% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc.R
\name{mc_cv}
\alias{mc_cv}
\title{Monte Carlo Cross-Validation}
\usage{
mc_cv(data, prop = 3/4, times = 25, strata = NULL, breaks = 4, ...)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{times}{The number of times to repeat the sampling.}

\item{strata}{A variable that is used to conduct stratified sampling to
create the resamples. This could be a single character value or a variable
name that corresponds to a variable that exists in the data frame.}

\item{breaks}{A single number giving the number of bins desired to stratify
a numeric stratification variable.}

\item{...}{Not currently used.}
}
\value{
An tibble with classes \code{mc_cv}, \code{rset}, \code{tbl_df}, \code{tbl}, and
\code{data.frame}. The results include a column for the data split objects and a
column called \code{id} that has a character string with the resample identifier.
}
\description{
One resample of Monte Carlo cross-validation takes a random sample (without
replacement) of the original data set to be used for analysis. All other
data points are added to the assessment set.
}
\details{
The \code{strata} argument causes the random sampling to be conducted
\emph{within the stratification variable}. This can help ensure that the number of
data points in the analysis data is equivalent to the proportions in the
original data set. (Strata below 10\% of the total are pooled together.)
}
\examples{
mc_cv(mtcars, times = 2)
mc_cv(mtcars, prop = .5, times = 2)

library(purrr)
data(wa_churn, package = "modeldata")

set.seed(13)
resample1 <- mc_cv(wa_churn, times = 3, prop = .5)
map_dbl(resample1$splits,
        function(x) {
          dat <- as.data.frame(x)$churn
          mean(dat == "Yes")
        })

set.seed(13)
resample2 <- mc_cv(wa_churn, strata = "churn", times = 3, prop = .5)
map_dbl(resample2$splits,
        function(x) {
          dat <- as.data.frame(x)$churn
          mean(dat == "Yes")
        })

set.seed(13)
resample3 <- mc_cv(wa_churn, strata = "tenure", breaks = 6, times = 3, prop = .5)
map_dbl(resample3$splits,
        function(x) {
          dat <- as.data.frame(x)$churn
          mean(dat == "Yes")
        })
}
