% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_polygon.R
\name{tween_polygon}
\alias{tween_polygon}
\title{Transition between polygon data.frames}
\usage{
tween_polygon(
  .data,
  to,
  ease,
  nframes,
  id = NULL,
  enter = NULL,
  exit = NULL,
  match = TRUE
)
}
\arguments{
\item{.data}{A data.frame to start from. If \code{.data} is the result of a prior
tween, only the last frame will be used for the tween. The new tween will
then be added to the prior tween}

\item{to}{A data.frame to end at. It must contain the same columns as .data
(exluding \code{.frame})}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{id}{The column to match observations on. If \code{NULL} observations will be
matched by position. See the \emph{Match, Enter, and Exit} section for more
information.}

\item{enter, exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{match}{Should polygons be matched by id? If \code{FALSE} then polygons will
be matched by shortest distance and if any state has more polygons than the
other, the other states polygons will be chopped up so the numbers match.}
}
\value{
A data.frame containing intermediary states
}
\description{
This function is equivalent to \code{\link[tweenr:tween_state]{tweenr::tween_state()}} except that data is
interpeted as encoding polygons. Data is expected to have an \code{x} and \code{y}
column encoding the location of corners in the polygon.
}
\section{Aligning polygons}{

\code{transformr} performs a lot of work to try to ensure the transition between
different shapes are as smooth and direct as possible. The first operation is
to ensure that the two end states of the polygon are both drawn clockwise, so
that the transition will not contain an inversion. Second, we need to make
sure that each end state is drawn with the same number of points. If not, the
less detailed polygon will get points inserted at the longest edges so that
the number is even between the two states. Third, we rotate the last state so
as to minimize the cumulative distance between all point pairs, thus ensuring
that the transition will involve a minimum of rotation.
}

\section{Cutting polygons}{

If the transition involves changing the number of polygons, there are two
strategies: Making polygons appear/disappear to even out the number, or
cutting up the polygons in the state with the fewest in order to create the
same number of polygons for the transition. In the latter case, a choice have
to be made with regards to which polygons to cut, into how many, and where to
cut it. \code{transformr} will distribute the number of cuts among candidate
polygons based on their relative area, ensuring that it is not necessarily
the largest polygon that gets all the cuts, but that divisions are
distributed as fairly as possible. For deciding on where to cut the polygons
they are triangulated and the triangles are then reassembled into the number
of pieces needed by always adding to the smallest piece.
}

\section{Polygon with holes}{

\code{transformr} support polygons with any number of holes. Holes are encoded by
adding an \code{NA} row to the main enclosing polygon and appending the hole after
that. Multiple holes are likewise added by simply separating them with \code{NA}
rows. A hole might get cut up and disappear during transition if the polygon
needs to be divided. When transitioning between polygons with holes the holes
are matched by position to minimize the travel distance. If there is a
mismatch between the number of holes in each end state then new zero-area
holes are inserted in the centroid of the polygon with the fewest to even out
the number.
}

\examples{
library(magrittr)
star <- poly_star_hole()
circle <- poly_circle()
circles <- poly_circles()

tween_polygon(circle, star, 'cubic-in-out', 20) \%>\%
  tween_polygon(circles, 'cubic-in-out', 20)

}
