// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Port.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.portsmodel {
  public class Port : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("portsmodel.Port:1.0.0", null);

    public Port(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Port(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Port StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Port(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public enum Events {
      EVT_KEY_PROPS_CHANGED,
      EVT_KEY_DEVICE_CHANGED,
    }

    public enum DetectionType {
      AUTO,
      PINNED,
    }

    public class DetectionMode : ICloneable {
      public object Clone() {
        DetectionMode copy = new DetectionMode();
        copy.type = this.type;
        copy.pinnedDeviceType = this.pinnedDeviceType;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = (int)this.type;
        json["pinnedDeviceType"] = this.pinnedDeviceType;
        return json;
      }

      public static DetectionMode Decode(LightJson.JsonObject json, Agent agent) {
        DetectionMode inst = new DetectionMode();
        inst.type = (Com.Raritan.Idl.portsmodel.Port.DetectionType)(int)json["type"];
        inst.pinnedDeviceType = (string)json["pinnedDeviceType"];
        return inst;
      }

      public Com.Raritan.Idl.portsmodel.Port.DetectionType type = Com.Raritan.Idl.portsmodel.Port.DetectionType.AUTO;
      public string pinnedDeviceType = "";
    }

    public class Properties : ICloneable {
      public object Clone() {
        Properties copy = new Properties();
        copy.name = this.name;
        copy.label = this.label;
        copy.mode = this.mode;
        copy.detectedDeviceType = this.detectedDeviceType;
        copy.detectedDeviceName = this.detectedDeviceName;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["label"] = this.label;
        json["mode"] = this.mode.Encode();
        json["detectedDeviceType"] = this.detectedDeviceType;
        json["detectedDeviceName"] = this.detectedDeviceName;
        return json;
      }

      public static Properties Decode(LightJson.JsonObject json, Agent agent) {
        Properties inst = new Properties();
        inst.name = (string)json["name"];
        inst.label = (string)json["label"];
        inst.mode = Com.Raritan.Idl.portsmodel.Port.DetectionMode.Decode(json["mode"], agent);
        inst.detectedDeviceType = (string)json["detectedDeviceType"];
        inst.detectedDeviceName = (string)json["detectedDeviceName"];
        return inst;
      }

      public string name = "";
      public string label = "";
      public Com.Raritan.Idl.portsmodel.Port.DetectionMode mode = new Com.Raritan.Idl.portsmodel.Port.DetectionMode();
      public string detectedDeviceType = "";
      public string detectedDeviceName = "";
    }

    public class GetPropertiesResult {
      public Com.Raritan.Idl.portsmodel.Port.Properties _ret_;
    }

    public GetPropertiesResult getProperties() {
      JsonObject _parameters = null;
      var _result = RpcCall("getProperties", _parameters);
      var _ret = new GetPropertiesResult();
      _ret._ret_ = Com.Raritan.Idl.portsmodel.Port.Properties.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getProperties(AsyncRpcResponse<GetPropertiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getProperties(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getProperties(AsyncRpcResponse<GetPropertiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getProperties", _parameters,
        _result => {
          try {
            var _ret = new GetPropertiesResult();
            _ret._ret_ = Com.Raritan.Idl.portsmodel.Port.Properties.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetNameResult {
    }

    public SetNameResult setName(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("setName", _parameters);
      var _ret = new SetNameResult();
      return _ret;
    }

    public AsyncRequest setName(string name, AsyncRpcResponse<SetNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setName(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setName(string name, AsyncRpcResponse<SetNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setName", _parameters,
        _result => {
          try {
            var _ret = new SetNameResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetDetectionModeResult {
      public int _ret_;
    }

    public SetDetectionModeResult setDetectionMode(Com.Raritan.Idl.portsmodel.Port.DetectionMode mode) {
      var _parameters = new LightJson.JsonObject();
      _parameters["mode"] = mode.Encode();

      var _result = RpcCall("setDetectionMode", _parameters);
      var _ret = new SetDetectionModeResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setDetectionMode(Com.Raritan.Idl.portsmodel.Port.DetectionMode mode, AsyncRpcResponse<SetDetectionModeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setDetectionMode(mode, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setDetectionMode(Com.Raritan.Idl.portsmodel.Port.DetectionMode mode, AsyncRpcResponse<SetDetectionModeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["mode"] = mode.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setDetectionMode", _parameters,
        _result => {
          try {
            var _ret = new SetDetectionModeResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDetectableDevicesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetDetectableDevicesResult getDetectableDevices() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDetectableDevices", _parameters);
      var _ret = new GetDetectableDevicesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getDetectableDevices(AsyncRpcResponse<GetDetectableDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDetectableDevices(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDetectableDevices(AsyncRpcResponse<GetDetectableDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDetectableDevices", _parameters,
        _result => {
          try {
            var _ret = new GetDetectableDevicesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDeviceResult {
      public ObjectProxy _ret_;
    }

    public GetDeviceResult getDevice() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDevice", _parameters);
      var _ret = new GetDeviceResult();
      _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDevice(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDevice", _parameters,
        _result => {
          try {
            var _ret = new GetDeviceResult();
            _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
