/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -i --loop-switch
#include <stdint.h>
#include <limits.h>
#include <assert.h>

static const uint64_t ERROR = ~0lu;

template<int BASE> static void adddgt(uint64_t &u, unsigned int d)
{
    u = u * BASE + d;
    if (u > UINT32_MAX) u = ERROR;
}

static uint64_t parse_u32(const char *s)
{
    const char *YYMARKER;
    uint64_t u = 0;

    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = *s;
				++s;
				switch (yych) {
					case '0':
						yystate = 2;
						continue;
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
						yystate = 4;
						continue;
					default:
						yystate = 1;
						continue;
				}
			case 1:
				{ return ERROR; }
			case 2:
				YYMARKER = s;
				yych = *s;
				switch (yych) {
					case 'B':
					case 'b':
						++s;
						yystate = 5;
						continue;
					case 'X':
					case 'x':
						++s;
						yystate = 7;
						continue;
					default:
						yystate = 3;
						continue;
				}
			case 3:
				{ goto oct; }
			case 4:
				s -= 1;
				{ goto dec; }
			case 5:
				yych = *s;
				switch (yych) {
					case '0':
					case '1':
						++s;
						yystate = 8;
						continue;
					default:
						yystate = 6;
						continue;
				}
			case 6:
				s = YYMARKER;
				yystate = 3;
				continue;
			case 7:
				yych = *s;
				switch (yych) {
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
					case 'A':
					case 'B':
					case 'C':
					case 'D':
					case 'E':
					case 'F':
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
						++s;
						yystate = 9;
						continue;
					default:
						yystate = 6;
						continue;
				}
			case 8:
				s -= 1;
				{ goto bin; }
			case 9:
				s -= 1;
				{ goto hex; }
		}
	}
}

bin:
    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = *s;
				++s;
				switch (yych) {
					case 0x00:
						yystate = 1;
						continue;
					case '0':
					case '1':
						yystate = 3;
						continue;
					default:
						yystate = 2;
						continue;
				}
			case 1:
				{ return u; }
			case 2:
				{ return ERROR; }
			case 3:
				{ adddgt<2>(u, s[-1] - '0'); goto bin; }
		}
	}
}

oct:
    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = *s;
				++s;
				switch (yych) {
					case 0x00:
						yystate = 1;
						continue;
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
						yystate = 3;
						continue;
					default:
						yystate = 2;
						continue;
				}
			case 1:
				{ return u; }
			case 2:
				{ return ERROR; }
			case 3:
				{ adddgt<8>(u, s[-1] - '0'); goto oct; }
		}
	}
}

dec:
    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = *s;
				++s;
				switch (yych) {
					case 0x00:
						yystate = 1;
						continue;
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
						yystate = 3;
						continue;
					default:
						yystate = 2;
						continue;
				}
			case 1:
				{ return u; }
			case 2:
				{ return ERROR; }
			case 3:
				{ adddgt<10>(u, s[-1] - '0'); goto dec; }
		}
	}
}

hex:
    
{
	char yych;
	unsigned int yystate = 0;
	for (;;) {
		switch (yystate) {
			case 0:
				yych = *s;
				++s;
				switch (yych) {
					case 0x00:
						yystate = 1;
						continue;
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
						yystate = 3;
						continue;
					case 'A':
					case 'B':
					case 'C':
					case 'D':
					case 'E':
					case 'F':
						yystate = 4;
						continue;
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
						yystate = 5;
						continue;
					default:
						yystate = 2;
						continue;
				}
			case 1:
				{ return u; }
			case 2:
				{ return ERROR; }
			case 3:
				{ adddgt<16>(u, s[-1] - '0');      goto hex; }
			case 4:
				{ adddgt<16>(u, s[-1] - 'A' + 10); goto hex; }
			case 5:
				{ adddgt<16>(u, s[-1] - 'a' + 10); goto hex; }
		}
	}
}

}

int main()
{
    assert(parse_u32("1234567890") == 1234567890);
    assert(parse_u32("0b1101") == 13);
    assert(parse_u32("0x7Fe") == 2046);
    assert(parse_u32("0644") == 420);
    assert(parse_u32("9999999999") == ERROR);
    assert(parse_u32("") == ERROR);
    return 0;
}
