/*
 * c-examples/any/example.c - an example of how to call C ASN.1-BER
 *             encoders and decoders generated by snacc
 *
 * AUTHOR: Mike Sample
 * DATE:   Mar 92
 *
 * $Header: /usr/app/odstb/CVS/snacc/c-examples/any/example.c,v 1.6 1997/02/16 20:26:15 rj Exp $
 * $Log: example.c,v $
 * Revision 1.6  1997/02/16 20:26:15  rj
 * check-in of a few cosmetic changes
 *
 * Revision 1.5  1995/07/24  20:40:19  rj
 * any-test.[hc] becomes any.[hc] due to to snacc's new file name generation scheme.
 *
 * changed `_' to `-' in file names.
 *
 * Revision 1.4  1995/02/18  15:17:35  rj
 * cosmetic changes
 *
 * Revision 1.3  1994/08/31  23:45:45  rj
 * more portable .h file inclusion.
 *
 * Revision 1.2  1994/08/31  08:59:31  rj
 * first check-in. for a list of changes to the snacc-1.1 distribution please refer to the ChangeLog.
 *
 */

#include "asn-incl.h"

#include <sys/types.h>
#include <sys/stat.h>
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <stdio.h>

#include "any.h"



main PARAMS ((argc, argv),
    int argc _AND_
    char *argv[])
{
    int fd;
    SBuf  buf;
    SBuf  encBuf;
    char *encData;
    AsnLen encodedLen;
    AsnLen decodedLen;
    int     val;
    AnyTestType att;
    int      size;
    char    *origData;
    struct stat sbuf;
    jmp_buf env;

    if (argc != 2)
    {
        fprintf (stderr, "Usage: %s <BER data file name>\n", argv[0]);
        fprintf (stderr, "   Decodes the given PersonnelRecord BER data file\n");
        fprintf (stderr, "   and re-encodes it to stdout\n");
        exit (1);
    }

    fd = open (argv[1], O_RDONLY, 0);
    if (fd < 0)
    {
        perror ("main: fopen");
        exit (1);
    }

    if (fstat (fd, &sbuf) < 0)
    {
        perror ("main: fstat");
        exit (1);
    }

    size = sbuf.st_size;
    origData = (char*)malloc (size);
    if (read (fd, origData, size) != size)
    {
        perror ("main: read");
        exit (1);
    }

    close (fd);

    /*
     * puts the given data 'origData' of 'size' bytes
     * into an SBuf and sets the SBuf up for reading
     * origData from the beginning
     */
    SBufInstallData (&buf, origData, size);

    /*
     * the first argument (512) is the number of bytes to
     * initially allocate for the decoder to allocate from.
     * The second argument (512) is the size in bytes to
     * enlarge the nibble memory by when it fills up
     */
    InitNibbleMem (512, 512);


    /*
     * initialize the hash table for the
     * the ANY type mappings.
     * This only needs to be done once per execution
     * (before any encoding or decoding is done)
     */
    InitAnyANY_TEST();

    decodedLen = 0;
    if ((val = setjmp (env)) == 0)
    {
        BDecAnyTestType (&buf, &att, &decodedLen, env);
    }
    else
    {
        fprintf (stderr, "ERROR - Decode routines returned %d\n",val);
        exit (1);
    }

    fprintf (stderr, "decodedValue AnyTestType ::= ");
    PrintAnyTestType (stderr, &att, 0);
    fprintf (stderr, "\n\n");

    /*
     * setup a new buffer set up for writing.
     * make sure size is big enough to hold the encoded
     * value (may be larger than decoded value if encoding
     * with indef lengths - so add 512 slush bytes)
     */
    encData = (char*) malloc (size + 512);
    SBufInit (&encBuf, encData, size + 512);
    SBufResetInWriteRvsMode (&encBuf);

    encodedLen =  BEncAnyTestType (&encBuf, &att);
    if ((encodedLen <= 0) || SBufWriteError (&encBuf))
    {
        fprintf (stderr, "ERROR - buffer to hold the encoded value was too small\n");
        exit (1);
    }

    /*
     * free all of the decoded value since
     * it has been encoded into the buffer.
     * This is much more efficient than freeing
     * each compontent of the value individually
     */
    ResetNibbleMem();

    /*
     * write encoded value from encBuf
     * to stdout
     */
    fwrite (SBufDataPtr (&encBuf), SBufDataLen (&encBuf), 1, stdout);

    return 0;
}
