/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.ButtonAction;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PrimitiveCircleObject;

public class CircleEditDialog
extends ObjectEditDialog {
    TextField Length;
    TextField BoundA;
    TextField BoundB;
    Checkbox Fixed;
    Checkbox Arc;
    IconBar IC;
    ZirkelCanvas ZC;
    Button RangeButton;
    Button KillRangeButton;
    Button SetButton;
    static Color[] Colors = ZirkelFrame.Colors;
    static String[] ColorStrings = ZirkelFrame.ColorStrings;

    public CircleEditDialog(Frame frame, PrimitiveCircleObject primitiveCircleObject, ZirkelCanvas zirkelCanvas) {
        super(frame, Zirkel.name("edit.circle.title"), primitiveCircleObject, "circle");
        this.ZC = zirkelCanvas;
    }

    public void addFirst(Panel panel) {
        PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)this.O;
        if (primitiveCircleObject instanceof CircleObject) {
            if (((CircleObject)primitiveCircleObject).canFix()) {
                this.Fixed = new Checkbox("");
                this.Fixed.setState(((CircleObject)primitiveCircleObject).fixed());
            }
            this.Length = new TextFieldAction(this, "Length", ((CircleObject)this.O).getStringLength(), 30);
        } else if (primitiveCircleObject instanceof FixedCircleObject) {
            this.Fixed = new Checkbox("");
            this.Fixed.setState(!((FixedCircleObject)primitiveCircleObject).isDragable());
            this.Length = new TextFieldAction(this, "Length", ((FixedCircleObject)this.O).getStringLength(), 30);
        } else {
            this.Length = new MyTextField("" + primitiveCircleObject.round(primitiveCircleObject.getR()));
        }
        panel.add(new MyLabel(Zirkel.name("edit.circle.length")));
        panel.add(this.Length);
        if (this.Fixed != null) {
            panel.add(new MyLabel(Zirkel.name("edit.fixed")));
            panel.add(this.Fixed);
        } else {
            this.Length.setEditable(false);
        }
        panel.add(new MyLabel(Zirkel.name("edit.circle.bounds")));
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(1, 3));
        this.Arc = new Checkbox("");
        this.Arc.setState(primitiveCircleObject.hasRange());
        myPanel.add(this.Arc);
        this.BoundA = new MyTextField(primitiveCircleObject.getStartString(), 5);
        this.BoundB = new MyTextField(primitiveCircleObject.getEndString(), 5);
        myPanel.add(this.BoundA);
        myPanel.add(this.BoundB);
        panel.add(myPanel);
    }

    public void addButton(Panel panel) {
        this.RangeButton = new ButtonAction(this, Zirkel.name("edit.circle.range"), "Range");
        panel.add(this.RangeButton);
        if (this.O instanceof FixedCircleObject) {
            this.SetButton = new ButtonAction(this, Zirkel.name("edit.fixedcircle.set"), "Set");
            panel.add(this.SetButton);
        }
    }

    public void addSecond(Panel panel) {
        PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)this.O;
        this.IC = new IconBar(this.F);
        this.IC.setIconBarListener(this);
        this.IC.addOnOffLeft("partial");
        this.IC.setState("partial", primitiveCircleObject.isPartial());
        this.IC.addOnOffLeft("filled");
        this.IC.setState("filled", primitiveCircleObject.isFilled());
        this.IC.addOnOffLeft("obtuse");
        this.IC.setState("obtuse", primitiveCircleObject.getObtuse());
        this.IC.addOnOffLeft("chord");
        this.IC.setState("chord", !primitiveCircleObject.getArc());
        this.IC.setIconBarListener(this);
        panel.add(new MyLabel(""));
        panel.add(this.IC);
    }

    public void iconPressed(String string) {
        if (string.equals("filled")) {
            if (this.IC.getState("filled")) {
                this.IB.setState("isback", true);
                this.ThicknessIB.setEnabled("solid", true);
            } else {
                this.IB.setState("isback", false);
                this.ThicknessIB.setState("solid", false);
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        super.iconPressed(string);
    }

    public void doAction(String string) {
        if (string.equals("Length") && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else if (string.equals("Range")) {
            this.ZC.range((PrimitiveCircleObject)this.O);
            super.doAction("OK");
        } else if (string.equals("KillRange")) {
            ((PrimitiveCircleObject)this.O).clearRange();
            super.doAction("OK");
        } else if (string.equals("Set") && this.O instanceof FixedCircleObject) {
            this.ZC.set((FixedCircleObject)this.O);
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void setAction() {
        if (this.O instanceof CircleObject) {
            try {
                ((CircleObject)this.O).setFixed(this.Fixed.getState(), this.Length.getText());
            }
            catch (Exception exception) {}
        } else if (this.O instanceof FixedCircleObject) {
            ((FixedCircleObject)this.O).setDragable(!this.Fixed.getState());
            try {
                ((FixedCircleObject)this.O).setFixed(this.Length.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((PrimitiveCircleObject)this.O).setPartial(this.IC.getState("partial"));
        ((PrimitiveCircleObject)this.O).setFilled(this.IC.getState("filled"));
        ((PrimitiveCircleObject)this.O).setArc(!this.IC.getState("chord"));
        this.O.setObtuse(this.IC.getState("obtuse"));
        if (!this.Arc.getState()) {
            ((PrimitiveCircleObject)this.O).clearRange();
        } else {
            ((PrimitiveCircleObject)this.O).setRange(this.BoundA.getText(), this.BoundB.getText());
        }
        Global.setParameter("unit.length", this.Unit.getText());
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.Length.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }
}

