/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     config.h
 * Abstract:        configuration file. Before any compilation please check
 *                  that actual configuration is consistent with your
 *                  hardware AND your compiler.
 */

/* module definition: 1 indicates that a module should be included in the
 * base vocabulary, 0 excludes a module. Note however that some words in
 * excluded word lists may be linked to final code if used by other words.
 */

#include <endian.h>

#define COREE_DEF           1L
#define DOUBLE_DEF          1L
#define DOUBLEE_DEF         1L
#define FLOAT_DEF           1L
#define FLOATE_DEF          1L
#define MEMALL_DEF          1L
#define MEMALLE_DEF         0L
#define SEARCH_DEF          1L
#define SEARCHE_DEF         1L
#define TOOLS_DEF           1L
#define TOOLSE_DEF          1L
#define LOCALS_DEF          1L
#define LOCALSE_DEF         1L
#define FACILITY_DEF        1L
#define FACILITYE_DEF       0L
#define BLOCK_DEF           1L
#define BLOCKE_DEF          1L
#define EXCEPTION_DEF       1L
#define EXCEPTIONE_DEF      0L
#define FILE_DEF            1L
#define FILEE_DEF           1L
#define STRING_DEF          1L
#define STRINGE_DEF         0L

#define VERSION_PATTERN     (COREE_DEF | (DOUBLE_DEF << 1) |\
							 (DOUBLEE_DEF << 2) | (FLOAT_DEF << 3) |\
                             (FLOATE_DEF << 4) | (MEMALL_DEF << 5) |\
                             (MEMALLE_DEF << 6) | (SEARCH_DEF << 7) |\
                             (SEARCHE_DEF << 8) | (TOOLS_DEF << 9) |\
                             (TOOLSE_DEF << 10) | (LOCALS_DEF << 11) |\
                             (LOCALSE_DEF << 12) | (FACILITY_DEF << 13) |\
                             (FACILITYE_DEF << 14) | (BLOCK_DEF << 15) |\
                             (BLOCKE_DEF << 16) | (EXCEPTION_DEF << 17) |\
                             (EXCEPTIONE_DEF << 18) | (FILE_DEF << 19) |\
                             (FILEE_DEF << 20) | (STRING_DEF << 21) |\
                             (STRINGE_DEF << 22)\
                            )

/************************************************************************/
/* compilation and machine dependent definitions                        */
/************************************************************************/

/* Define LITTLE_ENDIAN if you machine is little-endian (e.g. Intel), undefine
 * it if your machine is big-endian (e.g. Motorola, Sparc...)
 * Note that some compilers have LITTLE_ENDIAN yet defined.
 */
#ifndef LITTLE_ENDIAN
# if __BYTE_ORDER == __LITTLE_ENDIAN
#	define LITTLE_ENDIAN
# else
#	undef  LITTLE_ENDIAN
# endif
#endif

/* When DCELL_MEM is defined, double cell transfer is realized by memory
 * copy, if not defined shift and logical operators are used to combine
 * or isolate cell values
 */
#define DCELL_MEM
 
/* DATA TYPES: please modify this list accordingly to your system. Note that
 * sizeof(DCell) == 2 * sizeof(Cell) MUST BE satisfied.
 * For example, using Borland C for DOS Cell may be "int" and DCell "long int".
 * Under Linux, Cell may be "int" and DCell "long long".
 */

/* this might work for other 64 bit architectures, too? */
#if defined(__alpha__)
# define Cell                           long
#else
# define Cell                           int
#endif /* __alpha__ */

#define Char				char
#define Real				float

#define UCell				unsigned Cell
#define DCell               long long
#define UDCell				unsigned DCell
#define UChar				unsigned Char

#define CellBits            (sizeof(Cell) * 8)
#define CellLog             (sizeof(Cell) - 1)
#define RealLog				(sizeof(Real) - 1)

#define FFLAG(n)            (-(n))

/* Please modify this definitions accordingly with your data types */

#define MAX_CHAR			UCHAR_MAX
#define MAX_D				LONG_MAX
#define MAX_N				INT_MAX
#define MAX_U				UINT_MAX
#define MAX_UD				ULONG_MAX
#define MAX_F				0.0

/* Some compilers doesn't provide some functions in the standard library.
 * If you don't have, turn 1s into 0s 
 */
#define HAVE_ACOSH			1
#define HAVE_ASINH			1
#define HAVE_ATANH			1

/* Set following define to 1 if you're compiling under Turbo C, Borland C,
 * or GCC for DOS.
 */
#define HAVE_CONIO			0
