// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_ESSL_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {3297, 2629, 2651, 2337, 2303, 3220, 3385, 1210, 2130, 1919,
                              3300, 2529, 2310, 3215, 1751, 2155, 96,   2644, 3105, 1639,
                              1010, 851,  1501, 558,  2641, 328,  1973, 296,  1999, 2273,
                              441,  2860, 911,  1153, 2602, 1727, 2732, 521,  1672, 1330};
constexpr int mangledkT2[] = {1661, 42,   548,  942,  2329, 3201, 841,  3274, 1976, 3379,
                              1752, 1024, 961,  2388, 3033, 1547, 591,  2585, 1383, 473,
                              319,  3081, 1789, 734,  478,  219,  1353, 381,  1660, 408,
                              1440, 2281, 2126, 1243, 1080, 2835, 3286, 168,  458,  1343};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1017, 0,    0,    2710, 0,    0,    0,
    0,    0,    2928, 579,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    2927, 632,  0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    1534, 0,    0,    0,    1494, 0,    0,    0,    0,    0,    0,    0,
    0,    0,    3387, 0,    0,    0,    0,    575,  0,    1229, 0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    2918, 0,    0,    0,    0,    0,    0,    480,  0,    0,    0,
    1595, 0,    0,    0,    3263, 0,    3229, 373,  0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    3124, 0,    0,    899,  0,    0,
    0,    459,  0,    0,    0,    0,    0,    0,    2582, 1334, 0,    172,  126,  0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    2180, 0,    841,  0,    0,    0,    2145, 0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    953,  0,    810,  0,    0,    0,    678,  0,    0,    0,    0,    0,    0,
    0,    0,    0,    1861, 2280, 0,    2634, 0,    0,    2476, 0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    2784, 0,    0,    0,    3384, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    2760, 0,    0,    0,    1572, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    904,
    0,    0,    0,    3352, 0,    0,    0,    0,    1371, 2613, 0,    0,    3227, 0,    0,    0,
    1772, 0,    601,  0,    944,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1928,
    0,    0,    0,    0,    0,    0,    0,    0,    2235, 0,    0,    0,    3179, 0,    0,    619,
    0,    0,    3251, 0,    0,    0,    0,    0,    0,    203,  0,    0,    0,    0,    0,    1825,
    0,    0,    0,    0,    3176, 2489, 0,    0,    70,   0,    519,  0,    505,  1677, 0,    0,
    0,    0,    0,    1872, 0,    0,    2289, 0,    0,    0,    1160, 0,    2362, 776,  2964, 0,
    0,    0,    2477, 0,    1303, 0,    95,   0,    0,    3408, 0,    0,    0,    2894, 250,  0,
    0,    0,    0,    0,    0,    0,    0,    2894, 0,    3389, 930,  2489, 0,    2755, 0,    1807,
    701,  2938, 0,    0,    0,    0,    609,  0,    0,    0,    1985, 343,  0,    2608, 0,    366,
    1367, 1387, 0,    0,    3159, 0,    0,    0,    2036, 0,    0,    2232, 0,    0,    2248, 2652,
    0,    307,  0,    0,    3307, 0,    0,    0,    525,  0,    0,    1300, 0,    0,    1432, 2594,
    2612, 53,   1093, 0,    1779, 3020, 3237, 457,  48,   0,    0,    525,  1380, 0,    0,    0,
    442,  1063, 3293, 0,    0,    0,    0,    0,    0,    832,  2958, 1451, 0,    0,    348,  0,
    1871, 0,    0,    2548, 1826, 441,  2846, 0,    2601, 1910, 1415, 0,    0,    0,    420,  0,
    3072, 620,  0,    0,    1333, 1133, 0,    0,    1402, 0,    0,    0,    0,    290,  0,    0,
    0,    0,    0,    1598, 363,  0,    1161, 0,    0,    0,    0,    218,  0,    2571, 226,  0,
    526,  270,  2557, 2815, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1796, 0,
    0,    173,  610,  2958, 0,    0,    0,    0,    0,    300,  0,    0,    0,    0,    0,    0,
    0,    0,    1955, 0,    0,    0,    0,    414,  0,    0,    0,    0,    0,    0,    0,    265,
    0,    0,    0,    0,    230,  0,    502,  0,    1243, 0,    0,    2474, 0,    0,    0,    0,
    23,   0,    669,  0,    3124, 0,    3209, 0,    0,    929,  403,  0,    39,   118,  443,  852,
    0,    767,  0,    0,    0,    0,    3067, 0,    0,    0,    1532, 0,    0,    0,    3202, 0,
    0,    0,    0,    0,    2801, 0,    2253, 0,    0,    3,    0,    0,    0,    0,    0,    3240,
    1618, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    665,  0,    0,    1803, 0,
    2475, 0,    0,    0,    499,  0,    1386, 3147, 0,    0,    1168, 0,    0,    0,    1823, 0,
    0,    77,   935,  136,  0,    0,    882,  0,    0,    421,  257,  381,  0,    0,    643,  0,
    0,    284,  0,    2581, 0,    0,    0,    0,    0,    0,    964,  0,    0,    0,    3217, 681,
    479,  0,    529,  0,    0,    0,    0,    0,    2901, 0,    1026, 0,    1190, 0,    0,    0,
    0,    0,    0,    3266, 0,    0,    2286, 0,    0,    0,    0,    594,  0,    0,    0,    0,
    0,    114,  0,    608,  0,    2750, 0,    3179, 0,    161,  0,    0,    0,    556,  3088, 2489,
    1877, 0,    0,    0,    0,    2552, 0,    0,    0,    0,    0,    1637, 0,    746,  0,    0,
    338,  0,    1429, 0,    0,    1407, 0,    1134, 0,    0,    0,    0,    0,    0,    0,    0,
    113,  227,  0,    433,  926,  0,    0,    0,    1524, 1343, 38,   0,    2017, 1986, 3079, 0,
    3409, 0,    0,    0,    0,    2612, 1298, 137,  0,    0,    2021, 486,  0,    0,    1626, 0,
    0,    209,  0,    2406, 563,  97,   0,    578,  0,    0,    1064, 0,    1393, 61,   1962, 1624,
    534,  133,  994,  0,    0,    3180, 0,    0,    0,    0,    0,    0,    0,    1648, 0,    0,
    0,    0,    0,    0,    0,    2629, 0,    0,    955,  3301, 0,    414,  395,  0,    467,  681,
    0,    0,    0,    3070, 747,  1612, 0,    2987, 429,  0,    0,    438,  0,    627,  2229, 0,
    0,    0,    0,    0,    0,    2485, 35,   0,    307,  450,  0,    0,    0,    0,    0,    3382,
    2994, 3119, 0,    992,  1257, 782,  1249, 0,    915,  981,  837,  3177, 0,    0,    0,    0,
    747,  0,    0,    66,   3213, 0,    0,    3142, 0,    311,  744,  767,  0,    0,    0,    0,
    0,    0,    1164, 0,    1138, 757,  67,   1332, 724,  2680, 0,    0,    0,    275,  1321, 0,
    0,    750,  1072, 0,    660,  1228, 546,  0,    544,  0,    0,    0,    0,    1429, 356,  0,
    1200, 0,    0,    914,  1270, 0,    149,  473,  936,  336,  2834, 0,    0,    0,    0,    0,
    93,   0,    0,    0,    586,  0,    2776, 0,    1485, 0,    3193, 1133, 0,    0,    1386, 0,
    0,    0,    435,  87,   0,    0,    680,  1588, 320,  0,    0,    0,    2574, 0,    0,    0,
    0,    1079, 156,  0,    0,    582,  0,    792,  3388, 2760, 2509, 2915, 0,    0,    1326, 925,
    2684, 0,    0,    3305, 0,    468,  0,    1874, 120,  0,    0,    0,    0,    567,  549,  0,
    1238, 0,    0,    0,    2254, 0,    0,    1746, 348,  0,    0,    0,    2774, 0,    0,    0,
    0,    572,  0,    0,    1787, 251,  0,    767,  0,    3365, 0,    586,  1353, 0,    1039, 0,
    0,    626,  0,    0,    34,   2733, 0,    888,  523,  0,    518,  0,    2166, 0,    1502, 2652,
    0,    1278, 2808, 0,    1369, 1428, 0,    0,    0,    710,  0,    159,  1118, 0,    0,    0,
    248,  996,  2274, 0,    537,  2856, 0,    0,    0,    0,    0,    0,    2313, 769,  0,    0,
    0,    1145, 0,    0,    0,    0,    0,    0,    0,    0,    1582, 1138, 0,    0,    0,    967,
    1195, 0,    273,  1590, 460,  0,    0,    1620, 0,    0,    0,    1331, 0,    661,  0,    0,
    340,  0,    1582, 807,  0,    0,    1082, 0,    0,    0,    0,    0,    0,    0,    293,  0,
    1065, 1277, 0,    0,    949,  916,  36,   867,  0,    1335, 1355, 0,    997,  1272, 0,    0,
    0,    1507, 0,    0,    1631, 896,  0,    3338, 0,    1280, 1145, 278,  0,    1361, 2065, 1030,
    0,    436,  0,    0,    384,  2984, 0,    3409, 0,    0,    909,  0,    0,    0,    149,  539,
    2604, 0,    463,  1583, 556,  1662, 0,    446,  0,    0,    0,    1075, 0,    2395, 0,    82,
    258,  0,    580,  0,    0,    549,  1509, 0,    1160, 0,    109,  195,  0,    136,  0,    704,
    0,    0,    3108, 0,    0,    0,    1623, 0,    359,  986,  3340, 1596, 1316, 47,   718,  479,
    560,  0,    33,   0,    878,  0,    0,    3021, 0,    616,  342,  0,    882,  776,  3251, 0,
    32,   513,  273,  232,  746,  1184, 0,    3289, 364,  0,    0,    3102, 0,    3194, 481,  0,
    842,  0,    3113, 647,  0,    0,    0,    2239, 0,    720,  0,    1192, 0,    980,  0,    0,
    0,    0,    661,  1493, 3370, 3348, 31,   1970, 0,    1251, 1513, 0,    0,    2199, 673,  562,
    33,   186,  1457, 0,    786,  0,    1036, 0,    0,    1998, 0,    0,    0,    1906, 0,    1148,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    1047, 982,  0,    1363, 0,    0,    2893,
    0,    0,    0,    1442, 0,    0,    2735, 1044, 0,    0,    1197, 0,    434,  0,    420,  1009,
    3105, 0,    2979, 823,  0,    0,    0,    99,   2815, 1534, 2319, 993,  2897, 0,    0,    2192,
    961,  0,    0,    1551, 0,    0,    0,    0,    0,    0,    0,    0,    565,  2807, 0,    1869,
    667,  0,    0,    0,    0,    1017, 139,  0,    0,    0,    152,  0,    3155, 0,    769,  2995,
    1247, 1113, 0,    0,    3203, 0,    1183, 0,    1469, 0,    1194, 375,  88,   0,    0,    0,
    0,    0,    0,    1037, 0,    3372, 180,  1947, 0,    0,    0,    2759, 2065, 0,    0,    0,
    3345, 563,  0,    2729, 0,    2979, 0,    5,    0,    2986, 155,  0,    393,  1883, 1845, 0,
    0,    2673, 0,    453,  947,  123,  1252, 0,    550,  1599, 231,  151,  1215, 0,    233,  3394,
    3370, 455,  0,    1619, 0,    0,    2860, 0,    1569, 0,    2095, 0,    1392, 0,    0,    373,
    0,    388,  0,    0,    2856, 2919, 2415, 0,    0,    0,    0,    0,    0,    933,  2108, 0,
    1536, 667,  675,  495,  0,    1705, 0,    0,    656,  0,    0,    63,   1484, 0,    0,    1033,
    0,    914,  3397, 0,    2928, 192,  597,  2666, 0,    1035, 0,    0,    0,    0,    1726, 1720,
    3406, 0,    0,    1644, 0,    0,    555,  0,    58,   1168, 0,    430,  236,  998,  935,  0,
    0,    659,  402,  3242, 0,    1010, 0,    2241, 0,    1140, 2556, 0,    1002, 748,  539,  212,
    0,    1602, 264,  0,    0,    0,    1286, 669,  334,  2327, 0,    0,    911,  0,    157,  714,
    0,    0,    0,    0,    180,  0,    0,    0,    359,  0,    3041, 0,    0,    808,  982,  732,
    1539, 0,    324,  0,    0,    0,    0,    3325, 698,  0,    1799, 0,    2942, 2667, 0,    519,
    2898, 1068, 0,    0,    0,    1460, 3022, 0,    0,    0,    2842, 927,  3153, 0,    0,    1521,
    1361, 0,    0,    588,  0,    36,   2910, 0,    0,    0,    2621, 0,    2711, 315,  2628, 0,
    286,  718,  0,    267,  775,  77,   0,    0,    0,    0,    0,    0,    0,    3228, 0,    1925,
    0,    0,    0,    0,    1454, 1384, 2952, 0,    0,    156,  0,    0,    0,    271,  0,    0,
    289,  179,  2421, 2348, 0,    766,  0,    1462, 2516, 930,  768,  0,    0,    0,    0,    0,
    0,    0,    331,  1378, 0,    1162, 0,    0,    3313, 0,    3367, 0,    0,    0,    0,    0,
    1147, 0,    1866, 0,    0,    1648, 0,    0,    0,    858,  964,  0,    1975, 0,    0,    0,
    0,    1031, 0,    0,    2901, 3008, 0,    0,    2440, 1174, 910,  1006, 3125, 0,    2722, 825,
    0,    2250, 1465, 0,    0,    0,    1104, 476,  1673, 0,    1429, 130,  1184, 1911, 183,  650,
    487,  0,    0,    676,  0,    1528, 0,    0,    426,  2746, 731,  0,    0,    1226, 0,    0,
    661,  2458, 0,    2203, 0,    0,    998,  0,    3016, 223,  0,    2758, 1006, 0,    0,    3356,
    1197, 0,    0,    1164, 940,  1424, 365,  1120, 0,    0,    0,    0,    838,  0,    2166, 0,
    1592, 2396, 859,  1542, 0,    0,    0,    406,  0,    1468, 1315, 3385, 186,  672,  3019, 854,
    301,  2252, 1430, 1225, 845,  1067, 128,  0,    0,    1144, 0,    209,  0,    400,  0,    1051,
    0,    492,  0,    0,    0,    0,    283,  0,    161,  0,    2649, 1013, 0,    3075, 0,    62,
    2969, 1449, 0,    641,  2726, 0,    1911, 1169, 1553, 1466, 120,  0,    0,    812,  0,    188,
    0,    0,    1278, 3176, 0,    0,    0,    0,    2742, 0,    0,    1772, 0,    874,  680,  0,
    1378, 2734, 53,   0,    0,    329,  2,    1014, 2786, 717,  1868, 0,    2296, 0,    357,  0,
    0,    0,    0,    2371, 1203, 1109, 1302, 3047, 2319, 0,    2834, 1711, 0,    849,  1658, 131,
    0,    1191, 268,  1519, 0,    1080, 0,    0,    488,  0,    46,   0,    658,  0,    0,    1838,
    0,    0,    0,    0,    1741, 2096, 1702, 0,    0,    691,  3262, 950,  0,    0,    0,    705,
    734,  2177, 3260, 0,    0,    897,  291,  1318, 866,  3106, 3161, 1205, 0,    0,    0,    0,
    0,    0,    0,    835,  0,    0,    0,    0,    0,    0,    1283, 0,    0,    772,  0,    1482,
    1609, 1279, 1121, 870,  0,    3184, 818,  1521, 0,    0,    297,  0,    0,    1360, 0,    0,
    249,  0,    2112, 72,   0,    1110, 2278, 619,  0,    1014, 809,  397,  0,    0,    1405, 0,
    905,  0,    690,  751,  0,    0,    0,    19,   3355, 0,    0,    0,    0,    1345, 114,  945,
    0,    123,  173,  0,    133,  0,    971,  0,    453,  1183, 0,    0,    2727, 632,  678,  1572,
    0,    1304, 1433, 926,  0,    0,    302,  941,  0,    0,    0,    0,    0,    1222, 0,    0,
    0,    0,    1771, 0,    884,  872,  0,    0,    1234, 1928, 3190, 0,    0,    0,    0,    0,
    238,  615,  522,  287,  654,  798,  0,    1264, 0,    0,    0,    0,    466,  395,  1175, 1406,
    633,  1146, 3235, 3347, 62,   237,  0,    0,    0,    0,    0,    10,   1461, 0,    0,    1914,
    447,  0,    3148, 1253, 1970, 0,    1404, 744,  3377, 1362, 3085, 0,    3083, 1529, 0,    0,
    1441, 0,    1476, 0,    955,  156,  0,    0,    1752, 1212, 0,    45,   1193, 1605, 0,    0,
    0,    0,    209,  180,  447,  1584, 23,   1520, 2177, 0,    74,   0,    3334, 2718, 0,    728,
    0,    1000, 0,    1366, 978,  0,    0,    1488, 3222, 122,  388,  1641, 946,  0,    0,    0,
    0,    0,    741,  0,    0,    0,    0,    1875, 1116, 880,  0,    343,  1376, 0,    1699, 0,
    2350, 605,  132,  0,    0,    1429, 0,    0,    528,  564,  0,    1571, 1265, 0,    0,    625,
    3052, 1040, 1470, 266,  603,  3325, 0,    679,  0,    1901, 265,  2717, 1591, 671,  3355, 0,
    0,    321,  0,    3220, 990,  0,    408,  0,    716,  0,    0,    0,    822,  99,   754,  780,
    3335, 365,  0,    1682, 2332, 0,    3209, 0,    0,    774,  589,  0,    0,    841,  138,  679,
    320,  0,    0,    2355, 491,  3001, 0,    3280, 0,    0,    1743, 0,    0,    0,    2191, 0,
    1176, 0,    0,    0,    0,    0,    1143, 0,    0,    0,    580,  0,    0,    0,    0,    0,
    0,    620,  0,    1207, 0,    1603, 494,  433,  0,    847,  44,   2266, 2101, 2457, 0,    0,
    0,    389,  1428, 2257, 3104, 456,  0,    0,    0,    0,    0,    0,    1468, 966,  979,  1877,
    1217, 3122, 2407, 0,    3022, 0,    0,    910,  465,  0,    2931, 2770, 173,  209,  1004, 0,
    160,  0,    1404, 0,    965,  0,    0,    1455, 1314, 2643, 0,    713,  1544, 0,    0,    0,
    544,  0,    476,  847,  1029, 983,  231,  285,  2181, 0,    0,    513,  739,  336,  0,    1206,
    0,    3020, 493,  0,    0,    596,  0,    0,    1282, 0,    121,  0,    0,    667,  873,  0,
    0,    1015, 196,  0,    1390, 469,  563,  1091, 349,  0,    2300, 0,    0,    104,  0,    23,
    1617, 0,    1649, 0,    0,    499,  558,  0,    0,    0,    0,    0,    1089, 0,    2932, 472,
    700,  2599, 0,    3,    3365, 556,  1347, 1138, 380,  2427, 0,    1084, 0,    0,    0,    701,
    0,    0,    2747, 0,    0,    1481, 0,    2017, 1487, 0,    0,    0,    0,    0,    2867, 610,
    0,    1453, 1383, 0,    0,    489,  0,    663,  3399, 0,    0,    2629, 1525, 2947, 0,    1472,
    0,    0,    745,  14,   0,    2983, 639,  0,    741,  389,  0,    0,    795,  0,    527,  0,
    0,    0,    404,  768,  2738, 1877, 0,    901,  82,   0,    0,    967,  0,    574,  103,  0,
    0,    497,  2837, 0,    0,    0,    338,  1070, 0,    0,    1127, 0,    1029, 1166, 0,    0,
    0,    0,    1111, 0,    1238, 2206, 222,  0,    632,  0,    3368, 923,  435,  0,    704,  57,
    536,  1427, 0,    0,    1232, 101,  0,    0,    255,  1427, 828,  0,    160,  613,  2985, 0,
    1010, 0,    0,    0,    2916, 2185, 1519, 2988, 2817, 3387, 3090, 1538, 43,   0,    781,  0,
    0,    0,    0,    0,    804,  2815, 3090, 3021, 1095, 0,    0,    0,    0,    1285, 0,    0,
    244,  0,    713,  0,    899,  0,    0,    0,    142,  16,   0,    1655, 120,  22,   2957, 0,
    784,  2620, 666,  0,    263,  0,    2359, 1150, 0,    243,  0,    946,  988,  1510, 636,  1271,
    1038, 0,    2893, 0,    0,    938,  0,    0,    175,  0,    0,    0,    0,    0,    0,    277,
    0,    2911, 0,    0,    0,    0,    1516, 2054, 0,    3270, 0,    3089, 410,  0,    3202, 1216,
    0,    0,    0,    1076, 590,  141,  282,  0,    0,    193,  2844, 224,  2981, 0,    0,    555,
    0,    1054, 275,  0,    1144, 0,    504,  1046, 550,  0,    800,  187,  2264, 1137, 0,    298,
    2843, 3120, 3366, 0,    882,  1430, 2165, 2553, 0,    0,    2305, 0,    1945, 0,    2032, 606,
    3296, 3028, 274,  936,  3036, 1285, 642,  0,    116,  834,  0,    1485, 1322, 0,    1667, 0,
    697,  2746, 893,  1561, 1264, 101,  0,    0,    362,  1242, 142,  0,    225,  957,  1153, 117,
    0,    514,  0,    0,    1393, 365,  266,  833,  0,    1317, 0,    0,    2334, 0,    0,    0,
    0,    0,    0,    165,  1293, 526,  17,   0,    71,   0,    2986, 0,    808,  1195, 6,    1124,
    0,    0,    0,    0,    0,    274,  0,    0,    0,    0,    0,    0,    1511, 380,  0,    251,
    0,    2324, 772,  0,    195,  0,    393,  0,    2126, 258,  0,    21,   354,  0,    0,    198,
    0,    0,    514,  0,    0,    0,    0,    0,    0,    0,    0,    565,  1284, 0,    0,    735,
    2315, 1196, 831,  1278, 2601, 504,  0,    1174, 3177, 0,    1224, 1307, 574,  119,  1426, 1970,
    0,    198,  1029, 0,    860,  928,  0,    1114, 767,  2884, 0,    0,    492,  1549, 2358, 0,
    2879, 930,  581,  1368, 0,    1223, 0,    96,   0,    3313, 868,  0,    2962, 2697, 2823, 1086,
    3239, 448,  0,    0,    0,    1236, 0,    0,    1310, 886,  531,  0,    9,    0,    0,    293,
    0,    0,    2627, 3078, 3408, 1297, 883,  115,  0,    2906, 3009, 0,    1405, 1046, 1101, 0,
    1556, 1118, 1103, 0,    0,    2285, 434,  922,  0,    0,    941,  3194, 1070, 2741, 307,  668,
    2371, 3061, 945,  643,  0,    1503, 0,    561,  0,    618,  0,    1170, 3050, 3219, 0,    752,
    2992, 0,    0,    0,    0,    839,  1253, 348,  144,  0,    29,   1190, 441,  3202, 705,  2600,
    1516, 73,   472,  814,  3042, 361,  0,    3256, 0,    0,    0,    0,    0,    0,    1748, 1007,
    3384, 0,    0,    1412, 473,  0,    0,    1325, 0,    3170, 542,  0,    1066, 1126, 1215, 0,
    0,    624,  0,    1219, 0,    949,  0,    730,  1376, 2256, 733,  0,    1577, 0,    576,  1594,
    181,  0,    461,  3238, 1436, 0,    899,  2193, 0,    894,  698,  0,    777,  59,   845,  2941,
    0,    0,    1408, 0,    224,  0,    0,    0,    2322, 1129, 1509, 0,    870,  239,  3365, 0,
    918,  1107, 0,    2483, 0,    0,    0,    0,    0,    0,    235,  1152, 1300, 304,  0,    396,
    0,    0,    130,  0,    0,    0,    0,    0,    212,  0,    0,    0,    0,    1554, 0,    0,
    393,  3180, 1050, 0,    1363, 861,  0,    1070, 1014, 0,    3145, 0,    1352, 0,    876,  1221,
    0,    325,  0,    0,    53,   107,  0,    2952, 0,    0,    310,  423,  47,   0,    0,    815,
    0,    749,  0,    3227, 1192, 2310, 1281, 3208, 0,    251,  380,  0,    512,  0,    1404, 908,
    0,    0,    300,  920,  0,    0,    2257, 1566, 0,    397,  558,  0,    0,    936,  0,    663,
    2840, 0,    0,    1323, 2928, 1798, 0,    2180, 1326, 568,  1585, 662,  0,    0,    0,    1910,
    976,  0,    58,   0,    0,    3353, 0,    0,    0,    2580, 2798, 3201, 1144, 1352, 0,    858,
    104,  0,    1667, 0,    3186, 781,  987,  0,    570,  193,  13,   415,  657,  52,   0,    0,
    333,  729,  207,  696,  0,    3378, 1198, 2332, 0,    1327, 1564, 1009, 0,    0,    0,    0,
    153,  2698, 89,   1114, 3367, 2898, 3117, 2837, 0,    2690, 0,    2278, 2025, 921,  3232, 0,
    0,    1035, 2620, 0,    0,    0,    0,    300,  0,    1075, 1668, 0,    0,    0,    3159, 0,
    3031, 0,    3084, 982,  1684, 0,    0,    0,    525,  0,    0,    0,    0,    0,    294,  0,
    434,  52,   2034, 0,    0,    497,  2952, 1499, 0,    1874, 0,    2853, 0,    3319, 442,  1411,
    0,    2945, 0,    1324, 251,  3096, 0,    723,  3151, 0,    0,    0,    0,    570,  0,    3295,
    1260, 0,    1395, 2545, 885,  1991, 1729, 1268, 2598, 0,    1289, 275,  0,    0,    114,  1836,
    885,  1259, 2295, 682,  0,    0,    932,  0,    286,  0,    0,    61,   864,  0,    0,    1483,
    0,    86,   587,  9,    459,  0,    1342, 0,    1286, 414,  16,   371,  0,    0,    508,  0,
    350,  2826, 0,    0,    0,    3293, 3183, 0,    238,  0,    1503, 2720, 0,    3108, 0,    2340,
    1602, 2599, 0,    314,  0,    0,    1060, 347,  0,    1546, 0,    0,    0,    0,    895,  158,
    217,  1351, 0,    0,    2159, 0,    0,    121,  755,  407,  2490, 305,  288,  0,    183,  745,
    0,    1667, 3220, 177,  0,    0,    958,  0,    0,    0,    0,    2293, 0,    0,    0,    504,
    0,    0,    0,    1256, 2600, 985,  2319, 529,  1615, 3147, 1601, 0,    3177, 2050, 569,  0,
    513,  0,    0,    689,  1308, 0,    0,    0,    0,    746,  0,    398,  2399, 1141, 0,    3356,
    214,  0,    0,    2903, 0,    431,  2902, 356,  1942, 1430, 1478, 6,    0,    0,    117,  0,
    2887, 2268};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 3410;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 40)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 3410;
}

constexpr int unmangledkT1[] = {258, 260, 73,  6,   294, 235, 86,  89,  66,  164, 215,
                                28,  84,  215, 207, 246, 53,  166, 227, 83,  238, 195,
                                109, 294, 270, 27,  167, 281, 55,  194, 257, 4};
constexpr int unmangledkT2[] = {67,  64,  203, 266, 212, 293, 215, 33,  106, 81,  61,
                                214, 272, 162, 248, 114, 4,   202, 197, 98,  169, 304,
                                196, 197, 294, 217, 1,   201, 74,  46,  38,  221};
constexpr int unmangledkG[]  = {
    0,   0,  0,   0,   132, 0,   0,  123, 0,   152, 0,   87,  196, 305, 0,   0,   229, 273,
    130, 0,  87,  27,  163, 284, 0,  0,   0,   179, 233, 88,  0,   0,   0,   0,   12,  0,
    0,   0,  0,   0,   0,   48,  0,  0,   0,   0,   126, 0,   104, 0,   222, 0,   0,   0,
    0,   0,  171, 36,  129, 0,   0,  0,   113, 0,   142, 303, 0,   138, 246, 0,   21,  0,
    121, 0,  162, 0,   0,   0,   0,  0,   147, 205, 0,   0,   232, 19,  0,   200, 0,   0,
    0,   68, 277, 68,  63,  0,   31, 0,   0,   255, 0,   0,   122, 0,   0,   108, 1,   63,
    74,  20, 130, 0,   0,   284, 0,  98,  158, 245, 0,   22,  2,   157, 195, 0,   257, 0,
    0,   0,  2,   172, 0,   0,   0,  0,   0,   132, 0,   0,   72,  27,  35,  269, 224, 0,
    216, 45, 151, 44,  9,   21,  0,  0,   188, 0,   229, 132, 212, 0,   75,  279, 119, 0,
    0,   0,  261, 25,  3,   180, 0,  0,   42,  40,  133, 200, 51,  0,   0,   232, 137, 128,
    9,   0,  0,   0,   278, 0,   0,  100, 0,   0,   0,   11,  137, 0,   0,   6,   0,   97,
    63,  0,  0,   166, 86,  0,   43, 228, 0,   0,   88,  272, 242, 61,  25,  99,  0,   260,
    169, 0,  0,   0,   99,  123, 39, 289, 77,  83,  0,   0,   33,  167, 0,   305, 0,   230,
    22,  0,  284, 0,   85,  26,  0,  80,  0,   0,   19,  206, 266, 0,   292, 74,  233, 86,
    218, 0,  63,  104, 15,  0,   0,  26,  132, 303, 0,   155, 256, 0,   109, 0,   215, 52,
    0,   0,  155, 95,  240, 112, 0,  95,  54,  89,  0,   171, 0,   158, 0,   51,  23,  125,
    276, 16, 107, 177, 92,  113, 32, 45,  136, 0,   0,   90,  241, 279, 38,  185, 0,   169};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 306;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 32)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 306;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
