# antiX hostname changer

This is a script meant for usage in antiX control centre, allowing safe and easy change of the hostname of an antiX system (Live, frugal or installed).

## Installation

**A.) Apt package installation** (This is the preferred way of installation.)
- [ ] $ sudo apt-get update
- [ ] $ sudo apt-get install antix-hostname-changer

**B.) Apt package installation out of tree** (Use this if no package from the default apt repos is available)
- [ ] Download deb-installer-package and checksum file from respective folder. Current version is approved for antiX 21 and 22, 23, as well as 26, booted into runit, s6-66, s6-rc, dint, legacy sysvinit, and for 32bit and 64bit both.
- [ ] Check shasum file using the command:
```
shasum -c './antix-hostname-changer.sha512.sum'
```
It must show an _OK_.
- [ ] If check was OK, install the package by the commands 
```
sudo apt-get update && sudo apt-get install './antix-hostname-changer.deb'
```
Check console output for error messages during installation.


**C.) Manual installation** (not recommended):
- [ ] Put the script file _antiX-hostname-changer_ from _bin_ directory into the antiX system folder _/usr/local/bin_ and make it executable (_sudo chmod 755 /usr/local/bin/antiX-hostname-changer_)
- [ ] Put the localisation of its user interface for your language (_.mo_ type file) into the respective locale subflolder of your antiX system. ( _/usr/share/locale/‹your_language_ID›/LC_MESSAGES_ ).
- [ ] Put the Icon file _antiXhnc_ from _resources_ into the folder "/usr/share/icons/papirus-antix/48x48/apps".

- [ ] Make sure you have the packages _bind9-dnsutils_, _grep_, _sed_, _yad_, _gettext_, _xauth_, _coreutils_, _sudo_, _awk_, _iproute2_, _isc-dhcp-client_ installed on your system.

## Usage
Simply start it from within _antiX Control Centre_, section _Network_. Alternatively you can either bring up the GUI tool from console by keying in _sudo antiX-hostname-changer_, or you can run it from _App-Select_ in the antiX Main Menu.
After its window appears, enter a new hostname and click the "Change it!" button.

All programs you open after the change, like a terminal emulator, will show the new computer name already instead of the default "antix1", even in Live and frugal.
Since the new hostname is announced in the network, you should be able to ping it from another machine in your LAN by the new name immediately, if your DNS-Server is set up properly.

To make the change permanent in a Live and frugal environment, you'll have to apply a _Live Remaster_ from _antiX Control Centre_, section _Live_. (Not reqired for traditionally installed antiX)

## Known issues
In specific cases it is impossible to retrieve all existing hostnames in a LAN, in particular if machines are configured not to answer, or no local DNS is set up. In these cases please make sure yourself that you don't assign a name to your machine which is already assigned to another one in your LAN.

This tool is designed to look up the Xauth magic cookies in the places where antiX places them by default. If you happen to have them moved around elsewhere or renamed in an unusual way, the script won't be able to update them, causing GUI programs running on the respective X11 account no longer being accessible. In this case you'll have to reboot or restart the X server in order to let them recreate with the new hostname.

Some programs require reopening them, while most GUI programs accept silently the hostname change on the fly. In particular, if you have opened a zzzFM root window from within zzzFM user window while applying the new name, you will find it not fully functional after this. Mitigation: Simply close the zzzFM root window and reopen it from the entry in zzzFM user window.

## Support
For help, questions, suggestions and bug reporting please write to [antiX forums](https://www.forum.antixlinux.com).

## Contributing
- If you find a translation of user interface or user manual being inadequat or misleading wrong, please edit it simply on [antix-development at transifex](https://www.transifex.com/anticapitalista/antix-development/antix-hostname-changer/). On transifex you may edit the string translations used in user interface directly.

## Authors and acknowledgment
This is an antiX community project.

## License
GPL Version 3 (GPLv3)

-----------
Written 2024 by Robin.antiX for antiX community.


