/* $Id: tstIEMAImplDataFpuLdSt-Intel.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Intel - r150741 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_ST_I16_TEST_T const g_aTests_fistt_r80_to_i16_intel[] =
{
    { 0x0141, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/0 */
    { 0x0149, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/2 */
    { 0x0151, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/4 */
    { 0x0159, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/6 */
    { 0x0161, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/8 */
    { 0x0169, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/10 */
    { 0x0171, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/12 */
    { 0x0179, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/0/14 */
    { 0x0541, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/0 */
    { 0x0549, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/2 */
    { 0x0551, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/4 */
    { 0x0559, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/6 */
    { 0x0561, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/8 */
    { 0x0569, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/10 */
    { 0x0571, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/12 */
    { 0x0579, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/1/14 */
    { 0x0941, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/0 */
    { 0x0949, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/2 */
    { 0x0951, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/4 */
    { 0x0959, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/6 */
    { 0x0961, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/8 */
    { 0x0969, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/10 */
    { 0x0971, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/12 */
    { 0x0979, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/2/14 */
    { 0x0d41, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/0 */
    { 0x0d49, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/2 */
    { 0x0d51, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/4 */
    { 0x0d59, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/6 */
    { 0x0d61, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/8 */
    { 0x0d69, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/10 */
    { 0x0d71, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/12 */
    { 0x0d79, 0xf1ff, 0x4101, RTFLOAT80U_INIT_C(1,0x7556824d1acbdfae,32767), INT16_MIN }, /* #0/3/14 */
    { 0x0104, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/0 */
    { 0x010c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/2 */
    { 0x0114, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/4 */
    { 0x011c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/6 */
    { 0x0124, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/8 */
    { 0x012c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/10 */
    { 0x0134, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/12 */
    { 0x013c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/0/14 */
    { 0x0504, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/0 */
    { 0x050c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/2 */
    { 0x0514, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/4 */
    { 0x051c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/6 */
    { 0x0524, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/8 */
    { 0x052c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/10 */
    { 0x0534, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/12 */
    { 0x053c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/1/14 */
    { 0x0904, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/0 */
    { 0x090c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/2 */
    { 0x0914, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/4 */
    { 0x091c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/6 */
    { 0x0924, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/8 */
    { 0x092c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/10 */
    { 0x0934, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/12 */
    { 0x093c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/2/14 */
    { 0x0d04, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/0 */
    { 0x0d0c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/2 */
    { 0x0d14, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/4 */
    { 0x0d1c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/6 */
    { 0x0d24, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/8 */
    { 0x0d2c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/10 */
    { 0x0d34, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/12 */
    { 0x0d3c, 0x1652, 0xbc81, RTFLOAT80U_INIT_C(0,0x201d6fd113a6dc4f,32767), INT16_C(-3) }, /* #1/3/14 */
    { 0x0342, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/0 */
    { 0x034a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/2 */
    { 0x0352, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/4 */
    { 0x035a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/6 */
    { 0x0362, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/8 */
    { 0x036a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/10 */
    { 0x0372, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/12 */
    { 0x037a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/0/14 */
    { 0x0742, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/0 */
    { 0x074a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/2 */
    { 0x0752, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/4 */
    { 0x075a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/6 */
    { 0x0762, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/8 */
    { 0x076a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/10 */
    { 0x0772, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/12 */
    { 0x077a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/1/14 */
    { 0x0b42, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/0 */
    { 0x0b4a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/2 */
    { 0x0b52, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/4 */
    { 0x0b5a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/6 */
    { 0x0b62, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/8 */
    { 0x0b6a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/10 */
    { 0x0b72, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/12 */
    { 0x0b7a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/2/14 */
    { 0x0f42, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/0 */
    { 0x0f4a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/2 */
    { 0x0f52, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/4 */
    { 0x0f5a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/6 */
    { 0x0f62, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/8 */
    { 0x0f6a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/10 */
    { 0x0f72, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/12 */
    { 0x0f7a, 0xaa46, 0xb881, RTFLOAT80U_INIT_C(1,0xd04e79084fb51498,20331), INT16_C(-3) }, /* #2/3/14 */
    { 0x0101, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/0 */
    { 0x0109, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/2 */
    { 0x0111, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/4 */
    { 0x0119, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/6 */
    { 0x0121, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/8 */
    { 0x0129, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/10 */
    { 0x0131, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/12 */
    { 0x0139, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/0/14 */
    { 0x0501, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/0 */
    { 0x0509, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/2 */
    { 0x0511, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/4 */
    { 0x0519, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/6 */
    { 0x0521, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/8 */
    { 0x0529, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/10 */
    { 0x0531, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/12 */
    { 0x0539, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/1/14 */
    { 0x0901, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/0 */
    { 0x0909, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/2 */
    { 0x0911, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/4 */
    { 0x0919, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/6 */
    { 0x0921, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/8 */
    { 0x0929, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/10 */
    { 0x0931, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/12 */
    { 0x0939, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/2/14 */
    { 0x0d01, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/0 */
    { 0x0d09, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/2 */
    { 0x0d11, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/4 */
    { 0x0d19, 0x9219, 0x80a0, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/6 */
    { 0x0d21, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/8 */
    { 0x0d29, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/10 */
    { 0x0d31, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/12 */
    { 0x0d39, 0x9219, 0x0020, RTFLOAT80U_INIT_C(0,0xe3409b96d07cfa4e,16383), INT16_C(1) }, /* #3/3/14 */
    { 0x0302, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/0 */
    { 0x030a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/2 */
    { 0x0312, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/4 */
    { 0x031a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/6 */
    { 0x0322, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/8 */
    { 0x032a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/10 */
    { 0x0332, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/12 */
    { 0x033a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/0/14 */
    { 0x0702, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/0 */
    { 0x070a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/2 */
    { 0x0712, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/4 */
    { 0x071a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/6 */
    { 0x0722, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/8 */
    { 0x072a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/10 */
    { 0x0732, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/12 */
    { 0x073a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/1/14 */
    { 0x0b02, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/0 */
    { 0x0b0a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/2 */
    { 0x0b12, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/4 */
    { 0x0b1a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/6 */
    { 0x0b22, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/8 */
    { 0x0b2a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/10 */
    { 0x0b32, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/12 */
    { 0x0b3a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/2/14 */
    { 0x0f02, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/0 */
    { 0x0f0a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/2 */
    { 0x0f12, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/4 */
    { 0x0f1a, 0x218b, 0x81a0, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/6 */
    { 0x0f22, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/8 */
    { 0x0f2a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/10 */
    { 0x0f32, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/12 */
    { 0x0f3a, 0x218b, 0x0120, RTFLOAT80U_INIT_C(1,0x846c8dc57d78c4cb,16383), INT16_C(-1) }, /* #4/3/14 */
    { 0x0241, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/0 */
    { 0x0249, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/2 */
    { 0x0251, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/4 */
    { 0x0259, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/6 */
    { 0x0261, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/8 */
    { 0x0269, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/10 */
    { 0x0271, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/12 */
    { 0x0279, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/0/14 */
    { 0x0641, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/0 */
    { 0x0649, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/2 */
    { 0x0651, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/4 */
    { 0x0659, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/6 */
    { 0x0661, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/8 */
    { 0x0669, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/10 */
    { 0x0671, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/12 */
    { 0x0679, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/1/14 */
    { 0x0a41, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/0 */
    { 0x0a49, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/2 */
    { 0x0a51, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/4 */
    { 0x0a59, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/6 */
    { 0x0a61, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/8 */
    { 0x0a69, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/10 */
    { 0x0a71, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/12 */
    { 0x0a79, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/2/14 */
    { 0x0e41, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/0 */
    { 0x0e49, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/2 */
    { 0x0e51, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/4 */
    { 0x0e59, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/6 */
    { 0x0e61, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/8 */
    { 0x0e69, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/10 */
    { 0x0e71, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/12 */
    { 0x0e79, 0xa941, 0x0101, RTFLOAT80U_INIT_C(1,0x9dcca85462a8c57a,31593), INT16_MIN }, /* #5/3/14 */
    { 0x0340, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/0 */
    { 0x0348, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/2 */
    { 0x0350, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/4 */
    { 0x0358, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/6 */
    { 0x0360, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/8 */
    { 0x0368, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/10 */
    { 0x0370, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/12 */
    { 0x0378, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/0/14 */
    { 0x0740, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/0 */
    { 0x0748, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/2 */
    { 0x0750, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/4 */
    { 0x0758, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/6 */
    { 0x0760, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/8 */
    { 0x0768, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/10 */
    { 0x0770, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/12 */
    { 0x0778, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/1/14 */
    { 0x0b40, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/0 */
    { 0x0b48, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/2 */
    { 0x0b50, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/4 */
    { 0x0b58, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/6 */
    { 0x0b60, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/8 */
    { 0x0b68, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/10 */
    { 0x0b70, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/12 */
    { 0x0b78, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/2/14 */
    { 0x0f40, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/0 */
    { 0x0f48, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/2 */
    { 0x0f50, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/4 */
    { 0x0f58, 0x7c93, 0xc4a0, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/6 */
    { 0x0f60, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/8 */
    { 0x0f68, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/10 */
    { 0x0f70, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/12 */
    { 0x0f78, 0x7c93, 0x4420, RTFLOAT80U_INIT_C(1,0xd313605aeea6dfb3,16383), INT16_C(-1) }, /* #6/3/14 */
    { 0x0007, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/0 */
    { 0x000f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/2 */
    { 0x0017, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/4 */
    { 0x001f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/6 */
    { 0x0027, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/8 */
    { 0x002f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/10 */
    { 0x0037, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/12 */
    { 0x003f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/0/14 */
    { 0x0407, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/0 */
    { 0x040f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/2 */
    { 0x0417, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/4 */
    { 0x041f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/6 */
    { 0x0427, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/8 */
    { 0x042f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/10 */
    { 0x0437, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/12 */
    { 0x043f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/1/14 */
    { 0x0807, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/0 */
    { 0x080f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/2 */
    { 0x0817, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/4 */
    { 0x081f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/6 */
    { 0x0827, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/8 */
    { 0x082f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/10 */
    { 0x0837, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/12 */
    { 0x083f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/2/14 */
    { 0x0c07, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/0 */
    { 0x0c0f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/2 */
    { 0x0c17, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/4 */
    { 0x0c1f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/6 */
    { 0x0c27, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/8 */
    { 0x0c2f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/10 */
    { 0x0c37, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/12 */
    { 0x0c3f, 0xb289, 0x0001, RTFLOAT80U_INIT_C(1,0x8000000000000039,32767), INT16_MIN }, /* #7/3/14 */
    { 0x0140, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/0 */
    { 0x0148, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/2 */
    { 0x0150, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/4 */
    { 0x0158, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/6 */
    { 0x0160, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/8 */
    { 0x0168, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/10 */
    { 0x0170, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/12 */
    { 0x0178, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/0/14 */
    { 0x0540, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/0 */
    { 0x0548, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/2 */
    { 0x0550, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/4 */
    { 0x0558, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/6 */
    { 0x0560, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/8 */
    { 0x0568, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/10 */
    { 0x0570, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/12 */
    { 0x0578, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/1/14 */
    { 0x0940, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/0 */
    { 0x0948, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/2 */
    { 0x0950, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/4 */
    { 0x0958, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/6 */
    { 0x0960, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/8 */
    { 0x0968, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/10 */
    { 0x0970, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/12 */
    { 0x0978, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/2/14 */
    { 0x0d40, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/0 */
    { 0x0d48, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/2 */
    { 0x0d50, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/4 */
    { 0x0d58, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/6 */
    { 0x0d60, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/8 */
    { 0x0d68, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/10 */
    { 0x0d70, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/12 */
    { 0x0d78, 0xd9d9, 0xf981, RTFLOAT80U_INIT_C(0,0xc00000e31b890969,32767), INT16_C(-3) }, /* #8/3/14 */
    { 0x0241, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/0 */
    { 0x0249, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/2 */
    { 0x0251, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/4 */
    { 0x0259, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/6 */
    { 0x0261, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/8 */
    { 0x0269, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/10 */
    { 0x0271, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/12 */
    { 0x0279, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/0/14 */
    { 0x0641, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/0 */
    { 0x0649, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/2 */
    { 0x0651, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/4 */
    { 0x0659, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/6 */
    { 0x0661, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/8 */
    { 0x0669, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/10 */
    { 0x0671, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/12 */
    { 0x0679, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/1/14 */
    { 0x0a41, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/0 */
    { 0x0a49, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/2 */
    { 0x0a51, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/4 */
    { 0x0a59, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/6 */
    { 0x0a61, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/8 */
    { 0x0a69, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/10 */
    { 0x0a71, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/12 */
    { 0x0a79, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/2/14 */
    { 0x0e41, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/0 */
    { 0x0e49, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/2 */
    { 0x0e51, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/4 */
    { 0x0e59, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/6 */
    { 0x0e61, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/8 */
    { 0x0e69, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/10 */
    { 0x0e71, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/12 */
    { 0x0e79, 0x255d, 0x0501, RTFLOAT80U_INIT_C(1,0x2d5061a631a6380c,28144), INT16_MIN }, /* #9/3/14 */
    { 0x0043, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/0 */
    { 0x004b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/2 */
    { 0x0053, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/4 */
    { 0x005b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/6 */
    { 0x0063, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/8 */
    { 0x006b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/10 */
    { 0x0073, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/12 */
    { 0x007b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/0/14 */
    { 0x0443, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/0 */
    { 0x044b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/2 */
    { 0x0453, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/4 */
    { 0x045b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/6 */
    { 0x0463, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/8 */
    { 0x046b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/10 */
    { 0x0473, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/12 */
    { 0x047b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/1/14 */
    { 0x0843, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/0 */
    { 0x084b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/2 */
    { 0x0853, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/4 */
    { 0x085b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/6 */
    { 0x0863, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/8 */
    { 0x086b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/10 */
    { 0x0873, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/12 */
    { 0x087b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/2/14 */
    { 0x0c43, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/0 */
    { 0x0c4b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/2 */
    { 0x0c53, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/4 */
    { 0x0c5b, 0xc30b, 0xc1a0, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/6 */
    { 0x0c63, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/8 */
    { 0x0c6b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/10 */
    { 0x0c73, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/12 */
    { 0x0c7b, 0xc30b, 0x4120, RTFLOAT80U_INIT_C(1,0x98a4639c7026d925,16397), INT16_C(-19538) }, /* #10/3/14 */
    { 0x0042, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/0 */
    { 0x004a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/2 */
    { 0x0052, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/4 */
    { 0x005a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/6 */
    { 0x0062, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/8 */
    { 0x006a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/10 */
    { 0x0072, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/12 */
    { 0x007a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/0/14 */
    { 0x0442, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/0 */
    { 0x044a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/2 */
    { 0x0452, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/4 */
    { 0x045a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/6 */
    { 0x0462, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/8 */
    { 0x046a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/10 */
    { 0x0472, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/12 */
    { 0x047a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/1/14 */
    { 0x0842, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/0 */
    { 0x084a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/2 */
    { 0x0852, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/4 */
    { 0x085a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/6 */
    { 0x0862, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/8 */
    { 0x086a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/10 */
    { 0x0872, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/12 */
    { 0x087a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/2/14 */
    { 0x0c42, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/0 */
    { 0x0c4a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/2 */
    { 0x0c52, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/4 */
    { 0x0c5a, 0xa042, 0x80a0, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/6 */
    { 0x0c62, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/8 */
    { 0x0c6a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/10 */
    { 0x0c72, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/12 */
    { 0x0c7a, 0xa042, 0x0020, RTFLOAT80U_INIT_C(1,0xffffffffffff0000,16383), INT16_C(-1) }, /* #11/3/14 */
    { 0x0107, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/0 */
    { 0x010f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/2 */
    { 0x0117, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/4 */
    { 0x011f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/6 */
    { 0x0127, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/8 */
    { 0x012f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/10 */
    { 0x0137, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/12 */
    { 0x013f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/0/14 */
    { 0x0507, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/0 */
    { 0x050f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/2 */
    { 0x0517, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/4 */
    { 0x051f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/6 */
    { 0x0527, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/8 */
    { 0x052f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/10 */
    { 0x0537, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/12 */
    { 0x053f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/1/14 */
    { 0x0907, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/0 */
    { 0x090f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/2 */
    { 0x0917, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/4 */
    { 0x091f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/6 */
    { 0x0927, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/8 */
    { 0x092f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/10 */
    { 0x0937, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/12 */
    { 0x093f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/2/14 */
    { 0x0d07, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/0 */
    { 0x0d0f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/2 */
    { 0x0d17, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/4 */
    { 0x0d1f, 0x941c, 0x84a0, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/6 */
    { 0x0d27, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/8 */
    { 0x0d2f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/10 */
    { 0x0d37, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/12 */
    { 0x0d3f, 0x941c, 0x0420, RTFLOAT80U_INIT_C(1,0xbcd569a8ed860d35,16383), INT16_C(-1) }, /* #12/3/14 */
    { 0x0047, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/0 */
    { 0x004f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/2 */
    { 0x0057, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/4 */
    { 0x005f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/6 */
    { 0x0067, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/8 */
    { 0x006f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/10 */
    { 0x0077, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/12 */
    { 0x007f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/0/14 */
    { 0x0447, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/0 */
    { 0x044f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/2 */
    { 0x0457, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/4 */
    { 0x045f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/6 */
    { 0x0467, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/8 */
    { 0x046f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/10 */
    { 0x0477, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/12 */
    { 0x047f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/1/14 */
    { 0x0847, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/0 */
    { 0x084f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/2 */
    { 0x0857, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/4 */
    { 0x085f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/6 */
    { 0x0867, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/8 */
    { 0x086f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/10 */
    { 0x0877, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/12 */
    { 0x087f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/2/14 */
    { 0x0c47, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/0 */
    { 0x0c4f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/2 */
    { 0x0c57, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/4 */
    { 0x0c5f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/6 */
    { 0x0c67, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/8 */
    { 0x0c6f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/10 */
    { 0x0c77, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/12 */
    { 0x0c7f, 0xc7aa, 0x4501, RTFLOAT80U_INIT_C(0,0x929e334f22b2e,32767), INT16_MIN }, /* #13/3/14 */
    { 0x0107, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/0 */
    { 0x010f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/2 */
    { 0x0117, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/4 */
    { 0x011f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/6 */
    { 0x0127, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/8 */
    { 0x012f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/10 */
    { 0x0137, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/12 */
    { 0x013f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/0/14 */
    { 0x0507, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/0 */
    { 0x050f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/2 */
    { 0x0517, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/4 */
    { 0x051f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/6 */
    { 0x0527, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/8 */
    { 0x052f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/10 */
    { 0x0537, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/12 */
    { 0x053f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/1/14 */
    { 0x0907, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/0 */
    { 0x090f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/2 */
    { 0x0917, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/4 */
    { 0x091f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/6 */
    { 0x0927, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/8 */
    { 0x092f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/10 */
    { 0x0937, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/12 */
    { 0x093f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/2/14 */
    { 0x0d07, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/0 */
    { 0x0d0f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/2 */
    { 0x0d17, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/4 */
    { 0x0d1f, 0x4d41, 0xc5a0, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/6 */
    { 0x0d27, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/8 */
    { 0x0d2f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/10 */
    { 0x0d37, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/12 */
    { 0x0d3f, 0x4d41, 0x4520, RTFLOAT80U_INIT_C(1,0x1c3f0a3aca2d1711,0), INT16_C(0) }, /* #14/3/14 */
    { 0x0341, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/0 */
    { 0x0349, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/2 */
    { 0x0351, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/4 */
    { 0x0359, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/6 */
    { 0x0361, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/8 */
    { 0x0369, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/10 */
    { 0x0371, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/12 */
    { 0x0379, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/0/14 */
    { 0x0741, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/0 */
    { 0x0749, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/2 */
    { 0x0751, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/4 */
    { 0x0759, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/6 */
    { 0x0761, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/8 */
    { 0x0769, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/10 */
    { 0x0771, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/12 */
    { 0x0779, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/1/14 */
    { 0x0b41, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/0 */
    { 0x0b49, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/2 */
    { 0x0b51, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/4 */
    { 0x0b59, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/6 */
    { 0x0b61, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/8 */
    { 0x0b69, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/10 */
    { 0x0b71, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/12 */
    { 0x0b79, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/2/14 */
    { 0x0f41, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/0 */
    { 0x0f49, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/2 */
    { 0x0f51, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/4 */
    { 0x0f59, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/6 */
    { 0x0f61, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/8 */
    { 0x0f69, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/10 */
    { 0x0f71, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/12 */
    { 0x0f79, 0x2e6c, 0x0401, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_MIN }, /* #15/3/14 */
    { 0x0040, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/0 */
    { 0x0048, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/2 */
    { 0x0050, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/4 */
    { 0x0058, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/6 */
    { 0x0060, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/8 */
    { 0x0068, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/10 */
    { 0x0070, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/12 */
    { 0x0078, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/0/14 */
    { 0x0440, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/0 */
    { 0x0448, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/2 */
    { 0x0450, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/4 */
    { 0x0458, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/6 */
    { 0x0460, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/8 */
    { 0x0468, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/10 */
    { 0x0470, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/12 */
    { 0x0478, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/1/14 */
    { 0x0840, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/0 */
    { 0x0848, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/2 */
    { 0x0850, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/4 */
    { 0x0858, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/6 */
    { 0x0860, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/8 */
    { 0x0868, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/10 */
    { 0x0870, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/12 */
    { 0x0878, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/2/14 */
    { 0x0c40, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/0 */
    { 0x0c48, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/2 */
    { 0x0c50, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/4 */
    { 0x0c58, 0x74dc, 0xc4a0, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/6 */
    { 0x0c60, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/8 */
    { 0x0c68, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/10 */
    { 0x0c70, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/12 */
    { 0x0c78, 0x74dc, 0x4420, RTFLOAT80U_INIT_C(0,0xd38f7e6f6846542b,16383), INT16_C(1) }, /* #16/3/14 */
    { 0x0041, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/0 */
    { 0x0049, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/2 */
    { 0x0051, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/4 */
    { 0x0059, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/6 */
    { 0x0061, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/8 */
    { 0x0069, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/10 */
    { 0x0071, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/12 */
    { 0x0079, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/0/14 */
    { 0x0441, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/0 */
    { 0x0449, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/2 */
    { 0x0451, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/4 */
    { 0x0459, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/6 */
    { 0x0461, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/8 */
    { 0x0469, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/10 */
    { 0x0471, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/12 */
    { 0x0479, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/1/14 */
    { 0x0841, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/0 */
    { 0x0849, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/2 */
    { 0x0851, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/4 */
    { 0x0859, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/6 */
    { 0x0861, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/8 */
    { 0x0869, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/10 */
    { 0x0871, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/12 */
    { 0x0879, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/2/14 */
    { 0x0c41, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/0 */
    { 0x0c49, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/2 */
    { 0x0c51, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/4 */
    { 0x0c59, 0xe475, 0xc4a0, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/6 */
    { 0x0c61, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/8 */
    { 0x0c69, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/10 */
    { 0x0c71, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/12 */
    { 0x0c79, 0xe475, 0x4420, RTFLOAT80U_INIT_C(0,0xa94dfe8d8b59292e,16383), INT16_C(1) }, /* #17/3/14 */
    { 0x0240, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/0 */
    { 0x0248, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/2 */
    { 0x0250, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/4 */
    { 0x0258, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/6 */
    { 0x0260, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/8 */
    { 0x0268, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/10 */
    { 0x0270, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/12 */
    { 0x0278, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/0/14 */
    { 0x0640, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/0 */
    { 0x0648, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/2 */
    { 0x0650, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/4 */
    { 0x0658, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/6 */
    { 0x0660, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/8 */
    { 0x0668, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/10 */
    { 0x0670, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/12 */
    { 0x0678, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/1/14 */
    { 0x0a40, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/0 */
    { 0x0a48, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/2 */
    { 0x0a50, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/4 */
    { 0x0a58, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/6 */
    { 0x0a60, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/8 */
    { 0x0a68, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/10 */
    { 0x0a70, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/12 */
    { 0x0a78, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/2/14 */
    { 0x0e40, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/0 */
    { 0x0e48, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/2 */
    { 0x0e50, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/4 */
    { 0x0e58, 0x206e, 0x80a0, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/6 */
    { 0x0e60, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/8 */
    { 0x0e68, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/10 */
    { 0x0e70, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/12 */
    { 0x0e78, 0x206e, 0x0020, RTFLOAT80U_INIT_C(1,0xa38a8e7f0d3ed6ab,16383), INT16_C(-1) }, /* #18/3/14 */
    { 0x0246, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/0 */
    { 0x024e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/2 */
    { 0x0256, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/4 */
    { 0x025e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/6 */
    { 0x0266, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/8 */
    { 0x026e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/10 */
    { 0x0276, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/12 */
    { 0x027e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/0/14 */
    { 0x0646, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/0 */
    { 0x064e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/2 */
    { 0x0656, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/4 */
    { 0x065e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/6 */
    { 0x0666, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/8 */
    { 0x066e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/10 */
    { 0x0676, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/12 */
    { 0x067e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/1/14 */
    { 0x0a46, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/0 */
    { 0x0a4e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/2 */
    { 0x0a56, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/4 */
    { 0x0a5e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/6 */
    { 0x0a66, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/8 */
    { 0x0a6e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/10 */
    { 0x0a76, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/12 */
    { 0x0a7e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/2/14 */
    { 0x0e46, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/0 */
    { 0x0e4e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/2 */
    { 0x0e56, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/4 */
    { 0x0e5e, 0x0c2a, 0x84a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/6 */
    { 0x0e66, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/8 */
    { 0x0e6e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/10 */
    { 0x0e76, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/12 */
    { 0x0e7e, 0x0c2a, 0x0420, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16383), INT16_C(-1) }, /* #19/3/14 */
    { 0x0040, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/0 */
    { 0x0048, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/2 */
    { 0x0050, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/4 */
    { 0x0058, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/6 */
    { 0x0060, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/8 */
    { 0x0068, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/10 */
    { 0x0070, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/12 */
    { 0x0078, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/0/14 */
    { 0x0440, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/0 */
    { 0x0448, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/2 */
    { 0x0450, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/4 */
    { 0x0458, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/6 */
    { 0x0460, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/8 */
    { 0x0468, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/10 */
    { 0x0470, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/12 */
    { 0x0478, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/1/14 */
    { 0x0840, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/0 */
    { 0x0848, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/2 */
    { 0x0850, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/4 */
    { 0x0858, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/6 */
    { 0x0860, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/8 */
    { 0x0868, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/10 */
    { 0x0870, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/12 */
    { 0x0878, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/2/14 */
    { 0x0c40, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/0 */
    { 0x0c48, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/2 */
    { 0x0c50, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/4 */
    { 0x0c58, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/6 */
    { 0x0c60, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/8 */
    { 0x0c68, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/10 */
    { 0x0c70, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/12 */
    { 0x0c78, 0x402c, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), INT16_C(-3) }, /* #20/3/14 */
    { 0x0107, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/0 */
    { 0x010f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/2 */
    { 0x0117, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/4 */
    { 0x011f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/6 */
    { 0x0127, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/8 */
    { 0x012f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/10 */
    { 0x0137, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/12 */
    { 0x013f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/0/14 */
    { 0x0507, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/0 */
    { 0x050f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/2 */
    { 0x0517, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/4 */
    { 0x051f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/6 */
    { 0x0527, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/8 */
    { 0x052f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/10 */
    { 0x0537, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/12 */
    { 0x053f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/1/14 */
    { 0x0907, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/0 */
    { 0x090f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/2 */
    { 0x0917, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/4 */
    { 0x091f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/6 */
    { 0x0927, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/8 */
    { 0x092f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/10 */
    { 0x0937, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/12 */
    { 0x093f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/2/14 */
    { 0x0d07, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/0 */
    { 0x0d0f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/2 */
    { 0x0d17, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/4 */
    { 0x0d1f, 0x69bb, 0xc1a0, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/6 */
    { 0x0d27, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/8 */
    { 0x0d2f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/10 */
    { 0x0d37, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/12 */
    { 0x0d3f, 0x69bb, 0x4120, RTFLOAT80U_INIT_C(1,0x6569ff581a42af5a,0), INT16_C(0) }, /* #21/3/14 */
    { 0x0241, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/0 */
    { 0x0249, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/2 */
    { 0x0251, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/4 */
    { 0x0259, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/6 */
    { 0x0261, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/8 */
    { 0x0269, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/10 */
    { 0x0271, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/12 */
    { 0x0279, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/0/14 */
    { 0x0641, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/0 */
    { 0x0649, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/2 */
    { 0x0651, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/4 */
    { 0x0659, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/6 */
    { 0x0661, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/8 */
    { 0x0669, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/10 */
    { 0x0671, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/12 */
    { 0x0679, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/1/14 */
    { 0x0a41, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/0 */
    { 0x0a49, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/2 */
    { 0x0a51, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/4 */
    { 0x0a59, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/6 */
    { 0x0a61, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/8 */
    { 0x0a69, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/10 */
    { 0x0a71, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/12 */
    { 0x0a79, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/2/14 */
    { 0x0e41, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/0 */
    { 0x0e49, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/2 */
    { 0x0e51, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/4 */
    { 0x0e59, 0x97de, 0x85a0, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/6 */
    { 0x0e61, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/8 */
    { 0x0e69, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/10 */
    { 0x0e71, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/12 */
    { 0x0e79, 0x97de, 0x0520, RTFLOAT80U_INIT_C(0,0xab8c2fb407494034,16383), INT16_C(1) }, /* #22/3/14 */
    { 0x0107, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/0 */
    { 0x010f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/2 */
    { 0x0117, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/4 */
    { 0x011f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/6 */
    { 0x0127, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/8 */
    { 0x012f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/10 */
    { 0x0137, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/12 */
    { 0x013f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/0/14 */
    { 0x0507, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/0 */
    { 0x050f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/2 */
    { 0x0517, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/4 */
    { 0x051f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/6 */
    { 0x0527, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/8 */
    { 0x052f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/10 */
    { 0x0537, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/12 */
    { 0x053f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/1/14 */
    { 0x0907, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/0 */
    { 0x090f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/2 */
    { 0x0917, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/4 */
    { 0x091f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/6 */
    { 0x0927, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/8 */
    { 0x092f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/10 */
    { 0x0937, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/12 */
    { 0x093f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/2/14 */
    { 0x0d07, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/0 */
    { 0x0d0f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/2 */
    { 0x0d17, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/4 */
    { 0x0d1f, 0x26a2, 0x84a0, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/6 */
    { 0x0d27, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/8 */
    { 0x0d2f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/10 */
    { 0x0d37, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/12 */
    { 0x0d3f, 0x26a2, 0x0420, RTFLOAT80U_INIT_C(1,0x3ea877cf,0), INT16_C(0) }, /* #23/3/14 */
    { 0x0207, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/0 */
    { 0x020f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/2 */
    { 0x0217, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/4 */
    { 0x021f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/6 */
    { 0x0227, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/8 */
    { 0x022f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/10 */
    { 0x0237, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/12 */
    { 0x023f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/0/14 */
    { 0x0607, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/0 */
    { 0x060f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/2 */
    { 0x0617, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/4 */
    { 0x061f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/6 */
    { 0x0627, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/8 */
    { 0x062f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/10 */
    { 0x0637, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/12 */
    { 0x063f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/1/14 */
    { 0x0a07, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/0 */
    { 0x0a0f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/2 */
    { 0x0a17, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/4 */
    { 0x0a1f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/6 */
    { 0x0a27, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/8 */
    { 0x0a2f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/10 */
    { 0x0a37, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/12 */
    { 0x0a3f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/2/14 */
    { 0x0e07, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/0 */
    { 0x0e0f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/2 */
    { 0x0e17, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/4 */
    { 0x0e1f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/6 */
    { 0x0e27, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/8 */
    { 0x0e2f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/10 */
    { 0x0e37, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/12 */
    { 0x0e3f, 0xda1a, 0x4001, RTFLOAT80U_INIT_C(1,0xfcfdf5ed4654853,13109), INT16_MIN }, /* #24/3/14 */
    { 0x0140, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/0 */
    { 0x0148, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/2 */
    { 0x0150, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/4 */
    { 0x0158, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/6 */
    { 0x0160, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/8 */
    { 0x0168, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/10 */
    { 0x0170, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/12 */
    { 0x0178, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/0/14 */
    { 0x0540, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/0 */
    { 0x0548, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/2 */
    { 0x0550, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/4 */
    { 0x0558, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/6 */
    { 0x0560, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/8 */
    { 0x0568, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/10 */
    { 0x0570, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/12 */
    { 0x0578, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/1/14 */
    { 0x0940, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/0 */
    { 0x0948, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/2 */
    { 0x0950, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/4 */
    { 0x0958, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/6 */
    { 0x0960, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/8 */
    { 0x0968, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/10 */
    { 0x0970, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/12 */
    { 0x0978, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/2/14 */
    { 0x0d40, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/0 */
    { 0x0d48, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/2 */
    { 0x0d50, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/4 */
    { 0x0d58, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/6 */
    { 0x0d60, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/8 */
    { 0x0d68, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/10 */
    { 0x0d70, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/12 */
    { 0x0d78, 0xb411, 0xbc81, RTFLOAT80U_INIT_C(1,0x4a73c471cbdb0aec,32767), INT16_C(-3) }, /* #25/3/14 */
    { 0x0104, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/0 */
    { 0x010c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/2 */
    { 0x0114, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/4 */
    { 0x011c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/6 */
    { 0x0124, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/8 */
    { 0x012c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/10 */
    { 0x0134, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/12 */
    { 0x013c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/0/14 */
    { 0x0504, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/0 */
    { 0x050c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/2 */
    { 0x0514, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/4 */
    { 0x051c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/6 */
    { 0x0524, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/8 */
    { 0x052c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/10 */
    { 0x0534, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/12 */
    { 0x053c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/1/14 */
    { 0x0904, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/0 */
    { 0x090c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/2 */
    { 0x0914, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/4 */
    { 0x091c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/6 */
    { 0x0924, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/8 */
    { 0x092c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/10 */
    { 0x0934, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/12 */
    { 0x093c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/2/14 */
    { 0x0d04, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/0 */
    { 0x0d0c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/2 */
    { 0x0d14, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/4 */
    { 0x0d1c, 0x7522, 0xc5a0, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/6 */
    { 0x0d24, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/8 */
    { 0x0d2c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/10 */
    { 0x0d34, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/12 */
    { 0x0d3c, 0x7522, 0x4520, RTFLOAT80U_INIT_C(1,0x987b5aa250b8ce1f,0), INT16_C(0) }, /* #26/3/14 */
    { 0x0146, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/0 */
    { 0x014e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/2 */
    { 0x0156, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/4 */
    { 0x015e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/6 */
    { 0x0166, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/8 */
    { 0x016e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/10 */
    { 0x0176, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/12 */
    { 0x017e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/0/14 */
    { 0x0546, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/0 */
    { 0x054e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/2 */
    { 0x0556, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/4 */
    { 0x055e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/6 */
    { 0x0566, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/8 */
    { 0x056e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/10 */
    { 0x0576, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/12 */
    { 0x057e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/1/14 */
    { 0x0946, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/0 */
    { 0x094e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/2 */
    { 0x0956, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/4 */
    { 0x095e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/6 */
    { 0x0966, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/8 */
    { 0x096e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/10 */
    { 0x0976, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/12 */
    { 0x097e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/2/14 */
    { 0x0d46, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/0 */
    { 0x0d4e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/2 */
    { 0x0d56, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/4 */
    { 0x0d5e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/6 */
    { 0x0d66, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/8 */
    { 0x0d6e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/10 */
    { 0x0d76, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/12 */
    { 0x0d7e, 0xf559, 0xfd81, RTFLOAT80U_INIT_C(0,0x5cf2d199f4b666e,9032), INT16_C(-3) }, /* #27/3/14 */
    { 0x0304, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/0 */
    { 0x030c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/2 */
    { 0x0314, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/4 */
    { 0x031c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/6 */
    { 0x0324, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/8 */
    { 0x032c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/10 */
    { 0x0334, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/12 */
    { 0x033c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/0/14 */
    { 0x0704, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/0 */
    { 0x070c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/2 */
    { 0x0714, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/4 */
    { 0x071c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/6 */
    { 0x0724, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/8 */
    { 0x072c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/10 */
    { 0x0734, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/12 */
    { 0x073c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/1/14 */
    { 0x0b04, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/0 */
    { 0x0b0c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/2 */
    { 0x0b14, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/4 */
    { 0x0b1c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/6 */
    { 0x0b24, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/8 */
    { 0x0b2c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/10 */
    { 0x0b34, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/12 */
    { 0x0b3c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/2/14 */
    { 0x0f04, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/0 */
    { 0x0f0c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/2 */
    { 0x0f14, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/4 */
    { 0x0f1c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/6 */
    { 0x0f24, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/8 */
    { 0x0f2c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/10 */
    { 0x0f34, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/12 */
    { 0x0f3c, 0x49c4, 0xf981, RTFLOAT80U_INIT_C(0,0x490159ab9d8fa3f4,32767), INT16_C(-3) }, /* #28/3/14 */
    { 0x0103, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/0 */
    { 0x010b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/2 */
    { 0x0113, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/4 */
    { 0x011b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/6 */
    { 0x0123, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/8 */
    { 0x012b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/10 */
    { 0x0133, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/12 */
    { 0x013b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/0/14 */
    { 0x0503, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/0 */
    { 0x050b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/2 */
    { 0x0513, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/4 */
    { 0x051b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/6 */
    { 0x0523, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/8 */
    { 0x052b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/10 */
    { 0x0533, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/12 */
    { 0x053b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/1/14 */
    { 0x0903, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/0 */
    { 0x090b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/2 */
    { 0x0913, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/4 */
    { 0x091b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/6 */
    { 0x0923, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/8 */
    { 0x092b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/10 */
    { 0x0933, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/12 */
    { 0x093b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/2/14 */
    { 0x0d03, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/0 */
    { 0x0d0b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/2 */
    { 0x0d13, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/4 */
    { 0x0d1b, 0x270d, 0x85a0, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/6 */
    { 0x0d23, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/8 */
    { 0x0d2b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/10 */
    { 0x0d33, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/12 */
    { 0x0d3b, 0x270d, 0x0520, RTFLOAT80U_INIT_C(0,0x80000000000000bd,0), INT16_C(0) }, /* #29/3/14 */
    { 0x0300, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/0 */
    { 0x0308, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/2 */
    { 0x0310, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/4 */
    { 0x0318, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/6 */
    { 0x0320, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/8 */
    { 0x0328, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/10 */
    { 0x0330, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/12 */
    { 0x0338, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/0/14 */
    { 0x0700, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/0 */
    { 0x0708, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/2 */
    { 0x0710, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/4 */
    { 0x0718, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/6 */
    { 0x0720, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/8 */
    { 0x0728, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/10 */
    { 0x0730, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/12 */
    { 0x0738, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/1/14 */
    { 0x0b00, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/0 */
    { 0x0b08, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/2 */
    { 0x0b10, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/4 */
    { 0x0b18, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/6 */
    { 0x0b20, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/8 */
    { 0x0b28, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/10 */
    { 0x0b30, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/12 */
    { 0x0b38, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/2/14 */
    { 0x0f00, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/0 */
    { 0x0f08, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/2 */
    { 0x0f10, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/4 */
    { 0x0f18, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/6 */
    { 0x0f20, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/8 */
    { 0x0f28, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/10 */
    { 0x0f30, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/12 */
    { 0x0f38, 0x539e, 0xf981, RTFLOAT80U_INIT_C(0,0x3d98519e38e32ea8,15747), INT16_C(-3) }, /* #30/3/14 */
    { 0x0143, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/0 */
    { 0x014b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/2 */
    { 0x0153, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/4 */
    { 0x015b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/6 */
    { 0x0163, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/8 */
    { 0x016b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/10 */
    { 0x0173, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/12 */
    { 0x017b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/0/14 */
    { 0x0543, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/0 */
    { 0x054b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/2 */
    { 0x0553, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/4 */
    { 0x055b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/6 */
    { 0x0563, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/8 */
    { 0x056b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/10 */
    { 0x0573, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/12 */
    { 0x057b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/1/14 */
    { 0x0943, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/0 */
    { 0x094b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/2 */
    { 0x0953, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/4 */
    { 0x095b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/6 */
    { 0x0963, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/8 */
    { 0x096b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/10 */
    { 0x0973, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/12 */
    { 0x097b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/2/14 */
    { 0x0d43, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/0 */
    { 0x0d4b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/2 */
    { 0x0d53, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/4 */
    { 0x0d5b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/6 */
    { 0x0d63, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/8 */
    { 0x0d6b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/10 */
    { 0x0d73, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/12 */
    { 0x0d7b, 0x5789, 0x4501, RTFLOAT80U_INIT_C(1,0x7689faf32cd9,32767), INT16_MIN }, /* #31/3/14 */
    { 0x0207, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/0 */
    { 0x020f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/2 */
    { 0x0217, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/4 */
    { 0x021f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/6 */
    { 0x0227, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/8 */
    { 0x022f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/10 */
    { 0x0237, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/12 */
    { 0x023f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/0/14 */
    { 0x0607, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/0 */
    { 0x060f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/2 */
    { 0x0617, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/4 */
    { 0x061f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/6 */
    { 0x0627, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/8 */
    { 0x062f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/10 */
    { 0x0637, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/12 */
    { 0x063f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/1/14 */
    { 0x0a07, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/0 */
    { 0x0a0f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/2 */
    { 0x0a17, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/4 */
    { 0x0a1f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/6 */
    { 0x0a27, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/8 */
    { 0x0a2f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/10 */
    { 0x0a37, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/12 */
    { 0x0a3f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/2/14 */
    { 0x0e07, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/0 */
    { 0x0e0f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/2 */
    { 0x0e17, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/4 */
    { 0x0e1f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/6 */
    { 0x0e27, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/8 */
    { 0x0e2f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/10 */
    { 0x0e37, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/12 */
    { 0x0e3f, 0x480b, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000094,32767), INT16_MIN }, /* #32/3/14 */
    { 0x0204, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/0 */
    { 0x020c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/2 */
    { 0x0214, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/4 */
    { 0x021c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/6 */
    { 0x0224, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/8 */
    { 0x022c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/10 */
    { 0x0234, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/12 */
    { 0x023c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/0/14 */
    { 0x0604, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/0 */
    { 0x060c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/2 */
    { 0x0614, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/4 */
    { 0x061c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/6 */
    { 0x0624, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/8 */
    { 0x062c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/10 */
    { 0x0634, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/12 */
    { 0x063c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/1/14 */
    { 0x0a04, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/0 */
    { 0x0a0c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/2 */
    { 0x0a14, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/4 */
    { 0x0a1c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/6 */
    { 0x0a24, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/8 */
    { 0x0a2c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/10 */
    { 0x0a34, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/12 */
    { 0x0a3c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/2/14 */
    { 0x0e04, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/0 */
    { 0x0e0c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/2 */
    { 0x0e14, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/4 */
    { 0x0e1c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/6 */
    { 0x0e24, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/8 */
    { 0x0e2c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/10 */
    { 0x0e34, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/12 */
    { 0x0e3c, 0xf3fa, 0xf981, RTFLOAT80U_INIT_C(0,0x5c2d7f3498782aa5,11310), INT16_C(-3) }, /* #33/3/14 */
    { 0x0100, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/0 */
    { 0x0108, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/2 */
    { 0x0110, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/4 */
    { 0x0118, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/6 */
    { 0x0120, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/8 */
    { 0x0128, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/10 */
    { 0x0130, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/12 */
    { 0x0138, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/0/14 */
    { 0x0500, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/0 */
    { 0x0508, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/2 */
    { 0x0510, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/4 */
    { 0x0518, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/6 */
    { 0x0520, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/8 */
    { 0x0528, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/10 */
    { 0x0530, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/12 */
    { 0x0538, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/1/14 */
    { 0x0900, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/0 */
    { 0x0908, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/2 */
    { 0x0910, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/4 */
    { 0x0918, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/6 */
    { 0x0920, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/8 */
    { 0x0928, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/10 */
    { 0x0930, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/12 */
    { 0x0938, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/2/14 */
    { 0x0d00, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/0 */
    { 0x0d08, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/2 */
    { 0x0d10, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/4 */
    { 0x0d18, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/6 */
    { 0x0d20, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/8 */
    { 0x0d28, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/10 */
    { 0x0d30, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/12 */
    { 0x0d38, 0x8602, 0xbc81, RTFLOAT80U_INIT_C(0,0x54efe71bb5c93b57,22646), INT16_C(-3) }, /* #34/3/14 */
    { 0x0104, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/0 */
    { 0x010c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/2 */
    { 0x0114, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/4 */
    { 0x011c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/6 */
    { 0x0124, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/8 */
    { 0x012c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/10 */
    { 0x0134, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/12 */
    { 0x013c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/0/14 */
    { 0x0504, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/0 */
    { 0x050c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/2 */
    { 0x0514, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/4 */
    { 0x051c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/6 */
    { 0x0524, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/8 */
    { 0x052c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/10 */
    { 0x0534, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/12 */
    { 0x053c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/1/14 */
    { 0x0904, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/0 */
    { 0x090c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/2 */
    { 0x0914, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/4 */
    { 0x091c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/6 */
    { 0x0924, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/8 */
    { 0x092c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/10 */
    { 0x0934, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/12 */
    { 0x093c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/2/14 */
    { 0x0d04, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/0 */
    { 0x0d0c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/2 */
    { 0x0d14, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/4 */
    { 0x0d1c, 0xcbef, 0xc1a0, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/6 */
    { 0x0d24, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/8 */
    { 0x0d2c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/10 */
    { 0x0d34, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/12 */
    { 0x0d3c, 0xcbef, 0x4120, RTFLOAT80U_INIT_C(0,0xbbd23ca289c71bc4,0), INT16_C(0) }, /* #35/3/14 */
    { 0x0042, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/0 */
    { 0x004a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/2 */
    { 0x0052, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/4 */
    { 0x005a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/6 */
    { 0x0062, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/8 */
    { 0x006a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/10 */
    { 0x0072, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/12 */
    { 0x007a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/0/14 */
    { 0x0442, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/0 */
    { 0x044a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/2 */
    { 0x0452, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/4 */
    { 0x045a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/6 */
    { 0x0462, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/8 */
    { 0x046a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/10 */
    { 0x0472, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/12 */
    { 0x047a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/1/14 */
    { 0x0842, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/0 */
    { 0x084a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/2 */
    { 0x0852, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/4 */
    { 0x085a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/6 */
    { 0x0862, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/8 */
    { 0x086a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/10 */
    { 0x0872, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/12 */
    { 0x087a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/2/14 */
    { 0x0c42, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/0 */
    { 0x0c4a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/2 */
    { 0x0c52, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/4 */
    { 0x0c5a, 0x9f65, 0x85a0, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/6 */
    { 0x0c62, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/8 */
    { 0x0c6a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/10 */
    { 0x0c72, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/12 */
    { 0x0c7a, 0x9f65, 0x0520, RTFLOAT80U_INIT_C(1,0xb1dc9e0efad5950c,16383), INT16_C(-1) }, /* #36/3/14 */
    { 0x0307, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/0 */
    { 0x030f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/2 */
    { 0x0317, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/4 */
    { 0x031f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/6 */
    { 0x0327, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/8 */
    { 0x032f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/10 */
    { 0x0337, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/12 */
    { 0x033f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/0/14 */
    { 0x0707, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/0 */
    { 0x070f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/2 */
    { 0x0717, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/4 */
    { 0x071f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/6 */
    { 0x0727, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/8 */
    { 0x072f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/10 */
    { 0x0737, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/12 */
    { 0x073f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/1/14 */
    { 0x0b07, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/0 */
    { 0x0b0f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/2 */
    { 0x0b17, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/4 */
    { 0x0b1f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/6 */
    { 0x0b27, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/8 */
    { 0x0b2f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/10 */
    { 0x0b37, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/12 */
    { 0x0b3f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/2/14 */
    { 0x0f07, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/0 */
    { 0x0f0f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/2 */
    { 0x0f17, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/4 */
    { 0x0f1f, 0x845b, 0x84a0, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/6 */
    { 0x0f27, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/8 */
    { 0x0f2f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/10 */
    { 0x0f37, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/12 */
    { 0x0f3f, 0x845b, 0x0420, RTFLOAT80U_INIT_C(0,0xab6d0d1569f40e9b,16397), INT16_C(21942) }, /* #37/3/14 */
    { 0x0300, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/0 */
    { 0x0308, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/2 */
    { 0x0310, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/4 */
    { 0x0318, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/6 */
    { 0x0320, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/8 */
    { 0x0328, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/10 */
    { 0x0330, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/12 */
    { 0x0338, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/0/14 */
    { 0x0700, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/0 */
    { 0x0708, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/2 */
    { 0x0710, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/4 */
    { 0x0718, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/6 */
    { 0x0720, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/8 */
    { 0x0728, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/10 */
    { 0x0730, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/12 */
    { 0x0738, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/1/14 */
    { 0x0b00, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/0 */
    { 0x0b08, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/2 */
    { 0x0b10, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/4 */
    { 0x0b18, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/6 */
    { 0x0b20, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/8 */
    { 0x0b28, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/10 */
    { 0x0b30, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/12 */
    { 0x0b38, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/2/14 */
    { 0x0f00, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/0 */
    { 0x0f08, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/2 */
    { 0x0f10, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/4 */
    { 0x0f18, 0xd8e6, 0xc0a0, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/6 */
    { 0x0f20, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/8 */
    { 0x0f28, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/10 */
    { 0x0f30, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/12 */
    { 0x0f38, 0xd8e6, 0x4020, RTFLOAT80U_INIT_C(0,0xa4577df9cc0c88ea,16383), INT16_C(1) }, /* #38/3/14 */
    { 0x0243, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/0 */
    { 0x024b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/2 */
    { 0x0253, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/4 */
    { 0x025b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/6 */
    { 0x0263, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/8 */
    { 0x026b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/10 */
    { 0x0273, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/12 */
    { 0x027b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/0/14 */
    { 0x0643, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/0 */
    { 0x064b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/2 */
    { 0x0653, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/4 */
    { 0x065b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/6 */
    { 0x0663, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/8 */
    { 0x066b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/10 */
    { 0x0673, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/12 */
    { 0x067b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/1/14 */
    { 0x0a43, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/0 */
    { 0x0a4b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/2 */
    { 0x0a53, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/4 */
    { 0x0a5b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/6 */
    { 0x0a63, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/8 */
    { 0x0a6b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/10 */
    { 0x0a73, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/12 */
    { 0x0a7b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/2/14 */
    { 0x0e43, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/0 */
    { 0x0e4b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/2 */
    { 0x0e53, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/4 */
    { 0x0e5b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/6 */
    { 0x0e63, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/8 */
    { 0x0e6b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/10 */
    { 0x0e73, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/12 */
    { 0x0e7b, 0x53e9, 0x4101, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #39/3/14 */
    { 0x0141, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/0 */
    { 0x0149, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/2 */
    { 0x0151, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/4 */
    { 0x0159, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/6 */
    { 0x0161, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/8 */
    { 0x0169, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/10 */
    { 0x0171, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/12 */
    { 0x0179, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/0/14 */
    { 0x0541, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/0 */
    { 0x0549, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/2 */
    { 0x0551, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/4 */
    { 0x0559, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/6 */
    { 0x0561, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/8 */
    { 0x0569, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/10 */
    { 0x0571, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/12 */
    { 0x0579, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/1/14 */
    { 0x0941, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/0 */
    { 0x0949, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/2 */
    { 0x0951, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/4 */
    { 0x0959, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/6 */
    { 0x0961, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/8 */
    { 0x0969, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/10 */
    { 0x0971, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/12 */
    { 0x0979, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/2/14 */
    { 0x0d41, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/0 */
    { 0x0d49, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/2 */
    { 0x0d51, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/4 */
    { 0x0d59, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/6 */
    { 0x0d61, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/8 */
    { 0x0d69, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/10 */
    { 0x0d71, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/12 */
    { 0x0d79, 0xa6b8, 0x0401, RTFLOAT80U_INIT_C(1,0xa8814a4809331ab1,32767), INT16_MIN }, /* #40/3/14 */
    { 0x0346, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/0 */
    { 0x034e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/2 */
    { 0x0356, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/4 */
    { 0x035e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/6 */
    { 0x0366, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/8 */
    { 0x036e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/10 */
    { 0x0376, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/12 */
    { 0x037e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/0/14 */
    { 0x0746, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/0 */
    { 0x074e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/2 */
    { 0x0756, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/4 */
    { 0x075e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/6 */
    { 0x0766, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/8 */
    { 0x076e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/10 */
    { 0x0776, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/12 */
    { 0x077e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/1/14 */
    { 0x0b46, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/0 */
    { 0x0b4e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/2 */
    { 0x0b56, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/4 */
    { 0x0b5e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/6 */
    { 0x0b66, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/8 */
    { 0x0b6e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/10 */
    { 0x0b76, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/12 */
    { 0x0b7e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/2/14 */
    { 0x0f46, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/0 */
    { 0x0f4e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/2 */
    { 0x0f56, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/4 */
    { 0x0f5e, 0xcae0, 0xc0a0, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/6 */
    { 0x0f66, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/8 */
    { 0x0f6e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/10 */
    { 0x0f76, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/12 */
    { 0x0f7e, 0xcae0, 0x4020, RTFLOAT80U_INIT_C(0,0xb9c8c5a2659f11bb,16397), INT16_C(23780) }, /* #41/3/14 */
    { 0x0241, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/0 */
    { 0x0249, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/2 */
    { 0x0251, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/4 */
    { 0x0259, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/6 */
    { 0x0261, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/8 */
    { 0x0269, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/10 */
    { 0x0271, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/12 */
    { 0x0279, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/0/14 */
    { 0x0641, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/0 */
    { 0x0649, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/2 */
    { 0x0651, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/4 */
    { 0x0659, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/6 */
    { 0x0661, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/8 */
    { 0x0669, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/10 */
    { 0x0671, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/12 */
    { 0x0679, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/1/14 */
    { 0x0a41, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/0 */
    { 0x0a49, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/2 */
    { 0x0a51, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/4 */
    { 0x0a59, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/6 */
    { 0x0a61, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/8 */
    { 0x0a69, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/10 */
    { 0x0a71, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/12 */
    { 0x0a79, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/2/14 */
    { 0x0e41, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/0 */
    { 0x0e49, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/2 */
    { 0x0e51, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/4 */
    { 0x0e59, 0xb6f6, 0x84a0, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/6 */
    { 0x0e61, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/8 */
    { 0x0e69, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/10 */
    { 0x0e71, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/12 */
    { 0x0e79, 0xb6f6, 0x0420, RTFLOAT80U_INIT_C(0,0x2c2edcea4ea17d3,0), INT16_C(0) }, /* #42/3/14 */
    { 0x0302, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/0 */
    { 0x030a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/2 */
    { 0x0312, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/4 */
    { 0x031a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/6 */
    { 0x0322, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/8 */
    { 0x032a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/10 */
    { 0x0332, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/12 */
    { 0x033a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/0/14 */
    { 0x0702, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/0 */
    { 0x070a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/2 */
    { 0x0712, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/4 */
    { 0x071a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/6 */
    { 0x0722, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/8 */
    { 0x072a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/10 */
    { 0x0732, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/12 */
    { 0x073a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/1/14 */
    { 0x0b02, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/0 */
    { 0x0b0a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/2 */
    { 0x0b12, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/4 */
    { 0x0b1a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/6 */
    { 0x0b22, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/8 */
    { 0x0b2a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/10 */
    { 0x0b32, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/12 */
    { 0x0b3a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/2/14 */
    { 0x0f02, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/0 */
    { 0x0f0a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/2 */
    { 0x0f12, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/4 */
    { 0x0f1a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/6 */
    { 0x0f22, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/8 */
    { 0x0f2a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/10 */
    { 0x0f32, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/12 */
    { 0x0f3a, 0x376d, 0xbd81, RTFLOAT80U_INIT_C(1,0xe45611520a4bf241,32438), INT16_C(-3) }, /* #43/3/14 */
    { 0x0341, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/0 */
    { 0x0349, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/2 */
    { 0x0351, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/4 */
    { 0x0359, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/6 */
    { 0x0361, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/8 */
    { 0x0369, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/10 */
    { 0x0371, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/12 */
    { 0x0379, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/0/14 */
    { 0x0741, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/0 */
    { 0x0749, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/2 */
    { 0x0751, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/4 */
    { 0x0759, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/6 */
    { 0x0761, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/8 */
    { 0x0769, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/10 */
    { 0x0771, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/12 */
    { 0x0779, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/1/14 */
    { 0x0b41, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/0 */
    { 0x0b49, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/2 */
    { 0x0b51, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/4 */
    { 0x0b59, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/6 */
    { 0x0b61, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/8 */
    { 0x0b69, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/10 */
    { 0x0b71, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/12 */
    { 0x0b79, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/2/14 */
    { 0x0f41, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/0 */
    { 0x0f49, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/2 */
    { 0x0f51, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/4 */
    { 0x0f59, 0x0253, 0x80a0, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/6 */
    { 0x0f61, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/8 */
    { 0x0f69, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/10 */
    { 0x0f71, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/12 */
    { 0x0f79, 0x0253, 0x0020, RTFLOAT80U_INIT_C(1,0xbb28594911ff6cbf,16397), INT16_C(-23956) }, /* #44/3/14 */
    { 0x0306, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/0 */
    { 0x030e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/2 */
    { 0x0316, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/4 */
    { 0x031e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/6 */
    { 0x0326, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/8 */
    { 0x032e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/10 */
    { 0x0336, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/12 */
    { 0x033e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/0/14 */
    { 0x0706, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/0 */
    { 0x070e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/2 */
    { 0x0716, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/4 */
    { 0x071e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/6 */
    { 0x0726, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/8 */
    { 0x072e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/10 */
    { 0x0736, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/12 */
    { 0x073e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/1/14 */
    { 0x0b06, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/0 */
    { 0x0b0e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/2 */
    { 0x0b16, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/4 */
    { 0x0b1e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/6 */
    { 0x0b26, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/8 */
    { 0x0b2e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/10 */
    { 0x0b36, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/12 */
    { 0x0b3e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/2/14 */
    { 0x0f06, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/0 */
    { 0x0f0e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/2 */
    { 0x0f16, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/4 */
    { 0x0f1e, 0xbebc, 0x84a0, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/6 */
    { 0x0f26, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/8 */
    { 0x0f2e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/10 */
    { 0x0f36, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/12 */
    { 0x0f3e, 0xbebc, 0x0420, RTFLOAT80U_INIT_C(0,0xb0b4b14c7c66235d,16383), INT16_C(1) }, /* #45/3/14 */
    { 0x0045, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/0 */
    { 0x004d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/2 */
    { 0x0055, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/4 */
    { 0x005d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/6 */
    { 0x0065, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/8 */
    { 0x006d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/10 */
    { 0x0075, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/12 */
    { 0x007d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/0/14 */
    { 0x0445, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/0 */
    { 0x044d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/2 */
    { 0x0455, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/4 */
    { 0x045d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/6 */
    { 0x0465, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/8 */
    { 0x046d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/10 */
    { 0x0475, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/12 */
    { 0x047d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/1/14 */
    { 0x0845, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/0 */
    { 0x084d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/2 */
    { 0x0855, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/4 */
    { 0x085d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/6 */
    { 0x0865, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/8 */
    { 0x086d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/10 */
    { 0x0875, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/12 */
    { 0x087d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/2/14 */
    { 0x0c45, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/0 */
    { 0x0c4d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/2 */
    { 0x0c55, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/4 */
    { 0x0c5d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/6 */
    { 0x0c65, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/8 */
    { 0x0c6d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/10 */
    { 0x0c75, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/12 */
    { 0x0c7d, 0xc250, 0x4001, RTFLOAT80U_INIT_C(0,0xa9bbea157bd3f0db,17204), INT16_MIN }, /* #46/3/14 */
    { 0x0040, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/0 */
    { 0x0048, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/2 */
    { 0x0050, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/4 */
    { 0x0058, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/6 */
    { 0x0060, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/8 */
    { 0x0068, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/10 */
    { 0x0070, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/12 */
    { 0x0078, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/0/14 */
    { 0x0440, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/0 */
    { 0x0448, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/2 */
    { 0x0450, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/4 */
    { 0x0458, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/6 */
    { 0x0460, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/8 */
    { 0x0468, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/10 */
    { 0x0470, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/12 */
    { 0x0478, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/1/14 */
    { 0x0840, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/0 */
    { 0x0848, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/2 */
    { 0x0850, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/4 */
    { 0x0858, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/6 */
    { 0x0860, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/8 */
    { 0x0868, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/10 */
    { 0x0870, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/12 */
    { 0x0878, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/2/14 */
    { 0x0c40, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/0 */
    { 0x0c48, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/2 */
    { 0x0c50, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/4 */
    { 0x0c58, 0x7001, 0xc0a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/6 */
    { 0x0c60, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/8 */
    { 0x0c68, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/10 */
    { 0x0c70, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/12 */
    { 0x0c78, 0x7001, 0x4020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16397), INT16_MAX }, /* #47/3/14 */
    { 0x0041, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/0 */
    { 0x0049, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/2 */
    { 0x0051, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/4 */
    { 0x0059, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/6 */
    { 0x0061, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/8 */
    { 0x0069, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/10 */
    { 0x0071, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/12 */
    { 0x0079, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/0/14 */
    { 0x0441, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/0 */
    { 0x0449, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/2 */
    { 0x0451, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/4 */
    { 0x0459, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/6 */
    { 0x0461, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/8 */
    { 0x0469, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/10 */
    { 0x0471, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/12 */
    { 0x0479, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/1/14 */
    { 0x0841, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/0 */
    { 0x0849, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/2 */
    { 0x0851, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/4 */
    { 0x0859, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/6 */
    { 0x0861, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/8 */
    { 0x0869, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/10 */
    { 0x0871, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/12 */
    { 0x0879, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/2/14 */
    { 0x0c41, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/0 */
    { 0x0c49, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/2 */
    { 0x0c51, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/4 */
    { 0x0c59, 0x6a2f, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/6 */
    { 0x0c61, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/8 */
    { 0x0c69, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/10 */
    { 0x0c71, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/12 */
    { 0x0c79, 0x6a2f, 0x4020, RTFLOAT80U_INIT_C(1,0x8129dbc533676c38,16397), INT16_C(-16532) }, /* #48/3/14 */
    { 0x0242, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/0 */
    { 0x024a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/2 */
    { 0x0252, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/4 */
    { 0x025a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/6 */
    { 0x0262, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/8 */
    { 0x026a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/10 */
    { 0x0272, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/12 */
    { 0x027a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/0/14 */
    { 0x0642, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/0 */
    { 0x064a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/2 */
    { 0x0652, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/4 */
    { 0x065a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/6 */
    { 0x0662, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/8 */
    { 0x066a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/10 */
    { 0x0672, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/12 */
    { 0x067a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/1/14 */
    { 0x0a42, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/0 */
    { 0x0a4a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/2 */
    { 0x0a52, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/4 */
    { 0x0a5a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/6 */
    { 0x0a62, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/8 */
    { 0x0a6a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/10 */
    { 0x0a72, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/12 */
    { 0x0a7a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/2/14 */
    { 0x0e42, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/0 */
    { 0x0e4a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/2 */
    { 0x0e52, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/4 */
    { 0x0e5a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/6 */
    { 0x0e62, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/8 */
    { 0x0e6a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/10 */
    { 0x0e72, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/12 */
    { 0x0e7a, 0x4183, 0xf981, RTFLOAT80U_INIT_C(1,0x8b926a45f7824f7e,19248), INT16_C(-3) }, /* #49/3/14 */
    { 0x0007, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/0 */
    { 0x000f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/2 */
    { 0x0017, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/4 */
    { 0x001f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/6 */
    { 0x0027, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/8 */
    { 0x002f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/10 */
    { 0x0037, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/12 */
    { 0x003f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/0/14 */
    { 0x0407, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/0 */
    { 0x040f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/2 */
    { 0x0417, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/4 */
    { 0x041f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/6 */
    { 0x0427, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/8 */
    { 0x042f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/10 */
    { 0x0437, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/12 */
    { 0x043f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/1/14 */
    { 0x0807, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/0 */
    { 0x080f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/2 */
    { 0x0817, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/4 */
    { 0x081f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/6 */
    { 0x0827, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/8 */
    { 0x082f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/10 */
    { 0x0837, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/12 */
    { 0x083f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/2/14 */
    { 0x0c07, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/0 */
    { 0x0c0f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/2 */
    { 0x0c17, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/4 */
    { 0x0c1f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/6 */
    { 0x0c27, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/8 */
    { 0x0c2f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/10 */
    { 0x0c37, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/12 */
    { 0x0c3f, 0x6832, 0x4001, RTFLOAT80U_INIT_C(0,0x6121d3e8e2319d0e,22835), INT16_MIN }, /* #50/3/14 */
    { 0x0346, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/0 */
    { 0x034e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/2 */
    { 0x0356, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/4 */
    { 0x035e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/6 */
    { 0x0366, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/8 */
    { 0x036e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/10 */
    { 0x0376, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/12 */
    { 0x037e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/0/14 */
    { 0x0746, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/0 */
    { 0x074e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/2 */
    { 0x0756, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/4 */
    { 0x075e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/6 */
    { 0x0766, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/8 */
    { 0x076e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/10 */
    { 0x0776, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/12 */
    { 0x077e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/1/14 */
    { 0x0b46, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/0 */
    { 0x0b4e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/2 */
    { 0x0b56, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/4 */
    { 0x0b5e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/6 */
    { 0x0b66, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/8 */
    { 0x0b6e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/10 */
    { 0x0b76, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/12 */
    { 0x0b7e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/2/14 */
    { 0x0f46, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/0 */
    { 0x0f4e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/2 */
    { 0x0f56, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/4 */
    { 0x0f5e, 0xb57d, 0x85a0, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/6 */
    { 0x0f66, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/8 */
    { 0x0f6e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/10 */
    { 0x0f76, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/12 */
    { 0x0f7e, 0xb57d, 0x0520, RTFLOAT80U_INIT_C(0,0xbeb0558e3fc9fa1b,4810), INT16_C(0) }, /* #51/3/14 */
    { 0x0142, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/0 */
    { 0x014a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/2 */
    { 0x0152, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/4 */
    { 0x015a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/6 */
    { 0x0162, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/8 */
    { 0x016a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/10 */
    { 0x0172, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/12 */
    { 0x017a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/0/14 */
    { 0x0542, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/0 */
    { 0x054a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/2 */
    { 0x0552, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/4 */
    { 0x055a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/6 */
    { 0x0562, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/8 */
    { 0x056a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/10 */
    { 0x0572, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/12 */
    { 0x057a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/1/14 */
    { 0x0942, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/0 */
    { 0x094a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/2 */
    { 0x0952, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/4 */
    { 0x095a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/6 */
    { 0x0962, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/8 */
    { 0x096a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/10 */
    { 0x0972, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/12 */
    { 0x097a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/2/14 */
    { 0x0d42, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/0 */
    { 0x0d4a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/2 */
    { 0x0d52, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/4 */
    { 0x0d5a, 0x0fd2, 0x85a0, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/6 */
    { 0x0d62, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/8 */
    { 0x0d6a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/10 */
    { 0x0d72, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/12 */
    { 0x0d7a, 0x0fd2, 0x0520, RTFLOAT80U_INIT_C(0,0x7ab2534cfc053e9,0), INT16_C(0) }, /* #52/3/14 */
    { 0x0141, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/0 */
    { 0x0149, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/2 */
    { 0x0151, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/4 */
    { 0x0159, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/6 */
    { 0x0161, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/8 */
    { 0x0169, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/10 */
    { 0x0171, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/12 */
    { 0x0179, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/0/14 */
    { 0x0541, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/0 */
    { 0x0549, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/2 */
    { 0x0551, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/4 */
    { 0x0559, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/6 */
    { 0x0561, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/8 */
    { 0x0569, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/10 */
    { 0x0571, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/12 */
    { 0x0579, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/1/14 */
    { 0x0941, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/0 */
    { 0x0949, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/2 */
    { 0x0951, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/4 */
    { 0x0959, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/6 */
    { 0x0961, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/8 */
    { 0x0969, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/10 */
    { 0x0971, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/12 */
    { 0x0979, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/2/14 */
    { 0x0d41, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/0 */
    { 0x0d49, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/2 */
    { 0x0d51, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/4 */
    { 0x0d59, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/6 */
    { 0x0d61, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/8 */
    { 0x0d69, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/10 */
    { 0x0d71, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/12 */
    { 0x0d79, 0x2e11, 0x0401, RTFLOAT80U_INIT_C(1,0xfc42fa2a8caab2bf,22574), INT16_MIN }, /* #53/3/14 */
    { 0x0306, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/0 */
    { 0x030e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/2 */
    { 0x0316, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/4 */
    { 0x031e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/6 */
    { 0x0326, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/8 */
    { 0x032e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/10 */
    { 0x0336, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/12 */
    { 0x033e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/0/14 */
    { 0x0706, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/0 */
    { 0x070e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/2 */
    { 0x0716, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/4 */
    { 0x071e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/6 */
    { 0x0726, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/8 */
    { 0x072e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/10 */
    { 0x0736, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/12 */
    { 0x073e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/1/14 */
    { 0x0b06, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/0 */
    { 0x0b0e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/2 */
    { 0x0b16, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/4 */
    { 0x0b1e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/6 */
    { 0x0b26, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/8 */
    { 0x0b2e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/10 */
    { 0x0b36, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/12 */
    { 0x0b3e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/2/14 */
    { 0x0f06, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/0 */
    { 0x0f0e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/2 */
    { 0x0f16, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/4 */
    { 0x0f1e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/6 */
    { 0x0f26, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/8 */
    { 0x0f2e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/10 */
    { 0x0f36, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/12 */
    { 0x0f3e, 0x7853, 0xf881, RTFLOAT80U_INIT_C(1,0xc903af47dd27e,26047), INT16_C(-3) }, /* #54/3/14 */
    { 0x0204, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/0 */
    { 0x020c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/2 */
    { 0x0214, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/4 */
    { 0x021c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/6 */
    { 0x0224, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/8 */
    { 0x022c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/10 */
    { 0x0234, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/12 */
    { 0x023c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/0/14 */
    { 0x0604, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/0 */
    { 0x060c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/2 */
    { 0x0614, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/4 */
    { 0x061c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/6 */
    { 0x0624, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/8 */
    { 0x062c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/10 */
    { 0x0634, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/12 */
    { 0x063c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/1/14 */
    { 0x0a04, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/0 */
    { 0x0a0c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/2 */
    { 0x0a14, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/4 */
    { 0x0a1c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/6 */
    { 0x0a24, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/8 */
    { 0x0a2c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/10 */
    { 0x0a34, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/12 */
    { 0x0a3c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/2/14 */
    { 0x0e04, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/0 */
    { 0x0e0c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/2 */
    { 0x0e14, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/4 */
    { 0x0e1c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/6 */
    { 0x0e24, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/8 */
    { 0x0e2c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/10 */
    { 0x0e34, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/12 */
    { 0x0e3c, 0xb673, 0xbc81, RTFLOAT80U_INIT_C(1,0x2a42aa6b15f55,7073), INT16_C(-3) }, /* #55/3/14 */
    { 0x0147, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/0 */
    { 0x014f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/2 */
    { 0x0157, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/4 */
    { 0x015f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/6 */
    { 0x0167, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/8 */
    { 0x016f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/10 */
    { 0x0177, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/12 */
    { 0x017f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/0/14 */
    { 0x0547, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/0 */
    { 0x054f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/2 */
    { 0x0557, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/4 */
    { 0x055f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/6 */
    { 0x0567, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/8 */
    { 0x056f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/10 */
    { 0x0577, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/12 */
    { 0x057f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/1/14 */
    { 0x0947, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/0 */
    { 0x094f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/2 */
    { 0x0957, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/4 */
    { 0x095f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/6 */
    { 0x0967, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/8 */
    { 0x096f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/10 */
    { 0x0977, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/12 */
    { 0x097f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/2/14 */
    { 0x0d47, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/0 */
    { 0x0d4f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/2 */
    { 0x0d57, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/4 */
    { 0x0d5f, 0xb6e4, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/6 */
    { 0x0d67, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/8 */
    { 0x0d6f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/10 */
    { 0x0d77, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/12 */
    { 0x0d7f, 0xb6e4, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffffc,16397), INT16_MAX }, /* #56/3/14 */
    { 0x0142, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/0 */
    { 0x014a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/2 */
    { 0x0152, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/4 */
    { 0x015a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/6 */
    { 0x0162, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/8 */
    { 0x016a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/10 */
    { 0x0172, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/12 */
    { 0x017a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/0/14 */
    { 0x0542, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/0 */
    { 0x054a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/2 */
    { 0x0552, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/4 */
    { 0x055a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/6 */
    { 0x0562, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/8 */
    { 0x056a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/10 */
    { 0x0572, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/12 */
    { 0x057a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/1/14 */
    { 0x0942, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/0 */
    { 0x094a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/2 */
    { 0x0952, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/4 */
    { 0x095a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/6 */
    { 0x0962, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/8 */
    { 0x096a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/10 */
    { 0x0972, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/12 */
    { 0x097a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/2/14 */
    { 0x0d42, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/0 */
    { 0x0d4a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/2 */
    { 0x0d52, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/4 */
    { 0x0d5a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/6 */
    { 0x0d62, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/8 */
    { 0x0d6a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/10 */
    { 0x0d72, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/12 */
    { 0x0d7a, 0x89a0, 0xb981, RTFLOAT80U_INIT_C(1,0xe941ce2c542ba9e0,32767), INT16_C(-3) }, /* #57/3/14 */
    { 0x0047, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/0 */
    { 0x004f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/2 */
    { 0x0057, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/4 */
    { 0x005f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/6 */
    { 0x0067, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/8 */
    { 0x006f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/10 */
    { 0x0077, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/12 */
    { 0x007f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/0/14 */
    { 0x0447, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/0 */
    { 0x044f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/2 */
    { 0x0457, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/4 */
    { 0x045f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/6 */
    { 0x0467, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/8 */
    { 0x046f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/10 */
    { 0x0477, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/12 */
    { 0x047f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/1/14 */
    { 0x0847, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/0 */
    { 0x084f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/2 */
    { 0x0857, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/4 */
    { 0x085f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/6 */
    { 0x0867, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/8 */
    { 0x086f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/10 */
    { 0x0877, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/12 */
    { 0x087f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/2/14 */
    { 0x0c47, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/0 */
    { 0x0c4f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/2 */
    { 0x0c57, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/4 */
    { 0x0c5f, 0xce43, 0xc4a0, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/6 */
    { 0x0c67, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/8 */
    { 0x0c6f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/10 */
    { 0x0c77, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/12 */
    { 0x0c7f, 0xce43, 0x4420, RTFLOAT80U_INIT_C(1,0xa1fb1a1aea1f183a,16383), INT16_C(-1) }, /* #58/3/14 */
    { 0x0040, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/0 */
    { 0x0048, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/2 */
    { 0x0050, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/4 */
    { 0x0058, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/6 */
    { 0x0060, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/8 */
    { 0x0068, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/10 */
    { 0x0070, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/12 */
    { 0x0078, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/0/14 */
    { 0x0440, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/0 */
    { 0x0448, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/2 */
    { 0x0450, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/4 */
    { 0x0458, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/6 */
    { 0x0460, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/8 */
    { 0x0468, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/10 */
    { 0x0470, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/12 */
    { 0x0478, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/1/14 */
    { 0x0840, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/0 */
    { 0x0848, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/2 */
    { 0x0850, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/4 */
    { 0x0858, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/6 */
    { 0x0860, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/8 */
    { 0x0868, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/10 */
    { 0x0870, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/12 */
    { 0x0878, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/2/14 */
    { 0x0c40, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/0 */
    { 0x0c48, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/2 */
    { 0x0c50, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/4 */
    { 0x0c58, 0x948b, 0x84a0, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/6 */
    { 0x0c60, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/8 */
    { 0x0c68, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/10 */
    { 0x0c70, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/12 */
    { 0x0c78, 0x948b, 0x0420, RTFLOAT80U_INIT_C(1,0x800169b94499520d,0), INT16_C(0) }, /* #59/3/14 */
    { 0x0343, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/0 */
    { 0x034b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/2 */
    { 0x0353, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/4 */
    { 0x035b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/6 */
    { 0x0363, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/8 */
    { 0x036b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/10 */
    { 0x0373, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/12 */
    { 0x037b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/0/14 */
    { 0x0743, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/0 */
    { 0x074b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/2 */
    { 0x0753, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/4 */
    { 0x075b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/6 */
    { 0x0763, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/8 */
    { 0x076b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/10 */
    { 0x0773, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/12 */
    { 0x077b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/1/14 */
    { 0x0b43, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/0 */
    { 0x0b4b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/2 */
    { 0x0b53, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/4 */
    { 0x0b5b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/6 */
    { 0x0b63, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/8 */
    { 0x0b6b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/10 */
    { 0x0b73, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/12 */
    { 0x0b7b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/2/14 */
    { 0x0f43, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/0 */
    { 0x0f4b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/2 */
    { 0x0f53, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/4 */
    { 0x0f5b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/6 */
    { 0x0f63, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/8 */
    { 0x0f6b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/10 */
    { 0x0f73, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/12 */
    { 0x0f7b, 0xaf8e, 0x0501, RTFLOAT80U_INIT_C(0,0xb76d47b39e83ca26,18727), INT16_MIN }, /* #60/3/14 */
    { 0x0047, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/0 */
    { 0x004f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/2 */
    { 0x0057, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/4 */
    { 0x005f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/6 */
    { 0x0067, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/8 */
    { 0x006f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/10 */
    { 0x0077, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/12 */
    { 0x007f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/0/14 */
    { 0x0447, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/0 */
    { 0x044f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/2 */
    { 0x0457, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/4 */
    { 0x045f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/6 */
    { 0x0467, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/8 */
    { 0x046f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/10 */
    { 0x0477, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/12 */
    { 0x047f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/1/14 */
    { 0x0847, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/0 */
    { 0x084f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/2 */
    { 0x0857, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/4 */
    { 0x085f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/6 */
    { 0x0867, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/8 */
    { 0x086f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/10 */
    { 0x0877, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/12 */
    { 0x087f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/2/14 */
    { 0x0c47, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/0 */
    { 0x0c4f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/2 */
    { 0x0c57, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/4 */
    { 0x0c5f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/6 */
    { 0x0c67, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/8 */
    { 0x0c6f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/10 */
    { 0x0c77, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/12 */
    { 0x0c7f, 0x56da, 0x4401, RTFLOAT80U_INIT_C(1,0xdbb0bd9945016003,24094), INT16_MIN }, /* #61/3/14 */
    { 0x0203, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/0 */
    { 0x020b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/2 */
    { 0x0213, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/4 */
    { 0x021b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/6 */
    { 0x0223, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/8 */
    { 0x022b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/10 */
    { 0x0233, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/12 */
    { 0x023b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/0/14 */
    { 0x0603, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/0 */
    { 0x060b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/2 */
    { 0x0613, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/4 */
    { 0x061b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/6 */
    { 0x0623, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/8 */
    { 0x062b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/10 */
    { 0x0633, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/12 */
    { 0x063b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/1/14 */
    { 0x0a03, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/0 */
    { 0x0a0b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/2 */
    { 0x0a13, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/4 */
    { 0x0a1b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/6 */
    { 0x0a23, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/8 */
    { 0x0a2b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/10 */
    { 0x0a33, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/12 */
    { 0x0a3b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/2/14 */
    { 0x0e03, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/0 */
    { 0x0e0b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/2 */
    { 0x0e13, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/4 */
    { 0x0e1b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/6 */
    { 0x0e23, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/8 */
    { 0x0e2b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/10 */
    { 0x0e33, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/12 */
    { 0x0e3b, 0x641f, 0x4401, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_MIN }, /* #62/3/14 */
    { 0x0003, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/0 */
    { 0x000b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/2 */
    { 0x0013, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/4 */
    { 0x001b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/6 */
    { 0x0023, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/8 */
    { 0x002b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/10 */
    { 0x0033, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/12 */
    { 0x003b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/0/14 */
    { 0x0403, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/0 */
    { 0x040b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/2 */
    { 0x0413, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/4 */
    { 0x041b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/6 */
    { 0x0423, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/8 */
    { 0x042b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/10 */
    { 0x0433, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/12 */
    { 0x043b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/1/14 */
    { 0x0803, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/0 */
    { 0x080b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/2 */
    { 0x0813, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/4 */
    { 0x081b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/6 */
    { 0x0823, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/8 */
    { 0x082b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/10 */
    { 0x0833, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/12 */
    { 0x083b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/2/14 */
    { 0x0c03, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/0 */
    { 0x0c0b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/2 */
    { 0x0c13, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/4 */
    { 0x0c1b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/6 */
    { 0x0c23, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/8 */
    { 0x0c2b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/10 */
    { 0x0c33, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/12 */
    { 0x0c3b, 0x1802, 0x0001, RTFLOAT80U_INIT_C(0,0x9449434fc4e6ab2e,30378), INT16_MIN }, /* #63/3/14 */
    { 0x0301, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/0 */
    { 0x0309, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/2 */
    { 0x0311, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/4 */
    { 0x0319, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/6 */
    { 0x0321, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/8 */
    { 0x0329, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/10 */
    { 0x0331, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/12 */
    { 0x0339, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/0/14 */
    { 0x0701, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/0 */
    { 0x0709, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/2 */
    { 0x0711, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/4 */
    { 0x0719, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/6 */
    { 0x0721, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/8 */
    { 0x0729, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/10 */
    { 0x0731, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/12 */
    { 0x0739, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/1/14 */
    { 0x0b01, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/0 */
    { 0x0b09, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/2 */
    { 0x0b11, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/4 */
    { 0x0b19, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/6 */
    { 0x0b21, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/8 */
    { 0x0b29, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/10 */
    { 0x0b31, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/12 */
    { 0x0b39, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/2/14 */
    { 0x0f01, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/0 */
    { 0x0f09, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/2 */
    { 0x0f11, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/4 */
    { 0x0f19, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/6 */
    { 0x0f21, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/8 */
    { 0x0f29, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/10 */
    { 0x0f31, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/12 */
    { 0x0f39, 0xd1aa, 0x4101, RTFLOAT80U_INIT_C(1,0x6abe1dee13b3630e,29826), INT16_MIN }, /* #64/3/14 */
    { 0x0141, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/0 */
    { 0x0149, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/2 */
    { 0x0151, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/4 */
    { 0x0159, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/6 */
    { 0x0161, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/8 */
    { 0x0169, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/10 */
    { 0x0171, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/12 */
    { 0x0179, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/0/14 */
    { 0x0541, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/0 */
    { 0x0549, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/2 */
    { 0x0551, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/4 */
    { 0x0559, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/6 */
    { 0x0561, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/8 */
    { 0x0569, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/10 */
    { 0x0571, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/12 */
    { 0x0579, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/1/14 */
    { 0x0941, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/0 */
    { 0x0949, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/2 */
    { 0x0951, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/4 */
    { 0x0959, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/6 */
    { 0x0961, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/8 */
    { 0x0969, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/10 */
    { 0x0971, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/12 */
    { 0x0979, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/2/14 */
    { 0x0d41, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/0 */
    { 0x0d49, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/2 */
    { 0x0d51, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/4 */
    { 0x0d59, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/6 */
    { 0x0d61, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/8 */
    { 0x0d69, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/10 */
    { 0x0d71, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/12 */
    { 0x0d79, 0x4084, 0x4001, RTFLOAT80U_INIT_C(0,0x1,32767), INT16_MIN }, /* #65/3/14 */
    { 0x0043, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/0 */
    { 0x004b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/2 */
    { 0x0053, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/4 */
    { 0x005b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/6 */
    { 0x0063, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/8 */
    { 0x006b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/10 */
    { 0x0073, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/12 */
    { 0x007b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/0/14 */
    { 0x0443, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/0 */
    { 0x044b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/2 */
    { 0x0453, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/4 */
    { 0x045b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/6 */
    { 0x0463, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/8 */
    { 0x046b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/10 */
    { 0x0473, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/12 */
    { 0x047b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/1/14 */
    { 0x0843, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/0 */
    { 0x084b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/2 */
    { 0x0853, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/4 */
    { 0x085b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/6 */
    { 0x0863, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/8 */
    { 0x086b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/10 */
    { 0x0873, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/12 */
    { 0x087b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/2/14 */
    { 0x0c43, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/0 */
    { 0x0c4b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/2 */
    { 0x0c53, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/4 */
    { 0x0c5b, 0x8551, 0x85a0, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/6 */
    { 0x0c63, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/8 */
    { 0x0c6b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/10 */
    { 0x0c73, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/12 */
    { 0x0c7b, 0x8551, 0x0520, RTFLOAT80U_INIT_C(1,0xd63792030974d0e8,0), INT16_C(0) }, /* #66/3/14 */
    { 0x0100, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/0 */
    { 0x0108, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/2 */
    { 0x0110, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/4 */
    { 0x0118, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/6 */
    { 0x0120, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/8 */
    { 0x0128, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/10 */
    { 0x0130, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/12 */
    { 0x0138, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/0/14 */
    { 0x0500, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/0 */
    { 0x0508, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/2 */
    { 0x0510, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/4 */
    { 0x0518, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/6 */
    { 0x0520, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/8 */
    { 0x0528, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/10 */
    { 0x0530, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/12 */
    { 0x0538, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/1/14 */
    { 0x0900, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/0 */
    { 0x0908, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/2 */
    { 0x0910, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/4 */
    { 0x0918, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/6 */
    { 0x0920, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/8 */
    { 0x0928, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/10 */
    { 0x0930, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/12 */
    { 0x0938, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/2/14 */
    { 0x0d00, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/0 */
    { 0x0d08, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/2 */
    { 0x0d10, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/4 */
    { 0x0d18, 0x7a46, 0xc0a0, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/6 */
    { 0x0d20, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/8 */
    { 0x0d28, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/10 */
    { 0x0d30, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/12 */
    { 0x0d38, 0x7a46, 0x4020, RTFLOAT80U_INIT_C(1,0x13,0), INT16_C(0) }, /* #67/3/14 */
    { 0x0206, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/0 */
    { 0x020e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/2 */
    { 0x0216, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/4 */
    { 0x021e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/6 */
    { 0x0226, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/8 */
    { 0x022e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/10 */
    { 0x0236, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/12 */
    { 0x023e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/0/14 */
    { 0x0606, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/0 */
    { 0x060e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/2 */
    { 0x0616, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/4 */
    { 0x061e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/6 */
    { 0x0626, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/8 */
    { 0x062e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/10 */
    { 0x0636, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/12 */
    { 0x063e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/1/14 */
    { 0x0a06, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/0 */
    { 0x0a0e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/2 */
    { 0x0a16, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/4 */
    { 0x0a1e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/6 */
    { 0x0a26, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/8 */
    { 0x0a2e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/10 */
    { 0x0a36, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/12 */
    { 0x0a3e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/2/14 */
    { 0x0e06, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/0 */
    { 0x0e0e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/2 */
    { 0x0e16, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/4 */
    { 0x0e1e, 0x8d6b, 0x85a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/6 */
    { 0x0e26, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/8 */
    { 0x0e2e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/10 */
    { 0x0e36, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/12 */
    { 0x0e3e, 0x8d6b, 0x0520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #68/3/14 */
    { 0x0345, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/0 */
    { 0x034d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/2 */
    { 0x0355, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/4 */
    { 0x035d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/6 */
    { 0x0365, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/8 */
    { 0x036d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/10 */
    { 0x0375, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/12 */
    { 0x037d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/0/14 */
    { 0x0745, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/0 */
    { 0x074d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/2 */
    { 0x0755, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/4 */
    { 0x075d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/6 */
    { 0x0765, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/8 */
    { 0x076d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/10 */
    { 0x0775, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/12 */
    { 0x077d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/1/14 */
    { 0x0b45, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/0 */
    { 0x0b4d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/2 */
    { 0x0b55, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/4 */
    { 0x0b5d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/6 */
    { 0x0b65, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/8 */
    { 0x0b6d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/10 */
    { 0x0b75, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/12 */
    { 0x0b7d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/2/14 */
    { 0x0f45, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/0 */
    { 0x0f4d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/2 */
    { 0x0f55, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/4 */
    { 0x0f5d, 0xd5be, 0xc5a0, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/6 */
    { 0x0f65, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/8 */
    { 0x0f6d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/10 */
    { 0x0f75, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/12 */
    { 0x0f7d, 0xd5be, 0x4520, RTFLOAT80U_INIT_C(0,0xf639a9687915df65,16397), INT16_C(31516) }, /* #69/3/14 */
    { 0x0201, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/0 */
    { 0x0209, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/2 */
    { 0x0211, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/4 */
    { 0x0219, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/6 */
    { 0x0221, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/8 */
    { 0x0229, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/10 */
    { 0x0231, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/12 */
    { 0x0239, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/0/14 */
    { 0x0601, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/0 */
    { 0x0609, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/2 */
    { 0x0611, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/4 */
    { 0x0619, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/6 */
    { 0x0621, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/8 */
    { 0x0629, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/10 */
    { 0x0631, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/12 */
    { 0x0639, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/1/14 */
    { 0x0a01, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/0 */
    { 0x0a09, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/2 */
    { 0x0a11, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/4 */
    { 0x0a19, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/6 */
    { 0x0a21, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/8 */
    { 0x0a29, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/10 */
    { 0x0a31, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/12 */
    { 0x0a39, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/2/14 */
    { 0x0e01, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/0 */
    { 0x0e09, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/2 */
    { 0x0e11, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/4 */
    { 0x0e19, 0x547c, 0xc4a0, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/6 */
    { 0x0e21, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/8 */
    { 0x0e29, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/10 */
    { 0x0e31, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/12 */
    { 0x0e39, 0x547c, 0x4420, RTFLOAT80U_INIT_C(1,0x7f8ee433a191,0), INT16_C(0) }, /* #70/3/14 */
    { 0x0247, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/0 */
    { 0x024f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/2 */
    { 0x0257, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/4 */
    { 0x025f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/6 */
    { 0x0267, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/8 */
    { 0x026f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/10 */
    { 0x0277, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/12 */
    { 0x027f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/0/14 */
    { 0x0647, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/0 */
    { 0x064f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/2 */
    { 0x0657, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/4 */
    { 0x065f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/6 */
    { 0x0667, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/8 */
    { 0x066f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/10 */
    { 0x0677, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/12 */
    { 0x067f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/1/14 */
    { 0x0a47, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/0 */
    { 0x0a4f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/2 */
    { 0x0a57, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/4 */
    { 0x0a5f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/6 */
    { 0x0a67, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/8 */
    { 0x0a6f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/10 */
    { 0x0a77, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/12 */
    { 0x0a7f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/2/14 */
    { 0x0e47, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/0 */
    { 0x0e4f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/2 */
    { 0x0e57, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/4 */
    { 0x0e5f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/6 */
    { 0x0e67, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/8 */
    { 0x0e6f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/10 */
    { 0x0e77, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/12 */
    { 0x0e7f, 0xe441, 0x4401, RTFLOAT80U_INIT_C(1,0x21fd0d82fe439398,13678), INT16_MIN }, /* #71/3/14 */
    { 0x0303, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/0 */
    { 0x030b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/2 */
    { 0x0313, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/4 */
    { 0x031b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/6 */
    { 0x0323, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/8 */
    { 0x032b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/10 */
    { 0x0333, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/12 */
    { 0x033b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/0/14 */
    { 0x0703, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/0 */
    { 0x070b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/2 */
    { 0x0713, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/4 */
    { 0x071b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/6 */
    { 0x0723, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/8 */
    { 0x072b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/10 */
    { 0x0733, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/12 */
    { 0x073b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/1/14 */
    { 0x0b03, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/0 */
    { 0x0b0b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/2 */
    { 0x0b13, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/4 */
    { 0x0b1b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/6 */
    { 0x0b23, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/8 */
    { 0x0b2b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/10 */
    { 0x0b33, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/12 */
    { 0x0b3b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/2/14 */
    { 0x0f03, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/0 */
    { 0x0f0b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/2 */
    { 0x0f13, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/4 */
    { 0x0f1b, 0xb39b, 0x81a0, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/6 */
    { 0x0f23, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/8 */
    { 0x0f2b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/10 */
    { 0x0f33, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/12 */
    { 0x0f3b, 0xb39b, 0x0120, RTFLOAT80U_INIT_C(0,0x910730684d771f62,16383), INT16_C(1) }, /* #72/3/14 */
    { 0x0007, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/0 */
    { 0x000f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/2 */
    { 0x0017, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/4 */
    { 0x001f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/6 */
    { 0x0027, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/8 */
    { 0x002f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/10 */
    { 0x0037, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/12 */
    { 0x003f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/0/14 */
    { 0x0407, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/0 */
    { 0x040f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/2 */
    { 0x0417, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/4 */
    { 0x041f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/6 */
    { 0x0427, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/8 */
    { 0x042f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/10 */
    { 0x0437, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/12 */
    { 0x043f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/1/14 */
    { 0x0807, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/0 */
    { 0x080f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/2 */
    { 0x0817, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/4 */
    { 0x081f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/6 */
    { 0x0827, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/8 */
    { 0x082f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/10 */
    { 0x0837, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/12 */
    { 0x083f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/2/14 */
    { 0x0c07, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/0 */
    { 0x0c0f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/2 */
    { 0x0c17, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/4 */
    { 0x0c1f, 0x3aca, 0x80a0, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/6 */
    { 0x0c27, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/8 */
    { 0x0c2f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/10 */
    { 0x0c37, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/12 */
    { 0x0c3f, 0x3aca, 0x0020, RTFLOAT80U_INIT_C(0,0x8a3ad64d74700401,16383), INT16_C(1) }, /* #73/3/14 */
    { 0x0003, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/0 */
    { 0x000b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/2 */
    { 0x0013, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/4 */
    { 0x001b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/6 */
    { 0x0023, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/8 */
    { 0x002b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/10 */
    { 0x0033, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/12 */
    { 0x003b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/0/14 */
    { 0x0403, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/0 */
    { 0x040b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/2 */
    { 0x0413, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/4 */
    { 0x041b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/6 */
    { 0x0423, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/8 */
    { 0x042b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/10 */
    { 0x0433, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/12 */
    { 0x043b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/1/14 */
    { 0x0803, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/0 */
    { 0x080b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/2 */
    { 0x0813, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/4 */
    { 0x081b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/6 */
    { 0x0823, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/8 */
    { 0x082b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/10 */
    { 0x0833, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/12 */
    { 0x083b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/2/14 */
    { 0x0c03, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/0 */
    { 0x0c0b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/2 */
    { 0x0c13, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/4 */
    { 0x0c1b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/6 */
    { 0x0c23, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/8 */
    { 0x0c2b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/10 */
    { 0x0c33, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/12 */
    { 0x0c3b, 0x5738, 0x4500, RTFLOAT80U_INIT_C(1,0x0,0), INT16_C(0) }, /* #74/3/14 */
    { 0x0203, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/0 */
    { 0x020b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/2 */
    { 0x0213, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/4 */
    { 0x021b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/6 */
    { 0x0223, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/8 */
    { 0x022b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/10 */
    { 0x0233, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/12 */
    { 0x023b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/0/14 */
    { 0x0603, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/0 */
    { 0x060b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/2 */
    { 0x0613, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/4 */
    { 0x061b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/6 */
    { 0x0623, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/8 */
    { 0x062b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/10 */
    { 0x0633, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/12 */
    { 0x063b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/1/14 */
    { 0x0a03, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/0 */
    { 0x0a0b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/2 */
    { 0x0a13, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/4 */
    { 0x0a1b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/6 */
    { 0x0a23, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/8 */
    { 0x0a2b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/10 */
    { 0x0a33, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/12 */
    { 0x0a3b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/2/14 */
    { 0x0e03, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/0 */
    { 0x0e0b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/2 */
    { 0x0e13, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/4 */
    { 0x0e1b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/6 */
    { 0x0e23, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/8 */
    { 0x0e2b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/10 */
    { 0x0e33, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/12 */
    { 0x0e3b, 0x41a9, 0x4101, RTFLOAT80U_INIT_C(0,0x92251bf8d3afe747,17993), INT16_MIN }, /* #75/3/14 */
    { 0x0207, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/0 */
    { 0x020f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/2 */
    { 0x0217, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/4 */
    { 0x021f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/6 */
    { 0x0227, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/8 */
    { 0x022f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/10 */
    { 0x0237, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/12 */
    { 0x023f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/0/14 */
    { 0x0607, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/0 */
    { 0x060f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/2 */
    { 0x0617, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/4 */
    { 0x061f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/6 */
    { 0x0627, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/8 */
    { 0x062f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/10 */
    { 0x0637, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/12 */
    { 0x063f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/1/14 */
    { 0x0a07, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/0 */
    { 0x0a0f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/2 */
    { 0x0a17, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/4 */
    { 0x0a1f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/6 */
    { 0x0a27, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/8 */
    { 0x0a2f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/10 */
    { 0x0a37, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/12 */
    { 0x0a3f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/2/14 */
    { 0x0e07, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/0 */
    { 0x0e0f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/2 */
    { 0x0e17, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/4 */
    { 0x0e1f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/6 */
    { 0x0e27, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/8 */
    { 0x0e2f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/10 */
    { 0x0e37, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/12 */
    { 0x0e3f, 0xb8c7, 0x0001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #76/3/14 */
    { 0x0305, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/0 */
    { 0x030d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/2 */
    { 0x0315, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/4 */
    { 0x031d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/6 */
    { 0x0325, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/8 */
    { 0x032d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/10 */
    { 0x0335, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/12 */
    { 0x033d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/0/14 */
    { 0x0705, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/0 */
    { 0x070d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/2 */
    { 0x0715, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/4 */
    { 0x071d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/6 */
    { 0x0725, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/8 */
    { 0x072d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/10 */
    { 0x0735, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/12 */
    { 0x073d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/1/14 */
    { 0x0b05, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/0 */
    { 0x0b0d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/2 */
    { 0x0b15, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/4 */
    { 0x0b1d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/6 */
    { 0x0b25, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/8 */
    { 0x0b2d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/10 */
    { 0x0b35, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/12 */
    { 0x0b3d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/2/14 */
    { 0x0f05, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/0 */
    { 0x0f0d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/2 */
    { 0x0f15, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/4 */
    { 0x0f1d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/6 */
    { 0x0f25, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/8 */
    { 0x0f2d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/10 */
    { 0x0f35, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/12 */
    { 0x0f3d, 0x498d, 0x4101, RTFLOAT80U_INIT_C(0,0x17b34,7000), INT16_MIN }, /* #77/3/14 */
    { 0x0347, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/0 */
    { 0x034f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/2 */
    { 0x0357, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/4 */
    { 0x035f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/6 */
    { 0x0367, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/8 */
    { 0x036f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/10 */
    { 0x0377, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/12 */
    { 0x037f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/0/14 */
    { 0x0747, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/0 */
    { 0x074f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/2 */
    { 0x0757, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/4 */
    { 0x075f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/6 */
    { 0x0767, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/8 */
    { 0x076f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/10 */
    { 0x0777, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/12 */
    { 0x077f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/1/14 */
    { 0x0b47, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/0 */
    { 0x0b4f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/2 */
    { 0x0b57, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/4 */
    { 0x0b5f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/6 */
    { 0x0b67, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/8 */
    { 0x0b6f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/10 */
    { 0x0b77, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/12 */
    { 0x0b7f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/2/14 */
    { 0x0f47, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/0 */
    { 0x0f4f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/2 */
    { 0x0f57, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/4 */
    { 0x0f5f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/6 */
    { 0x0f67, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/8 */
    { 0x0f6f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/10 */
    { 0x0f77, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/12 */
    { 0x0f7f, 0xd9e3, 0x4101, RTFLOAT80U_INIT_C(0,0x616663f32ffa2c6b,7158), INT16_MIN }, /* #78/3/14 */
    { 0x0046, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/0 */
    { 0x004e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/2 */
    { 0x0056, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/4 */
    { 0x005e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/6 */
    { 0x0066, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/8 */
    { 0x006e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/10 */
    { 0x0076, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/12 */
    { 0x007e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/0/14 */
    { 0x0446, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/0 */
    { 0x044e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/2 */
    { 0x0456, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/4 */
    { 0x045e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/6 */
    { 0x0466, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/8 */
    { 0x046e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/10 */
    { 0x0476, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/12 */
    { 0x047e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/1/14 */
    { 0x0846, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/0 */
    { 0x084e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/2 */
    { 0x0856, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/4 */
    { 0x085e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/6 */
    { 0x0866, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/8 */
    { 0x086e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/10 */
    { 0x0876, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/12 */
    { 0x087e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/2/14 */
    { 0x0c46, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/0 */
    { 0x0c4e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/2 */
    { 0x0c56, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/4 */
    { 0x0c5e, 0x7cf7, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/6 */
    { 0x0c66, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/8 */
    { 0x0c6e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/10 */
    { 0x0c76, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/12 */
    { 0x0c7e, 0x7cf7, 0x4420, RTFLOAT80U_INIT_C(1,0xf5ded06b17051fef,16397), INT16_C(-31471) }, /* #79/3/14 */
    { 0x0041, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/0 */
    { 0x0049, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/2 */
    { 0x0051, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/4 */
    { 0x0059, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/6 */
    { 0x0061, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/8 */
    { 0x0069, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/10 */
    { 0x0071, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/12 */
    { 0x0079, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/0/14 */
    { 0x0441, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/0 */
    { 0x0449, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/2 */
    { 0x0451, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/4 */
    { 0x0459, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/6 */
    { 0x0461, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/8 */
    { 0x0469, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/10 */
    { 0x0471, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/12 */
    { 0x0479, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/1/14 */
    { 0x0841, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/0 */
    { 0x0849, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/2 */
    { 0x0851, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/4 */
    { 0x0859, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/6 */
    { 0x0861, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/8 */
    { 0x0869, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/10 */
    { 0x0871, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/12 */
    { 0x0879, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/2/14 */
    { 0x0c41, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/0 */
    { 0x0c49, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/2 */
    { 0x0c51, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/4 */
    { 0x0c59, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/6 */
    { 0x0c61, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/8 */
    { 0x0c69, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/10 */
    { 0x0c71, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/12 */
    { 0x0c79, 0x2994, 0x0101, RTFLOAT80U_INIT_C(1,0xd8c1a64ddd122c75,32767), INT16_MIN }, /* #80/3/14 */
    { 0x0243, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/0 */
    { 0x024b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/2 */
    { 0x0253, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/4 */
    { 0x025b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/6 */
    { 0x0263, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/8 */
    { 0x026b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/10 */
    { 0x0273, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/12 */
    { 0x027b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/0/14 */
    { 0x0643, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/0 */
    { 0x064b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/2 */
    { 0x0653, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/4 */
    { 0x065b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/6 */
    { 0x0663, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/8 */
    { 0x066b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/10 */
    { 0x0673, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/12 */
    { 0x067b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/1/14 */
    { 0x0a43, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/0 */
    { 0x0a4b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/2 */
    { 0x0a53, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/4 */
    { 0x0a5b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/6 */
    { 0x0a63, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/8 */
    { 0x0a6b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/10 */
    { 0x0a73, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/12 */
    { 0x0a7b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/2/14 */
    { 0x0e43, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/0 */
    { 0x0e4b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/2 */
    { 0x0e53, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/4 */
    { 0x0e5b, 0xaf2e, 0x85a0, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/6 */
    { 0x0e63, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/8 */
    { 0x0e6b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/10 */
    { 0x0e73, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/12 */
    { 0x0e7b, 0xaf2e, 0x0520, RTFLOAT80U_INIT_C(1,0x9a2e11b03897c0c8,16397), INT16_C(-19735) }, /* #81/3/14 */
    { 0x0344, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/0 */
    { 0x034c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/2 */
    { 0x0354, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/4 */
    { 0x035c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/6 */
    { 0x0364, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/8 */
    { 0x036c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/10 */
    { 0x0374, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/12 */
    { 0x037c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/0/14 */
    { 0x0744, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/0 */
    { 0x074c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/2 */
    { 0x0754, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/4 */
    { 0x075c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/6 */
    { 0x0764, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/8 */
    { 0x076c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/10 */
    { 0x0774, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/12 */
    { 0x077c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/1/14 */
    { 0x0b44, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/0 */
    { 0x0b4c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/2 */
    { 0x0b54, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/4 */
    { 0x0b5c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/6 */
    { 0x0b64, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/8 */
    { 0x0b6c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/10 */
    { 0x0b74, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/12 */
    { 0x0b7c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/2/14 */
    { 0x0f44, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/0 */
    { 0x0f4c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/2 */
    { 0x0f54, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/4 */
    { 0x0f5c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/6 */
    { 0x0f64, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/8 */
    { 0x0f6c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/10 */
    { 0x0f74, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/12 */
    { 0x0f7c, 0xdd2b, 0xfd81, RTFLOAT80U_INIT_C(0,0x6ef7f53825206665,5960), INT16_C(-3) }, /* #82/3/14 */
    { 0x0245, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/0 */
    { 0x024d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/2 */
    { 0x0255, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/4 */
    { 0x025d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/6 */
    { 0x0265, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/8 */
    { 0x026d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/10 */
    { 0x0275, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/12 */
    { 0x027d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/0/14 */
    { 0x0645, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/0 */
    { 0x064d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/2 */
    { 0x0655, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/4 */
    { 0x065d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/6 */
    { 0x0665, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/8 */
    { 0x066d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/10 */
    { 0x0675, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/12 */
    { 0x067d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/1/14 */
    { 0x0a45, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/0 */
    { 0x0a4d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/2 */
    { 0x0a55, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/4 */
    { 0x0a5d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/6 */
    { 0x0a65, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/8 */
    { 0x0a6d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/10 */
    { 0x0a75, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/12 */
    { 0x0a7d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/2/14 */
    { 0x0e45, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/0 */
    { 0x0e4d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/2 */
    { 0x0e55, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/4 */
    { 0x0e5d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/6 */
    { 0x0e65, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/8 */
    { 0x0e6d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/10 */
    { 0x0e75, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/12 */
    { 0x0e7d, 0x186b, 0x0001, RTFLOAT80U_INIT_C(1,0xb7e2ab74fef620c2,32767), INT16_MIN }, /* #83/3/14 */
    { 0x0201, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/0 */
    { 0x0209, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/2 */
    { 0x0211, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/4 */
    { 0x0219, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/6 */
    { 0x0221, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/8 */
    { 0x0229, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/10 */
    { 0x0231, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/12 */
    { 0x0239, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/0/14 */
    { 0x0601, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/0 */
    { 0x0609, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/2 */
    { 0x0611, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/4 */
    { 0x0619, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/6 */
    { 0x0621, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/8 */
    { 0x0629, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/10 */
    { 0x0631, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/12 */
    { 0x0639, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/1/14 */
    { 0x0a01, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/0 */
    { 0x0a09, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/2 */
    { 0x0a11, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/4 */
    { 0x0a19, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/6 */
    { 0x0a21, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/8 */
    { 0x0a29, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/10 */
    { 0x0a31, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/12 */
    { 0x0a39, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/2/14 */
    { 0x0e01, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/0 */
    { 0x0e09, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/2 */
    { 0x0e11, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/4 */
    { 0x0e19, 0xf233, 0xc0a0, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/6 */
    { 0x0e21, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/8 */
    { 0x0e29, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/10 */
    { 0x0e31, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/12 */
    { 0x0e39, 0xf233, 0x4020, RTFLOAT80U_INIT_C(0,0x818bad7f61cee114,16166), INT16_C(0) }, /* #84/3/14 */
    { 0x0142, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/0 */
    { 0x014a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/2 */
    { 0x0152, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/4 */
    { 0x015a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/6 */
    { 0x0162, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/8 */
    { 0x016a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/10 */
    { 0x0172, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/12 */
    { 0x017a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/0/14 */
    { 0x0542, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/0 */
    { 0x054a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/2 */
    { 0x0552, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/4 */
    { 0x055a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/6 */
    { 0x0562, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/8 */
    { 0x056a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/10 */
    { 0x0572, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/12 */
    { 0x057a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/1/14 */
    { 0x0942, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/0 */
    { 0x094a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/2 */
    { 0x0952, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/4 */
    { 0x095a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/6 */
    { 0x0962, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/8 */
    { 0x096a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/10 */
    { 0x0972, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/12 */
    { 0x097a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/2/14 */
    { 0x0d42, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/0 */
    { 0x0d4a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/2 */
    { 0x0d52, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/4 */
    { 0x0d5a, 0x2deb, 0x85a0, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/6 */
    { 0x0d62, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/8 */
    { 0x0d6a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/10 */
    { 0x0d72, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/12 */
    { 0x0d7a, 0x2deb, 0x0520, RTFLOAT80U_INIT_C(0,0xf028635eaac564fb,16383), INT16_C(1) }, /* #85/3/14 */
    { 0x0346, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/0 */
    { 0x034e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/2 */
    { 0x0356, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/4 */
    { 0x035e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/6 */
    { 0x0366, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/8 */
    { 0x036e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/10 */
    { 0x0376, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/12 */
    { 0x037e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/0/14 */
    { 0x0746, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/0 */
    { 0x074e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/2 */
    { 0x0756, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/4 */
    { 0x075e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/6 */
    { 0x0766, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/8 */
    { 0x076e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/10 */
    { 0x0776, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/12 */
    { 0x077e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/1/14 */
    { 0x0b46, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/0 */
    { 0x0b4e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/2 */
    { 0x0b56, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/4 */
    { 0x0b5e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/6 */
    { 0x0b66, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/8 */
    { 0x0b6e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/10 */
    { 0x0b76, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/12 */
    { 0x0b7e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/2/14 */
    { 0x0f46, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/0 */
    { 0x0f4e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/2 */
    { 0x0f56, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/4 */
    { 0x0f5e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/6 */
    { 0x0f66, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/8 */
    { 0x0f6e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/10 */
    { 0x0f76, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/12 */
    { 0x0f7e, 0xd8b5, 0xf881, RTFLOAT80U_INIT_C(0,0x5d94a6c4f644f8ac,25301), INT16_C(-3) }, /* #86/3/14 */
    { 0x0247, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/0 */
    { 0x024f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/2 */
    { 0x0257, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/4 */
    { 0x025f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/6 */
    { 0x0267, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/8 */
    { 0x026f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/10 */
    { 0x0277, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/12 */
    { 0x027f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/0/14 */
    { 0x0647, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/0 */
    { 0x064f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/2 */
    { 0x0657, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/4 */
    { 0x065f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/6 */
    { 0x0667, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/8 */
    { 0x066f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/10 */
    { 0x0677, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/12 */
    { 0x067f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/1/14 */
    { 0x0a47, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/0 */
    { 0x0a4f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/2 */
    { 0x0a57, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/4 */
    { 0x0a5f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/6 */
    { 0x0a67, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/8 */
    { 0x0a6f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/10 */
    { 0x0a77, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/12 */
    { 0x0a7f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/2/14 */
    { 0x0e47, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/0 */
    { 0x0e4f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/2 */
    { 0x0e57, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/4 */
    { 0x0e5f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/6 */
    { 0x0e67, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/8 */
    { 0x0e6f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/10 */
    { 0x0e77, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/12 */
    { 0x0e7f, 0x0367, 0x0101, RTFLOAT80U_INIT_C(1,0x2c51aea4088cff88,15135), INT16_MIN }, /* #87/3/14 */
    { 0x0303, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/0 */
    { 0x030b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/2 */
    { 0x0313, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/4 */
    { 0x031b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/6 */
    { 0x0323, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/8 */
    { 0x032b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/10 */
    { 0x0333, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/12 */
    { 0x033b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/0/14 */
    { 0x0703, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/0 */
    { 0x070b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/2 */
    { 0x0713, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/4 */
    { 0x071b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/6 */
    { 0x0723, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/8 */
    { 0x072b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/10 */
    { 0x0733, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/12 */
    { 0x073b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/1/14 */
    { 0x0b03, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/0 */
    { 0x0b0b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/2 */
    { 0x0b13, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/4 */
    { 0x0b1b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/6 */
    { 0x0b23, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/8 */
    { 0x0b2b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/10 */
    { 0x0b33, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/12 */
    { 0x0b3b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/2/14 */
    { 0x0f03, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/0 */
    { 0x0f0b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/2 */
    { 0x0f13, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/4 */
    { 0x0f1b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/6 */
    { 0x0f23, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/8 */
    { 0x0f2b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/10 */
    { 0x0f33, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/12 */
    { 0x0f3b, 0x6d91, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), INT16_MIN }, /* #88/3/14 */
    { 0x0041, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/0 */
    { 0x0049, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/2 */
    { 0x0051, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/4 */
    { 0x0059, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/6 */
    { 0x0061, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/8 */
    { 0x0069, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/10 */
    { 0x0071, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/12 */
    { 0x0079, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/0/14 */
    { 0x0441, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/0 */
    { 0x0449, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/2 */
    { 0x0451, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/4 */
    { 0x0459, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/6 */
    { 0x0461, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/8 */
    { 0x0469, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/10 */
    { 0x0471, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/12 */
    { 0x0479, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/1/14 */
    { 0x0841, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/0 */
    { 0x0849, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/2 */
    { 0x0851, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/4 */
    { 0x0859, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/6 */
    { 0x0861, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/8 */
    { 0x0869, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/10 */
    { 0x0871, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/12 */
    { 0x0879, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/2/14 */
    { 0x0c41, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/0 */
    { 0x0c49, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/2 */
    { 0x0c51, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/4 */
    { 0x0c59, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/6 */
    { 0x0c61, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/8 */
    { 0x0c69, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/10 */
    { 0x0c71, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/12 */
    { 0x0c79, 0x263d, 0x0400, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #89/3/14 */
    { 0x0304, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/0 */
    { 0x030c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/2 */
    { 0x0314, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/4 */
    { 0x031c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/6 */
    { 0x0324, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/8 */
    { 0x032c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/10 */
    { 0x0334, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/12 */
    { 0x033c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/0/14 */
    { 0x0704, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/0 */
    { 0x070c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/2 */
    { 0x0714, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/4 */
    { 0x071c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/6 */
    { 0x0724, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/8 */
    { 0x072c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/10 */
    { 0x0734, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/12 */
    { 0x073c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/1/14 */
    { 0x0b04, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/0 */
    { 0x0b0c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/2 */
    { 0x0b14, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/4 */
    { 0x0b1c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/6 */
    { 0x0b24, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/8 */
    { 0x0b2c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/10 */
    { 0x0b34, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/12 */
    { 0x0b3c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/2/14 */
    { 0x0f04, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/0 */
    { 0x0f0c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/2 */
    { 0x0f14, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/4 */
    { 0x0f1c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/6 */
    { 0x0f24, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/8 */
    { 0x0f2c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/10 */
    { 0x0f34, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/12 */
    { 0x0f3c, 0x86f4, 0xbc81, RTFLOAT80U_INIT_C(1,0x3e6f31728d1b30be,19017), INT16_C(-3) }, /* #90/3/14 */
    { 0x0002, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/0 */
    { 0x000a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/2 */
    { 0x0012, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/4 */
    { 0x001a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/6 */
    { 0x0022, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/8 */
    { 0x002a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/10 */
    { 0x0032, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/12 */
    { 0x003a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/0/14 */
    { 0x0402, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/0 */
    { 0x040a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/2 */
    { 0x0412, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/4 */
    { 0x041a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/6 */
    { 0x0422, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/8 */
    { 0x042a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/10 */
    { 0x0432, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/12 */
    { 0x043a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/1/14 */
    { 0x0802, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/0 */
    { 0x080a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/2 */
    { 0x0812, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/4 */
    { 0x081a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/6 */
    { 0x0822, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/8 */
    { 0x082a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/10 */
    { 0x0832, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/12 */
    { 0x083a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/2/14 */
    { 0x0c02, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/0 */
    { 0x0c0a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/2 */
    { 0x0c12, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/4 */
    { 0x0c1a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/6 */
    { 0x0c22, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/8 */
    { 0x0c2a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/10 */
    { 0x0c32, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/12 */
    { 0x0c3a, 0x8346, 0xb981, RTFLOAT80U_INIT_C(0,0x5ae5d2279bc6a62,14355), INT16_C(-3) }, /* #91/3/14 */
    { 0x0247, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/0 */
    { 0x024f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/2 */
    { 0x0257, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/4 */
    { 0x025f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/6 */
    { 0x0267, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/8 */
    { 0x026f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/10 */
    { 0x0277, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/12 */
    { 0x027f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/0/14 */
    { 0x0647, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/0 */
    { 0x064f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/2 */
    { 0x0657, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/4 */
    { 0x065f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/6 */
    { 0x0667, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/8 */
    { 0x066f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/10 */
    { 0x0677, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/12 */
    { 0x067f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/1/14 */
    { 0x0a47, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/0 */
    { 0x0a4f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/2 */
    { 0x0a57, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/4 */
    { 0x0a5f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/6 */
    { 0x0a67, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/8 */
    { 0x0a6f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/10 */
    { 0x0a77, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/12 */
    { 0x0a7f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/2/14 */
    { 0x0e47, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/0 */
    { 0x0e4f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/2 */
    { 0x0e57, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/4 */
    { 0x0e5f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/6 */
    { 0x0e67, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/8 */
    { 0x0e6f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/10 */
    { 0x0e77, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/12 */
    { 0x0e7f, 0x673e, 0x4501, RTFLOAT80U_INIT_C(0,0xa23db74368ffe5eb,21831), INT16_MIN }, /* #92/3/14 */
    { 0x0146, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/0 */
    { 0x014e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/2 */
    { 0x0156, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/4 */
    { 0x015e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/6 */
    { 0x0166, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/8 */
    { 0x016e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/10 */
    { 0x0176, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/12 */
    { 0x017e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/0/14 */
    { 0x0546, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/0 */
    { 0x054e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/2 */
    { 0x0556, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/4 */
    { 0x055e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/6 */
    { 0x0566, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/8 */
    { 0x056e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/10 */
    { 0x0576, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/12 */
    { 0x057e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/1/14 */
    { 0x0946, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/0 */
    { 0x094e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/2 */
    { 0x0956, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/4 */
    { 0x095e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/6 */
    { 0x0966, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/8 */
    { 0x096e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/10 */
    { 0x0976, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/12 */
    { 0x097e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/2/14 */
    { 0x0d46, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/0 */
    { 0x0d4e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/2 */
    { 0x0d56, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/4 */
    { 0x0d5e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/6 */
    { 0x0d66, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/8 */
    { 0x0d6e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/10 */
    { 0x0d76, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/12 */
    { 0x0d7e, 0x56cf, 0xfc81, RTFLOAT80U_INIT_C(1,0x367afc26c19e2eed,2230), INT16_C(-3) }, /* #93/3/14 */
    { 0x0204, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/0 */
    { 0x020c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/2 */
    { 0x0214, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/4 */
    { 0x021c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/6 */
    { 0x0224, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/8 */
    { 0x022c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/10 */
    { 0x0234, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/12 */
    { 0x023c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/0/14 */
    { 0x0604, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/0 */
    { 0x060c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/2 */
    { 0x0614, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/4 */
    { 0x061c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/6 */
    { 0x0624, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/8 */
    { 0x062c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/10 */
    { 0x0634, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/12 */
    { 0x063c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/1/14 */
    { 0x0a04, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/0 */
    { 0x0a0c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/2 */
    { 0x0a14, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/4 */
    { 0x0a1c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/6 */
    { 0x0a24, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/8 */
    { 0x0a2c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/10 */
    { 0x0a34, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/12 */
    { 0x0a3c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/2/14 */
    { 0x0e04, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/0 */
    { 0x0e0c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/2 */
    { 0x0e14, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/4 */
    { 0x0e1c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/6 */
    { 0x0e24, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/8 */
    { 0x0e2c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/10 */
    { 0x0e34, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/12 */
    { 0x0e3c, 0x98c3, 0xb881, RTFLOAT80U_INIT_C(1,0x1e025517dadc3f5f,11119), INT16_C(-3) }, /* #94/3/14 */
    { 0x0206, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/0 */
    { 0x020e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/2 */
    { 0x0216, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/4 */
    { 0x021e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/6 */
    { 0x0226, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/8 */
    { 0x022e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/10 */
    { 0x0236, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/12 */
    { 0x023e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/0/14 */
    { 0x0606, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/0 */
    { 0x060e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/2 */
    { 0x0616, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/4 */
    { 0x061e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/6 */
    { 0x0626, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/8 */
    { 0x062e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/10 */
    { 0x0636, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/12 */
    { 0x063e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/1/14 */
    { 0x0a06, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/0 */
    { 0x0a0e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/2 */
    { 0x0a16, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/4 */
    { 0x0a1e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/6 */
    { 0x0a26, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/8 */
    { 0x0a2e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/10 */
    { 0x0a36, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/12 */
    { 0x0a3e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/2/14 */
    { 0x0e06, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/0 */
    { 0x0e0e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/2 */
    { 0x0e16, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/4 */
    { 0x0e1e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/6 */
    { 0x0e26, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/8 */
    { 0x0e2e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/10 */
    { 0x0e36, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/12 */
    { 0x0e3e, 0x2533, 0xbd81, RTFLOAT80U_INIT_C(1,0x37d53b479f563532,30025), INT16_C(-3) }, /* #95/3/14 */
    { 0x0100, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/0 */
    { 0x0108, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/2 */
    { 0x0110, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/4 */
    { 0x0118, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/6 */
    { 0x0120, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/8 */
    { 0x0128, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/10 */
    { 0x0130, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/12 */
    { 0x0138, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/14 */
    { 0x0500, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/0 */
    { 0x0508, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/2 */
    { 0x0510, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/4 */
    { 0x0518, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/6 */
    { 0x0520, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/8 */
    { 0x0528, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/10 */
    { 0x0530, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/12 */
    { 0x0538, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/14 */
    { 0x0900, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/0 */
    { 0x0908, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/2 */
    { 0x0910, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/4 */
    { 0x0918, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/6 */
    { 0x0920, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/8 */
    { 0x0928, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/10 */
    { 0x0930, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/12 */
    { 0x0938, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/14 */
    { 0x0d00, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/0 */
    { 0x0d08, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/2 */
    { 0x0d10, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/4 */
    { 0x0d18, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/6 */
    { 0x0d20, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/8 */
    { 0x0d28, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/10 */
    { 0x0d30, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/12 */
    { 0x0d38, 0xc6b5, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/14 */
    { 0x0240, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/0 */
    { 0x0248, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/2 */
    { 0x0250, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/4 */
    { 0x0258, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/6 */
    { 0x0260, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/8 */
    { 0x0268, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/10 */
    { 0x0270, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/12 */
    { 0x0278, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/14 */
    { 0x0640, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/0 */
    { 0x0648, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/2 */
    { 0x0650, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/4 */
    { 0x0658, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/6 */
    { 0x0660, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/8 */
    { 0x0668, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/10 */
    { 0x0670, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/12 */
    { 0x0678, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/14 */
    { 0x0a40, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/0 */
    { 0x0a48, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/2 */
    { 0x0a50, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/4 */
    { 0x0a58, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/6 */
    { 0x0a60, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/8 */
    { 0x0a68, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/10 */
    { 0x0a70, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/12 */
    { 0x0a78, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/14 */
    { 0x0e40, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/0 */
    { 0x0e48, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/2 */
    { 0x0e50, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/4 */
    { 0x0e58, 0x54a9, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/6 */
    { 0x0e60, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/8 */
    { 0x0e68, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/10 */
    { 0x0e70, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/12 */
    { 0x0e78, 0x54a9, 0x4420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/14 */
    { 0x0103, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/0 */
    { 0x010b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/2 */
    { 0x0113, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/4 */
    { 0x011b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/6 */
    { 0x0123, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/8 */
    { 0x012b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/10 */
    { 0x0133, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/12 */
    { 0x013b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/14 */
    { 0x0503, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/0 */
    { 0x050b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/2 */
    { 0x0513, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/4 */
    { 0x051b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/6 */
    { 0x0523, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/8 */
    { 0x052b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/10 */
    { 0x0533, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/12 */
    { 0x053b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/14 */
    { 0x0903, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/0 */
    { 0x090b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/2 */
    { 0x0913, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/4 */
    { 0x091b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/6 */
    { 0x0923, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/8 */
    { 0x092b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/10 */
    { 0x0933, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/12 */
    { 0x093b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/14 */
    { 0x0d03, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/0 */
    { 0x0d0b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/2 */
    { 0x0d13, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/4 */
    { 0x0d1b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/6 */
    { 0x0d23, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/8 */
    { 0x0d2b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/10 */
    { 0x0d33, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/12 */
    { 0x0d3b, 0xbcd5, 0x0400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/14 */
    { 0x0203, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/0 */
    { 0x020b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/2 */
    { 0x0213, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/4 */
    { 0x021b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/6 */
    { 0x0223, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/8 */
    { 0x022b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/10 */
    { 0x0233, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/12 */
    { 0x023b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/14 */
    { 0x0603, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/0 */
    { 0x060b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/2 */
    { 0x0613, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/4 */
    { 0x061b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/6 */
    { 0x0623, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/8 */
    { 0x062b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/10 */
    { 0x0633, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/12 */
    { 0x063b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/14 */
    { 0x0a03, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/0 */
    { 0x0a0b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/2 */
    { 0x0a13, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/4 */
    { 0x0a1b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/6 */
    { 0x0a23, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/8 */
    { 0x0a2b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/10 */
    { 0x0a33, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/12 */
    { 0x0a3b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/14 */
    { 0x0e03, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/0 */
    { 0x0e0b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/2 */
    { 0x0e13, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/4 */
    { 0x0e1b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/6 */
    { 0x0e23, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/8 */
    { 0x0e2b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/10 */
    { 0x0e33, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/12 */
    { 0x0e3b, 0x4024, 0x4000, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/14 */
    { 0x0003, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/0 */
    { 0x000b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/2 */
    { 0x0013, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/4 */
    { 0x001b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/6 */
    { 0x0023, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/8 */
    { 0x002b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/10 */
    { 0x0033, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/12 */
    { 0x003b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/14 */
    { 0x0403, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/0 */
    { 0x040b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/2 */
    { 0x0413, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/4 */
    { 0x041b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/6 */
    { 0x0423, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/8 */
    { 0x042b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/10 */
    { 0x0433, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/12 */
    { 0x043b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/14 */
    { 0x0803, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/0 */
    { 0x080b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/2 */
    { 0x0813, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/4 */
    { 0x081b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/6 */
    { 0x0823, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/8 */
    { 0x082b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/10 */
    { 0x0833, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/12 */
    { 0x083b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/14 */
    { 0x0c03, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/0 */
    { 0x0c0b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/2 */
    { 0x0c13, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/4 */
    { 0x0c1b, 0x4860, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/6 */
    { 0x0c23, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/8 */
    { 0x0c2b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/10 */
    { 0x0c33, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/12 */
    { 0x0c3b, 0x4860, 0x4020, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/14 */
    { 0x0345, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/0 */
    { 0x034d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/2 */
    { 0x0355, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/4 */
    { 0x035d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/6 */
    { 0x0365, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/8 */
    { 0x036d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/10 */
    { 0x0375, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/12 */
    { 0x037d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/14 */
    { 0x0745, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/0 */
    { 0x074d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/2 */
    { 0x0755, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/4 */
    { 0x075d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/6 */
    { 0x0765, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/8 */
    { 0x076d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/10 */
    { 0x0775, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/12 */
    { 0x077d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/14 */
    { 0x0b45, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/0 */
    { 0x0b4d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/2 */
    { 0x0b55, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/4 */
    { 0x0b5d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/6 */
    { 0x0b65, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/8 */
    { 0x0b6d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/10 */
    { 0x0b75, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/12 */
    { 0x0b7d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/14 */
    { 0x0f45, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/0 */
    { 0x0f4d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/2 */
    { 0x0f55, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/4 */
    { 0x0f5d, 0x148c, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/6 */
    { 0x0f65, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/8 */
    { 0x0f6d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/10 */
    { 0x0f75, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/12 */
    { 0x0f7d, 0x148c, 0x0420, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/14 */
    { 0x0100, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/0 */
    { 0x0108, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/2 */
    { 0x0110, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/4 */
    { 0x0118, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/6 */
    { 0x0120, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/8 */
    { 0x0128, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/10 */
    { 0x0130, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/12 */
    { 0x0138, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/14 */
    { 0x0500, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/0 */
    { 0x0508, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/2 */
    { 0x0510, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/4 */
    { 0x0518, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/6 */
    { 0x0520, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/8 */
    { 0x0528, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/10 */
    { 0x0530, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/12 */
    { 0x0538, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/14 */
    { 0x0900, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/0 */
    { 0x0908, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/2 */
    { 0x0910, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/4 */
    { 0x0918, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/6 */
    { 0x0920, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/8 */
    { 0x0928, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/10 */
    { 0x0930, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/12 */
    { 0x0938, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/14 */
    { 0x0d00, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/0 */
    { 0x0d08, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/2 */
    { 0x0d10, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/4 */
    { 0x0d18, 0xfa6b, 0xc0a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/6 */
    { 0x0d20, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/8 */
    { 0x0d28, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/10 */
    { 0x0d30, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/12 */
    { 0x0d38, 0xfa6b, 0x4020, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/14 */
    { 0x0044, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/0 */
    { 0x004c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/2 */
    { 0x0054, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/4 */
    { 0x005c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/6 */
    { 0x0064, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/8 */
    { 0x006c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/10 */
    { 0x0074, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/12 */
    { 0x007c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/14 */
    { 0x0444, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/0 */
    { 0x044c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/2 */
    { 0x0454, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/4 */
    { 0x045c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/6 */
    { 0x0464, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/8 */
    { 0x046c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/10 */
    { 0x0474, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/12 */
    { 0x047c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/14 */
    { 0x0844, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/0 */
    { 0x084c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/2 */
    { 0x0854, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/4 */
    { 0x085c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/6 */
    { 0x0864, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/8 */
    { 0x086c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/10 */
    { 0x0874, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/12 */
    { 0x087c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/14 */
    { 0x0c44, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/0 */
    { 0x0c4c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/2 */
    { 0x0c54, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/4 */
    { 0x0c5c, 0x5a29, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/6 */
    { 0x0c64, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/8 */
    { 0x0c6c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/10 */
    { 0x0c74, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/12 */
    { 0x0c7c, 0x5a29, 0x4020, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/14 */
    { 0x0243, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/0 */
    { 0x024b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/2 */
    { 0x0253, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/4 */
    { 0x025b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/6 */
    { 0x0263, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/8 */
    { 0x026b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/10 */
    { 0x0273, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/12 */
    { 0x027b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/14 */
    { 0x0643, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/0 */
    { 0x064b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/2 */
    { 0x0653, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/4 */
    { 0x065b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/6 */
    { 0x0663, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/8 */
    { 0x066b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/10 */
    { 0x0673, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/12 */
    { 0x067b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/14 */
    { 0x0a43, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/0 */
    { 0x0a4b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/2 */
    { 0x0a53, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/4 */
    { 0x0a5b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/6 */
    { 0x0a63, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/8 */
    { 0x0a6b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/10 */
    { 0x0a73, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/12 */
    { 0x0a7b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/14 */
    { 0x0e43, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/0 */
    { 0x0e4b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/2 */
    { 0x0e53, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/4 */
    { 0x0e5b, 0x7971, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/6 */
    { 0x0e63, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/8 */
    { 0x0e6b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/10 */
    { 0x0e73, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/12 */
    { 0x0e7b, 0x7971, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/14 */
    { 0x0042, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/0 */
    { 0x004a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/2 */
    { 0x0052, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/4 */
    { 0x005a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/6 */
    { 0x0062, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/8 */
    { 0x006a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/10 */
    { 0x0072, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/12 */
    { 0x007a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/14 */
    { 0x0442, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/0 */
    { 0x044a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/2 */
    { 0x0452, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/4 */
    { 0x045a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/6 */
    { 0x0462, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/8 */
    { 0x046a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/10 */
    { 0x0472, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/12 */
    { 0x047a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/14 */
    { 0x0842, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/0 */
    { 0x084a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/2 */
    { 0x0852, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/4 */
    { 0x085a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/6 */
    { 0x0862, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/8 */
    { 0x086a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/10 */
    { 0x0872, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/12 */
    { 0x087a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/14 */
    { 0x0c42, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/0 */
    { 0x0c4a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/2 */
    { 0x0c52, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/4 */
    { 0x0c5a, 0xe468, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/6 */
    { 0x0c62, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/8 */
    { 0x0c6a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/10 */
    { 0x0c72, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/12 */
    { 0x0c7a, 0xe468, 0x4420, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/14 */
    { 0x0300, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/0 */
    { 0x0308, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/2 */
    { 0x0310, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/4 */
    { 0x0318, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/6 */
    { 0x0320, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/8 */
    { 0x0328, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/10 */
    { 0x0330, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/12 */
    { 0x0338, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/14 */
    { 0x0700, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/0 */
    { 0x0708, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/2 */
    { 0x0710, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/4 */
    { 0x0718, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/6 */
    { 0x0720, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/8 */
    { 0x0728, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/10 */
    { 0x0730, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/12 */
    { 0x0738, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/14 */
    { 0x0b00, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/0 */
    { 0x0b08, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/2 */
    { 0x0b10, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/4 */
    { 0x0b18, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/6 */
    { 0x0b20, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/8 */
    { 0x0b28, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/10 */
    { 0x0b30, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/12 */
    { 0x0b38, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/14 */
    { 0x0f00, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/0 */
    { 0x0f08, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/2 */
    { 0x0f10, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/4 */
    { 0x0f18, 0xe5b7, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/6 */
    { 0x0f20, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/8 */
    { 0x0f28, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/10 */
    { 0x0f30, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/12 */
    { 0x0f38, 0xe5b7, 0x4520, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/14 */
    { 0x0104, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/0 */
    { 0x010c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/2 */
    { 0x0114, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/4 */
    { 0x011c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/6 */
    { 0x0124, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/8 */
    { 0x012c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/10 */
    { 0x0134, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/12 */
    { 0x013c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/14 */
    { 0x0504, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/0 */
    { 0x050c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/2 */
    { 0x0514, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/4 */
    { 0x051c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/6 */
    { 0x0524, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/8 */
    { 0x052c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/10 */
    { 0x0534, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/12 */
    { 0x053c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/14 */
    { 0x0904, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/0 */
    { 0x090c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/2 */
    { 0x0914, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/4 */
    { 0x091c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/6 */
    { 0x0924, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/8 */
    { 0x092c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/10 */
    { 0x0934, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/12 */
    { 0x093c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/14 */
    { 0x0d04, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/0 */
    { 0x0d0c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/2 */
    { 0x0d14, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/4 */
    { 0x0d1c, 0x27f9, 0x85a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/6 */
    { 0x0d24, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/8 */
    { 0x0d2c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/10 */
    { 0x0d34, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/12 */
    { 0x0d3c, 0x27f9, 0x0520, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/14 */
    { 0x0101, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/0 */
    { 0x0109, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/2 */
    { 0x0111, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/4 */
    { 0x0119, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/6 */
    { 0x0121, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/8 */
    { 0x0129, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/10 */
    { 0x0131, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/12 */
    { 0x0139, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/14 */
    { 0x0501, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/0 */
    { 0x0509, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/2 */
    { 0x0511, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/4 */
    { 0x0519, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/6 */
    { 0x0521, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/8 */
    { 0x0529, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/10 */
    { 0x0531, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/12 */
    { 0x0539, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/14 */
    { 0x0901, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/0 */
    { 0x0909, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/2 */
    { 0x0911, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/4 */
    { 0x0919, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/6 */
    { 0x0921, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/8 */
    { 0x0929, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/10 */
    { 0x0931, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/12 */
    { 0x0939, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/14 */
    { 0x0d01, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/0 */
    { 0x0d09, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/2 */
    { 0x0d11, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/4 */
    { 0x0d19, 0x7db6, 0xc5a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/6 */
    { 0x0d21, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/8 */
    { 0x0d29, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/10 */
    { 0x0d31, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/12 */
    { 0x0d39, 0x7db6, 0x4520, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/14 */
    { 0x0047, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/0 */
    { 0x004f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/2 */
    { 0x0057, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/4 */
    { 0x005f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/6 */
    { 0x0067, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/8 */
    { 0x006f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/10 */
    { 0x0077, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/12 */
    { 0x007f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/14 */
    { 0x0447, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/0 */
    { 0x044f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/2 */
    { 0x0457, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/4 */
    { 0x045f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/6 */
    { 0x0467, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/8 */
    { 0x046f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/10 */
    { 0x0477, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/12 */
    { 0x047f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/14 */
    { 0x0847, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/0 */
    { 0x084f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/2 */
    { 0x0857, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/4 */
    { 0x085f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/6 */
    { 0x0867, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/8 */
    { 0x086f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/10 */
    { 0x0877, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/12 */
    { 0x087f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/14 */
    { 0x0c47, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/0 */
    { 0x0c4f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/2 */
    { 0x0c57, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/4 */
    { 0x0c5f, 0x2b19, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/6 */
    { 0x0c67, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/8 */
    { 0x0c6f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/10 */
    { 0x0c77, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/12 */
    { 0x0c7f, 0x2b19, 0x0120, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/14 */
    { 0x0104, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/0 */
    { 0x010c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/2 */
    { 0x0114, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/4 */
    { 0x011c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/6 */
    { 0x0124, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/8 */
    { 0x012c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/10 */
    { 0x0134, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/12 */
    { 0x013c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/14 */
    { 0x0504, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/0 */
    { 0x050c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/2 */
    { 0x0514, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/4 */
    { 0x051c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/6 */
    { 0x0524, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/8 */
    { 0x052c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/10 */
    { 0x0534, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/12 */
    { 0x053c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/14 */
    { 0x0904, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/0 */
    { 0x090c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/2 */
    { 0x0914, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/4 */
    { 0x091c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/6 */
    { 0x0924, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/8 */
    { 0x092c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/10 */
    { 0x0934, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/12 */
    { 0x093c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/14 */
    { 0x0d04, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/0 */
    { 0x0d0c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/2 */
    { 0x0d14, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/4 */
    { 0x0d1c, 0xe120, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/6 */
    { 0x0d24, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/8 */
    { 0x0d2c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/10 */
    { 0x0d34, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/12 */
    { 0x0d3c, 0xe120, 0x4120, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/14 */
    { 0x0105, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/0 */
    { 0x010d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/2 */
    { 0x0115, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/4 */
    { 0x011d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/6 */
    { 0x0125, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/8 */
    { 0x012d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/10 */
    { 0x0135, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/12 */
    { 0x013d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/14 */
    { 0x0505, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/0 */
    { 0x050d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/2 */
    { 0x0515, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/4 */
    { 0x051d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/6 */
    { 0x0525, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/8 */
    { 0x052d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/10 */
    { 0x0535, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/12 */
    { 0x053d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/14 */
    { 0x0905, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/0 */
    { 0x090d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/2 */
    { 0x0915, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/4 */
    { 0x091d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/6 */
    { 0x0925, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/8 */
    { 0x092d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/10 */
    { 0x0935, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/12 */
    { 0x093d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/14 */
    { 0x0d05, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/0 */
    { 0x0d0d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/2 */
    { 0x0d15, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/4 */
    { 0x0d1d, 0x6ec6, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/6 */
    { 0x0d25, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/8 */
    { 0x0d2d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/10 */
    { 0x0d35, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/12 */
    { 0x0d3d, 0x6ec6, 0x4420, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/14 */
    { 0x0105, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/0 */
    { 0x010d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/2 */
    { 0x0115, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/4 */
    { 0x011d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/6 */
    { 0x0125, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/8 */
    { 0x012d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/10 */
    { 0x0135, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/12 */
    { 0x013d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/14 */
    { 0x0505, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/0 */
    { 0x050d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/2 */
    { 0x0515, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/4 */
    { 0x051d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/6 */
    { 0x0525, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/8 */
    { 0x052d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/10 */
    { 0x0535, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/12 */
    { 0x053d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/14 */
    { 0x0905, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/0 */
    { 0x090d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/2 */
    { 0x0915, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/4 */
    { 0x091d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/6 */
    { 0x0925, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/8 */
    { 0x092d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/10 */
    { 0x0935, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/12 */
    { 0x093d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/14 */
    { 0x0d05, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/0 */
    { 0x0d0d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/2 */
    { 0x0d15, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/4 */
    { 0x0d1d, 0x8009, 0x80a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/6 */
    { 0x0d25, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/8 */
    { 0x0d2d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/10 */
    { 0x0d35, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/12 */
    { 0x0d3d, 0x8009, 0x0020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/14 */
    { 0x0007, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/0 */
    { 0x000f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/2 */
    { 0x0017, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/4 */
    { 0x001f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/6 */
    { 0x0027, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/8 */
    { 0x002f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/10 */
    { 0x0037, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/12 */
    { 0x003f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/14 */
    { 0x0407, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/0 */
    { 0x040f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/2 */
    { 0x0417, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/4 */
    { 0x041f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/6 */
    { 0x0427, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/8 */
    { 0x042f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/10 */
    { 0x0437, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/12 */
    { 0x043f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/14 */
    { 0x0807, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/0 */
    { 0x080f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/2 */
    { 0x0817, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/4 */
    { 0x081f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/6 */
    { 0x0827, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/8 */
    { 0x082f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/10 */
    { 0x0837, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/12 */
    { 0x083f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/14 */
    { 0x0c07, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/0 */
    { 0x0c0f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/2 */
    { 0x0c17, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/4 */
    { 0x0c1f, 0x419b, 0xc1a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/6 */
    { 0x0c27, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/8 */
    { 0x0c2f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/10 */
    { 0x0c37, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/12 */
    { 0x0c3f, 0x419b, 0x4120, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/14 */
    { 0x0045, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/0 */
    { 0x004d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/2 */
    { 0x0055, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/4 */
    { 0x005d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/6 */
    { 0x0065, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/8 */
    { 0x006d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/10 */
    { 0x0075, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/12 */
    { 0x007d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/14 */
    { 0x0445, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/0 */
    { 0x044d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/2 */
    { 0x0455, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/4 */
    { 0x045d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/6 */
    { 0x0465, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/8 */
    { 0x046d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/10 */
    { 0x0475, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/12 */
    { 0x047d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/14 */
    { 0x0845, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/0 */
    { 0x084d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/2 */
    { 0x0855, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/4 */
    { 0x085d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/6 */
    { 0x0865, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/8 */
    { 0x086d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/10 */
    { 0x0875, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/12 */
    { 0x087d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/14 */
    { 0x0c45, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/0 */
    { 0x0c4d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/2 */
    { 0x0c55, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/4 */
    { 0x0c5d, 0x50dd, 0xc0a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/6 */
    { 0x0c65, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/8 */
    { 0x0c6d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/10 */
    { 0x0c75, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/12 */
    { 0x0c7d, 0x50dd, 0x4020, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/14 */
    { 0x0201, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/0 */
    { 0x0209, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/2 */
    { 0x0211, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/4 */
    { 0x0219, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/6 */
    { 0x0221, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/8 */
    { 0x0229, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/10 */
    { 0x0231, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/12 */
    { 0x0239, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/14 */
    { 0x0601, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/0 */
    { 0x0609, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/2 */
    { 0x0611, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/4 */
    { 0x0619, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/6 */
    { 0x0621, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/8 */
    { 0x0629, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/10 */
    { 0x0631, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/12 */
    { 0x0639, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/14 */
    { 0x0a01, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/0 */
    { 0x0a09, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/2 */
    { 0x0a11, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/4 */
    { 0x0a19, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/6 */
    { 0x0a21, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/8 */
    { 0x0a29, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/10 */
    { 0x0a31, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/12 */
    { 0x0a39, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/14 */
    { 0x0e01, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/0 */
    { 0x0e09, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/2 */
    { 0x0e11, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/4 */
    { 0x0e19, 0xe72d, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/6 */
    { 0x0e21, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/8 */
    { 0x0e29, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/10 */
    { 0x0e31, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/12 */
    { 0x0e39, 0xe72d, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/14 */
    { 0x0147, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/0 */
    { 0x014f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/2 */
    { 0x0157, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/4 */
    { 0x015f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/6 */
    { 0x0167, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/8 */
    { 0x016f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/10 */
    { 0x0177, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/12 */
    { 0x017f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/14 */
    { 0x0547, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/0 */
    { 0x054f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/2 */
    { 0x0557, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/4 */
    { 0x055f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/6 */
    { 0x0567, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/8 */
    { 0x056f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/10 */
    { 0x0577, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/12 */
    { 0x057f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/14 */
    { 0x0947, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/0 */
    { 0x094f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/2 */
    { 0x0957, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/4 */
    { 0x095f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/6 */
    { 0x0967, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/8 */
    { 0x096f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/10 */
    { 0x0977, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/12 */
    { 0x097f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/14 */
    { 0x0d47, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/0 */
    { 0x0d4f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/2 */
    { 0x0d57, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/4 */
    { 0x0d5f, 0x01da, 0x81a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/6 */
    { 0x0d67, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/8 */
    { 0x0d6f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/10 */
    { 0x0d77, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/12 */
    { 0x0d7f, 0x01da, 0x0120, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/14 */
    { 0x0246, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/0 */
    { 0x024e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/2 */
    { 0x0256, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/4 */
    { 0x025e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/6 */
    { 0x0266, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/8 */
    { 0x026e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/10 */
    { 0x0276, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/12 */
    { 0x027e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/14 */
    { 0x0646, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/0 */
    { 0x064e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/2 */
    { 0x0656, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/4 */
    { 0x065e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/6 */
    { 0x0666, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/8 */
    { 0x066e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/10 */
    { 0x0676, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/12 */
    { 0x067e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/14 */
    { 0x0a46, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/0 */
    { 0x0a4e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/2 */
    { 0x0a56, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/4 */
    { 0x0a5e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/6 */
    { 0x0a66, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/8 */
    { 0x0a6e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/10 */
    { 0x0a76, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/12 */
    { 0x0a7e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/14 */
    { 0x0e46, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/0 */
    { 0x0e4e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/2 */
    { 0x0e56, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/4 */
    { 0x0e5e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/6 */
    { 0x0e66, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/8 */
    { 0x0e6e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/10 */
    { 0x0e76, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/12 */
    { 0x0e7e, 0xe350, 0x4100, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/14 */
    { 0x0301, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/0 */
    { 0x0309, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/2 */
    { 0x0311, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/4 */
    { 0x0319, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/6 */
    { 0x0321, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/8 */
    { 0x0329, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/10 */
    { 0x0331, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/12 */
    { 0x0339, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/14 */
    { 0x0701, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/0 */
    { 0x0709, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/2 */
    { 0x0711, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/4 */
    { 0x0719, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/6 */
    { 0x0721, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/8 */
    { 0x0729, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/10 */
    { 0x0731, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/12 */
    { 0x0739, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/14 */
    { 0x0b01, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/0 */
    { 0x0b09, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/2 */
    { 0x0b11, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/4 */
    { 0x0b19, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/6 */
    { 0x0b21, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/8 */
    { 0x0b29, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/10 */
    { 0x0b31, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/12 */
    { 0x0b39, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/14 */
    { 0x0f01, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/0 */
    { 0x0f09, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/2 */
    { 0x0f11, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/4 */
    { 0x0f19, 0xcf97, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/6 */
    { 0x0f21, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/8 */
    { 0x0f29, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/10 */
    { 0x0f31, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/12 */
    { 0x0f39, 0xcf97, 0x4520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/14 */
    { 0x0340, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/0 */
    { 0x0348, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/2 */
    { 0x0350, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/4 */
    { 0x0358, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/6 */
    { 0x0360, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/8 */
    { 0x0368, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/10 */
    { 0x0370, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/12 */
    { 0x0378, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/14 */
    { 0x0740, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/0 */
    { 0x0748, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/2 */
    { 0x0750, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/4 */
    { 0x0758, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/6 */
    { 0x0760, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/8 */
    { 0x0768, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/10 */
    { 0x0770, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/12 */
    { 0x0778, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/14 */
    { 0x0b40, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/0 */
    { 0x0b48, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/2 */
    { 0x0b50, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/4 */
    { 0x0b58, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/6 */
    { 0x0b60, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/8 */
    { 0x0b68, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/10 */
    { 0x0b70, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/12 */
    { 0x0b78, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/14 */
    { 0x0f40, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/0 */
    { 0x0f48, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/2 */
    { 0x0f50, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/4 */
    { 0x0f58, 0x2e53, 0x84a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/6 */
    { 0x0f60, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/8 */
    { 0x0f68, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/10 */
    { 0x0f70, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/12 */
    { 0x0f78, 0x2e53, 0x0420, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/14 */
    { 0x0105, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/0 */
    { 0x010d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/2 */
    { 0x0115, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/4 */
    { 0x011d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/6 */
    { 0x0125, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/8 */
    { 0x012d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/10 */
    { 0x0135, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/12 */
    { 0x013d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/14 */
    { 0x0505, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/0 */
    { 0x050d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/2 */
    { 0x0515, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/4 */
    { 0x051d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/6 */
    { 0x0525, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/8 */
    { 0x052d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/10 */
    { 0x0535, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/12 */
    { 0x053d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/14 */
    { 0x0905, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/0 */
    { 0x090d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/2 */
    { 0x0915, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/4 */
    { 0x091d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/6 */
    { 0x0925, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/8 */
    { 0x092d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/10 */
    { 0x0935, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/12 */
    { 0x093d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/14 */
    { 0x0d05, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/0 */
    { 0x0d0d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/2 */
    { 0x0d15, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/4 */
    { 0x0d1d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/6 */
    { 0x0d25, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/8 */
    { 0x0d2d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/10 */
    { 0x0d35, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/12 */
    { 0x0d3d, 0x775a, 0x4500, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/14 */
    { 0x0306, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/0 */
    { 0x030e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/2 */
    { 0x0316, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/4 */
    { 0x031e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/6 */
    { 0x0326, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/8 */
    { 0x032e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/10 */
    { 0x0336, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/12 */
    { 0x033e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/0/14 */
    { 0x0706, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/0 */
    { 0x070e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/2 */
    { 0x0716, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/4 */
    { 0x071e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/6 */
    { 0x0726, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/8 */
    { 0x072e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/10 */
    { 0x0736, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/12 */
    { 0x073e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/1/14 */
    { 0x0b06, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/0 */
    { 0x0b0e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/2 */
    { 0x0b16, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/4 */
    { 0x0b1e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/6 */
    { 0x0b26, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/8 */
    { 0x0b2e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/10 */
    { 0x0b36, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/12 */
    { 0x0b3e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/2/14 */
    { 0x0f06, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/0 */
    { 0x0f0e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/2 */
    { 0x0f16, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/4 */
    { 0x0f1e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/6 */
    { 0x0f26, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/8 */
    { 0x0f2e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/10 */
    { 0x0f36, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/12 */
    { 0x0f3e, 0x0194, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_C(-3) }, /* #121/3/14 */
    { 0x0344, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/0 */
    { 0x034c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/2 */
    { 0x0354, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/4 */
    { 0x035c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/6 */
    { 0x0364, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/8 */
    { 0x036c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/10 */
    { 0x0374, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/12 */
    { 0x037c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/0/14 */
    { 0x0744, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/0 */
    { 0x074c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/2 */
    { 0x0754, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/4 */
    { 0x075c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/6 */
    { 0x0764, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/8 */
    { 0x076c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/10 */
    { 0x0774, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/12 */
    { 0x077c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/1/14 */
    { 0x0b44, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/0 */
    { 0x0b4c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/2 */
    { 0x0b54, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/4 */
    { 0x0b5c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/6 */
    { 0x0b64, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/8 */
    { 0x0b6c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/10 */
    { 0x0b74, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/12 */
    { 0x0b7c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/2/14 */
    { 0x0f44, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/0 */
    { 0x0f4c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/2 */
    { 0x0f54, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/4 */
    { 0x0f5c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/6 */
    { 0x0f64, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/8 */
    { 0x0f6c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/10 */
    { 0x0f74, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/12 */
    { 0x0f7c, 0x5958, 0xf981, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_C(-3) }, /* #122/3/14 */
    { 0x0107, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/0 */
    { 0x010f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/2 */
    { 0x0117, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/4 */
    { 0x011f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/6 */
    { 0x0127, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/8 */
    { 0x012f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/10 */
    { 0x0137, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/12 */
    { 0x013f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/14 */
    { 0x0507, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/0 */
    { 0x050f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/2 */
    { 0x0517, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/4 */
    { 0x051f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/6 */
    { 0x0527, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/8 */
    { 0x052f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/10 */
    { 0x0537, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/12 */
    { 0x053f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/14 */
    { 0x0907, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/0 */
    { 0x090f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/2 */
    { 0x0917, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/4 */
    { 0x091f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/6 */
    { 0x0927, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/8 */
    { 0x092f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/10 */
    { 0x0937, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/12 */
    { 0x093f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/14 */
    { 0x0d07, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/0 */
    { 0x0d0f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/2 */
    { 0x0d17, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/4 */
    { 0x0d1f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/6 */
    { 0x0d27, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/8 */
    { 0x0d2f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/10 */
    { 0x0d37, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/12 */
    { 0x0d3f, 0xe44f, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/14 */
    { 0x0103, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/0 */
    { 0x010b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/2 */
    { 0x0113, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/4 */
    { 0x011b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/6 */
    { 0x0123, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/8 */
    { 0x012b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/10 */
    { 0x0133, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/12 */
    { 0x013b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/0/14 */
    { 0x0503, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/0 */
    { 0x050b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/2 */
    { 0x0513, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/4 */
    { 0x051b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/6 */
    { 0x0523, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/8 */
    { 0x052b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/10 */
    { 0x0533, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/12 */
    { 0x053b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/1/14 */
    { 0x0903, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/0 */
    { 0x090b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/2 */
    { 0x0913, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/4 */
    { 0x091b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/6 */
    { 0x0923, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/8 */
    { 0x092b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/10 */
    { 0x0933, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/12 */
    { 0x093b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/2/14 */
    { 0x0d03, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/0 */
    { 0x0d0b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/2 */
    { 0x0d13, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/4 */
    { 0x0d1b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/6 */
    { 0x0d23, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/8 */
    { 0x0d2b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/10 */
    { 0x0d33, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/12 */
    { 0x0d3b, 0xd958, 0x4101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_MIN }, /* #124/3/14 */
    { 0x0047, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/0 */
    { 0x004f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/2 */
    { 0x0057, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/4 */
    { 0x005f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/6 */
    { 0x0067, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/8 */
    { 0x006f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/10 */
    { 0x0077, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/12 */
    { 0x007f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/0/14 */
    { 0x0447, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/0 */
    { 0x044f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/2 */
    { 0x0457, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/4 */
    { 0x045f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/6 */
    { 0x0467, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/8 */
    { 0x046f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/10 */
    { 0x0477, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/12 */
    { 0x047f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/1/14 */
    { 0x0847, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/0 */
    { 0x084f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/2 */
    { 0x0857, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/4 */
    { 0x085f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/6 */
    { 0x0867, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/8 */
    { 0x086f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/10 */
    { 0x0877, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/12 */
    { 0x087f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/2/14 */
    { 0x0c47, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/0 */
    { 0x0c4f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/2 */
    { 0x0c57, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/4 */
    { 0x0c5f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/6 */
    { 0x0c67, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/8 */
    { 0x0c6f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/10 */
    { 0x0c77, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/12 */
    { 0x0c7f, 0xee57, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_MIN }, /* #125/3/14 */
    { 0x0005, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/0 */
    { 0x000d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/2 */
    { 0x0015, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/4 */
    { 0x001d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/6 */
    { 0x0025, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/8 */
    { 0x002d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/10 */
    { 0x0035, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/12 */
    { 0x003d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/0/14 */
    { 0x0405, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/0 */
    { 0x040d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/2 */
    { 0x0415, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/4 */
    { 0x041d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/6 */
    { 0x0425, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/8 */
    { 0x042d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/10 */
    { 0x0435, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/12 */
    { 0x043d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/1/14 */
    { 0x0805, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/0 */
    { 0x080d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/2 */
    { 0x0815, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/4 */
    { 0x081d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/6 */
    { 0x0825, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/8 */
    { 0x082d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/10 */
    { 0x0835, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/12 */
    { 0x083d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/2/14 */
    { 0x0c05, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/0 */
    { 0x0c0d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/2 */
    { 0x0c15, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/4 */
    { 0x0c1d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/6 */
    { 0x0c25, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/8 */
    { 0x0c2d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/10 */
    { 0x0c35, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/12 */
    { 0x0c3d, 0xbfd0, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_MIN }, /* #126/3/14 */
    { 0x0301, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/0 */
    { 0x0309, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/2 */
    { 0x0311, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/4 */
    { 0x0319, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/6 */
    { 0x0321, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/8 */
    { 0x0329, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/10 */
    { 0x0331, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/12 */
    { 0x0339, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/14 */
    { 0x0701, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/0 */
    { 0x0709, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/2 */
    { 0x0711, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/4 */
    { 0x0719, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/6 */
    { 0x0721, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/8 */
    { 0x0729, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/10 */
    { 0x0731, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/12 */
    { 0x0739, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/14 */
    { 0x0b01, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/0 */
    { 0x0b09, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/2 */
    { 0x0b11, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/4 */
    { 0x0b19, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/6 */
    { 0x0b21, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/8 */
    { 0x0b29, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/10 */
    { 0x0b31, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/12 */
    { 0x0b39, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/14 */
    { 0x0f01, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/0 */
    { 0x0f09, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/2 */
    { 0x0f11, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/4 */
    { 0x0f19, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/6 */
    { 0x0f21, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/8 */
    { 0x0f29, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/10 */
    { 0x0f31, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/12 */
    { 0x0f39, 0xb28d, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/14 */
    { 0x0245, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/0 */
    { 0x024d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/2 */
    { 0x0255, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/4 */
    { 0x025d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/6 */
    { 0x0265, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/8 */
    { 0x026d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/10 */
    { 0x0275, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/12 */
    { 0x027d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/14 */
    { 0x0645, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/0 */
    { 0x064d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/2 */
    { 0x0655, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/4 */
    { 0x065d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/6 */
    { 0x0665, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/8 */
    { 0x066d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/10 */
    { 0x0675, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/12 */
    { 0x067d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/14 */
    { 0x0a45, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/0 */
    { 0x0a4d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/2 */
    { 0x0a55, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/4 */
    { 0x0a5d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/6 */
    { 0x0a65, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/8 */
    { 0x0a6d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/10 */
    { 0x0a75, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/12 */
    { 0x0a7d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/14 */
    { 0x0e45, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/0 */
    { 0x0e4d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/2 */
    { 0x0e55, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/4 */
    { 0x0e5d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/6 */
    { 0x0e65, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/8 */
    { 0x0e6d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/10 */
    { 0x0e75, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/12 */
    { 0x0e7d, 0x5c7b, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/14 */
    { 0x0144, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/0 */
    { 0x014c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/2 */
    { 0x0154, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/4 */
    { 0x015c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/6 */
    { 0x0164, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/8 */
    { 0x016c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/10 */
    { 0x0174, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/12 */
    { 0x017c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/14 */
    { 0x0544, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/0 */
    { 0x054c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/2 */
    { 0x0554, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/4 */
    { 0x055c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/6 */
    { 0x0564, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/8 */
    { 0x056c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/10 */
    { 0x0574, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/12 */
    { 0x057c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/14 */
    { 0x0944, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/0 */
    { 0x094c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/2 */
    { 0x0954, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/4 */
    { 0x095c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/6 */
    { 0x0964, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/8 */
    { 0x096c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/10 */
    { 0x0974, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/12 */
    { 0x097c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/14 */
    { 0x0d44, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/0 */
    { 0x0d4c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/2 */
    { 0x0d54, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/4 */
    { 0x0d5c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/6 */
    { 0x0d64, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/8 */
    { 0x0d6c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/10 */
    { 0x0d74, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/12 */
    { 0x0d7c, 0x9fdf, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/14 */
    { 0x0205, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/0 */
    { 0x020d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/2 */
    { 0x0215, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/4 */
    { 0x021d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/6 */
    { 0x0225, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/8 */
    { 0x022d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/10 */
    { 0x0235, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/12 */
    { 0x023d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/14 */
    { 0x0605, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/0 */
    { 0x060d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/2 */
    { 0x0615, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/4 */
    { 0x061d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/6 */
    { 0x0625, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/8 */
    { 0x062d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/10 */
    { 0x0635, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/12 */
    { 0x063d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/14 */
    { 0x0a05, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/0 */
    { 0x0a0d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/2 */
    { 0x0a15, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/4 */
    { 0x0a1d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/6 */
    { 0x0a25, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/8 */
    { 0x0a2d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/10 */
    { 0x0a35, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/12 */
    { 0x0a3d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/14 */
    { 0x0e05, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/0 */
    { 0x0e0d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/2 */
    { 0x0e15, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/4 */
    { 0x0e1d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/6 */
    { 0x0e25, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/8 */
    { 0x0e2d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/10 */
    { 0x0e35, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/12 */
    { 0x0e3d, 0x633d, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/14 */
    { 0x0106, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/0 */
    { 0x010e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/2 */
    { 0x0116, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/4 */
    { 0x011e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/6 */
    { 0x0126, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/8 */
    { 0x012e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/10 */
    { 0x0136, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/12 */
    { 0x013e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/0/14 */
    { 0x0506, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/0 */
    { 0x050e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/2 */
    { 0x0516, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/4 */
    { 0x051e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/6 */
    { 0x0526, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/8 */
    { 0x052e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/10 */
    { 0x0536, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/12 */
    { 0x053e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/1/14 */
    { 0x0906, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/0 */
    { 0x090e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/2 */
    { 0x0916, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/4 */
    { 0x091e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/6 */
    { 0x0926, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/8 */
    { 0x092e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/10 */
    { 0x0936, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/12 */
    { 0x093e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/2/14 */
    { 0x0d06, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/0 */
    { 0x0d0e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/2 */
    { 0x0d16, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/4 */
    { 0x0d1e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/6 */
    { 0x0d26, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/8 */
    { 0x0d2e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/10 */
    { 0x0d36, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/12 */
    { 0x0d3e, 0x7fce, 0xfd81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_C(-3) }, /* #131/3/14 */
    { 0x0305, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/0 */
    { 0x030d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/2 */
    { 0x0315, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/4 */
    { 0x031d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/6 */
    { 0x0325, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/8 */
    { 0x032d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/10 */
    { 0x0335, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/12 */
    { 0x033d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/0/14 */
    { 0x0705, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/0 */
    { 0x070d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/2 */
    { 0x0715, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/4 */
    { 0x071d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/6 */
    { 0x0725, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/8 */
    { 0x072d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/10 */
    { 0x0735, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/12 */
    { 0x073d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/1/14 */
    { 0x0b05, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/0 */
    { 0x0b0d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/2 */
    { 0x0b15, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/4 */
    { 0x0b1d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/6 */
    { 0x0b25, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/8 */
    { 0x0b2d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/10 */
    { 0x0b35, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/12 */
    { 0x0b3d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/2/14 */
    { 0x0f05, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/0 */
    { 0x0f0d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/2 */
    { 0x0f15, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/4 */
    { 0x0f1d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/6 */
    { 0x0f25, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/8 */
    { 0x0f2d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/10 */
    { 0x0f35, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/12 */
    { 0x0f3d, 0x81ba, 0x0101, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_MIN }, /* #132/3/14 */
    { 0x0302, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/0 */
    { 0x030a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/2 */
    { 0x0312, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/4 */
    { 0x031a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/6 */
    { 0x0322, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/8 */
    { 0x032a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/10 */
    { 0x0332, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/12 */
    { 0x033a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/14 */
    { 0x0702, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/0 */
    { 0x070a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/2 */
    { 0x0712, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/4 */
    { 0x071a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/6 */
    { 0x0722, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/8 */
    { 0x072a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/10 */
    { 0x0732, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/12 */
    { 0x073a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/14 */
    { 0x0b02, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/0 */
    { 0x0b0a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/2 */
    { 0x0b12, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/4 */
    { 0x0b1a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/6 */
    { 0x0b22, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/8 */
    { 0x0b2a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/10 */
    { 0x0b32, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/12 */
    { 0x0b3a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/14 */
    { 0x0f02, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/0 */
    { 0x0f0a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/2 */
    { 0x0f12, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/4 */
    { 0x0f1a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/6 */
    { 0x0f22, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/8 */
    { 0x0f2a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/10 */
    { 0x0f32, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/12 */
    { 0x0f3a, 0xc06c, 0xf881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/14 */
    { 0x0302, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/0 */
    { 0x030a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/2 */
    { 0x0312, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/4 */
    { 0x031a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/6 */
    { 0x0322, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/8 */
    { 0x032a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/10 */
    { 0x0332, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/12 */
    { 0x033a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/14 */
    { 0x0702, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/0 */
    { 0x070a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/2 */
    { 0x0712, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/4 */
    { 0x071a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/6 */
    { 0x0722, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/8 */
    { 0x072a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/10 */
    { 0x0732, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/12 */
    { 0x073a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/14 */
    { 0x0b02, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/0 */
    { 0x0b0a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/2 */
    { 0x0b12, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/4 */
    { 0x0b1a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/6 */
    { 0x0b22, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/8 */
    { 0x0b2a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/10 */
    { 0x0b32, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/12 */
    { 0x0b3a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/14 */
    { 0x0f02, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/0 */
    { 0x0f0a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/2 */
    { 0x0f12, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/4 */
    { 0x0f1a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/6 */
    { 0x0f22, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/8 */
    { 0x0f2a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/10 */
    { 0x0f32, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/12 */
    { 0x0f3a, 0xb8b1, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/14 */
    { 0x0202, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/0 */
    { 0x020a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/2 */
    { 0x0212, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/4 */
    { 0x021a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/6 */
    { 0x0222, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/8 */
    { 0x022a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/10 */
    { 0x0232, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/12 */
    { 0x023a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/0/14 */
    { 0x0602, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/0 */
    { 0x060a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/2 */
    { 0x0612, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/4 */
    { 0x061a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/6 */
    { 0x0622, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/8 */
    { 0x062a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/10 */
    { 0x0632, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/12 */
    { 0x063a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/1/14 */
    { 0x0a02, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/0 */
    { 0x0a0a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/2 */
    { 0x0a12, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/4 */
    { 0x0a1a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/6 */
    { 0x0a22, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/8 */
    { 0x0a2a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/10 */
    { 0x0a32, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/12 */
    { 0x0a3a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/2/14 */
    { 0x0e02, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/0 */
    { 0x0e0a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/2 */
    { 0x0e12, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/4 */
    { 0x0e1a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/6 */
    { 0x0e22, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/8 */
    { 0x0e2a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/10 */
    { 0x0e32, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/12 */
    { 0x0e3a, 0x2460, 0xbc81, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_C(-3) }, /* #135/3/14 */
    { 0x0347, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/0 */
    { 0x034f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/2 */
    { 0x0357, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/4 */
    { 0x035f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/6 */
    { 0x0367, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/8 */
    { 0x036f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/10 */
    { 0x0377, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/12 */
    { 0x037f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/0/14 */
    { 0x0747, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/0 */
    { 0x074f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/2 */
    { 0x0757, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/4 */
    { 0x075f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/6 */
    { 0x0767, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/8 */
    { 0x076f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/10 */
    { 0x0777, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/12 */
    { 0x077f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/1/14 */
    { 0x0b47, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/0 */
    { 0x0b4f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/2 */
    { 0x0b57, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/4 */
    { 0x0b5f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/6 */
    { 0x0b67, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/8 */
    { 0x0b6f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/10 */
    { 0x0b77, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/12 */
    { 0x0b7f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/2/14 */
    { 0x0f47, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/0 */
    { 0x0f4f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/2 */
    { 0x0f57, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/4 */
    { 0x0f5f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/6 */
    { 0x0f67, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/8 */
    { 0x0f6f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/10 */
    { 0x0f77, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/12 */
    { 0x0f7f, 0xa44c, 0x0401, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_MIN }, /* #136/3/14 */
    { 0x0141, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/0 */
    { 0x0149, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/2 */
    { 0x0151, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/4 */
    { 0x0159, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/6 */
    { 0x0161, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/8 */
    { 0x0169, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/10 */
    { 0x0171, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/12 */
    { 0x0179, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/14 */
    { 0x0541, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/0 */
    { 0x0549, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/2 */
    { 0x0551, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/4 */
    { 0x0559, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/6 */
    { 0x0561, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/8 */
    { 0x0569, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/10 */
    { 0x0571, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/12 */
    { 0x0579, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/14 */
    { 0x0941, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/0 */
    { 0x0949, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/2 */
    { 0x0951, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/4 */
    { 0x0959, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/6 */
    { 0x0961, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/8 */
    { 0x0969, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/10 */
    { 0x0971, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/12 */
    { 0x0979, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/14 */
    { 0x0d41, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/0 */
    { 0x0d49, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/2 */
    { 0x0d51, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/4 */
    { 0x0d59, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/6 */
    { 0x0d61, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/8 */
    { 0x0d69, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/10 */
    { 0x0d71, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/12 */
    { 0x0d79, 0xac84, 0x0401, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/14 */
    { 0x0341, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/0 */
    { 0x0349, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/2 */
    { 0x0351, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/4 */
    { 0x0359, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/6 */
    { 0x0361, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/8 */
    { 0x0369, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/10 */
    { 0x0371, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/12 */
    { 0x0379, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/14 */
    { 0x0741, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/0 */
    { 0x0749, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/2 */
    { 0x0751, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/4 */
    { 0x0759, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/6 */
    { 0x0761, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/8 */
    { 0x0769, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/10 */
    { 0x0771, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/12 */
    { 0x0779, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/14 */
    { 0x0b41, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/0 */
    { 0x0b49, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/2 */
    { 0x0b51, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/4 */
    { 0x0b59, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/6 */
    { 0x0b61, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/8 */
    { 0x0b69, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/10 */
    { 0x0b71, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/12 */
    { 0x0b79, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/14 */
    { 0x0f41, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/0 */
    { 0x0f49, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/2 */
    { 0x0f51, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/4 */
    { 0x0f59, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/6 */
    { 0x0f61, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/8 */
    { 0x0f69, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/10 */
    { 0x0f71, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/12 */
    { 0x0f79, 0x8988, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/14 */
    { 0x0201, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/0 */
    { 0x0209, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/2 */
    { 0x0211, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/4 */
    { 0x0219, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/6 */
    { 0x0221, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/8 */
    { 0x0229, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/10 */
    { 0x0231, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/12 */
    { 0x0239, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/14 */
    { 0x0601, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/0 */
    { 0x0609, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/2 */
    { 0x0611, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/4 */
    { 0x0619, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/6 */
    { 0x0621, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/8 */
    { 0x0629, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/10 */
    { 0x0631, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/12 */
    { 0x0639, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/14 */
    { 0x0a01, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/0 */
    { 0x0a09, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/2 */
    { 0x0a11, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/4 */
    { 0x0a19, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/6 */
    { 0x0a21, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/8 */
    { 0x0a29, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/10 */
    { 0x0a31, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/12 */
    { 0x0a39, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/14 */
    { 0x0e01, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/0 */
    { 0x0e09, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/2 */
    { 0x0e11, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/4 */
    { 0x0e19, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/6 */
    { 0x0e21, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/8 */
    { 0x0e29, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/10 */
    { 0x0e31, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/12 */
    { 0x0e39, 0x08db, 0x0001, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/14 */
    { 0x0244, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/0 */
    { 0x024c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/2 */
    { 0x0254, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/4 */
    { 0x025c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/6 */
    { 0x0264, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/8 */
    { 0x026c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/10 */
    { 0x0274, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/12 */
    { 0x027c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/14 */
    { 0x0644, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/0 */
    { 0x064c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/2 */
    { 0x0654, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/4 */
    { 0x065c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/6 */
    { 0x0664, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/8 */
    { 0x066c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/10 */
    { 0x0674, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/12 */
    { 0x067c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/14 */
    { 0x0a44, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/0 */
    { 0x0a4c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/2 */
    { 0x0a54, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/4 */
    { 0x0a5c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/6 */
    { 0x0a64, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/8 */
    { 0x0a6c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/10 */
    { 0x0a74, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/12 */
    { 0x0a7c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/14 */
    { 0x0e44, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/0 */
    { 0x0e4c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/2 */
    { 0x0e54, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/4 */
    { 0x0e5c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/6 */
    { 0x0e64, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/8 */
    { 0x0e6c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/10 */
    { 0x0e74, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/12 */
    { 0x0e7c, 0xa6f9, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/14 */
    { 0x0140, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/0 */
    { 0x0148, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/2 */
    { 0x0150, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/4 */
    { 0x0158, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/6 */
    { 0x0160, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/8 */
    { 0x0168, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/10 */
    { 0x0170, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/12 */
    { 0x0178, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/14 */
    { 0x0540, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/0 */
    { 0x0548, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/2 */
    { 0x0550, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/4 */
    { 0x0558, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/6 */
    { 0x0560, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/8 */
    { 0x0568, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/10 */
    { 0x0570, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/12 */
    { 0x0578, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/14 */
    { 0x0940, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/0 */
    { 0x0948, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/2 */
    { 0x0950, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/4 */
    { 0x0958, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/6 */
    { 0x0960, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/8 */
    { 0x0968, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/10 */
    { 0x0970, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/12 */
    { 0x0978, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/14 */
    { 0x0d40, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/0 */
    { 0x0d48, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/2 */
    { 0x0d50, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/4 */
    { 0x0d58, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/6 */
    { 0x0d60, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/8 */
    { 0x0d68, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/10 */
    { 0x0d70, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/12 */
    { 0x0d78, 0x142e, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/14 */
    { 0x0347, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/0 */
    { 0x034f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/2 */
    { 0x0357, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/4 */
    { 0x035f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/6 */
    { 0x0367, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/8 */
    { 0x036f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/10 */
    { 0x0377, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/12 */
    { 0x037f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/14 */
    { 0x0747, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/0 */
    { 0x074f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/2 */
    { 0x0757, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/4 */
    { 0x075f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/6 */
    { 0x0767, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/8 */
    { 0x076f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/10 */
    { 0x0777, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/12 */
    { 0x077f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/14 */
    { 0x0b47, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/0 */
    { 0x0b4f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/2 */
    { 0x0b57, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/4 */
    { 0x0b5f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/6 */
    { 0x0b67, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/8 */
    { 0x0b6f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/10 */
    { 0x0b77, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/12 */
    { 0x0b7f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/14 */
    { 0x0f47, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/0 */
    { 0x0f4f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/2 */
    { 0x0f57, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/4 */
    { 0x0f5f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/6 */
    { 0x0f67, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/8 */
    { 0x0f6f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/10 */
    { 0x0f77, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/12 */
    { 0x0f7f, 0xc7e0, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/14 */
};
uint32_t const g_cTests_fistt_r80_to_i16_intel = RT_ELEMENTS(g_aTests_fistt_r80_to_i16_intel);


/* end of file */
