/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.ancestorstatistics;

import ancestris.modules.gedcom.consanguinity.ComputeConsanguinity;
import ancestris.modules.gedcom.consanguinity.ConsanguiniteInfo;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReportAncestorStatistics
extends Report {
    private static final String LINE_SEPARATOR = "--------------------------------------------------------------------------------";
    private double dImplexFactor;
    private final List<GenerationInfo> vecGenerationInfo = new ArrayList<GenerationInfo>();
    private final Set<String> setIndi = new HashSet<String>();
    private final Set<String> setCommonAncestor = new HashSet<String>();
    private final Map<String, Indi> mapImplexCommonIndi = new TreeMap<String, Indi>();
    private double dConsanguinityFactor;
    private final Map<String, ConsanguiniteInfo> mapConsanguinityCommonIndi = new TreeMap<String, ConsanguiniteInfo>();
    private final List<ConsanguiniteInfo> commonConsanguinity = new ArrayList<ConsanguiniteInfo>();

    public void start(Indi indi) {
        this.clearStats();
        this.computeConsanguinityFactor(indi);
        if (this.dConsanguinityFactor == -1.0) {
            return;
        }
        this.computeImplexFactor(indi);
        this.printHeader(indi);
        this.printImplexStats();
        this.printConsanguinityStats(indi);
        this.println("");
        this.println(this.translate("footer_info"));
    }

    private void clearStats() {
        this.dImplexFactor = 0.0;
        this.vecGenerationInfo.clear();
        this.setIndi.clear();
        this.setCommonAncestor.clear();
        this.mapImplexCommonIndi.clear();
        this.dConsanguinityFactor = 0.0;
        this.mapConsanguinityCommonIndi.clear();
    }

    private void printHeader(Indi indi) {
        this.println(this.translate("name"));
        this.println();
        this.println(this.translate("root_individual"));
        this.println(LINE_SEPARATOR);
        this.println(indi.toString());
        this.println();
        this.println(this.translate("implex_factor", new Object[]{this.dImplexFactor}));
        this.println(this.translate("consanguinity_factor", new Object[]{this.dConsanguinityFactor}));
        this.println();
    }

    private void printImplexStats() {
        this.println(ReportAncestorStatistics.align((String)this.translate("header_implex_generation"), (int)10, (int)0) + ReportAncestorStatistics.align((String)this.translate("header_implex_possible"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_known"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_known_percent"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_cumul"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_cumul_percent"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_diff"), (int)10, (int)2) + ReportAncestorStatistics.align((String)this.translate("header_implex_implex"), (int)10, (int)2));
        this.println(LINE_SEPARATOR);
        for (GenerationInfo info : this.vecGenerationInfo) {
            this.println(ReportAncestorStatistics.align((String)("" + info.iLevel), (int)10, (int)0) + ReportAncestorStatistics.align((String)("" + info.iPossibleCount), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.iKnownCount), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.dCoverage + "%"), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.iKnownCumul), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.dCoverageCumul + "%"), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.iDiffCount), (int)10, (int)2) + ReportAncestorStatistics.align((String)("" + info.dImplex + "%"), (int)10, (int)2));
        }
        this.println();
        this.println(this.translate("header_implex_common_ancestors"));
        this.println(LINE_SEPARATOR);
        Collection<Indi> col = this.mapImplexCommonIndi.values();
        Iterator<Indi> itr1 = col.iterator();
        while (itr1.hasNext()) {
            this.println(itr1.next());
        }
        this.println();
    }

    private void printConsanguinityStats(Indi indi) {
        this.println(this.translate("header_consanguinity_common_ancestors"));
        this.println(LINE_SEPARATOR);
        for (ConsanguiniteInfo info : this.mapConsanguinityCommonIndi.values()) {
            this.println(ReportAncestorStatistics.align((String)info.getIndi().toString(), (int)80, (int)0));
        }
        this.println();
        this.println(this.translate("header_consanguinity_not_null"));
        this.println(LINE_SEPARATOR);
        for (ConsanguiniteInfo info : this.commonConsanguinity) {
            this.println(ReportAncestorStatistics.align((String)info.getIndi().toString(), (int)60, (int)0) + ReportAncestorStatistics.align((String)(String.format("%6.3e", Float.valueOf(info.getCoefficient())) + ""), (int)20, (int)2));
        }
    }

    private void computeImplexFactor(Indi indi) {
        ArrayList<Indi> listIndi = new ArrayList<Indi>();
        listIndi.add(indi);
        int iLevel = 1;
        while (!listIndi.isEmpty()) {
            ArrayList<Indi> listParent = new ArrayList<Indi>();
            this.computeGeneration(iLevel, listIndi, listParent);
            listIndi = listParent;
            ++iLevel;
        }
        long iPossibleCumul = 0L;
        long iKnownCumul = 0L;
        long iDiffCumul = 0L;
        for (GenerationInfo info : this.vecGenerationInfo) {
            info.iPossibleCount = (long)Math.pow(2.0, info.iLevel - 1);
            info.iPossibleCumul = iPossibleCumul += info.iPossibleCount;
            info.iKnownCumul = iKnownCumul += info.iKnownCount;
            info.iDiffCumul = iDiffCumul += info.iDiffCount;
            info.dCoverage = (double)(10000L * info.iKnownCount / info.iPossibleCount) / 100.0;
            info.dCoverageCumul = (double)(10000L * info.iKnownCumul / info.iPossibleCumul) / 100.0;
            if (iKnownCumul == 0L) continue;
            this.dImplexFactor = info.dImplex = (double)(10000L * (info.iKnownCumul - info.iDiffCumul) / info.iKnownCumul) / 100.0;
        }
    }

    private void addCommonAncestor(Indi indi) {
        if (indi == null) {
            return;
        }
        String strId = indi.getId();
        this.setCommonAncestor.add(strId);
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (famc != null) {
            this.addCommonAncestor(famc.getWife());
            this.addCommonAncestor(famc.getHusband());
        }
    }

    private void computeGeneration(int iLevel, List<Indi> listIndi, List<Indi> listParent) {
        GenerationInfo info = new GenerationInfo(iLevel);
        this.vecGenerationInfo.add(info);
        for (Indi indi : listIndi) {
            Indi indiHusband;
            String strId = indi.getId();
            if (this.setIndi.contains(strId)) {
                if (!this.setCommonAncestor.contains(strId)) {
                    this.mapImplexCommonIndi.put(strId, indi);
                    this.addCommonAncestor(indi);
                }
            } else {
                this.setIndi.add(strId);
                ++info.iDiffCount;
            }
            ++info.iKnownCount;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi indiWife = famc.getWife();
            if (indiWife != null) {
                listParent.add(indiWife);
            }
            if ((indiHusband = famc.getHusband()) == null) continue;
            listParent.add(indiHusband);
        }
    }

    private void computeConsanguinityFactor(Indi indi) {
        this.dConsanguinityFactor = 0.0;
        ComputeConsanguinity calculation = new ComputeConsanguinity(indi);
        this.dConsanguinityFactor = calculation.compute();
        if (this.dConsanguinityFactor != -1.0) {
            for (ConsanguiniteInfo c : calculation.getCommonAncestors()) {
                this.mapConsanguinityCommonIndi.put(c.getId(), c);
            }
            this.commonConsanguinity.addAll(calculation.getCoefficientNotNul());
        } else {
            this.println(this.translate("loop_error", new Object[]{((ConsanguiniteInfo)calculation.getPotentialLoop().get()).getIndi()}));
        }
    }

    private class GenerationInfo {
        int iLevel;
        long iPossibleCount;
        long iKnownCount;
        long iDiffCount;
        long iPossibleCumul;
        long iKnownCumul;
        long iDiffCumul;
        double dCoverage;
        double dCoverageCumul;
        double dImplex;

        GenerationInfo(int iLevel) {
            this.iLevel = iLevel;
        }
    }
}

