/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.demography;

import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ReportDemography
extends Report {
    private static final int MAX_AGE = 100;
    private int ageGroupSize = 10;
    private String[] categories;

    public int getAgeGroupSize() {
        return this.ageGroupSize;
    }

    public void setAgeGroupSize(int set) {
        this.ageGroupSize = Math.max(1, Math.min(25, set));
    }

    public JPanel start(Gedcom gedcom) throws Exception {
        this.createCategories();
        String labelForMen = this.translate("men");
        String labelForWomen = this.translate("women");
        String labelForFathers = this.translate("fathers");
        String labelForMothers = this.translate("mothers");
        String diagramTitle = this.translate("title", new Object[]{gedcom.getName()});
        IndiAnalyzer[] indiAnalyzers = new IndiAnalyzer[]{new IndiAnalyzer(labelForMen, labelForWomen, PropertyAge.getLabelForAge()){

            @Override
            public void addFact(Indi indi) {
                try {
                    this.addAge(indi, indi.getDeathDateOption());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new IndiAnalyzer(labelForMen, labelForWomen, this.translate("ageAtFirstMariage")){

            @Override
            public void addFact(Indi indi) {
                try {
                    this.addAge(indi, indi.getFamiliesWhereSpouse()[0].getMarriageDate());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new IndiAnalyzer(labelForFathers, labelForMothers, this.translate("ageAtParentsDeath")){

            @Override
            public void addFact(Indi indi) {
                try {
                    this.addAgeForMale(indi, indi.getBiologicalFather().getDeathDate());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                try {
                    this.addAgeForFemale(indi, indi.getBiologicalMother().getDeathDate());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new IndiAnalyzer(labelForFathers, labelForMothers, this.translate("ageAtChildsBirth")){

            @Override
            public void addFact(Indi indi) {
                try {
                    PropertyDate birthDate = indi.getBirthDateOption();
                    try {
                        this.addAgeForMale(indi.getBiologicalFather(), birthDate);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    this.addAgeForFemale(indi.getBiologicalMother(), birthDate);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new IndiAnalyzer(labelForFathers, labelForMothers, this.translate("ageOfYoungestChildLeftBehind")){

            @Override
            public void addFact(Indi indi) {
                try {
                    PropertyDate deathDate = indi.getDeathDateOption();
                    Fam[] fams = indi.getFamiliesWhereSpouse();
                    Fam fam = fams[fams.length - 1];
                    Indi[] children = fam.getChildren();
                    Indi child = children[children.length - 1];
                    if (indi.getSex() == 1) {
                        this.addAgeForMale(child, deathDate);
                    } else {
                        this.addAgeForFemale(child, deathDate);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new IndiAnalyzer(labelForMen, labelForWomen, this.translate("yearsSinceDeathOfSpouse")){

            @Override
            public void addFact(Indi indi) {
                try {
                    Indi[] partners = indi.getPartners();
                    for (int i = 0; i < partners.length; ++i) {
                        try {
                            this.addRemainingYears(indi, partners[i].getDeathDateOption());
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }};
        FamAnalyzer[] famAnalyzers = new FamAnalyzer[]{new FamAnalyzer(labelForMen, labelForWomen, this.translate("ageAtDivorce")){

            @Override
            public void addFact(Fam fam) {
                try {
                    PropertyDate divorce = fam.getDivorceDate();
                    try {
                        this.addAgeForMale(fam.getHusband(), divorce);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    this.addAgeForFemale(fam.getWife(), divorce);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new FamAnalyzer(labelForMen, labelForWomen, this.translate("ageOfOldestWhenYoungestWasBorn")){

            @Override
            public void addFact(Fam fam) {
                try {
                    Indi[] children = fam.getChildren();
                    if (1 >= children.length) {
                        return;
                    }
                    Indi youngest = children[children.length - 1];
                    Indi oldest = children[0];
                    this.addAge(oldest, youngest.getBirthDateOption());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }, new FamAnalyzer(labelForFathers, labelForMothers, this.translate("ageOfYoungestOrphan")){

            @Override
            public void addFact(Fam fam) {
                try {
                    Indi[] children = fam.getChildren();
                    Indi youngest = children[children.length - 1];
                    PropertyDate father = fam.getHusband().getDeathDateOption();
                    PropertyDate mother = fam.getWife().getDeathDateOption();
                    if (father.getStart().getYear() > mother.getStart().getYear()) {
                        this.addAgeForMale(youngest, father);
                    } else {
                        this.addAgeForFemale(youngest, mother);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }};
        this.gatherData(gedcom, indiAnalyzers, famAnalyzers);
        return this.showData(diagramTitle, indiAnalyzers, famAnalyzers);
    }

    private JPanel showData(String title, IndiAnalyzer[] indiAnalyzers, FamAnalyzer[] famAnalyzers) {
        int i;
        JTabbedPane charts = new JTabbedPane();
        for (i = 0; i < indiAnalyzers.length; ++i) {
            charts.addTab(indiAnalyzers[i].getAgeLabel(), (Component)indiAnalyzers[i].createChart(title));
        }
        for (i = 0; i < famAnalyzers.length; ++i) {
            charts.addTab(famAnalyzers[i].getAgeLabel(), (Component)famAnalyzers[i].createChart(title));
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", charts);
        return panel;
    }

    private void gatherData(Gedcom gedcom, IndiAnalyzer[] indiAnalyzers, FamAnalyzer[] famAnalyzers) {
        for (Indi indi : gedcom.getIndis()) {
            for (IndiAnalyzer indiAnalyzer : indiAnalyzers) {
                indiAnalyzer.addFact(indi);
            }
        }
        for (Fam fam : gedcom.getEntities("FAM")) {
            for (int i = 0; i < famAnalyzers.length; ++i) {
                famAnalyzers[i].addFact(fam);
            }
        }
    }

    private void createCategories() {
        this.categories = new String[100 / this.ageGroupSize + 1];
        this.categories[0] = "100+";
        for (int i = 1; i < this.categories.length; ++i) {
            this.categories[i] = this.ageGroupSize < 5 && (double)i % Math.ceil(5.0f / (float)this.ageGroupSize) != 0.0 ? "" : 100 - i * this.ageGroupSize + "+";
        }
    }

    private abstract class Analyzer {
        private IndexedSeries males;
        private IndexedSeries females;
        private String ageLabel;

        public Analyzer(String maleLabel, String femaleLabel, String ageLabel) {
            this.ageLabel = ageLabel;
            this.males = new IndexedSeries(maleLabel, ReportDemography.this.categories.length);
            this.females = new IndexedSeries(femaleLabel, ReportDemography.this.categories.length);
        }

        public Chart createChart(String title) {
            IndexedSeries[] nestedSeries = new IndexedSeries[]{this.males, this.females};
            DecimalFormat decimalFormat = new DecimalFormat("#; #");
            return new Chart(title, this.ageLabel, nestedSeries, ReportDemography.this.categories, (NumberFormat)decimalFormat, true, true);
        }

        private int calculateGroup(PropertyDate firstEvent, PropertyDate lastEvent) {
            if (!firstEvent.isValid() || !lastEvent.isValid()) {
                throw new IllegalArgumentException();
            }
            try {
                if (firstEvent.getStart().getJulianDay() > lastEvent.getStart().getJulianDay()) {
                    throw new IllegalArgumentException();
                }
            }
            catch (GedcomException e) {
                throw new IllegalArgumentException();
            }
            int years = Delta.get((PointInTime)firstEvent.getStart(), (PointInTime)lastEvent.getStart()).getYears();
            return years >= 100 ? 0 : (100 - years - 1) / ReportDemography.this.ageGroupSize + 1;
        }

        protected void addAgeForMale(Indi individual, PropertyDate event) {
            this.males.dec(this.calculateGroup(individual.getBirthDate(), event));
        }

        protected void addAgeForFemale(Indi individual, PropertyDate event) {
            this.females.inc(this.calculateGroup(individual.getBirthDate(), event));
        }

        protected void addAge(Indi individual, PropertyDate event) {
            if (individual.getSex() == 1) {
                this.addAgeForMale(individual, event);
            } else {
                this.addAgeForFemale(individual, event);
            }
        }

        protected void addRemainingYears(Indi individual, PropertyDate event) {
            int group = this.calculateGroup(event, individual.getDeathDate());
            if (individual.getSex() == 1) {
                this.males.dec(group);
            } else {
                this.females.inc(group);
            }
        }

        public String getAgeLabel() {
            return this.ageLabel;
        }
    }

    private abstract class IndiAnalyzer
    extends Analyzer {
        public IndiAnalyzer(String maleLabel, String femaleLabel, String ageLabel) {
            super(maleLabel, femaleLabel, ageLabel);
        }

        public abstract void addFact(Indi var1);
    }

    private abstract class FamAnalyzer
    extends Analyzer {
        public FamAnalyzer(String maleLabel, String femaleLabel, String ageLabel) {
            super(maleLabel, femaleLabel, ageLabel);
        }

        public abstract void addFact(Fam var1);
    }
}

