/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.linescirc;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.linescirc.IndividualData;
import ancestris.reports.linescirc.PersonCell;
import ancestris.reports.linescirc.PsOptions;
import ancestris.reports.linescirc.SvgOptions;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Fam;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.report.Translator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ReportLinesCirc
extends Report {
    private static final Charset SVG_CHARSET = Charset.forName("UTF-8");
    private static final Charset PS_CHARSET = Charset.forName("ISO-8859-1");
    private static final int RADIUS_LENGTH = 150;
    private static final int SVG_LENGTH = 1800;
    private static final int SVG_WIDTH = 1800;
    private static final String SVG_NAME_SPACE = "http://www.w3.org/2000/svg";
    private static final int[] FONT_SIZE = new int[]{12, 12, 12, 12, 10, 8, 7, 6, 5, 5, 4};
    private static final int[] MARRIAGE_SIZE = new int[]{10, 10, 10, 10, 8, 7, 6, 5, 4, 4, 3};
    private final Translator translator = new Translator((Report)this);
    private int maxlevel = 10;
    private int x_pages = 1;
    private int y_pages = 1;
    private int radius = 0;
    private boolean alternating;
    private boolean gradient;
    private boolean marrest;
    private boolean printmarr;
    private int enc_choice = 1;
    private String font_name = "Helvetica";
    public PsOptions psOptions = new PsOptions(this.translator);
    public SvgOptions svgOptions = new SvgOptions(this.translator);
    private PrintWriter writer;
    private final int indicentre = 1;
    private int numindilines = 0;
    private int nummarr = -1;
    private static final String VERSION = "genj 1.0";
    private boolean transparent;
    private int numcenter;
    private final Map<Integer, IndividualData> data = new HashMap<Integer, IndividualData>();
    private final List<Element> texts = new ArrayList<Element>();
    private final Map<String, Color> geoColor = new HashMap<String, Color>();
    private final Set<Color> colorUsed = new HashSet<Color>();
    private final Random random = new Random();

    private PrintWriter getWriter(OutputStream out) {
        if (this.svgOptions.isSvg) {
            return new PrintWriter(new OutputStreamWriter(out, SVG_CHARSET));
        }
        return new PrintWriter(new OutputStreamWriter(out, PS_CHARSET));
    }

    public File start(Indi indi) {
        this.initUserOptions();
        File file = this.svgOptions.isSvg ? this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, FileChooserBuilder.getImageFilter().getExtensions()[6]) : this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, FileChooserBuilder.getPdfFilter().getExtensions()[1]);
        if (file == null) {
            return null;
        }
        try {
            this.writer = this.getWriter(new FileOutputStream(file));
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, this.translate("output.error"), ioe);
            return null;
        }
        if (this.svgOptions.isSvg) {
            this.mainSvg(indi);
            this.writer.flush();
            this.writer.close();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                Document doc = dbf.newDocumentBuilder().parse(file);
                doc.getDocumentElement().normalize();
                doc.getDocumentElement().setAttribute("font-family", this.svgOptions.fontNames[this.svgOptions.fontName]);
                for (Element ele : this.texts) {
                    Node node = doc.importNode(ele, true);
                    doc.getDocumentElement().appendChild(node);
                }
                this.writer = this.getWriter(new FileOutputStream(file));
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(this.writer));
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException ex) {
                LOG.log(Level.INFO, this.translate("output.error"), ex);
            }
        } else {
            this.main(indi);
        }
        this.writer.flush();
        this.writer.close();
        return file;
    }

    private void initUserOptions() {
        this.numindilines = 0;
        this.nummarr = -1;
        this.marrest = false;
        this.printmarr = true;
        this.alternating = this.psOptions.colouroption == 0;
        this.gradient = this.psOptions.colouroption == 2;
        this.maxlevel = this.svgOptions.isSvg ? this.svgOptions.umaxlevel + 5 : this.psOptions.umaxlevel + 5;
        this.enc_choice = 1 + this.psOptions.uenc_choice;
        this.font_name = this.translate("ufont_name." + this.psOptions.ufont_name);
        this.transparent = this.psOptions.colouroption != 0;
        switch (this.psOptions.unb_pages) {
            case 1: {
                this.x_pages = 2;
                this.y_pages = 1;
                break;
            }
            case 2: {
                this.x_pages = 2;
                this.y_pages = 2;
                break;
            }
            case 3: {
                this.x_pages = 3;
                this.y_pages = 2;
                break;
            }
            case 4: {
                this.x_pages = 4;
                this.y_pages = 3;
                break;
            }
            case 5: {
                this.x_pages = 5;
                this.y_pages = 4;
                break;
            }
            case 6: {
                this.x_pages = 6;
                this.y_pages = 4;
                break;
            }
            default: {
                this.x_pages = 1;
                this.y_pages = 1;
            }
        }
        this.data.clear();
        this.texts.clear();
        this.geoColor.clear();
        this.colorUsed.clear();
        this.colorUsed.add(Color.BLACK);
        this.colorUsed.add(Color.WHITE);
    }

    private String putGivenName(Indi person, int length) {
        return this.escapePsString(this.truncateString(this.givens(person), length));
    }

    private String putFullName(Indi person, int sur_upper, int n_order, int length) {
        return this.fullname(person, sur_upper, n_order, length);
    }

    private void endline(int ahnen, int offset, int info, int max) {
        this.writer.println(") " + ahnen + " " + offset + " " + info + " " + max + "} addind");
    }

    private void putperson(Fam family, Indi person, int level, int ahnen, int info, int dateformat) {
        int[] levellength = new int[]{25, 26, 23, 16, 15, 15, 21, 21, 21, 21, 21};
        PersonCell pCell = new PersonCell();
        if (this.eq(level, 1)) {
            this.numindilines += pCell.add(this.surname(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.putGivenName(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.and(this.ge(level, 2), this.le(level, 6))) {
            this.numindilines += pCell.add(this.surname(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.putGivenName(person, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.or(this.eq(level, 7), this.eq(level, 8))) {
            this.numindilines += pCell.add(this.putFullName(person, 0, 1, levellength[level]), this.numindilines);
            this.numindilines += pCell.add(this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        } else if (this.ge(level, 9)) {
            this.numindilines += pCell.add(this.putFullName(person, 0, 1, levellength[level]) + this.getDateString(this.birth(person), this.death(person), dateformat), this.numindilines);
            this.writer.print(pCell.get(ahnen, info));
        }
        if (this.printmarr) {
            if (this.marrest) {
                // empty if block
            }
            if (this.marriage(family) != null && this.eq("M", this.sex(person))) {
                ++this.nummarr;
                this.writer.println(this.d(this.nummarr) + " {(" + this.date(this.marriage(family)) + ") " + this.d(ahnen) + " " + this.d(info) + "} addmarr");
            }
        }
    }

    private void semicirc(Fam family, Indi person, int level, int ahnen, int info, int maxlevel, int dateformat) {
        if (person != null && this.le(level, maxlevel)) {
            this.putperson(family, person, level, ahnen, info, dateformat);
            int nextlevel = this.add(level, 1);
            int nextahnen = this.mul(ahnen, 2);
            this.semicirc(this.parents(person), this.father(person), nextlevel, nextahnen, info, maxlevel, dateformat);
            this.semicirc(this.parents(person), this.mother(person), nextlevel, this.add(nextahnen, 1), info, maxlevel, dateformat);
        }
    }

    boolean le(int a, int b) {
        return a <= b;
    }

    boolean gt(int a, int b) {
        return a > b;
    }

    boolean ge(int a, int b) {
        return a >= b;
    }

    boolean ne(int a, int b) {
        return a != b;
    }

    boolean eq(int a, int b) {
        return a == b;
    }

    boolean eq(String a, String b) {
        return a.equals(b);
    }

    boolean or(boolean a, boolean b) {
        return a || b;
    }

    boolean and(boolean a, boolean b) {
        return a && b;
    }

    int add(int a, int b) {
        return a + b;
    }

    int mul(int a, int b) {
        return a * b;
    }

    int getel(int[] intarray, int offset) {
        if (offset >= intarray.length) {
            return 0;
        }
        return intarray[offset];
    }

    String d(int i) {
        return "" + i;
    }

    String d(boolean b) {
        return b ? "1" : "0";
    }

    PropertyDate birth(Indi entity) {
        if (entity == null) {
            return null;
        }
        return entity.getBirthDateOption();
    }

    PropertyDate death(Indi entity) {
        if (entity == null) {
            return null;
        }
        return entity.getDeathDateOption();
    }

    String date(PropertyDate date) {
        if (date != null) {
            return date.getReportValue(null, GedcomOptions.GedcomDateFormat.SHORT);
        }
        return "";
    }

    String year(PropertyDate date) {
        if (date != null) {
            return date.getStart().isValid() ? "" + date.getStart().getYear() : "????";
        }
        return "";
    }

    PropertyDate marriage(Fam family) {
        if (family == null) {
            return null;
        }
        Property prop = family.getProperty("MARR");
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop.getProperty("DATE");
    }

    Indi husband(Fam fam) {
        return fam == null ? null : fam.getHusband();
    }

    Indi wife(Fam fam) {
        return fam == null ? null : fam.getWife();
    }

    Fam parents(Indi person) {
        return person == null ? null : person.getFamilyWhereBiologicalChild();
    }

    Indi father(Indi person) {
        return person == null ? null : this.husband(this.parents(person));
    }

    Indi mother(Indi person) {
        return person == null ? null : this.wife(this.parents(person));
    }

    String sex(Indi indi) {
        if (indi == null) {
            return "";
        }
        if (indi.getSex() == 1) {
            return "M";
        }
        if (indi.getSex() == 2) {
            return "F";
        }
        return "";
    }

    private String fullname(Indi indi, int isUpper, int type, int length) {
        if (indi.getName().length() <= length) {
            return this.escapePsString(indi.getName());
        }
        return this.escapePsString(this.truncateString(indi.getName(), length));
    }

    String surname(Indi indi, int length) {
        if (indi == null) {
            return "";
        }
        return this.escapePsString(this.truncateString(indi.getLastName(), length));
    }

    String givens(Indi indi) {
        if (indi == null) {
            return "";
        }
        return indi.getFirstName();
    }

    private String truncateString(String s, int length) {
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }

    private String escapePsString(String s) {
        String result = s.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        return result;
    }

    private void putpageprintouts(int xn, int yn) {
        int page_num = 0;
        for (int yi = yn - 1; yi >= 0; --yi) {
            int yi_ord = yn - 1 - yi;
            for (int xi = xn - 1; xi >= 0; --xi) {
                page_num = this.add(page_num, 1);
                this.writer.println("%%Page: " + page_num + " " + page_num + "\ncleartomark mark\n" + xi + " " + yi + " print-a-page\nshowpage\n");
            }
        }
    }

    private void printfile() {
        this.writer.println("%!PS-Adobe-3.0");
        this.writer.println("%%Title: (PS-CIRCLE.PS - Circular Genealogical Pedigree Chart in Postscript format)");
        this.writer.println("%%Creator: genj 1.0 - a Lifelines circle ancestry chart report generator");
        this.writer.println("%%CreationDate: ");
        this.writer.println("%%Pages: " + this.d(this.mul(this.x_pages, this.y_pages)));
        this.writer.println("%%PageOrder: Ascend");
        this.writer.println("%%Orientation: Portrait");
        this.writer.println("%%EndComments\n");
        this.writer.println("%%BeginDefaults");
        this.writer.println("%%ViewingOrientation: 1 0 0 1");
        this.writer.println("%%EndDefaults\n");
        this.writer.println("%%BeginProlog\n");
        this.writer.println("%   much of the code involved with font encoding and with multipaging");
        this.writer.println("%   is borrowed from Robert Simms <rsimms@ces.clemson.edu>\n");
        this.writer.println("%page margins");
        this.writer.println("/margin_top 20 def");
        this.writer.println("/margin_bottom 20 def");
        this.writer.println("/margin_left 20 def");
        this.writer.println("/margin_right 20 def\n");
        this.writer.println("%number of pages in each direction");
        this.writer.println("/xpages " + this.d(this.x_pages) + " def");
        this.writer.println("/ypages " + this.d(this.y_pages) + " def\n");
        this.writer.println("/fontname /" + this.font_name + " def\n");
        this.writer.println("/portrait true def\n");
        this.writer.println("/inch {72 mul} def\n");
        this.writer.println("/*SF {                 % Complete selectfont emulation");
        this.writer.println("  exch findfont exch");
        this.writer.println("  dup type /arraytype eq {makefont}{scalefont} ifelse setfont");
        this.writer.println("} bind def\n");
        this.writer.println("/BuildRectPath{");
        this.writer.println("\tdup type dup /integertype eq exch /realtype eq or{");
        this.writer.println("\t\t\t4 -2 roll moveto \t%Operands are: x y width height");
        this.writer.println("\t\t\tdup 0 exch rlineto");
        this.writer.println("\t\t\texch 0 rlineto");
        this.writer.println("\t\t\tneg 0 exch rlineto");
        this.writer.println("\t\t\tclosepath");
        this.writer.println("\t\t}{");
        this.writer.println("\t\t\tdup length 4 sub 0 exch 4 exch{");
        this.writer.println("\t\t\t\t1 index exch 4 getinterval aload pop");
        this.writer.println("\t\t\t\tBuildRectPath");
        this.writer.println("\t\t\t}for");
        this.writer.println("\t\t\tpop");
        this.writer.println("\t\t}ifelse");
        this.writer.println("} bind def\n");
        this.writer.println("/*RC { gsave newpath BuildRectPath fill grestore } bind def\n");
        this.writer.println("% install Level 2 emulations, or substitute built-in Level 2 operators");
        this.writer.println("/languagelevel where");
        this.writer.println("  {pop languagelevel}{1} ifelse");
        this.writer.println("2 lt {");
        this.writer.println("  /RC /*RC load def");
        this.writer.println("  /SF /*SF load def");
        this.writer.println("}{");
        this.writer.println("  /RC /rectclip load def      % use RC instead of rectclip");
        this.writer.println("  /SF /selectfont load def    % use SF instead of selectfont");
        this.writer.println("} ifelse\n");
        this.writer.println("%Coordinate conversion utilities");
        this.writer.println("/polar { %(ang rad) -> (x y)");
        this.writer.println("\t/rad exch def\t\t/ang exch def");
        this.writer.println("\t/x rad ang cos mul def\t\t/y rad ang sin mul def");
        this.writer.println("\tx y");
        this.writer.println("} def\n");
        this.writer.println("/midang {");
        this.writer.println("\t/inf exch def");
        this.writer.println("\tinf 1 eq {360 2 maxlevel exp div mul -90.0 add}           %for first level male, go counter clockwise from bottom");
        this.writer.println("\t\t\t\t{360 2 maxlevel exp div mul 90.0 add} ifelse     %for first level female, go clockwise from bottom");
        this.writer.println("} def\n");
        this.writer.println("%Shortcut macros");
        this.writer.println("/m {moveto} def\t\t/l {lineto} def\n");
        this.writer.println("%Constants");
        this.writer.println("/pi 3.14159265358979 def");
        this.writer.println("/ptsize 10 def");
        this.writer.println("/offset ptsize 1.25 mul neg def\n");
        this.writer.println("/radius {4.0 7.0 div exch indicentre add mul inch} def");
        this.writer.println("%begin font encoding   borrowed from Robert Simms");
        if (this.ne(this.enc_choice, 0)) {
            this.writer.println("/encvecmod* {  % on stack should be /Encoding and an encoding array");
            this.writer.println("\t% make an array copy so we don't try to modify the original via pointer");
            this.writer.println("\tdup length array copy");
            this.writer.println("\tencvecmod aload length dup 2 idiv exch 2 add -1 roll exch");
            this.writer.println("\t{dup 4 2 roll put}");
            this.writer.println("\trepeat");
            this.writer.println("} def");
            this.writer.println("/reenc {");
            this.writer.println("\tfindfont");
            this.writer.println("\tdup length dict begin");
            this.writer.println("\t\t{1 index /FID eq {pop pop} {");
            this.writer.println("\t\t\t1 index /Encoding eq {");
            this.writer.println("\t\t\t\t\tencvecmod* def");
            this.writer.println("\t\t\t\t}{def} ifelse");
            this.writer.println("\t\t\t} ifelse");
            this.writer.println("\t\t} forall");
            this.writer.println("\t\tcurrentdict");
            this.writer.println("\tend");
            this.writer.println("\tdefinefont pop");
            this.writer.println("} def");
        }
        if (this.eq(this.enc_choice, 1)) {
            this.writer.println("% Adjust the font so that it is iso-8859-1 compatible");
            this.writer.println("/languagelevel where {pop languagelevel}{1} ifelse 2 ge {");
            this.writer.println("\t/encvecmod* {pop ISOLatin1Encoding} def\t% Use built-in ISOLatin1Encoding if PS interpreter is Level 2");
            this.writer.println("}{");
            this.writer.println("\t/encvecmod [");
            this.writer.println("\t\t16#90 /dotlessi   16#91 /grave        16#92 /acute      16#93 /circumflex");
            this.writer.println("\t\t16#94 /tilde      16#95 /macron       16#96 /breve      16#97 /dotaccent");
            this.writer.println("\t\t16#98 /dieresis   16#99 /.notdef      16#9a /ring       16#9b /cedilla");
            this.writer.println("\t\t16#9c /.notdef    16#9d /hungarumlaut 16#9e /ogonek     16#9f /caron");
            this.writer.println("\t\t16#a0 /space      16#a1 /exclamdown   16#a2 /cent       16#a3 /sterling");
            this.writer.println("\t\t16#a4 /currency   16#a5 /yen         16#a6 /brokenbar   16#a7 /section");
            this.writer.println("\t\t16#a8 /dieresis   16#a9 /copyright   16#aa /ordfeminine 16#ab /guillemotleft");
            this.writer.println("\t\t16#ac /logicalnot 16#ad /hyphen      16#ae /registered  16#af /macron");
            this.writer.println("\t\t16#b0 /degree     16#b1 /plusminus   16#b2 /twosuperior 16#b3 /threesuperior");
            this.writer.println("\t\t16#b4 /acute      16#b5 /mu          16#b6 /paragraph    16#b7 /periodcentered");
            this.writer.println("\t\t16#b8 /cedilla    16#b9 /onesuperior 16#ba /ordmasculine 16#bb /guillemotright");
            this.writer.println("\t\t16#bc /onequarter 16#bd /onehalf    16#be /threequarters 16#bf /questiondown");
            this.writer.println("\t\t16#c0 /Agrave      16#c1 /Aacute    16#c2 /Acircumflex 16#c3 /Atilde");
            this.writer.println("\t\t16#c4 /Adieresis   16#c5 /Aring     16#c6 /AE          16#c7 /Ccedilla");
            this.writer.println("\t\t16#c8 /Egrave      16#c9 /Eacute    16#ca /Ecircumflex 16#cb /Edieresis");
            this.writer.println("\t\t16#cc /Igrave      16#cd /Iacute    16#ce /Icircumflex 16#cf /Idieresis");
            this.writer.println("\t\t16#d0 /Eth         16#d1 /Ntilde    16#d2 /Ograve      16#d3 /Oacute");
            this.writer.println("\t\t16#d4 /Ocircumflex 16#d5 /Otilde    16#d6 /Odieresis   16#d7 /multiply");
            this.writer.println("\t\t16#d8 /Oslash      16#d9 /Ugrave    16#da /Uacute      16#db /Ucircumflex");
            this.writer.println("\t\t16#dc /Udieresis   16#dd /Yacute    16#de /Thorn       16#df /germandbls");
            this.writer.println("\t\t16#e0 /agrave      16#e1 /aacute    16#e2 /acircumflex 16#e3 /atilde");
            this.writer.println("\t\t16#e4 /adieresis   16#e5 /aring     16#e6 /ae          16#e7 /ccedilla");
            this.writer.println("\t\t16#e8 /egrave      16#e9 /eacute    16#ea /ecircumflex 16#eb /edieresis");
            this.writer.println("\t\t16#ec /igrave      16#ed /iacute    16#ee /icircumflex 16#ef /idieresis");
            this.writer.println("\t\t16#f0 /eth         16#f1 /ntilde    16#f2 /ograve      16#f3 /oacute");
            this.writer.println("\t\t16#f4 /ocircumflex 16#f5 /otilde    16#f6 /odieresis   16#f7 /divide");
            this.writer.println("\t\t16#f8 /oslash      16#f9 /ugrave    16#fa /uacute      16#fb /ucircumflex");
            this.writer.println("\t\t16#fc /udieresis   16#fd /yacute    16#fe /thorn       16#ff /ydieresis");
            this.writer.println("\t] def");
            this.writer.println("} ifelse\n");
        } else if (this.eq(this.enc_choice, 2)) {
            this.writer.println("/encvecmod [");
            this.writer.println("\t16#a0 /space     16#a1 /Aogonek 16#a2 /breve     16#a3 /Lslash");
            this.writer.println("\t16#a4 /currency  16#a5 /Lcaron  16#a6 /Sacute    16#a7 /section");
            this.writer.println("\t16#a8 /dieresis  16#a9 /Scaron  16#aa /Scedilla  16#ab /Tcaron");
            this.writer.println("\t16#ac /Zacute    16#ad /hyphen  16#ae /Zcaron    16#af /Zdotaccent");
            this.writer.println("\t16#b0 /degree    16#b1 /aogonek 16#b2 /ogonek    16#b3 /lslash");
            this.writer.println("\t16#b4 /acute     16#b5 /lcaron  16#b6 /sacute    16#b7 /caron");
            this.writer.println("\t16#b8 /cedilla   16#b9 /scaron  16#ba /scedilla  16#bb /tcaron");
            this.writer.println("\t16#bc /zacute    16#bd /hungarumlaut 16#be /zcaron 16#bf /zdotaccent");
            this.writer.println("\t16#c0 /Racute    16#c1 /Aacute  16#c2 /Acircumflex 16#c3 /Abreve");
            this.writer.println("\t16#c4 /Adieresis 16#c5 /Lacute  16#c6 /Cacute    16#c7 /Ccedilla");
            this.writer.println("\t16#c8 /Ccaron    16#c9 /Eacute  16#ca /Eogonek   16#cb /Edieresis");
            this.writer.println("\t16#cc /Ecaron    16#cd /Iacute  16#ce /Icircumflex 16#cf /Dcaron");
            this.writer.println("\t16#d0 /Dcroat    16#d1 /Nacute   16#d2 /Ncaron    16#d3 /Oacute");
            this.writer.println("\t16#d4 /Ocircumflex 16#d5 /Ohungarumlaut 16#d6 /Odieresis 16#d7 /multiply");
            this.writer.println("\t16#d8 /Rcaron    16#d9 /Uring   16#da /Uacute    16#db /Uhungarumlaut");
            this.writer.println("\t16#dc /Udieresis 16#dd /Yacute  16#de /Tcommaaccent 16#df /germandbls");
            this.writer.println("\t16#e0 /racute    16#e1 /aacute  16#e2 /acircumflex 16#e3 /abreve");
            this.writer.println("\t16#e4 /adieresis 16#e5 /lacute  16#e6 /cacute    16#e7 /ccedilla");
            this.writer.println("\t16#e8 /ccaron    16#e9 /eacute  16#ea /eogonek   16#eb /edieresis");
            this.writer.println("\t16#ec /ecaron    16#ed /iacute  16#ee /icircumflex 16#ef /dcaron");
            this.writer.println("\t16#f0 /dcroat    16#f1 /nacute  16#f2 /ncaron     16#f3 /oacute");
            this.writer.println("\t16#f4 /ocircumflex 16#f5 /ohungarumlaut 16#f6 /odieresis 16#f7 /divide");
            this.writer.println("\t16#f8 /rcaron    16#f9 /uring   16#fa /uacute    16#fb /uhungarumlaut");
            this.writer.println("\t16#fc /udieresis 16#fd /yacute  16#fe /tcommaaccent  16#ff /dotaccent");
            this.writer.println("] def\n");
        } else if (this.eq(this.enc_choice, 3)) {
            this.writer.println("/encvecmod [");
            this.writer.println("\t16#80 /Ccedilla    16#81 /udieresis 16#82 /eacute      16#83 /acircumflex");
            this.writer.println("\t16#84 /adieresis   16#85 /agrave    16#86 /aring       16#87 /ccedilla");
            this.writer.println("\t16#88 /ecircumflex 16#89 /edieresis 16#8a /egrave      16#8b /idieresis");
            this.writer.println("\t16#8c /icircumflex 16#8d /igrave    16#8e /Adieresis   16#8f /Aring");
            this.writer.println("\t16#90 /Eacute      16#91 /ae        16#92 /AE          16#93 /ocircumflex");
            this.writer.println("\t16#94 /odieresis   16#95 /ograve    16#96 /ucircumflex 16#97 /ugrave");
            this.writer.println("\t16#98 /ydieresis   16#99 /Odieresis 16#9a /Udieresis   16#9b /cent");
            this.writer.println("\t16#9c /sterling    16#9d /yen       16#9e /.notdef     16#9f /florin");
            this.writer.println("\t16#a0 /aacute      16#a1 /iacute    16#a2 /oacute      16#a3 /uacute");
            this.writer.println("\t16#a4 /ntilde      16#a5 /Ntilde    16#a6 /ordfeminine 16#a7 /ordmasculine");
            this.writer.println("\t16#a8 /questiondown 16#a9 /.notdef  16#aa /.notdef     16#ab /onehalf");
            this.writer.println("\t16#ac /onequarter  16#ad /exclamdown 16#ae /guillemotleft  16#af /guillemotright");
            this.writer.println("\t16#e1 /germandbls  16#ed /oslash    16#f1 /plusminus   16#f6 /divide");
            this.writer.println("\t16#f8 /degree      16#f9 /bullet");
            this.writer.println("] def\n");
        }
        if (this.ne(this.enc_choice, 0)) {
            this.writer.println("/gedfont fontname reenc");
            this.writer.println("/fontname /gedfont def\n");
        }
        this.writer.println("%end font encoding   end of section borrowed from Robert Simms");
        if (this.gradient) {
            this.writer.println("/gradient{   %draw and fill 256 circles with a decreasing radius and slightly diffent colour");
            this.writer.println("\t/blue2 exch def\t/green2 exch def\t/red2 exch def");
            this.writer.println("\t/blue1 exch def\t/green1 exch def\t/red1 exch def\n");
            this.writer.println("\t/maxrad maxlevel radius def");
            this.writer.println("\t/delta_r maxrad neg 256 div def                          %find radius step to use\n");
            this.writer.println("\tgsave");
            this.writer.println("\t\tmaxrad delta_r 0.0 {                                  %step through the circles from large to small");
            this.writer.println("\t\t\t/r exch def");
            this.writer.println("\t\t\t/ratio r maxrad div def");
            this.writer.println("\t\t\t/red red1 red2 sub ratio mul red2 add def          % work out the new colour");
            this.writer.println("\t\t\t/blue blue1 blue2 sub ratio mul blue2 add def");
            this.writer.println("\t\t\t/green green1 green2 sub ratio mul green2 add def\n");
            this.writer.println("\t\t\tred green blue setrgbcolor");
            this.writer.println("\t\t\tnewpath 0.0 0.0 r 0 360 arc fill                   %draw and fill circles");
            this.writer.println("\t\t} for");
            this.writer.println("\tgrestore");
            this.writer.println("} def\n");
        }
        this.writer.println("/fan{  %Fan Template");
        this.writer.println("\tgsave");
        if (this.or(!this.printmarr, !this.transparent)) {
            this.writer.println("\t%begin gender specific shading of boxes");
            this.writer.println("\t/c 1 def                          %flag for the alternating colours");
            this.writer.println("\t1 indicentre sub 1 maxlevel {%shade the boxes if necessary");
            this.writer.println("\t\t/i exch def");
            this.writer.println("\t\t/delta_ang 360.0 2 i exp div def  %set the angle stepsize");
            this.writer.println("\t\t/r1 i radius def\t\t/r2 i 1 sub radius def        %find the inner and outer radius for the box");
            if (this.ge(this.maxlevel, 8)) {
                this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
            } else {
                this.writer.println("\t\t.7 radfactor div");
            }
            this.writer.println(" setlinewidth                %if level is beyond 7 make lines thinnest possible\n");
            this.writer.println("\t\t90.0 delta_ang 449.99 { %step through all angles from 90deg to 90deg+360deg (450deg)");
            this.writer.println("\t\t\t/ang1 exch def\t\t/ang2 ang1 delta_ang add def     %find the beginning and ending angle for each box");
            this.writer.println("\t\t\tnewpath");
            this.writer.println("\t\t\t\ti 0 gt{%draw the box");
            this.writer.println("\t\t\t\t\tang1 r1 polar m 0 0 r1 ang1 ang2 arc ang2 r2 polar l 0 0 r2 ang2 ang1 arcn");
            this.writer.println("\t\t\t\t}{");
            this.writer.println("\t\t\t\t\t0 0 1 radius 0 0 1 radius 0 360 arc");
            this.writer.println("\t\t\t\t}ifelse");
            this.writer.println("\t\t\tclosepath");
            if (!this.transparent) {
                this.writer.println("\t\t\t\ti 0 gt {                              %fill in box if necessary");
                this.writer.println("\t\t\t\t\tc 1 eq {/c1 0 def rf gf bf setrgbcolor} {/c1 1 def rm gm bm setrgbcolor} ifelse");
                this.writer.println("\t\t\t\t}{");
                this.writer.println("\t\t\t\t\tcentrepersonsex 0 eq {rm gm bm setrgbcolor} {rf gf bf setrgbcolor} ifelse");
                this.writer.println("\t\t\t\t}ifelse");
                this.writer.println("\t\t\t\tgsave fill grestore");
                this.writer.println("\t\t\t\ti 0 gt{/c c1 def}if                                    %exchange color for next box");
                this.writer.println("\t\t\trl gl bl setrgbcolor\n");
            }
            if (!this.printmarr) {
                if (!this.transparent) {
                    this.writer.println("\t\t\t\ti 9 le {stroke} if              %draw outline of box if level is less than 10");
                } else {
                    this.writer.println("\t\t\t\tstroke");
                }
            }
            this.writer.println("\t\t}for");
            this.writer.println("\t}for %end gender specific shading of boxes");
        }
        if (this.printmarr) {
            this.writer.println("\t%begin draw boxes around husband and wife");
            this.writer.println("\trl gl bl setrgbcolor");
            this.writer.println("\t2 indicentre sub 1 maxlevel {                    %step through the levels");
            this.writer.println("\t\t/i exch def");
            if (this.ge(this.maxlevel, 8)) {
                this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
            } else {
                this.writer.println("\t\t.7 radfactor div");
            }
            this.writer.println(" setlinewidth\n");
            this.writer.println("\t\t/delta_ang 360.0 2 i 1 sub exp div def  %set the angle stepsize");
            this.writer.println("\t\t90.0 delta_ang 449.99 {");
            this.writer.println("\t\t\t/ang1 exch def\t\t/ang2 ang1 delta_ang add def");
            this.writer.println("\t\t\t/r1 i radius def\t/r2 i 1 sub radius def\n");
            this.writer.println("\t\t\t%draw tic marks around marriage date");
            this.writer.println("\t\t\t/delta_r r1 r2 sub 15 div def");
            this.writer.println("\t\t\t/angave ang1 delta_ang 2 div add def");
            this.writer.println("\t\t\t/r_inner r2 delta_r add def");
            this.writer.println("\t\t\t/r_outer r1 delta_r sub def\n");
            this.writer.println("\t\t\tnewpath angave r_outer polar m angave r1 polar l stroke");
            this.writer.println("\t\t\tr2 0 gt{");
            this.writer.println("\t\t\t\tnewpath angave r2 polar m angave r_inner polar l stroke");
            this.writer.println("\t\t\t}if\n");
            if (!this.transparent) {
                this.writer.println("\t\t\trm gm bm setrgbcolor         %erase small gap between male and female");
                this.writer.println("\t\t\t.5 setlinewidth");
                this.writer.println("\t\t\tnewpath angave r_outer polar m angave r_inner polar l stroke");
                this.writer.println("\t\t\trl gl bl setrgbcolor");
                if (this.ge(this.maxlevel, 8)) {
                    this.writer.println("\t\ti 8 ge {0}{0.7 radfactor div} ifelse");
                } else {
                    this.writer.println("\t\t.7 radfactor div");
                }
                this.writer.println(" setlinewidth");
            }
            this.writer.println("\t\t\t%finish tic marks\n");
            this.writer.println("\t\t\tnewpath\t%draw box around parents");
            this.writer.println("\t\t\t\tang1 r1 polar m 0 0 r1 ang1 ang2 arc");
            this.writer.println("\t\t\t\tang2 r2 polar l 0 0 r2 ang2 ang1 arcn closepath");
            this.writer.println("\t\t\tstroke");
            this.writer.println("\t\t}for");
            this.writer.println("\t}for\t%end draw boxes around husband and wife\n");
        }
        if (this.psOptions.printdate) {
            this.writer.println("\t0 0 0 setrgbcolor");
            this.writer.println("\tfontname 5 SF");
            this.writer.println("\t/radiusprint maxlevel radius 1.01 mul def");
            this.writer.println("\tdatetoday radiusprint 300 circtext");
        }
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/angtext{   %Angled Line Printing Procedure for outer lines than do not curve");
        this.writer.println("\t/inf exch def\t\t/offst exch def\t\t/ang exch def\t\t/levelnum exch def\t\t/str exch def\n");
        this.writer.println("\tgsave");
        this.writer.println("\tang rotate                                               %rotate coordinate system for printing\n");
        this.writer.println("\t/r1 levelnum 1 sub radius def\t\t/r2 levelnum radius def");
        if (this.printmarr) {
            this.writer.println("\tlevelnum 1 eq indicentre 0 eq and{/r1 0 def /r2 0 def}if\n");
        }
        this.writer.println("\t/y r1 r2 add 2 div def\n");
        this.writer.println("\tinf 0 eq{0 offst -10 mul 15 add translate}{y 0.0 translate}ifelse\n");
        this.writer.println("\tstr stringwidth pop 2 div neg offst moveto");
        this.writer.println("\tstr show");
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/circtext{   %Circular Line Printing Procedure for inner lines than do curve\n");
        this.writer.println("\t/angle exch def\t/textradius exch def\t/str exch def\n");
        this.writer.println("\t/xradius textradius ptsize 4 div add def");
        this.writer.println("\tgsave");
        this.writer.println("\t\tangle str findhalfangle add rotate");
        this.writer.println("\t\tstr {/charcode exch def ( ) dup 0 charcode put circchar} forall");
        this.writer.println("\tgrestore");
        this.writer.println("} def\n");
        this.writer.println("/findhalfangle {stringwidth pop 2 div 2 xradius mul pi mul div 360 mul} def\n");
        this.writer.println("/circchar{   %print each character at a different angle around the circle");
        this.writer.println("\t/char exch def\n");
        this.writer.println("\t/halfangle char findhalfangle def");
        this.writer.println("\t\tgsave");
        this.writer.println("\t\thalfangle neg  rotate");
        this.writer.println("\t\ttextradius 0 translate");
        this.writer.println("\t\t-90 rotate");
        this.writer.println("\t\tchar stringwidth pop 2 div neg 0 moveto");
        this.writer.println("\t\tchar show");
        this.writer.println("\tgrestore");
        this.writer.println("\thalfangle 2 mul neg rotate");
        this.writer.println("} def\n");
        this.writer.println("/setprintcolor{");
        this.writer.println("\t/ahnen exch def\t\t/inf exch def");
        this.writer.println("\tahnen 2 div dup cvi eq {redmale greenmale bluemale setrgbcolor}{redfemale greenfemale bluefemale setrgbcolor} ifelse");
        this.writer.println("\tahnen inf mul 1 eq {redmale greenmale bluemale setrgbcolor} if");
        this.writer.println("} def\n");
        this.writer.println("/position{  %compute position from ahnentafel number");
        this.writer.println("\t/ahnenn exch def");
        this.writer.println("\tahnenn 2 maxlevel -1 add exp lt {");
        this.writer.println("\t\t/a 2 ahnenn log 1.9999 log div floor exp def");
        this.writer.println("\t\t/numerator 2 a mul -1 add -2 ahnenn a neg add mul add def");
        this.writer.println("\t\t/fact 2 maxlevel -2 add exp def");
        this.writer.println("\t\tnumerator a div fact mul");
        this.writer.println("\t}{2 maxlevel exp ahnenn neg add} ifelse");
        this.writer.println("} def\n");
        this.writer.println("/level {1 add log 2 log div ceiling cvi} def %compute generation level from ahnentafel number\n");
        this.writer.println("/info{");
        this.writer.println("\t/max exch def\t\t/inf exch def\t\t/noffset exch def\t\t/ahnen exch def");
        this.writer.println("\t/fntfactor {[0 0.85 0.85 0.8 0.7 0.5 0.4 0.3 0.3 0.25 0.25 0.25 0.25] exch get} def %set different font sizes for each level\n");
        this.writer.println("\tahnen 2 maxlevel exp lt {");
        this.writer.println("\t\t/place ahnen position def");
        this.writer.println("\t\t/levelnum ahnen level def    %get the level number of the current person");
        this.writer.println("\t\t/radtab levelnum radius def  %get the radius of the current level");
        this.writer.println("\t\t/ftsize ptsize levelnum fntfactor mul def  %find the new fontsize depending on the current level number");
        this.writer.println("\t\t/offset ftsize 1.25 mul neg def            %find the distance that the text should be printed from the ring");
        this.writer.println("\t\tinf ahnen setprintcolor      %print the names and information in alternating colors as defined below in line #350");
        this.writer.println("\t\tfontname ftsize SF %set the font to use\n");
        this.writer.println("\t\tlevelnum 5 lt {levelnum radtab place noffset inf max inner}  % the inner four rings");
        this.writer.println("\t\t\t\t\t\t{levelnum place noffset inf 0 max outer} ifelse  % all outer rings");
        this.writer.println("\t} if");
        this.writer.println("} def\n");
        if (this.eq(1, 1)) {
            this.writer.println("/indiinfo{");
            this.writer.println("\t/inf exch def\t\t/noffset exch def\t\t/ahnen exch def");
            this.writer.println("\t/ftsize ptsize 0.9 mul def  %find the new fontsize depending on the current level number");
            this.writer.println("\t/offset ftsize 1.25 mul neg def            %find the distance that the text should be printed from the ring");
            this.writer.println("\tinf ahnen setprintcolor      %print the names and information in alternating colors as defined below in line #350");
            this.writer.println("\tfontname ftsize SF %set the font to use\n");
            this.writer.println("\t0 0 noffset 0 angtext");
            this.writer.println("} def\n");
        }
        this.writer.println("/nstr 7 string def");
        this.writer.println("/prtn {-0.5 inch 5.5 inch m nstr cvs show} def");
        this.writer.println("/prt {-0.5 inch 5.5 inch m\tshow} def\n");
        if (this.printmarr) {
            this.writer.println("/minfo{");
            this.writer.println("\t/inf exch def\t\t/ahnen exch def");
            this.writer.println("\t/fntfactor {[0 0.7 0.7 0.6 0.6 0.5 0.4 0.3 0.3 0.25 0.25 0.25 0.25] exch get} def %set different font sizes for each level\n");
            this.writer.println("\tahnen 2 maxlevel exp lt {");
            this.writer.println("\t\t/place ahnen 1 eq {0}{ahnen 2 div position}ifelse def  %get the position of the text counting on the outer ring from bottom upwards");
            this.writer.println("\t\t/levelnum ahnen level def   %get the level number of the current person");
            this.writer.println("\t\t/ftsize ptsize levelnum fntfactor mul 0.80 mul def  %find the new fontsize depending on the current level number");
            this.writer.println("\t\t/offset ftsize 0.35 mul neg def            %find the distance that the text should be printed from the ring");
            this.writer.println("\t\trl gl bl setrgbcolor");
            this.writer.println("\t\tdup");
            this.writer.println("\t\t/namelength exch length def");
            this.writer.println("\t\t/f namelength 11 lt {1}{11 namelength div}ifelse def");
            this.writer.println("\t\tfontname ftsize f mul SF %set the font to use\n");
            this.writer.println("\t\tlevelnum place 0 inf 1 1 outer");
            this.writer.println("\t} if");
            this.writer.println("} def\n");
        }
        this.writer.println("/inner{");
        this.writer.println("\t/max exch def\t\t/inf exch def\t\t/noffset exch def\t\t/place exch def\t\t/radtab exch def\t\t/levelnum exch def");
        this.writer.println("\t% slight modifications for each level for line spacing");
        if (this.eq(1, 0)) {
            this.writer.println("\t\tmax 3 eq {/factor {[0.0 0.98 0.97 0.97 0.975] exch get} def}if");
            this.writer.println("\t\tmax 2 eq {/factor {[0.0 0.80 0.885 0.935 0.94] exch get} def}if");
            this.writer.println("\t\tmax 1 eq {/factor {[0.0 0.70 0.835 0.905 0.91] exch get} def}if\n");
        }
        if (this.eq(1, 1)) {
            this.writer.println("\t\tmax 3 eq {/factor {[0.0 0.96 0.98 0.98 0.975] exch get} def}if");
            this.writer.println("\t\tmax 2 eq {/factor {[0.0 0.96 0.935 0.945 0.94] exch get} def}if");
            this.writer.println("\t\tmax 1 eq {/factor {[0.0 0.96 0.905 0.915 0.91] exch get} def}if\n");
        }
        this.writer.println("\tlevelnum 1 eq indicentre 0 eq and{/offset offset 0.75 mul def} if  %max the offset a bit smaller for the first level");
        this.writer.println("\tradtab levelnum factor mul noffset offset mul add place inf midang circtext");
        this.writer.println("} def\n");
        this.writer.println("/outer{");
        this.writer.println("\t/max exch def\t/marr exch def\t\t/inf exch def\t\t/noffset exch def\t\t/place exch def\t\t/levelnum exch def\n");
        this.writer.println("\t\t\t% in the following:");
        this.writer.println("\t\t\t%      f1 spreads the text out apart from eachother when more positive (larger)");
        this.writer.println("\t\t\t%      f2 shifts the set of text counter clockwise when more positive (larger)");
        if (this.eq(this.maxlevel, 5)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 1.35 def} if}if");
            this.writer.println("\t\tmax 2 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 0.25 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 6)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.7 def\t/f2 1.50 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.7 def\t/f2 1.50 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 7)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t \t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 0.70 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -2.0 def\t/f2 1.20 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 8)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.20 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.7 def\t/f2 0.80 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 3.30 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 1.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.7 def\t/f2 0.50 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 9)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if");
            this.writer.println("\t\t\t\t\t levelnum 9 eq {/f1  0.0 def\t/f2 0.00 def} if}if\n");
        }
        if (this.eq(this.maxlevel, 10)) {
            this.writer.println("\t\tmax 3 eq {levelnum 5 eq {/f1 -2.5 def\t/f2 6.50 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.30 def} if}if");
            this.writer.println("\t\tmax 2 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 2.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.40 def} if}if");
            this.writer.println("\t\tmax 1 eq {");
            this.writer.println("\t\t\t\t\t levelnum 5 eq {/f1 -2.5 def\t/f2 4.85 def} if");
            this.writer.println("\t\t\t\t\t levelnum 6 eq {/f1 -1.6 def\t/f2 4.00 def} if");
            this.writer.println("\t\t\t\t\t levelnum 7 eq {/f1 -1.0 def\t/f2 1.70 def} if");
            this.writer.println("\t\t\t\t\t levelnum 8 eq {/f1 -0.6 def\t/f2 1.20 def} if");
            this.writer.println("\t\t\t\t\t levelnum 9 eq {/f1  0.0 def\t/f2 0.40 def} if");
            this.writer.println("\t\t\t\t\t levelnum 10 ge{/f1  0.0 def\t/f2 0.225 def}if}if\n");
        }
        this.writer.println("\tmarr 1 eq {/f1 0.0 def\t\t/f2 0.0 def} if\n");
        this.writer.println("\t/ang place inf midang f1 noffset mul f2 add add def");
        this.writer.println("\tlevelnum ang offset inf angtext");
        this.writer.println("} def\n");
        this.writer.println("%   borrowed from Robert Simms");
        if (this.eq(1, 1)) {
            this.writer.println("/addcenterindi {centerperson_array 3 1 roll put} def");
        }
        if (this.printmarr) {
            this.writer.println("/addmarr {marriage_array 3 1 roll put} def");
        }
        this.writer.println("/addind {person_array 3 1 roll put} def\n");
    }

    private void main(Indi person) {
        int psex = person.getSex() == 1 ? 0 : 1;
        this.printfile();
        if (this.psOptions.printdate) {
            this.writer.println("/datetoday (Date: " + PointInTime.getNow().toReportString() + ") def\n\n");
        }
        this.writer.println("/indicentre " + this.d(1) + " def %1=put individual in centre,0=family at centre");
        if (this.eq(1, 1)) {
            this.writer.println("/centrepersonsex " + psex + " def %0=male; 1=female\n\n");
        }
        this.writer.println("/maxlevel " + this.d(this.maxlevel) + " def");
        this.writer.println("% color  of the text in RGB format");
        if (this.eq(this.psOptions.colourtext, 1)) {
            this.writer.println("/redmale   0.0 def  /greenmale   0.0 def  /bluemale   1.0 def");
            this.writer.println("/redfemale 1.0 def  /greenfemale 0.0 def  /bluefemale 0.0 def\n");
        } else {
            this.writer.println("/redmale   0.0 def  /greenmale   0.0 def  /bluemale   0.0 def");
            this.writer.println("/redfemale 0.0 def  /greenfemale 0.0 def  /bluefemale 0.0 def\n");
        }
        if (this.gradient) {
            this.writer.println("/transparent 1 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 0.0 def /gf 0.0 def /bf 0.0 def %rgb female box fill");
            this.writer.println("/rm 0.0 def /gm 0.0 def /bm 0.0 def %rgb male box fill\n");
        } else if (!this.alternating) {
            this.writer.println("/transparent 1 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 1.0 def /gf 1.0 def /bf 1.0 def %rgb female box fill");
            this.writer.println("/rm 1.0 def /gm 1.0 def /bm 1.0 def %rgb male box fill\n");
        } else {
            this.writer.println("/transparent 0 def         % 1=transparent, 0=color shading\n");
            this.writer.println("/rf 0.8 def /gf 0.8 def /bf 1.0 def %rgb female box fill");
            this.writer.println("/rm 1.0 def /gm 0.8 def /bm 0.8 def %rgb male box fill\n");
        }
        this.writer.println("/rl 0.0 def /gl 0.0 def /bl 0.0 def %  rgb for lines");
        this.writer.println("%     partially borrowed from Robert Simms");
        this.writer.println("% Find printable dimension for chart with a sequence of steps\n");
        this.writer.println("% get printable area for each page");
        this.writer.println("clippath pathbbox newpath");
        this.writer.println("/ury exch def /urx exch def");
        this.writer.println("/lly exch def /llx exch def\n");
        this.writer.println("/llx llx margin_left add def /lly lly margin_bottom add def");
        this.writer.println("/urx urx margin_right sub def /ury ury margin_top sub def\n");
        this.writer.println("% get available width and height for printing on a sheet of paper");
        this.writer.println("/wp urx llx sub def");
        this.writer.println("/hp ury lly sub def\n");
        this.writer.println("% get width and height of the multi-page printable area");
        this.writer.println("/tw0 wp xpages mul def");
        this.writer.println("/th0 hp ypages mul def\n");
        this.writer.println("tw0 th0 gt {");
        if (this.eq(this.radius, 0)) {
            this.writer.println("\t/mindim th0 def\n");
        }
        this.writer.println("\tth0 wp div ceiling cvi xpages lt {/xpages th0 wp div ceiling cvi def /tw0 wp xpages mul def /ypages ypages def}{/xpages xpages def /ypages ypages def}ifelse");
        this.writer.println("}{");
        if (this.eq(this.radius, 0)) {
            this.writer.println("\t/mindim tw0 def\n");
        }
        this.writer.println("\ttw0 hp div ceiling cvi ypages lt {/ypages tw0 hp div ceiling cvi def /th0 hp ypages mul def /xpages xpages def}{/xpages xpages def /ypages ypages def}ifelse");
        this.writer.println("}ifelse\n");
        if (this.gt(this.radius, 0)) {
            this.writer.println("/radfactor " + this.d(this.radius) + " inch 8 inch div def");
        } else {
            this.writer.println("/radfactor mindim 8 inch div def");
        }
        this.writer.println("/scalefactor 7.0 maxlevel indicentre add div radfactor mul def\n");
        this.writer.println("/print-a-page { % page printing procedure");
        this.writer.println("\t/ypage exch ypages 2 div 1 sub sub def  %y-correction to center chart");
        this.writer.println("\t/xpage exch xpages 2 div 1 sub sub def  %x-correction to center chart");
        this.writer.println("\typage ypages lt xpage xpages lt and { %only print if page is in correct range");
        this.writer.println("\t\tgsave");
        this.writer.println("\t\t\tllx lly translate");
        this.writer.println("\t\t\t0 0 wp hp RC\t\t% specify (rectangular) clipping path to keep the margins clean");
        this.writer.println("\t\t\txpage wp mul ypage hp mul translate\t% move origin so that desired portion of chart lands within clipping path");
        this.writer.println("\t\t\tscalefactor dup scale  %enlarge scale to fit page");
        if (this.gradient) {
            this.writer.println("0.6431 0.3255 0.0228  % inside centre color in RGB format");
            this.writer.println("0.9922 0.7686 0.5490  % outside rim color in RGB format    to form a radial gradient");
            this.writer.println("gradient\n");
        }
        this.writer.println("\t\t\tfan  %draw circle template");
        if (this.eq(1, 1)) {
            this.writer.println("\t\t\tcenterperson_array {exec indiinfo} forall %put in center person\n");
        }
        this.writer.println("\t\t\tperson_array {exec info} forall %put in all people with dates");
        if (this.printmarr) {
            this.writer.println("\t\t\tmarriage_array {exec minfo} forall %put in marriage dates\n");
        }
        this.writer.println("\t\t\t1 dup scale %reset scale to normal");
        this.writer.println("\t\tgrestore");
        this.writer.println("\t} if");
        this.writer.println("} def      % print-a-page procedure\n");
        this.writer.println("%%EndProlog");
        this.writer.println("%%BeginSetUp\n");
        this.writer.println("/fillarray{% store vertical lines and individual records in arrays");
        if (this.eq(1, 1)) {
            PersonCell pCell = new PersonCell();
            this.numcenter = 0;
            this.numcenter += pCell.add(this.surname(person, 25), this.numcenter);
            this.numcenter += pCell.add(this.putGivenName(person, 25), this.numcenter);
            this.numcenter += pCell.add(this.getDateString(this.birth(person), this.death(person), this.psOptions.dateformat), this.numcenter);
            this.writer.print(pCell.getCenter(psex));
            this.semicirc(this.parents(person), this.father(person), 1, 1, 1, this.maxlevel, this.psOptions.dateformat);
            this.semicirc(this.parents(person), this.mother(person), 1, 1, 2, this.maxlevel, this.psOptions.dateformat);
        } else {
            this.semicirc(null, this.husband(null), 1, 1, 1, this.maxlevel, this.psOptions.dateformat);
            this.semicirc(null, this.wife(null), 1, 1, 2, this.maxlevel, this.psOptions.dateformat);
        }
        this.writer.println("} def\n");
        if (this.eq(1, 1)) {
            this.writer.println("/centerperson_array " + this.numcenter + " array def\n");
        }
        if (this.printmarr) {
            this.writer.println("/marriage_array " + this.d(this.add(this.nummarr, 1)) + " array def\n");
        }
        this.writer.println("/person_array " + this.numindilines + " array def");
        this.writer.println("fillarray\n");
        this.writer.println("mark\n");
        this.writer.println("%%EndSetUp");
        this.putpageprintouts(this.x_pages, this.y_pages);
        this.writer.println("%%EOF");
    }

    private String getDateString(PropertyDate birth, PropertyDate death, int dateformat) {
        String result = "";
        String birthstr = "";
        String deathstr = "";
        if (birth != null && !birth.isValid()) {
            birth = null;
        }
        if (death != null && !death.isValid()) {
            death = null;
        }
        if (birth == null && death == null) {
            return "";
        }
        switch (dateformat) {
            case 2: {
                birthstr = "    ";
                deathstr = "    ";
            }
            case 1: {
                if (death != null) {
                    deathstr = this.year(death);
                }
                if (birth != null) {
                    birthstr = this.year(birth);
                }
                result = " (" + birthstr + "-" + deathstr + ")";
                break;
            }
            default: {
                if (death != null) {
                    if (birth != null) {
                        result = result + " " + this.year(birth);
                    }
                    result = result + "-" + this.year(death);
                    break;
                }
                if (birth == null) break;
                result = result + this.OPTIONS.getBirthSymbol() + this.date(birth);
            }
        }
        return result;
    }

    private void mainSvg(Indi indi) {
        this.fillIndi(1, indi, null, 0);
        this.nextLevel(2, this.father(indi), this.parents(indi), 1);
        this.nextLevel(3, this.mother(indi), this.parents(indi), 1);
        this.fan();
    }

    private void nextLevel(Integer cell, Indi indi, Fam fam, int level) {
        if (indi != null && level <= this.maxlevel) {
            this.fillIndi(cell, indi, fam, level);
            this.nextLevel(cell * 2, this.father(indi), this.parents(indi), level + 1);
            this.nextLevel(cell * 2 + 1, this.mother(indi), this.parents(indi), level + 1);
        }
    }

    private void fillIndi(Integer cell, Indi indi, Fam fam, int level) {
        if (indi != null) {
            IndividualData pCell = new IndividualData(indi);
            if (level == 0) {
                pCell.setName(this.surname(indi, 20));
                pCell.setSecondLine(this.putGivenName(indi, 20));
                pCell.setThirdLine(this.getDateString(this.birth(indi), this.death(indi), this.svgOptions.dateformat));
            } else if (level > 0 && level < 6) {
                pCell.setName(this.surname(indi, 100));
                pCell.setSecondLine(this.putGivenName(indi, 100));
                pCell.setThirdLine(this.getDateString(this.birth(indi), this.death(indi), this.svgOptions.dateformat));
            } else if (level == 6 || level == 7) {
                pCell.setName(this.putFullName(indi, 0, 1, 100));
                pCell.setSecondLine(this.getDateString(this.birth(indi), this.death(indi), this.svgOptions.dateformat));
            } else if (level >= 8) {
                String name = this.putFullName(indi, 0, 1, 100) + this.getDateString(this.birth(indi), this.death(indi), this.svgOptions.dateformat);
                pCell.setName(name);
            }
            if (this.svgOptions.uprintmarr && fam != null && this.marriage(fam) != null && "M".equals(this.sex(indi))) {
                pCell.setMarriageDate(this.date(this.marriage(fam)));
            }
            pCell.setBgColor(this.getColor(cell, indi, true));
            pCell.setFgColor(this.getColor(cell, indi, false));
            this.data.put(cell, pCell);
        }
    }

    private Color getColor(int sosa, Indi indi, boolean bg) {
        switch (this.svgOptions.colorScheme) {
            case 0: {
                String sex;
                switch (sex = this.sex(indi)) {
                    case "M": {
                        if (bg) {
                            return this.svgOptions.sexMColor;
                        }
                        return this.svgOptions.sexMText;
                    }
                    case "F": {
                        if (bg) {
                            return this.svgOptions.sexFColor;
                        }
                        return this.svgOptions.sexFText;
                    }
                }
                if (bg) {
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
            case 2: {
                if (bg) {
                    int red = this.svgOptions.gradientColor.getRed();
                    int green = this.svgOptions.gradientColor.getGreen();
                    int blue = this.svgOptions.gradientColor.getBlue();
                    int currentLevel = this.getLevel(sosa);
                    if (currentLevel == 0) {
                        return this.svgOptions.gradientColor;
                    }
                    red = (int)((double)red * (1.0 - (double)currentLevel * 0.1));
                    green = (int)((double)green * (1.0 - (double)currentLevel * 0.1));
                    blue = (int)((double)blue * (1.0 - (double)currentLevel * 0.1));
                    return new Color(red, green, blue);
                }
                return this.svgOptions.gradientText;
            }
            case 3: {
                int quadrant = this.getQuadrant(sosa);
                if (bg) {
                    return this.svgOptions.getQuadrantList().get(quadrant);
                }
                return this.svgOptions.getTextList().get(quadrant);
            }
            case 4: {
                if (bg) {
                    if (indi != null) {
                        return this.getGeoColor(indi);
                    }
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
            case 5: {
                if (bg) {
                    if (indi != null) {
                        return this.getOccuColor(indi);
                    }
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
        }
        if (bg) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private Color getOccuColor(Indi indi) {
        Property occupation = indi.getProperty("OCCU");
        if (occupation == null) {
            return Color.WHITE;
        }
        String value = occupation.getDisplayValue();
        return this.getRandomColor(value);
    }

    private Color getGeoColor(Indi indi) {
        PropertyPlace place = indi.getBirthPlaceOption();
        if (place == null) {
            place = indi.getDeathPlaceOption();
        }
        if (place == null && indi.getFamiliesWhereSpouse()[0] != null) {
            place = indi.getFamiliesWhereSpouse()[0].getMarriagePlace();
        }
        if (place != null) {
            String value = place.format(this.svgOptions.juridiction);
            return this.getRandomColor(value);
        }
        return Color.WHITE;
    }

    private Color getRandomColor(String value) {
        if ("".equals(value)) {
            return Color.WHITE;
        }
        Color color = this.geoColor.get(value);
        if (color != null) {
            return color;
        }
        color = new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
        while (this.colorUsed.contains(color) || !this.isLuma(color)) {
            color = new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
        }
        this.geoColor.put(value, color);
        this.colorUsed.add(color);
        return color;
    }

    private boolean isLuma(Color color) {
        return 0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue() > 60.0;
    }

    private double radius(int level) {
        return (level + 1) * 150;
    }

    private void fan() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(SVG_NAME_SPACE, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.setFont(Font.getFont(this.svgOptions.fontNames[this.svgOptions.fontName]));
        FontMetrics metrics = svgGenerator.getFontMetrics();
        int width = 1800;
        int height = 1800;
        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        BasicStroke ligne = new BasicStroke(1.0f);
        svgGenerator.setColor(Color.BLACK);
        svgGenerator.setStroke((Stroke)ligne);
        svgGenerator.drawRect(10, 10, width - 20, height - 20);
        double centerX = width / 2;
        double centerY = height / 2;
        int sosa = 0;
        for (int i = 0; i < this.maxlevel + 1; ++i) {
            double angularStep = 360.0 / Math.pow(2.0, i);
            double rInner = this.radius(i - 1);
            double rOuter = this.radius(i);
            boolean female = false;
            for (double ang1 = 450.0; ang1 > 90.0; ang1 -= angularStep) {
                ++sosa;
                double ang2 = ang1 - angularStep;
                if (i == 0) {
                    IndividualData user = this.data.get(sosa);
                    if (user == null) continue;
                    svgGenerator.setPaint((Paint)user.getBgColor());
                    svgGenerator.fill((Shape)new Ellipse2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter));
                    svgGenerator.setPaint((Paint)user.getFgColor());
                    Rectangle2D boundary = metrics.getStringBounds(user.getName(), (Graphics)svgGenerator);
                    svgGenerator.drawString(user.getName(), (int)(centerX - boundary.getWidth() / 2.0), (int)(centerY - boundary.getHeight()));
                    if (user.getSecondLine() != null && !"".equals(user.getSecondLine())) {
                        boundary = metrics.getStringBounds(user.getSecondLine(), (Graphics)svgGenerator);
                        svgGenerator.drawString(user.getSecondLine(), (int)(centerX - boundary.getWidth() / 2.0), (int)centerY);
                    }
                    if (user.getThirdLine() == null || "".equals(user.getThirdLine())) continue;
                    boundary = metrics.getStringBounds(user.getThirdLine(), (Graphics)svgGenerator);
                    svgGenerator.drawString(user.getThirdLine(), (int)(centerX - boundary.getWidth() / 2.0), (int)(centerY + boundary.getHeight()));
                    continue;
                }
                GeneralPath path = new GeneralPath();
                Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1, -angularStep, 0);
                Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang2, angularStep, 0);
                path.append(inner, false);
                Point2D point = outer.getStartPoint();
                path.lineTo(point.getX(), point.getY());
                path.append(outer, true);
                path.closePath();
                if (this.svgOptions.colorScheme == 0) {
                    if (female) {
                        svgGenerator.setPaint((Paint)this.svgOptions.sexFColor);
                    } else {
                        svgGenerator.setPaint((Paint)this.svgOptions.sexMColor);
                    }
                } else {
                    svgGenerator.setPaint((Paint)this.getColor(sosa, null, true));
                }
                female = !female;
                IndividualData user = this.data.get(sosa);
                if (user != null) {
                    this.addText(i, rOuter, rInner, centerX, centerY, ang1, angularStep, svgGenerator, sosa, user, document);
                    if (sosa % 2 == 0) {
                        this.addMariage(i, inner, outer, rOuter - rInner, svgGenerator, sosa, user, document);
                    }
                    svgGenerator.setPaint((Paint)user.getBgColor());
                    svgGenerator.fill((Shape)path);
                }
                if (this.svgOptions.isDrawEmptyBoxes && this.svgOptions.isEmptyColor && user == null) {
                    svgGenerator.fill((Shape)path);
                }
                if (!this.svgOptions.isDrawEmptyBoxes && user == null) continue;
                svgGenerator.setColor(Color.BLACK);
                svgGenerator.draw((Shape)path);
            }
        }
        if (this.svgOptions.printdate) {
            svgGenerator.setColor(Color.BLACK);
            svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, 8));
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String date = dtf.format(now);
            svgGenerator.drawString(date, width - 120, height - 20);
        }
        if (this.svgOptions.legende && (this.svgOptions.colorScheme == 4 || this.svgOptions.colorScheme == 5)) {
            double rayon = this.radius(10);
            Ellipse2D.Double cercle = new Ellipse2D.Double(centerX - rayon / 2.0, centerY - rayon / 2.0, rayon, rayon);
            this.drawLegend(svgGenerator, cercle);
        }
        try {
            svgGenerator.stream((Writer)this.writer);
        }
        catch (SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
        }
    }

    private void drawLegend(SVGGraphics2D svgGenerator, Ellipse2D cercle) {
        svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, 7));
        FontMetrics metrics = svgGenerator.getFontMetrics();
        double maxWidth = 0.0;
        int debutX = 15;
        int debutY = 1775;
        Area areaCercle = new Area(cercle);
        ArrayList<String> values = new ArrayList<String>(this.geoColor.keySet());
        Collections.sort(values);
        Collections.reverse(values);
        for (String value : values) {
            Rectangle2D boundary = metrics.getStringBounds(value, (Graphics)svgGenerator);
            Rectangle2D.Double texteRect = new Rectangle2D.Double(debutX, debutY, 12.0 + boundary.getWidth(), 10.0);
            while (areaCercle.intersects(texteRect)) {
                debutY = 1775;
                maxWidth = 0.0;
                texteRect = new Rectangle2D.Double(debutX += (int)maxWidth + 20, debutY, 12.0 + boundary.getWidth(), 10.0);
            }
            maxWidth = Math.max(maxWidth, boundary.getWidth());
            svgGenerator.setColor(this.geoColor.get(value));
            svgGenerator.fillRect(debutX, debutY, 10, 10);
            svgGenerator.setColor(Color.BLACK);
            svgGenerator.drawString(value, debutX + 12, debutY + 8);
            debutY -= 12;
        }
    }

    private void addText(int level, double rOuter, double rInner, double centerX, double centerY, double ang1, double angularStep, SVGGraphics2D svgGenerator, int sosa, IndividualData user, Document document) throws DOMException {
        if (level < 6) {
            double delta = (rOuter - rInner) / 2.0;
            svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)svgGenerator);
            double diametre = rInner + delta + 2.0 * bounds.getHeight();
            this.addLine(level, centerX, diametre, centerY, ang1, angularStep, svgGenerator, sosa, bounds, document, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            if (user.getSecondLine() != null && !"".equals(user.getSecondLine())) {
                bounds = metrics.getStringBounds(user.getSecondLine(), (Graphics)svgGenerator);
                diametre = rInner + delta;
                this.addLine(level, centerX, diametre, centerY, ang1, angularStep, svgGenerator, sosa, bounds, document, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 2);
            }
            if (user.getThirdLine() != null && !"".equals(user.getThirdLine())) {
                bounds = metrics.getStringBounds(user.getThirdLine(), (Graphics)svgGenerator);
                diametre = rInner + delta - 2.0 * bounds.getHeight();
                this.addLine(level, centerX, diametre, centerY, ang1, angularStep, svgGenerator, sosa, bounds, document, user.getThirdLine(), user.getFgColor(), user.getBgColor(), 3);
            }
        } else if (level < 8) {
            double size = rOuter - rInner;
            svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)svgGenerator);
            Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - angularStep / 3.0, -angularStep, 0);
            Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - angularStep / 3.0, -angularStep, 0);
            this.addLine(level, inner.getStartPoint(), outer.getStartPoint(), size, svgGenerator, sosa, bounds, document, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            if (user.getSecondLine() != null) {
                bounds = metrics.getStringBounds(user.getSecondLine(), (Graphics)svgGenerator);
                inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - 2.0 * angularStep / 3.0, -angularStep, 0);
                outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - 2.0 * angularStep / 3.0, -angularStep, 0);
                this.addLine(level, inner.getStartPoint(), outer.getStartPoint(), size, svgGenerator, sosa, bounds, document, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 2);
            }
        } else {
            double size = rOuter - rInner;
            svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)svgGenerator);
            Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - angularStep / 2.0, -angularStep + 0.5, 0);
            Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - angularStep / 2.0, -angularStep + 0.5, 0);
            this.addLine(level, inner.getStartPoint(), outer.getStartPoint(), size, svgGenerator, sosa, bounds, document, user.getName(), user.getFgColor(), user.getBgColor(), 1);
        }
    }

    private void addLine(int level, Point2D start, Point2D end, double size, SVGGraphics2D svgGenerator, int sosa, Rectangle2D bounds, Document document, String value, Color fgColor, Color bgColor, int line) throws DOMException {
        Line2D.Double path = new Line2D.Double(start, end);
        GeneralPath inPath = new GeneralPath();
        inPath.append(path, false);
        Element pathElement = svgGenerator.getShapeConverter().toSVG((Shape)inPath);
        double offset = (size - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset < 0.0 ? 2.0 : offset, sosa, document, value, fgColor, bgColor, line);
    }

    private void addLine(int level, double centerX, double diametre, double centerY, double ang1, double angularStep, SVGGraphics2D svgGenerator, int sosa, Rectangle2D bounds, Document document, String value, Color fgColor, Color bgColor, int line) throws DOMException {
        Arc2D.Double arcText = new Arc2D.Double(centerX - diametre / 2.0, centerY - diametre / 2.0, diametre, diametre, ang1, -angularStep + 0.5, 0);
        Element pathElement = svgGenerator.getShapeConverter().toSVG((Shape)arcText);
        double arcLength = diametre * Math.toRadians(angularStep);
        double offset = (arcLength - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset < 0.0 ? 2.0 : offset, sosa, document, value, fgColor, bgColor, line);
    }

    private void addLine(int level, Element pathElement, double offset, int sosa, Document document, String value, Color fgColor, Color bgColor, int line) {
        Element group = document.createElementNS(SVG_NAME_SPACE, "g");
        pathElement.setAttribute("id", String.valueOf(line) + "sosa" + String.valueOf(sosa));
        if (line == 0) {
            pathElement.setAttribute("stroke", String.format("#%06x", bgColor.getRGB() & 0xFFFFFF));
        } else {
            pathElement.setAttribute("visibility", "hidden");
            pathElement.setAttribute("style", "display:none");
        }
        group.appendChild(pathElement);
        Element pathText = document.createElement("textPath");
        pathText.setAttribute("xlink:href", "#" + String.valueOf(line) + "sosa" + String.valueOf(sosa));
        pathText.setAttribute("startOffset", String.valueOf(offset));
        pathText.setTextContent(value);
        Element text = document.createElement("text");
        text.setAttribute("fill", String.format("#%06x", fgColor.getRGB() & 0xFFFFFF));
        text.setAttribute("stroke", "none");
        if (line == 0) {
            text.setAttribute("font-size", String.valueOf(MARRIAGE_SIZE[level]));
        } else {
            text.setAttribute("font-size", String.valueOf(FONT_SIZE[level]));
        }
        text.setAttribute("dominant-baseline", "middle");
        text.appendChild(pathText);
        group.appendChild(text);
        this.texts.add(group);
    }

    private void addMariage(int level, Arc2D inner, Arc2D outer, double size, SVGGraphics2D svgGenerator, int sosa, IndividualData user, Document document) {
        Line2D.Double path = new Line2D.Double(inner.getEndPoint().getX(), inner.getEndPoint().getY(), outer.getStartPoint().getX(), outer.getStartPoint().getY());
        GeneralPath inPath = new GeneralPath();
        inPath.append(path, false);
        Element pathElement = svgGenerator.getShapeConverter().toSVG((Shape)inPath);
        svgGenerator.setFont(new Font(this.svgOptions.fontNames[this.svgOptions.fontName], 0, MARRIAGE_SIZE[level]));
        FontMetrics metrics = svgGenerator.getFontMetrics();
        String marriage = user.getMarriageDate() != null ? user.getMarriageDate() : " ";
        Rectangle2D bounds = metrics.getStringBounds(marriage, (Graphics)svgGenerator);
        double offset = (size - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset, sosa, document, marriage, user.getFgColor(), user.getBgColor(), 0);
    }

    private int getLevel(int sosa) {
        return (int)(Math.log(sosa) / Math.log(2.0));
    }

    private int getQuadrant(int sosa) {
        if (sosa == 1) {
            return 0;
        }
        if (sosa == 2) {
            return 0;
        }
        if (sosa == 3) {
            return 2;
        }
        String binary = Integer.toBinaryString(sosa);
        if (binary.startsWith("100")) {
            return 0;
        }
        if (binary.startsWith("101")) {
            return 1;
        }
        if (binary.startsWith("110")) {
            return 2;
        }
        return 3;
    }
}

