/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import org.graphstream.graph.Graph;
import org.graphstream.ui.view.Viewer;
import org.graphstream.util.MissingDisplayException;

public interface Display {
    public static Display getDefault() throws MissingDisplayException {
        String[] candidates;
        String uiModule = System.getProperty("org.graphstream.ui");
        if (uiModule == null) {
            throw new MissingDisplayException("No UI package detected! Please use System.setProperty(\"org.graphstream.ui\") for the selected package.");
        }
        Display display = null;
        String[] stringArray = candidates = new String[]{uiModule, String.valueOf(uiModule) + ".util.Display", "org.graphstream.ui." + uiModule + ".util.Display"};
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            try {
                Class<?> clazz = Class.forName(candidate);
                Object object = clazz.newInstance();
                if (object instanceof Display) {
                    display = (Display)object;
                    break;
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create object", e);
            }
            ++n2;
        }
        if (display == null) {
            throw new MissingDisplayException("No valid display found. Please check your System.setProperty(\"org.graphstream.ui\") statement.");
        }
        return display;
    }

    public Viewer display(Graph var1, boolean var2);
}

