/*
 * Decompiled with CFR 0.152.
 */
package gj.awt.geom;

import gj.awt.geom.SegmentConsumer;
import gj.awt.geom.ShapeHelper;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class Geometry {
    private static final double DEFAULT_FLATNESS = 4.0;

    public static double getDistance(Point2D lineStart, Point2D lineEnd, Point2D point) {
        return Line2D.ptLineDist(lineStart.getX(), lineStart.getY(), lineEnd.getX(), lineEnd.getY(), point.getX(), point.getY());
    }

    public static double getDistance(double lineStartX, double lineStartY, double lineEndX, double lineEndY, double pointX, double pointY) {
        return Line2D.ptLineDist(lineStartX, lineStartY, lineEndX, lineEndY, pointX, pointY);
    }

    public static double getAngle(Point2D vectorA, Point2D vectorB) {
        return Math.atan2(vectorB.getY() - vectorA.getY(), vectorB.getX() - vectorA.getX());
    }

    public static double getCrossProduct(Point2D vectorA, Point2D vectorB) {
        return Geometry.getCrossProduct(vectorA.getX(), vectorA.getY(), vectorB.getX(), vectorB.getY());
    }

    public static double getCrossProduct(double vectorAx, double vectorAy, double vectorBx, double vectorBy) {
        return vectorAx * vectorBy - vectorBx * vectorAy;
    }

    public static Point2D getDelta(Point2D vectorA, Point2D vectorB) {
        return new Point2D.Double(vectorB.getX() - vectorA.getX(), vectorB.getY() - vectorA.getY());
    }

    public static double getLength(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static Point2D getClosestIntersection(Point2D fix, Point2D lineStart, Point2D lineEnd, PathIterator shape) {
        return new OpGetClosestIntersection(fix, lineStart, lineEnd, shape).getResult();
    }

    public static Point2D getIntersection(Point2D p1, Point2D p2, Point2D p3, Shape s) {
        Point2D p;
        if (s != null && (p = Geometry.getClosestIntersection(p1, p1, p2, s.getPathIterator(AffineTransform.getTranslateInstance(p3.getX(), p3.getY())))) != null) {
            return p;
        }
        return p2;
    }

    public static boolean testIntersection(Point2D aStart, Point2D aEnd, Point2D bStart, Point2D bEnd) {
        Point2D vectorA = Geometry.getDelta(aStart, aEnd);
        Point2D vector1 = Geometry.getDelta(aStart, bStart);
        Point2D vector2 = Geometry.getDelta(aStart, bEnd);
        if (Geometry.getCrossProduct(vectorA, vector1) * Geometry.getCrossProduct(vectorA, vector2) > 0.0) {
            return false;
        }
        Point2D vectorB = Geometry.getDelta(bStart, bEnd);
        vector1 = Geometry.getDelta(bStart, aStart);
        vector2 = Geometry.getDelta(bStart, aEnd);
        return Geometry.getCrossProduct(vectorB, vector1) * Geometry.getCrossProduct(vectorB, vector2) <= 0.0;
    }

    public static Point2D getIntersection(Point2D aStart, Point2D aEnd, Point2D bStart, Point2D bEnd) {
        if (!Geometry.testIntersection(aStart, aEnd, bStart, bEnd)) {
            return null;
        }
        double v_ax = aEnd.getX() - aStart.getX();
        double v_ay = aEnd.getY() - aStart.getY();
        double v_bx = bEnd.getX() - bStart.getX();
        double v_by = bEnd.getY() - bStart.getY();
        double v_cx = bStart.getX() - aStart.getX();
        double v_cy = bStart.getY() - aStart.getY();
        double cp_ba = Geometry.getCrossProduct(v_bx, v_by, v_ax, v_ay);
        double cp_bc = Geometry.getCrossProduct(v_bx, v_by, v_cx, v_cy);
        if (cp_ba == 0.0) {
            return null;
        }
        double s = cp_bc / cp_ba;
        return new Point2D.Double(aStart.getX() + s * v_ax, aStart.getY() + s * v_ay);
    }

    public static Point2D getNegative(Point2D p) {
        return new Point2D.Double(-p.getX(), -p.getY());
    }

    private static class OpGetClosestIntersection
    extends SegmentConsumer {
        private Point2D result = null;
        private double distance = Double.MAX_VALUE;
        private Point2D origin;
        private Point2D lineStart;
        private Point2D lineEnd;

        protected OpGetClosestIntersection(Point2D origin, Point2D lineStart, Point2D lineEnd, PathIterator shape) {
            this.origin = origin;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            FlatteningPathIterator it = new FlatteningPathIterator(shape, 4.0);
            ShapeHelper.iteratePath(it, this);
        }

        protected Point2D getResult() {
            return this.result;
        }

        @Override
        public boolean consumeLine(Point2D start, Point2D end) {
            double d;
            Point2D p = Geometry.getIntersection(this.lineStart, this.lineEnd, start, end);
            if (p != null && (d = p.distance(this.origin)) < this.distance) {
                this.distance = d;
                this.result = p;
            }
            return true;
        }
    }
}

