/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.beans;

import ancestris.core.AncestrisCorePlugin;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.DialogManager;
import genj.util.Registry;
import genj.util.swing.ButtonHelper;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;

public class ConfirmChangeWidget
extends JPanel
implements ChangeListener {
    private static final ResourceBundle BUNDLE = NbBundle.getBundle(AncestrisCorePlugin.class);
    private boolean changed = false;
    private ConfirmChangeCallBack callback;
    private OK ok = new OK();
    private Cancel cancel = new Cancel();
    public boolean hideIfUnchanged = true;
    private KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
    private KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0);
    private static final String AUTO_COMMIT = "auto.commit";

    public ConfirmChangeWidget(ConfirmChangeCallBack callback) {
        super(new FlowLayout(2));
        ButtonHelper bh = new ButtonHelper().setInsets(0).setContainer(this);
        bh.create(this.ok).setFocusable(false);
        bh.create(this.cancel).setFocusable(false);
        this.callback = callback;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.registerKeyboardAction(this.ok, this.enterStroke, 2);
        this.registerKeyboardAction(this.cancel, this.escStroke, 2);
    }

    public static void setAutoCommit(boolean autoCommit) {
        Registry.get(AncestrisCorePlugin.class).put(AUTO_COMMIT, autoCommit);
    }

    public static boolean getAutoCommit() {
        return Registry.get(AncestrisCorePlugin.class).get(AUTO_COMMIT, false);
    }

    public boolean isCommitChanges() {
        if (ConfirmChangeWidget.getAutoCommit()) {
            return true;
        }
        JCheckBox auto = new JCheckBox(BUNDLE.getString("confirm.autocomit"));
        auto.setFocusable(false);
        if (DialogManager.create(BUNDLE.getString("confirm.keep.title"), new JComponent[]{new JLabel(BUNDLE.getString("confirm.keep.changes")), new JLabel(" "), auto}).setMessageType(3).setOptionType(0).show() != DialogManager.YES_OPTION) {
            return false;
        }
        ConfirmChangeWidget.setAutoCommit(auto.isSelected());
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.callback != null && e.getSource() instanceof Boolean) {
            Boolean b = (Boolean)e.getSource();
            if (b.booleanValue()) {
                this.callback.okCallBack(null);
            } else {
                this.callback.cancelCallBack(null);
            }
            return;
        }
        this.setChanged(true);
        this.revalidate();
    }

    public void setChanged(boolean changeStatus) {
        this.changed = changeStatus;
        if (ConfirmChangeWidget.getAutoCommit()) {
            this.ok.setEnabled(false);
            this.cancel.setEnabled(false);
            this.setVisible(false);
            return;
        }
        this.ok.setEnabled(changeStatus);
        this.cancel.setEnabled(changeStatus);
        if (changeStatus) {
            this.setVisible(true);
        } else if (this.hideIfUnchanged) {
            this.setVisible(false);
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public static interface ConfirmChangeCallBack {
        public void okCallBack(ActionEvent var1);

        public void cancelCallBack(ActionEvent var1);

        public void commit(boolean var1);
    }

    private class Cancel
    extends AbstractAncestrisAction {
        private Cancel() {
            this.setText(AbstractAncestrisAction.TXT_CANCEL);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConfirmChangeWidget.this.setChanged(false);
            if (ConfirmChangeWidget.this.callback != null) {
                ConfirmChangeWidget.this.callback.cancelCallBack(event);
            }
        }
    }

    private class OK
    extends AbstractAncestrisAction {
        private OK() {
            this.setText(AbstractAncestrisAction.TXT_OK);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ConfirmChangeWidget.this.callback != null) {
                ConfirmChangeWidget.this.callback.okCallBack(event);
            }
        }
    }
}

