/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoTextPane
extends JTextPane
implements UndoableEditListener,
FocusListener,
KeyListener {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private UndoManager myUndoManager;

    public UndoTextPane() {
        this.getDocument().addUndoableEditListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public UndoTextPane(StyledDocument doc) {
        this();
        this.setStyledDocument(doc);
    }

    private void createUndoMananger() {
        this.myUndoManager = new UndoManager();
        this.myUndoManager.setLimit(10);
    }

    private void removeUndoMananger() {
        this.myUndoManager.end();
    }

    @Override
    public void focusGained(FocusEvent fe) {
        this.createUndoMananger();
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.removeUndoMananger();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.myUndoManager != null) {
            this.myUndoManager.addEdit(e.getEdit());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 90 && e.isControlDown() && e.isShiftDown()) {
            try {
                this.myUndoManager.undo();
            }
            catch (CannotUndoException cue) {
                LOG.log(Level.FINE, "Nothing to undo", cue);
            }
        }
        if (e.getKeyCode() == 89 && e.isControlDown() && e.isShiftDown()) {
            try {
                this.myUndoManager.redo();
            }
            catch (CannotRedoException cue) {
                LOG.log(Level.FINE, "Nothing to redo", cue);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

