/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing.atable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ATableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private TableCellRenderer headerRendererUI;

    public ATableHeaderRenderer() {
        this((TableCellRenderer)null);
    }

    public ATableHeaderRenderer(TableCellRenderer headerRenderer) {
        this.headerRendererUI = headerRenderer;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (this.headerRendererUI instanceof JComponent) {
            ((JComponent)((Object)this.headerRendererUI)).setBorder(border);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component resUI = this.headerRendererUI == null ? super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.headerRendererUI.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (resUI instanceof JLabel) {
            JLabel label = (JLabel)resUI;
            LabelUI lui = label.getUI();
            lui.installUI(label);
            String valueString = "";
            if (value != null) {
                valueString = value.toString();
            }
            Icon sortIcon = null;
            List<TableColumn> sortedColumns = this.getSortedColumns(table);
            SortDesc sort = this.getSortOrder(table, column);
            int sortRank = sort == null ? 0 : sort.rank;
            boolean ascending = true;
            if (sort != null && sort.order == SortOrder.DESCENDING) {
                ascending = false;
            }
            Icon customIcon = null;
            if (sortRank != 0) {
                if (sortedColumns.size() > 1) {
                    valueString = valueString == null || valueString.isEmpty() ? Integer.toString(sortRank) : sortRank + " " + valueString;
                }
                label.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
                if (ascending) {
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    if (sortIcon == null) {
                        sortIcon = new SortUpIcon();
                    }
                } else {
                    sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                    if (sortIcon == null) {
                        sortIcon = new SortDownIcon();
                    }
                }
            }
            label.setText(valueString);
            if (sortIcon == null) {
                if (customIcon == null) {
                    Icon dummy = new Icon(){

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                        }

                        @Override
                        public int getIconWidth() {
                            return 0;
                        }

                        @Override
                        public int getIconHeight() {
                            return 0;
                        }
                    };
                    label.setIcon(dummy);
                } else {
                    label.setIcon(customIcon);
                }
            } else if (customIcon == null) {
                label.setIcon(sortIcon);
            } else {
                label.setIcon(ATableHeaderRenderer.mergeIcons(customIcon, sortIcon, 16, 0, this));
            }
        }
        return resUI;
    }

    private List<TableColumn> getSortedColumns(JTable table) {
        ArrayList<TableColumn> result = new ArrayList<TableColumn>(3);
        List<RowSorter.SortKey> sortKeys = null;
        if (table.getRowSorter() != null) {
            sortKeys = table.getRowSorter().getSortKeys();
        }
        if (sortKeys == null || sortKeys.isEmpty()) {
            return result;
        }
        for (RowSorter.SortKey sortKey : sortKeys) {
            result.add(table.getColumnModel().getColumn(sortKey.getColumn()));
        }
        return result;
    }

    private SortDesc getSortOrder(JTable table, int column) {
        List<RowSorter.SortKey> sortKeys = null;
        if (table.getRowSorter() != null) {
            sortKeys = table.getRowSorter().getSortKeys();
        }
        if (sortKeys == null || sortKeys.isEmpty()) {
            return null;
        }
        int rank = 1;
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (sortKey.getColumn() == table.convertColumnIndexToModel(column)) {
                return new SortDesc(rank, sortKey.getSortOrder());
            }
            ++rank;
        }
        return null;
    }

    private static Icon mergeIcons(Icon icon1, Icon icon2, int x, int y, Component c) {
        int w = 0;
        int h = 0;
        if (icon1 != null) {
            w = icon1.getIconWidth();
            h = icon1.getIconHeight();
        }
        if (icon2 != null) {
            w = icon2.getIconWidth() + x > w ? icon2.getIconWidth() + x : w;
            int n = h = icon2.getIconHeight() + y > h ? icon2.getIconHeight() + y : h;
        }
        if (w < 1) {
            w = 16;
        }
        if (h < 1) {
            h = 16;
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        if (icon1 != null) {
            icon1.paintIcon(c, g, 0, 0);
        }
        if (icon2 != null) {
            icon2.paintIcon(c, g, x, y);
        }
        g.dispose();
        return new ImageIcon(buffImage);
    }

    private static class SortUpIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(x, y + 6, x + 8, y + 6);
            g.drawLine(x, y + 6, x + 4, y + 2);
            g.drawLine(x + 8, y + 6, x + 4, y + 2);
        }
    }

    private static class SortDownIcon
    implements Icon {
        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(x, y + 2, x + 8, y + 2);
            g.drawLine(x, y + 2, x + 4, y + 6);
            g.drawLine(x + 8, y + 2, x + 4, y + 6);
        }
    }

    private static class SortDesc {
        private int rank = 0;
        private Enum<SortOrder> order = null;

        public SortDesc(int rank, Enum<SortOrder> order) {
            this.order = order;
            this.rank = rank;
        }
    }
}

