/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class MergeEntityPanel
extends JPanel {
    private Registry registry = null;
    private final HashMap<String, Integer> tagMap = new HashMap();
    private final List<PropertyRow> propRows = new ArrayList<PropertyRow>();
    private boolean isMerged = false;
    private final JLabel dummyLabel = new JLabel();
    private final JButton entAButton = new JButton();
    private final JButton entBButton = new JButton();
    private final JSeparator dummySeparator = new JSeparator();
    private final Action goToLeft;
    private final Action goToRight;
    private JScrollPane scrollPane;

    public MergeEntityPanel(Gedcom gedcom) {
        this.registry = gedcom.getRegistry();
        this.initSortMaps();
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("searchDuplicatesWindowWidth", this.getPreferredSize().width), this.registry.get("searchDuplicatesWindowHeight", this.getPreferredSize().height)));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.goToLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeEntityPanel.this.showLeftEntity();
            }
        };
        this.goToRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeEntityPanel.this.showRightEntity();
            }
        };
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.setMinimumSize(new Dimension(50, 30));
        this.setPreferredSize(new Dimension(300, 310));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MergeEntityPanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("searchDuplicatesWindowWidth", evt.getComponent().getWidth());
        this.registry.put("searchDuplicatesWindowHeight", evt.getComponent().getHeight());
    }

    public void setEntities(Entity leftEntity, Entity rightEntity, boolean isMerged) {
        this.propRows.clear();
        this.propRows.add(new PropertyRow(leftEntity.getPropertyName() + " " + NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.ID"), leftEntity, rightEntity, false, true));
        this.entAButton.setAction(this.goToLeft);
        this.entBButton.setAction(this.goToRight);
        this.entAButton.setText(leftEntity.getId() + " = " + leftEntity.toString(false));
        this.entBButton.setText(isMerged ? "  -  " : rightEntity.getId() + " = " + rightEntity.toString(false));
        this.entBButton.setEnabled(!isMerged);
        List<TagPath> firstLevelTagPaths = this.getTagPaths(leftEntity, rightEntity);
        Collections.sort(firstLevelTagPaths, new CompareTagPath());
        for (TagPath tagPath : firstLevelTagPaths) {
            Property[] leftProperties = leftEntity.getProperties(tagPath);
            Property[] rightProperties = rightEntity.getProperties(tagPath);
            int nbProperties = Math.max(leftProperties.length, rightProperties.length);
            for (int index = 0; index < nbProperties; ++index) {
                Property leftP = index >= leftProperties.length ? null : leftProperties[index];
                Property rightP = index >= rightProperties.length ? null : rightProperties[index];
                String label = this.getLabelFromProperty(leftP, rightP);
                this.propRows.add(new PropertyRow(label, leftP, rightP, true, tagPath.contains("CHAN")));
                List<TagPath> secondLevelTagPaths = this.getTagPaths(leftP, rightP);
                for (TagPath tagPath2 : secondLevelTagPaths) {
                    Property leftP2 = leftEntity.getProperty(tagPath2, true);
                    Property rightP2 = rightEntity.getProperty(tagPath2, true);
                    String label2 = this.getLabelFromProperty(leftP2, rightP2);
                    this.propRows.add(new PropertyRow(label2, leftP2, rightP2, false, tagPath2.contains("*")));
                }
            }
        }
        this.drawPanelElements();
    }

    private void showLeftEntity() {
        if (!this.propRows.isEmpty()) {
            SelectionDispatcher.fireSelection(new Context(this.propRows.get((int)0).propA));
        }
    }

    private void showRightEntity() {
        if (!this.propRows.isEmpty()) {
            SelectionDispatcher.fireSelection(new Context(this.propRows.get((int)0).propB));
        }
    }

    private void drawPanelElements() {
        JPanel panel = new JPanel();
        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        GroupLayout.ParallelGroup pg = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sgH = panelLayout.createSequentialGroup();
        GroupLayout.ParallelGroup pgHH = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pgHHA = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pgHHB = panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        pgHH.addComponent(this.dummyLabel);
        pgHHA.addComponent(this.entAButton, -2, 0, Short.MAX_VALUE);
        pgHHB.addComponent(this.entBButton, -2, 0, Short.MAX_VALUE);
        for (PropertyRow row : this.propRows) {
            pgHH.addComponent(row.label);
            pgHHA.addComponent(row.compA, -2, 0, Short.MAX_VALUE);
            pgHHB.addComponent(row.compB, -2, 0, Short.MAX_VALUE);
        }
        sgH.addContainerGap();
        sgH.addGroup(pgHH);
        sgH.addGap(18, 18, 18);
        sgH.addGroup(pgHHA);
        sgH.addGap(18, 18, 18);
        sgH.addGroup(pgHHB);
        sgH.addContainerGap();
        pg.addGroup(sgH);
        sgH = panelLayout.createSequentialGroup();
        sgH.addContainerGap();
        sgH.addComponent(this.dummySeparator);
        sgH.addContainerGap();
        pg.addGroup(sgH);
        for (PropertyRow row : this.propRows) {
            if (!row.separator) continue;
            sgH = panelLayout.createSequentialGroup();
            sgH.addContainerGap();
            sgH.addComponent(row.jSeparator);
            sgH.addContainerGap();
            pg.addGroup(sgH);
        }
        panelLayout.setHorizontalGroup(pg);
        GroupLayout.SequentialGroup sgV = panelLayout.createSequentialGroup();
        sgV.addContainerGap();
        sgV.addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dummyLabel).addComponent(this.entAButton, -2, -1, -2).addComponent(this.entBButton, -2, -1, -2));
        sgV.addComponent(this.dummySeparator, -2, 10, -2);
        for (PropertyRow row : this.propRows) {
            if (row.separator) {
                sgV.addComponent(row.jSeparator, -2, 10, -2);
            }
            sgV.addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(row.label).addComponent(row.compA, -2, -1, -2).addComponent(row.compB, -2, -1, -2));
            sgV.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        sgV.addContainerGap(-1, Short.MAX_VALUE);
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sgV));
        this.scrollPane.setViewportView(panel);
    }

    public List<Property> getSelectedProperties() {
        ArrayList<Property> selectedProperties = new ArrayList<Property>();
        for (PropertyRow row : this.propRows) {
            if (!row.isBSelected()) continue;
            selectedProperties.add(row.propB);
        }
        return selectedProperties;
    }

    private List<TagPath> getTagPaths(Property pLeft, Property pRight) {
        TagPath tp;
        String tmpStr;
        ArrayList<TagPath> tagPaths = new ArrayList<TagPath>();
        String pathPrefix = "";
        if (pLeft != null) {
            if (pLeft instanceof PropertyFamilySpouse || pLeft instanceof PropertyFamilyChild) {
                pathPrefix = pLeft.getPath(true).toString() + TagPath.SEPARATOR_STRING + "*" + TagPath.SEPARATOR_STRING + ".." + TagPath.SEPARATOR_STRING;
                pLeft = ((PropertyXRef)pLeft).getTargetParent();
            }
            if (pLeft != null) {
                for (Property property : pLeft.getProperties()) {
                    tmpStr = property.getPath(true).toString();
                    if (!pathPrefix.isEmpty()) {
                        tmpStr = pathPrefix + tmpStr.substring(tmpStr.indexOf(TagPath.SEPARATOR_STRING) + 1);
                    }
                    if (tagPaths.contains(tp = new TagPath(tmpStr))) continue;
                    tagPaths.add(tp);
                }
            }
        }
        pathPrefix = "";
        tp = null;
        tmpStr = "";
        if (pRight != null) {
            if (pRight instanceof PropertyFamilySpouse || pRight instanceof PropertyFamilyChild) {
                pathPrefix = pRight.getPath(true).toString() + TagPath.SEPARATOR_STRING + "*" + TagPath.SEPARATOR_STRING + ".." + TagPath.SEPARATOR_STRING;
                pRight = ((PropertyXRef)pRight).getTargetParent();
            }
            if (pRight != null) {
                for (Property property : pRight.getProperties()) {
                    tmpStr = property.getPath(true).toString();
                    if (!pathPrefix.isEmpty()) {
                        tmpStr = pathPrefix + tmpStr.substring(tmpStr.indexOf(TagPath.SEPARATOR_STRING) + 1);
                    }
                    if (tagPaths.contains(tp = new TagPath(tmpStr))) continue;
                    tagPaths.add(tp);
                }
            }
        }
        return tagPaths;
    }

    private String getLabelFromProperty(Property leftP, Property rightP) {
        int i;
        String str;
        Property p;
        String ret = "";
        Property property = p = leftP != null ? leftP : rightP;
        ret = p.getTag().equals("FAMC") ? NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Parents") : (p.getTag().equals("FAMS") ? NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Spouse") : (p.getTag().equals("XREF") ? NbBundle.getMessage(MergeEntityPanel.class, (String)"MergeEntityPanel.Reference") : str.substring(0, (i = (str = p.getPropertyName()).indexOf(" ")) != -1 ? i : str.length())));
        return ret;
    }

    public String getTextFromProperty(Property p) {
        String ret = "-";
        if (p != null) {
            if (p instanceof Entity) {
                ret = ((Entity)p).getId();
            } else if (p.getTag().equals("MARR")) {
                ret = "";
                ret = ret + (p.getProperty("DATE") != null ? p.getProperty("DATE") + "<br>" : "");
                ret = ret + (p.getProperty("PLAC") != null ? p.getProperty("PLAC") : "");
            } else {
                ret = p.getDisplayValue();
            }
        }
        return "<html>" + ret + "</html>";
    }

    private void initSortMaps() {
        this.tagMap.put("INDI:NAME", 1);
        this.tagMap.put("INDI:SEX", 2);
        this.tagMap.put("INDI:FAMC", 3);
        this.tagMap.put("INDI:FAMS", 4);
        this.tagMap.put("INDI:BIRT", 5);
        this.tagMap.put("INDI:CHR", 6);
        this.tagMap.put("INDI:DEAT", 7);
        this.tagMap.put("INDI:BURI", 8);
        this.tagMap.put("INDI:OCCU", 9);
        this.tagMap.put("FAM:HUSB", 11);
        this.tagMap.put("FAM:WIFE", 12);
        this.tagMap.put("FAM:CHIL", 13);
        this.tagMap.put("FAM:MARR", 14);
        this.tagMap.put("FAM:MARC", 15);
        this.tagMap.put("SUBM:NAME", 21);
        this.tagMap.put("SUBM:ADDR", 22);
        this.tagMap.put("SUBM:PHON", 23);
        this.tagMap.put("SUBM:EMAIL", 24);
        this.tagMap.put("SUBM:WWW", 25);
        this.tagMap.put("REPO:NAME", 31);
        this.tagMap.put("REPO:ADDR", 32);
        this.tagMap.put("REPO:PHON", 33);
        this.tagMap.put("REPO:EMAIL", 34);
        this.tagMap.put("REPO:WWW", 35);
        this.tagMap.put("SOUR:TITL", 41);
        this.tagMap.put("SOUR:ABBR", 42);
        this.tagMap.put("SOUR:AUTH", 43);
        this.tagMap.put("SOUR:TEXT", 44);
        this.tagMap.put("SOUR:PUBL", 45);
        this.tagMap.put("OBJE:FILE", 51);
        this.tagMap.put("OBJE:FILE:TITL", 52);
    }

    private class CompareTagPath
    implements Comparator {
        private CompareTagPath() {
        }

        public int compare(Object o1, Object o2) {
            TagPath t1 = (TagPath)o1;
            TagPath t2 = (TagPath)o2;
            String tag1 = t1.getLast();
            String tag2 = t2.getLast();
            if (tag1.startsWith("_") && !tag2.startsWith("_")) {
                return 1;
            }
            if (!tag1.startsWith("_") && tag2.startsWith("_")) {
                return -1;
            }
            if (tag1.startsWith("_") && tag2.startsWith("_")) {
                return t1.compareTo(t2);
            }
            Integer i1 = (Integer)MergeEntityPanel.this.tagMap.get(t1.get(0) + ":" + t1.get(1));
            Integer i2 = (Integer)MergeEntityPanel.this.tagMap.get(t2.get(0) + ":" + t2.get(1));
            if (i1 == null) {
                if (i2 != null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (i2 == null) {
                return -1;
            }
            if (i1.compareTo(i2) == 0) {
                return t1.compareTo(t2);
            }
            return i1.compareTo(i2);
        }
    }

    private class PropertyRow {
        public Property propA = null;
        public Property propB = null;
        public boolean separator = false;
        public JSeparator jSeparator;
        public JLabel label = new JLabel();
        public JComponent compA = null;
        public JComponent compB = null;
        private final JLabel labelA = new JLabel();
        private final JLabel labelB = new JLabel();
        private JCheckBox checkPropA = new JCheckBox();
        private JCheckBox checkPropB = new JCheckBox();
        private boolean same = false;

        public PropertyRow(String label, Property propA, Property propB, boolean separator, boolean forInfoOnly) {
            this.propA = propA;
            this.propB = propB;
            this.separator = separator;
            this.jSeparator = separator ? new JSeparator() : null;
            Property prop = propA != null ? propA : propB;
            boolean bold = separator || prop instanceof Entity;
            this.label.setText((bold ? "" : "   ") + label);
            this.label.setIcon(prop.getImage());
            if (bold) {
                this.label.setFont(new Font("Default", 1, 12));
            }
            if (forInfoOnly) {
                Color color;
                this.compA = this.labelA;
                this.compB = this.labelB;
                this.labelA.setText(MergeEntityPanel.this.getTextFromProperty(propA));
                this.labelB.setText(MergeEntityPanel.this.getTextFromProperty(propB));
                this.same = this.labelA.getText().equals(this.labelB.getText()) || propA instanceof Entity;
                Color color2 = color = this.same ? Color.BLUE : Color.red;
                if (MergeEntityPanel.this.isMerged) {
                    color = new Color(0, 94, 20);
                } else {
                    this.labelA.setIcon(propA == null ? prop.getImage() : propA.getImage());
                    this.labelB.setIcon(propB == null ? prop.getImage() : propB.getImage());
                }
                this.labelA.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
                this.labelB.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
                this.labelB.setEnabled(!MergeEntityPanel.this.isMerged && !this.same || propA instanceof Entity);
                this.labelA.setForeground(color);
                this.labelB.setForeground(color);
            } else {
                Color color;
                this.compA = this.checkPropA;
                this.compB = this.checkPropB;
                this.checkPropA.setText(MergeEntityPanel.this.getTextFromProperty(propA));
                this.checkPropB.setText(MergeEntityPanel.this.getTextFromProperty(propB));
                this.same = this.checkPropA.getText().equals(this.checkPropB.getText()) || propA instanceof Entity;
                Color color3 = color = this.same ? Color.BLUE : Color.red;
                if (MergeEntityPanel.this.isMerged) {
                    color = new Color(0, 94, 20);
                }
                this.checkPropA.setSelected(true);
                this.checkPropB.setSelected(false);
                this.checkPropB.setEnabled(!MergeEntityPanel.this.isMerged && !this.same);
                this.checkPropA.setForeground(color);
                this.checkPropB.setForeground(color);
                if (!this.same && prop.getMetaProperty().isSingleton()) {
                    this.checkPropA.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertyRow.this.checkPropB.setSelected(!MergeEntityPanel.this.isMerged && !PropertyRow.this.checkPropA.isSelected());
                        }
                    });
                    this.checkPropB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertyRow.this.checkPropA.setSelected(!PropertyRow.this.checkPropB.isSelected());
                        }
                    });
                } else {
                    this.checkPropA.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertyRow.this.checkPropA.setSelected(true);
                        }
                    });
                }
            }
        }

        public boolean isBSelected() {
            return this.checkPropB.isSelected();
        }
    }
}

