/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.List;

public class PropertyChild
extends PropertyXRef {
    private static final TagPath PATH_FAMCHIL = new TagPath("FAM:CHIL");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_FAMCHIL).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_FAMCHIL).getImage();

    PropertyChild() {
        super("CHIL");
    }

    PropertyChild(String tag) {
        super(tag);
        this.assertTag("CHIL");
    }

    public Indi getChild() {
        return (Indi)this.getTargetEntity();
    }

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.chil.veto");
    }

    @Override
    public void link() throws GedcomException {
        Fam fam;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException ex) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        Indi child = (Indi)this.getCandidate();
        if (child.isAncestorOf(fam)) {
            throw new GedcomException(resources.getString("error.already.ancestor", child.toString(), fam.toString()));
        }
        List<PropertyFamilyChild> famcs = child.getProperties(PropertyFamilyChild.class);
        int j = famcs.size();
        for (int i = 0; i < j; ++i) {
            PropertyFamilyChild pfc = famcs.get(i);
            if (!pfc.isCandidate(fam)) continue;
            this.link(pfc);
            return;
        }
        PropertyFamilyChild pfc = new PropertyFamilyChild();
        child.addProperty(pfc);
        this.link(pfc);
    }

    public static String getLabelChildAlreadyinFamily(Indi child, Fam fam) {
        return resources.getString("error.already.child", child.toString(), fam.toString());
    }

    @Override
    public String getTargetType() {
        return "INDI";
    }

    @Override
    public ImageIcon getImage(boolean checkValid) {
        Indi child = this.getChild();
        if (child == null) {
            return super.getImage(checkValid);
        }
        switch (child.getSex()) {
            case 1: {
                return this.overlay(IMG_MALE);
            }
            case 2: {
                return this.overlay(IMG_FEMALE);
            }
        }
        return this.overlay(IMG_UNKNOWN);
    }
}

