/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PropertyCoordinate
extends Property {
    private Double coordinate = Double.NaN;
    private char direction = '\u0000';
    private String value = "";
    private static final Pattern COORD_PATTERN = Pattern.compile("^(?<deg>[-+0-9]+)[^0-9]+(?<min>[0-9]+)[^0-9]+(?<sec>[0-9.,]+)[^0-9.,ENSW]+(?<pos>[ENSW]*)$");
    private static final Pattern GDC_COORD_PATTERN = Pattern.compile("^(?<pos>[ENSW]?)(?<deg>.*)$");

    private boolean isTrueCoordinate() {
        return !this.coordinate.isNaN() && (this.direction == '\u0000' || this.direction == this.getDirection(this.coordinate)) && this.isValidCoordinateRange(this.coordinate);
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty() && super.isValid() || this.isTrueCoordinate();
    }

    abstract char getDirection(double var1);

    abstract boolean isValidCoordinateRange(double var1);

    public PropertyCoordinate(String tag) {
        super(tag);
    }

    private double parseCoordinate(String value) {
        Matcher matcher;
        double result = Double.NaN;
        this.direction = '\u0000';
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 2).replace("\"\"", "\"");
        }
        if ((matcher = COORD_PATTERN.matcher(value = value.toUpperCase())).matches()) {
            double deg = Double.parseDouble(matcher.group("deg"));
            double min = Double.parseDouble(matcher.group("min"));
            double sec = Double.parseDouble(matcher.group("sec"));
            String p = matcher.group("pos");
            if (!p.isEmpty()) {
                this.direction = p.charAt(0);
            }
            result = deg + min / 60.0 + sec / 3600.0;
            result = this.direction == 'S' || this.direction == 'W' ? -result : result;
            return result;
        }
        matcher = GDC_COORD_PATTERN.matcher(value);
        if (matcher.matches()) {
            String p = matcher.group("pos");
            if (!p.isEmpty()) {
                this.direction = p.charAt(0);
            }
            try {
                result = Double.parseDouble(matcher.group("deg").replace(",", "."));
                result = this.direction == 'S' || this.direction == 'W' ? -result : result;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String getValue() {
        if (this.isTrueCoordinate()) {
            return this.getDirection(this.coordinate) + String.valueOf(Math.abs(this.coordinate));
        }
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String old = this.getValue();
        value = this.trim(value);
        this.coordinate = this.parseCoordinate(value);
        this.value = value;
        this.propagatePropertyChanged(this, old);
    }

    protected String trim(String value) {
        return value != null ? value.replaceAll("\\r\\n|\\r|\\n", " ") : "";
    }

    public Double getDoubleValue() {
        return this.coordinate;
    }
}

