/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.RunExternal;
import ancestris.util.Utilities;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.Origin;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.ThumbnailWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Node;

public class FileBean
extends PropertyBean
implements AncestrisActionProvider {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private JPanel main = null;
    private JCheckBox updateMeta = new JCheckBox(RESOURCES.getString("file.update"), true);
    private FileChooserWidget chooser = new FileChooserWidget();
    private ThumbnailWidget preview = new ThumbnailWidget(){

        protected void handleDrop(List<File> files) {
            if (files.size() == 1) {
                File file = files.get(0);
                FileBean.this.chooser.setFile(file);
                FileBean.this.attributes.setLocal(true);
                FileBean.this.attributes.setFound(file.exists());
                this.setSource(InputSource.get((File)file).orElse(null));
            }
        }
    };
    private AttributeWidget attributes = new AttributeWidget();
    private transient ActionListener doPreview = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String relative;
            PropertyBean.REGISTRY.put("bean.file.dir", FileBean.this.chooser.getDirectory());
            String name = FileBean.this.chooser.getFile();
            File file = FileBean.this.getProperty().getGedcom().getOrigin().getFile(name);
            if (file == null || !file.exists()) {
                FileBean.this.attributes.setLocal(false);
                Utilities.setCursorWaiting((JPanel)FileBean.this.main);
                try {
                    URL url = new URL(name);
                    URLInput urlInput = InputSource.get((URL)url).orElse(null);
                    FileBean.this.preview.setSource((InputSource)urlInput);
                    FileBean.this.attributes.setFound(urlInput != null && urlInput.isAvailable());
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.FINE, "Unable to get url.", ex);
                    FileBean.this.preview.setSource(null);
                    FileBean.this.attributes.setFound(false);
                }
                Utilities.setCursorNormal((JPanel)FileBean.this.main);
                return;
            }
            FileBean.this.attributes.setLocal(true);
            FileBean.this.attributes.setFound(true);
            FileBean.this.preview.setSource((InputSource)InputSource.get((File)file).orElse(null));
            if (GedcomOptions.getInstance().isForceRelative() && (relative = FileBean.this.getProperty().getGedcom().getOrigin().calcRelativeLocation(file.getAbsolutePath())) != null) {
                FileBean.this.chooser.setFile(relative);
            }
        }
    };

    public FileBean() {
        this.main = this;
        this.setLayout(new BorderLayout());
        this.chooser.setComponentPopupMenu((JPopupMenu)new CCPMenu((JComponent)this.chooser));
        this.chooser.setAccessory((JComponent)this.updateMeta);
        this.chooser.addChangeListener((ChangeListener)this.changeSupport);
        this.chooser.addActionListener(this.doPreview);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add((Component)this.chooser);
        panel.add(this.attributes);
        this.add((Component)panel, "North");
        this.add((Component)this.preview, "Center");
        this.defaultFocus = this.chooser;
    }

    @Override
    public void setPropertyImpl(Property property) {
        String dir;
        Origin origin = this.getRoot().getGedcom().getOrigin();
        String string = dir = origin.getFile() != null ? origin.getFile().getParent() : null;
        if (dir != null) {
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new FilePermission(dir, "read"));
                }
                this.chooser.setDirectory(REGISTRY.get("bean.file.dir", dir));
                this.chooser.setVisible(true);
                this.defaultFocus = this.chooser;
            }
            catch (SecurityException se) {
                this.chooser.setVisible(false);
                this.defaultFocus = null;
            }
        }
        this.preview.setSource(null);
        this.attributes.setFile(property);
        if (property instanceof PropertyFile) {
            PropertyFile file = (PropertyFile)property;
            this.chooser.setTemplate(false);
            this.chooser.setFile(file.getValue());
            if (property.getValue().length() > 0) {
                this.preview.setSource((InputSource)((PropertyFile)property).getInput().orElse(null));
            }
        }
        if (property instanceof PropertyBlob) {
            PropertyBlob blob = (PropertyBlob)property;
            this.chooser.setFile(blob.getValue());
            this.chooser.setTemplate(true);
            this.preview.setSource((InputSource)((PropertyBlob)property).getInput().orElse(null));
        }
    }

    @Override
    protected void commitImpl(Property property) {
        InputSource is;
        String value = this.chooser.getFile();
        File file = new File(value);
        if (file.exists()) {
            is = InputSource.get((File)file).orElse(null);
        } else {
            try {
                is = InputSource.get((URL)new URL(value)).orElse(null);
            }
            catch (MalformedURLException mfue) {
                is = null;
            }
        }
        if (property instanceof PropertyFile) {
            ((PropertyFile)property).setValue(value, this.updateMeta.isSelected());
        }
        if (property instanceof PropertyBlob) {
            ((PropertyBlob)property).load(is, this.updateMeta.isSelected());
        }
        this.preview.setSource(is);
        this.attributes.setFile(property);
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        PropertyFile file;
        if (!hasFocus) {
            return AncestrisActionProvider.EMPTY_ACTIONS;
        }
        ArrayList<Action> result = new ArrayList<Action>(1);
        if (nodes != null && (file = (PropertyFile)this.getProperty()) != null) {
            result.add((Action)new RunExternal((InputSource)((FileInput)file.getInput().get())));
        }
        return result;
    }

    private class NonEditableCheckBox
    extends JCheckBox {
        public NonEditableCheckBox(String text) {
            super(text);
            this.addActionListener(evt -> this.setSelected(!this.isSelected()));
        }
    }

    private class AttributeWidget
    extends Box {
        private NonEditableCheckBox isLocalCheck;
        private NonEditableCheckBox isFoundCheck;

        public AttributeWidget() {
            super(0);
            this.isLocalCheck = new NonEditableCheckBox(PropertyBean.RESOURCES.getString("file.local"));
            this.isFoundCheck = new NonEditableCheckBox(PropertyBean.RESOURCES.getString("file.found"));
            this.add(this.isLocalCheck);
            this.add(new JLabel("    "));
            this.add(this.isFoundCheck);
            this.add(Box.createGlue());
        }

        private void setFile(Property prop) {
            if (prop instanceof PropertyFile) {
                PropertyFile pFile = (PropertyFile)prop;
                this.setLocal(!pFile.isIsRemote());
                this.setFound(pFile.isFound());
            }
            if (FileBean.this.property instanceof PropertyBlob) {
                this.setLocal(true);
                this.setFound(true);
            }
        }

        private void setLocal(boolean set) {
            this.isLocalCheck.setSelected(set);
        }

        private void setFound(boolean set) {
            this.isFoundCheck.setSelected(set);
        }
    }
}

