/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.beans.ImageBean;
import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.ReferencesTablePanel;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.Registry;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class MultiMediaObjectEditor
extends EntityEditor {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private Context context;
    private Property mRoot;
    private Property mMultiMediaObject;
    private InputSource mFile = null;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private Box.Filler filler1;
    private ImageBean imageBean;
    private JPanel imagePanel;
    private JLabel multiMediaObjectFileLabel;
    private JTextField multiMediaObjectFileTextField;
    private JLabel multiMediaObjectIDLabel;
    private JTextField multiMediaObjectIDTextField;
    private JPanel multiMediaObjectReferencesPanel;
    private JTabbedPane multiMediaObjectTabbedPane;
    private JLabel multiMediaObjectTitleLabel;
    private JTextField multiMediaObjectTitleTextField;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private ReferencesTablePanel referencesTablePanel;

    public MultiMediaObjectEditor() {
        this(false);
    }

    public MultiMediaObjectEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.multiMediaObjectTitleTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.multiMediaObjectFileTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
    }

    private void initComponents() {
        this.multiMediaObjectIDLabel = new JLabel();
        this.multiMediaObjectIDTextField = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.multiMediaObjectTabbedPane = new JTabbedPane();
        this.imagePanel = new JPanel();
        this.imageBean = new ImageBean();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.multiMediaObjectReferencesPanel = new JPanel();
        this.referencesTablePanel = new ReferencesTablePanel();
        this.multiMediaObjectTitleLabel = new JLabel();
        this.multiMediaObjectTitleTextField = new JTextField();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.multiMediaObjectFileTextField = new JTextField();
        this.multiMediaObjectFileLabel = new JLabel();
        this.multiMediaObjectIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("MultiMediaObjectEditor.multiMediaObjectIDLabel.text"), new Object[0]));
        this.multiMediaObjectIDTextField.setEditable(false);
        this.multiMediaObjectIDTextField.setColumns(8);
        this.multiMediaObjectIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("MultiMediaObjectEditor.multiMediaObjectIDTextField.text"), new Object[0]));
        this.imagePanel.setLayout(new BorderLayout());
        this.imageBean.setToolTipText(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.imageBean.toolTipText"));
        this.imageBean.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultiMediaObjectEditor.this.imageBeanMouseClicked(evt);
            }
        });
        GroupLayout imageBeanLayout = new GroupLayout(this.imageBean);
        this.imageBean.setLayout(imageBeanLayout);
        imageBeanLayout.setHorizontalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 539, Short.MAX_VALUE));
        imageBeanLayout.setVerticalGroup(imageBeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 212, Short.MAX_VALUE));
        this.imagePanel.add((Component)this.imageBean, "Center");
        this.multiMediaObjectTabbedPane.addTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.imagePanel.TabConstraints.tabTitle"), this.imagePanel);
        this.noteCitationsTablePanel.setMinimumSize(null);
        this.noteCitationsTablePanel.setPreferredSize(null);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(notesPanelLayout.createSequentialGroup().addComponent(this.noteCitationsTablePanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.multiMediaObjectTabbedPane.addTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.notesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.notesPanel);
        this.referencesTablePanel.setPreferredSize(null);
        GroupLayout multiMediaObjectReferencesPanelLayout = new GroupLayout(this.multiMediaObjectReferencesPanel);
        this.multiMediaObjectReferencesPanel.setLayout(multiMediaObjectReferencesPanelLayout);
        multiMediaObjectReferencesPanelLayout.setHorizontalGroup(multiMediaObjectReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesTablePanel, -1, -1, Short.MAX_VALUE));
        multiMediaObjectReferencesPanelLayout.setVerticalGroup(multiMediaObjectReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesTablePanel, -1, -1, Short.MAX_VALUE));
        this.multiMediaObjectTabbedPane.addTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectReferencesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.multiMediaObjectReferencesPanel);
        this.multiMediaObjectTitleLabel.setHorizontalAlignment(4);
        this.multiMediaObjectTitleLabel.setText(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectTitleLabel.text"));
        this.multiMediaObjectTitleTextField.setMinimumSize(new Dimension(303, 19));
        this.multiMediaObjectTitleTextField.setPreferredSize(new Dimension(303, 27));
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.changeDateLabel.text"));
        this.multiMediaObjectFileTextField.setText(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectFileTextField.text"));
        this.multiMediaObjectFileTextField.setMinimumSize(new Dimension(303, 19));
        this.multiMediaObjectFileTextField.setPreferredSize(new Dimension(303, 27));
        this.multiMediaObjectFileLabel.setHorizontalAlignment(4);
        this.multiMediaObjectFileLabel.setText(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectFileLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addComponent(this.multiMediaObjectTabbedPane).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.multiMediaObjectTitleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.multiMediaObjectFileLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.multiMediaObjectTitleTextField, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.multiMediaObjectIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multiMediaObjectIDTextField, -2, 115, -2)).addComponent(this.multiMediaObjectFileTextField, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, 9, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.multiMediaObjectIDLabel).addComponent(this.multiMediaObjectIDTextField, -2, -1, -2).addComponent(this.multiMediaObjectTitleLabel).addComponent(this.multiMediaObjectTitleTextField, -2, -1, -2)).addComponent(this.filler1, -1, -1, Short.MAX_VALUE)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.multiMediaObjectFileTextField, -2, -1, -2).addComponent(this.multiMediaObjectFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multiMediaObjectTabbedPane, -2, 242, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.changeDateLabel).addComponent(this.changeDateLabeldate, -1, 18, Short.MAX_VALUE)).addContainerGap()));
    }

    private void imageBeanMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            File file = new FileChooserBuilder(MultiMediaObjectEditor.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_ChooseImage")).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OK_Button")).setDefaultExtension(FileChooserBuilder.getImageFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getImageFilter()).setAcceptAllFileFilterUsed(true).setDefaultPreviewer().setFileHiding(true).setDefaultWorkingDirectory(new File(Registry.get(MultiMediaObjectEditor.class).get("rootPath", "."))).showOpenDialog();
            if (file == null) {
                return;
            }
            this.mFile = InputSource.get((File)file).orElse(null);
            if (this.mFile != null) {
                this.multiMediaObjectFileTextField.setText(this.mFile.getLocation());
            } else {
                this.multiMediaObjectFileTextField.setText("");
            }
            this.imageBean.setImage(this.mFile, 0);
            this.changes.fireChangeEvent();
        }
        if (evt.getButton() == 3 && this.mFile != null) {
            if (this.mFile instanceof FileInput) {
                FileAssociation.getDefault().execute(((FileInput)this.mFile).getFile().getAbsolutePath());
            }
            if (this.mFile instanceof URLInput) {
                FileAssociation.getDefault().execute(((URLInput)this.mFile).getURL());
            }
        }
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity property = context.getEntity();
        if (property == null || !(property instanceof Media)) {
            property = context.getProperty();
        }
        if (property != null && property.getGedcom() != null) {
            this.mMultiMediaObject = property instanceof PropertyMedia ? ((PropertyMedia)property).getTargetEntity() : property;
            this.setTitle(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)(this.isNew() ? "MultiMediaObjectEditor.create.title" : "MultiMediaObjectEditor.edit.title"), (Object)this.mMultiMediaObject));
            Property property2 = this.mRoot = this.mMultiMediaObject.getParent() == null ? this.mMultiMediaObject : this.mMultiMediaObject.getParent();
            if (this.mMultiMediaObject instanceof Media) {
                this.multiMediaObjectIDTextField.setText(((Media)this.mMultiMediaObject).getId());
                this.multiMediaObjectTitleTextField.setText(((Media)this.mMultiMediaObject).getTitle());
                this.changeDateLabel.setVisible(true);
                this.changeDateLabeldate.setVisible(true);
                Property changeDate = this.mMultiMediaObject.getProperty("CHAN");
                if (changeDate != null) {
                    this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
                }
                ArrayList<Entity> entitiesList = new ArrayList<Entity>();
                for (PropertyXRef entityRef : this.mMultiMediaObject.getProperties(PropertyXRef.class)) {
                    entitiesList.add(entityRef.getTargetEntity());
                }
                this.referencesTablePanel.set((Entity)((Media)this.mMultiMediaObject), entitiesList);
                int indexOfTab = this.multiMediaObjectTabbedPane.indexOfTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectReferencesPanel.TabConstraints.tabTitle"));
                if (indexOfTab == -1) {
                    this.multiMediaObjectTabbedPane.addTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectReferencesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.multiMediaObjectReferencesPanel);
                }
            } else {
                Property propertyTitle = this.mMultiMediaObject.getProperty("TITL");
                this.multiMediaObjectTitleTextField.setText(propertyTitle != null ? propertyTitle.getValue() : "");
                this.multiMediaObjectIDTextField.setVisible(false);
                this.multiMediaObjectIDLabel.setVisible(false);
                this.changeDateLabel.setVisible(false);
                this.changeDateLabeldate.setVisible(false);
                int indexOfTab = this.multiMediaObjectTabbedPane.indexOfTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectReferencesPanel.TabConstraints.tabTitle"));
                if (indexOfTab != -1) {
                    this.multiMediaObjectTabbedPane.removeTabAt(this.multiMediaObjectTabbedPane.indexOfTab(NbBundle.getMessage(MultiMediaObjectEditor.class, (String)"MultiMediaObjectEditor.multiMediaObjectReferencesPanel.TabConstraints.tabTitle")));
                }
            }
            Property multimediaFile = this.mMultiMediaObject.getProperty("FILE", false);
            if (multimediaFile != null && multimediaFile instanceof PropertyFile) {
                this.mFile = ((PropertyFile)multimediaFile).getInput().orElse(null);
                this.imageBean.setImage(this.mFile, 0);
                this.multiMediaObjectFileTextField.setText(multimediaFile.getDisplayValue());
            } else {
                PropertyBlob propertyBlob = (PropertyBlob)this.mMultiMediaObject.getProperty("BLOB", true);
                this.imageBean.setImage(propertyBlob != null ? (InputSource)propertyBlob.getInput().get() : null, 0);
            }
            this.noteCitationsTablePanel.set(this.mMultiMediaObject, Arrays.asList(this.mMultiMediaObject.getProperties("NOTE")));
        }
    }

    public void commit() {
        if (this.changes.hasChanged()) {
            File newFile = new File(this.multiMediaObjectFileTextField.getText());
            if (newFile.exists()) {
                this.mFile = InputSource.get((File)newFile).orElse(null);
            } else {
                try {
                    URL newURL = new URL(this.multiMediaObjectFileTextField.getText());
                    this.mFile = InputSource.get((URL)newURL).orElse(null);
                }
                catch (MalformedURLException ex) {
                    this.mFile = null;
                }
            }
            this.imageBean.setImage(this.mFile, 0);
            if (this.mMultiMediaObject instanceof Media) {
                if (this.mFile != null) {
                    ((Media)this.mMultiMediaObject).addFile(this.mFile);
                }
                ((Media)this.mMultiMediaObject).setTitle(this.multiMediaObjectTitleTextField.getText().isEmpty() ? (this.mFile != null ? this.mFile.getName() : "") : this.multiMediaObjectTitleTextField.getText());
            } else {
                Property propertyTitle;
                if (this.mFile != null) {
                    this.mMultiMediaObject.addFile(this.mFile);
                }
                if ((propertyTitle = this.mMultiMediaObject.getProperty("TITL")) == null) {
                    this.mMultiMediaObject.addProperty("TITL", this.multiMediaObjectTitleTextField.getText().isEmpty() ? (this.mFile != null ? this.mFile.getName() : "") : this.multiMediaObjectTitleTextField.getText());
                } else {
                    propertyTitle.setValue(this.multiMediaObjectTitleTextField.getText().isEmpty() ? (this.mFile != null ? this.mFile.getName() : "") : this.multiMediaObjectTitleTextField.getText());
                }
            }
        }
    }

    public Entity getEditedEntity() {
        return this.mMultiMediaObject.getEntity();
    }
}

