/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.panels.AddressEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.MultimediaObjectCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.Submitter;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SubmitterEditor
extends EntityEditor {
    private Context context;
    private Submitter mSubmitter;
    private AddressEditorPanel addressEditorPanel;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JTextField firstPreferLanguageTextField;
    private JPanel languagesPanel;
    private MultimediaObjectCitationsTablePanel multimediaObjectCitationsTablePanel;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JTextField secondPreferLanguageTextField;
    private JLabel submitterNameLabel;
    private JTextField submitterNameTextField;
    private JTabbedPane submitterTabbedPane;
    private JTextField thirdPreferLanguageTextField;

    public SubmitterEditor() {
        this(false);
    }

    public SubmitterEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.submitterNameTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.firstPreferLanguageTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.secondPreferLanguageTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.thirdPreferLanguageTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.addressEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.multimediaObjectCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
    }

    private void initComponents() {
        this.languagesPanel = new JPanel();
        this.firstPreferLanguageTextField = new JTextField();
        this.secondPreferLanguageTextField = new JTextField();
        this.thirdPreferLanguageTextField = new JTextField();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.submitterNameLabel = new JLabel();
        this.submitterNameTextField = new JTextField();
        this.submitterTabbedPane = new JTabbedPane();
        this.addressEditorPanel = new AddressEditorPanel();
        this.multimediaObjectCitationsTablePanel = new MultimediaObjectCitationsTablePanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.languagesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.languagesPanel.border.title"), 0, 2));
        GroupLayout languagesPanelLayout = new GroupLayout(this.languagesPanel);
        this.languagesPanel.setLayout(languagesPanelLayout);
        languagesPanelLayout.setHorizontalGroup(languagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagesPanelLayout.createSequentialGroup().addContainerGap().addGroup(languagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.firstPreferLanguageTextField).addComponent(this.secondPreferLanguageTextField).addComponent(this.thirdPreferLanguageTextField)).addContainerGap()));
        languagesPanelLayout.setVerticalGroup(languagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.firstPreferLanguageTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondPreferLanguageTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.thirdPreferLanguageTextField, -2, -1, -2).addContainerGap()));
        this.changeDateLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.changeDateLabel, (String)NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.changeDateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.submitterNameLabel, (String)NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.submitterNameLabel.text"));
        this.submitterTabbedPane.addTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.addressEditorPanel.TabConstraints.tabTitle"), this.addressEditorPanel);
        this.submitterTabbedPane.addTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.multimediaObjectCitationsTablePanel.TabConstraints.tabTitle"), this.multimediaObjectCitationsTablePanel);
        this.submitterTabbedPane.addTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.noteCitationsTablePanel.TabConstraints.tabTitle"), this.noteCitationsTablePanel);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.languagesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.submitterTabbedPane, -1, 486, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.submitterNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitterNameTextField))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitterNameLabel).addComponent(this.submitterNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languagesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitterTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.changeDateLabel).addComponent(this.changeDateLabeldate, -2, 14, -2))));
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Submitter && entity.getGedcom() != null) {
            int index;
            this.mSubmitter = (Submitter)entity;
            this.setTitle(NbBundle.getMessage(SubmitterEditor.class, (String)(this.isNew() ? "SubmitterEditor.create.title" : "SubmitterEditor.edit.title"), (Object)this.mSubmitter));
            Property name = this.mSubmitter.getProperty("NAME");
            this.submitterNameTextField.setText(name != null ? name.getDisplayValue() : "");
            Property address = this.mSubmitter.getProperty("ADDR", false);
            this.addressEditorPanel.set((Property)this.mSubmitter, address);
            this.multimediaObjectCitationsTablePanel.set((Property)this.mSubmitter, Arrays.asList(this.mSubmitter.getProperties("OBJE")));
            Property[] preferedLanguages = this.mSubmitter.getProperties("LANG", false);
            block10: for (index = 0; index < preferedLanguages.length; ++index) {
                switch (index) {
                    case 0: {
                        this.firstPreferLanguageTextField.setText(preferedLanguages[0].getValue());
                        continue block10;
                    }
                    case 1: {
                        this.secondPreferLanguageTextField.setText(preferedLanguages[1].getValue());
                        continue block10;
                    }
                    case 2: {
                        this.thirdPreferLanguageTextField.setText(preferedLanguages[2].getValue());
                        continue block10;
                    }
                }
            }
            while (index < 3) {
                switch (index) {
                    case 0: {
                        this.firstPreferLanguageTextField.setText("");
                        break;
                    }
                    case 1: {
                        this.secondPreferLanguageTextField.setText("");
                        break;
                    }
                    case 2: {
                        this.thirdPreferLanguageTextField.setText("");
                        break;
                    }
                }
                ++index;
            }
            if (!this.mSubmitter.getGedcom().getGrammar().getVersion().equals("5.5.1")) {
                int indexOfTab = this.submitterTabbedPane.indexOfTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.noteCitationsTablePanel.TabConstraints.tabTitle"));
                if (indexOfTab != -1) {
                    this.submitterTabbedPane.removeTabAt(indexOfTab);
                }
            } else {
                if (this.submitterTabbedPane.indexOfTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.noteCitationsTablePanel.TabConstraints.tabTitle")) == -1) {
                    this.submitterTabbedPane.addTab(NbBundle.getMessage(SubmitterEditor.class, (String)"SubmitterEditor.noteCitationsTablePanel.TabConstraints.tabTitle"), this.noteCitationsTablePanel);
                }
                this.noteCitationsTablePanel.set((Property)this.mSubmitter, Arrays.asList(this.mSubmitter.getProperties("NOTE")));
            }
            Property changeDate = this.mSubmitter.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
        }
    }

    public void commit() throws GedcomException {
        if (this.changes.hasChanged()) {
            Property name = this.mSubmitter.getProperty("NAME");
            if (name != null) {
                name.setValue(this.submitterNameTextField.getText());
            } else {
                this.mSubmitter.addProperty("NAME", this.submitterNameTextField.getText());
            }
            Property[] preferedLanguages = this.mSubmitter.getProperties("LANG", false);
            if (!this.firstPreferLanguageTextField.getText().isEmpty()) {
                if (preferedLanguages.length > 0 && preferedLanguages[0] != null) {
                    if (this.firstPreferLanguageTextField.getText().isEmpty()) {
                        preferedLanguages[0].setValue(this.firstPreferLanguageTextField.getText());
                    }
                } else {
                    this.mSubmitter.addProperty("LANG", this.firstPreferLanguageTextField.getText());
                }
            } else if (preferedLanguages.length > 0 && preferedLanguages[0] != null) {
                this.mSubmitter.delProperty(preferedLanguages[0]);
            }
            if (!this.secondPreferLanguageTextField.getText().isEmpty()) {
                if (preferedLanguages.length > 1 && preferedLanguages[1] != null) {
                    if (this.secondPreferLanguageTextField.getText().isEmpty()) {
                        preferedLanguages[1].setValue(this.secondPreferLanguageTextField.getText());
                    }
                } else {
                    this.mSubmitter.addProperty("LANG", this.secondPreferLanguageTextField.getText());
                }
            } else if (preferedLanguages.length > 1 && preferedLanguages[1] != null) {
                this.mSubmitter.delProperty(preferedLanguages[1]);
            }
            if (!this.thirdPreferLanguageTextField.getText().isEmpty()) {
                if (preferedLanguages.length > 2 && preferedLanguages[2] != null) {
                    if (this.thirdPreferLanguageTextField.getText().isEmpty()) {
                        preferedLanguages[2].setValue(this.thirdPreferLanguageTextField.getText());
                    }
                } else {
                    this.mSubmitter.addProperty("LANG", this.thirdPreferLanguageTextField.getText());
                }
            } else if (preferedLanguages.length > 2 && preferedLanguages[2] != null) {
                this.mSubmitter.delProperty(preferedLanguages[2]);
            }
            this.addressEditorPanel.commit();
        }
    }

    public Entity getEditedEntity() {
        return this.mSubmitter;
    }
}

