/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Property;
import genj.gedcom.PropertyRepository;
import genj.gedcom.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class SourcesTableModel
extends AbstractTableModel {
    List<Source> mSourcesList = new ArrayList<Source>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.ID.title"), NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.description.title"), NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.events.title"), NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.date.title"), NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.repository.title"), NbBundle.getMessage(SourcesTableModel.class, (String)"SourcesTableModel.column.repository_caln.title")};

    @Override
    public int getRowCount() {
        return this.mSourcesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Source source = this.mSourcesList.get(row);
        if (source != null) {
            switch (column) {
                case 0: {
                    return source.getId();
                }
                case 1: {
                    return source.getTitle();
                }
                case 2: {
                    Property propertyByPath = source.getPropertyByPath(".:DATA:EVEN");
                    if (propertyByPath != null) {
                        return propertyByPath.getDisplayValue();
                    }
                    return "";
                }
                case 3: {
                    Property propertyByPath = source.getPropertyByPath(".:DATA:EVEN:DATE");
                    if (propertyByPath != null) {
                        return propertyByPath.getDisplayValue();
                    }
                    return "";
                }
                case 4: {
                    Property p = source.getProperty("REPO");
                    PropertyRepository repositoryXref = (PropertyRepository)(p instanceof PropertyRepository ? p : null);
                    if (repositoryXref != null) {
                        return repositoryXref.getDisplayValue();
                    }
                    return "";
                }
                case 5: {
                    Property p = source.getProperty("REPO");
                    PropertyRepository repositoryXref = (PropertyRepository)(p instanceof PropertyRepository ? p : null);
                    if (repositoryXref != null) {
                        Property caln = repositoryXref.getProperty("CALN");
                        if (caln != null) {
                            return caln.getDisplayValue();
                        }
                        return "";
                    }
                    return "";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Source source) {
        this.mSourcesList.add(source);
        this.fireTableDataChanged();
    }

    public void addAll(Collection<Source> sourcesList) {
        this.mSourcesList.addAll(sourcesList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.mSourcesList.clear();
    }

    public Source getValueAt(int row) {
        return this.mSourcesList.get(row);
    }

    public Source remove(int row) {
        Source source = this.mSourcesList.remove(row);
        this.fireTableDataChanged();
        return source;
    }
}

