/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.IndiPanel;
import ancestris.util.swing.DialogManager;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.renderer.MediaUtils;
import genj.renderer.RenderSelectionHintKey;
import genj.view.BigBufferedImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ImagePanel
extends JPanel
implements DropTargetListener {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private IndiPanel callingPanel = null;
    private BufferedImage IMG_MAIN = null;
    private BufferedImage IMG_DEFAULT = null;
    private static final int DEFAULT_WIDTH = 197;
    private static final int DEFAULT_HEIGHT = 140;
    private static final String CROPPED = "-cropped";
    private BufferedImage image = null;
    private InputSource inputSource = null;
    private InputSource mainInputSource = null;
    private int x;
    private int y;
    private static int startX;
    private static int startY;
    private double sourceZoom;
    private boolean ready;
    private static final RenderingHints TEXT_RENDER_HINTS;
    private static final RenderingHints IMAGE_RENDER_HINTS;
    private static final RenderingHints RENDER_HINTS;

    public ImagePanel(IndiPanel callingPanel) {
        this.callingPanel = callingPanel;
        this.x = 0;
        this.y = 0;
        startX = 0;
        startY = 0;
        this.ready = false;
        this.initComponents();
        this.setDropTarget(new DropTarget(this, this));
    }

    public void setMedia(InputSource is, BufferedImage defaultImage) {
        this.setMedia(is, defaultImage, false);
    }

    public void setMedia(InputSource is, BufferedImage defaultImage, boolean isMainImage) {
        this.IMG_DEFAULT = defaultImage;
        if (isMainImage && this.mainInputSource != null && this.mainInputSource == is && this.IMG_MAIN != null) {
            this.inputSource = this.mainInputSource;
            this.image = this.IMG_MAIN;
        } else if (this.inputSource != is) {
            this.inputSource = is;
            this.image = MediaUtils.getImageFromFile((InputSource)this.inputSource, this.getClass(), (BufferedImage)defaultImage);
            if (isMainImage && this.image != defaultImage) {
                this.mainInputSource = is;
                this.IMG_MAIN = this.image;
            }
        }
        if (this.image == null || is == null) {
            this.image = defaultImage;
        }
        final ImagePanel ip = this;
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ImagePanel.this.sourceZoom = (double)ip.getWidth() / (double)ImagePanel.this.image.getWidth();
                double s2 = (double)ip.getHeight() / (double)ImagePanel.this.image.getHeight();
                if (s2 > ImagePanel.this.sourceZoom) {
                    ImagePanel.this.sourceZoom = s2;
                }
                if (ImagePanel.this.sourceZoom > 20.0) {
                    ImagePanel.this.sourceZoom = 20.0;
                }
                if (ImagePanel.this.sourceZoom < 0.1) {
                    ImagePanel.this.sourceZoom = 0.1;
                }
                ImagePanel.this.x = (int)((double)(ip.getWidth() / 2 - (int)((double)ImagePanel.this.image.getWidth() * ImagePanel.this.sourceZoom / 2.0)) / ImagePanel.this.sourceZoom);
                ImagePanel.this.y = (int)((double)(ip.getHeight() / 2 - (int)((double)ImagePanel.this.image.getHeight() * ImagePanel.this.sourceZoom / 2.0)) / ImagePanel.this.sourceZoom);
                ImagePanel.this.ready = true;
                ImagePanel.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        super.paintComponent(grphcs);
        if (!this.ready) {
            return;
        }
        Graphics2D g2d = (Graphics2D)grphcs;
        ImagePanel.applyRenderHints(g2d);
        g2d.scale(this.sourceZoom, this.sourceZoom);
        g2d.drawImage((Image)this.image, this.x, this.y, null);
        this.ready = true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(197, 140);
    }

    public static void applyRenderHints(Graphics2D g2d) {
        g2d.setRenderingHints(TEXT_RENDER_HINTS);
        g2d.setRenderingHints(IMAGE_RENDER_HINTS);
        g2d.setRenderingHints(RENDER_HINTS);
    }

    private void initComponents() {
        this.setBorder(null);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ImagePanel.this.formMouseDragged(evt);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ImagePanel.this.formMouseWheelMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImagePanel.this.formMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ImagePanel.this.formMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if ((this.callingPanel == null || evt.getButton() != 1) && (this.callingPanel != null && evt.getButton() == 3 && this.inputSource != null || this.callingPanel == null && evt.getButton() == 1 && this.inputSource != null)) {
            if (this.inputSource instanceof FileInput) {
                FileAssociation.getDefault().execute(((FileInput)this.inputSource).getFile().getAbsolutePath());
            }
            if (this.inputSource instanceof URLInput) {
                FileAssociation.getDefault().execute(((URLInput)this.inputSource).getURL());
            }
        }
    }

    private void formMousePressed(MouseEvent evt) {
        startX = (int)((double)evt.getX() - (double)this.x * this.sourceZoom);
        startY = (int)((double)evt.getY() - (double)this.y * this.sourceZoom);
    }

    private void formMouseDragged(MouseEvent evt) {
        this.x = (int)((double)(evt.getX() - startX) / this.sourceZoom);
        this.y = (int)((double)(evt.getY() - startY) / this.sourceZoom);
        this.repaint();
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        int notches = evt.getWheelRotation();
        double zoom = Math.pow(1.1f, -notches);
        double pointX = evt.getX();
        double pointY = evt.getY();
        double zoomafter = this.sourceZoom * zoom;
        if (zoomafter > 20.0) {
            zoomafter = 20.0;
        }
        if (zoomafter < 0.1) {
            zoomafter = 0.1;
        }
        this.x = (int)((double)this.x - (pointX / this.sourceZoom - pointX / zoomafter));
        this.y = (int)((double)this.y - (pointY / this.sourceZoom - pointY / zoomafter));
        this.sourceZoom = zoomafter;
        this.repaint();
    }

    public void redraw() {
        if (this.IMG_DEFAULT != null) {
            this.setMedia(this.inputSource, this.IMG_DEFAULT);
        }
    }

    public InputSource getInput() {
        return this.inputSource;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void cropAndSave() {
        try {
            int w = this.getWidth();
            int h = this.getHeight();
            BigBufferedImage subImage = BigBufferedImage.create((File)new File(System.getProperty("java.io.tmpdir")), (int)w, (int)h, (int)1);
            Graphics2D g = subImage.createGraphics();
            g.setRenderingHint(RenderSelectionHintKey.KEY, false);
            g.setClip(0, 0, w, h);
            this.paint(g);
            g.dispose();
            String ext = null;
            String s = this.inputSource.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            String c = s.contains(CROPPED) ? "i" : CROPPED;
            File file = new File(this.inputSource.getLocation());
            String filepath = file.exists() ? file.getParentFile().getAbsolutePath() + File.separator + s.substring(0, i) + c + "." + ext : " ";
            file = new File(filepath);
            ImageIO.write((RenderedImage)subImage, ext, file);
            this.setMedia(InputSource.get((File)file).orElse(null), (BufferedImage)subImage);
            DialogManager.create((String)NbBundle.getMessage(ImagePanel.class, (String)"TITL_CroppedSuccessfully"), (String)NbBundle.getMessage(ImagePanel.class, (String)"MSG_CroppedSuccessfully", (Object)file.getName())).setMessageType(1).show();
        }
        catch (Exception e) {
            DialogManager.create((String)NbBundle.getMessage(ImagePanel.class, (String)"TITL_CannotSaveCopy"), (String)e.getLocalizedMessage()).setMessageType(0).show();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            dtde.acceptDrop(dtde.getDropAction());
            this.handleDrop((List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor));
            dtde.dropComplete(true);
        }
        catch (Throwable t) {
            dtde.dropComplete(false);
        }
    }

    protected void handleDrop(List<File> files) {
    }

    static {
        TEXT_RENDER_HINTS = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        IMAGE_RENDER_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RENDER_HINTS = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }
}

