/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.modules.imports.gedcom.ImportAhnenblatt;
import genj.gedcom.Context;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyRelationship;
import java.io.IOException;
import java.util.ArrayList;
import org.openide.util.NbBundle;

public class ImportAldfaer
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return NbBundle.getMessage(ImportAhnenblatt.class, (String)"importaldfaer.name");
    }

    protected String getImportComment() {
        return NbBundle.getMessage(ImportAhnenblatt.class, (String)"importaldfaer.note");
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected boolean process() throws IOException {
        String valueBefore;
        String pathBefore;
        if ("DATE".equals(this.input.getTag())) {
            pathBefore = this.input.getPath().getShortName();
            valueBefore = this.input.getValue();
            if (valueBefore.contains("FROM") && !valueBefore.contains("TO")) {
                String valueAfter = valueBefore.replace("FROM", "");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            if (valueBefore.contains("TO") && !valueBefore.contains("FROM")) {
                String valueAfter = valueBefore.replace("TO", "");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            if (valueBefore.contains("FROM") && valueBefore.contains("BEF")) {
                String valueAfter = valueBefore.replace("BEF", "");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            if (valueBefore.contains("FROM") && valueBefore.contains("AFT")) {
                String valueAfter = valueBefore.replace("AFT", "");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            if (valueBefore.contains("FROM") && valueBefore.contains("ABT")) {
                String valueAfter = valueBefore.replace("ABT", "");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
        }
        if ("NAME".equals(this.input.getTag())) {
            pathBefore = this.input.getPath().getShortName();
            valueBefore = this.input.getValue();
            long count = valueBefore.chars().filter(ch -> ch == 47).count();
            if (count > 2L) {
                int i = valueBefore.lastIndexOf("/");
                i = valueBefore.lastIndexOf("/", i - 1);
                String valueAfter = valueBefore.substring(0, i).replace("/", ",") + valueBefore.substring(i);
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidName", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            if (valueBefore.contains("//")) {
                String valueAfter = valueBefore.replace("//", "/*/");
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                this.fixes.add(new ImportFix(this.currentXref, "invalidName", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
        }
        if ("_ASSO".equals(this.input.getTag())) {
            pathBefore = this.input.getPath().getShortName();
            valueBefore = this.input.getValue();
            this.output.writeLine(this.input.getLevel(), "ASSO", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", pathBefore, this.input.getPath().getParent().getShortName() + ":ASSO", valueBefore, valueBefore));
            return true;
        }
        return super.process();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean retour = super.fixGedcom(gedcom);
        return retour | this.manageAssociations(gedcom);
    }

    private boolean manageAssociations(Gedcom gedcom) {
        boolean retour = false;
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        gedcom.getFamilies().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        boolean isV55 = Grammar.V55.equals(gedcom.getGrammar());
        if (!isV55) {
            for (Property p : list) {
                Property typeProp = p.getProperty("TYPE");
                if (typeProp == null) continue;
                String valueBefore = typeProp.getValue();
                String pathBefore = typeProp.getPath(true).getShortName();
                Property newType = p.addProperty("_TYPE", valueBefore);
                p.delProperty(typeProp);
                this.fixes.add(new ImportFix(p.getEntity().getId(), "invalidTagLocation.1", pathBefore, newType.getPath().getShortName(), valueBefore, valueBefore));
                retour = true;
            }
        }
        for (Property p : list) {
            PropertyRelationship pr;
            PropertyAssociation pa;
            if (!(p instanceof PropertyAssociation) || !((pa = (PropertyAssociation)p).getTargetEntity() instanceof Fam) || (pr = (PropertyRelationship)pa.getProperty("RELA")) == null || pr.getAnchor() != null) continue;
            String valueBefore = pr.getValue();
            String valueAfter = pr.getValue() + " @#FAM:MARR@";
            pr.setValue(valueAfter);
            this.fixes.add(new ImportFix(p.getEntity().getId(), "swithAssos.2", pr.getPath().getShortName(), pr.getPath().getShortName(), valueBefore, valueAfter));
            retour = true;
        }
        return retour;
    }
}

