/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImportAncestry
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importancestry_name();
    }

    protected String getImportComment() {
        return Bundle.importancestry_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void init() {
        super.init();
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if (path.toString().endsWith("_META") || path.toString().endsWith("_DSCR")) {
            this.output.writeLine(this.input.getLevel(), "NOTE", valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.2", pathBefore, path.getParent().getShortName() + ":NOTE", valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.processEntities(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public boolean processEntities(Gedcom gedcom) {
        boolean hasErrors = false;
        for (Indi indi : gedcom.getIndis()) {
            String pathAfter;
            String pathBefore;
            String valueBefore;
            Property[] sources;
            Property sex = indi.getProperty("SEX", false);
            Property[] propertyArray = sources = sex != null ? sex.getProperties("SOUR", false) : null;
            if (sex != null && sources != null && sources.length != 0) {
                Set<String> existingSources = this.getSources(indi.getProperty("NAME"));
                existingSources.addAll(this.getSources((Property)indi));
                ArrayList<Property> deleteSources = new ArrayList<Property>();
                ArrayList<Property> moveupSources = new ArrayList<Property>();
                for (Property source : sources) {
                    String value = source.getValue();
                    if (value.isEmpty() || !value.startsWith("@") || !value.endsWith("@")) continue;
                    if (existingSources.contains(value = value.substring(1, value.length() - 1))) {
                        deleteSources.add(source);
                        valueBefore = source.getValue();
                        pathBefore = source.getPath(true).getShortName();
                        pathAfter = "";
                        this.fixes.add(new ImportFix(indi.getId(), "invalidSourceLocation.1", pathBefore, pathAfter, valueBefore, valueBefore));
                        hasErrors = true;
                        continue;
                    }
                    moveupSources.add(source);
                    valueBefore = source.getValue();
                    pathBefore = source.getPath(true).getShortName();
                    pathAfter = indi.getPath(true).getShortName() + ":SOUR";
                    this.fixes.add(new ImportFix(indi.getId(), "invalidSourceLocation.2", pathBefore, pathAfter, valueBefore, valueBefore));
                    hasErrors = true;
                }
                for (Property source : deleteSources) {
                    sex.delProperty(source);
                }
                for (Property source : moveupSources) {
                    this.movePropertiesRecursively(source, (Property)indi);
                }
            }
            Property[] marrs = indi.getProperties("MARR", false);
            Property[] divs = indi.getProperties("DIV", false);
            Property[] famss = indi.getProperties("FAMS", false);
            if (marrs.length <= 0 && divs.length <= 0 || famss.length != 1) continue;
            Entity fam = ((PropertyXRef)famss[0]).getTargetEntity();
            for (Property marr : marrs) {
                valueBefore = marr.getValue();
                pathBefore = marr.getPath(true).getShortName();
                pathAfter = fam.getPath(true).getShortName() + ":MARR";
                this.fixes.add(new ImportFix(indi.getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
                this.movePropertiesRecursively(marr, (Property)fam);
            }
            for (Property div : divs) {
                valueBefore = div.getValue();
                pathBefore = div.getPath(true).getShortName();
                pathAfter = fam.getPath(true).getShortName() + ":DIV";
                this.fixes.add(new ImportFix(indi.getId(), "invalidTagLocation.3", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
                this.movePropertiesRecursively(div, (Property)fam);
            }
        }
        for (Entity ent : gedcom.getEntities()) {
            List notes = ent.getAllProperties("NOTE");
            for (Property note : notes) {
                if (!note.getPath().toString().contains("SOUR:DATA:NOTE")) continue;
                String value = note.getValue();
                Property parent = note.getParent();
                Property newNote = parent.addProperty("_NOTE", value);
                String valueBefore = value;
                String pathBefore = note.getPath(true).getShortName();
                String pathAfter = newNote.getPath(true).getShortName();
                parent.delProperty(note);
                this.fixes.add(new ImportFix(ent.getId(), "invalidTagLocation.1", pathBefore, pathAfter, valueBefore, valueBefore));
                hasErrors = true;
            }
        }
        return hasErrors;
    }

    private Set<String> getSources(Property host) {
        Property[] sources;
        HashSet<String> ret = new HashSet<String>();
        for (Property source : sources = host.getProperties("SOUR")) {
            if (!(source instanceof PropertySource)) continue;
            PropertySource pSource = (PropertySource)source;
            ret.add(pSource.getTargetEntity().getId());
        }
        return ret;
    }
}

