/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.modules.imports.gedcom.ImportAhnenblatt;
import genj.gedcom.Context;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.io.IOException;
import java.util.logging.Level;
import org.openide.util.NbBundle;

public class ImportBrotherKeeper
extends Import {
    public String toString() {
        return "BROSKEEP";
    }

    public boolean isGeneric() {
        return false;
    }

    protected String getImportComment() {
        return NbBundle.getMessage(ImportAhnenblatt.class, (String)"importbk.note");
    }

    protected boolean process() throws IOException {
        if ("DATE".equals(this.input.getTag())) {
            String[] dateSplit;
            String pathBefore = this.input.getPath().getShortName();
            String valueBefore = this.input.getValue();
            Calendar calendar = null;
            if (valueBefore.contains("@#D")) {
                for (Calendar cal : PointInTime.CALENDARS) {
                    if (!valueBefore.contains(cal.getEscape())) continue;
                    calendar = cal;
                    break;
                }
            }
            String valueAfter = valueBefore;
            if (calendar != null) {
                valueAfter = valueAfter.substring(calendar.getEscape().length() + 1);
            }
            if ((dateSplit = valueAfter.split("-")).length == 3) {
                try {
                    PointInTime pit = new PointInTime(Integer.valueOf(dateSplit[0]) - 1, Integer.valueOf(dateSplit[1]) - 1, Integer.valueOf(dateSplit[2]).intValue(), (Calendar)(calendar != null ? calendar : PointInTime.GREGORIAN));
                    if (!pit.isValid()) {
                        return super.process();
                    }
                    valueAfter = pit.getValue();
                    this.output.writeLine(this.input.getLevel(), this.input.getTag(), valueAfter);
                    this.fixes.add(new ImportFix(this.currentXref, "invalidDate.6", pathBefore, pathBefore, valueBefore, valueAfter));
                    return true;
                }
                catch (NumberFormatException e) {
                    LOG.log(Level.INFO, "Error during Date conversion.", e);
                    return super.process();
                }
            }
        }
        return super.process();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }
}

