/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import ancestris.util.TimingUtility;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.TagPath;
import java.io.IOException;

public class ImportGeneric
extends Import {
    public boolean isGeneric() {
        return true;
    }

    public String toString() {
        return Bundle.importgeneric_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneric_note();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    protected void init() {
        super.init();
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
    }

    protected boolean process() throws IOException {
        if (super.process()) {
            return true;
        }
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        TimingUtility.getInstance().reset();
        if ("HEAD:GEDC:VERS".equalsIgnoreCase(pathBefore)) {
            String valueAfter = this.GEDCOM_VERSION;
            if (!valueBefore.equals(valueAfter)) {
                this.output.writeLine(2, "VERS", this.GEDCOM_VERSION);
                this.fixes.add(new ImportFix(this.currentXref, "header.Version", pathBefore, pathBefore, valueBefore, valueAfter));
                return true;
            }
            return false;
        }
        return false;
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        return super.fixGedcom(gedcom);
    }

    public void complete() {
        super.complete();
    }
}

