/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.viewers.media;

import ancestris.modules.viewers.media.MediaDescription;
import ancestris.modules.viewers.media.MediaFilterPanel;
import ancestris.modules.viewers.media.MediaWrapper;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.renderer.MediaRenderer;
import genj.renderer.MediaUtils;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class MediaChooser
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static int THUMB_WIDTH = 50;
    private static int THUMB_HEIGHT = 70;
    private static Map<String, ImageIcon> cacheIcon = new HashMap<String, ImageIcon>();
    private static Map<String, List<Property>> mapFilepathKeys = new HashMap<String, List<Property>>();
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<MediaThumb> allMedia = new TreeSet<MediaThumb>(this.thumbComparator);
    private DefaultListModel filteredModel = new DefaultListModel();
    private Gedcom gedcom = null;
    private MediaWrapper mainMedia = null;
    private Image scaledImage = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private SwingWorker<Void, Void> worker;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneMedia;
    private JSplitPane jSplitPane;
    private JLabel labelPhoto;
    private MediaDescription mediaDescriptionPanel;
    private MediaFilterPanel mediaFilter;
    private JList mediaList;
    private JLabel photoTitle;
    protected static Set events_birth = new HashSet<String>(Arrays.asList("BIRT", "CHR", "BAPM", "BARM", "BASM", "BLES", "ADOP"));
    protected static Set events_marr = new HashSet<String>(Arrays.asList("MARR", "MARC", "DIV", "ANUL", "ENGA", "DIVF", "MARL", "MARS"));
    protected static Set events_death = new HashSet<String>(Arrays.asList("DEAT", "BURI", "CREM"));
    protected static Set events_other = new HashSet<String>(Arrays.asList("CHRA", "CONF", "FCOM", "ORDN", "NATU", "EMIG", "IMMI", "CENS", "PROB", "WILL", "GRAD", "RETI", "EVEN"));
    protected static Set events_general = new HashSet<String>(Arrays.asList("INDI", "FAM"));
    protected String CAT_BIRT = Gedcom.getName((String)"BIRT");
    protected String CAT_MARR = Gedcom.getName((String)"MARR");
    protected String CAT_DEAT = Gedcom.getName((String)"DEAT");
    protected String CAT_OTHE = NbBundle.getMessage(this.getClass(), (String)"Cat_Othe");
    protected String CAT_GENE = NbBundle.getMessage(this.getClass(), (String)"Cat_Gene");

    public MediaChooser(Gedcom gedcom) {
        this.init(gedcom, null, null, null, true, false);
    }

    public MediaChooser(Gedcom gedcom, MediaWrapper media, JButton okButton, JButton cancelButton, boolean sourceImages) {
        this.init(gedcom, media, okButton, cancelButton, false, sourceImages);
    }

    private void init(Gedcom gedcom, MediaWrapper media, JButton okButton, JButton cancelButton, boolean allFiles, boolean sourceImages) {
        this.gedcom = gedcom;
        this.mainMedia = media;
        this.okButton = okButton;
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        this.cancelButton = cancelButton;
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.jSplitPane.setDividerLocation(this.registry.get("mediaSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.labelPhoto.setText("");
        this.displayMedia();
        this.mediaList.setCellRenderer(new ListEntryCellRenderer());
        this.worker = null;
        this.jScrollPaneMedia.getViewport().addChangeListener(e -> this.executeWorker());
        this.allMedia.clear();
        mapFilepathKeys.clear();
        if (allFiles) {
            this.createMediaThumbs(false);
            this.createMediaThumbs(true);
        } else {
            this.createMediaThumbs(sourceImages);
        }
        this.mediaFilter.resetCombosValues(this.allMedia);
        this.filteredModel.clear();
        for (MediaThumb item : this.allMedia) {
            item.nbFileUsed = mapFilepathKeys.get(item.fileLocation).size();
            this.filteredModel.addElement(item);
        }
        SwingUtilities.invokeLater(() -> {
            this.filterModel();
            this.selectMedia(this.mainMedia);
        });
    }

    private void executeWorker() {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                for (int i = MediaChooser.this.mediaList.getFirstVisibleIndex(); i <= MediaChooser.this.mediaList.getLastVisibleIndex() && !this.isCancelled(); ++i) {
                    MediaThumb mediaThumb = (MediaThumb)MediaChooser.this.mediaList.getModel().getElementAt(i);
                    mediaThumb.setIcon();
                    MediaChooser.this.jScrollPaneMedia.getViewport().repaint();
                    if (this.isCancelled()) break;
                }
                return null;
            }
        };
        this.worker.execute();
    }

    private void selectMedia(MediaWrapper media) {
        MediaThumb selectedMedia = null;
        if (media == null) {
            selectedMedia = this.allMedia.first();
        } else {
            Entity parentOfKey;
            Object object = parentOfKey = media.getRecordType() ? media.getTargetMedia() : media.getHostingProperty();
            if (parentOfKey == null) {
                selectedMedia = this.allMedia.first();
            } else {
                Property key = parentOfKey.getProperty("FILE");
                for (MediaThumb mediai : this.allMedia) {
                    if (!mediai.key.equals(key)) continue;
                    selectedMedia = mediai;
                    break;
                }
            }
        }
        if (selectedMedia != null) {
            final MediaThumb mediai = selectedMedia;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    MediaChooser.this.mediaList.setSelectedValue(mediai, true);
                    Rectangle rect = MediaChooser.this.mediaList.getCellBounds(MediaChooser.this.mediaList.getMinSelectionIndex(), MediaChooser.this.mediaList.getMaxSelectionIndex());
                    if (rect != null) {
                        MediaChooser.this.mediaList.scrollRectToVisible(rect);
                    }
                }
            });
        }
    }

    private void displayMedia() {
        this.displayMediaDetails(this.labelPhoto.getPreferredSize().width, this.labelPhoto.getPreferredSize().height);
    }

    private void displayMediaDetails(int width, int height) {
        if (this.filteredModel.isEmpty() || this.mediaList.getSelectedIndex() < 0) {
            return;
        }
        MediaThumb media = (MediaThumb)this.filteredModel.get(this.mediaList.getSelectedIndex());
        if (media == null) {
            return;
        }
        Image image = media.getImage();
        if (image != null) {
            double imageRatio = (double)image.getWidth(null) / (double)image.getHeight(null);
            double targetRatio = (double)width / (double)(height = Math.max(height, 10));
            this.scaledImage = targetRatio < imageRatio ? image.getScaledInstance(width, -1, 1) : image.getScaledInstance(-1, height, 1);
        }
        this.labelPhoto.repaint();
        this.photoTitle.setText("<html><center>" + media.title + "</center></html>");
        this.photoTitle.setPreferredSize(new Dimension(width, -1));
        this.mediaDescriptionPanel.setValues(media, mapFilepathKeys.get(media.fileLocation));
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.labelPhoto = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (MediaChooser.this.scaledImage != null) {
                    ((Graphics2D)g).drawImage(MediaChooser.this.scaledImage, 0 + (this.getWidth() - MediaChooser.this.scaledImage.getWidth(this)) / 2, (this.getHeight() - MediaChooser.this.scaledImage.getHeight(this)) / 2, null);
                }
            }
        };
        this.photoTitle = new JLabel();
        this.mediaDescriptionPanel = new MediaDescription();
        this.jPanel2 = new JPanel();
        this.mediaFilter = new MediaFilterPanel(this.gedcom, this);
        this.jScrollPaneMedia = new JScrollPane();
        this.mediaList = new JList(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MediaChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(200, 383));
        this.labelPhoto.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.labelPhoto, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.labelPhoto.text"));
        this.labelPhoto.setToolTipText(NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.labelPhoto.toolTipText"));
        this.labelPhoto.setBorder(BorderFactory.createEtchedBorder());
        this.labelPhoto.setPreferredSize(new Dimension(232, 352));
        this.labelPhoto.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaChooser.this.labelPhotoMouseClicked(evt);
            }
        });
        this.labelPhoto.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MediaChooser.this.labelPhotoComponentResized(evt);
            }
        });
        this.photoTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.photoTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.photoTitle, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.photoTitle.text"));
        this.photoTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mediaDescriptionPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPhoto, -1, 188, Short.MAX_VALUE).addComponent(this.photoTitle, -1, -1, Short.MAX_VALUE).addComponent(this.mediaDescriptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.photoTitle, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelPhoto, -1, 232, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mediaDescriptionPanel, -2, -1, -2).addContainerGap()));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        this.mediaList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.mediaList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.mediaList.setSelectionMode(0);
        this.mediaList.setLayoutOrientation(2);
        this.mediaList.setVisibleRowCount(-1);
        this.mediaList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaChooser.this.mediaListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MediaChooser.this.mediaListMousePressed(evt);
            }
        });
        this.mediaList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MediaChooser.this.mediaListValueChanged(evt);
            }
        });
        this.jScrollPaneMedia.setViewportView(this.mediaList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneMedia)).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1, -1, 724, Short.MAX_VALUE))).addContainerGap()).addComponent(this.mediaFilter, -2, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.mediaFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneMedia, -1, 302, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, -1, -2)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 954, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 507, Short.MAX_VALUE));
    }

    private void mediaListValueChanged(ListSelectionEvent evt) {
        if (!this.mediaList.isSelectionEmpty()) {
            this.displayMediaDetails(this.labelPhoto.getWidth(), this.labelPhoto.getHeight());
            if (this.okButton != null) {
                this.okButton.setEnabled(true);
            }
            this.executeWorker();
        } else if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
    }

    private void labelPhotoComponentResized(ComponentEvent evt) {
        this.displayMediaDetails(this.labelPhoto.getWidth(), this.labelPhoto.getHeight());
    }

    private void mediaListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.okButton != null) {
            this.okButton.doClick();
        }
    }

    private void labelPhotoMouseClicked(MouseEvent evt) {
        int index = this.mediaList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        MediaThumb media = (MediaThumb)this.filteredModel.get(index);
        InputSource is = media.inputSource;
        if (evt.getButton() == 1 && is != null) {
            if (is instanceof FileInput) {
                FileAssociation.getDefault().execute(((FileInput)is).getFile().getAbsolutePath());
            }
            if (is instanceof URLInput) {
                FileAssociation.getDefault().execute(((URLInput)is).getURL());
            }
        }
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("mediaSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void mediaListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mediaList.setSelectedIndex(this.mediaList.locationToIndex(evt.getPoint()));
            JPopupMenu menu = new JPopupMenu();
            MediaThumb media = this.getSelectedThumb();
            Entity entity = media.entity;
            Entity[] ents = PropertyXRef.getReferences((Entity)media.entity);
            if (media.isMedia && ents.length > 0) {
                for (Entity ent : ents) {
                    JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)ent.toString(true)));
                    menu.add(menuItem);
                    Entity finalEntity = ent;
                    menuItem.addActionListener(ae -> this.edit(finalEntity));
                }
            } else {
                JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)entity.toString(true)));
                menu.add(menuItem);
                menuItem.addActionListener(ae -> this.edit(entity));
            }
            menu.show(this.mediaList, evt.getX(), evt.getY());
        }
    }

    private void edit(Entity entity) {
        if (this.cancelButton != null) {
            this.cancelButton.doClick();
        }
        SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private void createMediaThumbs(boolean sourceImages) {
        PropertyFile.suspendExistenceCheck = true;
        for (Entity entity : this.gedcom.getEntities()) {
            List fileProperties = entity.getProperties(PropertyFile.class);
            for (PropertyFile fileProperty : fileProperties) {
                boolean flag;
                Property mediaTitle;
                boolean isSourceMedia;
                boolean bl = isSourceMedia = entity instanceof Media ? this.isTagAncestorOfMediaEntity((Media)entity, new HashSet<String>(Arrays.asList("SOUR"))) : this.isTagAncestorOfFile((Property)fileProperty, new HashSet<String>(Arrays.asList("SOUR")));
                if ((!isSourceMedia || !sourceImages) && (isSourceMedia || sourceImages)) continue;
                String title = "";
                Entity[] ents = new Entity[]{entity};
                if (entity instanceof Media) {
                    ents = PropertyXRef.getReferences((Entity)entity);
                }
                if ((mediaTitle = fileProperty.getProperty("TITL")) == null || mediaTitle.getValue().isEmpty()) {
                    mediaTitle = fileProperty.getParent().getProperty("TITL");
                }
                if (mediaTitle != null && !mediaTitle.getDisplayValue().trim().isEmpty()) {
                    title = mediaTitle.getDisplayValue().trim();
                    flag = true;
                } else if (ents.length > 0) {
                    title = ents[0].toString(false).trim();
                    flag = false;
                } else {
                    title = entity.toString(false).trim();
                    flag = false;
                }
                int[] qualifiers = fileProperty.getPath(true).getQualifiers();
                int position = qualifiers[qualifiers.length - 1] + 1;
                if (position > 1) {
                    title = title + " (" + position + ")";
                }
                InputSource is = MediaRenderer.getSource((Property)fileProperty);
                MediaThumb media = new MediaThumb(fileProperty, is, sourceImages, title, ents, position, this.getTagEvents(entity, (Property)fileProperty));
                this.addKeyToFilelist(is != null ? is.getLocation() : fileProperty.getValue(), fileProperty.getParent());
                media.setTrueTitle(flag);
                media.setUnused(ents.length == 0);
                this.allMedia.add(media);
            }
        }
        PropertyFile.suspendExistenceCheck = false;
    }

    private void addKeyToFilelist(String value, Property key) {
        List<Property> list = mapFilepathKeys.get(value);
        if (list == null) {
            list = new ArrayList<Property>();
            mapFilepathKeys.put(value, list);
        }
        list.add(key);
    }

    private MediaThumb getSelectedThumb() {
        return (MediaThumb)this.filteredModel.get(this.mediaList.getSelectedIndex());
    }

    public boolean isSelectedEntityMedia() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? false : media.isMedia;
    }

    public Entity getSelectedEntity() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? null : media.entity;
    }

    public InputSource getSelectedInput() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? null : media.inputSource;
    }

    public String getSelectedTitle() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? "" : media.title;
    }

    public void filterModel() {
        if (this.mediaList == null) {
            return;
        }
        this.mediaList.clearSelection();
        this.mediaList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        this.allMedia.stream().filter(item -> this.mediaFilter.matches((MediaThumb)item)).sorted(this.thumbComparator).forEachOrdered(item -> this.filteredModel.addElement(item));
        this.mediaList.setModel(this.filteredModel);
        this.mediaFilter.update(this.filteredModel.getSize());
        SwingUtilities.invokeLater(() -> this.executeWorker());
    }

    private boolean isTagAncestorOfFile(Property property, Set<String> tags) {
        return MediaUtils.parentTagsContains((Property)property, tags);
    }

    private boolean isTagAncestorOfMediaEntity(Media entity, Set<String> tags) {
        List references = entity.getProperties(PropertyXRef.class);
        for (PropertyXRef refProp : references) {
            if (!MediaUtils.parentTagsContains((Property)refProp, tags)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getTagEvents(Entity entity, Property property) {
        HashSet<String> ret = new HashSet<String>();
        boolean isMedia = entity instanceof Media;
        if (isMedia) {
            if (this.isTagAncestorOfMediaEntity((Media)entity, events_birth)) {
                ret.add(this.CAT_BIRT);
            }
            if (this.isTagAncestorOfMediaEntity((Media)entity, events_marr)) {
                ret.add(this.CAT_MARR);
            }
            if (this.isTagAncestorOfMediaEntity((Media)entity, events_death)) {
                ret.add(this.CAT_DEAT);
            }
            if (this.isTagAncestorOfMediaEntity((Media)entity, events_other)) {
                ret.add(this.CAT_OTHE);
            }
            if (this.isTagAncestorOfMediaEntity((Media)entity, events_general)) {
                ret.add(this.CAT_GENE);
            }
        } else {
            if (this.isTagAncestorOfFile(property, events_birth)) {
                ret.add(this.CAT_BIRT);
            }
            if (this.isTagAncestorOfFile(property, events_marr)) {
                ret.add(this.CAT_MARR);
            }
            if (this.isTagAncestorOfFile(property, events_death)) {
                ret.add(this.CAT_DEAT);
            }
            if (this.isTagAncestorOfFile(property, events_other)) {
                ret.add(this.CAT_OTHE);
            }
            if (this.isTagAncestorOfFile(property, events_general)) {
                ret.add(this.CAT_GENE);
            }
        }
        return ret;
    }

    public int getNbMedia() {
        return this.allMedia.size();
    }

    private class ThumbComparator
    implements Comparator<MediaThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(MediaThumb o1, MediaThumb o2) {
            InputSource is1 = o1.inputSource;
            InputSource is2 = o2.inputSource;
            String folder1 = is1 != null ? is1.getLocation() : "";
            String folder2 = is2 != null ? is2.getLocation() : "";
            String id1 = o1.entity.getId();
            String id2 = o2.entity.getId();
            String total1 = "";
            String total2 = "";
            int sortOrder = MediaChooser.this.mediaFilter.getSortOrder();
            switch (sortOrder) {
                case 0: {
                    total1 = o1.title.toLowerCase() + folder1 + id1;
                    total2 = o2.title.toLowerCase() + folder2 + id2;
                    break;
                }
                case 1: {
                    total1 = (is1 != null ? is1.getName() : "") + folder1 + id1;
                    total2 = (is2 != null ? is2.getName() : "") + folder2 + id2;
                    break;
                }
                case 2: {
                    total1 = folder1 + id1;
                    total2 = folder2 + id2;
                    break;
                }
                case 3: {
                    int l1 = o1.entities.length;
                    int l2 = o2.entities.length;
                    if (l1 > l2) {
                        return -1;
                    }
                    if (l1 < l2) {
                        return 1;
                    }
                    total1 = folder1 + id1;
                    total2 = folder2 + id2;
                    break;
                }
            }
            return total1.compareTo(total2);
        }
    }

    protected class MediaThumb {
        public Property key = null;
        public Entity entity = null;
        public boolean isSource = false;
        public boolean isMedia = false;
        public boolean isUnused = false;
        public Entity[] entities = null;
        public Set<String> tagEvents = null;
        public String fileValue = "";
        public String fileLocation = "";
        public InputSource inputSource = null;
        public boolean isFileLocal = false;
        public boolean isFileRemote = false;
        public int position = 1;
        public int nbFileUsed = 1;
        public ImageIcon icon = null;
        public String title = "";
        public boolean isTrueTitle = true;

        private MediaThumb(PropertyFile key, InputSource is, boolean isSource, String title, Entity[] ents, int position, Set<String> tagEvents) {
            this.key = key;
            this.entity = key.getEntity();
            this.isMedia = this.entity instanceof Media;
            this.fileValue = key.getValue();
            this.isFileLocal = !key.isIsRemote();
            this.isFileRemote = key.isIsRemote();
            this.inputSource = is;
            this.fileLocation = is != null ? is.getLocation() : key.getValue();
            this.isSource = isSource;
            this.title = title;
            this.entities = ents;
            this.position = position;
            this.tagEvents = tagEvents;
        }

        public Image getImage() {
            MediaRenderer.getSource((Property)this.key);
            return MediaUtils.getImageFromFile((InputSource)this.inputSource, this.getClass(), (BufferedImage)(this.isSource ? MediaUtils.IMG_NO_SOURCE_MEDIA : MediaUtils.IMG_INVALID_PHOTO));
        }

        public void setIcon() {
            MediaRenderer.getSource((Property)this.key);
            ImageIcon imageIcon = this.icon = this.inputSource == null ? null : (ImageIcon)cacheIcon.get(this.inputSource.getLocation());
            if (this.icon == null) {
                this.icon = new ImageIcon(MediaUtils.scaleImage((InputSource)this.inputSource, this.getClass(), (int)THUMB_WIDTH, (int)THUMB_HEIGHT, (BufferedImage)(this.isSource ? MediaUtils.IMG_NO_SOURCE_MEDIA : MediaUtils.IMG_INVALID_PHOTO)));
                if (this.inputSource != null && this.inputSource.isAvailable()) {
                    cacheIcon.put(this.inputSource.getLocation(), this.icon);
                }
            }
        }

        private void setTrueTitle(boolean flag) {
            this.isTrueTitle = flag;
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }

        public boolean isFound() {
            return ((PropertyFile)this.key).isFound();
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListEntryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MediaThumb entry = (MediaThumb)value;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            int labelWidth = THUMB_WIDTH + 30;
            int nbLines = this.getFontMetrics(this.getFont()).stringWidth(entry.title) / labelWidth + 3;
            int labelHeight = THUMB_HEIGHT + 12 * nbLines;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            String color = entry.isTrueTitle && !entry.isUnused ? "black" : (!entry.isTrueTitle && !entry.isUnused ? "blue" : "red");
            this.setText("<html><center><font color=" + color + ">" + entry.title + "</font></center></html>");
            this.setIcon(entry.icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
                this.setOpaque(true);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.setOpaque(false);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }
}

