/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace.format;

import ancestris.core.pluginservice.PluginInterface;
import ancestris.modules.editors.geoplace.format.GedcomPlacesAligner;
import ancestris.modules.editors.geoplace.format.GedcomPlacesConverter;
import ancestris.modules.editors.geoplace.format.PlaceFormatConverterPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PlaceFormatPanel
extends JPanel {
    private Gedcom gedcom;
    private JButton confirmButton;
    private String originalPlaceFormat = "";
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private Set<String> incorrectList = null;
    private int nbExpectedPlaces = 0;
    private PlaceFormatConverterPanel placeFormatConverter = null;
    private JButton addButton;
    private JCheckBox alignPlacesCheckBox;
    private JButton blankButton;
    private JButton convertButton;
    private JCheckBox convertCheckBox;
    private JLabel currentFormatLabel;
    private JScrollPane currentFormatScrollPane;
    private JTextArea currentFormatTextArea;
    private JButton deleteButton;
    private JButton downButton;
    private JLabel errorLabel;
    private Box.Filler filler;
    private JLabel helpLabel;
    private JList jList1;
    private JPanel jPanel;
    private JPanel jPanel3;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane2;
    private JButton listButton;
    private JLabel modifyFormatLabel;
    private JPanel modifyFormatPanel;
    private JTextField newCriteriaTextField;
    private JLabel newFormatLabel;
    private JScrollPane newFormatScrollPane;
    private JTextArea newFormatTextArea;
    private JLabel remark2Label;
    private JLabel remarkLabel;
    private JButton resetButton;
    private JButton upButton;

    public PlaceFormatPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.confirmButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OK_button"));
        this.originalPlaceFormat = PropertyPlace.formatSpaces((String)gedcom.getPlaceFormat());
        this.initComponents();
        this.setTargetPlaceFormat();
        this.updateDisplay();
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jPanel = new JPanel();
        this.currentFormatLabel = new JLabel();
        this.currentFormatScrollPane = new JScrollPane();
        this.currentFormatTextArea = new JTextArea();
        this.remarkLabel = new JLabel();
        this.remark2Label = new JLabel();
        this.listButton = new JButton();
        this.alignPlacesCheckBox = new JCheckBox();
        this.modifyFormatLabel = new JLabel();
        this.filler = new Box.Filler(new Dimension(0, 2), new Dimension(0, 2), new Dimension(Short.MAX_VALUE, 2));
        this.modifyFormatPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.addButton = new JButton();
        this.newCriteriaTextField = new JTextField();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.blankButton = new JButton();
        this.resetButton = new JButton();
        this.jPanel3 = new JPanel();
        this.helpLabel = new JLabel();
        this.newFormatLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.convertCheckBox = new JCheckBox();
        this.convertButton = new JButton();
        this.newFormatScrollPane = new JScrollPane();
        this.newFormatTextArea = new JTextArea();
        this.setBorder(null);
        this.setPreferredSize(new Dimension(630, 450));
        this.jScrollPane.setBorder(null);
        this.jScrollPane.setViewportBorder(null);
        this.jPanel.setBorder(null);
        this.jPanel.setMinimumSize(new Dimension(0, 0));
        this.jPanel.setPreferredSize(new Dimension(495, 375));
        this.currentFormatLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.currentFormatLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.currentFormatLabel.text"));
        this.currentFormatTextArea.setEditable(false);
        this.currentFormatTextArea.setColumns(20);
        this.currentFormatTextArea.setRows(5);
        this.currentFormatScrollPane.setViewportView(this.currentFormatTextArea);
        this.remarkLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.remarkLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.remarkLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.remark2Label, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.remark2Label.text"));
        this.remark2Label.setVerticalAlignment(1);
        this.listButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/List.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.listButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.listButton.text"));
        this.listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.listButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.alignPlacesCheckBox, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.alignPlacesCheckBox.text"));
        this.alignPlacesCheckBox.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.alignPlacesCheckBox.toolTipText"));
        this.alignPlacesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.alignPlacesCheckBoxActionPerformed(evt);
            }
        });
        this.modifyFormatLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.modifyFormatLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.modifyFormatLabel.text"));
        this.modifyFormatPanel.setPreferredSize(new Dimension(493, 210));
        this.jList1.setModel(this.listModel);
        this.jList1.setSelectionMode(0);
        this.jList1.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.jList1.toolTipText"));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PlaceFormatPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.addButton.text"));
        this.addButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.addButton.toolTipText"));
        this.addButton.setEnabled(false);
        this.addButton.setPreferredSize(new Dimension(28, 28));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.newCriteriaTextField.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.newCriteriaTextField.text"));
        this.newCriteriaTextField.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.newCriteriaTextField.toolTipText"));
        this.newCriteriaTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PlaceFormatPanel.this.newCriteriaTextFieldKeyReleased(evt);
            }
        });
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.deleteButton.text"));
        this.deleteButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.deleteButton.toolTipText"));
        this.deleteButton.setPreferredSize(new Dimension(28, 28));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/MoveUp.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.upButton.text"));
        this.upButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.upButton.toolTipText"));
        this.upButton.setPreferredSize(new Dimension(28, 28));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/MoveDown.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.downButton.text"));
        this.downButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.downButton.toolTipText"));
        this.downButton.setPreferredSize(new Dimension(28, 28));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.blankButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Blank.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.blankButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.blankButton.text"));
        this.blankButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.blankButton.toolTipText"));
        this.blankButton.setPreferredSize(new Dimension(28, 28));
        this.blankButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.blankButtonActionPerformed(evt);
            }
        });
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Reset.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.resetButton.text"));
        this.resetButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.resetButton.toolTipText"));
        this.resetButton.setPreferredSize(new Dimension(28, 28));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.helpLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.helpLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.helpLabel.text"));
        this.helpLabel.setVerticalAlignment(1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.helpLabel, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.helpLabel).addContainerGap()));
        GroupLayout modifyFormatPanelLayout = new GroupLayout(this.modifyFormatPanel);
        this.modifyFormatPanel.setLayout(modifyFormatPanelLayout);
        modifyFormatPanelLayout.setHorizontalGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modifyFormatPanelLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 221, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, -1, 44, Short.MAX_VALUE).addComponent(this.deleteButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE)).addComponent(this.blankButton, -2, 44, -2).addComponent(this.resetButton, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newCriteriaTextField).addGroup(modifyFormatPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        modifyFormatPanelLayout.setVerticalGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, modifyFormatPanelLayout.createSequentialGroup().addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2).addGroup(modifyFormatPanelLayout.createSequentialGroup().addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, -2, -1, -2).addComponent(this.newCriteriaTextField, -2, -1, -2)).addGroup(modifyFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modifyFormatPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.deleteButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blankButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton, -2, -1, -2)).addGroup(modifyFormatPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))))).addGap(12, 12, 12)));
        this.newFormatLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.newFormatLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.newFormatLabel.text"));
        this.errorLabel.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.convertCheckBox, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.convertCheckBox.text"));
        this.convertCheckBox.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.convertCheckBox.toolTipText"));
        this.convertCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.convertCheckBoxActionPerformed(evt);
            }
        });
        this.convertButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Mapping.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.convertButton, (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.convertButton.text"));
        this.convertButton.setToolTipText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.convertButton.toolTipText"));
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatPanel.this.convertButtonActionPerformed(evt);
            }
        });
        this.newFormatTextArea.setEditable(false);
        this.newFormatTextArea.setColumns(20);
        this.newFormatTextArea.setLineWrap(true);
        this.newFormatTextArea.setRows(5);
        this.newFormatScrollPane.setViewportView(this.newFormatTextArea);
        GroupLayout jPanelLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(jPanelLayout);
        jPanelLayout.setHorizontalGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.remarkLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelLayout.createSequentialGroup().addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelLayout.createSequentialGroup().addComponent(this.remark2Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.listButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alignPlacesCheckBox)).addComponent(this.modifyFormatPanel, -1, 613, Short.MAX_VALUE).addComponent(this.newFormatScrollPane).addComponent(this.currentFormatScrollPane).addComponent(this.modifyFormatLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanelLayout.createSequentialGroup().addComponent(this.newFormatLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertButton)).addComponent(this.currentFormatLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler, -2, 0, -2))).addContainerGap()));
        jPanelLayout.setVerticalGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.currentFormatLabel).addGap(0, 0, 0).addComponent(this.currentFormatScrollPane, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remarkLabel).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remark2Label).addComponent(this.alignPlacesCheckBox).addComponent(this.listButton)).addGap(18, 18, 18).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.filler, -1, -1, Short.MAX_VALUE).addComponent(this.modifyFormatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modifyFormatPanel, -1, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.convertCheckBox).addComponent(this.convertButton).addComponent(this.newFormatLabel).addComponent(this.errorLabel)).addComponent(this.newFormatScrollPane, -2, 34, -2).addGap(30, 30, 30)));
        this.jScrollPane.setViewportView(this.jPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane, -1, 630, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane, -1, 450, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void newCriteriaTextFieldKeyReleased(KeyEvent evt) {
        String juris = this.newCriteriaTextField.getText();
        this.addButton.setEnabled(juris != null && !juris.isEmpty() && !this.listModel.contains(juris));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        String defaultFormat = GedcomOptions.getInstance().getPlaceFormat();
        this.setPLAC(!this.originalPlaceFormat.isEmpty() ? this.originalPlaceFormat : defaultFormat);
        this.resetValidation();
    }

    private void blankButtonActionPerformed(ActionEvent evt) {
        this.addNewJurisdiction(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.emptyField"));
        this.resetValidation();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.moveDownSelectedIndex();
        this.resetValidation();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.moveUpSelectedIndex();
        this.resetValidation();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedIndex();
        this.resetValidation();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addNewJurisdiction(this.newCriteriaTextField.getText());
        this.resetValidation();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.updateDisplay(this.jList1.getSelectedIndex());
    }

    private void convertCheckBoxActionPerformed(ActionEvent evt) {
        this.convertButton.setEnabled(this.convertCheckBox.isSelected());
        if (this.convertCheckBox.isSelected() && this.placeFormatConverter == null) {
            this.placeFormatConverter = new PlaceFormatConverterPanel(this.originalPlaceFormat, this.getPLAC(), null);
            this.DisplayPlaceFormatConverter(this.placeFormatConverter);
        }
        this.updateOK();
    }

    private void convertButtonActionPerformed(ActionEvent evt) {
        if (this.placeFormatConverter == null) {
            this.placeFormatConverter = new PlaceFormatConverterPanel(this.originalPlaceFormat, this.getPLAC(), null);
        }
        this.DisplayPlaceFormatConverter(this.placeFormatConverter);
        this.updateOK();
    }

    private void listButtonActionPerformed(ActionEvent evt) {
        this.DisplayIncorrectPlaces(this.incorrectList);
    }

    private void alignPlacesCheckBoxActionPerformed(ActionEvent evt) {
        this.updateOK();
    }

    private void updateOK() {
        this.errorLabel.setVisible(false);
        if (this.convertCheckBox.isSelected()) {
            this.errorLabel.setVisible(true);
            if (this.placeFormatConverter == null || !this.placeFormatConverter.isValidatedMap()) {
                this.errorLabel.setForeground(Color.red);
                this.errorLabel.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.errorLabel.text"));
            } else if (!this.placeFormatConverter.isMapComplete()) {
                this.errorLabel.setForeground(new Color(204, 102, 0));
                this.errorLabel.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.errorLabel.text.warning"));
            } else {
                this.errorLabel.setForeground(new Color(0, 102, 0));
                this.errorLabel.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.errorLabel.text.OK"));
            }
        }
        this.confirmButton.setEnabled(this.isPlacesAlignmentToBeDone() || this.isConversionToBeDone());
    }

    public void setPLAC(String str) {
        String value = PropertyPlace.formatSpaces((String)str);
        if (!value.equals(this.getPLAC())) {
            this.placeFormatConverter = null;
        }
        String[] placeFormatList = PropertyPlace.getFormat((String)str);
        this.listModel.clear();
        for (String p : placeFormatList) {
            if (p.isEmpty()) {
                this.listModel.addElement(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.emptyField"));
                continue;
            }
            this.listModel.addElement(p.trim());
        }
        this.updateDisplay();
    }

    public String getPLAC() {
        boolean USE_SPACES = GedcomOptions.getInstance().isUseSpacedPlaces();
        String ret = "";
        String tmpStr = "";
        String addStr = "," + (USE_SPACES ? " " : "");
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i == this.listModel.getSize() - 1) {
                addStr = "";
            }
            if ((tmpStr = this.listModel.elementAt(i).trim()).equals(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.emptyField"))) {
                tmpStr = "";
            }
            ret = ret + tmpStr + addStr;
        }
        return ret;
    }

    public boolean isConversionToBeDone() {
        return this.convertCheckBox.isSelected() && !this.currentFormatTextArea.getText().equals(this.newFormatTextArea.getText()) && this.placeFormatConverter != null && this.placeFormatConverter.isValidatedMap();
    }

    public boolean isPlacesAlignmentToBeDone() {
        return this.alignPlacesCheckBox.isSelected();
    }

    private void removeSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        this.listModel.remove(index);
        int size = this.listModel.getSize();
        if (size != 0 && index == size) {
            --index;
        }
        this.updateDisplay(index);
    }

    private void addNewJurisdiction(String text) {
        int index = this.jList1.getSelectedIndex();
        index = index == -1 ? 0 : ++index;
        this.listModel.insertElementAt(text, index);
        this.updateDisplay(index);
        this.newCriteriaTextField.requestFocusInWindow();
        this.newCriteriaTextField.setText("");
        this.addButton.setEnabled(false);
    }

    private void moveUpSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        String juris = this.listModel.remove(index);
        this.listModel.add(index - 1, juris);
        this.updateDisplay(index - 1);
    }

    private void moveDownSelectedIndex() {
        int index = this.jList1.getSelectedIndex();
        String juris = this.listModel.remove(index);
        this.listModel.add(index + 1, juris);
        this.updateDisplay(index + 1);
    }

    private void resetValidation() {
        if (this.placeFormatConverter != null) {
            this.placeFormatConverter.setValidatedMap(false, null);
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        this.updateDisplay(this.listModel.isEmpty() ? -1 : 0);
    }

    private void updateDisplay(int index) {
        boolean listIsEmpty = this.listModel.isEmpty();
        boolean indexIsFirst = index == 0;
        boolean indexIsLast = index == this.listModel.getSize() - 1;
        this.deleteButton.setEnabled(!listIsEmpty);
        this.upButton.setEnabled(!listIsEmpty && !indexIsFirst);
        this.downButton.setEnabled(!listIsEmpty && !indexIsLast);
        if (!listIsEmpty) {
            this.jList1.setSelectedIndex(index);
            this.jList1.ensureIndexIsVisible(index);
        }
        this.newFormatTextArea.setText(this.getPLAC());
        this.originalPlaceFormat = PropertyPlace.formatSpaces((String)this.gedcom.getPlaceFormat());
        this.currentFormatTextArea.setText(this.originalPlaceFormat);
        boolean canBeConverted = !this.getPLAC().equals(this.originalPlaceFormat);
        this.convertCheckBox.setVisible(canBeConverted);
        this.convertCheckBox.setSelected(canBeConverted);
        this.convertButton.setVisible(canBeConverted);
        this.convertButton.setEnabled(this.convertCheckBox.isSelected());
        this.currentFormatLabel.setVisible(true);
        this.currentFormatScrollPane.setVisible(true);
        if (canBeConverted && this.placeFormatConverter != null) {
            this.placeFormatConverter.setValidatedMap(false, this.getPLAC());
        }
        this.remarkLabel.setVisible(true);
        this.remark2Label.setVisible(true);
        Set<String> keys = this.getNbOfDifferentPlaces(this.gedcom);
        String nbOfDifferentFoundPlaces = "" + keys.size();
        this.remarkLabel.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.remarkLabel.text", (Object)nbOfDifferentFoundPlaces));
        this.nbExpectedPlaces = PropertyPlace.getFormat((String)this.originalPlaceFormat).length;
        this.incorrectList = this.getIncorrectPlaces(this.nbExpectedPlaces, keys);
        if (this.incorrectList.isEmpty()) {
            this.remark2Label.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.remark2Label.text"));
            this.alignPlacesCheckBox.setVisible(false);
            this.listButton.setVisible(false);
        } else {
            this.remark2Label.setText(NbBundle.getMessage(PlaceFormatPanel.class, (String)"PlaceFormatPanel.remark2Label.text.incorrect", (Object)this.incorrectList.size(), (Object)this.nbExpectedPlaces));
            this.alignPlacesCheckBox.setVisible(true);
            this.listButton.setVisible(true);
        }
        this.updateOK();
    }

    private void DisplayPlaceFormatConverter(PlaceFormatConverterPanel placeFormatConverter) {
        placeFormatConverter.initToFields(this.getPLAC());
        Object o = DialogManager.create((String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"TITL_PlaceFormatConversionSettings"), (JComponent)placeFormatConverter).setMessageType(-1).show();
        placeFormatConverter.setValidatedMap(o == DialogManager.OK_OPTION, null);
        this.updateOK();
    }

    private Set<String> getNbOfDifferentPlaces(Gedcom gedcom) {
        TreeSet<String> ret = new TreeSet<String>();
        for (Property place : gedcom.getPropertiesByClass(PropertyPlace.class)) {
            ret.add(place.getValue());
        }
        return ret;
    }

    private Set<String> getIncorrectPlaces(int nbExpected, Set<String> places) {
        TreeSet<String> ret = new TreeSet<String>();
        for (String place : places) {
            if (place.isEmpty() || PropertyPlace.getFormat((String)place).length == nbExpected) continue;
            ret.add(place);
        }
        return ret;
    }

    private void setTargetPlaceFormat() {
        String defaultFormat = GedcomOptions.getInstance().getPlaceFormat();
        this.setPLAC(!this.originalPlaceFormat.isEmpty() ? this.originalPlaceFormat : defaultFormat);
        this.resetValidation();
    }

    private void DisplayIncorrectPlaces(Set<String> list) {
        boolean isGeoFound = false;
        PluginInterface pi = null;
        for (PluginInterface sInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
            if (!"ancestris.modules.geo".equals(sInterface.getPluginName())) continue;
            pi = sInterface;
            isGeoFound = true;
            break;
        }
        JButton geoButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Geo"));
        geoButton.setEnabled(isGeoFound);
        if (isGeoFound) {
            final PluginInterface geo = pi;
            geoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    geo.launchModule((Object)PlaceFormatPanel.this.gedcom);
                }
            });
        }
        JScrollPane panel = new JScrollPane(new JList<Object>(list.toArray()));
        panel.setPreferredSize(new Dimension(Math.max(panel.getPreferredSize().width, 400), 300));
        Object[] options = new Object[]{DialogManager.OK_OPTION, geoButton};
        DialogManager.create((String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"TITL_IncorrectList", (Object)list.size(), (Object)this.nbExpectedPlaces), (JComponent)panel).setMessageType(-1).setOptionType(10).setOptions(options).setDialogId("incorrectPlaces").show();
    }

    public void execute() {
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (JComponent)this).setMessageType(-1).setOptions(new Object[]{this.confirmButton, DialogManager.CANCEL_OPTION}).setDialogId("actionPlaceFormat").show();
        if (o == this.confirmButton) {
            Object o2;
            if (this.placeFormatConverter != null && !this.placeFormatConverter.isMapComplete() && (o2 = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (String)NbBundle.getMessage(this.getClass(), (String)"WNG_PlaceMapIncomplete")).setMessageType(2).setOptionType(2).setDialogId("incompletePlaceMessage").show()) == DialogManager.CANCEL_OPTION) {
                return;
            }
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PlaceFormatPanel.this.commit();
                    }
                });
            }
            catch (Throwable ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void commit() {
        String msg;
        String title;
        if (this.isPlacesAlignmentToBeDone()) {
            title = NbBundle.getMessage(PlaceFormatPanel.class, (String)"TITL_PlacesAlignment");
            msg = "";
            GedcomPlacesAligner placesAligner = new GedcomPlacesAligner(this.gedcom);
            if (placesAligner.convert()) {
                msg = NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_GedcomPlacesAligned", (Object)placesAligner.getNbOfPlacesAligned(), (Object)placesAligner.getNbOfPlaces());
                DialogManager.create((String)title, (String)msg).setMessageType(1).show();
            } else {
                msg = NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_GedcomPlacesNotAligned", (Object)placesAligner.getNbOfPlacesAligned(), (Object)placesAligner.getNbOfPlaces());
                msg = msg + "\n\n" + placesAligner.getError().getMessage();
                DialogManager.create((String)title, (String)msg).setMessageType(2).show();
            }
        }
        if (this.isConversionToBeDone()) {
            if (this.placeFormatConverter == null || !this.placeFormatConverter.isValidatedMap()) {
                DialogManager.createError((String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"TITL_PlacesFormatModification"), (String)NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_ConversionMapMandatory")).show();
                return;
            }
            title = NbBundle.getMessage(PlaceFormatPanel.class, (String)"TITL_PlacesFormatModification");
            msg = "";
            this.gedcom.setPlaceFormat(this.getPLAC());
            GedcomPlacesConverter placesConverter = new GedcomPlacesConverter(this.gedcom, this.originalPlaceFormat, this.getPLAC(), this.placeFormatConverter.getConversionMapAsString());
            if (placesConverter.convert()) {
                msg = NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_GedcomModified", (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object)placesConverter.getNbOfDifferentFoundPlaces());
                DialogManager.create((String)title, (String)msg).setMessageType(1).show();
            } else {
                msg = NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_GedcomNotModified", (Object)placesConverter.getNbOfDifferentChangedPlaces(), (Object)placesConverter.getNbOfDifferentFoundPlaces());
                msg = msg + "\n\n" + placesConverter.getError().getMessage();
                DialogManager.create((String)title, (String)msg).setMessageType(2).show();
            }
        } else {
            String newFormat;
            String oldFormat = this.gedcom.getPlaceFormat();
            if (!oldFormat.equals(newFormat = this.getPLAC())) {
                String title2 = NbBundle.getMessage(PlaceFormatPanel.class, (String)"TITL_PlacesHeaderModification");
                String msg2 = NbBundle.getMessage(PlaceFormatPanel.class, (String)"MSG_GedcomHeaderModified");
                this.gedcom.setPlaceFormat(newFormat);
                DialogManager.create((String)title2, (String)msg2).setMessageType(1).show();
            }
        }
    }
}

