/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.DownloadProgress;
import org.netbeans.installer.downloader.services.FileProvider;
import org.netbeans.installer.downloader.ui.ProxySettingsDialog;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.UiMode;
import org.netbeans.installer.utils.progress.Progress;

public class FileProxy {
    private static final String RESOURCE_SCHEME = "resource";
    public static final String RESOURCE_SCHEME_PREFIX = "resource:";
    private final File tmpDir = new File(DownloadManager.getInstance().getLocalDirectory(), "tmp");
    private final Map<String, File> cache = new HashMap<String, File>();
    public static final FileProxy proxy = new FileProxy();

    public FileProxy() {
        this.tmpDir.mkdirs();
        this.tmpDir.deleteOnExit();
    }

    public static FileProxy getInstance() {
        return proxy;
    }

    public void deleteFile(String uri) throws IOException {
        File file = this.cache.get(uri);
        if (uri != null && uri.startsWith("file")) {
            return;
        }
        if (file != null) {
            FileUtils.deleteFile(file);
        }
        this.cache.remove(uri);
    }

    public void deleteFile(ExtendedUri uri) throws IOException {
        if (uri.getLocal() != null && !uri.getLocal().equals(uri.getRemote()) && !uri.getAlternates().contains(uri.getLocal())) {
            this.deleteFile(uri.getRemote());
            uri.setLocal(null);
        }
    }

    public void deleteFile(URI uri) throws IOException {
        this.deleteFile(uri.toString());
    }

    public void deleteFile(URL url) throws IOException {
        this.deleteFile(url.toString());
    }

    public File getFile(URL url) throws DownloadException {
        return this.getFile(url, null, false);
    }

    public File getFile(String uri) throws DownloadException {
        return this.getFile(uri, null, null);
    }

    public File getFile(String uri, boolean deleteOnExit) throws DownloadException {
        return this.getFile(uri, null, null, deleteOnExit);
    }

    public File getFile(ExtendedUri uri, Progress progress) throws DownloadException {
        return this.getFile(uri.getRemote(), progress, null, false);
    }

    public File getFile(String uri, ClassLoader loader) throws DownloadException {
        return this.getFile(uri, null, loader);
    }

    public File getFile(String uri, ClassLoader loader, boolean deleteOnExit) throws DownloadException {
        return this.getFile(uri, null, loader, deleteOnExit);
    }

    public File getFile(URI uri, Progress progress) throws DownloadException {
        return this.getFile(uri, progress, null, false);
    }

    public File getFile(String uri, Progress progress, ClassLoader loader) throws DownloadException {
        return this.getFile(uri, progress, loader, false);
    }

    public File getFile(String uri, Progress progress, ClassLoader loader, boolean deleteOnExit) throws DownloadException {
        URI myUri;
        try {
            myUri = new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new DownloadException("uri:" + uri, ex);
        }
        return this.getFile(myUri, progress, loader, deleteOnExit);
    }

    public File getFile(URI uri, boolean deleteOnExit) throws DownloadException {
        return this.getFile(uri, null, null, deleteOnExit);
    }

    public File getFile(URI uri) throws DownloadException {
        return this.getFile(uri, null, null, false);
    }

    public File getFile(URI uri, Progress progress, ClassLoader loader, boolean deleteOnExit) throws DownloadException {
        String cacheKey = uri.toString() + (loader != null ? "#" + loader.toString() : "");
        if (this.cache.containsKey(cacheKey) && this.cache.get(cacheKey).exists()) {
            return this.cache.get(cacheKey);
        }
        if (uri.getScheme().equals("file")) {
            File file = new File(uri);
            if (!file.exists()) {
                throw new DownloadException("file not exist: " + uri);
            }
            return file;
        }
        if (uri.getScheme().equals(RESOURCE_SCHEME)) {
            OutputStream out = null;
            try {
                String path = uri.getSchemeSpecificPart();
                File file = new File(this.tmpDir, path.substring(path.lastIndexOf(47)));
                String fileName = file.getName();
                File parent = file.getParentFile();
                int i = 0;
                while (file.exists()) {
                    file = new File(parent, fileName + "." + i);
                    ++i;
                }
                file.createNewFile();
                if (deleteOnExit) {
                    file.deleteOnExit();
                }
                InputStream resource = (loader != null ? loader : this.getClass().getClassLoader()).getResourceAsStream(uri.getSchemeSpecificPart());
                out = new FileOutputStream(file);
                if (resource == null) {
                    throw new DownloadException(RESOURCE_SCHEME_PREFIX + uri.getSchemeSpecificPart() + " not found");
                }
                StreamUtils.transferData(resource, out);
                this.cache.put(cacheKey, file);
                File file2 = file;
                return file2;
            }
            catch (IOException ex) {
                throw new DownloadException("I/O error has occures", ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (uri.getScheme().startsWith("http")) {
            try {
                File file = this.getFile(uri.toURL(), progress, deleteOnExit);
                this.cache.put(cacheKey, file);
                return file;
            }
            catch (MalformedURLException ex) {
                throw new DownloadException("malformed url: " + uri, ex);
            }
        }
        throw new DownloadException("unsupported sheme: " + uri.getScheme());
    }

    protected File getFile(URL url, Progress progress, boolean deleteOnExit) throws DownloadException {
        try {
            DownloadProgress dlProgress = new DownloadProgress(progress, url);
            DownloadManager.instance.registerListener(dlProgress);
            File file = null;
            file = FileProvider.getProvider().get(url);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            return file;
        }
        catch (DownloadException e) {
            if (UiMode.getCurrentUiMode() == UiMode.SWING) {
                new ProxySettingsDialog().execute();
                return this.getFile(url, progress, deleteOnExit);
            }
            throw e;
        }
    }
}

