/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.website;

import ancestris.core.TextOptions;
import ancestris.modules.exports.website.Html;
import ancestris.modules.exports.website.WebSiteExportPlugin;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.option.OptionsWidget;
import genj.report.Report;
import genj.util.Resources;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.io.FileUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportWebsite
extends Report {
    public String reportTitle = this.translate("reportTitleExample");
    public String reportSubTitle = this.translate("reportSubTitleExample");
    public boolean reportNowLiving = false;
    public boolean displaySosaStradonitz = false;
    public boolean reportNotesInFullOnEntity = false;
    public boolean reportDisplayIndividualMap = true;
    public boolean reportLinksToMap = true;
    public String placeDisplayFormat = "all";
    public boolean displayChangeDate = true;
    public boolean displayAncestrisFooter = true;
    public boolean includeGedcomName = false;
    public String secondaryLanguage = "en";
    public int treeType = 0;
    public String[] treeTypes = new String[]{this.translateGUI("treeLTR"), this.translateGUI("treeRTL")};
    public Color cssTextColor = Color.BLACK;
    public Color cssBackgroundColor = Color.WHITE;
    public Color cssLinkColor = new Color(0, 0, 153);
    public Color cssVistedLinkColor = new Color(102, 0, 153);
    public Color cssBorderColor = Color.BLACK;
    public int boxBackground = 0;
    public String[] boxBackgrounds = new String[]{this.translateGUI("green"), this.translateGUI("blue")};
    public boolean removeAllFiles = false;
    public String reportIndexFileName = "index.html";
    public String listPersonFileName = "listing.html";
    public String listSourceFileName = "sources.html";
    public String listRepositoryFileName = "repositories.html";
    public boolean omitXmlDeclaration = false;
    public boolean createAccess = false;
    public String accessPath = "";
    public String accessUsername = "";
    public String accessPasswd = "";
    public int serverType = 0;
    public String[] serverTypes = new String[]{this.translateGUI("server.Apache"), this.translateGUI("server.Free")};
    protected static final String[] cssTreeFile = new String[]{"html/treel2r.css", "html/treer2l.css"};
    protected static final String CSS_BASE_FILE = "html/style.css";
    protected static final String[] boxBackgroundImages = new String[]{"html/bkgr_green.png", "html/bkgr_blue.png"};
    protected List<Indi> personsWithImage = null;
    protected Element sourceDiv = null;
    protected List<Property> addedSourceProperty = null;
    protected int sourceCounter = 0;
    protected Element noteDiv = null;
    protected List<Property> addedNoteProperty = null;
    protected int noteCounter = 0;
    protected StringBuffer mapEventLocations = null;
    protected Locale currentLocale = null;
    protected String currentLang = null;
    protected Locale secondaryLocale = null;
    protected Resources gedcomResources = null;
    protected File destDir = null;
    final String[] addressOtherProperties = new String[]{"PHON", "EMAIL", "FAX", "WWW"};

    public boolean isHidden() {
        return true;
    }

    public void start(Gedcom gedcom) throws Exception {
        if (gedcom == null) {
            return;
        }
        new OptionsWidget("").setOptions(WebSiteExportPlugin.getReport().getOptions());
        this.currentLang = TextOptions.getInstance().getOutputLocale().getLanguage();
        this.gedcomResources = Resources.get(Gedcom.class, (Locale)TextOptions.getInstance().getOutputLocale());
        this.secondaryLocale = null;
        if (this.secondaryLanguage != null && !this.secondaryLanguage.equals("") && !this.secondaryLanguage.equals(this.currentLang)) {
            this.secondaryLocale = new Locale(this.secondaryLanguage);
            if (!this.secondaryLanguage.matches("[a-z]{2}") || this.secondaryLocale == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.translateGUI("invalidLanguage", new Object[]{this.secondaryLanguage}), 0));
                return;
            }
        }
        HashMap<String, String> translator = this.makeCssAndJSSettings();
        this.personsWithImage = new ArrayList<Indi>();
        this.destDir = new FileChooserBuilder(ReportWebsite.class).setTitle(this.translateGUI("qOutputDir")).setApproveText(this.translateGUI("qOk")).setFileHiding(true).setDirectoriesOnly(true).showSaveDialog(false);
        if (this.destDir == null) {
            return;
        }
        this.destDir.mkdirs();
        if (this.destDir.list().length > 0 && !this.getOptionFromUser(this.translateGUI("qOverwrite"), 1)) {
            return;
        }
        this.println(" ");
        this.println("=======================================");
        this.println("               START                   ");
        this.println("Generating pages in primary language...");
        this.println("=======================================");
        this.println(" ");
        if (this.createAccess) {
            this.generateAccess();
        }
        Indi rootIndi = null;
        if (this.displaySosaStradonitz && (rootIndi = gedcom.getDeCujusIndi()) == null) {
            this.println(" ");
            this.println("Sosa numbering has not been generated for this genealogy. Cannot display them.");
            this.displaySosaStradonitz = false;
        }
        if (this.removeAllFiles) {
            this.deleteDirContent(this.destDir, false);
        }
        this.makeCss(this.destDir, translator);
        this.makeJs(this.destDir, translator);
        this.copyImages(this.destDir);
        this.generateFiles(gedcom, rootIndi);
        if (this.secondaryLocale != null) {
            this.println(" ");
            this.println(" ");
            this.println("=========================================");
            this.println("Generating pages in secondary language...");
            this.println("=========================================");
            this.println(" ");
            this.personsWithImage = new ArrayList<Indi>();
            this.currentLocale = this.secondaryLocale;
            this.currentLang = this.secondaryLocale.getLanguage();
            this.gedcomResources = Resources.get(Gedcom.class, (Locale)this.currentLocale);
            translator = this.makeCssAndJSSettings();
            this.makeJs(this.destDir, translator);
            this.generateFiles(gedcom, rootIndi);
            this.currentLocale = null;
        }
        this.println(" ");
        this.println("=======================================");
        this.println("                END                    ");
        this.println("=======================================");
        this.println(" ");
        this.println(" ");
        try {
            String fileStr = "file://" + this.destDir.getAbsolutePath() + File.separator + "index.html";
            this.println("Opening genealogy with browser...(" + fileStr + ").");
            FileAssociation.getDefault().execute(new URL(fileStr));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getPropertyName(String tag) {
        return this.getPropertyName(tag, false);
    }

    public String getPropertyName(String tag, boolean plural) {
        String name;
        if (plural && (name = this.gedcomResources.getString(tag + ".s.name", false)) != null) {
            return name;
        }
        name = this.gedcomResources.getString(tag + ".name", false);
        if (name != null) {
            return name;
        }
        return Gedcom.getName((String)tag, (boolean)plural);
    }

    private void generateAccess() throws IOException {
        File privateDir = new File(this.destDir.getAbsolutePath() + File.separator + "private");
        privateDir.mkdirs();
        File htaccess = new File(this.destDir.getAbsolutePath() + File.separator + ".htaccess");
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htaccess, false), "UTF-8"));){
            out.write("AuthType Basic");
            out.newLine();
            out.write((this.serverType == 1 ? "PerlSetVar AuthFile " : "AuthUserFile ") + this.accessPath + "/private/.htpasswd");
            out.newLine();
            out.write("AuthName \"Private Access\"");
            out.newLine();
            out.write("Require valid-user");
            out.newLine();
        }
        File privateAccess = new File(privateDir.getAbsolutePath() + File.separator + ".htaccess");
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(privateAccess, false), "UTF-8"));){
            out.write("<Files *>");
            out.newLine();
            out.write("Deny from all");
            out.newLine();
            out.write("</Files>");
            out.newLine();
        }
        if (this.accessPasswd != null && !"".equals(this.accessPasswd) && this.accessUsername != null && !"".equals(this.accessUsername)) {
            File passwd = new File(privateDir.getAbsolutePath() + File.separator + ".htpasswd");
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(passwd, false), "UTF-8"));){
                if (this.serverType == 0) {
                    out.write(this.accessUsername + ":" + Md5Crypt.apr1Crypt((String)this.accessPasswd));
                } else {
                    out.write(this.accessUsername + ":" + this.accessPasswd);
                }
                out.newLine();
            }
        }
    }

    protected void generateFiles(Gedcom gedcom, Indi rootIndi) throws Exception {
        Entity[] submitters;
        Entity[] notes;
        Entity[] repos;
        Entity[] sources;
        Indi[] indis;
        Entity[] objects;
        for (Entity object : objects = gedcom.getEntities("OBJE", "")) {
            this.println("Exporting object " + object.getId());
            File objeFile = this.makeDirFor(object.getId());
            this.createMultimediaDoc((Media)object).toFile(objeFile, this.omitXmlDeclaration);
        }
        Collection indiList = gedcom.getIndis();
        for (Indi indi : indis = indiList.toArray(new Indi[indiList.size()])) {
            this.println("Exporting person " + indi.getId() + " " + this.getName(indi));
            File indiFile = this.makeDirFor(indi.getId());
            this.createIndiDoc(indi).toFile(indiFile, this.omitXmlDeclaration);
        }
        for (Entity source : sources = gedcom.getEntities("SOUR", "")) {
            this.println("Exporting source " + source.getId());
            File sourFile = this.makeDirFor(source.getId());
            this.createSourceDoc((Source)source).toFile(sourFile, this.omitXmlDeclaration);
        }
        for (Entity repo : repos = gedcom.getEntities("REPO", "")) {
            this.println("Exporting repository " + repo.getId());
            File repoFile = this.makeDirFor(repo.getId());
            this.createRepoDoc((Repository)repo).toFile(repoFile, this.omitXmlDeclaration);
        }
        for (Entity note : notes = gedcom.getEntities("NOTE", "")) {
            this.println("Exporting note " + note.getId());
            File noteFile = this.makeDirFor(note.getId());
            this.createNoteDoc((Note)note).toFile(noteFile, this.omitXmlDeclaration);
        }
        for (Entity submitter : submitters = gedcom.getEntities("SUBM", "")) {
            this.println("Exporting submitter " + submitter.getId());
            File submFile = this.makeDirFor(submitter.getId());
            this.createSubmitterDoc((Submitter)submitter).toFile(submFile, this.omitXmlDeclaration);
        }
        Collator collator = gedcom.getCollator();
        Arrays.sort(indis, new PropertyComparator("INDI:NAME"));
        Arrays.sort(sources, new PropertyComparator("SOUR:TITL"));
        Arrays.sort(repos, new PropertyComparator("REPO:NAME"));
        this.makeStartpage(gedcom, this.destDir, (Entity[])indis, sources, repos, rootIndi);
        this.makePersonIndex(this.destDir, (Entity[])indis, collator);
        if (sources.length > 0) {
            this.makeEntityIndex(this.destDir, sources, "sourceIndex", this.listSourceFileName, collator, "SOUR:TITL");
        }
        if (repos.length > 0) {
            this.makeEntityIndex(this.destDir, repos, "repositoryIndex", this.listRepositoryFileName, collator, "REPO:NAME");
        }
        this.makeSearchDataPage(this.destDir, indis);
        this.println("Report done!");
    }

    protected void deleteDirContent(File dir, boolean deleteThisDir) {
        for (String name : dir.list()) {
            File curr = new File(dir, name);
            if (curr.isDirectory()) {
                this.deleteDirContent(curr, true);
                continue;
            }
            curr.delete();
        }
    }

    protected void copyImages(File dir) throws IOException {
        File dstFile = new File(dir, "bkgr.png");
        this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream(boxBackgroundImages[this.boxBackground]), dstFile);
        try {
            this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream("html/Indi.png"), new File(dir, "Indi.png"));
            this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream("html/Source.png"), new File(dir, "Source.png"));
            this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream("html/Repository.png"), new File(dir, "Repository.png"));
        }
        catch (IOException e) {
            this.println(" Failed to copy icons. Error:" + e.getMessage());
        }
    }

    protected void makeSearchDataPage(File dir, Indi[] indis) throws IOException {
        this.println("Making search data file");
        File file = new File(dir, "searchData.js");
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));){
            out.write("var searchValues = [");
            boolean first = true;
            for (Indi indi : indis) {
                if (!first) {
                    out.write(",");
                    out.newLine();
                }
                first = false;
                String displayName = indi.getName().replace('\"', ' ');
                String simpleName = displayName.toLowerCase();
                String sosaId = indi.getSosaString();
                String birth = indi.getBirthAsString().replace('\"', ' ');
                String death = indi.getDeathAsString().replace('\"', ' ');
                out.write("[\"" + simpleName + "\",\"" + indi.getId().substring(1) + "\",\"" + displayName + "\",\"" + birth + "\",\"" + death + "\",\"" + sosaId + "\"]");
            }
            out.write("];");
        }
    }

    protected void makeStartpage(Gedcom gedcom, File dir, Entity[] indis, Entity[] sources, Entity[] repos, Indi rootIndi) {
        Submitter subm;
        this.println("Making start-page");
        Collator collator = gedcom.getCollator();
        File startFile = new File(dir.getAbsolutePath() + File.separator + this.getLocalizedFilename(this.reportIndexFileName, this.currentLocale));
        Html html = new Html(this.reportTitle, "", this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(html.h1(this.reportTitle));
        bodyNode.appendChild(html.pNewlines(this.reportSubTitle));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        div1.appendChild(html.h2("Indi.png", this.getPropertyName("INDI", true)));
        div1.appendChild(html.p(this.translateLocal("indexPersonText1", indis.length, gedcom.getEntities("FAM", "").length)));
        if (this.displaySosaStradonitz && rootIndi != null) {
            Element p = html.p(this.translateLocal("indexSosaDescriptionText") + " ");
            p.appendChild(html.link(this.addressTo(rootIndi.getId()), this.getName(rootIndi)));
            div1.appendChild(p);
        }
        div1.appendChild(html.h2(this.translateLocal("personIndex")));
        Element indiP = html.p();
        div1.appendChild(indiP);
        String lastLetter = "";
        for (Entity indi : indis) {
            String name = ((Indi)indi).getName();
            Entity[] lastname = this.normalizeText(((Indi)indi).getLastName());
            String letter = lastname.substring(0, 1);
            if (collator.equals(letter, lastLetter)) continue;
            indiP.appendChild(html.link(this.listPersonFileName + "#" + letter, letter));
            indiP.appendChild(html.text(", "));
            lastLetter = letter;
        }
        html.addJSFile(this.getLocalizedFilename("search.js", this.currentLocale));
        html.addJSFile("searchData.js");
        Element searchForm = html.form(null, "javascript:displayResult();", "return displayResult();");
        Element searchP = html.p(this.getPropertyName("NAME") + " ");
        searchForm.appendChild(searchP);
        searchP.appendChild(html.input("searchName", "name"));
        searchP.appendChild(html.input("word", this.translateLocal("searchCheckBox"), "checkbox"));
        searchP.appendChild(html.button(this.translateLocal("searchButton"), "displayResult();"));
        div1.appendChild(searchForm);
        if (this.displaySosaStradonitz) {
            Element searchSosaForm = html.form(null, "javascript:jumpToSosa();", "return jumpToSosa();");
            Element searchSosaP = html.p(this.translateLocal("sosaNumber") + " ");
            searchSosaForm.appendChild(searchSosaP);
            searchSosaP.appendChild(html.input("searchSosa", "sosa", 5));
            searchSosaP.appendChild(html.button(this.translateLocal("searchButton"), "jumpToSosa();"));
            div1.appendChild(searchSosaForm);
        }
        Element divResult = html.divId("searchResult");
        divResult.appendChild(html.text(" "));
        div1.appendChild(divResult);
        div1.appendChild(html.h2(this.translateLocal("personGallery")));
        for (Indi indi : this.personsWithImage) {
            div1.appendChild(html.link(this.addressTo(indi.getId()), html.img(this.addressToDir(indi.getId()) + "gallery.jpg", this.getName(indi))));
        }
        Element div2 = html.div("left");
        bodyNode.appendChild(div2);
        if (sources.length > 0) {
            div2.appendChild(html.h2("Source.png", this.translateLocal("sourceIndex")));
            Element sourceP = html.p();
            div2.appendChild(sourceP);
            lastLetter = "";
            for (Entity source : sources) {
                Property prop = source.getPropertyByPath("SOUR:TITL");
                String text = this.normalizeText(prop != null ? prop.getValue() : "?");
                String letter = text.substring(0, 1);
                if (collator.equals(letter, lastLetter)) continue;
                sourceP.appendChild(html.link(this.listSourceFileName + "#" + letter, letter));
                sourceP.appendChild(html.text(", "));
                lastLetter = letter;
            }
            bodyNode.appendChild(div2);
        }
        if (repos.length > 0) {
            div2.appendChild(html.h2("Repository.png", this.translateLocal("repositoryIndex")));
            Element repoP = html.p();
            div2.appendChild(repoP);
            lastLetter = "";
            for (Entity repo : repos) {
                String letter = repo.toString().substring(0, 1);
                if (collator.equals(letter, lastLetter)) continue;
                repoP.appendChild(html.link(this.listRepositoryFileName + "#" + letter, letter));
                repoP.appendChild(html.text(", "));
                lastLetter = letter;
            }
            bodyNode.appendChild(div2);
        }
        if ((subm = gedcom.getSubmitter()) != null) {
            div2.appendChild(html.h2(this.translateLocal("dataGatheredBy")));
            Element p = html.p(subm.getName() + ", ");
            div2.appendChild(p);
            this.processAddresses(p, (Property)subm, html, new ArrayList<String>(), false);
        }
        String gedcomName = this.includeGedcomName ? " " + gedcom.getName() : "";
        div2.appendChild(html.p(this.translateLocal("pageCreated") + " " + new PropertyChange().getDisplayValue() + gedcomName));
        Element backlink = this.backlink(this.reportIndexFileName, null, "", html);
        if (backlink.hasChildNodes()) {
            bodyNode.appendChild(backlink);
        }
        this.makeFooter(bodyNode, html);
        html.toFile(startFile, this.omitXmlDeclaration);
    }

    protected void makeEntityIndex(File dir, Entity[] sources, String name, String fileName, Collator collator, String namePath) {
        name = this.translateLocal(name);
        this.println("Making " + name);
        File startFile = new File(dir.getAbsolutePath() + File.separator + this.getLocalizedFilename(fileName, this.currentLocale));
        Html html = new Html(name, "", this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(this.backlink(fileName, null, "", html));
        bodyNode.appendChild(html.h1(name));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        String lastLetter = "";
        for (Entity source : sources) {
            Property prop = source.getPropertyByPath(namePath);
            String text = this.normalizeText(prop != null ? prop.getValue() : "?");
            String letter = text.substring(0, 1);
            if (!collator.equals(letter, lastLetter)) {
                div1.appendChild(html.anchor(letter));
                div1.appendChild(html.h2(letter));
                lastLetter = letter;
            }
            div1.appendChild(html.link(this.addressTo(source.getId()), text));
            div1.appendChild(html.br());
        }
        this.makeFooter(bodyNode, html);
        html.toFile(startFile, this.omitXmlDeclaration);
    }

    protected void makePersonIndex(File dir, Entity[] indis, Collator collator) {
        this.println("Making person index");
        File startFile = new File(dir.getAbsolutePath() + File.separator + this.getLocalizedFilename(this.listPersonFileName, this.currentLocale));
        Html html = new Html(this.translateLocal("personIndex"), "", this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(this.backlink(this.listPersonFileName, null, "", html));
        bodyNode.appendChild(html.h1(this.translateLocal("personIndex")));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        String lastLetter = "";
        for (Entity indi : indis) {
            String name = ((Indi)indi).getName();
            String lastname = this.normalizeText(((Indi)indi).getLastName());
            String letter = lastname.substring(0, 1);
            if (!collator.equals(letter, lastLetter)) {
                div1.appendChild(html.anchor(letter));
                div1.appendChild(html.h2(letter));
                lastLetter = letter;
            }
            String text = this.getName((Indi)indi) + " (";
            if (!this.isPrivate((Indi)indi)) {
                PropertyDate birth = ((Indi)indi).getBirthDate();
                if (birth != null && birth.getStart().isValid()) {
                    text = text + birth.getStart().getYear();
                }
                text = text + " - ";
                PropertyDate death = ((Indi)indi).getDeathDate();
                if (death != null && death.getStart().isValid()) {
                    text = text + death.getStart().getYear();
                }
            } else {
                text = text + this.translateLocal("notPublic");
            }
            text = text + ")";
            div1.appendChild(html.link(this.addressTo(indi.getId()), text));
            div1.appendChild(html.br());
        }
        this.makeFooter(bodyNode, html);
        html.toFile(startFile, this.omitXmlDeclaration);
    }

    private String normalizeText(String text) {
        return text == null || text.isEmpty() ? "?" : text;
    }

    protected File makeDirFor(String id) throws Exception {
        String path = this.addressTo(id);
        String fileSep = File.separator;
        if (fileSep.equals("\\")) {
            fileSep = "\\\\";
        }
        path = path.replaceAll("/", fileSep);
        File indiFile = new File(this.destDir.getAbsolutePath() + File.separator + path);
        File indiDir = indiFile.getParentFile();
        indiDir.mkdirs();
        return indiFile;
    }

    protected String makeDescription(Indi indi, boolean isPrivate) {
        Fam[] spouseFams;
        Fam fam;
        StringBuilder pageDescription = new StringBuilder(indi.getName());
        if (!isPrivate) {
            String death;
            String birth = this.makeDescriptionEvent((PropertyEvent)indi.getProperty("BIRT"));
            if (birth != null) {
                pageDescription.append(", ").append(birth);
            }
            if ((death = this.makeDescriptionEvent((PropertyEvent)indi.getProperty("DEAT"))) != null) {
                pageDescription.append(", ").append(death);
            }
        }
        if ((fam = indi.getFamilyWhereBiologicalChild()) != null) {
            Indi mother;
            pageDescription.append(", ").append(this.translateLocal("parents")).append(":");
            Indi father = fam.getHusband();
            if (father != null) {
                pageDescription.append(' ').append(father.getName());
            }
            if ((mother = fam.getWife()) != null) {
                pageDescription.append(' ').append(mother.getName());
            }
        }
        if ((spouseFams = indi.getFamiliesWhereSpouse()).length > 0) {
            pageDescription.append(", ").append(this.translateLocal("spouses"));
            for (Fam spouseFam : spouseFams) {
                Indi spouse = spouseFam.getOtherSpouse(indi);
                if (spouse == null) continue;
                pageDescription.append(' ').append(spouse.getName());
            }
        }
        return pageDescription.toString();
    }

    protected String makeDescriptionEvent(PropertyEvent event) {
        if (event == null) {
            return null;
        }
        Property date = event.getProperty("DATE");
        Property place = event.getProperty("PLAC");
        if (date == null && place == null) {
            return null;
        }
        if (date == null) {
            return this.getPropertyName(event.getTag()) + ": " + place.getDisplayValue();
        }
        if (place == null) {
            return this.getPropertyName(event.getTag()) + ": " + date.getDisplayValue();
        }
        return this.getPropertyName(event.getTag()) + ": " + date.getDisplayValue() + " " + place.getDisplayValue();
    }

    protected Html createIndiDoc(Indi indi) {
        List famss;
        Element p;
        Property[] names;
        ArrayList<String> handledProperties = new ArrayList<String>();
        this.resetNoteAndSourceList();
        String linkPrefix = this.relativeLinkPrefix(indi.getId());
        boolean isPrivate = this.isPrivate(indi);
        if (!isPrivate) {
            this.mapEventLocations = new StringBuffer();
        }
        Html html = new Html(this.getName(indi), linkPrefix, this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        html.setDescription(this.makeDescription(indi, isPrivate));
        this.addDecendantTree(bodyNode, indi, "", linkPrefix, html);
        for (Property name : names = indi.getProperties("NAME")) {
            Property nick;
            String nickValue;
            String[] h1 = html.h1(this.getName(indi, name));
            bodyNode.appendChild((Node)h1);
            if (!isPrivate) {
                this.processSourceRefs((Element)h1, name, linkPrefix, indi.getId(), html);
                this.processNoteRefs((Element)h1, name, linkPrefix, indi.getId(), html);
            }
            String string = nickValue = (nick = name.getProperty("NICK")) != null ? nick.getDisplayValue() : "";
            if (nick != null && !nickValue.isEmpty()) {
                bodyNode.appendChild(html.p(this.getPropertyName("NICK") + ": " + nickValue));
            }
            String constructedName = this.constructName(name);
            for (String subTag : new String[]{"FONE", "ROMN"}) {
                Property fone = name.getProperty(subTag);
                if (fone == null) continue;
                String type = "";
                Property typeProp = fone.getProperty("TYPE");
                if (typeProp != null) {
                    type = typeProp.getDisplayValue();
                }
                type = type.isEmpty() ? "" : " (" + type + ")";
                Element p2 = html.p(this.getPropertyName(subTag) + " : " + fone.getDisplayValue() + type);
                bodyNode.appendChild(p2);
                Property foneNick = name.getProperty("NICK");
                String constructedFoneName = this.constructName(fone);
                if (constructedFoneName != null) {
                    p2.appendChild(html.text(", " + constructedName));
                }
                if (foneNick != null) {
                    p2.appendChild(html.text(", " + this.getPropertyName("NICK") + " " + foneNick.getDisplayValue()));
                }
                if (!isPrivate) {
                    this.processSourceRefs(p2, fone, linkPrefix, indi.getId(), html);
                    this.processNoteRefs(p2, fone, linkPrefix, indi.getId(), html);
                }
                this.reportUnhandledProperties(fone, new String[]{"TYPE", "SOUR", "NOTE", "NICK", "NPFX", "GIVN", "SPFX", "SURN", "NSFX"});
            }
            this.reportUnhandledProperties(name, new String[]{"SOUR", "NOTE", "NICK", "NPFX", "GIVN", "SPFX", "SURN", "NSFX"});
        }
        if (names == null) {
            bodyNode.appendChild(html.h1("(" + this.translateLocal("unknown") + ")"));
        }
        handledProperties.add("NAME");
        Element div1 = null;
        if (!isPrivate) {
            div1 = html.div("left");
            bodyNode.appendChild(div1);
            div1.appendChild(html.h2(this.translateLocal("facts")));
            Property sex = indi.getProperty("SEX");
            if (sex != null) {
                div1.appendChild(html.p(this.getPropertyName("SEX") + ": " + PropertySex.getLabelForSex((int)indi.getSex())));
                this.reportUnhandledProperties(sex, null);
            }
            handledProperties.add("SEX");
            Element birth = this.processEventDetail((Property)((PropertyEvent)indi.getProperty("BIRT")), linkPrefix, indi.getId(), html, true);
            if (birth != null) {
                div1.appendChild(birth);
            }
            handledProperties.add("BIRT");
            Element death = this.processEventDetail((Property)((PropertyEvent)indi.getProperty("DEAT")), linkPrefix, indi.getId(), html, true);
            if (death != null) {
                div1.appendChild(death);
            }
            handledProperties.add("DEAT");
            for (String tag : new String[]{"CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "RESI", "SSN", "TITL", "FACT", "ADOP", "CHR", "CREM", "BURI", "BAPM", "BARM", "BASM", "BLES", "CHRA", "CONF", "FCOM", "ORDN", "NATU", "EMIG", "IMMI", "CENS", "PROB", "WILL", "GRAD", "RETI", "EVEN"}) {
                this.processOtherEventTag(tag, (Property)indi, linkPrefix, indi.getId(), div1, html);
                handledProperties.add(tag);
            }
            for (String tag : new String[]{"SUBM", "ALIA", "ANCI", "DESI"}) {
                Property[] refs = indi.getProperties(tag);
                if (refs.length > 0) {
                    div1.appendChild(html.h2(this.getPropertyName(tag)));
                    Element p3 = html.p();
                    for (Property ref : refs) {
                        if (ref instanceof PropertyXRef) {
                            this.getReferenceLink((PropertyXRef)ref, p3, linkPrefix, html, false);
                            if (p3.hasChildNodes()) {
                                div1.appendChild(p3);
                            }
                            this.reportUnhandledProperties(ref, null);
                            continue;
                        }
                        this.println(tag + " is not reference:" + ref.toString());
                    }
                }
                handledProperties.add(tag);
            }
            Property[] refs = indi.getProperties("ASSO");
            if (refs.length > 0) {
                div1.appendChild(html.h2(this.getPropertyName("ASSO")));
                for (Property ref : refs) {
                    if (ref instanceof PropertyXRef) {
                        Property relation = ref.getProperty("RELA");
                        if (relation == null) continue;
                        Element p4 = html.p(relation.getDisplayValue() + ": ");
                        this.getReferenceLink((PropertyXRef)ref, p4, linkPrefix, html, false);
                        if (p4.hasChildNodes()) {
                            div1.appendChild(p4);
                        }
                        this.processNoteRefs(p4, ref, linkPrefix, indi.getId(), html);
                        this.processSourceRefs(p4, ref, linkPrefix, indi.getId(), html);
                        this.reportUnhandledProperties(ref, new String[]{"RELA", "NOTE", "SOUR"});
                        continue;
                    }
                    this.println("ASSO is not reference:" + ref.toString());
                }
                handledProperties.add("ASSO");
            }
            if ((p = this.processMultimediaLink((Property)indi, linkPrefix, indi.getId(), html, false, true)) != null) {
                div1.appendChild(p);
            }
            handledProperties.add("OBJE");
            this.processSimpleTag((Property)indi, "RESN", div1, html, handledProperties);
        }
        Element div2 = html.div("right");
        bodyNode.appendChild(div2);
        div2.appendChild(html.h2(this.translateLocal("parents")));
        List famRefs = indi.getProperties(PropertyFamilyChild.class);
        if (famRefs.isEmpty()) {
            div2.appendChild(html.p(this.translateLocal("unknown")));
        } else {
            for (Object famRef : famRefs) {
                Property status;
                Property pedi;
                p = html.p();
                div2.appendChild(p);
                Boolean bio = famRef.isBiological();
                if (bio != null && !bio.booleanValue() && (pedi = famRef.getProperty("PEDI")) != null) {
                    p.appendChild(html.text(pedi.getValue() + ": "));
                    p.appendChild(html.br());
                }
                if ((status = famRef.getProperty("STAT")) != null) {
                    p.appendChild(html.text(this.getPropertyName("STAT") + ": " + status.getDisplayValue()));
                    p.appendChild(html.br());
                }
                this.getReferenceLink((PropertyXRef)famRef, p, linkPrefix, html, true);
                this.processNoteRefs(p, (Property)famRef, linkPrefix, indi.getId(), html);
                this.reportUnhandledProperties((Property)famRef, new String[]{"PEDI", "NOTE"});
            }
        }
        handledProperties.add("FAMC");
        if (!isPrivate) {
            // empty if block
        }
        if (!(famss = indi.getProperties(PropertyFamilySpouse.class)).isEmpty()) {
            for (PropertyFamilySpouse pfs : famss) {
                Indi[] children;
                Element h2 = html.h2(this.getPropertyName("FAM") + " - ");
                div2.appendChild(h2);
                Fam fam = pfs.getFamily();
                if (fam == null) {
                    this.println(" Reference to invalid family: " + pfs.getValue());
                    continue;
                }
                Indi spouse = fam.getOtherSpouse(indi);
                if (spouse != null) {
                    h2.appendChild(html.link(linkPrefix + this.addressTo(spouse.getId()), this.getName(spouse)));
                } else {
                    h2.appendChild(html.text(this.translateLocal("unknown")));
                }
                this.processNoteRefs(h2, (Property)pfs, linkPrefix, fam.getId(), html);
                ArrayList<String> handledFamProperties = new ArrayList<String>();
                handledFamProperties.add("HUSB");
                handledFamProperties.add("WIFE");
                if (!isPrivate) {
                    for (String tag : new String[]{"ENGA", "MARR", "MARB", "MARC", "MARL", "MARS", "EVEN", "ANUL", "CENS", "DIV", "DIVF"}) {
                        for (Property event : fam.getProperties(tag)) {
                            div2.appendChild(this.processEventDetail(event, linkPrefix, fam.getId(), html, true));
                        }
                        handledFamProperties.add(tag);
                    }
                    for (String tag : new String[]{"NCHI", "RESN"}) {
                        Property singleTag = fam.getProperty(tag);
                        if (singleTag != null) {
                            div2.appendChild(html.text(this.getPropertyName(tag) + ": " + singleTag.getDisplayValue()));
                        }
                        handledFamProperties.add(tag);
                    }
                    Element images = this.processMultimediaLink((Property)fam, linkPrefix, fam.getId(), html, true, false);
                    if (images != null) {
                        div2.appendChild(images);
                    }
                    handledFamProperties.add("OBJE");
                    handledFamProperties.add("CHIL");
                    for (String tag : new String[]{"SUBM"}) {
                        Property[] refs = indi.getProperties(tag);
                        if (refs.length > 0) {
                            div2.appendChild(html.h2(this.getPropertyName(tag)));
                            Element p5 = html.p();
                            for (Property ref : refs) {
                                if (ref instanceof PropertyXRef) {
                                    this.getReferenceLink((PropertyXRef)ref, p5, linkPrefix, html, false);
                                    if (p5.hasChildNodes()) {
                                        div2.appendChild(p5);
                                    }
                                    this.reportUnhandledProperties(ref, null);
                                    continue;
                                }
                                this.println(tag + " is not reference:" + ref.toString());
                            }
                        }
                        handledFamProperties.add(tag);
                    }
                }
                if ((children = fam.getChildren(true)).length > 0) {
                    div2.appendChild(html.p(this.getPropertyName("CHIL", true) + ":"));
                    Element childrenList = doc.createElement("ul");
                    for (Indi child : children) {
                        Element childEl = doc.createElement("li");
                        childEl.appendChild(html.link(linkPrefix + this.addressTo(child.getId()), this.getName(child)));
                        childrenList.appendChild(childEl);
                    }
                    div2.appendChild(childrenList);
                }
                this.reportUnhandledProperties((Property)pfs, null);
                if (isPrivate) continue;
                this.processNumberNoteSourceChangeRest((Property)fam, linkPrefix, div2, fam.getId(), html, handledFamProperties, false);
            }
        }
        handledProperties.add("FAMS");
        if (!isPrivate) {
            this.processNumberNoteSourceChangeRest((Property)indi, linkPrefix, div1, indi.getId(), html, handledProperties, true);
            if (this.reportDisplayIndividualMap && this.mapEventLocations != null && this.mapEventLocations.length() > 0) {
                String url = "http://maps.google.com/maps/api/staticmap?size=200x200&maptype=roadmap&sensor=false&markers=";
                div1.appendChild(html.img(url + this.mapEventLocations.toString(), ""));
            }
        }
        this.mapEventLocations = null;
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, this.listPersonFileName, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    protected String constructName(Property nameProp) {
        StringBuilder sb = new StringBuilder();
        for (String tag : new String[]{"NPFX", "GIVN", "SPFX", "SURN", "NSFX"}) {
            for (Property subProp : nameProp.getProperties(tag)) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(subProp.getDisplayValue());
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    protected Html createSourceDoc(Source source) {
        ArrayList<String> handledProperties = new ArrayList<String>();
        this.resetNoteAndSourceList();
        String linkPrefix = this.relativeLinkPrefix(source.getId());
        Html html = new Html(this.getPropertyName("SOUR") + " " + source.getId() + ": " + source.getTitle(), linkPrefix, this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(html.h1(source.getTitle()));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        handledProperties.add("TITL");
        this.processSimpleTags((Property)source, new String[]{"TEXT", "AUTH", "ABBR", "PUBL"}, div1, html, handledProperties);
        for (Property[] repo : source.getProperties(PropertyRepository.class)) {
            div1.appendChild(html.h2(this.getPropertyName("REPO")));
            Element p = html.p();
            div1.appendChild(p);
            Repository ent = (Repository)repo.getTargetEntity();
            p.appendChild(html.link(linkPrefix + this.addressTo(ent.getId()), ent.toString()));
            for (Property caln : repo.getProperties("CALN")) {
                p.appendChild(html.text(", " + caln.getDisplayValue()));
                Property medi = caln.getProperty("MEDI");
                if (medi != null) {
                    p.appendChild(html.text(medi.getDisplayValue()));
                }
                this.reportUnhandledProperties(caln, new String[]{"MEDI"});
            }
            this.processNoteRefs(div1, (Property)repo, linkPrefix, source.getId(), html);
            this.reportUnhandledProperties((Property)repo, new String[]{"NOTE", "CALN"});
        }
        handledProperties.add("REPO");
        Property data = source.getProperty("DATA");
        if (data != null) {
            div1.appendChild(html.h2(this.getPropertyName("DATA")));
            for (Property event : data.getProperties("EVEN")) {
                Property placeProp;
                Element place;
                Element p = html.p(this.getPropertyName("EVEN") + ": ");
                for (String eventType : event.getValue().split(",")) {
                    p.appendChild(html.text(this.getPropertyName(eventType.trim()) + " "));
                }
                Property date = event.getProperty("DATE");
                if (date != null) {
                    p.appendChild(html.text(date.getDisplayValue() + " "));
                }
                if ((place = this.processPlace(placeProp = event.getProperty("PLAC"), linkPrefix, source.getId(), html)) != null) {
                    p.appendChild(place);
                }
                this.reportUnhandledProperties(event, new String[]{"DATE", "PLAC"});
            }
            Property agency = data.getProperty("AGNC");
            if (agency != null) {
                div1.appendChild(html.p(this.getPropertyName("AGNC") + ": " + agency.getDisplayValue()));
            }
            this.processNoteRefs(div1, data, linkPrefix, source.getId(), html);
            this.reportUnhandledProperties(data, new String[]{"EVEN", "AGNC", "NOTE"});
        }
        handledProperties.add("DATA");
        Element images = this.processMultimediaLink((Property)source, linkPrefix, source.getId(), html, false, false);
        if (images != null) {
            div1.appendChild(html.h2(this.translateLocal("images")));
            div1.appendChild(images);
        }
        handledProperties.add("OBJE");
        Element div2 = html.div("right");
        bodyNode.appendChild(div2);
        this.processReferences((Property)source, linkPrefix, div2, html, handledProperties);
        this.processNumberNoteSourceChangeRest((Property)source, linkPrefix, div1, source.getId(), html, handledProperties, true);
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, this.listSourceFileName, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    protected Html createRepoDoc(Repository repo) {
        ArrayList<String> handledProperties = new ArrayList<String>();
        String linkPrefix = this.relativeLinkPrefix(repo.getId());
        this.resetNoteAndSourceList();
        Html html = new Html(this.getPropertyName("REPO") + " " + repo.getId() + ": " + repo.toString(), linkPrefix, this.currentLang);
        Element bodyNode = html.getBody();
        bodyNode.appendChild(html.h1(repo.toString()));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        handledProperties.add("NAME");
        this.processAddresses(div1, (Property)repo, html, handledProperties, true);
        Element div2 = html.div("right");
        this.processReferences((Property)repo, linkPrefix, div2, html, handledProperties);
        if (div2.hasChildNodes()) {
            bodyNode.appendChild(div2);
        }
        this.processNumberNoteSourceChangeRest((Property)repo, linkPrefix, div1, repo.getId(), html, handledProperties, true);
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, this.listRepositoryFileName, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    protected Html createMultimediaDoc(Media object) {
        ArrayList<String> handledProperties = new ArrayList<String>();
        String linkPrefix = this.relativeLinkPrefix(object.getId());
        this.resetNoteAndSourceList();
        Html html = new Html(this.getPropertyName("OBJE") + " " + object.getId() + ": " + object.toString(), linkPrefix, this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        String h1str = object.getTitle();
        if (h1str.isEmpty()) {
            h1str = "?";
        }
        h1str = object.getId() + " - " + h1str;
        bodyNode.appendChild(html.h1(h1str));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        this.processSimpleTag((Property)object, "TITL", div1, html, handledProperties);
        this.processSimpleTag((Property)object, "FORM", div1, html, handledProperties);
        File objectDir = new File(this.destDir, this.addressToDir(object.getId()));
        Element p = html.p();
        for (PropertyFile file : object.getProperties(PropertyFile.class)) {
            block22: {
                String title = "?";
                Property titleProp = file.getProperty("TITL");
                if (titleProp != null) {
                    title = titleProp.getDisplayValue();
                    if (title == null || title.isEmpty()) {
                        title = "?";
                    }
                    this.reportUnhandledProperties(titleProp, null);
                }
                boolean tryMakeThumb = true;
                boolean thumbMade = false;
                Property formProp = file.getProperty("FORM");
                if (formProp != null) {
                    Property type;
                    if (!formProp.getValue().matches("^jpe?g|gif|JPE?G|gif|PNG|png$")) {
                        tryMakeThumb = false;
                    }
                    if ((type = formProp.getProperty("TYPE")) != null) {
                        this.reportUnhandledProperties(type, null);
                    }
                    this.reportUnhandledProperties(formProp, new String[]{"TYPE"});
                }
                int imgSize = 100;
                File srcFile = this.getSrcFile(file, true);
                if (srcFile != null) {
                    File dstFile = new File(objectDir, srcFile.getName());
                    File thumbFile = new File(dstFile.getParentFile(), "thumb_" + dstFile.getName());
                    try {
                        if (!dstFile.exists() || srcFile.lastModified() > dstFile.lastModified()) {
                            this.copyFile(srcFile, dstFile);
                        }
                        if (tryMakeThumb) {
                            if (!thumbFile.exists() || srcFile.lastModified() > thumbFile.lastModified()) {
                                try {
                                    this.makeThumb(dstFile, imgSize, imgSize, thumbFile);
                                    thumbMade = true;
                                }
                                catch (IOException e) {
                                    this.println("Failed maiking thumb of:" + dstFile.getPath() + " Error:" + e.getMessage());
                                }
                            } else {
                                thumbMade = true;
                            }
                        }
                        if (thumbMade) {
                            p.appendChild(html.link(dstFile.getName(), html.img(thumbFile.getName(), title)));
                            break block22;
                        }
                        p.appendChild(html.link(dstFile.getName(), title));
                    }
                    catch (IOException e) {
                        this.println(" Error in copying file or making thumb: " + srcFile.getName() + e.getMessage());
                    }
                } else if (file.isIsRemote()) {
                    p.appendChild(html.link(((InputSource)file.getInput().get()).getLocation(), title));
                } else {
                    this.println(" FILE ref but no file was found");
                }
            }
            this.reportUnhandledProperties((Property)file, new String[]{"TITL", "FORM"});
        }
        if (p.hasChildNodes()) {
            div1.appendChild(p);
        }
        handledProperties.add("FILE");
        Element div2 = html.div("right");
        this.processReferences((Property)object, linkPrefix, div2, html, handledProperties);
        if (div2.hasChildNodes()) {
            bodyNode.appendChild(div2);
        }
        this.processNumberNoteSourceChangeRest((Property)object, linkPrefix, div1, object.getId(), html, handledProperties, true);
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, null, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    private File getSrcFile(PropertyFile file, boolean copy) {
        Optional ois = file.getInput();
        if (!ois.isPresent()) {
            return null;
        }
        InputSource is = (InputSource)ois.get();
        if ("web".equals(is.getExtension())) {
            return null;
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir") + File.separator + this.getCleanFileName(file.getValue(), "-"));
        if (copy) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)is.open(), (File)tempFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return tempFile;
    }

    private String getCleanFileName(String input, String defchar) {
        String str = input.substring(Math.max(0, input.lastIndexOf(":") + 1));
        while (str.startsWith("\\")) {
            str = str.substring(1);
        }
        while (str.startsWith("/")) {
            str = str.substring(1);
        }
        String temp = str.replaceAll("\\s", "_");
        int i = temp.indexOf(63);
        if (i > 0) {
            temp = temp.substring(0, i);
        }
        String cleanName = this.fileNameConvert(temp, defchar);
        return cleanName;
    }

    private String fileNameConvert(String filename, String defchar) {
        if (filename == null) {
            return "null";
        }
        String text = filename.toLowerCase();
        char[] charInput = text.toCharArray();
        StringBuilder strOutput = new StringBuilder(1000);
        for (int i = 0; i < charInput.length; ++i) {
            strOutput.append(this.convertChar(charInput[i], false, defchar));
        }
        return strOutput.toString();
    }

    public String convertChar(char c, boolean isAnchor, String defchar) {
        String str;
        switch (c) {
            case '\u00e0': {
                str = "a";
                break;
            }
            case '\u00e1': {
                str = "a";
                break;
            }
            case '\u00e2': {
                str = "a";
                break;
            }
            case '\u00e3': {
                str = "a";
                break;
            }
            case '\u00e4': {
                str = "a";
                break;
            }
            case '\u00e5': {
                str = "a";
                break;
            }
            case '\u00e6': {
                str = "ae";
                break;
            }
            case '\u00e7': {
                str = "c";
                break;
            }
            case '\u00e8': {
                str = "e";
                break;
            }
            case '\u00e9': {
                str = "e";
                break;
            }
            case '\u00ea': {
                str = "e";
                break;
            }
            case '\u00eb': {
                str = "e";
                break;
            }
            case '\u00ec': {
                str = "i";
                break;
            }
            case '\u00ed': {
                str = "i";
                break;
            }
            case '\u00ee': {
                str = "i";
                break;
            }
            case '\u00ef': {
                str = "i";
                break;
            }
            case '\u00f0': {
                str = "o";
                break;
            }
            case '\u00f1': {
                str = "n";
                break;
            }
            case '\u00f2': {
                str = "o";
                break;
            }
            case '\u00f3': {
                str = "o";
                break;
            }
            case '\u00f4': {
                str = "o";
                break;
            }
            case '\u00f5': {
                str = "o";
                break;
            }
            case '\u00f6': {
                str = "o";
                break;
            }
            case '\u00f8': {
                str = "o";
                break;
            }
            case '\u00f9': {
                str = "u";
                break;
            }
            case '\u00fa': {
                str = "u";
                break;
            }
            case '\u00fb': {
                str = "u";
                break;
            }
            case '\u00fc': {
                str = "u";
                break;
            }
            case '\u00fd': {
                str = "y";
                break;
            }
            case '\u00fe': {
                str = "p";
                break;
            }
            case '\u00ff': {
                str = "y";
                break;
            }
            case '\u00df': {
                str = "ss";
                break;
            }
            default: {
                String str2 = String.valueOf(c);
                if (str2.matches("[a-zA-Z0-9]")) {
                    return str2;
                }
                if (str2.compareTo(".") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("/") == 0) {
                    return isAnchor ? defchar : str2;
                }
                if (str2.compareTo("\\") == 0) {
                    return isAnchor ? defchar : str2;
                }
                return defchar;
            }
        }
        return str;
    }

    protected Html createNoteDoc(Note note) {
        ArrayList<String> handledProperties = new ArrayList<String>();
        String linkPrefix = this.relativeLinkPrefix(note.getId());
        this.resetNoteAndSourceList();
        Html html = new Html(this.getPropertyName("NOTE") + " " + note.getId() + ": " + note.toString(), linkPrefix, this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(html.h1(this.getPropertyName("NOTE") + note.getId() + ": " + note.toString()));
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        this.appendDisplayValue(div1, (Property)note, false, html);
        Element div2 = html.div("right");
        this.processReferences((Property)note, linkPrefix, div2, html, handledProperties);
        if (div2.hasChildNodes()) {
            bodyNode.appendChild(div2);
        }
        this.processNumberNoteSourceChangeRest((Property)note, linkPrefix, div1, note.getId(), html, handledProperties, true);
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, null, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    protected Html createSubmitterDoc(Submitter submitter) {
        ArrayList<String> handledProperties = new ArrayList<String>();
        String linkPrefix = this.relativeLinkPrefix(submitter.getId());
        this.resetNoteAndSourceList();
        Html html = new Html(this.getPropertyName("SUBM") + " " + submitter.getId() + ": " + submitter.getName(), linkPrefix, this.currentLang);
        Document doc = html.getDoc();
        Element bodyNode = html.getBody();
        bodyNode.appendChild(html.h1(submitter.getName()));
        handledProperties.add("NAME");
        Element div1 = html.div("left");
        bodyNode.appendChild(div1);
        this.processAddresses(div1, (Property)submitter, html, handledProperties, true);
        this.processSimpleTag((Property)submitter, "LANG", div1, html, handledProperties);
        Element images = this.processMultimediaLink((Property)submitter, linkPrefix, submitter.getId(), html, true, false);
        if (images != null) {
            div1.appendChild(images);
        }
        handledProperties.add("OBJE");
        Element div2 = html.div("right");
        this.processReferences((Property)submitter, linkPrefix, div2, html, handledProperties);
        if (div2.hasChildNodes()) {
            bodyNode.appendChild(div2);
        }
        this.processNumberNoteSourceChangeRest((Property)submitter, linkPrefix, div1, submitter.getId(), html, handledProperties, true);
        this.addNoteAndSourceList(bodyNode);
        bodyNode.appendChild(this.backlink(this.reportIndexFileName, null, linkPrefix, html));
        this.makeFooter(bodyNode, html);
        return html;
    }

    protected Element backlink(String currentFileName, String indexFileName, String linkPrefix, Html html) {
        Element divlink = html.div("backlink");
        if (!linkPrefix.equals("") || !currentFileName.equals(this.reportIndexFileName)) {
            divlink.appendChild(html.link(linkPrefix + this.getLocalizedFilename(this.reportIndexFileName, this.currentLocale), this.translateLocal("startPage")));
        }
        if (indexFileName != null) {
            divlink.appendChild(html.text(" "));
            divlink.appendChild(html.link(linkPrefix + this.getLocalizedFilename(indexFileName, this.currentLocale), this.translateLocal("indexPage")));
        }
        if (this.secondaryLocale != null) {
            divlink.appendChild(html.br());
            Locale linkToLocale = null;
            String nameOfLang = TextOptions.getInstance().getOutputLocale().getDisplayLanguage(TextOptions.getInstance().getOutputLocale());
            if (this.currentLocale == null) {
                linkToLocale = this.secondaryLocale;
                nameOfLang = this.secondaryLocale.getDisplayLanguage(this.secondaryLocale);
            }
            divlink.appendChild(html.link(this.getLocalizedFilename(currentFileName, linkToLocale), nameOfLang));
        }
        return divlink;
    }

    protected void makeFooter(Element appendTo, Html html) {
        if (this.displayAncestrisFooter) {
            Element divFooter = html.div("footer");
            appendTo.appendChild(divFooter);
            Element p = html.p(this.translateLocal("footerText") + " ");
            p.appendChild(html.link("https://www.ancestris.org", "Ancestris"));
            divFooter.appendChild(p);
        }
    }

    protected String getName(Indi indi) {
        return indi.getName() + " (" + indi.getSosaString() + ")";
    }

    protected String getLimitedName(Indi indi) {
        String name = this.getName(indi);
        return name.substring(0, Math.min(50, name.length()));
    }

    protected String getName(Indi indi, Property nameProp) {
        return nameProp.getDisplayValue() + " (" + indi.getSosaString() + ")";
    }

    protected boolean isPrivate(Indi indi) {
        if (this.reportNowLiving) {
            return false;
        }
        if (indi.isDeceased()) {
            return false;
        }
        return !this.bornBeforeDate(indi);
    }

    protected boolean bornBeforeDate(Indi indi) {
        if (indi.getBirthDate() != null && indi.getBirthDate().isComparable()) {
            return indi.getBirthDate().compareTo((Property)new PropertyDate(1900)) < 0;
        }
        for (Indi child : indi.getChildren()) {
            if (!this.bornBeforeDate(child)) continue;
            return true;
        }
        return false;
    }

    protected void processReferences(Property ent, String linkPrefix, Element appendTo, Html html, List<String> handledProperties) {
        List refs = ent.getProperties(PropertyXRef.class);
        PropertyXRef head = null;
        for (PropertyXRef ref : refs) {
            Entity e = ref.getTargetEntity();
            if (e == null || !"HEAD".equals(e.getTag())) continue;
            head = ref;
            break;
        }
        if (head != null) {
            refs.remove(head);
        }
        if (refs.size() > 0) {
            appendTo.appendChild(html.h2(this.translateLocal("references")));
            Element p = html.p();
            appendTo.appendChild(p);
            for (PropertyXRef ref : refs) {
                this.getReferenceLink(ref, p, linkPrefix, html, true);
            }
        }
        handledProperties.add("XREF");
    }

    protected void getReferenceLink(PropertyXRef ref, Element appendTo, String linkPrefix, Html html, boolean addNewline) {
        if (ref.isValid()) {
            Entity refEnt = ref.getTargetEntity();
            if (refEnt instanceof Indi) {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(refEnt.getId()), this.getName((Indi)refEnt)));
                if (addNewline) {
                    appendTo.appendChild(html.br());
                }
            } else if (refEnt instanceof Fam) {
                Indi husb = ((Fam)refEnt).getHusband();
                Indi wife = ((Fam)refEnt).getWife();
                if (husb != null) {
                    appendTo.appendChild(html.link(linkPrefix + this.addressTo(husb.getId()), this.getName(husb)));
                    if (addNewline || wife != null) {
                        appendTo.appendChild(html.br());
                    }
                }
                if (wife != null) {
                    appendTo.appendChild(html.link(linkPrefix + this.addressTo(wife.getId()), this.getName(wife)));
                    if (addNewline) {
                        appendTo.appendChild(html.br());
                    }
                }
            } else {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(refEnt.getId()), refEnt.toString()));
                if (addNewline) {
                    appendTo.appendChild(html.br());
                }
            }
        }
    }

    protected Element processMultimediaLink(Property prop, String linkPrefix, String id, Html html, boolean smallThumbs, boolean makeGalleryImage) {
        Property[] objects;
        File currentObjectDir = new File(this.destDir, this.addressToDir(id));
        if (!currentObjectDir.exists()) {
            currentObjectDir.mkdirs();
        }
        if ((objects = prop.getProperties("OBJE")).length == 0) {
            return null;
        }
        Element p = html.p();
        int imgSize = 200;
        if (smallThumbs) {
            imgSize = 100;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof PropertyMedia) {
                Media media = (Media)((PropertyMedia)objects[i]).getTargetEntity();
                if (media != null) {
                    for (PropertyFile pFile : media.getProperties(PropertyFile.class)) {
                        Element mediaBox;
                        File mFile = this.getSrcFile(pFile, true);
                        if (mFile != null) {
                            mediaBox = html.span("imageBox");
                            p.appendChild(mediaBox);
                            File mediaDir = new File(this.destDir, this.addressToDir(media.getId()));
                            File thumbFile = new File(mediaDir, "thumb_" + mFile.getName());
                            if (thumbFile.exists()) {
                                mediaBox.appendChild(html.link(linkPrefix + this.addressToDir(media.getId()) + mFile.getName(), html.img(linkPrefix + this.addressToDir(media.getId()) + "thumb_" + mFile.getName(), media.getTitle())));
                                if (makeGalleryImage) {
                                    File galleryImage = new File(currentObjectDir, "gallery.jpg");
                                    try {
                                        if (!galleryImage.exists() || mFile.lastModified() > galleryImage.lastModified()) {
                                            this.makeThumb(mFile, 50, 70, galleryImage);
                                        }
                                        makeGalleryImage = false;
                                        if (prop instanceof Indi) {
                                            this.personsWithImage.add((Indi)prop);
                                        }
                                    }
                                    catch (IOException e) {
                                        this.println("Making gallery thumb of image failed: " + mFile.getAbsolutePath() + " Error: " + e.getMessage());
                                    }
                                }
                            } else {
                                String str = media.getTitle();
                                if (str == null || str.isEmpty()) {
                                    str = FileChooserBuilder.getExtension((String)mFile.getName());
                                }
                                mediaBox.appendChild(html.link(linkPrefix + this.addressToDir(media.getId()) + mFile.getName(), str));
                            }
                            this.processNoteRefs(mediaBox, (Property)media, linkPrefix, id, html);
                            this.processSourceRefs(mediaBox, (Property)media, linkPrefix, id, html);
                            mediaBox.appendChild(html.br());
                            mediaBox.appendChild(html.link(linkPrefix + this.addressTo(media.getId()), this.translateLocal("aboutMedia")));
                        } else if (pFile.isIsRemote()) {
                            mediaBox = html.span("imageBox");
                            p.appendChild(mediaBox);
                            String str = media.getTitle();
                            if (str == null || str.isEmpty()) {
                                str = ((InputSource)pFile.getInput().get()).getExtension();
                            }
                            mediaBox.appendChild(html.link(linkPrefix + this.addressToDir(media.getId()) + "index.html", str));
                        } else {
                            this.println(" Media reference to media without file.");
                        }
                        this.reportUnhandledProperties(objects[i], null);
                    }
                    continue;
                }
                this.println(" Invalid media reference to non existing object:" + objects[i].getValue());
                continue;
            }
            Property titleProp = objects[i].getProperty("TITL");
            String title = null;
            if (titleProp != null) {
                title = titleProp.getValue();
            }
            boolean tryMakeThumb = true;
            boolean thumbExist = false;
            Property formProp = objects[i].getProperty("FORM");
            if (formProp != null) {
                if (!formProp.getValue().matches("^jpe?g|gif|JPE?G|gif|PNG|png$")) {
                    tryMakeThumb = false;
                }
                this.reportUnhandledProperties(formProp, null);
            }
            for (PropertyFile file : objects[i].getProperties(PropertyFile.class)) {
                if (file != null && file.getInput().isPresent()) {
                    formProp = file.getProperty("FORM");
                    if (formProp != null) {
                        if (!formProp.getValue().matches("^jpe?g|gif|JPE?G|gif|PNG|png$")) {
                            tryMakeThumb = false;
                        }
                        this.reportUnhandledProperties(formProp, null);
                    }
                    this.reportUnhandledProperties((Property)file, new String[]{"FORM"});
                    File srcFile = this.getSrcFile(file, true);
                    if (srcFile != null) {
                        File dstFile = new File(currentObjectDir, srcFile.getName());
                        File thumbFile = new File(dstFile.getParentFile(), "thumb_" + dstFile.getName());
                        try {
                            if (!dstFile.exists() || srcFile.lastModified() > dstFile.lastModified()) {
                                this.copyFile(srcFile, dstFile);
                            }
                            if (tryMakeThumb) {
                                if (!thumbFile.exists() || srcFile.lastModified() > thumbFile.lastModified()) {
                                    try {
                                        this.makeThumb(dstFile, imgSize, imgSize, thumbFile);
                                        thumbExist = true;
                                    }
                                    catch (IOException e) {
                                        this.println("Making thumb of image failed: " + dstFile.getAbsolutePath() + " Error: " + e.getMessage());
                                    }
                                } else {
                                    thumbExist = true;
                                }
                            }
                            if (makeGalleryImage && tryMakeThumb) {
                                File galleryImage = new File(dstFile.getParentFile(), "gallery.jpg");
                                try {
                                    if (!galleryImage.exists() || srcFile.lastModified() > galleryImage.lastModified()) {
                                        this.makeThumb(dstFile, 50, 70, galleryImage);
                                    }
                                    makeGalleryImage = false;
                                    if (prop instanceof Indi) {
                                        this.personsWithImage.add((Indi)prop);
                                    }
                                }
                                catch (Exception e) {
                                    this.println("Making gallery thumb of image failed: " + dstFile.getAbsolutePath() + " Error: " + e.getMessage());
                                }
                            }
                            if (thumbExist) {
                                p.appendChild(html.link(linkPrefix + this.addressToDir(id) + dstFile.getName(), html.img(linkPrefix + this.addressToDir(id) + thumbFile.getName(), title)));
                            } else {
                                p.appendChild(html.link(linkPrefix + this.addressToDir(id) + dstFile.getName(), title));
                            }
                        }
                        catch (IOException e) {
                            this.println(" Error while copying file: " + srcFile.getName() + " Error: " + e.getMessage());
                        }
                        this.processNoteRefs(p, objects[i], linkPrefix, id, html);
                        this.reportUnhandledProperties(objects[i], new String[]{"FILE", "TITL", "FORM", "NOTE"});
                        continue;
                    }
                    this.println(" FILE ref but no file was found (" + file.getDisplayValue() + ")");
                    continue;
                }
                this.println(" OBJE without FILE is currently not handled (" + file != null ? file.getDisplayValue() : "file is null)");
            }
        }
        if (p.hasChildNodes()) {
            return p;
        }
        return null;
    }

    protected void processNumberNoteSourceChangeRest(Property prop, String linkPrefix, Element appendTo, String id, Html html, List<String> handledProperties, boolean showPageCreated) {
        if (!prop.getTag().equals("SOUR")) {
            Element sourceP = html.p();
            this.processSourceRefs(sourceP, prop, linkPrefix, id, html);
            if (sourceP.hasChildNodes()) {
                appendTo.appendChild(html.h2(this.getPropertyName("SOUR", true)));
                appendTo.appendChild(sourceP);
            }
        }
        handledProperties.add("SOUR");
        if (!prop.getTag().equals("NOTE")) {
            Element noteP = html.p();
            this.processNoteRefs(noteP, prop, linkPrefix, id, html);
            if (noteP.hasChildNodes()) {
                appendTo.appendChild(html.h2(this.getPropertyName("NOTE", true)));
                appendTo.appendChild(noteP);
            }
        }
        handledProperties.add("NOTE");
        this.processSimpleTags(prop, new String[]{"RFN", "AFN", "RIN"}, appendTo, html, handledProperties);
        Property[] refns = prop.getProperties("REFN");
        if (refns.length > 0) {
            appendTo.appendChild(html.h2(this.getPropertyName("REFN")));
            for (Property refn : refns) {
                Element p = html.p(refn.getDisplayValue());
                Property type = refn.getProperty("TYPE");
                if (type != null) {
                    p.appendChild(html.text(" (" + type.getDisplayValue() + ")"));
                }
                appendTo.appendChild(p);
                this.reportUnhandledProperties(refn, new String[]{"TYPE"});
            }
            handledProperties.add("REFN");
        }
        if (this.displayChangeDate) {
            String gedcomName;
            PropertyChange lastUpdate = (PropertyChange)prop.getProperty("CHAN");
            String string = gedcomName = this.includeGedcomName ? " " + prop.getGedcom().getName() : "";
            if (lastUpdate != null) {
                appendTo.appendChild(html.h2(this.translateLocal("other")));
                Element p = html.p(this.translateLocal("dataUpdated") + " " + lastUpdate.getDisplayValue());
                appendTo.appendChild(p);
                handledProperties.add("CHAN");
                this.processNoteRefs(p, (Property)lastUpdate, linkPrefix, id, html);
                this.reportUnhandledProperties((Property)lastUpdate, new String[]{"NOTE"});
                if (showPageCreated) {
                    p.appendChild(html.br());
                    p.appendChild(html.text(this.translateLocal("pageCreated") + " " + new PropertyChange().getDisplayValue() + gedcomName));
                }
            } else if (showPageCreated) {
                appendTo.appendChild(html.h2(this.translateLocal("other")));
                appendTo.appendChild(html.p(this.translateLocal("pageCreated") + " " + new PropertyChange().getDisplayValue() + gedcomName));
            }
        } else {
            handledProperties.add("CHAN");
        }
        this.reportUnhandledProperties(prop, handledProperties.toArray(new String[0]));
        Element otherProperties = this.getAllProperties(prop, html, handledProperties);
        if (otherProperties != null) {
            appendTo.appendChild(html.p(this.translateLocal("otherprops") + ":"));
            appendTo.appendChild(otherProperties);
        }
    }

    protected void processSimpleTags(Property prop, String[] tags, Element appendTo, Html html, List<String> handledProperties) {
        for (String tag : tags) {
            this.processSimpleTag(prop, tag, appendTo, html, handledProperties);
        }
    }

    protected void processSimpleTag(Property prop, String tag, Element appendTo, Html html, List<String> handledProperties) {
        Property[] subProps = prop.getProperties(tag);
        if (subProps.length > 0) {
            appendTo.appendChild(html.h2(this.getPropertyName(tag)));
            for (Property subProp : subProps) {
                Element p = html.p();
                this.appendDisplayValue(p, subProp, false, html);
                appendTo.appendChild(p);
                this.reportUnhandledProperties(subProp, null);
            }
        }
        handledProperties.add(tag);
    }

    protected void processOtherEventTag(String tag, Property prop, String linkPrefix, String id, Element appendTo, Html html) {
        Property[] subProp = prop.getProperties(tag);
        if (subProp.length == 0) {
            return;
        }
        Arrays.sort(subProp, new PropertyComparator(".:DATE"));
        appendTo.appendChild(html.h2(this.getPropertyName(tag)));
        for (int i = 0; i < subProp.length; ++i) {
            appendTo.appendChild(this.processEventDetail(subProp[i], linkPrefix, id, html, false));
        }
    }

    protected Element processEventDetail(Property event, String linkPrefix, String id, Html html, boolean displayTagDescription) {
        Property tagProp;
        Property type;
        if (event == null) {
            return null;
        }
        Element p = html.p();
        ArrayList<String> handledProperties = new ArrayList<String>();
        if (displayTagDescription && !event.getTag().equals("EVEN")) {
            p.appendChild(html.text(this.getPropertyName(event.getTag()) + ": "));
        }
        if ((type = event.getProperty("TYPE")) != null) {
            p.appendChild(html.text(type.getDisplayValue() + " "));
        }
        handledProperties.add("TYPE");
        p.appendChild(html.text(event.getDisplayValue() + " "));
        PropertyDate date = (PropertyDate)event.getProperty("DATE");
        if (date != null) {
            p.appendChild(html.text(date.getDisplayValue() + " "));
        }
        handledProperties.add("DATE");
        Element place = this.processPlace(event.getProperty("PLAC"), linkPrefix, id, html);
        if (place != null) {
            p.appendChild(place);
            if (this.mapEventLocations != null) {
                if (this.mapEventLocations.length() > 0) {
                    this.mapEventLocations.append("|");
                }
                this.mapEventLocations.append(this.getEventMapPosition(event));
            }
        }
        handledProperties.add("PLAC");
        this.processAddresses(p, event, html, handledProperties, false);
        this.processSourceRefs(p, event, linkPrefix, id, html);
        handledProperties.add("SOUR");
        this.processNoteRefs(p, event, linkPrefix, id, html);
        handledProperties.add("NOTE");
        for (String tag : new String[]{"AGE", "AGNC", "CAUS", "RELI", "RESN"}) {
            tagProp = event.getProperty(tag);
            if (tagProp != null) {
                p.appendChild(html.text(this.getPropertyName(tag) + " " + tagProp.getDisplayValue()));
                this.reportUnhandledProperties(tagProp, null);
            }
            handledProperties.add(tag);
        }
        for (String tag : new String[]{"HUSB", "WIFE"}) {
            tagProp = event.getProperty(tag);
            if (tagProp != null) {
                Property age = tagProp.getProperty("AGE");
                if (age != null) {
                    p.appendChild(html.text(this.getPropertyName(tag) + " " + this.getPropertyName("AGE") + " " + age.getDisplayValue()));
                    this.reportUnhandledProperties(age, null);
                }
                this.reportUnhandledProperties(tagProp, new String[]{"AGE"});
            }
            handledProperties.add(tag);
        }
        Property famRef = event.getProperty("FAMC");
        if (famRef != null) {
            if (famRef instanceof PropertyXRef) {
                Fam fam = (Fam)((PropertyXRef)famRef).getTargetEntity();
                Property adoptedBy = famRef.getProperty("ADOP");
                if (adoptedBy != null) {
                    this.makeLinkToFamily(p, fam, adoptedBy.getValue(), linkPrefix, html);
                } else {
                    this.makeLinkToFamily(p, fam, null, linkPrefix, html);
                }
            } else {
                this.println(event.getTag() + ":FAMC is not a reference:" + event.getValue());
            }
        }
        handledProperties.add("FAMC");
        Element pObj = this.processMultimediaLink(event, linkPrefix, id, html, true, false);
        if (pObj != null && pObj.hasChildNodes()) {
            NodeList nl = pObj.getChildNodes();
            while (nl.getLength() > 0) {
                p.appendChild(nl.item(0));
            }
        }
        handledProperties.add("OBJE");
        this.reportUnhandledProperties(event, handledProperties.toArray(new String[0]));
        return p;
    }

    protected String getEventMapPosition(Property event) {
        if (event == null) {
            return null;
        }
        Property place = event.getProperty("PLAC");
        if (place == null) {
            return null;
        }
        PropertyLatitude latitude = ((PropertyPlace)place).getLatitude(true);
        if (latitude != null) {
            PropertyLongitude longitude = ((PropertyPlace)place).getLongitude(true);
            return latitude.getDoubleValue().toString() + "," + longitude.getDoubleValue().toString();
        }
        String value = place.getValue();
        value = value.replaceAll("[?&]", "");
        value = value.replaceAll(" ", "+");
        return value;
    }

    protected void makeLinkToFamily(Element appendTo, Fam fam, String memberOfFamily, String linkPrefix, Html html) {
        Indi husb = fam.getHusband();
        Indi wife = fam.getWife();
        if (memberOfFamily == null || memberOfFamily.equals("BOTH")) {
            if (husb != null) {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(husb.getId()), this.getName(husb)));
                if (wife != null) {
                    appendTo.appendChild(html.text(" " + this.translateLocal("and") + " "));
                }
            }
            if (wife != null) {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(wife.getId()), this.getName(wife)));
            }
        } else if (memberOfFamily.equals("WIFE")) {
            if (wife != null) {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(wife.getId()), this.getName(wife)));
            }
        } else if (memberOfFamily.equals("HUSB")) {
            if (husb != null) {
                appendTo.appendChild(html.link(linkPrefix + this.addressTo(husb.getId()), this.getName(husb)));
            }
        } else {
            this.println("Invalid value on member of family:" + memberOfFamily);
        }
    }

    protected Element processPlace(Property place, String linkPrefix, String id, Html html) {
        if (place == null) {
            return null;
        }
        String formattedPlace = this.placeDisplayFormat.equals("all") ? place.getValue() : place.format(this.placeDisplayFormat).replaceAll("^(,|(, ))*", "").trim();
        Element span = html.span("place", formattedPlace);
        this.processSourceRefs(span, place, linkPrefix, id, html);
        this.processNoteRefs(span, place, linkPrefix, id, html);
        for (String subTag : new String[]{"FONE", "ROMN"}) {
            Property fone = place.getProperty(subTag);
            if (fone == null) continue;
            String type = "";
            Property typeProp = fone.getProperty("TYPE");
            if (typeProp != null) {
                type = typeProp.getDisplayValue();
            }
            span.appendChild(html.text(this.getPropertyName(subTag) + " " + type + ": " + formattedPlace));
            this.reportUnhandledProperties(fone, new String[]{"TYPE"});
        }
        Property map = place.getProperty("MAP");
        if (map != null && this.reportLinksToMap) {
            String latitude = map.getProperty("LATI").getDisplayValue();
            String longitude = map.getProperty("LONG").getDisplayValue();
            latitude = latitude.startsWith("S") || latitude.startsWith("s") ? "-" + latitude.substring(1) : latitude.substring(1);
            longitude = longitude.startsWith("W") || longitude.startsWith("w") ? "-" + longitude.substring(1) : longitude.substring(1);
            span.appendChild(html.text(" "));
            span.appendChild(html.link(this.translateLocal("mapLink", latitude, longitude), this.translateLocal("linkToMap")));
            this.reportUnhandledProperties(map, new String[]{"LATI", "LONG"});
        }
        this.reportUnhandledProperties(place, new String[]{"SOUR", "NOTE", "MAP"});
        return span;
    }

    protected boolean processAddressesHasData(Property prop) {
        if (prop.getProperty("ADDR") != null) {
            return true;
        }
        for (String tag : this.addressOtherProperties) {
            if (prop.getProperty(tag) == null) continue;
            return true;
        }
        return false;
    }

    protected void processAddresses(Element appendTo, Property prop, Html html, List<String> handledProperties, boolean bigDisplayWithHeading) {
        Property address;
        if (!this.processAddressesHasData(prop)) {
            return;
        }
        if (bigDisplayWithHeading) {
            appendTo.appendChild(html.h2(this.getPropertyName("ADDR")));
        }
        Element span = html.span("address");
        if (!bigDisplayWithHeading) {
            appendTo.appendChild(span);
        }
        if ((address = prop.getProperty("ADDR")) != null) {
            String[] addressSubProperties;
            this.appendDisplayValue(span, address, !bigDisplayWithHeading, html);
            String[] stringArray = addressSubProperties = new String[]{"ADR1", "ADR2", "ADR3", "CITY", "STAE", "POST", "CTRY"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String subTag = stringArray[i];
                Property subProp = address.getProperty(subTag);
                if (subProp == null) continue;
                if (bigDisplayWithHeading) {
                    span.appendChild(html.br());
                } else {
                    span.appendChild(html.text(", "));
                }
                span.appendChild(html.text(subProp.getDisplayValue()));
                this.reportUnhandledProperties(subProp, null);
            }
            this.reportUnhandledProperties(address, addressSubProperties);
        }
        if (bigDisplayWithHeading && span.hasChildNodes()) {
            appendTo.appendChild(html.p(span));
        }
        handledProperties.add("ADDR");
        for (String tag : this.addressOtherProperties) {
            for (Property subProp : prop.getProperties(tag)) {
                Node value = html.text(subProp.getDisplayValue());
                if (tag.equals("EMAIL")) {
                    value = html.link("mailto:" + subProp.getDisplayValue(), subProp.getDisplayValue());
                }
                if (tag.equals("WWW")) {
                    value = html.link(subProp.getDisplayValue(), subProp.getDisplayValue());
                }
                if (bigDisplayWithHeading) {
                    Element p = html.p(this.getPropertyName(tag) + ": ");
                    p.appendChild(value);
                    appendTo.appendChild(p);
                    continue;
                }
                span.appendChild(html.text(", "));
                span.appendChild(value);
            }
            handledProperties.add(tag);
        }
    }

    protected void processSourceRefs(Element appendTo, Property prop, String linkPrefix, String id, Html html) {
        Property[] sourceRefs = prop.getProperties("SOUR");
        if (sourceRefs.length > 0) {
            if (this.sourceDiv == null) {
                this.sourceDiv = html.div("left");
                this.addedSourceProperty = new ArrayList<Property>();
                this.sourceCounter = 1;
            }
            Element sup = html.sup("source");
            for (Property sourceRef : sourceRefs) {
                if (sup.hasChildNodes()) {
                    sup.appendChild(html.text(", "));
                }
                sup.appendChild(this.addSourceRef(sourceRef, linkPrefix, id, html));
            }
            appendTo.appendChild(sup);
        }
    }

    protected Element addSourceRef(Property sourceRef, String linkPrefix, String id, Html html) {
        int i = 1;
        for (Property alreadyAdded : this.addedSourceProperty) {
            if (this.propertyStructEquals(sourceRef, alreadyAdded)) {
                return html.link("#S" + i, "S" + i);
            }
            ++i;
        }
        this.addedSourceProperty.add(sourceRef);
        int number = this.sourceCounter++;
        Element p = html.p();
        this.sourceDiv.appendChild(p);
        Element anchor = html.anchor("S" + number);
        p.appendChild(anchor);
        anchor.appendChild(html.text("S" + number + ": "));
        if (sourceRef instanceof PropertySource) {
            Element pObj;
            Property quay;
            Property data;
            Property even;
            Source source = (Source)((PropertySource)sourceRef).getTargetEntity();
            if (source != null) {
                p.appendChild(html.link(linkPrefix + this.addressTo(source.getId()), source.toString()));
            } else {
                p.appendChild(html.text("(" + this.translateLocal("unknown") + ")"));
            }
            Property page = sourceRef.getProperty("PAGE");
            if (page != null) {
                p.appendChild(html.text(" " + this.getPropertyName("PAGE") + ": " + page.getDisplayValue()));
                this.reportUnhandledProperties(page, null);
            }
            if ((even = sourceRef.getProperty("EVEN")) != null) {
                p.appendChild(html.text(" " + this.getPropertyName("EVEN") + ": " + even.getDisplayValue()));
                Property role = even.getProperty("ROLE");
                if (role != null) {
                    p.appendChild(html.text(" " + this.getPropertyName("ROLE") + ": " + role.getDisplayValue()));
                    this.reportUnhandledProperties(role, null);
                }
                this.reportUnhandledProperties(even, new String[]{"ROLE"});
            }
            if ((data = sourceRef.getProperty("DATA")) != null) {
                Property text;
                p.appendChild(html.text(" " + this.getPropertyName("DATA") + ": " + data.getDisplayValue()));
                Property date = data.getProperty("DATE");
                if (date != null) {
                    p.appendChild(html.text(" " + date.getDisplayValue()));
                }
                if ((text = data.getProperty("TEXT")) != null) {
                    p.appendChild(html.text(" "));
                    this.appendDisplayValue(p, text, false, html);
                }
                this.reportUnhandledProperties(data, new String[]{"DATE", "TEXT"});
            }
            if ((quay = sourceRef.getProperty("QUAY")) != null) {
                p.appendChild(html.text(" " + this.getPropertyName("QUAY") + ": " + quay.getDisplayValue()));
                this.reportUnhandledProperties(quay, null);
            }
            if ((pObj = this.processMultimediaLink(sourceRef, linkPrefix, id, html, true, false)) != null) {
                this.sourceDiv.appendChild(pObj);
            }
            this.reportUnhandledProperties(sourceRef, new String[]{"PAGE", "EVEN", "DATA", "QUAY", "OBJE", "NOTE"});
        } else {
            this.appendDisplayValue(p, sourceRef, false, html);
            for (Property text : sourceRef.getProperties("TEXT")) {
                Element sp = html.p();
                this.sourceDiv.appendChild(sp);
                sp.appendChild(html.text(this.getPropertyName("TEXT") + ": "));
                this.appendDisplayValue(sp, text, false, html);
            }
            this.reportUnhandledProperties(sourceRef, new String[]{"TEXT", "NOTE"});
        }
        this.processNoteRefs(p, sourceRef, linkPrefix, id, html);
        return html.link("#S" + number, "S" + number);
    }

    protected void processNoteRefs(Element appendTo, Property prop, String linkPrefix, String id, Html html) {
        Property[] noteRefs = prop.getProperties("NOTE");
        if (noteRefs.length > 0) {
            if (this.noteDiv == null) {
                this.noteDiv = html.div("left");
                this.addedNoteProperty = new ArrayList<Property>();
                this.noteCounter = 1;
            }
            Element sup = html.sup("note");
            for (Property noteRef : noteRefs) {
                if (sup.hasChildNodes()) {
                    sup.appendChild(html.text(", "));
                }
                sup.appendChild(this.addNoteRef(noteRef, linkPrefix, id, html));
            }
            appendTo.appendChild(sup);
        }
    }

    protected Element addNoteRef(Property noteRef, String linkPrefix, String id, Html html) {
        int i = 1;
        for (Property alreadyAdded : this.addedNoteProperty) {
            if (this.propertyStructEquals(noteRef, alreadyAdded)) {
                return html.link("#N" + i, "N" + i);
            }
            ++i;
        }
        this.addedNoteProperty.add(noteRef);
        int number = this.noteCounter++;
        Element p = html.p();
        this.noteDiv.appendChild(p);
        Element anchor = html.anchor("N" + number);
        p.appendChild(anchor);
        anchor.appendChild(html.text("N" + number + ": "));
        if (noteRef instanceof PropertyNote) {
            Note note = (Note)((PropertyNote)noteRef).getTargetEntity();
            if (this.reportNotesInFullOnEntity) {
                this.appendDisplayValue(p, (Property)note, false, html);
                this.processSourceRefs(p, (Property)note, linkPrefix, id, html);
            } else {
                p.appendChild(html.link(linkPrefix + this.addressTo(note.getId()), note.toString()));
            }
        } else {
            this.appendDisplayValue(p, noteRef, false, html);
        }
        this.processSourceRefs(p, noteRef, linkPrefix, id, html);
        this.reportUnhandledProperties(noteRef, new String[]{"SOUR"});
        return html.link("#N" + number, "N" + number);
    }

    protected boolean propertyStructEquals(Property a, Property b) {
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (a.compareTo(b) != 0) {
            return false;
        }
        Property[] aProps = a.getProperties();
        Property[] bProps = b.getProperties();
        if (aProps.length == 0 && bProps.length == 0) {
            return true;
        }
        if (aProps.length == 1 && bProps.length == 1) {
            return this.propertyStructEquals(aProps[0], bProps[0]);
        }
        return false;
    }

    protected void appendDisplayValue(Element appendTo, Property prop, boolean ignoreNewLine, Html html) {
        if (prop instanceof MultiLineProperty) {
            MultiLineProperty.Iterator lineIter = ((MultiLineProperty)prop).getLineIterator(true);
            boolean firstLine = true;
            do {
                if (!firstLine && !ignoreNewLine && lineIter.getTag().equals("CONT")) {
                    appendTo.appendChild(html.br());
                }
                appendTo.appendChild(html.text(lineIter.getValue()));
                firstLine = false;
            } while (lineIter.next());
        } else {
            appendTo.appendChild(html.text(prop.getDisplayValue()));
        }
    }

    protected void resetNoteAndSourceList() {
        this.sourceDiv = null;
        this.noteDiv = null;
    }

    protected void addNoteAndSourceList(Element appendTo) {
        if (this.noteDiv != null) {
            appendTo.appendChild(this.noteDiv);
        }
        if (this.sourceDiv != null) {
            appendTo.appendChild(this.sourceDiv);
        }
    }

    protected void addDecendantTree(Element whereToAdd, Indi indi, String relation, String linkPrefix, Html html) {
        if (indi == null) {
            return;
        }
        String relationClass = relation;
        if (relation.length() == 0) {
            relationClass = "ident";
        }
        Element div = html.div("anc " + relationClass);
        Element link = html.link(linkPrefix + this.addressTo(indi.getId()), this.getLimitedName(indi));
        link.appendChild(html.br());
        if (!this.isPrivate(indi)) {
            PropertyDate deathDate;
            PropertyDate birthDate = indi.getBirthDate();
            if (birthDate != null) {
                link.appendChild(html.text(birthDate.getDisplayValue()));
            }
            if ((deathDate = indi.getDeathDate()) != null) {
                link.appendChild(html.text(" -- " + deathDate.getDisplayValue()));
            }
        }
        div.appendChild(link);
        whereToAdd.appendChild(div);
        Indi f = indi.getBiologicalFather();
        Indi m = indi.getBiologicalMother();
        if (f != null || m != null) {
            div.appendChild(html.div("l1", " "));
            div.appendChild(html.div("l2", " "));
            if (relation.length() == 2) {
                div.appendChild(html.div("l3", " "));
                div.appendChild(html.div("l4", " "));
            }
            if (relation.length() < 3) {
                this.addDecendantTree(whereToAdd, m, relation + "m", linkPrefix, html);
                this.addDecendantTree(whereToAdd, f, relation + "f", linkPrefix, html);
            }
        }
        if (relation.length() == 0) {
            Element p = html.pNewlines(" ");
            p.setAttribute("class", "treeMargin");
            whereToAdd.appendChild(p);
        }
    }

    protected Element getBirthPlaceMap(Indi indi, Html html) {
        String lines = this.getBirthPlaceMapRec(indi, 0, html);
        if (lines.equals("")) {
            return null;
        }
        return html.img("http://maps.google.com/maps/api/staticmap?size=300x300&maptype=roadmap&sensor=false" + lines, this.translate("mapAncestorBirthPlace"));
    }

    protected String getBirthPlaceMapRec(Indi indi, int depth, Html html) {
        if (indi == null) {
            return "";
        }
        Indi f = indi.getBiologicalFather();
        Indi m = indi.getBiologicalMother();
        if (f == null || m == null) {
            return "";
        }
        String ibp = this.getEventMapPosition(indi.getProperty("BIRT"));
        String fbp = this.getEventMapPosition(f.getProperty("BIRT"));
        String mbp = this.getEventMapPosition(m.getProperty("BIRT"));
        String path = "";
        if (ibp != null && (mbp != null || fbp != null)) {
            String color = "000000";
            if (depth > 0) {
                color = Integer.toHexString(depth * 0x444444);
            }
            path = "&path=color:0x" + color + "FF|weight:2";
            if (fbp != null) {
                path = path + "|" + fbp;
            }
            path = path + "|" + ibp;
            if (mbp != null) {
                path = path + "|" + mbp;
            }
        }
        if (depth > 1) {
            return path;
        }
        path = path + this.getBirthPlaceMapRec(f, depth + 1, html);
        path = path + this.getBirthPlaceMapRec(m, depth + 1, html);
        return path;
    }

    protected void reportUnhandledProperties(Property current, String[] handled) {
        for (Property property : current.getProperties()) {
            String tag = property.getTag();
            if (this.isIn(tag, handled)) continue;
            this.println("  Unhandled tag:" + current.getTag() + ":" + tag);
        }
    }

    protected boolean isIn(String value, String[] list) {
        if (list == null) {
            return false;
        }
        for (String element : list) {
            if (!value.equals(element)) continue;
            return true;
        }
        return false;
    }

    protected Element getAllProperties(Property current, Html html, List<String> ignore) {
        Property[] properties = current.getProperties();
        if (properties.length > 0) {
            Element propertiesList = html.ul("padding-left:10px;");
            for (int i = 0; i < properties.length; ++i) {
                if (ignore != null && ignore.contains(properties[i].getTag())) continue;
                Element li = html.li(properties[i].getTag() + ": " + properties[i].getDisplayValue());
                Element subProperties = this.getAllProperties(properties[i], html, null);
                if (subProperties != null) {
                    li.appendChild(subProperties);
                }
                propertiesList.appendChild(li);
            }
            if (propertiesList.hasChildNodes()) {
                return propertiesList;
            }
        }
        return null;
    }

    protected HashMap<String, String> makeCssAndJSSettings() {
        HashMap<String, String> translator = new HashMap<String, String>();
        this.addColorToMap(translator, "cssTextColor", this.cssTextColor);
        this.addColorToMap(translator, "cssBackgroundColor", this.cssBackgroundColor);
        this.addColorToMap(translator, "cssLinkColor", this.cssLinkColor);
        this.addColorToMap(translator, "cssVistedLinkColor", this.cssVistedLinkColor);
        this.addColorToMap(translator, "cssBorderColor", this.cssBorderColor);
        translator.put("indexFile", this.getLocalizedFilename(this.reportIndexFileName, this.currentLocale));
        translator.put("noSearchResults", this.translateLocal("noSearchResults"));
        return translator;
    }

    protected void addColorToMap(HashMap<String, String> translator, String name, Color color) {
        StringBuilder value = new StringBuilder();
        int r = color.getRed();
        if (r < 16) {
            value.append("0");
        }
        value.append(Integer.toHexString(r));
        int g = color.getGreen();
        if (g < 16) {
            value.append("0");
        }
        value.append(Integer.toHexString(g));
        int b = color.getBlue();
        if (b < 16) {
            value.append("0");
        }
        value.append(Integer.toHexString(b));
        translator.put(name, value.toString());
    }

    protected void makeCss(File dir, HashMap<String, String> translator) throws IOException {
        this.println("Making css-file");
        this.copyTextFileModify(((Object)((Object)this)).getClass().getResourceAsStream(CSS_BASE_FILE), dir.getAbsolutePath() + File.separator + "style.css", translator, false);
        this.copyTextFileModify(((Object)((Object)this)).getClass().getResourceAsStream(cssTreeFile[this.treeType]), dir.getAbsolutePath() + File.separator + "style.css", translator, true);
    }

    protected void makeJs(File dir, HashMap<String, String> translator) throws IOException {
        this.println("Making js-file");
        this.copyTextFileModify(((Object)((Object)this)).getClass().getResourceAsStream("html/search.js"), dir.getAbsolutePath() + File.separator + this.getLocalizedFilename("search.js", this.currentLocale), translator, false);
    }

    protected String getLocalizedFilename(String filename, Locale locale) {
        if (locale != null) {
            return filename.replaceFirst("\\.", "-" + locale.getLanguage() + ".");
        }
        return filename;
    }

    protected String addressTo(String id) {
        return this.addressToDir(id) + this.getLocalizedFilename(this.reportIndexFileName, this.currentLocale);
    }

    private String addressToDir(String id) {
        StringBuilder address = new StringBuilder();
        String type = id.substring(0, 1);
        String prefix = type.toLowerCase();
        if (type.equals("I")) {
            prefix = "indi";
        }
        if (type.equals("S")) {
            prefix = "source";
        }
        if (type.equals("R")) {
            prefix = "repository";
        }
        if (type.equals("O")) {
            prefix = "object";
        }
        address.append(prefix);
        String idString = id.substring(1);
        int i = idString.length();
        if (i % 2 == 1) {
            ++i;
            idString = "0" + idString;
        }
        address.append(i);
        while (idString.length() > 0) {
            address.append('/').append(idString.substring(0, 2));
            idString = idString.substring(2);
        }
        address.append('/');
        return address.toString();
    }

    protected int addressDepth(String id) {
        return id.length() / 2 + 1;
    }

    protected String relativeLinkPrefix(String fromId) {
        StringBuilder address = new StringBuilder();
        for (int i = 0; i < this.addressDepth(fromId); ++i) {
            address.append("../");
        }
        return address.toString();
    }

    protected void makeThumb(File imgFile, int wmax, int hmax, File thumbFile) throws IOException {
        int height;
        float hscale;
        BufferedImage originalImage = ImageIO.read(imgFile);
        if (originalImage == null) {
            this.println(">>>>>>>>>> error with image " + imgFile.getAbsolutePath());
            return;
        }
        int width = originalImage.getWidth();
        float wscale = (float)wmax / (float)width;
        if (wscale > (hscale = (float)hmax / (float)(height = originalImage.getHeight()))) {
            wscale = hscale;
        }
        width = (int)((float)width * wscale);
        height = (int)((float)height * wscale);
        BufferedImage thumbImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(originalImage, 0, 0, width, height, null);
        ImageIO.write((RenderedImage)thumbImage, "jpg", thumbFile);
    }

    protected void copyFile(File src, File dst) throws IOException {
        this.copyFile(new FileInputStream(src), dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(InputStream source, File dst) throws IOException {
        try (FileOutputStream destination = new FileOutputStream(dst);){
            FileUtil.copy((InputStream)source, (OutputStream)destination);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTextFileModify(InputStream inStream, String outFile, HashMap<String, String> translator, boolean append) throws IOException {
        Pattern replacePattern = Pattern.compile(".*\\{(\\w+)\\}.*");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStream));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile, append), "UTF-8"));
            String buffer = in.readLine();
            while (buffer != null) {
                Matcher m = replacePattern.matcher(buffer);
                while (m.matches()) {
                    String key = m.group(1);
                    buffer = buffer.replaceAll("\\{" + key + "\\}", translator.get(key));
                    m = replacePattern.matcher(buffer);
                }
                out.write(buffer);
                out.newLine();
                buffer = in.readLine();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    protected String translateLocal(String key, Object ... values) {
        return this.translate(key, this.currentLocale, values);
    }

    protected String translateLocal(String key) {
        return this.translateLocal(key, null);
    }

    protected class EntityComparator
    implements Comparator<Entity> {
        protected EntityComparator() {
        }

        @Override
        public int compare(Entity arg0, Entity arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

