#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    //ui->groupBox_multiTab->setVisible(false);
    ui->spinBox_tabletNumber->setVisible(false);
    ui->spinBox_multiTab_1->setVisible(false);
    ui->spinBox_multiTab_2->setVisible(false);
    ui->spinBox_multiTab_3->setVisible(false);
    ui->spinBox_multiTab_4->setVisible(false);
    ui->spinBox_multiTab_5->setVisible(false);
    ui->spinBox_multiTab_6->setVisible(false);
    ui->spinBox_multiTab_7->setVisible(false);

    ui->groupBox_proximity->setVisible(false);
    ui->groupBox_zoom->setVisible(false);
    ui->groupBox_scroll->setVisible(false);

    QProcess OProcess;
    QString Command;    //Contains the command to be executed
    QStringList args;   //Contains arguments of the command

    Command = "/usr/bin/xsetwacom";
    args<<"--list"<<"devices";

    OProcess.start(Command,args,QIODevice::ReadOnly); //Starts execution of command
    OProcess.waitForFinished();                       //Waits for execution to complete

    QString StdOut      =   OProcess.readAllStandardOutput();  //Reads standard output
    QString StdError    =   OProcess.readAllStandardError();   //Reads standard error
    QString NoError = "There were no Errors";
    QString NoOut = "There was no type of output";
    int currentCount = 0;
    if(StdOut != NULL){
        std::vector<int> filteredIds;
        QRegularExpression re("\\d+"); // removes any tabs
        QRegularExpressionMatchIterator i = re.globalMatch(StdOut);
        while (i.hasNext()) {
            QRegularExpressionMatch match = i.next();
            bool ok;
            int id = match.captured(0).toInt(&ok);
            if (ok && (id >= 1 && id <= 100)) { // as long as it's a int "ok" and a number between 1 and 100
                filteredIds.push_back(id);
            }
        }
        // use the filtered ids
        for (const auto& id : filteredIds) {
            //std::cout << "filtered id: " << id << std::endl;
            switch(currentCount){
            case 0:
                ui->spinBox_tabletNumber->setVisible(true);
                ui->spinBox_tabletNumber->setValue(id);

                break;
            case 1:
                ui->spinBox_multiTab_1->setVisible(true);
                ui->spinBox_multiTab_1->setValue(id);
               // ui->groupBox_multiTab->setVisible(true);
                break;
            case 2:
                ui->spinBox_multiTab_2->setValue(id);
                ui->spinBox_multiTab_2->setVisible(false);
                break;
            case 3:
                ui->spinBox_multiTab_3->setValue(id);
                ui->spinBox_multiTab_3->setVisible(false);
                break;
            case 4:
                ui->spinBox_multiTab_4->setValue(id);
                ui->spinBox_multiTab_4->setVisible(false);
                break;
            case 5:
                ui->spinBox_multiTab_5->setValue(id);
                ui->spinBox_multiTab_5->setVisible(false);
                break;
            case 6:
                ui->spinBox_multiTab_6->setValue(id);
                ui->spinBox_multiTab_6->setVisible(false);
                break;
            case 7:
                ui->spinBox_multiTab_7->setValue(id);
                ui->spinBox_multiTab_7->setVisible(false);
                break;
            }
            currentCount++;
        }
    } else if(StdOut == NULL && StdError == NULL){
        QString NoTabletOutput = "There was no Wacom Tablet found\r\nIf a Tablet is plugged in and is not recogonized please contact the developer for more help.";
        QMessageBox::warning(this, "No Wacom Tablet Found", NoTabletOutput);
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_actionQuit_triggered()
{
    QApplication::quit();
}
void MainWindow::on_pushButton_submit_clicked()
//void MainWindow::on_pushButton_submitTest_clicked()
{
    bool ShowOutput = false;
    bool RunTheProgram = true;
    if(ui->action_showOutput->isChecked()) ShowOutput = true;
    if(ui->action_Just_Test->isChecked()) RunTheProgram = false;
    //int tabletNumber;
    int count = 1;
    int mt[8];
    QString tabletNumberString;
    //int currentTabletNumber;

    mt[0] = ui->spinBox_tabletNumber->value(); // this is the number of the tablet id.
    mt[1] = ui->spinBox_multiTab_1->value();
    mt[2] = ui->spinBox_multiTab_2->value();
    mt[3] = ui->spinBox_multiTab_3->value();
    mt[4] = ui->spinBox_multiTab_4->value();
    mt[5] = ui->spinBox_multiTab_5->value();
    mt[6] = ui->spinBox_multiTab_6->value();
    mt[7] = ui->spinBox_multiTab_7->value();

    if(mt[1] > 0) count++;
    if(mt[2] > 0) count++;
    if(mt[3] > 0) count++;
    if(mt[4] > 0) count++;
    if(mt[5] > 0) count++;
    if(mt[6] > 0) count++;
    if(mt[7] > 0) count++;

    // Mode Section 1
    QString Mode;
    bool ModeBool=1;
    if(ui->radioButton_mode_absolute->isChecked()){ Mode="absolute"; ModeBool=1; }
    if(ui->radioButton_mode_relative->isChecked()){ Mode="relative"; ModeBool=0; }

    // Map2Monitor Section 1
    int Map2Monitor=100;
    if(ui->radioButton__map2monitor_1->isChecked()) Map2Monitor = 0;
    if(ui->radioButton__map2monitor_2->isChecked()) Map2Monitor = 1;
    if(ui->radioButton_map2monitor_3->isChecked()) Map2Monitor = 2;
    if(ui->radioButton_map2monitor_4->isChecked()) Map2Monitor = 3;

    // Rotate Section 1
    int Rotate = 0;
    if(ui->radioButton_rotate_180->isChecked()) Rotate=1; // 180
    if(ui->radioButton_rotate_90_ccw->isChecked()) Rotate=2; // 90 CCW
    if(ui->radioButton_rotate_90_cw->isChecked()) Rotate=3; // 90 CW
    if(ui->radioButton_rotate_none->isChecked()) Rotate=4; // NONE, back to normal
    QString outsRotate;
    switch(Rotate){
        case 1:
            outsRotate = "half";
        break;
    case 2:
            outsRotate = "cw";
        break;
    case 3:
            outsRotate = "ccw";
        break;
    case 4:
            outsRotate = "none";
        break;
    }

    // Pressure Curve Section 1
    int x1pc;
    int y1pc;
    int x2pc;
    int y2pc;
    if(ui->checkBox_pressureCurve->isChecked()){
        x1pc = ui->spinBox_pressureCurve_x1->value();
        y1pc = ui->spinBox_pressureCurve_y1->value();
        x2pc = ui->spinBox_pressureCurve_x2->value();
        y2pc = ui->spinBox_pressureCurve_y2->value();
    }

    // Touch Section 1
    QString touchResults;
    if(ui->checkBox_touch->isChecked()){
        if(ui->radioButton_touch_on->isChecked()){
            touchResults = "on";
        }else{
            touchResults = "off";
        }
    }

    // Threshold Level Section 1
    QString thresholdResults;
    if(ui->checkBox_thresholdlevel->isChecked()){
        thresholdResults = QString::number(ui->spinBox_thresholdlevel->value());

    }

    // Raw Sample Section 1
    QString rawsampleResults;
    if(ui->checkBox_rawsample->isChecked()){
        rawsampleResults = QString::number(ui->spinBox_rawsample->value());
    }

    // Suppress Level 1
    QString suppressResults;
    if(ui->checkBox_suppresslevel->isChecked()){
        suppressResults = QString::number(ui->spinBox_suppresslevel->value());
    }

    // PC Button Mode Section 1
    QString pcResults;
    if(ui->checkBox_buttonMode->isChecked()){
        if(ui->radioButton_buttonMode_on->isChecked()){pcResults = "on"; }else{ pcResults = "off"; }
    }

    // Pressure Recalibration Section 1
    QString prResults;
    if(ui->checkBox_pressureRecalibration->isChecked()){
        if(ui->radioButton_pressureRecalibration_on->isChecked()){
            prResults = "on";
        }else{
            prResults = "off";
        }
    }

    // Gesture Section 1
    QString gestureResults;
    if(ui->checkBox_gesture->isChecked()){
        if(ui->radioButton_gesture_on->isChecked()){ gestureResults = "on"; }else{ gestureResults = "off"; }
    }

    // Zoom Section 1
    QString zoomResults;
    if(ui->checkBox_zoom->isChecked()){
        zoomResults = QString::number(ui->spinBox_zoom->value());
    }

    // Scroll Section 1
    QString scrollResults;
    if(ui->checkBox_scroll->isChecked()){
        scrollResults = QString::number(ui->spinBox_scroll->value());
    }

    // Tap Time Section 1
    QString tapResults ;
    if(ui->checkBox_taptime->isChecked()){
        tapResults = QString::number(ui->spinBox_taptime->value());
    }

    // CursorProximity Section 1
    QString cursorResults;
    if(ui->checkBox_proximity->isChecked()){
        cursorResults = QString::number(ui->spinBox_proximity->value());
    }



    if(mt[0] > 0){
        for(int a=0; a<count; a++){
            //tabletNumber = mt[a];
            tabletNumberString = QString::number(mt[a]);

            // Mode Section 2
            QString outputMode = wac + " -- set " + tabletNumberString + " mode " + Mode;
            QByteArray outMode = outputMode.toLocal8Bit();
            if(RunTheProgram) system(outMode);
            if(ShowOutput) QMessageBox::information(this,"Mode Output", outputMode);

            if(ModeBool == 1){ // if the mode is ONLY in Absolute do you want to Map the Monitors
                // Map2Monitor Section 2
                if(Map2Monitor != 100){
                    // run a map to monitor.
                    QString outputMap2Monitor = wac + " --set " + tabletNumberString + " MapToOutput HEAD-" + QString::number(Map2Monitor);
                    QByteArray outMap2Monitor = outputMap2Monitor.toLocal8Bit();
                    if(RunTheProgram) system(outMap2Monitor);
                    if(ShowOutput) QMessageBox::information(this, "Map 2 Monitor Output", outputMap2Monitor);
                } else {
                    if(ShowOutput) {
                        QString outMap2Monitor = "Map to Monitor is not being used right now.";
                        QMessageBox::information(this, "Map to Monitor", outMap2Monitor);
                    }
                }
            }

            // Rotate Section 2
            QString outputRotate = wac + " --set " + tabletNumberString + " Rotate " + outsRotate;
            QByteArray outRotate = outputRotate.toLocal8Bit();
            if(RunTheProgram) system(outRotate);
            if(ShowOutput) QMessageBox::information(this, "Rotate The Tablet", outputRotate);

            // Pressure Curve Section 2
            if(ui->checkBox_pressureCurve->isChecked()){
                QString outputPressureCurve = wac + "--set " + tabletNumberString + " PressureCurve " + QString::number(x1pc) + " " + QString::number(y1pc) + " " + QString::number(x2pc) + " " + QString::number(y2pc);
                QByteArray outPressureCurve = outputPressureCurve.toLocal8Bit();
                if(RunTheProgram) system(outPressureCurve);
                if(ShowOutput) QMessageBox::information(this, "Pressure Curve", outputPressureCurve);
            }

            // Touch Section 2
            if(ui->checkBox_touch->isChecked()){
                QString outputTouch = wac + "--set " + tabletNumberString + " Touch " + touchResults;
                QByteArray outTouch = outputTouch.toLocal8Bit();
                if(RunTheProgram) system(outTouch);
                if(ShowOutput) QMessageBox::information(this, "Touch Events", outputTouch);
            }

            // Threshold Level Section 2
            if(ui->checkBox_thresholdlevel->isChecked()){
                QString outputThreshold = wac + " --set " + tabletNumberString + " Threshold " + thresholdResults;
                QByteArray outThreshold = outputThreshold.toLocal8Bit();
                if(RunTheProgram) system(outThreshold);
                if(ShowOutput) QMessageBox::information(this, "Threshold Level", outputThreshold);
            }

            // Raw Sample Section 2
            if(ui->checkBox_rawsample->isChecked()){
                QString outputRaw = wac + " --set " + tabletNumberString + " RawSample " + rawsampleResults;
                QByteArray outRaw = outputRaw.toLocal8Bit();
                if(RunTheProgram) system(outRaw);
                if(ShowOutput) QMessageBox::information(this, "Raw Sample", outputRaw);
            }

            // Suppress Level 2
            if(ui->checkBox_suppresslevel->isChecked()){
                QString outputSuppress = wac + " --set " + tabletNumberString + " Suppress " + suppressResults;
                QByteArray outSuppress = outputSuppress.toLocal8Bit();
                if(RunTheProgram) system(outSuppress);
                if(ShowOutput) QMessageBox::information(this, "Suppress Level", outputSuppress);
            }

            // PC Button Mode Section 2
            if(ui->checkBox_buttonMode->isChecked()){
                QString outputPC = wac + " --set " + tabletNumberString + " TabletPCButton " + pcResults;
                QByteArray outPC = outputPC.toLocal8Bit();
                if(RunTheProgram) system(outPC);
                if(ShowOutput) QMessageBox::information(this, "PC Button Mode", outputPC);
            }

            // Pressure Recalibration Section 2
            if(ui->checkBox_pressureRecalibration->isChecked()){
                QString outputPR = wac + " --set " + tabletNumberString + " PressureRecalibration " + prResults;
                QByteArray outPR = outputPR.toLocal8Bit();
                if(RunTheProgram) system(outPR);
                if(ShowOutput) QMessageBox::information(this, "Pressure Recalibration", outputPR);
            }

//            // Tap Section 2
//            if(ui->checkBox_tcp->isChecked()){
//                QString outputTCP = wac + " --set " + tabletNumberString + " TabletPCButton " + tcpResults;
//                QByteArray outTCP = outputTCP.toLocal8Bit();
//                if(RunTheProgram) system(outTCP);
//                if(ShowOutput) QMessageBox::information(this, "Tablet PC Button Mode", outputTCP);
//            }

            // Gesture Section 2
            if(ui->checkBox_gesture->isChecked()){
                QString outputGesture = wac + " --set " + tabletNumberString + " Gesture " + gestureResults;
                QByteArray outGesture = outputGesture.toLocal8Bit();
                if(RunTheProgram) system(outGesture);
                if(ShowOutput) QMessageBox::information(this, "Gesture Mode", outputGesture);
            }

            // Zoom Section 2
            if(ui->checkBox_zoom->isChecked()){
                QString outputZoom = wac + " --set " + tabletNumberString + " ZoomDistance " + zoomResults;
                QByteArray outZoom = outputZoom.toLocal8Bit();
                if(RunTheProgram) system(outZoom);
                if(ShowOutput) QMessageBox::information(this, "Zoom Distance", outputZoom);
            }

            // Scroll Section 2
            if(ui->checkBox_scroll->isChecked()){
                QString outputScroll = wac + " --set " + tabletNumberString + " ScrollDistance " + scrollResults;
                QByteArray outScroll = outputScroll.toLocal8Bit();
                if(RunTheProgram) system(outScroll);
                if(ShowOutput) QMessageBox::information(this, "Scroll Distance", outputScroll);
            }

            // Tap Time Section 2
            if(ui->checkBox_taptime->isChecked()){
                QString outputTap = wac + " --set " + tabletNumberString + " TapTime " + tapResults;
                QByteArray outTap = outputTap.toLocal8Bit();
                if(RunTheProgram) system(outTap);
                if(ShowOutput) QMessageBox::information(this, "Tap Time", outputTap);
            }

            // CursorProximity Section 2
            if(ui->checkBox_proximity->isChecked()){
                QString outputProximity = wac + " --set " + tabletNumberString + " CursorProximity " + cursorResults;
                QByteArray outProx = outputProximity.toLocal8Bit();
                if(RunTheProgram) system(outProx);
                if(ShowOutput) QMessageBox::information(this, "Tap Time", outputProximity);

            }
        }
    }else{
        QString output = "Please Set the Tablet Number.";
        QMessageBox::warning(this, "Tablet Number Not Set", output);
    }


}

/*
void MainWindow::on_pushButton_list_devices_clicked()
{
    QString output;
    QProcess OProcess;
    QString Command;    //Contains the command to be executed
    QStringList args;   //Contains arguments of the command

    Command = "/usr/bin/xsetwacom";
    args<<"--list"<<"devices";

    OProcess.start(Command,args,QIODevice::ReadOnly); //Starts execution of command
    OProcess.waitForFinished();                       //Waits for execution to complete

    QString StdOut      =   OProcess.readAllStandardOutput();  //Reads standard output
    QString StdError    =   OProcess.readAllStandardError();   //Reads standard error
    QString NoError = "There were no Errors\n\r";
    QString NoOut = "There was no type of output\n\r";
    if(StdOut != NULL){
        output += StdOut;
    } else {
        output += NoOut;
    }

    if(ui->action_showOutput->isChecked()){
        if(StdError != NULL){
            output += StdError;
        } else {
            output += NoError;
        }
        output += "\r\n";
        output += "Line Number: " + QString::number(__LINE__) +"\r\n";
        output += "\r\n";
        QMessageBox::information(this, "Output", output);
        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
    }else{
        QMessageBox::information(this, "Output", output);
    }
}
*/

/*
void MainWindow::on_pushButton_current_settings_clicked()
{

//    bool gotNumber = false;
//    int Num = ui->spinBox_tabletNumber->value();
//    QString thisNumber;
//    if(Num != 0){
//        thisNumber = QString::number(Num);
//        gotNumber = true;
//    } else {
//        thisNumber = QString::number(10);
//    }
//    QString output;
//    QString outputs;
//    output = wac + "get "+thisNumber+" all";
//    if(!gotNumber){
//        outputs = "You need to set the:\r\nTablet Number ID\r\nYou can get that by clicking the button:\r\n List Devices\r\n\nThis is an example, but the ID may not be correct.\r\n\r\n";
//        outputs += output + "\r\n";
//    }
//    if(ui->action_showOutput->isChecked()) {
//        output += "\r\n";
//        output += "This Section is NOT finished\r\n";
//        output += QString::number(__LINE__) +"\r\n";
//        output += "\r\n";
//        if(gotNumber) { // so if Show Output is Checked and Table Number does not equals zero
//            QMessageBox::information(this, "Output", output);
//            //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
//        } else { // so if Show Output is Checked and Table Number equals zero
//            outputs += output;
//            QMessageBox::information(this, "Output", outputs);
//        }
//    } else {
//        if(gotNumber){ // normal run output
//            QMessageBox::information(this, "Output", output);
//        } else { // if Table Number equals zero.
//            QMessageBox::warning(this, "Output", outputs);
//        }
//    }

    QString output;
    QString outputs;
    QProcess OProcess;
    QString Command;    //Contains the command to be executed
    QStringList args;   //Contains arguments of the command

    bool gotNumber = false;
    int Num = ui->spinBox_tabletNumber->value();
    QString thisNumber;
    if(Num != 0){
        thisNumber = QString::number(Num);
        gotNumber = true;
    } else {
        thisNumber = QString::number(10);
    }

    if(!gotNumber){
        outputs = "You need to set the:\r\nTablet Number ID\r\nYou can get that by clicking the button:\r\n List Devices\r\n\nThis is an example, but the ID may not be correct.\r\n\r\n";
        outputs += output + "\r\n";
    }

   // output = wac + "get "+thisNumber+" all";
    Command = "/usr/bin/xsetwacom";
    args<<"get"<<thisNumber<<"all";

    OProcess.start(Command,args,QIODevice::ReadOnly); //Starts execution of command
    OProcess.waitForFinished();                       //Waits for execution to complete

    QString StdOut      =   OProcess.readAllStandardOutput();  //Reads standard output
    QString StdError    =   OProcess.readAllStandardError();   //Reads standard error
    QString NoError = "There were no Errors\n\r";
    QString NoOut = "There was no type of output\n\r";
    if(StdOut != NULL){
        output += StdOut;
    } else {
        output += NoOut;
    }

    if(ui->action_showOutput->isChecked()){
        if(StdError != NULL){
            output += StdError;
        } else {
            output += NoError;
        }
        output += "\r\n";
        output += "Line Number: " + QString::number(__LINE__) +"\r\n";
        output += "\r\n";
        QMessageBox::information(this, "Current Settings", output);
        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
    }else{
        QMessageBox::information(this, "Current Settings", output);
    }

}
*/
/*
void MainWindow::on_pushButton_key_modifiers_clicked()
{

//    QString output = wac + "--list modifiers";
//    if(ui->action_showOutput->isChecked()) {
//        output += "\r\n";
//        output += "This Section is NOT finished\r\n";
//        output += QString::number(__LINE__) +"\r\n";
//        output += "\r\n";
//        QMessageBox::information(this, "Output", output);
//        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
//    }else{
//        QMessageBox::information(this, "Output", output);
//    }


    QString output;
    QString outputs;
    QProcess OProcess;
    QString Command;    //Contains the command to be executed
    QStringList args;   //Contains arguments of the command



    bool gotNumber = false;
    int Num = ui->spinBox_tabletNumber->value();
    QString thisNumber;
    if(Num != 0){
        thisNumber = QString::number(Num);
        gotNumber = true;
    } else {
        thisNumber = QString::number(10);
    }

    if(!gotNumber){
        outputs = "You need to set the:\r\nTablet Number ID\r\nYou can get that by clicking the button:\r\n List Devices\r\n\nThis is an example, but the ID may not be correct.\r\n\r\n";
        outputs += output + "\r\n";
    }

   // QString output = wac + "--list modifiers";
    Command = "/usr/bin/xsetwacom";
    args<<"--list"<<"modifiers";

    OProcess.start(Command,args,QIODevice::ReadOnly); //Starts execution of command
    OProcess.waitForFinished();                       //Waits for execution to complete

    QString StdOut      =   OProcess.readAllStandardOutput();  //Reads standard output
    QString StdError    =   OProcess.readAllStandardError();   //Reads standard error
    QString NoError = "There were no Errors\n\r";
    QString NoOut = "There was no type of output\n\r";
    if(StdOut != NULL){
        output += StdOut;
    } else {
        output += NoOut;
    }

    if(ui->action_showOutput->isChecked()){
        if(StdError != NULL){
            output += StdError;
        } else {
            output += NoError;
        }
        output += "\r\n";
        output += "Line Number: " + QString::number(__LINE__) +"\r\n";
        output += "\r\n";
        QMessageBox::information(this, "Current Settings", output);
        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
    }else{
        QMessageBox::information(this, "Current Settings", output);
    }
}
*/
/*
void MainWindow::on_pushButton_list_parameters_clicked()
{

//    QString output = wac + "--list parameters";
//    if(ui->action_showOutput->isChecked()) {
//        output += "\r\n";
//        output += "This Section is NOT finished\r\n";
//        output += QString::number(__LINE__) +"\r\n";
//        output += "\r\n";
//        QMessageBox::information(this, "Output", output);
//        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
//    }else{
//        QMessageBox::information(this, "Output", output);
//    }

    QString output;
    QString outputs;
    QProcess OProcess;
    QString Command;    //Contains the command to be executed
    QStringList args;   //Contains arguments of the command

    bool gotNumber = false;
    int Num = ui->spinBox_tabletNumber->value();
    QString thisNumber;
    if(Num != 0){
        thisNumber = QString::number(Num);
        gotNumber = true;
    } else {
        thisNumber = QString::number(10);
    }

    if(!gotNumber){
        outputs = "You need to set the:\r\nTablet Number ID\r\nYou can get that by clicking the button:\r\n List Devices\r\n\nThis is an example, but the ID may not be correct.\r\n\r\n";
        outputs += output + "\r\n";
    }

   // QString output = wac + "--list parameters";
    Command = "/usr/bin/xsetwacom";
    args<<"--list"<<"parameters";

    OProcess.start(Command,args,QIODevice::ReadOnly); //Starts execution of command
    OProcess.waitForFinished();                       //Waits for execution to complete

    QString StdOut      =   OProcess.readAllStandardOutput();  //Reads standard output
    QString StdError    =   OProcess.readAllStandardError();   //Reads standard error
    QString NoError = "There were no Errors\n\r";
    QString NoOut = "There was no type of output\n\r";
    if(StdOut != NULL){
        output += StdOut;
    } else {
        output += NoOut;
    }

    if(ui->action_showOutput->isChecked()){
        if(StdError != NULL){
            output += StdError;
        } else {
            output += NoError;
        }
        output += "\r\n";
        output += "Line Number: " + QString::number(__LINE__) +"\r\n";
        output += "\r\n";
        QMessageBox::information(this, "Current Settings", output);
        //https://stackoverflow.com/questions/36710260/qt-how-to-show-linux-command-output-in-text-browser
    }else{
        QMessageBox::information(this, "Current Settings", output);
    }
}
*/
void MainWindow::on_actionSubmit_triggered()
{
    MainWindow::on_pushButton_submit_clicked();
}

void MainWindow::on_radioButton_mode_relative_clicked()
{
    // make groupBox_map2monitor invisible
    ui->groupBox_map2monitor->setVisible(false);
    ui->groupBox_proximity->setVisible(true);
}

void MainWindow::on_radioButton_mode_absolute_clicked()
{
    // make groupBox_map2monitor visible
    ui->groupBox_map2monitor->setVisible(true);
    ui->groupBox_proximity->setVisible(false);
}

void MainWindow::on_checkBox_multipleTabletNumbers_stateChanged(int arg1)
{
    if(arg1 == 0){ // not checked
        if (ui->spinBox_tabletNumber->value() <= 0) ui->spinBox_tabletNumber->setVisible(false);
        if(ui->spinBox_multiTab_1->value() <= 0) ui->spinBox_multiTab_1->setVisible(false);
        if(ui->spinBox_multiTab_2->value() <= 0) ui->spinBox_multiTab_2->setVisible(false);
        if(ui->spinBox_multiTab_3->value() <= 0) ui->spinBox_multiTab_3->setVisible(false);
        if(ui->spinBox_multiTab_4->value() <= 0) ui->spinBox_multiTab_4->setVisible(false);
        if(ui->spinBox_multiTab_5->value() <= 0) ui->spinBox_multiTab_5->setVisible(false);
        if(ui->spinBox_multiTab_6->value() <= 0) ui->spinBox_multiTab_6->setVisible(false);
        if(ui->spinBox_multiTab_7->value() <= 0) ui->spinBox_multiTab_7->setVisible(false);
    }else{ // checked
        ui->spinBox_tabletNumber->setVisible(true);
        ui->spinBox_multiTab_1->setVisible(true);
        ui->spinBox_multiTab_2->setVisible(true);
        ui->spinBox_multiTab_3->setVisible(true);
        ui->spinBox_multiTab_4->setVisible(true);
        ui->spinBox_multiTab_5->setVisible(true);
        ui->spinBox_multiTab_6->setVisible(true);
        ui->spinBox_multiTab_7->setVisible(true);
    }
}

void MainWindow::on_actionAbout_triggered()
{
//    Dialog_about about;
//    about.setModal(true);
//    about.exec();
    about = new Dialog_about(this);
    about->show();
}

void MainWindow::on_actionindex_triggered()
{
    credits = new Dialog_credits(this);
    credits->show();
}

void MainWindow::on_checkBox_touch_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "If on, touch events are reported to userland, i.e., system cursor moves when user touches the tablet. If off, touch events are ignored.\n\rDefault:  on  for devices that support touch; off for all other models.\n\r";
        QMessageBox::information(this, "Touch Help", output);
        ui->checkBox_touch->setChecked(false);
    }
}

void MainWindow::on_checkBox_buttonMode_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "If on, the stylus must be in contact with the screen for a  stylus  side button to work.\n\rIf off, stylus buttons will work once the stylus is in proximity of the tablet (regardless of  whether it  is touching the screen).\n\rDefault:  on for Tablet PCs; off for all other models.\r\n";
        QMessageBox::information(this, "Tablet PC Button Help", output);
        ui->checkBox_buttonMode->setChecked(false);
    }
}

void MainWindow::on_checkBox_thresholdlevel_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Set the minimum pressure necessary to generate  a Button  event\r\nfor  the  stylus  tip, eraser, or touch.  The pressure levels of all tablets are normalized to 2048 levels  irregardless  of  the actual hardware supported levels.\r\nThis parameter is independent of the PressureCurve parameter.\r\nDefault:  27,  range  of  0  to 2047.\r\n";
        QMessageBox::information(this, "Threshold Level Help", output);
        ui->checkBox_thresholdlevel->setChecked(false);
    }
}

void MainWindow::on_checkBox_rawsample_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Set the sample window size (a sliding average sampling window) for incoming input tool raw data points.\r\nDefault:  4, range  of 1 to 20.\r\n";
        QMessageBox::information(this, "Raw Sample Help", output);
        ui->checkBox_rawsample->setChecked(false);
    }
}

void MainWindow::on_checkBox_pressureCurve_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "If the initial pressure of a device is != 0 the  driver  recalibrates the  pressure range. This is to account for worn out devices. The downside is that when the user hits the tablet  very hard  the  initial  pressure reading may be unequal to zero even for a perfectly good pen. If the consecutive  pressure  readings are  not higher than the initial pressure by a threshold no button event will be generated.\r\nThis option allows to disable  the recalibration.\r\nDefault:  on\r\n";
        QMessageBox::information(this, "Pressure Curve Help", output);
        ui->checkBox_pressureCurve->setChecked(false);
    }
}

void MainWindow::on_checkBox_pressureRecalibration_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "If the initial pressure of a device is != 0 the  driver recalibrates  the  pressure range. This is to account for worn out devices.  The downside is that when the user hits the tablet very hard  the  initial  pressure reading may be unequal to zero even for a perfectly good pen. If the consecutive  pressure  readings are not higher than the initial pressure by a threshold no button event will be generated. This option allows to disable  the recalibration.\n\rDefault:  on\n\r";
        QMessageBox::information(this, "Pressure Recalibration Help", output);
        ui->checkBox_pressureRecalibration->setChecked(false);
    }
}

void MainWindow::on_checkBox_suppresslevel_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Set the delta (difference) cutoff level for  further  processing of  incoming input tool coordinate values.  For example a X or Y coordinate event will be sent only if  the  change  between  the current  X  or Y coordinate and the previous one is greater than the Suppress value.  The same applies to pressure level (Z coordinate) and Tilt rotation values.  With a current absolute wheel (AbsWheel) or Tilt value the delta between it and  the previous value must be equal to or greater than the Suppress value in order to be sent on.  Suppress is a tablet wide parameter. A specified delta level for one input tool is applied to all input tool coordinates. To disable suppression use a level of 0.\n\rDefault:  2, range of 0 to 100.\n\r";
        QMessageBox::information(this, "Suppress Level Help", output);
        ui->checkBox_suppresslevel->setChecked(false);
    }
}

void MainWindow::on_checkBox_taptime_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Sets the time for a double tap to be registered; time is set in milli-seconds. \n\rDefault:  250ms  \n\r";
        QMessageBox::information(this, "Double Tap Time Help", output);
        ui->checkBox_taptime->setChecked(false);
    }
}

void MainWindow::on_checkBox_scroll_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = " If Option Gesture is enabled, this option specifies the minimum movement distance before a scroll gesture is recognized.\n\r";
        QMessageBox::information(this, "Scroll Distance Help", output);
        ui->checkBox_scroll->setChecked(false);
    }
}

void MainWindow::on_checkBox_proximity_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = " sets the max distance from tablet to stop reporting movement for cursor in relative mode.\n\rDefault for Intuos series is 10, for \nGraphire series (including Volitos) is 42. \n\rOnly available for the cursor/puck device.\n\r";
        QMessageBox::information(this, "Cursor Proximity Help", output);
        ui->checkBox_proximity->setChecked(false);
    }
}

void MainWindow::on_checkBox_gesture_stateChanged(int arg1)
{
//    qDebug() << arg1;
    if(ui->checkBox_gesture->isChecked()){
        ui->checkBox_gesture->setChecked(true);
        ui->groupBox_zoom->setVisible(true);
        ui->groupBox_scroll->setVisible(true);
    }else{
        ui->checkBox_gesture->setChecked(false);
        ui->groupBox_zoom->setVisible(false);
        ui->groupBox_scroll->setVisible(false);
    }
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Enable or disable multi-finger in-driver gesture support on the device.\n\rDefault: off unless the tablet supports multi-touch.\nNote that disabling this option may allow the desktop environment to detect multi-finger gestures instead.\n\rThis function may or may not work with your tablet. \n\r";
        QMessageBox::information(this, "Gesture Help", output);
    }
}

void MainWindow::on_checkBox_zoom_stateChanged(int arg1)
{
    if(ui->actionWhat_is->isChecked() && arg1 != 0){
        QString output = "Sets the Zoom Distance that you desire.\n\rThis function may or may not work with your tablet. \n\r";
        QMessageBox::information(this, "Zoom Help", output);
        ui->checkBox_zoom->setChecked(false);
    }
}

void MainWindow::on_pushButton_submit_quit_clicked()
{
    // use the submit the quit
    MainWindow::on_pushButton_submit_clicked();
    QApplication::quit();
}

void MainWindow::on_actionHelp_Video_triggered()
{
    QString output = fire + " https://youtu.be/BTGjppn4cuQ &";
    QByteArray out = output.toLocal8Bit();
    system(out);
}
