/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.tools;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.ui.tools.ExasolExportTableToolDialog;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class ExasolExportTableTool
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, ExasolTable.class);
        List views = CommonUtils.filterCollection(objects, ExasolView.class);
        List schemas = CommonUtils.filterCollection(objects, ExasolSchema.class);
        for (ExasolSchema schema : schemas) {
            tables.addAll(schema.getTables((DBRProgressMonitor)new VoidProgressMonitor()));
        }
        HashSet<ExasolTableBase> tableBaseObjects = new HashSet<ExasolTableBase>();
        for (ExasolTable table : tables) {
            tableBaseObjects.add((ExasolTableBase)table);
        }
        for (ExasolView view : views) {
            tableBaseObjects.add((ExasolTableBase)view);
        }
        if (!tableBaseObjects.isEmpty()) {
            ExasolExportTableToolDialog dialog = new ExasolExportTableToolDialog(activePart.getSite(), tableBaseObjects);
            dialog.open();
        }
    }
}

