/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class ConnectionFolderSelector {
    private final Combo connectionFolderCombo;
    private DBPDataSourceFolder dataSourceFolder;
    private final List<DBPDataSourceFolder> connectionFolders = new ArrayList<DBPDataSourceFolder>();

    public ConnectionFolderSelector(Composite parent) {
        UIUtils.createControlLabel(parent, UIMessages.control_label_connection_folder);
        this.connectionFolderCombo = new Combo(parent, 2060);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.connectionFolderCombo) * 20;
        this.connectionFolderCombo.setLayoutData((Object)gd);
        this.connectionFolderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionFolderSelector.this.dataSourceFolder = (DBPDataSourceFolder)ConnectionFolderSelector.this.connectionFolders.get(ConnectionFolderSelector.this.connectionFolderCombo.getSelectionIndex());
            }
        });
    }

    public DBPDataSourceFolder getFolder() {
        return this.dataSourceFolder;
    }

    public void setFolder(DBPDataSourceFolder folder) {
        this.dataSourceFolder = folder;
        if (this.dataSourceFolder != null) {
            this.connectionFolderCombo.select(this.connectionFolders.indexOf(this.dataSourceFolder));
        } else {
            this.connectionFolderCombo.select(0);
        }
    }

    public void loadConnectionFolders(DBPProject project) {
        DBPDataSourceRegistry registry;
        this.connectionFolderCombo.removeAll();
        this.connectionFolderCombo.add("");
        this.connectionFolders.clear();
        this.connectionFolders.add(null);
        DBPDataSourceRegistry dBPDataSourceRegistry = registry = project == null ? null : project.getDataSourceRegistry();
        if (registry != null) {
            for (DBPDataSourceFolder folder : DBUtils.makeOrderedObjectList((Collection)registry.getRootFolders())) {
                this.loadConnectionFolder(0, folder);
            }
        }
    }

    private void loadConnectionFolder(int level, DBPDataSourceFolder folder) {
        StringBuilder prefix = new StringBuilder();
        int i = 0;
        while (i < level) {
            prefix.append("   ");
            ++i;
        }
        this.connectionFolders.add(folder);
        this.connectionFolderCombo.add(prefix + folder.getName());
        for (DBPDataSourceFolder child : DBUtils.makeOrderedObjectList((DBPNamedObject[])folder.getChildren())) {
            this.loadConnectionFolder(level + 1, child);
        }
    }
}

