/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

class ViewerColumnRegistry {
    private static final Log log = Log.getLog(ViewerColumnRegistry.class);
    private static final String COLUMNS_CONFIG_FILE = "column_settings.xml";
    private static ViewerColumnRegistry instance;
    private final Map<String, List<ColumnState>> columnsConfig = new TreeMap<String, List<ColumnState>>();
    private volatile ConfigSaver saver = null;

    public static synchronized ViewerColumnRegistry getInstance() {
        if (instance == null) {
            instance = new ViewerColumnRegistry();
        }
        return instance;
    }

    public ViewerColumnRegistry() {
        File columnsConfig = DBWorkbench.getPlatform().getConfigurationFile(COLUMNS_CONFIG_FILE);
        if (columnsConfig.exists()) {
            this.loadConfiguration(columnsConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ColumnState> getSavedConfig(String controlId) {
        Map<String, List<ColumnState>> map = this.columnsConfig;
        synchronized (map) {
            return this.columnsConfig.get(controlId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfig(String controlId, Collection<? extends ColumnState> columns) {
        Map<String, List<ColumnState>> map = this.columnsConfig;
        synchronized (map) {
            ArrayList<ColumnState> newStates = new ArrayList<ColumnState>(columns.size());
            for (ColumnState columnState : columns) {
                newStates.add(new ColumnState(columnState));
            }
            this.columnsConfig.put(controlId, newStates);
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    private void loadConfiguration(File configFile) {
        this.columnsConfig.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(configFile);){
                SAXReader parser = new SAXReader((InputStream)in);
                ColumnsParser dsp = new ColumnsParser();
                parser.parse((SAXListener)dsp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading columns configuration", (Throwable)e);
        }
    }

    public static class ColumnState {
        String name;
        boolean visible;
        int order;
        int width;

        public ColumnState() {
        }

        public ColumnState(ColumnState source) {
            this.name = source.name;
            this.visible = source.visible;
            this.order = source.order;
            this.width = source.width;
        }

        public String toString() {
            return String.valueOf(this.name) + ":" + this.order;
        }
    }

    private class ColumnsParser
    extends SAXListener.BaseListener {
        private List<ColumnState> curColumnState = null;

        private ColumnsParser() {
        }

        /*
         * Exception decompiling
         */
        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl42 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl42 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Columns configuration save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            Map map = ViewerColumnRegistry.this.columnsConfig;
            synchronized (map) {
                this.flushConfig();
                ViewerColumnRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private void flushConfig() {
            File configFile = DBWorkbench.getPlatform().getConfigurationFile(ViewerColumnRegistry.COLUMNS_CONFIG_FILE);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream out = new FileOutputStream(configFile);){
                    XMLBuilder xml = new XMLBuilder((OutputStream)out, GeneralUtils.UTF8_ENCODING);
                    xml.setButify(true);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (XMLBuilder.Element e = xml.startElement("items");){
                        for (Map.Entry entry : ViewerColumnRegistry.this.columnsConfig.entrySet()) {
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("item");){
                                xml.addAttribute("id", (String)entry.getKey());
                                for (ColumnState column : (List)entry.getValue()) {
                                    if (column.width == 0) continue;
                                    Throwable throwable4 = null;
                                    Object var17_25 = null;
                                    try (XMLBuilder.Element e3 = xml.startElement("column");){
                                        xml.addAttribute("name", column.name);
                                        xml.addAttribute("visible", column.visible);
                                        xml.addAttribute("order", column.order);
                                        xml.addAttribute("width", column.width);
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable5;
                                        } else if (throwable4 != throwable5) {
                                            throwable4.addSuppressed(throwable5);
                                        }
                                        throw throwable4;
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable3 == null) {
                                    throwable3 = throwable6;
                                } else if (throwable3 != throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                    xml.flush();
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving columns configuration", (Throwable)e);
            }
        }
    }
}

