/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class ProgressEditorPart
extends EditorPart {
    private final IDatabaseEditor ownerEditor;
    private Composite parentControl;
    private Composite progressCanvas;

    public ProgressEditorPart(IDatabaseEditor ownerEditor) {
        this.ownerEditor = ownerEditor;
    }

    public DatabaseLazyEditorInput getEditorInput() {
        return (DatabaseLazyEditorInput)super.getEditorInput();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.createProgressPane(parent);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.parentControl.setFocus();
    }

    public void setPartName(String newName) {
        super.setPartName(newName);
    }

    public void dispose() {
        super.dispose();
        this.parentControl = null;
    }

    private void createProgressPane(Composite parent) {
        this.progressCanvas = new Composite(parent, 0);
        this.progressCanvas.addPaintListener(e -> e.gc.drawText("Opening editor '" + this.getEditorInput().getName() + "'...", 5, 5, true));
        InitNodeService loadingService = new InitNodeService();
        LoadingJob loadJob = LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new InitNodeVisualizer(loadingService));
        UIExecutionQueue.queueExec(() -> ((LoadingJob)loadJob).schedule());
    }

    private void initEntityEditor(IDatabaseEditorInput result) {
        if (result == null) {
            return;
        }
        try {
            this.ownerEditor.init(this.ownerEditor.getEditorSite(), result);
            this.ownerEditor.recreateEditorControl();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Editor init", "Can't initialize editor", (Throwable)e);
        }
    }

    public Composite destroyAndReturnParent() {
        Composite parent = this.progressCanvas.getParent();
        this.progressCanvas.dispose();
        return parent;
    }

    private class InitNodeService
    extends AbstractLoadService<IDatabaseEditorInput> {
        protected InitNodeService() {
            super("Initialize entity editor");
        }

        public IDatabaseEditorInput evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                return ProgressEditorPart.this.getEditorInput().initializeRealInput(monitor);
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public Object getFamily() {
            return null;
        }
    }

    private class InitNodeVisualizer
    extends ProgressLoaderVisualizer<IDatabaseEditorInput> {
        public InitNodeVisualizer(InitNodeService loadingService) {
            super((ILoadService)loadingService, ProgressEditorPart.this.progressCanvas);
        }

        public void completeLoading(IDatabaseEditorInput result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
            ProgressEditorPart.this.initEntityEditor(result);
            if (result == null) {
                UIUtils.asyncExec(() -> {
                    boolean bl = ProgressEditorPart.this.ownerEditor.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)ProgressEditorPart.this.ownerEditor, false);
                });
            } else {
                DBWorkbench.getPlatformUI().refreshPartState((Object)ProgressEditorPart.this.ownerEditor);
            }
        }
    }
}

