/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.internal.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreTableRegular
extends PostgreTable
implements DBPReferentialIntegrityController {
    public PostgreTableRegular(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreTableRegular(DBRProgressMonitor monitor, PostgreSchema catalog, PostgreTableRegular source) throws DBException {
        super(monitor, (PostgreTableContainer)catalog, source, false);
    }

    public PostgreTableRegular(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) {
        return ((PostgreDataSource)this.getDataSource()).getServerType().supportsDisablingAllTriggers();
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        if (!this.supportsChangingReferentialIntegrity(monitor)) {
            throw new DBException("Changing referential integrity is not supported");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Disabling referential integrity");){
            try {
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement statement = session.createStatement();){
                    StringBuilder sql = new StringBuilder("ALTER TABLE ");
                    sql.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
                    if (enable) {
                        sql.append("ENABLE ");
                    } else {
                        sql.append("DISABLE ");
                    }
                    sql.append("TRIGGER ALL");
                    statement.execute(sql.toString());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException("Unable to change referential integrity", (Throwable)e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @NotNull
    public String getReferentialIntegrityDisableWarning(@NotNull DBRProgressMonitor monitor) {
        if (this.supportsChangingReferentialIntegrity(monitor)) {
            return PostgreMessages.postgre_referential_integrity_disable_warning;
        }
        return "";
    }
}

