/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;

class DataSourceStorage
implements DBPDataSourceConfigurationStorage {
    private final File sourceFile;
    private final boolean isDefault;
    private final String configSuffix;

    DataSourceStorage(File sourceFile, boolean isDefault) {
        this.sourceFile = sourceFile;
        this.isDefault = isDefault;
        if (isDefault) {
            this.configSuffix = "";
        } else {
            String configFileName = sourceFile.getName();
            this.configSuffix = configFileName.substring("data-sources".length(), configFileName.length() - ".json".length());
        }
    }

    public String getStorageId() {
        return "file://" + this.sourceFile.getAbsolutePath();
    }

    public boolean isValid() {
        return true;
    }

    public String getStatus() {
        return "Valid";
    }

    public String getName() {
        return this.sourceFile.getName();
    }

    public String getConfigurationFileSuffix() {
        return this.configSuffix;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public List<? extends DBPDataSourceContainer> loadDataSources(DBPDataSourceRegistry registry, Map<String, Object> options) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public String toString() {
        return this.sourceFile.getAbsolutePath();
    }
}

