/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.ui.SQLServerUIMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class SQLServerSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private Text keystoreHostname;
    private Button trustServerCertificate;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        this.createTrustStoreConfigGroup(composite);
        UIUtils.createControlLabel((Composite)this.sslKeyStoreComposite, (String)SQLServerUIMessages.dialog_setting_ssl_advanced_hostname_label);
        this.keystoreHostname = new Text(this.sslKeyStoreComposite, 2048);
        this.keystoreHostname.setLayoutData((Object)new GridData(768));
        this.keystoreHostname.setToolTipText(SQLServerUIMessages.dialog_setting_ssl_advanced_hostname_tip);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)1, (int)768, (int)-1);
        this.trustServerCertificate = UIUtils.createCheckbox((Composite)settingsGroup, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate, (String)SQLServerUIMessages.dialog_setting_trust_server_certificate_tip, (boolean)true, (int)2);
    }

    protected boolean isCertificatesSupported() {
        return false;
    }

    protected boolean isKeystoreSupported() {
        return true;
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        if (CommonUtils.isEmpty((String)configuration.getStringProperty("ssl.method"))) {
            this.keyStorePath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStore")));
            this.keyStorePassword.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStorePassword")));
        }
        this.keystoreHostname.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("sslKeyStoreHostname")));
        this.trustServerCertificate.setSelection(configuration.getBooleanProperty("sslTrustServerCertificate"));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.setProperty("sslKeyStoreHostname", (Object)this.keystoreHostname.getText().trim());
        configuration.setProperty("sslTrustServerCertificate", (Object)this.trustServerCertificate.getSelection());
    }
}

