/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociationLazy;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DBVEntityForeignKey
implements DBSEntityConstraint,
DBSEntityAssociationLazy,
DBSEntityReferrer,
DBSTableForeignKey {
    private static final Log log = Log.getLog(DBVEntityForeignKey.class);
    @NotNull
    private final DBVEntity entity;
    private String refEntityId;
    private String refConstraintId;
    private final List<DBVEntityForeignKeyColumn> attributes = new ArrayList<DBVEntityForeignKeyColumn>();

    public DBVEntityForeignKey(@NotNull DBVEntity entity) {
        this.entity = entity;
    }

    DBVEntityForeignKey(@NotNull DBVEntity entity, DBVEntityForeignKey copy, DBVModel targetModel) {
        this.entity = entity;
        DBPDataSourceContainer copyDS = copy.getAssociatedDataSource();
        if (copyDS == null) {
            this.refEntityId = null;
        } else if (copyDS == copy.getParentObject().getDataSourceContainer()) {
            DBPDataSourceContainer newDS = targetModel.getDataSourceContainer();
            this.refEntityId = copy.refEntityId.replace(copyDS.getId(), newDS.getId());
        } else {
            this.refEntityId = copy.refEntityId;
        }
        this.refConstraintId = copy.refConstraintId;
        for (DBVEntityForeignKeyColumn fkc : copy.attributes) {
            this.attributes.add(new DBVEntityForeignKeyColumn(this, fkc));
        }
        DBVModel.addToCache(this);
    }

    void dispose() {
        if (this.refEntityId != null) {
            DBVModel.removeFromCache(this);
            this.refEntityId = null;
            this.refConstraintId = null;
        }
    }

    @Override
    @Nullable
    public DBSEntityConstraint getReferencedConstraint() {
        try {
            return this.getRealReferenceConstraint(new VoidProgressMonitor());
        }
        catch (DBException e) {
            log.error(e);
            return null;
        }
    }

    @Override
    @NotNull
    public DBSEntityConstraint getReferencedConstraint(DBRProgressMonitor monitor) throws DBException {
        return this.getRealReferenceConstraint(monitor);
    }

    public String getRefEntityId() {
        return this.refEntityId;
    }

    public void setRefEntityId(String refEntityId) {
        this.refEntityId = refEntityId;
    }

    public String getRefConstraintId() {
        return this.refConstraintId;
    }

    public synchronized void setReferencedConstraint(String refEntityId, String refConsId) {
        if (this.refEntityId != null) {
            DBVModel.removeFromCache(this);
        }
        this.refEntityId = refEntityId;
        this.refConstraintId = refConsId;
        if (refEntityId != null) {
            DBVModel.addToCache(this);
        }
    }

    public synchronized void setReferencedConstraint(DBRProgressMonitor monitor, DBSEntityConstraint constraint) throws DBException {
        DBNDatabaseNode refNode;
        DBSEntity refEntity = constraint.getParentObject();
        if (refEntity instanceof DBVEntity) {
            refEntity = ((DBVEntity)refEntity).getRealEntity(monitor);
        }
        if ((refNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, refEntity, true)) == null) {
            log.warn("Can't find navigator node for object " + DBUtils.getObjectFullId(refEntity));
            return;
        }
        if (this.refEntityId != null) {
            DBVModel.removeFromCache(this);
        }
        this.refEntityId = refNode.getNodeItemPath();
        this.refConstraintId = constraint.getName();
        if (this.refEntityId != null) {
            DBVModel.addToCache(this);
        }
    }

    @NotNull
    public DBSEntityConstraint getRealReferenceConstraint(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.refEntityId == null) {
            throw new DBException("Ref entity ID not set for virtual FK " + this.getName());
        }
        DBNNode refNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath(monitor, this.refEntityId);
        if (!(refNode instanceof DBNDatabaseNode)) {
            throw new DBException("Can't find reference node " + this.refEntityId + " for virtual foreign key");
        }
        DBSObject object = ((DBNDatabaseNode)refNode).getObject();
        if (object instanceof DBSEntity) {
            List<DBSEntityConstraint> constraints = DBVUtils.getAllConstraints(monitor, (DBSEntity)object);
            DBSObject refEntityConstraint = DBUtils.findObject(constraints, this.refConstraintId);
            if (refEntityConstraint == null) {
                throw new DBException("Can't find constraint " + this.refConstraintId + " in entity " + this.refEntityId);
            }
            return (DBSEntityConstraint)refEntityConstraint;
        }
        throw new DBException("Object " + this.refEntityId + " is not an entity");
    }

    @Override
    public DBSEntity getAssociatedEntity() {
        DBSEntityConstraint refC = this.getReferencedConstraint();
        return refC == null ? null : refC.getParentObject();
    }

    @Override
    public DBSEntity getAssociatedEntity(DBRProgressMonitor monitor) throws DBException {
        return this.getReferencedConstraint(monitor).getParentObject();
    }

    public List<DBVEntityForeignKeyColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) throws DBException {
        return this.attributes;
    }

    public List<DBVEntityForeignKeyColumn> getAttributes() {
        return this.attributes;
    }

    public synchronized void setAttributes(List<DBVEntityForeignKeyColumn> attrs) {
        this.attributes.clear();
        this.attributes.addAll(attrs);
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public DBVEntity getParentObject() {
        return this.entity;
    }

    @NotNull
    public DBVEntity getEntity() {
        return this.entity;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.VIRTUAL_FOREIGN_KEY;
    }

    @Override
    @NotNull
    public String getName() {
        return String.valueOf(this.getConstraintType().getId()) + "_" + this.entity.getName() + "_" + (this.refEntityId == null ? "?" : DBNUtils.getLastNodePathSegment(this.refEntityId));
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    @Override
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    public DBPDataSourceContainer getAssociatedDataSource() {
        if (this.refEntityId == null) {
            return null;
        }
        DBNDataSource dsNode = DBWorkbench.getPlatform().getNavigatorModel().getDataSourceByPath(this.getParentObject().getProject(), this.refEntityId);
        return dsNode == null ? null : dsNode.getDataSourceContainer();
    }

    public String toString() {
        return "VFK: " + this.entity.getName() + "->" + this.refEntityId + "." + this.refConstraintId + " (" + this.attributes + ")";
    }
}

