/***************************************************************
 * Name:      holiday.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef HOLIDAY_H
#define	HOLIDAY_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

class Holiday {
public:
    Holiday();
    Holiday(wxInt64 id, const wxString &name, int day, wxDateTime::Month month, int reminded, bool easternMonday=false, bool easternFriday=false);
    virtual ~Holiday();

    bool isValid() const { return m_id != -1; }
    int day() const;
    void setDay(int day);
    wxDateTime::Month month() const;
    void setMonth(const wxDateTime::Month &month);
    wxString name() const;
    void setName(const wxString &name);
    int reminded() const;
    void setReminded(int reminded);
    bool easternMonday() const;
    void setEasternMonday(bool easternMonday);
    bool easternFriday() const;
    void setEasternFriday(bool easternFriday);
    wxInt64 id() const;
    void setId(const wxInt64 &id);
private:
    wxInt64 m_id;
    wxString m_name;
    int m_day;
    wxDateTime::Month m_month;
    int m_reminded;
    bool m_easternMonday;
    bool m_easternFriday;
};

#endif	/* HOLIDAY_H */

