/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComponentState {
    DISABLED_ACTIVE(ColorSchemeKind.DISABLED, 0, false, false, false),
    ACTIVE(ColorSchemeKind.CURRENT, 0, false, true, false),
    DISABLED_SELECTED(ColorSchemeKind.DISABLED, 10, true, false, false),
    DISABLED_UNSELECTED(ColorSchemeKind.DISABLED, 0, false, false, false),
    PRESSED_SELECTED(ColorSchemeKind.CURRENT, 5, true, true, true),
    PRESSED_UNSELECTED(ColorSchemeKind.CURRENT, 8, false, true, true),
    SELECTED(ColorSchemeKind.CURRENT, 8, true, true, false),
    ROLLOVER_SELECTED(ColorSchemeKind.CURRENT, 4, true, true, true),
    ROLLOVER_UNSELECTED(ColorSchemeKind.CURRENT, 3, false, true, true),
    DEFAULT(ColorSchemeKind.REGULAR, 0, false, true, false);

    private ColorSchemeKind colorSchemeKind;
    private int cycleCount;
    private boolean isSelected;
    private boolean isEnabled;
    private boolean isRollover;

    private ComponentState(ColorSchemeKind kind, int count, boolean isSelected, boolean isEnabled, boolean isRollover) {
        this.colorSchemeKind = kind;
        this.cycleCount = count;
        this.isSelected = isSelected;
        this.isEnabled = isEnabled;
        this.isRollover = isRollover;
    }

    public ColorSchemeKind getColorSchemeKind() {
        return this.colorSchemeKind;
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isRollover() {
        return this.isRollover;
    }

    public static ComponentState getState(ButtonModel model, AbstractButton button) {
        JButton jb;
        if (button != null && button instanceof JButton && (jb = (JButton)button).isDefaultButton()) {
            if (model.isEnabled()) {
                if (!model.isPressed() && !model.isArmed()) {
                    return ACTIVE;
                }
            } else {
                return DISABLED_ACTIVE;
            }
        }
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (model.isPressed() && model.isArmed()) {
            if (model.isSelected()) {
                return PRESSED_SELECTED;
            }
            return PRESSED_UNSELECTED;
        }
        if (model.isSelected()) {
            if ((button == null || button.isRolloverEnabled()) && model.isRollover()) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if ((button == null || button.isRolloverEnabled()) && model.isRollover()) {
            return ROLLOVER_UNSELECTED;
        }
        return DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorSchemeKind {
        CURRENT,
        REGULAR,
        DISABLED;

    }
}

