[![Build Status](https://travis-ci.org/LibVNC/x11vnc.svg?branch=master)](https://travis-ci.org/LibVNC/x11vnc)

This is x11vnc with its development continued by LibVNC and the GitHub community.
While 0.9.13 was the last release by the original author Karl Runge, 0.9.14 was
the first community-based release here on GitHub.

This repo represents the x11vnc codebase that once resided in the LibVNCServer repo.
It was split off LibVNCServer and moved here with
https://github.com/LibVNC/libvncserver/commit/498d222976975f53dea885cfe43ef0f805abd412.

Copyright (C) 2002-2010 Karl J. Runge <runge@karlrunge.com>
All rights reserved.

x11vnc README file                         Date: Mon Dec 27 20:58:57 EST 2010

The following information is taken from these URLs:

	http://www.karlrunge.com/x11vnc/index.html
	http://www.karlrunge.com/x11vnc/x11vnc_opts.html
	...

they contain the most up to date info.

	
http://www.karlrunge.com/x11vnc/index.html:


# x11vnc: a VNC server for real X displays

   x11vnc allows one to view remotely and interact with real X displays
   (i.e. a display corresponding to a physical monitor, keyboard, and
   mouse) with any VNC viewer. In this way it plays the role for Unix/X11
   that WinVNC plays for Windows.

   It has built-in SSL/TLS encryption and 2048 bit RSA authentication,
   including VeNCrypt support; UNIX account and password login support;
   server-side scaling; single port HTTPS/HTTP+VNC; Zeroconf service
   advertising; and TightVNC and UltraVNC file-transfer. It has also been
   extended to work with non-X devices: natively on Mac OS X Aqua/Quartz,
   webcams and TV tuner capture devices, and embedded Linux systems such
   as Qtopia Core. Full IPv6 support is provided. More features are
   described here.

   It also provides an encrypted Terminal Services mode (-create, -svc,
   or -xdmsvc options) based on Unix usernames and Unix passwords where
   the user does not need to memorize his VNC display/port number.
   Normally a virtual X session (Xvfb) is created for each user, but it
   also works with X sessions on physical hardware. See the tsvnc
   terminal services mode of the SSVNC viewer for one way to take
   advantage of this mode.

   I wrote x11vnc back in 2002 because x0rfbserver was basically
   impossible to build on Solaris and had poor performance. The primary
   x0rfbserver build problems centered around esoteric C++ toolkits.
   x11vnc is written in plain C and needs only standard libraries and so
   should work on nearly all Unixes, even very old ones. I also created
   enhancements to improve the interactive response, added many features,
   and etc.

   This page including the FAQ contains much information [*]; solutions
   to many problems; and interesting applications, but nevertheless
   please feel free to contact me if you have problems or questions (and
   if I save you time or expense by giving you some of my time, please
   consider a PayPal Donation.) Do check the FAQ and this page first; I
   realize the pages are massive, but you can often use your browser's
   find-in-page search action using a keyword to find the answer to your
   problem or question.

   SSVNC:  An x11vnc side-project provides an Enhanced TightVNC Viewer
   package (SSVNC) for Unix, Windows, and Mac OS X with automatic SSL
   and/or SSH tunnelling support, SSL Certificate creation, Saved
   connection profiles, Zeroconf, VeNCrypt, and built-in Proxy support.
   Added features for the TightVNC Unix viewer: NewFBSize, ZRLE encoding,
   Viewer-side Scaling, cursor alphablending, low color modes, and
   enhanced popup menu; UltraVNC extensions support for: File Transfer,
   Text Chat, Single Window, Server Input, and 1/n Scaling extensions,
   and UltraVNC DSM encryption. The SSVNC bundle could be placed on, say,
   a USB memory stick for SSL/SSH VNC viewing from nearly any networked
   computer.


#   Announcements:

   Important: If you created any permanent SSL certificates (e.g. via
   "x11vnc -ssl SAVE ...") on a Debian or Ubuntu system from Sept. 2006
   through May 2008, then those keys are likely extremely weak and can be
   easily cracked. The certificate files should be deleted and recreated
   on a non-Debian system or an updated one. See
   http://www.debian.org/security/2008/dsa-1571 for details. The same
   applies to SSH keys (not used by x11vnc directly, but many people use
   SSH tunnels for VNC access.)

   FAQ moved: The huge FAQ has finally been moved to its own page. If you
   are trying to follow someone's link to an FAQ once on this page it is
   now a broken link. Try inserting the string "faq.html", e.g.:
from:   http://www.karlrunge.com/x11vnc/#faq-singleclick
to:     http://www.karlrunge.com/x11vnc/faq.html#faq-singleclick

   Apologies for the inconvenience, unfortunately it is not possible to
   automatically redirect to the new page since the '#' anchor is not
   sent to the webserver.


#   Background:

   VNC (Virtual Network Computing) is a very useful network graphics
   protocol (applications running on one computer but displaying their
   windows on another) in the spirit of X, however, unlike X, the
   viewing-end is very simple and maintains no state. It is a remote
   framebuffer (RFB) protocol.

   Some VNC links:

   * http://www.realvnc.com
   * http://www.tightvnc.com
   * http://www.ultravnc.com/
   * http://www.testplant.com/products/vine_server/OS_X

   For Unix, the traditional VNC implementation includes a "virtual" X11
   server Xvnc (usually launched via the vncserver command) that is not
   associated with a physical display, but provides a "fake" one X11
   clients (xterm, firefox, etc.) can attach to. A remote user then
   connects to Xvnc via the VNC client vncviewer from anywhere on the
   network to view and interact with the whole virtual X11 desktop.

   The VNC protocol is in most cases better suited for remote connections
   with low bandwidth and high latency than is the X11 protocol because
   it involves far fewer "roundtrips" (an exception is the cached pixmap
   data on the viewing-end provided by X.) Also, with no state maintained
   the viewing-end can crash, be rebooted, or relocated and the
   applications and desktop continue running. Not so with X11.

   So the standard Xvnc/vncserver program is very useful, I use it for
   things like:

   * Desktop conferencing with other users (e.g. code reviews.)
   * Long running apps/tasks I want to be able to view from many places
     (e.g. from home and work.)
   * Motif, GNOME, and similar applications that would yield very poor
     performance over a high latency link.

   However, sometimes one wants to connect to a real X11 display (i.e.
   one attached to a physical monitor, keyboard, and mouse: a Workstation
   or a SunRay session) from far away. Maybe you want to close down an
   application cleanly rather than using kill, or want to work a bit in
   an already running application, or would like to help a distant
   colleague solve a problem with their desktop, or would just like to
   work out on the deck for a while. This is where x11vnc is useful.

#   How to use x11vnc:

   In this basic example let's assume the remote machine with the X
   display you wish to view is "far-away.east:0" and the workstation you
   are presently working at is "sitting-here.west".

   Step 0. Download x11vnc (see below) and have it available to run on
   far-away.east (on some linux distros it is as easy as "apt-get install
   x11vnc", "emerge x11vnc", etc.) Similarly, have a VNC viewer (e.g.
   vncviewer) ready to run on sitting-here.west. We recommend TightVNC
   Viewers (see also our SSVNC viewer.)

   Step 1. By some means log in to far-away.east and get a command shell
   running there. You can use ssh, or even rlogin, telnet, or any other
   method to do this. We do this because the x11vnc process needs to be
   run on the same machine the X server process is running on (otherwise
   things would be extremely slow.)

   Step 2. In that far-away.east shell (with command prompt "far-away>"
   in this example) run x11vnc directed at the far-away.east X session
   display:

  ```
  far-away> x11vnc -display :0
  ```

   You could have also set the environment variable DISPLAY=:0 instead of
   using "-display :0". This step attaches x11vnc to the far-away.east:0
   X display (i.e. no viewer clients yet.)

   Common Gotcha: To get X11 permissions right, you may also need to set
   the XAUTHORITY environment variable (or use the -auth option) to point
   to the correct MIT-MAGIC-COOKIE file (e.g. /home/joe/.Xauthority.) If
   x11vnc does not have the authority to connect to the display it exits
   immediately. More on how to fix this below.

   If you suspect an X11 permissions problem do this simple test: while
   sitting at the physical X display open a terminal window
   (gnome-terminal, xterm, etc.) You should be able to run x11vnc
   successfully in that terminal without any need for command line
   options. If that works OK then you know X11 permissions are the only
   thing preventing it from working when you try to start x11vnc via a
   remote shell. Then fix this with the tips below.

   Note as of Feb/2007 you can also try the -find option instead of
   "-display ..." and see if that finds your display and Xauthority. Note
   as of Dec/2009 the -findauth and "-auth guess" options may be helpful
   as well.
   (End of Common Gotcha)

   When x11vnc starts up there will then be much chatter printed out (use
   "-q" to quiet it), until it finally says something like:

  ```
  .
  .
  13/05/2004 14:59:54 Autoprobing selected port 5900
  13/05/2004 14:59:54 screen setup finished.
  13/05/2004 14:59:54
  13/05/2004 14:59:54 The VNC desktop is far-away:0
  PORT=5900
  ```

   which means all is OK, and we are ready for the final step.

   Step 3. At the place where you are sitting (sitting-here.west in this
   example) you now want to run a VNC viewer program. There are VNC
   viewers for Unix, Windows, MacOS, Java-enabled web browsers, and even
   for PDA's like the Palm Pilot and Cell Phones! You can use any of them
   to connect to x11vnc (see the above VNC links under "Background:" on
   how to obtain a viewer for your platform or see this FAQ. For Solaris,
   vncviewer is available in the Companion CD package SFWvnc.)

   In this example we'll use the Unix vncviewer program on sitting-here
   by typing the following command in a second terminal window:

  ```
  sitting-here> vncviewer far-away.east:0
  ```

   That should pop up a viewer window on sitting-here.west showing and
   allowing interaction with the far-away.east:0  X11 desktop. Pretty
   nifty! When finished, exit the viewer: the remote x11vnc process will
   shutdown automatically (or you can use the -forever option to have it
   wait for additional viewer connections.)

   Common Gotcha: Nowadays there will likely be a host-level firewall on
   the x11vnc side that is blocking remote access to the VNC port (e.g.
   5900.) You will either have to open up that port (or a range of ports)
   in your firewall administration tool, or try the SSH tunnelling method
   below (even still the firewall must allow in the SSH port, 22.)


   Shortcut: Of course if you left x11vnc running on far-away.east:0 in a
   terminal window with the -forever option or as a service, you'd only
   have to do Step 3 as you moved around. Be sure to use a VNC Password
   or other measures if you do that.


   Super Shortcut: Here is a potentially very easy way to get all of it
   working.

   * Have x11vnc (0.9.3 or later) available to run on the remote host
     (i.e. in $PATH.)
   * Download and unpack a SSVNC bundle (1.0.19 or later, e.g.
     ssvnc_no_windows-1.0.28.tar.gz) on the Viewer-side machine.
   * Start the SSVNC Terminal Services mode GUI: ./ssvnc/bin/tsvnc
   * Enter your remote username@hostname (e.g. fred@far-away.east) in
     the "VNC Terminal Server" entry.
   * Click "Connect".

   That will do an SSH to username@hostname and start up x11vnc and then
   connect a VNC Viewer through the SSH encrypted tunnel.

   There are a number of things assumed here, first that you are able to
   SSH into the remote host; i.e. that you have a Unix account there and
   the SSH server is running. On Unix and MacOS X it is assumed that the
   ssh client command is available on the local machine (on Windows a
   plink binary is included in the SSVNC bundle.) Finally, it is assumed
   that you are already logged into an X session on the remote machine,
   e.g. your workstation (otherwise, a virtual X server, e.g. Xvfb, will
   be started for you.)

   In some cases the remote SSH server will not run commands with the
   same $PATH that you normally have in your shell there. In this case
   click on Options -> Advanced -> X11VNC Options, and type in the
   location of the x11vnc binary under "Full Path". (End of Super
   Shortcut)


   Desktop Sharing: The above more or less assumed nobody was sitting at
   the workstation display "far-away.east:0". This is often the case: a
   user wants to access her workstation remotely. Another usage pattern
   has the user sitting at "far-away.east:0" and invites one or more
   other people to view and interact with his desktop. Perhaps the user
   gives a demo or presentation this way (using the telephone for vocal
   communication.) A "Remote Help Desk" mode would be similar: a
   technician connects remotely to the user's desktop to interactively
   solve a problem the user is having.

   For these cases it should be obvious how it is done. The above steps
   will work, but more easily the user sitting at far-away.east:0 simply
   starts up x11vnc from a terminal window, after which the guests would
   start their VNC viewers. For this usage mode the "-connect
   host1,host2" option may be of use to automatically connect to the
   vncviewers in "-listen" mode on the list of hosts.

#   Tunnelling x11vnc via SSH:

   The above example had no security or privacy at all. When logging into
   remote machines (certainly when going over the internet) it is best to
   use ssh, or use a VPN (for a VPN, Virtual Private Network, the above
   example should be pretty safe.)

   For x11vnc one can tunnel the VNC protocol through an encrypted ssh
   channel. It would look something like running the following commands:

  ```
  sitting-here> ssh -t -L 5900:localhost:5900 far-away.east 'x11vnc -localhost
-display :0'
  ```

   (you will likely have to provide passwords/passphrases to login from
   sitting-here into your far-away.east Unix account; we assume you have
   a login account on far-away.east and it is running the SSH server)

   And then in another terminal window on sitting-here run the command:

  ```
  sitting-here> vncviewer -encodings "copyrect tight zrle hextile" localhost:0
  ```

   Note: The -encodings option is very important: vncviewer will often
   default to "raw" encoding if it thinks the connection is to the local
   machine, and so vncviewer gets tricked this way by the ssh
   redirection. "raw" encoding will be extremely slow over a networked
   link, so you need to force the issue with -encodings "copyrect tight
   ...". Nowadays, not all viewers use the -encodings option, try
   "-PreferredEncoding=ZRLE" (although the newer viewers seem to
   autodetect well when to use raw or not.)

   Note that "x11vnc -localhost ..." limits incoming vncviewer
   connections to only those from the same machine. This is very natural
   for ssh tunnelling (the redirection appears to come from the same
   machine.) Use of a VNC password is also strongly recommended.

   Note also the -t we used above (force allocate pseudoterminal), it
   actually seems to improve interactive typing response via VNC!

   You may want to add the -C option to ssh to enable compression. The
   VNC compression is not perfect, and so this may help a bit. However,
   over a fast LAN you probably don't want to enable SSH compression
   because it can slow things down. Try both and see which is faster.

   If your username is different on the remote machine use something
   like: "fred@far-away.east" in the above ssh command line.

   Some VNC viewers will do the ssh tunnelling for you automatically, the
   TightVNC Unix vncviewer does this when the "-via far-away.east" option
   is supplied to it (this requires x11vnc to be already running on
   far-away.east or having it started by inetd(8).) See the 3rd script
   example below for more info.

   SSVNC:  You may also want to look at the Enhanced TightVNC Viewer
   (ssvnc) bundles because they contain scripts and GUIs to automatically
   set up SSH tunnels (e.g. the GUI, "ssvnc", does it automatically and
   so does this command: "ssvnc_cmd -ssh user@far-away.east:0") and can
   even start up x11vnc as well.

   The Terminal Services mode of SSVNC is perhaps the easiest way to use
   x11vnc. You just need to have x11vnc available in $PATH on the remote
   side (and can SSH to the host), and then on the viewer-side you type
   something like:

  ```
  tsvnc fred@far-away.east
  ```

   everything else is done automatically for you. Normally this will
   start a virtual Terminal Services X session (RAM-only), but if you
   already have a real X session up on the physical hardware it will find
   that one for you.

   Gateways:  If the machine you SSH into is not the same machine with
   the X display you wish to view (e.g. your company provides incoming
   SSH access to a gateway machine), then you need to change the above
   to, e.g.: "-L 5900:OtherHost:5900":

  ```
  sitting-here> ssh -t -L 5900:OtherHost:5900 gateway.east
  ```

   Where gateway.east is the internet hostname (or IP) of the gateway
   machine (SSH server.) 'OtherHost' might be, e.g., freds-pc or
   192.168.2.33 (it is OK for these to be private hostnames or private IP
   addresses, the host in -L is relative to the remote server side.)

   Once logged in, you'll need to do a second login (ssh, rsh, etc.) to
   the workstation machine 'OtherHost' and then start up x11vnc on it (if
   it isn't already running.) (The "-connect gateway:59xx" option may be
   another alternative here with the viewer already in -listen mode.) For
   an automatic way to use a gateway and have all the network traffic
   encrypted (including inside the firewall) see Chaining SSH's.

   These gateway access modes also can be done automatically for you via
   the "Proxy/Gateway" setting in SSVNC (including the Chaining SSH's
   case, "Double Proxy".)

   Firewalls/Routers:

   A lot of people have inexpensive devices for home or office that act
   as a Firewall and Router to the machines inside on a private LAN. One
   can usually configure the Firewall/Router from inside the LAN via a
   web browser.

   Often having a Firewall/Router sitting between the vncviewer and
   x11vnc will make it impossible for the viewer to connect to x11vnc.

   One thing that can be done is to redirect a port on the
   Firewall/Router to, say, the SSH port (22) on an inside machine (how
   to do this depends on your particular Firewall/Router, often the
   router config URL is http://192.168.100.1 See www.portforward.com for
   more info.) This way you reach these computers from anywhere on the
   Internet and use x11vnc to view X sessions running on them.

   Suppose you configured the Firewall/Router to redirect these ports to
   two internal machines:

  ```
  Port 12300 -> 192.168.1.3, Port 22 (SSH)
  Port 12301 -> 192.168.1.4, Port 22 (SSH)

   (where 192.168.1.3 is "jills-pc" and 192.168.1.4 is "freds-pc".) Then
   the ssh's would look something like:
  sitting-here> ssh -t -p 12300 -L 5900:localhost:5900 jill@far-away.east 'x11v
nc -localhost -display :0'
  sitting-here> ssh -t -p 12301 -L 5900:localhost:5900 fred@far-away.east 'x11v
nc -localhost -display :0'
  ```

   Where far-away.east means the hostname (or IP) that the
   Router/Firewall is using (for home setups this is usually the IP
   gotten from your ISP via DHCP, the site http://www.whatismyip.com/ is
   a convenient way to determine what it is.)

   It is a good idea to add some obscurity to accessing your system via
   SSH by using some high random port (e.g. 12300 in the above example.)
   If you can't remember it, or are otherwise not worried about port
   scanners detecting the presence of your SSH server and there is just
   one internal PC involved you could map 22:

  ```
  Port 22 -> 192.168.1.3, Port 22 (SSH)
  ```

   Again, this SSH gateway access can be done automatically for you via
   the "Proxy/Gateway" setting in SSVNC. And under the "Remote SSH
   Command" setting you can enter the x11vnc -localhost -display :0.

   Host-Level-Firewalls: even with the hardware Firewall/Router problem
   solved via a port redirection, most PC systems have their own Host
   level "firewalls" enabled to protect users from themselves. I.e. the
   system itself blocks all incoming connections. So you will need to see
   what is needed to configure it to allow in the port (e.g. 22) that you
   desire. E.g. Yast, Firestarter, iptables(1), etc..

   VNC Ports and Firewalls: The above discussion was for configuring the
   Firewall/Router to let in port 22 (SSH), but the same thing can be
   done for the default VNC port 5900:

  ```
  Port 5900 -> 192.168.1.3, Port 5900 (VNC)
  Port 5901 -> 192.168.1.4, Port 5900 (VNC)
  ```

   (where 192.168.1.3 is "jills-pc" and 192.168.1.4 is "freds-pc".) This
   could be used for normal, unencrypted connections and also for SSL
   encrypted ones.

   The VNC displays to enter in the VNC viewer would be, say,
   "far-away.east:0" to reach jills-pc and "far-away.east:1" to reach
   freds-pc. We assume above that x11vnc is using port 5900 (and any
   Host-Level-firewalls on jills-pc has been configured to let that port
   in.) Use the "-rfbport" option to tell which port x11vnc should listen
   on.

   For a home system one likely does not have a hostname and would have
   to use the IP address, say, "24.56.78.93:0". E.g.:

  ```
  vncviewer 24.56.78.93:0
  ```

   You may want to choose a more obscure port on the router side, e.g.
   5944, to avoid a lot of port scans finding your VNC server. For 5944
   you would tell the viewer to use:

  ```
  vncviewer 24.56.78.93:44
  ```

   The IP address would need to be communicated to the person running the
   VNC Viewer. The site http://www.whatismyip.com/ can help here.


   Scripts to automate ssh tunneling: As discussed below, there may be
   some problems with port 5900 being available. If that happens, the
   above port and display numbers may change a bit (e.g. -> 5901 and :1).
   However, if you "know" port 5900 will be free on the local and remote
   machines, you can easily automate the above two steps by using the
   x11vnc option -bg (forks into background after connection to the
   display is set up) or using the -f option of ssh. Some example scripts
   are shown below. Feel free to try the ssh -C to enable its compression
   and see if that speeds things up noticeably.

   #1. A simple example script, assuming no problems with port 5900 being
   taken on the local or remote sides, looks like:
  ```
#!/bin/sh
# usage: x11vnc_ssh <host>:<xdisplay>
#  e.g.: x11vnc_ssh snoopy.peanuts.com:0
#  (user@host:N also works)

host=`echo $1 | awk -F: '{print $1}'`
disp=`echo $1 | awk -F: '{print $2}'`
if [ "x$disp" = "x" ]; then disp=0; fi

cmd="x11vnc -display :$disp -localhost -rfbauth .vnc/passwd"
enc="copyrect tight zrle hextile zlib corre rre raw"

ssh -f -t -L 5900:localhost:5900 $host "$cmd"

for i in 1 2 3
do
        sleep 2
        if vncviewer -encodings "$enc" :0; then break; fi
done
  ```

   See also rx11vnc.pl below.

   #2. Another method is to start the VNC viewer in listen mode
   "vncviewer -listen" and have x11vnc initiate a reverse connection
   using the -connect option:

  ```
#!/bin/sh
# usage: x11vnc_ssh <host>:<xdisplay>
#  e.g.: x11vnc_ssh snoopy.peanuts.com:0
#  (user@host:N also works)

host=`echo $1 | awk -F: '{print $1}'`
disp=`echo $1 | awk -F: '{print $2}'`
if [ "x$disp" = "x" ]; then disp=0; fi

cmd="x11vnc -display :$disp -localhost -connect localhost"   # <== note new opt
ion
enc="copyrect tight zrle hextile zlib corre rre raw"

vncviewer -encodings "$enc" -listen &
pid=$!
ssh -t -R 5500:localhost:5500 $host "$cmd"
kill $pid
  ```

   Note the use of the ssh option "-R" instead of "-L" to set up a remote
   port redirection.

   #3. A third way is specific to the TightVNC vncviewer special option
   -via for gateways. The only tricky part is we need to start up x11vnc
   and give it some time (5 seconds in this example) to start listening
   for connections (so we cannot use the TightVNC default setting for
   VNC_VIA_CMD):

  ```
#!/bin/sh
# usage: x11vnc_ssh <host>:<xdisplay>
#  e.g.: x11vnc_ssh snoopy.peanuts.com:0

host=`echo $1 | awk -F: '{print $1}'`
disp=`echo $1 | awk -F: '{print $2}'`
if [ "x$disp" = "x" ]; then disp=0; fi

VNC_VIA_CMD="ssh -f -t -L %L:%H:%R %G x11vnc -localhost -rfbport 5900 -display
:$disp; sleep 5"
export VNC_VIA_CMD

vncviewer -via $host localhost:0      # must be TightVNC vncviewer.
  ```

   Of course if you already have the x11vnc running waiting for
   connections (or have it started out of inetd(8)), you can simply use
   the TightVNC "vncviewer -via gateway host:port" in its default mode to
   provide secure ssh tunnelling.



   VNC password file: Also note in the #1. example script that the option
   "-rfbauth .vnc/passwd" provides additional protection by requiring a
   VNC password for every VNC viewer that connects. The vncpasswd or
   storepasswd programs, or the x11vnc -storepasswd option can be used to
   create the password file. x11vnc also has the slightly less secure
   -passwdfile and "-passwd XXXXX" options to specify passwords.

   Very Important: It is up to YOU to tell x11vnc to use password
   protection (-rfbauth or -passwdfile), it will NOT do it for you
   automatically or force you to (use -usepw if you want to be forced
   to.) The same goes for encrypting the channel between the viewer and
   x11vnc: it is up to you to use ssh, stunnel, -ssl mode, a VPN, etc.
   (use the Enhanced TightVNC Viewer (SSVNC) GUI if you want to be forced
   to use SSL or SSH.) For additional safety, also look into the -allow
   and -localhost options and building x11vnc with tcp_wrappers support
   to limit host access.


#   Tunnelling x11vnc via SSL/TLS:

   One can also encrypt the VNC traffic using an SSL/TLS tunnel such as
   stunnel.mirt.net (also stunnel.org) or using the built-in (Mar/2006)
   -ssl openssl mode. A SSL-enabled Java applet VNC Viewer is also
   provided in the x11vnc package (and https can be used to download it.)

   Although not as ubiquitous as ssh, SSL tunnelling still provides a
   useful alternative. See this FAQ on -ssl and -stunnel modes for
   details and examples.

   The Enhanced TightVNC Viewer (SSVNC) bundles contain some convenient
   utilities to automatically set up an SSL tunnel from the viewer-side
   (i.e. to connect to "x11vnc -ssl ...".) And many other enhancements
   too.

#   Downloading x11vnc:

   x11vnc is a contributed program to the LibVNCServer project at
   SourceForge.net. I use libvncserver for all of the VNC aspects; I
   couldn't have done without it. The full source code may be found and
   downloaded (either file-release tarball or GIT tree) from the above
   link. As of Sep 2010, the x11vnc-0.9.12.tar.gz source package is
   released (recommended download). The x11vnc 0.9.12 release notes.

   The x11vnc package is the subset of the libvncserver package needed to
   build the x11vnc program. Also, you can get a copy of my latest,
   bleeding edge x11vnc-0.9.13-dev.tar.gz tarball to build the most up to
   date one.

   Precompiled Binaries/Packages:  See the FAQ below for information
   about where you might obtain a precompiled x11vnc binary from 3rd
   parties and some ones I create.

   VNC Viewers:  To obtain VNC viewers for the viewing side (Windows, Mac
   OS, or Unix) try these links:

   * http://www.tightvnc.com/download.html
   * http://www.realvnc.com/download-free.html
   * http://sourceforge.net/projects/cotvnc/
   * http://www.ultravnc.com/
   * Our Enhanced TightVNC Viewer (SSVNC)

       [ssvnc.gif]


   More tools: Here is a ssh/rsh wrapper script rx11vnc that attempts to
   automatically do the above Steps 1-3 for you (provided you have
   ssh/rsh login permission on the machine x11vnc is to be run on.) The
   above example would be: "rx11vnc far-away.east:0" typed into a shell
   on sitting-here.west. Also included is an experimental script
   rx11vnc.pl that attempts to tunnel the vnc traffic through an ssh port
   redirection (and does not assume port 5900 is free.) Have a look at
   them to see what they do and customize as needed:

   * rx11vnc wrapper script
   * rx11vnc.pl wrapper script to tunnel traffic thru ssh


#   Building x11vnc:

   Make sure you have all the needed build/compile/development packages
   installed. On a Debian-based distro you can simply do

   ```
   sudo apt-get build-dep x11vnc
   ```

   to install most of them.

   To generate the build system, do a

   ```
   autoreconf -fiv
   ```

   After that, it's the usual

   ```
   ./configure
   make
   ```

   You might want to take a look at the dfferent configure options
   provided by `configure --help` to build without X11 or adapt the
   build to your needs in other ways.

   Building on Solaris, FreeBSD, etc:   Depending on your version of
   Solaris or other Unix OS the jpeg and/or zlib libraries may be in
   non-standard places (e.g. /usr/local, /usr/sfw, /opt/sfw, etc.)

   Note: If configure cannot find these two libraries then TightVNC and
   ZRLE encoding support will be disabled, and you don't want that!!! The
   TightVNC encoding gives very good compression and performance, it even
   makes a noticeable difference over a fast LAN.


   Shortcuts: On Solaris 10 you can pick up almost everything just by
   insuring that your PATH has /usr/sfw/bin (for gcc) and /usr/ccs/bin
   (for other build tools), e.g.:

  ```
  env PATH=/usr/sfw/bin:/usr/ccs/bin:$PATH sh -c './configure; make'
  ```

   (The only thing this misses is /usr/X11/lib/libXrandr.so.2, which is
   for the little used -xrandr option, see the script below to pick it up
   as well.)


   libjpeg is included in Solaris 9 and later (/usr/sfw/include and
   /usr/sfw/lib), and zlib in Solaris 8 and later (/usr/include and
   /usr/lib.) So on Solaris 9 you can pick up everything with something
   like this:

  ```
  env PATH=/usr/local/bin:/usr/ccs/bin:$PATH sh -c './configure --with-jpeg=/us
r/sfw; make'
  ```

   assuming your gcc is in /usr/local/bin and x11vnc 0.7.1 or later.
   These are getting pretty long, see those assignments split up in the
   build script below.


   If your system does not have these libraries at all you can get the
   source for the libraries to build them: libjpeg is available at
   ftp://ftp.uu.net/graphics/jpeg/ and zlib at http://www.gzip.org/zlib/.
   See also http://www.sunfreeware.com/ for Solaris binary packages of
   these libraries as well as for gcc. Normally they will install into
   /usr/local but you can install them anywhere with the
   --prefix=/path/to/anywhere, etc.


   Here is a build script that indicates one way to pass the library
   locations information to the libvncserver configuration via the
   CPPFLAGS and LDFLAGS environment variables.

  ```
#!/bin/sh

# Build script for Solaris, etc, with gcc, libjpeg and libz in
# non-standard locations.

# set to get your gcc, etc:
#
PATH=/path/to/gcc/bin:/usr/ccs/bin:/usr/sfw/bin:$PATH

JPEG=/path/to/jpeg      # set to maybe "/usr/local", "/usr/sfw", or "/opt/sfw"
ZLIB=/path/to/zlib      # set to maybe "/usr/local", "/usr/sfw", or "/opt/sfw"

# Below we assume headers in $JPEG/include and $ZLIB/include and the
# shared libraries are in $JPEG/lib and $ZLIB/lib.  If your situation
# is different change the locations in the two lines below.
#
CPPFLAGS="-I $JPEG/include -I $ZLIB/include"
LDFLAGS="-L$JPEG/lib -R $JPEG/lib -L$ZLIB/lib -R $ZLIB/lib"

# These two lines may not be needed on more recent Solaris releases:
#
CPPFLAGS="$CPPFLAGS -I /usr/openwin/include"
LDFLAGS="$LDFLAGS -L/usr/openwin/lib -R /usr/openwin/lib"

# These are for libXrandr.so on Solaris 10:
#
CPPFLAGS="$CPPFLAGS -I /usr/X11/include"
LDFLAGS="$LDFLAGS -L/usr/X11/lib -R /usr/X11/lib"

# Everything needs to built with _REENTRANT for thread safe errno:
#
CPPFLAGS="$CPPFLAGS -D_REENTRANT"

export PATH CPPFLAGS LDFLAGS

./configure
make

ls -l ./x11vnc/x11vnc
  ```

   Then do make install or copy the x11vnc binary to your desired
   destination.

   BTW, To run a shell script, just cut-and-paste the above into a file,
   say "myscript", then modify the "/path/to/..." items to correspond to
   your system/environment, and then type: "sh myscript" to run it.

   Note that on Solaris make is /usr/ccs/bin/make, so that is why the
   above puts /usr/ccs/bin in PATH. Other important build utilities are
   there too: ld, ar, etc. Also, it is probably a bad idea to have
   /usr/ucb in your PATH while building.

   Starting with the 0.7.1 x11vnc release the "configure --with-jpeg=DIR
   --with-zlib=DIR" options are handy if you want to avoid making a
   script.

   If you need to link OpenSSL libssl.a on Solaris see this method.

   If you need to build on Solaris 2.5.1 or earlier or other older Unix
   OS's, see this workaround FAQ.


   Building on FreeBSD, OpenBSD, ...:   The jpeg libraries seem to be in
   /usr/local or /usr/pkg on these OS's. You won't need the openwin stuff
   in the above script (but you may need /usr/X11R6/....) Also starting
   with the 0.7.1 x11vnc release, this usually works:

  ```
  ./configure --with-jpeg=/usr/local
  make
  ```

   Building on HP-UX:   For jpeg and zlib you will need to do the same
   sort of thing as described above for Solaris. You set CPPFLAGS and
   LDFLAGS to find them (see below for an example.) You do not need to do
   any of the above /usr/openwin stuff. Also, HP-UX does not seem to
   support -R, so get rid of the -R items in LDFLAGS. Because of this, at
   runtime you may need to set LD_LIBRARY_PATH or SHLIB_PATH to indicate
   the directory paths so the libraries can be found. It is a good idea
   to have static archives, e.g. libz.a and libjpeg.a for the nonstandard
   libraries so that they get bolted into the x11vnc binary (and so won't
   get "lost".)

   Here is what we recently did to build x11vnc 0.7.2 on HP-UX 11.11

  ```
./configure --with-jpeg=$HOME/hpux/jpeg --with-zlib=$HOME/hpux/zlib
make
  ```

   Where we had static archives (libjpeg.a, libz.a) only and header files
   in the $HOME/hpux/... directories as discussed for the build script.

   On HP-UX 11.23 and 11.31 we have had problems compiling with gcc.
   "/usr/include/rpc/auth.h:87: error: field 'syncaddr' has incomplete
   type". As a workaround for x11vnc 0.9.4 and later set your CPPFLAGS to
   include:

  ```
  CPPFLAGS="-DIGNORE_GETSPNAM"
  export CPPFLAGS
  ```

   This disables a very rare usage mode for -unixpw_nis by not trying
   getspnam(3).

   Using HP-UX's C compiler on 11.23 and 11.31 we have some severe
   compiler errors that have not been worked around yet. If you need to
   do this, contact me and I will give you a drastic recipe that will
   produce a working binary.


   Building on AIX:   AIX: one user had to add the "X11.adt" package to
   AIX 4.3.3 and 5.2 to get build header files like XShm.h, etc. You may
   also want to make sure that /usr/lpp/X11/include, etc is being picked
   up by the configure and make.

   For a recent build on AIX 5.3 we needed to add these CFLAGS to be able
   to build with gcc:
  env CFLAGS='-maix64 -Xlinker -bbigtoc' ./configure ...

   we also built our own libjpeg and libz using -maix64.

   BTW, one way to run an Xvfb-like virtual X server for testing on AIX
   is something like "/usr/bin/X11/X -force -vfb -ac :1".


   Building on Mac OS X:   There is now native Mac OS X support for
   x11vnc by using the raw framebuffer feature. This mode does not use or
   need X11 at all. To build you may need to disable X11:

  ```
./configure --without-x ...
make
  ```

   However, if your system has the Mac OS X build package for X11 apps
   you will not need to supply the "--without-x" option (in this case the
   resulting x11vnc would be able to export both the native Mac OS X
   display and windows displayed in the XDarwin X server.) Be sure to
   include the ./configure option to find libjpeg on your system.


   OpenSSL:   Starting with version 0.8.3 x11vnc can now be built with
   SSL/TLS support. For this to be enabled the libssl.so library needs to
   be available at build time. So you may need to have additional
   CPPFLAGS and LDFLAGS items if your libssl.so is in a non-standard
   place. As of x11vnc 0.9.4 there is also the --with-ssl=DIR configure
   option.

   Note that from OpenSSL 1.1.0 on SSLv2 support has been dropped and
   SSLv3 deactivated at build time per default. This means that unless
   explicitly enabled, OpenSSL builds only support TLS (any version).
   Since there is a reason for dropping SSLv3 (heard of POODLE?), most
   distributions do not enable it for their OpenSSL binary. In summary
   this means compiling x11vnc against OpenSSL 1.1.0 or newer is no
   problem, but using encryption will require a viewer with TLS support.

   On Solaris using static archives libssl.a and libcrypto.a instead of
   .so shared libraries (e.g. from www.sunfreeware.com), we found we
   needed to also set LDFLAGS as follows to get the configure to work:

  ```
env LDFLAGS='-lsocket -ldl' ./configure --with-ssl=/path/to/openssl ...
make
  ```

#   Beta Testing:

   I don't have any formal beta-testers for the releases of x11vnc, so
   I'd appreciate any additional testing very much.

   Thanks to those who suggested features and helped beta test x11vnc
   0.9.12 released in Sep 2010!

   Please help test and debug the 0.9.13 version for release sometime in
   Winter 2010.

   The version 0.9.13 beta tarball is kept here:
   x11vnc-0.9.13-dev.tar.gz

   There are also some Linux, Solaris, Mac OS X, and other OS test
   binaries here. Please kick the tires and report bugs, performance
   regressions, undesired behavior, etc. to me.

   To aid testing of the built-in SSL/TLS support for x11vnc, a number of
   VNC Viewer packages for Unix, Mac OS X, and Windows have been created
   that provide SSL Support for the TightVNC Viewer (this is done by
   wrapper scripts and a GUI that starts STUNNEL.) It should be pretty
   convenient for automatic SSL and SSH connections. It is described in
   detail at and can be downloaded from the Enhanced TightVNC Viewer
   (SSVNC) page. The SSVNC Unix viewer also supports x11vnc's symmetric
   key encryption ciphers (see the 'UltraVNC DSM Encryption Plugin'
   settings panel.)


   Here are some features that will appear in the 0.9.13 release:

     * Improved support for non-X11 touchscreen devices (e.g. handheld or
       cell phone) via Linux uinput input injection. Additional tuning
       parameters are added. TSLIB touchscreen calibration is supported.
       Tested on Qtmoko Neo Freerunner. A tool, misc/uinput.pl, is
       provided to diagnose uinput behavior on new devices. The env.
       vars. X11VNC_UINPUT_BUS and X11VNC_UINPUT_VERSION are available if
       leaving them unset does not work.
     * The Linux uinput non-X11 input injection can now be bypassed:
       events can be directly written to the /dev/input/event devices
       specified by the user (direct_abs=..., etc.) A -pipeinput input
       injection helper script, misc/qt_tslib_inject.pl is provided as a
       tweakable non-builtin direct input injection method.
     * The list of new uinput parameters for the above two features is:
       pressure, tslib_cal, touch_always, dragskip, btn_touch;
       direct_rel, direct_abs, direct_btn, direct_key.
     * The MacOSX native server can now use OpenGL for the screen
       capture. In nearly all cases this is faster than the raw
       framebuffer capture method. There are build and run time flags,
       X11VNC_MACOSX_NO_DEPRECATED, etc. to disable use of deprecated
       input injection and screen access interfaces. Cursor shape now
       works for 64bit binaries.
     * The included SSL enabled Java VNC Viewers now handle Mouse Wheel
       events.
     * miscellaneous new features and changes:
     * In -reflect mode, the libvncclient connection can now have the
       pixel format modified via the environment variables
       X11VNC_REFLECT_bitsPerSample, X11VNC_REFLECT_samplesPerPixel, and
       X11VNC_REFLECT_bytesPerPixel
     * In -create mode the following environment variables are added to
       fine tune the behavior: FIND_DISPLAY_NO_LSOF: do not use lsof(1)
       to try to determine the Linux VT, FIND_DISPLAY_NO_VT_FIND: do not
       try to determine the Linux VT at all, X11VNC_CREATE_LC_ALL_C_OK:
       do not bother undoing the setting LC_ALL=C that the create_display
       script sets. The performance of the -create script has been
       improved for large installations (100's of user sessions on one
       machine.)
     * In -unixpw mode, one can now Tab from login: to Password.
     * An environment variable, X11VNC_SB_FACTOR, allows one to scale the
       -sb screenblank sleep time from the default 2 secs.
     * An experimental option -unixsock is available for testing. Note,
       however, that it requires a manual change to
       libvncserver/rfbserver.c for it to work.
     * Documented that -grabkbd is no longer working with some/most
       window managers (it can prevent resizing and menu posting.)


   Here are some features that appeared in the 0.9.12 release (Sep/2010):

     * One can now specify the maximum number of displays that can be
       created in -create mode via the env. var.
       X11VNC_CREATE_MAX_DISPLAYS
     * The X11VNC_NO_LIMIT_SHM env. var. is added to skip any automatic
       shared memory reduction.
     * The kdm display manager is now detected when trying not to get
       killed by the display manager.
     * A compile time bug is fixed so that configuring using
       --with-system-libvncserver pointing to LibVNCServer 0.9.7 works
       again. A bug from forced use of Xdefs.h is worked around.


   Here are some features that appeared in the 0.9.11 release (Aug/2010):

     * The source tree is synchronized with the most recent libvncclient
       (this only affects -reflect mode.) Build is fixed for
       incompatibilities when using an external LibVNCServer (e.g.
       ./configure --with-system-libvncserver...) Please help test these
       build and runtime aspects and report back what you find, thanks.
     * The SSL enabled Java VNC Viewer Makefile has been modified so that
       the jar files that are built are compatible back to Java 1.4.
     * In -create/-unixpw mode, the env. var. FD_USERPREFS may be set to
       a filename in the user's home directory that includes default
       username:options values (so the options do not need to be typed
       every time at the login prompt.)
     * In -reflect mode cursor position updates are now handled
       correctly.


   Here are some features that appeared in the 0.9.10 release (May/2010):

     * The included SSL enabled Java applet viewer now supports Chained
       SSL Certificates. The debugCerts=yes applet parameter aids
       troubleshooting certificate validation. The x11vnc -ssl mode has
       always supported chained SSL certificates (simply put the
       intermediate certificates, in order, after the server certificate
       in the pem file.)
     * A demo CGI script desktop.cgi shows how to create an SSL
       encrypted, multi-user x11vnc web login desktop service. The script
       requires x11vnc version 0.9.10. The user logs into a secure web
       site and gets his/her own virtual desktop (Xvfb.) x11vnc's SSL
       enabled Java Viewer Applet is launched by the web browser for
       secure viewing (and so no software needs to be installed on the
       viewer-side.) One can use the desktop.cgi script for ideas to
       create their own fancier or customized web login desktop service
       (e.g. user-creation, PHP, SQL, specialized desktop application,
       etc.) More info here. There is also an optional 'port redirection'
       mode that allows redirection to other SSL enabled VNC servers
       running inside the firewall.
     * Built-in support for IPv6 (128 bit internet addresses) is now
       provided. See the -6 and -connect options for details.
       Additionally, in case there are still problems with built-in IPv6
       support, a transitional tool is provided in inet6to4 that allows
       x11vnc (or any other IPv4 application) to receive connections over
       IPv6.
     * The Xdummy wrapper script for Xorg's dummy driver is updated and
       no longer requires being run as root. New service options are
       provided to select Xdummy over Xvfb as the virtual X server to be
       created.
     * The "%" unix password verification tricks for the -unixpw option
       are now documented. They have also been extended to run a command
       as the user if one sets the environment variable UNIXPW_CMD. The
       desktop.cgi demo script takes advantage of this new feature.
     * A bug has been fixed that would prevent the Java applet viewer
       from being downloaded successfully in single-port HTTPS/VNC inetd
       mode. The env. var. X11VNC_HTTPS_DOWNLOAD_WAIT_TIME can be used to
       adjust for how many seconds a -inetd or -https httpd download is
       waited for (default 15 seconds.) The applet will now autodetect
       x11vnc and use GET=1 for faster connecting. Many other
       improvements and fixes.
     * The TightVNC security type (TightVNC features enabler) now works
       for RFB version 3.8.
     * The X property X11VNC_TRAP_XRANDR can be set on a desktop to force
       x11vnc to use the -xrandr screen size change trapping code.
     * New remote control query options: pointer_x, pointer_y,
       pointer_same, pointer_root, and pointer_mask. A demo script using
       them misc/panner.pl is provided.
     * The -sslScripts option prints out the SSL certificate management
       scripts.


   Here are some features that appeared in the 0.9.9 release (Dec/2009):

     * The -unixpw_system_greeter option, when used in combined unixpw
       and XDMCP FINDCREATEDISPLAY mode (for example: -xdmsvc), enables
       the user to press Escape to jump directly to the XDM/GDM/KDM login
       greeter screen. This way the user avoids entering his unix
       password twice at X session creation time. Also, the unixpw login
       panel now has a short help displayed if the user presses 'F1'.
     * x11vnc now tries to be a little bit more aggressive in keeping up
       with VNC client's framebuffer update requests. Some broken VNC
       clients like Eggplant and JollysFastVNC continuously spray these
       requests at VNC servers (regardless of whether they have received
       any updates or not.) Under some circumstances this could lead to
       x11vnc falling behind. The -extra_fbur option allows one to fine
       tune the setting. Additionally, one may also dial down delays:
       e.g. "-defer 5" and "-wait 5" (or to 1 or even 0) or -nonap or
       -allinput to keep up with these VNC clients at the expense of
       increased system load.
     * Heuristics are applied to try to determine if the X display is
       currently in a Display Manager Greeter Login panel (e.g. GDM) If
       so, x11vnc's creation of any windows and use of XFIXES are
       delayed. This is to try to avoid x11vnc being killed after the
       user logs in if the GDM KillInitClients=true is in effect. So one
       does not need to set KillInitClients=false. Note that in recent
       GDM the KillInitClients option has been removed. Also delayed is
       the use of the XFIXES cursor fetching functionality; this avoids
       an Xorg bug that causes Xorg to crash right after the user logs
       in.
     * A new option -findauth runs the FINDDISPLAY script that applies
       heuristics that try to determine the XAUTHORITY file. The use of
       '-auth guess' will use the XAUTHORITY that -findauth reveals. This
       can be handy in with the lastest GDM where the ability to store
       cookies in ~/.Xauthority has been removed. If x11vnc is running as
       root (e.g. inetd) and you add -env FD_XDM=1 to the above -findauth
       or -auth guess command lines, it will find the correct XAUTHORITY
       for the given display (this works for XDM/GDM/KDM if the login
       greeter panel is up or if someone has already logged into an X
       session.)
     * The FINDDISPLAY and FINDCREATEDISPLAY modes (i.e. "-display
       WAIT:cmd=...", -find, -create) now work correctly for the
       user-supplied login program scheme "-unixpw_cmd ...", as long as
       the login program supports running commands specified in the
       environment variable "RFB_UNIXPW_CMD_RUN" as the logged-in user.
       The mode "-unixpw_nis ..." has also been made more consistent.
     * The -stunnel option (like -ssl but uses stunnel as an external
       helper program) now works with the -ssl "SAVE" and "TMP" special
       certificate names. The -sslverify and -sslCRL options now work
       correctly in -stunnel mode. Single port HTTPS connections are also
       supported for this mode.
     * There is an experimental Application Sharing mode that improves
       upon the -id/-sid single window sharing: -appshare (run "x11vnc
       -appshare -help" for more info.) It is still very primitive and
       approximate, but at least it displays multiple top-level windows.
     * The remote control command -R can be used to instruct x11vnc to
       resend its most recent copy of the Clipboard, Primary, or
       Cutbuffer selections: "x11vnc -R resend_clipboard", "x11vnc -R
       resend_primary", and "x11vnc -R resend_cutbuffer".
     * The fonts in the GUI (-gui) can now by set via environment
       variables, e.g. -env X11VNC_FONT_BOLD='Helvetica -16 bold' and
       -env X11VNC_FONT_FIXED='Courier -14'.
     * The XDAMAGE mechanism is now automatically disabled for a period
       of time if a game or screensaver generates too many XDAMAGE
       rectangles per second. This avoids the X11 event queue from
       soaking up too much memory.
     * There is an experimental workaround: "-env X11VNC_WATCH_DX_DY=1"
       that tries to avoid problems with poorly constructed menu themes
       that place the initial position of the mouse cursor inside a menu
       item's active zone. More information can be found here.


   Here are some features that appeared in the 0.9.8 release (Jul/2009):

     * Stability improvements to -threads mode. Running x11vnc this way
       is more reliable now. Threaded operation sometimes gives better
       interactive response and faster updates: try it out. The threaded
       mode now supports multiple VNC viewers using the same VNC
       encoding. The threaded mode can also yield a performance
       enhancement in the many client case (e.g. class-room broadcast.)
       We have tested with 30 to 50 simultaneous clients. See also
       -reflect.
       For simultaneous clients: the ZRLE encoding is thread safe on all
       platforms, and the Tight and Zlib encodings are currently only
       thread safe on Linux where thread local storage, __thread, is
       used. If your non-Linux system and compiler support __thread one
       can supply -DTLS=__thread to enable it. When there is only one
       connected client, all encodings are safe on all platforms. Note
       that some features (e.g. scroll detection and -ncache) may be
       disabled or run with reduced functionality in -threads mode.
     * Automatically tries to work around an Xorg server and GNOME bug
       involving infinitely repeating keys when turning off key
       repeating. Use -repeat if the automatic workaround fails.
     * Improved reliability of the Single Port SSL VNC and HTTPS java
       viewer applet delivery mechanism.
     * The -clip mode works under -rawfb.


   Here are some features that appeared in the 0.9.7 release (Mar/2009):

     * Support for polling Linux Virtual Terminals (also called virtual
       consoles) directly instead of using /dev/fb. The option to use is,
       for example, "-rawfb vt2" for Virtual Terminal 2, etc. In this
       case the special file /dev/vcsa2 is used to retrieve vt2's current
       text. Text and colors are shown, but no graphics.
     * Support for less than 8 bits per pixel framebuffers (e.g. 4 or 1
       bpp) in the -rawfb mode.
     * The SSL enabled UltraVNC Java viewer applet now has a [Home] entry
       in the "drives" drop down menu. This menu can be configured with
       the ftpDropDown applet parameter. All of the applet parameters are
       documented in classes/ssl/README.
     * Experimental support for VirtualGL's TurboVNC (an enhanced
       TightVNC for fast LAN high framerate usage.)
     * The CUPS Terminal Services helper mode has been improved.
     * Improvements to the -ncache_cr that allows smooth opaque window
       motions using the 'copyrect' encoding when using -ncache mode.
     * The -rmflag option enables a way to indicate to other processes
       x11vnc has exited.
     * Reverse connections using anonymous Diffie Hellman SSL encryption
       now work.


   Here are some features that appeared in the 0.9.6 release (Dec/2008):

     * Support for VeNCrypt SSL/TLS encrypted connections. It is enabled
       by default in the -ssl mode. VNC Viewers like vinagre,
       gvncviewer/gtk-vnc, the vencrypt package, SSVNC, and others
       support this encryption mode. It can also be used with the -unixpw
       option to enable Unix username and password authentication
       (VeNCrypt's "*Plain" modes.) A similar but older VNC security type
       "ANONTLS" (used by vino) is supported as well. See the -vencrypt
       and -anontls options for additional control. The difference
       between x11vnc's normal -ssl mode and VeNCrypt is that the former
       wraps the entire VNC connection in SSL (like HTTPS does for HTTP,
       i.e. "vncs://") while VeNCrypt switches on the SSL/TLS at a
       certain point during the VNC handshake. Use -sslonly to disable
       both VeNCrypt and ANONTLS (vino.)
     * The "-ssl ANON" option enables Anonymous Diffie-Hellman (ADH) key
       exchange for x11vnc's normal SSL/TLS operation. Note that
       Anonymous Diffie-Hellman uses encryption for privacy, but provides
       no authentication and so is susceptible to Man-In-The-Middle
       attacks (and so we do not recommend it: we prefer you use "-ssl
       SAVE", etc. and have the VNC viewer verify the cert.) The ANONTLS
       mode (vino) only supports ADH. VeNCrypt mode supports both ADH and
       regular X509 SSL certificates modes. For these ADH is enabled by
       default. See -vencrypt and -anontls for how to disable ADH.
     * For x11vnc's SSL/TLS modes, one can now specify a Certificate
       Revocation List (CRL) with the -sslCRL option. This will only be
       useful for wide deployments: say a company-wide x11vnc SSL access
       deployment using a central Certificate Authority (CA) via
       -sslGenCA and -sslGenCert. This way if a user has his laptop lost
       or stolen, you only have to revoke his key instead of creating a
       new Certificate Authority and redeploying new keys to all users.
     * The default SSL/TLS mode, "-ssl" (no pem file parameter supplied),
       is now the same as "-ssl SAVE" and will save the generated
       self-signed cert in "~/.vnc/certs/server.pem". Previously "-ssl"
       would create a temporary self-signed cert that was discarded when
       x11vnc exited. The reason for the change is to at least give the
       chance for the VNC Viewer side (e.g. SSVNC) to remember the cert
       to authenticate subsequent connections to the same x11vnc server.
       Use "-ssl TMP" to regain the previous behavior. Use "-ssl
       SAVE_NOPROMPT" to avoid being prompted about using passphrase when
       the certificate is created.
     * The option -http_oneport enables single-port HTTP connections via
       the Java VNC Viewer. So, for example, the web browser URL
       "http://myhost.org:5900" works the same as
       "http://myhost.org:5800", but with the convenience of only
       involving one port instead of two. This works for both unencrypted
       connections and for SSH tunnels (see -httpsredir if the tunnel
       port differs.) Note that HTTPS single-port operation in -ssl SSL
       encrypted mode has been available since x11vnc version 0.8.3.
     * For the -avahi/-zeroconf Service Advertizing mode, if x11vnc was
       not compiled with the avahi-client library, then an external
       helper program, either avahi-publish(1) (on Unix) or dns-sd(1) (on
       Mac OS X), is used instead.
     * The "-rfbport PROMPT" option will prompt the user via the GUI to
       select the VNC port (e.g. 5901) to listen on, and a few other
       basic settings. This enables a handy GUI mode for naive users:
   x11vnc -gui tray=setpass -rfbport PROMPT -logfile $HOME/.x11vnc.log.%VNCDISP
LAY
       suitable for putting in a launcher or menu, e.g. x11vnc.desktop.
       The -logfile expansion is new too. In the GUI, the tray=setpass
       Properties panel has been improved.
     * The -solid solid background color option now works for the Mac OS
       X console.
     * The -reopen option instructs x11vnc to try to reopen the X display
       if it is prematurely closed by, say, the display manager (e.g.
       GDM.)


   Here are some features that appeared in the 0.9.5 release (Oct/2008):

     * Symmetric key encryption ciphers. ARC4, AES-128, AES-256,
       blowfish, and 3des are supported. Salt and initialization vector
       seeding is provided. These compliment the more widely used SSL and
       SSH encryption access methods. SSVNC also supports these
       encryption modes.
     * Scaling differently along the X- and Y-directions. E.g. "-scale
       1280x1024" or "-scale 0.8x0.75"    Also, "-geometry WxH" is an
       alias for "-scale WxH"
     * By having SSVNC version 1.0.21 or later available in your $PATH,
       the -chatwindow option allows a UltraVNC Text Chat window to
       appear on the local X11 console/display (this way the remote
       viewer can chat with the person at the physical display; e.g.
       helpdesk mode.) This also works on the Mac OS X console if the
       Xquartz X11 server (enabled by default on leopard) is running for
       the chatwindow.
     * The HTTP Java viewer applet jar, classes/VncViewer.jar, has been
       updated with an improved implementation based on the code used by
       the classes/ssl applets.


   Here are some features that appeared in the 0.9.4 release (Sep/2008):

     * Improvements to the -find and -create X session finding or
       creating modes: new desktop types and service redirection options.
       Personal cupsd daemon and SSH port redirection helper for use with
       SSVNC's Terminal Services feature.
     * Reverse VNC connections via -connect work in the -find, -create
       and related -display WAIT:... modes.
     * Reverse VNC connections (either normal or SSL) can use a Web Proxy
       or a SOCKS proxy, or a SSH connection, or even a CGI URL to make
       the outgoing connection. See: -proxy. Forward connections can also
       use: -ssh.
     * Reverse VNC connections via the UltraVNC repeater proxy (either
       normal or SSL) are supported. Use either the "-connect
       repeater=ID:NNNN+host:port" or "-connect
       repeater://host:port+ID:NNNN" notation. The SSVNC VNC viewer also
       supports the UltraVNC repeater. Also, a perl repeater implemention
       is here: ultravnc_repeater.pl
     * Support for indexed colormaps (PseudoColor) with depths other than
       8 (from 1 to 16 now work) for non-standard hardware. Option
       "-advertise_truecolor" to handle some workaround in this mode.
     * Support for the ZYWRLE encoding, this is the RealVNC ZRLE encoding
       extended to do motion video and photo regions more efficiently by
       way of a Wavelet based transformation.
     * The -finddpy and -listdpy utilities help to debug and configure
       the -find, -create, and -display WAIT:... modes.
     * Some automatic detection of screen resizes are handled even if the
       -xrandr option is not supplied.
     * The -autoport options gives more control over the VNC port x11vnc
       chooses.
     * The -ping secs can be used to help keep idle connections alive.
     * Pasting of the selection/clipboard into remote applications (e.g.
       Java) has been improved.
     * Fixed a bug if a client disconnects during the 'speed-estimation'
       phase.
     * To unset Caps_Lock, Num_Lock and raise all keys in the X server
       use -clear_all.
     * Usage with dvorak keyboards has been improved. See also: -xkb.
     * The Java Viewer applet source code is now included in the
       x11vnc-0.9.*.tar.gz tarball. This means you can now build the Java
       viewer applet jar files from source. If you stopped shipping the
       Java viewer applet jar files due to lack of source code, you can
       start again.


   Here are some features that appeared in the 0.9.3 release (Oct/2007):

     * Viewer-side pixmap caching. A large area of pixels (at least 2-3
       times as big as the framebuffer itself; the bigger the better...
       default is 10X) is placed below the framebuffer to act as a
       buffer/cache area for pixel data. The VNC CopyRect encoding is
       used to move it around, so any viewer can take advantage of it.
       Until we start modifying viewers you will be able to see the cache
       area if you scroll down (this makes it easier to debug!) For
       testing the default is "-ncache 10". The unix Enhanced TightVNC
       Viewer ssvnc has a nice -ycrop option to help hide the pixel cache
       area from view.


   Here are some features that appeared in the 0.9.2 release (Jun/2007):

     * Building with no OpenSSL libssl available (or with --without-ssl)
       has been fixed.
     * One can configure x11vnc via "./configure
       --with-system-libvncserver" to use a system installed libvncserver
       library instead of the one bundled in the release tarball.
     * If UltraVNC file transfer or chat is detected, then VNC clients
       are "pinged" more often to prevent these side channels from
       becoming serviced too infrequently.
     * In -unixpw mode in the username and password dialog no text will
       be echoed if the first character sent is "Escape". This enables a
       convenience feature in SSVNC to send the username and password
       automatically.


   Here are some features that appeared in the 0.9.1 release (May/2007):

     * The UltraVNC Java viewer has been enhanced to support SSL (as the
       TightVNC viewer had been previously.) The UltraVNC Java supports
       ultravnc filetransfer, and so can be used as a VNC viewer on Unix
       that supports ultravnc filetransfer. It is in the
       classes/ssl/UltraViewerSSL.jar file (that is pointed to by
       ultra.vnc.) The signed applet SignedUltraViewerSSL.jar version
       (pointed to by ultrasigned.vnc) will be needed to access the local
       drive if you are using it for file transfer via a Web browser.
       Some other bugs in the UltraVNC Java viewer were fixed and a few
       improvements to the UI made.
     * A new Unix username login mode for VNC Viewers authenticated via a
       Client SSL Certificate: "-users sslpeer=". The emailAddress
       subject field is inspected for username@hostname and then acts as
       though "-users +username" has been supplied. This way the Unix
       username is identified by (i.e. simply extracted from) the Client
       SSL Certificate. This could be useful with -find, -create and -svc
       modes if you are also have set up and use VNC Client SSL
       Certificate authentication.
     * For external display finding/creating programs (e.g. WAIT:cmd=...)
       if the VNC Viewer is authenticated via a Client SSL Certificate,
       then that Certificate is available in the environment variable
       RFB_SSL_CLIENT_CERT.


   Here are some features that appeared in the 0.9 release (Apr/2007):

     * VNC Service advertising via mDNS / ZeroConf / BonJour with the
       Avahi client library. Enable via "-avahi" or "-zeroconf".
     * Implementations of UltraVNC's TextChat, SingleWindow, and
       ServerInput extensions (requires ultravnc viewer or ssvnc Unix
       viewer.) They toggle the selection of a single window (-id), and
       disable (friendly) user input and viewing (monitor blank) at the
       VNC server.
     * Short aliases "-find", "-create", "-svc", and "-xdmsvc" for
       commonly used FINDCREATEDISPLAY usage modes.
     * Reverse VNC connections (viewer listening) now work in SSL (-ssl)
       mode.
     * New options to control the Monitor power state and keyboard/mouse
       grabbing: -forcedpms, -clientdpms, -noserverdpms, and -grabalways.
     * A simple way to emulate inetd(8) to some degree via the "-loopbg"
       option.
     * Monitor the accuracy of XDAMAGE and apply "-noxdamage" if it is
       not working well. OpenGL applications like like beryl and MythTv
       have been shown to make XDAMAGE not work properly.
     * For Java SSL connections involving a router/firewall port
       redirection, an option -httpsredir to spare the user from needing
       to include &PORT=NNN in the browser URL.


   Here are some features that appeared in the 0.8.4 release (Feb/2007):

     * Native Mac OS X Aqua/Quartz support. (i.e. OSXvnc alternative;
       some activities are faster)
     * A new login mode: "-display WAIT:cmd=FINDCREATEDISPLAY -unixpw
       ..." that will Create a new X session (either virtual or real and
       with or without a display manager, e.g. kdm) for the user if it
       cannot find the user's X session display via the FINDDISPLAY
       method. See the -svc and the -xdmsvc aliases.
     * x11vnc can act as a VNC reflector/repeater using the "-reflect
       host:N" option. Instead of polling an X display, the remote VNC
       Server host:N is connected to and re-exported via VNC. This is
       intended for use in broadcasting a display to many (e.g. > 16;
       classroom or large demo) VNC viewers where bandwidth and other
       resources are conserved by spreading the load over a number of
       repeaters.
     * Wireframe copyrect detection for local user activity (e.g. someone
       sitting at the physical display moving windows) Use
       -nowireframelocal to disable.
     * The "-N" option couples the VNC Display number to the X Display
       number. E.g. if your X DISPLAY is :2 then the VNC display will be
       :2 (i.e. using port 5902.) If that port is taken x11vnc will exit.
     * Option -nodpms to avoid problems with programs like KDE's
       kdesktop_lock that keep restarting the screen saver every few
       seconds.
     * To automatically fix the common mouse motion problem on XINERAMA
       (multi-headed) displays, the -xwarppointer option is enabled by
       default when XINERAMA is active.

   If you have a Mac please try out the native Mac OS X support, build
   with "./configure --without-x", or download a binary mentioned above,
   (even if you don't plan on ever using it in this mode!), and let me
   know how it went. Thanks.


   Here are some features that appeared in the 0.8.3 release (Nov/2006):

     * The -ssl option provides SSL encryption and authentication
       natively via the www.openssl.org library. One can use from a
       simple self-signed certificate server certificate up to full CA
       and client certificate authentication schemes.
     * Similar to -ssl, the -stunnel option starts up a SSL tunnel server
       stunnel (that must be installed separately on the system:
       stunnel.mirt.net ) to allow only encrypted SSL connections from
       the network.
     * The -sslverify option allows for authenticating VNC clients via
       their certificates in either -ssl or -stunnel modes.
     * Certificate creation and management tools are provide in the
       -sslGenCert, -sslGenCA, and related options.
     * An SSL enabled Java applet VNC Viewer applet is provided by x11vnc
       in classes/ssl/VncViewer.jar. In addition to normal HTTP, the
       applet may be loaded into the web browser via HTTPS (HTTP over
       SSL.) (one can use the VNC port, e.g. https://host:5900/, or also
       the separate -https port option.) A wrapper shell script
       ss_vncviewer is also provided that sets up a stunnel client-side
       tunnel on Unix systems. See Enhanced TightVNC Viewer (SSVNC) for
       other SSL/SSH viewer possibilities.
     * The -unixpw option supports Unix username and password
       authentication (a simpler variant is the -unixpw_nis option that
       works in environments where the encrypted passwords are readable,
       e.g. NIS.) The -ssl or -localhost + -stunnel options are enforced
       in this mode to prevent password sniffing. As a convenience, these
       requirements are lifted if a SSH tunnel can be deduced (but
       -localhost still applies.)
     * Coupling -unixpw with "-display WAIT:cmd=FINDDISPLAY" or "-display
       WAIT:cmd=FINDCREATEDISPLAY" provides a way to allow a user to
       login with their UNIX password and have their display connected to
       automatically. See the -svc and the -xdmsvc aliases.
     * Hooks are provided in the -unixpw_cmd and "-passwdfile
       cmd:,custom:..." options to allow you to supply your own
       authentication and password lookup programs.
     * x11vnc can be configured and built to not depend on X11 libraries
       "./configure --without-x" for -rawfb only operation (e.g. embedded
       linux console devices.)
     * The -rotate option enables you to rotate or reflect the screen
       before exporting via VNC. This is intended for use on handhelds
       and other devices where the rotation orientation is not "natural".
     * The "-ultrafilexfer" alias is provided and improved UltraVNC
       filetransfer rates have been achieved.
     * Under the "-connect_or_exit host" option x11vnc will exit
       immediately unless the reverse connection to host succeeds. The
       "-rfbport 0" option disables TCP listening for connections (useful
       for this mode.)
     * The "-rawfb rand" and "-rawfb none" options are useful for testing
       automation scripts, etc., without requiring a full desktop.
     * Reduced spewing of information at startup, use "-verbose" (also
       "-v") to turn it back on for debugging or if you are going to send
       me a problem report.

#  Here are some Previous Release Notes

##  Some Notes:

   Both a client and a server:   It is sometimes confusing to people that
   x11vnc is both a client and a server at the same time. It is an X
   client because it connects to the running X server to do the screen
   polls. Think of it as a rather efficient "screenshot" program running
   continuously. It is a server in the sense that it is a VNC server that
   VNC viewers on the network can connect to and view the screen
   framebuffer it manages.

   When trying to debug problems, remember to think of both roles. E.g.
   "how is x11vnc connecting to the X server?", "how is the vncviewer
   connecting to x11vnc?", "what permits/restricts the connection?". Both
   links may have reachability, permission, and other issues.

   Network performance:   Whether you are using Xvnc or x11vnc it is
   always a good idea to have a solid background color instead of a
   pretty background image. Each and every re-exposure of the background
   must be resent over the network: better to have that background be a
   solid color that compresses very well compared to a photo image. (This
   is one place where the X protocol has an advantage over the VNC
   protocol.) I suggest using xsetroot, dtstyle or similar utility to set
   a solid background while using x11vnc. You can turn the pretty
   background image back on when you are using the display directly.
   Update: As of Feb/2005 x11vnc has the -solid [color] option that works
   on recent GNOME, KDE, and CDE and also on classic X (background image
   is on the root window.) Update: As of Oct/2007 x11vnc has the -ncache
   option that does a reasonable job caching the background (and other)
   pixmap data on the viewer side.

   I also find the TightVNC encoding gives the best response for my usage
   (Unix <-> Unix over cable modem.) One needs a tightvnc-aware vncviewer
   to take advantage of this encoding.

   TCP port issues:   Notice the lines

  ```
  18/07/2003 14:36:31 Autoprobing selected port 5900
  PORT=5900
  ```

   in the output. 5900 is the default VNC listening port (just like 6000
   is X11's default listening port.) Had port 5900 been taken by some
   other application, x11vnc would have next tried 5901. That would mean
   the viewer command above should be changed to vncviewer
   far-away.east:1. You can force the port with the "-rfbport NNNN"
   option where NNNN is the desired port number. If that port is already
   taken, x11vnc will exit immediately. The "-N" option will try to match
   the VNC display number to the X display.   (also see the "SunRay
   Gotcha" note below)

   Options:   x11vnc has (far too) many features that may be activated
   via its command line options. Useful options are, e.g., -scale to do
   server-side scaling, and -rfbauth passwd-file to use VNC password
   protection (the vncpasswd or storepasswd programs, or the x11vnc
   -storepasswd option can be used to create the password file.)

   Algorithm:   How does x11vnc do it? Rather brute-forcedly: it
   continuously polls the X11 framebuffer for changes using
   XShmGetImage(). When changes are discovered, it instructs libvncserver
   which rectangular regions of the framebuffer have changed, and
   libvncserver compresses the changes and sends them off to any
   connected VNC viewers. A number of applications do similar things,
   such as x0rfbserver, krfb, x0vncserver, vino. x11vnc uses a 32 x 32
   pixel tile model (the desktop is decomposed into roughly 1000 such
   tiles), where changed tiles are found by pseudo-randomly polling 1
   pixel tall horizontal scanlines separated vertically by 32 pixels.
   This is a surprisingly effective algorithm for finding changed
   regions. For keyboard and mouse user input the XTEST extension is used
   to pass the input events to the X server. To detect XBell "beeps" the
   XKEYBOARD extension is used. If available, the XFIXES extension is
   used to retrieve the current mouse cursor shape. Also, if available
   the X DAMAGE extension is used to receive hints from the X server
   where modified regions on the screen are. This greatly reduces the
   system load when not much is changing on the screen and also improves
   how quickly the screen is updated.

   Barbershop mirrors effect:   What if x11vnc is started up, and
   vncviewer is then started up on the same machine and displayed on the
   same display x11vnc is polling? One might "accidentally" do this when
   first testing out the programs. You get an interesting
   recursive/feedback effect where vncviewer images keep popping up each
   one contained in the previous one and slightly shifted a bit by the
   window manager decorations. There will be an even more interesting
   effect if -scale is used. Also, if the XKEYBOARD is supported and the
   XBell "beeps" once, you get an infinite loop of beeps going off.
   Although all of this is mildly exciting it is not much use: you will
   normally run and display the viewer on a different machine!

##  Sun Ray Notes:

   You can run x11vnc on your (connected or disconnected) SunRay session.
   Here are some notes on SunRay usage with x11vnc.


##  Limitations:

     * Due to the polling nature, some activities (opaque window moves,
       scrolling), can be pretty choppy/ragged and others (exposures of
       large areas) slow. Experiment with interacting a bit differently
       than you normally do to minimize the effects (e.g. do fullpage
       paging rather than line-by-line scrolling, and move windows in a
       single, quick motion.) Recent work has provided the
       -scrollcopyrect and -wireframe speedups using the CopyRect VNC
       encoding and other things, but they only speed up some activities,
       not all.
     * A rate limiting factor for x11vnc performance is that graphics
       hardware is optimized for writing, not reading (x11vnc reads the
       video framebuffer for the screen image data.) The difference can
       be a factor of 10 to 1000, and so it usually takes about 0.5-1 sec
       to read in the whole video hardware framebuffer (e.g. 5MB for
       1280x1024 at depth 24 with a read rate of 5-10MB/sec.) So whenever
       activity changes most of the screen (e.g. moving or iconifying a
       large window) there is a delay of 0.5-1 sec while x11vnc reads the
       changed regions in.
       A slow framebuffer read rate will often be the performance
       bottleneck on a fast LAN (whereas on slower links the reduced
       network bandwidth becomes the bottleneck.)
       Note: A quick way to get a 2X speedup of this for x11vnc is to
       switch your X server from depth 24 (32bpp) to depth 16 (16bpp.)
       You get a 4X speedup going to 8bpp, but the lack of color cells is
       usually unacceptable.
       To get a sense of the read and write speeds of your video card,
       you can run benchmarks like: "x11perf -getimage500",  "x11perf
       -putimage500",  "x11perf -shmput500" and for XFree86 displays with
       direct graphics access the "dga" command (press "b" to run the
       benchmark and then after a few seconds press "q" to quit.) Even
       this "dd if=/dev/fb0 of=/dev/null" often gives a good estimate.
       x11vnc also prints out its estimate:
  28/02/2009 11:11:07 Autoprobing TCP port
  28/02/2009 11:11:07 Autoprobing selected port 5900
  28/02/2009 11:11:08 fb read rate: 10 MB/sec
  28/02/2009 11:11:08 screen setup finished.
       We have seen a few cases where the hardware fb read speed is
       greater than 65 MB/sec: on high end graphics workstations from SGI
       and Sun, and also from a Linux user using nvidia proprietary
       drivers for his nvidia video card. Update 2008: thankfully, these
       sped up drivers are becoming more common on Linux and *BSD systems
       and that makes x11vnc run somewhat more quickly. Sometimes they
       have a read rate of over 400 MB/sec.
       On XFree86/Xorg it is actually possible to increase the
       framebuffer read speed considerably (10-100 times) by using the
       Shadow Framebuffer (a copy of the framebuffer is kept in main
       memory and this can be read much more quickly.) To do this one
       puts the line Option "ShadowFB" "true" in the Device section of
       the /etc/X11/XF86Config or /etc/X11/xorg.conf file. Note that this
       disables 2D acceleration at the physical display and so that might
       be unacceptable if one plays games, etc. on the machine's local
       display. Nevertheless this could be handy in some circumstances,
       e.g. if the slower speed while sitting at the physical display was
       acceptable (this seems to be true for most video cards these
       days.) Unfortunately it does not seem shadowfb can be turned on
       and off dynamically...
       Another amusing thing one can do is use Xvfb as the X server, e.g.
       "xinit $HOME/.xinitrc -- /usr/X11R6/bin/Xvfb :1 -screen 0
       1024x768x16" x11vnc can poll Xvfb efficiently via main memory.
       It's not exactly clear why one would want to do this instead of
       using vncserver/Xvnc, (perhaps to take advantage of an x11vnc
       feature, such as framebuffer scaling or built-in SSL encryption),
       but we mention it because it may be of use for special purpose
       applications. You may need to use the "-cc 4" option to force Xvfb
       to use a TrueColor visual instead of DirectColor. See also the
       description of the -create option that does all of this
       automatically for you (be sure to install the Xvfb package, e.g.
       apt-get install xvfb.)
       Also, a faster and more accurate way is to use the "dummy"
       Xorg/XFree86 device driver (or our Xdummy wrapper script.) See
       this FAQ for details.
     * Somewhat surprisingly, the X11 mouse (cursor) shape is write-only
       and cannot be queried from the X server. So traditionally in
       x11vnc the cursor shape stays fixed at an arrow. (see the "-cursor
       X" and "-cursor some" options, however, for a partial hack for the
       root window, etc.) However, on Solaris using the SUN_OVL overlay
       extension, x11vnc can show the correct mouse cursor when the
       -overlay option is also supplied. A similar thing is done on IRIX
       as well when -overlay is supplied.
       More generally, as of Dec/2004 x11vnc supports the new XFIXES
       extension (in Xorg and Solaris 10) to query the X server for the
       exact cursor shape, this works pretty well except that cursors
       with transparency (alpha channel) need to approximated to solid
       RGB values (some cursors look worse than others.)
     * Audio from applications is of course not redirected (separate
       redirectors do exist, e.g. esd, see the FAQ on this below.) The
       XBell() "beeps" will work if the X server supports the XKEYBOARD
       extension. (Note that on Solaris XKEYBOARD is disabled by default.
       Passing +kb to Xsun enables it.)
     * The scroll detection algorithm for the -scrollcopyrect option can
       give choppy or bunched up transient output and occasionally
       painting errors.
     * Using -threads can expose some bugs/crashes in libvncserver.

   Please feel free to contact me if you have any questions, problems, or
   comments about x11vnc, etc. Please be polite, thorough, and not
   demanding (sadly, the number of people contacting me that are rude and
   demanding is increasing dramatically.)
   Also, some people ask if they can make a donation, see this link for
   that.
	
http://www.karlrunge.com/x11vnc/faq.html:


#   x11vnc FAQ:


   [Building and Starting]

   Q-1: I can't get x11vnc to start up. It says "XOpenDisplay failed
   (null)" or "Xlib: connection to ":0.0" refused by server Xlib: No
   protocol specified" and then exits. What do I need to do? 

   Q-2: I can't get x11vnc and/or libvncserver to compile. 

   Q-3: I just built x11vnc successfully, but when I use it my keystrokes
   and mouse button clicks are ignored  (I am able to move the mouse
   though.) 

   Q-4: Help, I need to run x11vnc on Solaris 2.5.1 (or other old
   Unix/Linux) and it doesn't compile! 

   Q-5: Where can I get a precompiled x11vnc binary for my Operating
   System? 

   Q-6: Where can I get a VNC Viewer binary (or source code) for the
   Operating System I will be viewing from? 

   Q-7: How can I see all of x11vnc's command line options and
   documentation on how to use them? 

   Q-8: I don't like typing arcane command line options every time I
   start x11vnc. What can I do? Is there a config file? Or a GUI? 

   Q-9: How can I get the GUI to run in the System Tray, or at least be a
   smaller, simpler icon? 

   Q-10: How can I get x11vnc to listen on a different port besides the
   default VNC port (5900)? 

   Q-11: My Firewall/Router doesn't allow VNC Viewers to connect to
   x11vnc. 

   Q-12: Is it possible for a VNC Viewer and a VNC Server to connect to
   each other even though both are behind Firewalls that block all
   incoming connections? 

   Q-13: Can I make x11vnc more quiet and also go into the background
   after starting up? 

   Q-14: Sometimes when a VNC viewer dies abruptly, x11vnc also dies with
   the error message like: "Broken pipe". I'm using the -forever mode and
   I want x11vnc to keep running. 

   Q-15: The Windows TightVNC 1.3.9 Viewer cannot connect to x11vnc. 

   Q-16: KDE's krdc VNC viewer cannot connect to x11vnc. 

   Q-17: When I start x11vnc on an Alpha Tru64 workstation the X server
   crashes! 

   Q-18: When running x11vnc on an IBM AIX workstation after a few
   minutes the VNC connection freezes. 

   Q-19: Are there any build-time customizations possible, e.g. change
   defaults, create a smaller binary, etc? 

   [Win2VNC Related]

   Q-20: I have two separate machine displays in front of me, one Windows
   the other X11: can I use x11vnc in combination with Win2VNC in
   dual-screen mode to pass the keystrokes and mouse motions to the X11
   display? 

   Q-21: I am running Win2VNC on my Windows machine and "x11vnc -nofb" on
   Unix to pass keyboard and mouse to the Unix monitor. Whenever I start
   Win2VNC it quickly disconnects and x11vnc says:
   rfbProcessClientNormalMessage: read: Connection reset by peer 

   Q-22: Can I run "x11vnc -nofb" on a Mac OS X machine to redirect mouse
   and keyboard input to it from Windows and X11 machines via Win2VNC and
   x2vnc, respectively? 

   [Color Issues]

   Q-23: The X display I run x11vnc on is only 8 bits per pixel (bpp)
   PseudoColor (i.e. only 256 distinct colors.) The x11vnc colors may
   start out OK, but after a while they are incorrect in certain windows.
   
   Q-24: Color problems: Why are the colors for some windows incorrect in
   x11vnc? BTW, my X display has nice overlay/multi-depth visuals of
   different color depths: e.g. there are both depth 8 and 24 visuals
   available at the same time. 

   Q-25: I am on a high color system (depth >= 24) but I seem to have
   colormap problems. They either flash or everything is very dark. 

   Q-26: How do I figure out the window id to supply to the -id windowid
   option? 

   Q-27: Why don't menus or other transient windows come up when I am
   using the -id windowid option to view a single application window? 

   Q-28: My X display is depth 24 at 24bpp (instead of the normal depth
   24 at 32bpp.) I'm having lots of color and visual problems with x11vnc
   and/or vncviewer. What's up? 

   [Xterminals]

   Q-29: Can I use x11vnc to view and interact with an Xterminal (e.g.
   NCD) that is not running UNIX and so x11vnc cannot be run on it
   directly? 

   Q-30: How do I get my X permissions (MIT-MAGIC-COOKIE file) correct
   for a Unix/Linux machine acting as an Xterminal? 

   [Sun Rays]

   Q-31: I'm having trouble using x11vnc with my Sun Ray session. 

   [Remote Control]

   Q-32: How do I stop x11vnc once it is running in the background? 

   Q-33: Can I change settings in x11vnc without having to restart it?
   Can I remote control it? 

   [Security and Permissions]

   Q-34: How do I create a VNC password for use with x11vnc? 

   Q-35: Can I make it so -storepasswd doesn't show my password on the
   screen? 

   Q-36: Can I have two passwords for VNC viewers, one for full access
   and the other for view-only access to the display? 

   Q-37: Can I have as many full-access and view-only passwords as I
   like? 

   Q-38: Does x11vnc support Unix usernames and passwords? Can I further
   limit the set of Unix usernames who can connect to the VNC desktop? 

   Q-39: Can I supply an external program to provide my own custom login
   method (e.g. Dynamic/One-time passwords or non-Unix (LDAP) usernames
   and passwords)? 

   Q-40: Why does x11vnc exit as soon as the VNC viewer disconnects? And
   why doesn't it allow more than one VNC viewer to connect at the same
   time? 

   Q-41: Can I limit which machines incoming VNC clients can connect
   from? 

   Q-42: How do I build x11vnc/libvncserver with libwrap (tcp_wrappers)
   support? 

   Q-43: Can I have x11vnc only listen on one network interface (e.g.
   internal LAN) rather than having it listen on all network interfaces
   and relying on -allow to filter unwanted connections out? 

   Q-44: Now that -localhost implies listening only on the loopback
   interface, how I can occasionally allow in a non-localhost via the -R
   allowonce remote control command? 

   Q-45: Can I fine tune what types of user input are allowed? E.g. have
   some users just be able to move the mouse, but not click or type
   anything? 

   Q-46: Can I prompt the user at the local X display whether the
   incoming VNC client should be accepted or not? Can I decide to make
   some clients view-only? How about running an arbitrary program to make
   the decisions? 

   Q-47: I start x11vnc as root because it is launched via inetd(8) or a
   display manager like gdm(1). Can I have x11vnc later switch to a
   different user? 

   Q-48: I use a screen-lock when I leave my workstation (e.g.
   xscreensaver or xlock.) When I remotely access my workstation desktop
   via x11vnc I can unlock the desktop fine, but I am worried people will
   see my activities on the physical monitor. What can I do to prevent
   this, or at least make it more difficult? 

   Q-49: Can I have x11vnc automatically lock the screen when I
   disconnect the VNC viewer? 

   [Encrypted Connections]

   Q-50: How can I tunnel my connection to x11vnc via an encrypted SSH
   channel between two Unix machines? 

   Q-51: How can I tunnel my connection to x11vnc via an encrypted SSH
   channel from Windows using an SSH client like Putty? 

   Q-52: How can I tunnel my connection to x11vnc via an encrypted SSL
   channel using an external tool like stunnel? 

   Q-53: Does x11vnc have built-in SSL tunneling? 

   Q-54: How do I use VNC Viewers with built-in SSL tunneling? 

   Q-55: How do I use the Java applet VNC Viewer with built-in SSL
   tunneling when going through a Web Proxy? 

   Q-56: Can Apache web server act as a gateway for users to connect via
   SSL from the Internet with a Web browser to x11vnc running on their
   workstations behind a firewall? 

   Q-57: Can I create and use my own SSL Certificate Authority (CA) with
   x11vnc? 

   [Display Managers and Services]

   Q-58: How can I run x11vnc as a "service" that is always available? 

   Q-59: How can I use x11vnc to connect to an X login screen like xdm,
   GNOME gdm, KDE kdm, or CDE dtlogin? (i.e. nobody is logged into an X
   session yet.) 

   Q-60: Can I run x11vnc out of inetd(8)? How about xinetd(8)? 

   Q-61: Can I have x11vnc advertise its VNC service and port via mDNS /
   Zeroconf (e.g. Avahi) so VNC viewers on the local network can detect
   it automatically? 

   Q-62: Can I have x11vnc allow a user to log in with her UNIX username
   and password and then have it find her X session display on that
   machine and then attach to it? How about starting an X session if one
   cannot be found? 

   Q-63: Can I have x11vnc restart itself after it terminates? 

   Q-64: How do I make x11vnc work with the Java VNC viewer applet in a
   web browser? 

   Q-65: Are reverse connections (i.e. the VNC server connecting to the
   VNC viewer) using "vncviewer -listen" and vncconnect(1) supported? 

   Q-66: Can reverse connections be made to go through a Web or SOCKS
   proxy or SSH? 

   Q-67: Can x11vnc provide a multi-user desktop web login service as an
   Apache CGI or PHP script? 

   Q-68: Can I use x11vnc as a replacement for Xvnc? (i.e. not for a real
   display, but for a virtual one I keep around.) 

   Q-69: How can I use x11vnc on "headless" machines? Why might I want
   to? 

   [Resource Usage and Performance]

   Q-70: I have lots of memory, but why does x11vnc fail with    shmget:
   No space left on device    or    Minor opcode of failed request: 1
   (X_ShmAttach)? 

   Q-71: How can I make x11vnc use less system resources? 

   Q-72: How can I make x11vnc use MORE system resources? 

   Q-73: I use x11vnc over a slow link with high latency (e.g. dialup
   modem or broadband), is there anything I can do to speed things up? 

   Q-74: Does x11vnc support the X DAMAGE Xserver extension to find
   modified regions of the screen quickly and efficiently? 

   Q-75: My OpenGL application shows no screen updates unless I supply
   the -noxdamage option to x11vnc. 

   Q-76: When I drag windows around with the mouse or scroll up and down
   things really bog down (unless I do the drag in a single, quick
   motion.) Is there anything to do to improve things? 

   Q-77: Why not do something like wireframe animations to avoid the
   windows "lurching" when being moved or resized? 

   Q-78: Can x11vnc try to apply heuristics to detect when a window is
   scrolling its contents and use the CopyRect encoding for a speedup? 

   Q-79: Can x11vnc do client-side caching of pixel data? I.e. so when
   that pixel data is needed again it does not have to be retransmitted
   over the network. 

   Q-80: Does x11vnc support TurboVNC? 

   [Mouse Cursor Shapes]

   Q-81: Why isn't the mouse cursor shape (the little icon shape where
   the mouse pointer is) correct as I move from window to window? 

   Q-82: When using XFIXES cursorshape mode, some of the cursors look
   really bad with extra black borders around the cursor and other cruft.
   How can I improve their appearance? 

   Q-83: In XFIXES mode, are there any hacks to handle cursor
   transparency ("alpha channel") exactly? 

   [Mouse Pointer]

   Q-84: Why does the mouse arrow just stay in one corner in my
   vncviewer, whereas my cursor (that does move) is just a dot? 

   Q-85: Can I take advantage of the TightVNC extension to the VNC
   protocol where Cursor Positions Updates are sent back to all connected
   clients (i.e. passive viewers can see the mouse cursor being moved
   around by another viewer)? 

   Q-86: Is it possible to swap the mouse buttons (e.g. left-handed
   operation), or arbitrarily remap them? How about mapping button clicks
   to keystrokes, e.g. to partially emulate Mouse wheel scrolling? 

   [Keyboard Issues]

   Q-87: How can I get my AltGr and Shift modifiers to work between
   keyboards for different languages? 

   Q-88: When I try to type a "<" (i.e. less than) instead I get ">"
   (i.e. greater than)! Strangely, typing ">" works OK!! 

   Q-89: Extra Character Inserted, E.g.: When I try to type a "<" (i.e.
   less than) instead I get "<," (i.e. an extra comma.) 

   Q-90: I'm using an "international" keyboard (e.g. German "de", or
   Danish "dk") and the -modtweak mode works well if the VNC viewer is
   run on a Unix/Linux machine with a similar keyboard.   But if I run
   the VNC viewer on Unix/Linux with a different keyboard (e.g. "us") or
   Windows with any keyboard, I can't type some keys like:   "@", "$",
   "<", ">", etc. How can I fix this? 

   Q-91: When typing I sometimes get double, triple, or more of my
   keystrokes repeated. I'm sure I only typed them once, what can I do? 

   Q-92: The x11vnc -norepeat mode is in effect, but I still get repeated
   keystrokes!! 

   Q-93: After using x11vnc for a while, I find that I cannot type some
   (or any) characters or my mouse clicks and drags no longer have any
   effect, or they lead to strange effects. What happened? 

   Q-94: The machine where I run x11vnc has an AltGr key, but the local
   machine where I run the VNC viewer does not. Is there a way I can map
   a local unused key to send an AltGr? How about a Compose key as well? 

   Q-95: I have a Sun machine I run x11vnc on. Its Sun keyboard has just
   one Alt key labelled "Alt" and two Meta keys labelled with little
   diamonds. The machine where I run the VNC viewer only has Alt keys.
   How can I send a Meta keypress? (e.g. emacs needs this) 

   Q-96: Running x11vnc on HP-UX I cannot type "#" I just get a "3"
   instead. 

   Q-97: Can I map a keystroke to a mouse button click on the remote
   machine? 

   Q-98: How can I get Caps_Lock to work between my VNC viewer and
   x11vnc? 

   [Screen Related Issues and Features]

   Q-99: The remote display is larger (in number of pixels) than the
   local display I am running the vncviewer on. I don't like the
   vncviewer scrollbars, what I can do? 

   Q-100: Does x11vnc support server-side framebuffer scaling? (E.g. to
   make the desktop smaller.) 

   Q-101: Does x11vnc work with Xinerama? (i.e. multiple monitors joined
   together to form one big, single screen.) 

   Q-102: Can I use x11vnc on a multi-headed display that is not Xinerama
   (i.e. separate screens :0.0, :0.1, ... for each monitor)? 

   Q-103: Can x11vnc show only a portion of the display? (E.g. for a
   special purpose application or a very large screen.) 

   Q-104: Does x11vnc support the XRANDR (X Resize, Rotate and
   Reflection) extension? Whenever I rotate or resize the screen x11vnc
   just seems to crash. 

   Q-105: Independent of any XRANDR, can I have x11vnc rotate and/or
   reflect the screen that the VNC viewers see? (e.g. for a handheld
   whose screen is rotated 90 degrees.) 

   Q-106: Why is the view in my VNC viewer completely black? Or why is
   everything flashing around randomly? 

   Q-107: I use Linux Virtual Terminals (VT's) to implement 'Fast User
   Switching' between users' sessions (e.g. Betty is on Ctrl-Alt-F7,
   Bobby is on Ctrl-Alt-F8, and Sid is on Ctrl-Alt-F1: they use those
   keystrokes to switch between their sessions.)   How come the view in a
   VNC viewer connecting to x11vnc is either completely black or
   otherwise all messed up unless the X session x11vnc is attached to is
   in the active VT? 

   Q-108: I am using x11vnc where my local machine has "popup/hidden
   taskbars" and the remote display where x11vnc runs also has
   "popup/hidden taskbars" and they interfere and fight with each other.
   What can I do? 

   Q-109: Help! x11vnc and my KDE screensaver keep switching each other
   on and off every few seconds. 

   Q-110: I am running the compiz 3D window manager (or beryl, MythTv,
   Google Earth, or some other OpenGL app) and I do not get screen
   updates in x11vnc. 

   Q-111: Can I use x11vnc to view my VMWare session remotely? 

   [Exporting non-X11 devices via VNC]

   Q-112: Can non-X devices (e.g. a raw framebuffer) be viewed (and even
   controlled) via VNC with x11vnc? 

   Q-113: Can I export the Linux Console (Virtual Terminals) via VNC
   using x11vnc? 

   Q-114: Can I export via VNC a Webcam or TV tuner framebuffer using
   x11vnc? 

   Q-115: Can I connect via VNC to a Qt-embedded/Qt-enhanced/Qtopia
   application running on my handheld, cell phone, or PC using the Linux
   console framebuffer (i.e. not X11)? 

   Q-116: How do I inject touch screen input into an
   Qt-embedded/Qt-enhanced/Qtopia cell phone such as openmoko/qtmoko Neo
   Freerunner? 

   Q-117: Now that non-X11 devices can be exported via VNC using x11vnc,
   can I build it with no dependencies on X11 header files and libraries?
   
   Q-118: How do I cross compile x11vnc for a different architecture than
   my Linux i386 or amd64 PC? 

   Q-119: Does x11vnc support Mac OS X Aqua/Quartz displays natively
   (i.e. no X11 involved)? 

   Q-120: Can x11vnc be used as a VNC reflector/repeater to improve
   performance for the case of a large number of simultaneous VNC viewers
   (e.g. classroom broadcasting or a large demo)? 

   Q-121: Can x11vnc be used during a Linux, Solaris, etc. system
   Installation so the Installation can be done remotely? 

   [Misc: Clipboard, File Transfer/Sharing, Printing, Sound, Beeps,
   Thanks, etc.]

   Q-122: Does the Clipboard/Selection get transferred between the
   vncviewer and the X display? 

   Q-123: Can I use x11vnc to record a Shock Wave Flash (or other format)
   video of my desktop, e.g. to record a tutorial or demo? 

   Q-124: Can I transfer files back and forth with x11vnc? 

   Q-125: Which UltraVNC extensions are supported? 

   Q-126: Can x11vnc emulate UltraVNC's Single Click helpdesk mode for
   Unix? I.e. something very simple for a naive user to initiate a
   reverse vnc connection from their Unix desktop to a helpdesk
   operator's VNC Viewer. 

   Q-127: Can I (temporarily) mount my local (viewer-side) Windows/Samba
   File share on the machine where x11vnc is running? 

   Q-128: Can I redirect CUPS print jobs from the remote desktop where
   x11vnc is running to a printer on my local (viewer-side) machine? 

   Q-129: How can I hear the sound (audio) from the remote applications
   on the desktop I am viewing via x11vnc? 

   Q-130: Why don't I hear the "Beeps" in my X session (e.g. when typing
   tput bel in an xterm)? 

   Q-131: Does x11vnc work with IPv6? 

   Q-132: Thanks for your program or for your help! Can I make a
   donation? 

   Q-133: I am experiencing extreme framebuffer update lags and am
   using an Intel graphics card. What to do?

_________________________________________________________________


   [Building and Starting]

   Q-1: I can't get x11vnc to start up. It says "XOpenDisplay failed
   (null)" or "Xlib: connection to ":0.0" refused by server Xlib: No
   protocol specified" and then exits. What do I need to do?

   For the former error, you need to specify the X display to connect to
   (it also needs to be on the same machine the x11vnc process is to run
   on.) Set your DISPLAY environment variable (or use the -display
   option) to specify it. Nearly always the correct value will be ":0"
   (in fact, x11vnc will now assume :0 if given no other information.)


   For the latter error, you need to set up the X11 permissions
   correctly.

   To make sure X11 permissions are the problem do this simple test:
   while sitting at the physical X display open a terminal window
   (gnome-terminal, xterm, etc.) You should be able to run x11vnc
   successfully without any need for special steps or command line
   options in that terminal (i.e. just type "x11vnc".) If that works OK
   then you know X11 permissions are the only thing preventing it from
   working when you try to start x11vnc via, say, a remote shell.

   How to Solve:  See the xauth(1), Xsecurity(7), and xhost(1) man pages
   or this Howto for much info on X11 permissions. For example, you may
   need to set your XAUTHORITY environment variable (or use the -auth
   option) to point to the correct MIT-MAGIC-COOKIE file (e.g.
   /home/joe/.Xauthority or /var/gdm/:0.Xauth or /var/lib/kdm/A:0-crWk72K
   or /tmp/.gdmzndVlR, etc, etc.), or simply be sure you run x11vnc as
   the correct user (i.e. the user who is logged into the X session you
   wish to view.)

   Note: The MIT cookie file contains the secret key that allows x11vnc
   to connect to the desired X display.

   If, say, sshd has set XAUTHORITY to point to a random file it has
   created for X forwarding that will cause problems. (Under some
   circumstances even su(1) and telnet(1) can set XAUTHORITY. See also
   the gdm parameter NeverPlaceCookiesOnNFS that sets XAUTHORITY to a
   random filename in /tmp for the whole X session.)

   Running x11vnc as root is often not enough: you need to know where the
   MIT-MAGIC-COOKIE file for the desired X display is.

   Example solution:
  x11vnc -display :0 -auth /var/gdm/:0.Xauth

   (this is for the display manager gdm and requires root permission to
   read the gdm cookie file, see this faq for other display manager
   cookie file names.)

   Note as of Feb/2007 you can also try the -find option instead of
   "-display ..." and see if that finds your display and Xauthority.

   Less safe, but to avoid figuring out where the correct XAUTHORITY file
   is, if the person sitting at the physical X session types "xhost
   +localhost" then one should be able to attach x11vnc to the session
   (from the same machine.) The person could then type "xhost -localhost"
   after x11vnc has connected to go back to the default permissions.
   Also, for some situations the "-users lurk=" option may soon be of use
   (please read the documentation on the -users option.)

   To test out your X11 permissions from a remote shell, set DISPLAY and
   possibly XAUTHORITY (see your shell's man page, bash(1), tcsh(1), on
   how to set environment variables) and type xdpyinfo in the same place
   you will be typing (or otherwise running) x11vnc. If information is
   printed out about the X display (screen sizes, supported extensions,
   color visuals info) that means the X11 permissions are set up
   properly: xdpyinfo successfully connected to DISPLAY! You could also
   type xclock and make sure no errors are reported (a clock should
   appear on the X display, press Ctrl-C to stop it.) If these work, then
   typing "x11vnc" in the same environment should also work.

   Important: if you cannot get your X11 permissions so that the xdpyinfo
   or xclock tests work, x11vnc also will not work (all of these X
   clients must be allowed to connect to the X server to function
   properly.)

   Firewalls: Speaking of permissions, it should go without saying that
   the host-level firewall will need to be configured to allow
   connections in on a port. E.g. 5900 (default VNC port) or 22 (default
   SSH port for tunnelling VNC.) Most systems these days have firewalls
   turned on by default, so you will actively have to do something to
   poke a hole in the firewall at the desired port number. See your
   system administration tool for Firewall settings (Yast, Firestarter,
   etc.)


   Q-2: I can't get x11vnc and/or libvncserver to compile.

   Make sure you have gcc (or other C compiler) and all of the required
   libraries and the corresponding -dev/-devel packages installed. These
   include Xorg/XFree86, libX11, libjpeg, libz, libssl, ... and don't
   forget the devs: libjpeg-dev, libssl-dev ...

   The most common build problem that people encounter is that the
   necessary X11 libraries are installed on their system however it does
   not have the corresponding -dev/-devel packages installed. These dev
   packages include C header files and build-time .so symlink. It is a
   shame the current trend in distros is to not install the dev package
   by default when the the library runtime package is installed... (it
   diminishes the power of open source)

   As of Nov/2006 here is a list of libraries that x11vnc usually likes
   to use:
libc.so        libX11.so       libXtst.so       libXext.so
libXfixes.so   libXdamage.so   libXinerama.so   libXrandr.so
libz.so        libjpeg.so      libpthread.so
libssl.so      libcrypto.so    libcrypt.so

   although x11vnc will be pretty usable with the subset: libc.so,
   libX11.so, libXtst.so, libXext.so, libz.so, and libjpeg.so.

   After running the libvncserver configure, carefully examine the output
   and the messages in the config.log file looking for missing
   components. For example, if the configure output looks like:
  checking how to run the C preprocessor... gcc -E
  checking for X... no
  checking for XkbSelectEvents in -lX11... no
  checking for XineramaQueryScreens in -lXinerama... no
  checking for XTestFakeKeyEvent in -lXtst... no

   or even worse:
  checking for C compiler default output file name... configure: error:
  C compiler cannot create executables
  See `config.log' for more details.

   there is quite a bit wrong with the build environment. Hopefully
   simply adding -dev packages and/or gcc or make will fix it.

   For Debian the list seems to be:
  gcc
  make
  libc6-dev
  libjpeg8-dev           (formerly libjpeg62-dev)
  libx11-dev
  x11proto-core-dev      (formerly x-dev)
  libxext-dev
  libxtst-dev
  libxdamage-dev
  libxfixes-dev
  libxrandr-dev
  libxinerama-dev
  libxss-dev             (formerly xlibs-static-dev)
  zlib1g-dev
  libssl-dev
  libavahi-client-dev
  linux-libc-dev         (only needed for linux console rawfb support)

   Note that depending on your OS version the above names may have been
   changed and/or additional packages may be needed.

   For Redhat the list seems to be:
  gcc
  make
  glibc-devel
  libjpeg-devel
  libX11-devel
  xorg-x11-proto-devel
  libXdamage-devel
  libXfixes-devel
  libXrandr-devel
  zlib-devel
  openssl-devel
  avahi-devel
  kernel-headers         (only needed for linux console rawfb support)

   For other distros or OS's the package names may not be the same but
   will look similar. Also, distros tend to rename packages as well so
   the above list may be out of date. So only use the above lists as
   hints for the package names that are needed.

   Have a look at Misc. Build Problems for additional fixes.

   Note: there is growing trend in Linux and other distros to slice up
   core X11 software into more and smaller packages. So be prepared for
   more headaches compiling software...


   Q-3: I just built x11vnc successfully, but when I use it my keystrokes
   and mouse button clicks are ignored  (I am able to move the mouse
   though.)

   This is most likely due to you not having a working build environment
   for the XTEST client library libXtst.so. The library is probably
   present on your system, but the package installing the build header
   file is missing.

   If you were watching carefully while configure was running you would
   have seen:
  checking for XTestFakeKeyEvent in -lXtst... no

   The solution is to add the necessary build environment package (and
   the library package if that is missing too.) On Debian the build
   package is libxtst-dev. Other distros/OS's may have it in another
   package.

   x11vnc will build without support for this library (e.g. perhaps one
   wants a view-only x11vnc on a stripped down or embedded system...) And
   at runtime it will also continue to run even if the X server it
   connects to does not support XTEST. In both cases it cannot inject
   keystrokes or button clicks since XTEST is needed for that (it can
   still move the mouse pointer using the X API XWarpPointer().)

   You will see a warning message something like this at run time:
  20/03/2005 22:33:09 WARNING: XTEST extension not available (either missing fr
om
  20/03/2005 22:33:09   display or client library libXtst missing at build time
.)
  20/03/2005 22:33:09   MOST user input (pointer and keyboard) will be DISCARDE
D.
  20/03/2005 22:33:09   If display does have XTEST, be sure to build x11vnc wit
h
  20/03/2005 22:33:09   a working libXtst build environment (e.g. libxtst-dev,
  20/03/2005 22:33:09   or other packages.)
  20/03/2005 22:33:09 No XTEST extension, switching to -xwarppointer mode for
  20/03/2005 22:33:09   pointer motion input.

   Also, as of Nov/2006 there will be a configure build time warning as
   well:
  ...
  checking for XFixesGetCursorImage in -lXfixes... yes
  checking for XDamageQueryExtension in -lXdamage... yes
  configure: WARNING:
  ==========================================================================
  A working build environment for the XTEST extension was not found (libXtst).
  An x11vnc built this way will be only barely usable.  You will be able to
  move the mouse but not click or type.  There can also be deadlocks if an
  application grabs the X server.

  It is recommended that you install the necessary development packages
  for XTEST (perhaps it is named something like libxtst-dev) and run
  configure again.
  ==========================================================================


   Q-4: Help, I need to run x11vnc on Solaris 2.5.1 (or other old
   Unix/Linux) and it doesn't compile!

   We apologize that x11vnc does not build cleanly on older versions of
   Solaris, Linux, etc.: very few users are on these old releases.

   We have heard that since Dec/2004 a Solaris 2.6 built x11vnc will run
   on Solaris Solaris 2.5 and 2.5.1 (since a workaround for XConvertCase
   is provided.)

   In any event, here is a workaround for Solaris 2.5.1 (and perhaps
   earlier and perhaps non-Solaris):

   First use the environment settings (CPPFLAGS, LDFLAGS, etc.) in the
   above Solaris build script to run the configure command. That should
   succeed without failure. Then you have to hand edit the autogenerated
   rfb/rfbconfig.h file in the source tree, and just before the last
   #endif at the bottom of that file insert these workaround lines:
struct timeval _tmp_usleep_tv;
#define usleep(x) \
    _tmp_usleep_tv.tv_sec  = (x) / 1000000; \
    _tmp_usleep_tv.tv_usec = (x) % 1000000; \
    select(0, NULL, NULL, NULL, &_tmp_usleep_tv);
int gethostname(char *name, int namelen);
long random();
int srandom(unsigned int seed);
#undef LIBVNCSERVER_HAVE_LIBPTHREAD
#define SHUT_RDWR 2
typedef unsigned int in_addr_t;
#define snprintf(a, n, args...) sprintf((a), ## args)

   Then run make with the Solaris build script environment, everything
   should compile without problems, and the resulting x11vnc binary
   should work OK. If some non-x11vnc related programs fail (e.g. test
   programs) and the x11vnc binary is not created try "make -k" to have
   it keep going. Similar sorts of kludges in rfb/rfbconfig.h can be done
   on other older OS (Solaris, Linux, ...) releases.

   Here are some notes for similar steps that need to be done to build on
   SunOS 4.x

   Please let us know if you had to use the above workaround (and whether
   it worked or not.) If there is enough demand we will try to push clean
   compilations back to earlier Solaris, Linux, etc, releases.


   Q-5: Where can I get a precompiled x11vnc binary for my Operating
   System?

   Hopefully the build steps above and FAQ provide enough info for a
   painless compile for most environments. Please report problems with
   the x11vnc configure, make, etc. on your system (if your system is
   known to compile other GNU packages successfully.)

   There are precompiled x11vnc binaries built by other groups that are
   available at the following locations:
    Slackware:      (.tgz)  http://www.linuxpackages.net/

   SuSE: (.rpm) http:/software.opensuse.org/ Gentoo: (info)
   http://gentoo-wiki.com/ and http://gentoo-portage.com/ FreeBSD: (.tbz)
   http://www.freebsd.org/ http://www.freshports.org/net/x11vnc NetBSD:
   (src) http://pkgsrc.se/x11/x11vnc OpenBSD: (.tgz) http://openports.se/
   Arch Linux: (.tgz) http://www.archlinux.org/ Nokia 770 (.deb)
   http://mike.saunby.googlepages.com/x11vncfornokia7702 Sharp Zaurus
   http://www.focv.com/ Debian: (.deb) http://packages.debian.org/x11vnc
   Redhat/Fedora: (.rpm) http://packages.sw.be/x11vnc RPMforge
   http://dag.wieers.com/rpm/packages/x11vnc/ (N.B.: unmaintained after
   0.9.3) Solaris: (pkg) http://www.sunfreeware.com/

   If the above binaries don't work and building x11vnc on your OS fails
   (and all else fails!) you can try one of My Collection of x11vnc
   Binaries for various OS's and x11vnc releases.

   As a general note, the x11vnc program is simple enough you don't
   really need to install a package: the binary will in most cases work
   as is and from any location (as long as your system libraries are not
   too old, etc.) So, for Linux distributions that are not one of the
   above, the x11vnc binary from the above packages has a good chance of
   working. You can "install" it by just copying the x11vnc binary to the
   desired directory in your PATH. Tip on extracting files from a Debian
   package: extract the archive via a command like: "ar x
   x11vnc_0.6-2_i386.deb" and then you can find the binary in the
   resulting data.tar.gz tar file. Also, rpm2cpio(1) is useful in
   extracting files from rpm packages.

   If you use a standalone binary like this and also want x11vnc to serve
   up the Java VNC Viewer jar file (either SSL enabled or regular one),
   then you will need to extract the classes subdirectory from the source
   tarball and point x11vnc to it via the -httpdir option. E.g.:
    x11vnc -httpdir /path/to/x11vnc-0.9.9/classes/ssl ...

   Alternatively, you can also go for a more up-to-date approach and use
   the very decent noVNC viewer (https://kanaka.github.io/noVNC/) that is
   purely HTML5 and does not need any plugins at all.


   Q-6: Where can I get a VNC Viewer binary (or source code) for the
   Operating System I will be viewing from?

   To obtain VNC viewers for the viewing side (Windows, Mac OS, or Unix)
   try here:
     * http://www.tightvnc.com/download.html
     * http://www.realvnc.com/download-free.html
     * http://sourceforge.net/projects/cotvnc/
     * http://www.ultravnc.com/
     * Our Enhanced TightVNC Viewer (SSVNC)

       [ssvnc.gif]


   Q-7: How can I see all of x11vnc's command line options and
   documentation on how to use them?

   Run:  x11vnc -opts   to list just the option names or run:  x11vnc
   -help   for long descriptions about each option. The output is listed
   here as well. Yes, x11vnc does have a lot of options, doesn't it...


   Q-8: I don't like typing arcane command line options every time I
   start x11vnc. What can I do? Is there a config file? Or a GUI?

   You could create a shell script that calls x11vnc with your options:
#!/bin/sh
#
# filename: X11vnc  (i.e. not "x11vnc")
# It resides in a directory in $PATH. "chmod 755 X11vnc" has been run on it.
#
x11vnc -wait 50 -localhost -rfbauth $HOME/.vnc/passwd -display :0 $*

   a similar thing can be done via aliases in your shell (bash, tcsh,
   csh, etc..)

   Or as of Jun/2004 you can use the simple $HOME/.x11vncrc config file
   support. If that file exists, each line is taken as a command line
   option. E.g. the above would be:
# this is a comment in my ~/.x11vncrc file
wait 50        # this is a comment to the end of the line.
-localhost     # note: the leading "-" is optional.
rfbauth  /home/fred/.vnc/passwd
display :0

   As of Dec/2004 there is now a simple Tcl/Tk GUI based on the
   remote-control functionality ("-R") that was added. The /usr/bin/wish
   program is needed for operation. The gui is not particularly
   user-friendly, it just provides a point and click mode to set all the
   many x11vnc parameters and obtain help on them. It is also very useful
   for testing. See the -gui option for more info. Examples: "x11vnc ...
   -gui" and "x11vnc ... -gui other:0" in the latter case the gui is
   displayed on other:0, not the X display x11vnc is polling. There is
   also a "-gui tray" system tray mode.

   [tkx11vnc.gif]

   NOTE: You may need to install the "wish" or "tk" or "tk8.4" package
   for the gui mode to work (the package name depends on your OS/distro.)
   The tcl/tk "wish" interpreter is used. In debian (and so ubuntu too)
   one would run "apt-get install tk" or perhaps "apt-get install tk8.4"


   Q-9: How can I get the GUI to run in the System Tray, or at least be a
   smaller, simpler icon?

   As of Jul/2005 the gui can run in a more friendly small icon mode
   "-gui icon" or in the system tray: "-gui tray". It has balloon status,
   a simple menu, and a Properities dialog. The full, complicated, gui is
   only available under "Advanced". Other improvements were added as
   well. Try "Misc -> simple_gui" for a gui with fewer esoteric menu
   items.

   If the gui fails to embed itself in the system tray, do a retry via
   "Window View -> icon" followed by "Window View -> tray" with the popup
   menu.

   For inexperienced users starting up x11vnc and the GUI while sitting
   at the physical X display (not remotely), using something like "x11vnc
   -display :0 -gui tray=setpass" might be something for them that they
   are accustomed to in a Desktop environment (it prompts for an initial
   password, etc.) This is a basic "Share My Desktop" usage mode.

   As of Nov/2008 in x11vnc 0.9.6 there is a desktop menu item
   (x11vnc.desktop) that runs this command:
   x11vnc -gui tray=setpass -rfbport PROMPT -logfile %HOME/.x11vnc.log.%VNCDISP
LAY

   which also prompts for which VNC port to use and a couple other
   parameters.


   Q-10: How can I get x11vnc to listen on a different port besides the
   default VNC port (5900)?

   Use something like, e.g., "x11vnc -rfbport 5901" to force it to use
   port 5901 (this is VNC display :1.) If something else is using that
   port x11vnc will exit immediately. If you do not supply the -rfbport
   option, it will autoprobe starting at 5900 and work its way up to 5999
   looking for a free port to listen on. In that case, watch for the
   PORT=59xx line to see which port it found, then subtract 5900 from it
   for the VNC display number to enter into the VNC Viewer(s).

   The "-N" option will try to match the VNC display number to the X
   display (e.g. X11 DISPLAY of :5 (port 6005) will have VNC display :5
   (port 5905).)

   Also see the "-autoport n" option to indicated at which value the auto
   probing should start at.


   Q-11: My Firewall/Router doesn't allow VNC Viewers to connect to
   x11vnc.

   See the Firewalls/Routers discussion.


   Q-12: Is it possible for a VNC Viewer and a VNC Server to connect to
   each other even though both are behind Firewalls that block all
   incoming connections?

   This is very difficult or impossible to do unless a third machine,
   reachable by both, is used as a relay. So we assume a third machine is
   somehow being used as a relay.

   (Update: It may be possible to do "NAT-2-NAT" without a relay machine
   by using a UDP tunnel such as http://samy.pl/pwnat/. All that is
   required is that both NAT firewalls allow in UDP packets from an IP
   address to which a UDP packet has recently been sent to. If you try it
   out let us know how it went.)

   In the following discussion, we will suppose port 5950 is being used
   on the relay machine as the VNC port for the rendezvous.

   A way to rendezvous is to have the VNC Server start a reverse
   connection to the relay machine:
   x11vnc -connect third-machine.net:5950 ...

   and the VNC viewer forward connects as usual:
   vncviewer third-machine.net:50

   Or maybe two ports would be involved, e.g. the viewer goes to display
   :51 (5951.) It depends on the relay software being used.

   What software to run on third-machine? A TCP relay of some sort could
   be used... Try a google search on "tcp relay" or "ip relay". However,
   note that this isn't a simple redirection because it hooks up two
   incoming connections. You can look at our UltraVNC repeater
   implementation ultravnc_repeater.pl for ideas and possibly to
   customize.

   Also, if you are not the admin of third-machine you'd have to convince
   the owner to allow you to install this software (and he would likely
   need to open his server's firewall to allow the port through.)

   It is recommended that SSL is used for encryption (e.g. "-ssl SAVE")
   when going over the internet.

   We have a prototype for performing a rendezvous via a Web Server
   acting as the relay machine. Download the vncxfer CGI script and see
   the instructions at the top.

   Once that CGI script is set up on the website, both users go to, say,
   http://somesite.com/vncxfer (or maybe a "/cgi-bin" directory or ".cgi"
   suffix must be used.) Previously, both have agreed on the same session
   name (say by phone or email) , e.g. "5cows", and put that into the
   entry form on the vncxfer starting page (hopefully separated by a few
   seconds, so the relay helper can fully start up at the first request.)

   The page returned tells them the hostname and port number and possible
   command to use for forward (VNC Viewer) and reverse (VNC Server, i.e.
   x11vnc) connections as described above.

   Also since Oct/2007, x11vnc can connect directly (no web browser),
   like this:
   x11vnc ... -connect localhost:0 -proxy 'http://somesite.com/vncxfer?session=
5cows&'

   Unfortunately the prototype requires that the Web server's firewall
   allow in the port (e.g. 5950) used for the rendezvous. Most web
   servers are not configured to do this, so you would need to ask the
   admin to do this for you. Nearly all free webspace sites, e.g.
   www.zendurl.com, will not allow your CGI script to be an open relay
   like this. (If you find one that does allow this, let me know!)

   Maybe someday a clever trick will be thought up to relax the listening
   port requirement (e.g. use HTTP/CGI itself for the transfer... it is
   difficult to emulate a full-duplex TCP connection with them.)

   See also the Firewalls/Routers discussion and Reverse Connection Proxy
   discussion.


   SSH method: If both users (i.e. one on Viewer-side and the other on
   x11vnc server side) have SSH access to a common machine on the
   internet (or otherwise mutually reachable), then SSH plumbing can be
   used to solve this problem. The users create SSH tunnels going through
   the SSH login machine.

   Instead of assuming port 5900 is free on the SSH machine, we will
   assume both users agreed to use 5933. This will illustrate how to use
   a different port for the redir. It could be any port, what matters is
   that both parties refer to the same one.

   Set up the Tunnel from the VNC Server side:
   ssh -t -R 5933:localhost:5900 user@third-machine.net

   Set up the Tunnel from the VNC Viewer side:
   ssh -t -L 5900:localhost:5933 user@third-machine.net

   Run Server on the VNC Server side:
   x11vnc -rfbport 5900 -localhost ...

   Run Viewer on the VNC Viewer side:
   vncviewer -encodings "copyrect tight zrle hextile" localhost:0

   (we assume the old-style -encodings option needs to be used. See here
   for details.)

   If the SSH machine has been configured (see sshd_config(5)) with the
   option GatewayPorts=yes, then the tunnel set up by the VNC Server will
   be reachable directly by the VNC viewer (as long as the SSH machine's
   firewall does not block the port, 5933 in this example.) So in that
   case the Viewer side does not need to run any ssh command, but rather
   only runs:
   vncviewer third-machine.net:33

   In this case we recommend SSL be used for encryption.

   The creation of both tunnels can be automated. As of Oct/2007 the -ssh
   x11vnc option is available and so only this command needs to be run on
   the VNC Server side:
   x11vnc -ssh user@third-machine.net:33 ...

   (the SSH passphrase may need to be supplied.)

   To automate on the VNC Viewer side, the user can use the Enhanced
   TightVNC Viewer (SSVNC) by:
     * Clicking on 'Use SSH'
     * Entering user@third-machine.net:33 into 'VNC Host:Display' entry
       box
     * Clicking on 'Connect'

   As above, if the SSH GatewayPorts=yes setting is configured the Viewer
   side doesn't need to create a SSH tunnel. In SSVNC the Viewer user
   could instead select 'Use SSL' and then, e.g., on the Server side
   supply "-ssl SAVE" to x11vnc. Then end-to-end SSL encryption would be
   used (in addition to the SSH encryption on the Server-side leg.)


   Q-13: Can I make x11vnc more quiet and also go into the background
   after starting up?

   Use the -q and -bg options, respectively.  (also: -quiet is an alias
   for -q)

   Note that under -bg the stderr messages will be lost unless you use
   the "-o logfile" option.


   Q-14: Sometimes when a VNC viewer dies abruptly, x11vnc also dies with
   the error message like: "Broken pipe". I'm using the -forever mode and
   I want x11vnc to keep running.

   As of Jan/2004 the SIGPIPE signal is ignored. So if a viewer client
   terminates abruptly, libvncserver will notice on the next I/O
   operation and will close the connection and continue on.

   Up until of Apr/2004 the above fix only works for BSD signal systems
   (Linux, FreeBSD, ...) For SYSV systems there is a workaround in place
   since about Jun/2004.


   Q-15: The Windows TightVNC 1.3.9 Viewer cannot connect to x11vnc.

   This appears to be fixed in x11vnc version 0.9 and later. If you need
   to use an earlier version of x11vnc, try using the "-rfbversion 3.7"
   option. In general sometimes one can get a misbehaving viewer to work
   by supplying rfb versions 3.7 or 3.3.


   Q-16: KDE's krdc VNC viewer cannot connect to x11vnc.

   This has been fixed in x11vnc version 0.8.4. More info here, here, and
   here.


   Q-17: When I start x11vnc on an Alpha Tru64 workstation the X server
   crashes!

   This is a bug in the X server obviously; an X client should never be
   able to crash it.

   The problem seems to be with the RECORD X extension and so a
   workaround is to use the "-noxrecord" x11vnc command line option.


   Q-18: When running x11vnc on an IBM AIX workstation after a few
   minutes the VNC connection freezes.

   One user reports when running x11vnc on AIX 5.3 in his CDE session
   after a few minutes or seconds x11vnc will "freeze" (no more updates
   being sent, etc.) The freezing appeared to be worse for versions later
   than 0.9.2.

   The problem seems to be with the RECORD X extension on AIX and so a
   workaround is to use the "-noxrecord" x11vnc command line option. The
   user found no freezes occurred when using that option.


   Q-19: Are there any build-time customizations possible, e.g. change
   defaults, create a smaller binary, etc?

   There are some options. They are enabled by adding something like
   -Dxxxx=1 to the CPPFLAGS environment variable before running configure
   (see the build notes for general background.)
/*
 * Mar/2006
 * Build-time customization via CPPFLAGS.
 *
 * Summary of options to include in CPPFLAGS for custom builds:
 *
 * -DVNCSHARED  to have the vnc display shared by default.
 * -DFOREVER  to have -forever on by default.
 * -DNOREPEAT=0  to have -repeat on by default.
 * -DADDKEYSYMS=0  to have -noadd_keysyms the default.
 *
 * -DREMOTE_DEFAULT=0  to disable remote-control on by default (-yesremote.)
 * -DREMOTE_CONTROL=0  to disable remote-control mechanism completely.
 * -DEXTERNAL_COMMANDS=0  to disable the running of all external commands.
 * -DFILEXFER=0  disable filexfer.
 *
 * -DHARDWIRE_PASSWD=...      hardwired passwords, quoting necessary.
 * -DHARDWIRE_VIEWPASSWD=...
 * -DNOPW=1                   make -nopw the default (skip warning)
 * -DUSEPW=1                  make -usepw the default
 * -DPASSWD_REQUIRED=1        exit unless a password is supplied.
 * -DPASSWD_UNLESS_NOPW=1     exit unless a password is supplied and no -nopw.
 *
 * -DWIREFRAME=0  to have -nowireframe as the default.
 * -DWIREFRAME_COPYRECT=0  to have -nowirecopyrect as the default.
 * -DWIREFRAME_PARMS=...   set default -wirecopyrect parameters.
 * -DSCROLL_COPYRECT=0     to have -noscrollcopyrect as the default.
 * -DSCROLL_COPYRECT_PARMS=...  set default -scrollcopyrect parameters.
 * -DSCALING_COPYRECT=0
 * -DXDAMAGE=0    to have -noxdamage as the default.
 * -DSKIPDUPS=0   to have -noskip_dups as the default or vice versa.
 *
 * -DPOINTER_MODE_DEFAULT={0,1,2,3,4}  set default -pointer_mode.
 * -DBOLDLY_CLOSE_DISPLAY=0  to not close X DISPLAY under -rawfb.
 * -DSMALL_FOOTPRINT=1  for smaller binary size (no help, no gui, etc)
 *                      use 2 or 3 for even smaller footprint.
 * -DNOGUI  do not include the gui tkx11vnc.
 * -DPOLL_8TO24_DELAY=N
 * -DDEBUG_XEVENTS=1  enable printout for X events.
 *
 * Set these in CPPFLAGS before running configure. E.g.:
 *
 *   % env CPPFLAGS="-DFOREVER -DREMOTE_CONTROL=0" ./configure
 *   % make
 */

   If other things (e.g. "-I ...") are needed in CPPFLAGS add them as
   well.

   On some systems is seems you need to set LC_ALL=C for configure to
   work properly...

   Be careful the following two variables: HARDWIRE_PASSWD and
   HARDWIRE_VIEWPASSWD. If set (remember to include the double quotes
   around the string), they will be used as default values for the
   -passwd and -viewpasswd options. Of course the strings will exist
   unobscured in the x11vnc binary: it better not be readable by
   unintendeds. Perhaps this is of use in remote access for an embedded
   application, etc...

   Let us know if more build-time customizations would be useful.


   [Win2VNC Related]

   Q-20: I have two separate machine displays in front of me, one Windows
   the other X11: can I use x11vnc in combination with Win2VNC in
   dual-screen mode to pass the keystrokes and mouse motions to the X11
   display?

   Yes, for best response start up x11vnc with the "-nofb" option
   (disables framebuffer polling, and does other optimizations) on the
   secondary display (X11) machine. Then start up Win2VNC on the primary
   display (Windows) referring it to the secondary display.

   This will also work X11 to X11 using x2vnc, however you would probably
   just want to avoid VNC and use x2x for that.

   For reference, here are some links to Win2VNC-like programs for
   multiple monitor setups:
     * Original Win2VNC
     * Enhanced Win2VNC (broken?) and sourceforge link
     * x2vnc
     * x2x
     * zvnc (MorphOS)

   All of them will work with x11vnc (except x2x where it is not needed.)


   Q-21: I am running Win2VNC on my Windows machine and "x11vnc -nofb" on
   Unix to pass keyboard and mouse to the Unix monitor. Whenever I start
   Win2VNC it quickly disconnects and x11vnc says:
   rfbProcessClientNormalMessage: read: Connection reset by peer

   Is the default visual of the X display you run x11vnc on low color
   (e.g. 8 bit per pixel PseudoColor)? (you can run xdpyinfo to check,
   look in the "screen" section.) There seems to be a bug in Win2VNC in
   that it cannot deal correctly with colormaps (PseudoColor is the most
   common example of a visual with a colormap.)

   If so, there are a couple options. 1) Can you set the default visual
   on your display to be depth 24 TrueColor? Sun machines often have 8+24
   overlay/multi-depth visuals, and you can make the default visual depth
   24 TrueColor (see fbconfig(1) and Xsun(1).) 2) As of Feb/2004 x11vnc
   has the -visual option to allow you to force the framebuffer visual to
   whatever you want (this usually messes up the colors unless you are
   very clever.) In this case, the option provides a convenient
   workaround for the Win2VNC bug:
  x11vnc -nofb -visual TrueColor -display :0 ...

   So the visual will be set to 8bpp TrueColor and Win2VNC can handle
   this. Since Win2VNC does not use the framebuffer data there should be
   no problems in doing this.

   Q-22: Can I run "x11vnc -nofb" on a Mac OS X machine to redirect mouse
   and keyboard input to it from Windows and X11 machines via Win2VNC and
   x2vnc, respectively?

   Yes, as of Nov/2006 you can. There may be a trick or two you'll need
   to do to get the Clipboard exchange between the machines to work.



   [Color Issues]

   Q-23: The X display I run x11vnc on is only 8 bits per pixel (bpp)
   PseudoColor (i.e. only 256 distinct colors.) The x11vnc colors may
   start out OK, but after a while they are incorrect in certain windows.

   Use the -flashcmap option to have x11vnc watch for changes in the
   colormap, and propagate those changes back to connected clients. This
   can be slow (since the whole screen must be updated over the network
   whenever the colormap changes.) This flashing colormap behavior often
   happens if an application installs its own private colormap when the
   mouse is in its window. "netscape -install" is a well-known historical
   example of this. Consider reconfiguring the system to 16 bpp or depth
   24 TrueColor if at all possible.

   Also note the option -8to24 (Jan/2006) can often remove the need for
   flashing the colormap. Everything is dynamically transformed to depth
   24 at 32 bpp using the colormaps. There may be painting errors however
   (see the following FAQ for tips on reducing and correcting them.)

   In some rare cases (SCO unixware) the -notruecolor option has
   corrected colors on 8bpp displays. The red, green, and blue masks were
   non-zero in 8bpp PseudoColor on an obscure setup, and this option
   corrected the problems.


   Q-24: Color problems: Why are the colors for some windows incorrect in
   x11vnc? BTW, my X display has nice overlay/multi-depth visuals of
   different color depths: e.g. there are both depth 8 and 24 visuals
   available at the same time.

   You may want to review the previous question regarding 8 bpp
   PseudoColor.

   On some hardware (Sun/SPARC and SGI), the -overlay option discussed a
   couple paragraphs down may solve this for you (you may want to skip to
   it directly.) On other hardware the less robust -8to24 option may help
   (also discussed below.)

   Run xdpyinfo(1) to see what the default visual is and what the depths
   of the other visuals are. Does the default visual have a depth of 8
   but there are other visuals of depth 24? If it does, can you possibly
   re-configure your X server to make a depth 24 visual the default? If
   you can do it, this will save you a lot of grief WRT colors and x11vnc
   (and for general usage too!) Here is how I do this on an old
   Sparcstation 20 running Solaris 9 with SX graphics
  xinit -- -dev /dev/fb defclass TrueColor defdepth 24

   and it works nicely (note: to log into console from the dtlogin
   window, select "Options -> Command Line Login", then login and enter
   the above command.) See the -dev section of the Xsun(1) manpage for a
   description of the above arguments. If you have root permission, a
   more permanent and convenient thing to do is to record the arguments
   in a line like:
  :0  Local local_uid@console root /usr/openwin/bin/Xsun -dev /dev/fb defclass
TrueColor defdepth 24

   in /etc/dt/config/Xservers (copy /usr/dt/config/Xservers.) Also look
   at the fbconfig(1) and related manpages (e.g. ffbconfig, m64config,
   pgxconfig, SUNWjfb_config, etc ...) for hardware framebuffer settings
   that may achieve the same effect.

   In general for non-Sun machines, look at the "-cc class" and related
   options in your X server manpage (perhaps Xserver(1)), it may allow
   modifying the default visual (e.g. "-cc 4", see <X11/X.h> for the
   visual class numbers.) On XFree86 some video card drivers (e.g. Matrox
   mga) have settings like Option "Overlay" "24,8" to support multi-depth
   overlays. For these, use the "-cc 4" X server command line option to
   get a depth 24 default visual.


   The -overlay mode: Another option is if the system with overlay
   visuals is a Sun system running Solaris or SGI running IRIX you can
   use the -overlay x11vnc option (Aug/2004) to have x11vnc use the
   Solaris XReadScreen(3X11) function to poll the "true view" of the
   whole screen at depth 24 TrueColor. XReadDisplay(3X11) is used on
   IRIX. This is useful for Legacy applications (older versions of
   Cadence CAD apps are mentioned by x11vnc users) that require the
   default depth be 8bpp, or the app will use a 8bpp visual even if depth
   24 visuals are available, and so the default depth workaround
   described in the previous paragraph is not sufficient for these apps.

   It seems that Xorg is working toward supporting XReadDisplay(3X11) as
   part of the RENDER extension work. When it does support it and
   provides a library API x11vnc will be modified to take advantage of
   the feature to support -overlay on Linux, *BSD, etc. Until then see
   the -8to24 mode below.

   Misc. notes on -overlay mode: An amusing by-product of -overlay mode
   is that the mouse cursor shape is correct! (i.e. XFIXES is not
   needed.) The -overlay mode may be somewhat slower than normal mode due
   to the extra framebuffer manipulations that must be performed. Also,
   on Solaris there is a bug in that for some popup menus, the windows
   they overlap will have painting errors (flashing colors) while the
   popup is up (a workaround is to disable SaveUnders by passing -su to
   Xsun, e.g. in your /etc/dt/config/Xservers file.)


   The -8to24 mode: The -8to24 x11vnc option (Jan/2006) is a kludge to
   try to dynamically rewrite the pixel values so that the 8bpp part of
   the screen is mapped onto depth 24 TrueColor. This is less robust than
   the -overlay mode because it is done by x11vnc outside of the X
   server. So only use it on OS's that do not support -overlay. The
   -8to24 mode will work if the default visual is depth 24 or depth 8. It
   scans for any windows within 3 levels of the root window that are 8bpp
   (i.e. legacy application), or in general ones that are not using the
   default visual. For the windows it finds it uses XGetSubImage() to
   retrieve the pixels values and uses the correct indexed colormap to
   create a depth 24 TrueColor view of the whole screen. This depth 24,
   32bpp view is exported via VNC.

   Even on pure 8bpp displays it can be used as an alternative to
   -flashcmap to avoid color flashing completely.

   This scheme is approximate and can often lead to painting errors. You
   can manually correct most painting errors by pressing 3 Alt_L's in a
   row, or by using something like: -fixscreen V=3.0 to automatically
   refresh the screen every 3 seconds. Also -fixscreen 8=3.0 has been
   added to just refresh the non-default visual parts of the screen.

   In general the scheme uses many resources and may give rise to
   sluggish behavior. If multiple windows are using different 8bpp
   indexed colormaps all but one window may need to be iconified for the
   colors to be correct. There are a number of tunable parameters to try
   to adjust performance and painting accuracy. The option -8to24
   nogetimage can give a nice speedup if the default depth 24 X server
   supports hiding the 8bpp bits in bits 25-32 of the framebuffer data.
   On very slow machines -8to24 poll=0.2,cachewin=5.0 gives an useful
   speedup. See the -8to24 help description for information on tunable
   parameters, etc.


   Colors still not working correctly? Run xwininfo on the application
   with the incorrect colors to verify that the depth of its visual is
   different from the default visual depth (gotten from xdpyinfo.) One
   possible workaround in this case is to use the -id option to point
   x11vnc at the application window itself. If the application is
   complicated (lots of toplevel windows and popup menus) this may not be
   acceptable, and may even crash x11vnc (but not the application.) See
   also -appshare.

   It is theoretically possible to solve this problem in general (see
   xwd(1) for example), but it does not seem trivial or sufficiently fast
   for x11vnc to be able to do so in real time. The -8to24 method does
   this approximately and is somewhat usable. Fortunately the -overlay
   option works for Solaris machines with overlay visuals where most of
   this problem occurs.


   Q-25: I am on a high color system (depth >= 24) but I seem to have
   colormap problems. They either flash or everything is very dark.

   This can happen if the default Visual (use xdpyinfo to list them) is
   DirectColor instead of TrueColor. These are both usually used in high
   color modes, but whereas TrueColor uses static ramps for the Red,
   Green, and Blue components, DirectColor has arbitrary colormaps for
   the Red, Green, and Blue Components. Currently x11vnc cannot decode
   these colormaps and treats them just like TrueColor.

   The only workaround so far is to restart the X server with the "-cc 4"
   option to force TrueColor as the default visual (DirectColor is "-cc
   5"; see /usr/include/X11/X.h.) The only place we have seen this is
   with the virtual framebuffer server Xvfb on Xorg 7.2. So in that case
   you probably should restart it with something like this: "Xvfb :1 -cc
   4 -screen 0 1280x1024x24". It should be possible for x11vnc to handle
   DirectColor, but this hasn't been implemented due to its rare usage.

   You may also see this problem on an X display with a TrueColor default
   visual where an application chooses a DirectColor visual for its
   window(s). It seems the application also needs to install its own
   colormap for the visual for the colors to be messed up in x11vnc. One
   can make xwud do this for example.


   Q-26: How do I figure out the window id to supply to the -id windowid
   option?

   Run the xwininfo program in a terminal. It will ask you to click on
   the desired application window. After clicking, it will print out much
   information, including the window id (e.g. 0x6000010.) Also, the
   visual and depth of the window printed out is often useful in
   debugging x11vnc color problems.

   Also, as of Dec/2004 you can use "-id pick" to have x11vnc run
   xwininfo(1) for you and after you click the window it extracts the
   windowid. Besides "pick" there is also "id:root" to allow you to go
   back to root window when doing remote-control.


   Q-27: Why don't menus or other transient windows come up when I am
   using the -id windowid option to view a single application window?

   This is related to the behavior of the XGetImage(3X11) and
   XShmGetImage() interfaces regarding backingstore, saveunders, etc. The
   way the image is retrieved depends on some aspects of how the X server
   maintains the display image data and whether other windows are
   clipping or obscuring it. See the XGetImage(3X11) man page for more
   details. If you disable BackingStore and SaveUnders in the X server
   you should be able to see these transient windows.

   If things are not working and you still want to do the single window
   polling, try the -sid windowid option ("shifted" windowid.)

   Update: as of Nov/2009 in the 0.9.9 x11vnc development tarball, there
   is an experimental Application Sharing mode that improves upon the
   -id/-sid single window sharing: -appshare (run "x11vnc -appshare
   -help" for more info.) It is still very primitive and approximate, but
   at least it displays multiple top-level windows.


   Q-28: My X display is depth 24 at 24bpp (instead of the normal depth
   24 at 32bpp.) I'm having lots of color and visual problems with x11vnc
   and/or vncviewer. What's up?

   First off, depth 24 at 24bpp (bpp=bits-per-pixel) is fairly uncommon
   and can cause problems in general. It also can be slower than depth 24
   at 32bpp. You might want to switch to 32bpp (for XFree86 see the
   "-fbbpp 32", DefaultFbBpp, FbBpp and related options.) Perhaps you
   have 24bpp because the video memory of the machine is low and the
   screen wouldn't fit in video RAM at 32bpp. For this case depth 16 at
   16bpp might be an acceptable option.

   In any event x11vnc should handle depth 24 at 24bpp (although
   performance may be slower, and you may need to use the ZRLE encoding
   instead of Tight.) There are some caveats involving the viewer
   however:

   The RealVNC Unix viewer cannot handle 24bpp from the server, it will
   say: "main: setPF: not 8, 16 or 32 bpp?" and exit. I have not checked
   the RealVNC Windows viewer.

   So you need to use the TightVNC Unix viewer. However there are some
   problems with that too. It seems libvncserver does not do 24bpp
   correctly with the Tight encoding. The colors and screen ultimately
   get messed up. So you have to use a different encoding with the
   TightVNC vncviewer, try "zlib", "hextile", or one of the other
   encodings (e.g. vncviewer -encodings "zlib hextile" ....) I have not
   checked the TightVNC or UltraVNC Windows viewers.

   It appears the older RealVNC Unix viewers (e.g. 3.3.3 and 3.3.7) can
   handle 24bpp from the server, so you may want to use those. They
   evidently request 32 bpp and libvncserver obliges.

   Update: as of Apr/2006 you can use the -24to32 option to have x11vnc
   dynamically transform the 24bpp pixel data to 32bpp. This extra
   transformation could slow things down further however.

   Now coming the opposite direction if you are running the vncviewer on
   the 24bpp display, TightVNC will fail with "Can't cope with 24
   bits-per-pixel. Sorry." and RealVNC will fail with "main: Error:
   couldn't find suitable pixmap format" so evidently you cannot use
   24bpp for the vncviewers to work on that X display.

   Note, however, that the Unix viewer in the Enhanced TightVNC Viewer
   (SSVNC) project can handle 24bpp X displays. It does this by
   requesting a 16bpp pixel format (or 8bpp if the -bgr233 option has
   been supplied) from the VNC server, and translates that to 24bpp
   locally.
   [Xterminals]

   Q-29: Can I use x11vnc to view and interact with an Xterminal (e.g.
   NCD) that is not running UNIX and so x11vnc cannot be run on it
   directly?

   You can, but it will likely be very wasteful of network bandwidth
   since you will be polling the X display over the network as opposed to
   over the local hardware. To do this, run x11vnc on a UNIX machine as
   close as possible network-wise (e.g. same switch) to the Xterminal
   machine. Use the -display option to point the display to that of the
   Xterminal (you'll of course need basic X11 permission to do that) and
   finally supply the -noshm option (this enables the polling over the
   network.)

   If the Xterminal's X display is open to the network for connections,
   you might use something like "-display xterm123:0". If you are trying
   to do this via an SSH tunnel (assuming you can actually ssh into the
   Xterminal) it will be a little tricky (either use the ssh "-R" option
   or consider ssh-ing in the other direction.) In all cases the X11
   permissions need to allow the connection.

   The response will likely be sluggish (maybe only one "frame" per
   second.) This mode is not recommended except for "quick checks" of
   hard to get to X servers. Use something like "-wait 150" to cut down
   on the polling rate. You may also need -flipbyteorder if the colors
   get messed up due to endian byte order differences.

   Q-30: How do I get my X permissions (MIT-MAGIC-COOKIE file) correct
   for a Unix/Linux machine acting as an Xterminal?

   If the X display machine is a traditional Xterminal (where the X
   server process runs on the Xterminal box, but all of the X client
   applications (firefox, etc) run on a central server (aka "terminal
   server")), you will need to log into the Xterminal machine (i.e. get a
   shell running there) and then start the x11vnc program. If the
   Xterminal Linux/Unix machine is stripped down (e.g. no users besides
   root) that may be difficult.

   The next problem is the login Display Manager (e.g. gdm, kdm), and
   hence the MIT-MAGIC-COOKIE auth files, are on the central server and
   not on the Xterminal box where the X server and x11vnc processes are.

   So unless X permissions are completely turned off (e.g. "xhost +"), to
   run the x11vnc process on the Xterminal box the MIT-MAGIC-COOKIE auth
   file data (XAUTHORITY or $HOME/.Xauthority) must be accessible by or
   copied to the Xterminal. If $HOME/.Xauthority is exported via NFS
   (this is insecure of course, but has been going on for decades), then
   x11vnc can simply pick it up via NFS (you may need to use the -auth
   option to point to the correct file.) Other options include copying
   the auth file using scp, or something like:
  central-server>  xauth nextract - xterm123:0 | ssh xterm123 xauth nmerge -

   and then, say, ssh from central-server to xterm123 to start x11vnc.
   Here "xterm123" refers to the computer acting as the Xterminal and
   "central-server" is the terminal server. You can use "xauth -f
   /path/to/cookie-file list" to examine the contents of the cookie(s) in
   a file "/path/to/cookie-file". See the xauth(1) manpage for more
   details.

   If the display name in the cookie file needs to be changed between the
   two hosts, see this note on the "xauth add ..." command.

   A less secure option is to run something like "xhost +127.0.0.1" while
   sitting at the Xterminal box to allow cookie-free local access for
   x11vnc. You can run "xhost -127.0.0.1" after x11vnc connects if you
   want to go back to the original permissions.

   If the Xterminal is really stripped down and doesn't have any user
   accounts, NFS, etc. you'll need to contact your system administrator
   to set something up. It can be done!!!  Some Xterminal projects have
   actually enabled "run locally" facilities for the running of an
   occasional app more efficiently locally on the Xterminal box (e.g.
   realplayer.)

   Not recommended, but as a last resort, you could have x11vnc poll the
   Xterminal Display over the network. For this you would run a "x11vnc
   -noshm ..." process on the central-server (and hope the network admin
   doesn't get angry...)

   Note: use of Display Manager (gdm, kdm, ...) auth cookie files (i.e.
   from /var/...,  /tmp/..., or elsewhere) may require modification via
   xauth(1) to correctly include the display x11vnc refers to (e.g.
   "xauth -f cookie-file add :0 . 45be51ae2ce9dfbacd882ab3ef8e96b1",
   where the "45be51..." cookie value was found from an "xauth -f
   /path/to/original/cookie-file list") or other reasons. See xauth(1)
   manpage for full details on how to transfer an MIT-MAGIC-COOKIE
   between machines and displays.

   VNCviewer performance on Xterminals:  This isn't related to x11vnc on
   Xterminals, but we mention it here anyway because of the similar
   issues. If you are on an Xterminal and want to use vncviewer to
   connect to a VNC server somewhere, then performance would be best if
   you ran the viewer on the Xterminal box. Otherwise, (i.e. running the
   viewer process on the central-server) all of the vncviewer screen
   drawing is done more inefficiently over the network. Something to
   consider, especially on a busy network. (BTW, this has all of the
   above permission, etc, problems: both vncviewer and x11vnc are X
   client apps desired to be run on the Xterminal box.)

   [Sun Rays]

   Q-31: I'm having trouble using x11vnc with my Sun Ray session.

   The Sun Ray technology is a bit like "VNC done in hardware" (the Sun
   Ray terminal device, DTU, playing the role of the vncviewer.)
   Completely independent of that, the SunRay user's session is still an
   X server that speaks the X11 protocol and so x11vnc simply talks to
   the X server part to export the SunRay desktop to any place in the
   world (i.e. not only to a Sun Ray terminal device), creating a sort of
   "Soft Ray". Please see this discussion of Sun Ray issues for solutions
   to problems.

   Also see the Sun Ray Remote Control Toolkit that uses x11vnc.

   [Remote Control]

   Q-32: How do I stop x11vnc once it is running in the background?

   As of Dec/2004 there is a remote control feature. It can change a huge
   number of parameters on the fly: see the -remote and -query options.
   To shut down the running x11vnc server just type "x11vnc -R stop". To
   disconnect all clients do "x11vnc -R disconnect:all", etc.

   If the -forever option has not been supplied, x11vnc will
   automatically exit after the first client disconnects. In general if
   you cannot use the remote control, then you will have to kill the
   x11vnc process This can be done via: "kill NNNNN" (where NNNNN is the
   x11vnc process id number found from ps(1)), or "pkill x11vnc", or
   "killall x11vnc" (Linux only.)

   If you have not put x11vnc in the background via the -bg option or
   shell & operator, then simply press Ctrl-C in the shell where x11vnc
   is running to stop it.

   Potential Gotcha: If somehow your Keypress of Ctrl-C went through
   x11vnc to the Xserver that then delivered it to x11vnc it is possible
   one or both of the Ctrl or C keys will be left stuck in the pressed
   down state in the Xserver. Tapping the stuck key (either via a new
   x11vnc or at the physical console) will release it from the stuck
   state. If the keyboard seems to be acting strangely it is often fixed
   by tapping Ctrl, Shift, and Alt. Alternatively, the -clear_mods option
   and -clear_keys option can be used to release pressed keys at startup
   and exit. The option -clear_all will also try to unset Caps_Lock,
   Num_Lock, etc.


   Q-33: Can I change settings in x11vnc without having to restart it?
   Can I remote control it?

   Look at the -remote (an alias is -R) and -query (an alias is -Q)
   options added in Dec/2004. They allow nearly everything to be changed
   dynamically and settings to be queried. Examples: "x11vnc -R shared",
   "x11vnc -R forever", "x11vnc -R scale:3/4", "x11vnc -Q modtweak",
   "x11vnc -R stop", "x11vnc -R disconnect:all", etc..

   These commands do not start a x11vnc server, but rather communicate
   with one that is already running. The X display (X11VNC_REMOTE
   property) is used as the communication channel, so the X permissions
   and DISPLAY must be set up correctly for communication to be possible.

   There is also a simple Tcl/Tk gui based on this remote control
   mechanism. See the -gui option for more info. You will need to have
   Tcl/Tk (i.e. /usr/bin/wish) installed for it to work. It can also run
   in the system tray: "-gui tray" or as a standalone small icon window:
   "-gui icon". Use "-gui tray=setpass" for a naive user "Share My
   Desktop" mode.

   [Security and Permissions]

   Q-34: How do I create a VNC password for use with x11vnc?

   You may already have one in $HOME/.vnc/passwd if you have used, say,
   the vncserver program from the regular RealVNC or TightVNC packages
   (i.e. launching the Xvnc server.) Otherwise, you could use the
   vncpasswd(1) program from those packages.

   As of Jun/2004 x11vnc supports the -storepasswd "pass" "file" option,
   which is the same functionality of storepasswd. Be sure to quote the
   "pass" if it contains shell meta characters, spaces, etc. Example:
  x11vnc -storepasswd 'sword*fish' $HOME/myvncpasswd

   You then use the password via the x11vnc option: "-rfbauth
   $HOME/myvncpasswd"

   As of Jan/2006 if you do not supply any arguments:
  x11vnc -storepasswd

   you will be prompted for a password to save to ~/.vnc/passwd (your
   keystrokes when entering the password will not be echoed to the
   screen.) If you supply one argument, e.g. "x11vnc -storepasswd
   ~/.mypass", the password you are prompted for will be stored in that
   file.

   x11vnc also has the -passwdfile and -passwd/-viewpasswd plain text
   (i.e. not obscured like the -rfbauth VNC passwords) password options.

   You can use the -usepw option to automatically use any password file
   you have in ~/.vnc/passwd or ~/.vnc/passwdfile (the latter is used
   with the -passwdfile option.)

  x11vnc -usepw -display :0 ...

   If neither file exists you are prompted to store a password in
   ~/.vnc/passwd. If a password file cannot be found or created x11vnc
   exits immediately. An admin may want to set it up this way for users
   who do not know better.


   Q-35: Can I make it so -storepasswd doesn't show my password on the
   screen?

   You can use the vncpasswd program from RealVNC or TightVNC mentioned
   above. As of Jan/2006 the -storepasswd option without any arguments
   will not echo your password as you type it and save the file to
   ~/.vnc/passwd:
  # x11vnc -storepasswd
  Enter VNC password:
  Verify password:
  Write password to /home/myname/.vnc/passwd?  [y]/n
  Password written to: /home/myname/.vnc/passwd

   You can also give it an alternate filename, e.g. "x11vnc -storepasswd
   ~/.mypass"


   Q-36: Can I have two passwords for VNC viewers, one for full access
   and the other for view-only access to the display?

   Yes, as of May/2004 there is the -viewpasswd option to supply the
   view-only password. Note the full-access password option -passwd must
   be supplied at the same time. E.g.: -passwd sword -viewpasswd fish.

   To avoid specifying the passwords on the command line (where they
   could be observed via the ps(1) command by any user) you can use the
   -passwdfile option to specify a file containing plain text passwords.
   Presumably this file is readable only by you, and ideally it is
   located on the machine x11vnc is run on (to avoid being snooped on
   over the network.) The first line of this file is the full-access
   password. If there is a second line in the file and it is non-blank,
   it is taken as the view-only password. (use "__EMPTY__" to supply an
   empty one.)

   View-only passwords currently do not work for the -rfbauth password
   option (standard VNC password storing mechanism.) FWIW, note that
   although the output (usually placed in $HOME/.vnc/passwd) by the
   vncpasswd or storepasswd programs (or from x11vnc -storepasswd) looks
   encrypted they are really just obscured to avoid "casual" password
   stealing. It takes almost no skill to figure out how to extract the
   plain text passwords from $HOME/.vnc/passwd since it is very
   straight-forward to work out what to do from the VNC source code.


   Q-37: Can I have as many full-access and view-only passwords as I
   like?

   Yes, as of Jan/2006 in the libvncserver CVS the -passwdfile option has
   been extended to handle as many passwords as you like. You put the
   view-only passwords after a line __BEGIN_VIEWONLY__.

   You can also easily annotate and comment out passwords in the file.
   You can have x11vnc re-read the file dynamically when it is modified.


   Q-38: Does x11vnc support Unix usernames and passwords? Can I further
   limit the set of Unix usernames who can connect to the VNC desktop?
   Update: as of Feb/2006 x11vnc has the -unixpw option that does this
   outside of the VNC protocol and libvncserver. The standard su(1)
   program is used to validate the user's password. A familiar "login:"
   and "Password:" dialog is presented to the user on a black screen
   inside the vncviewer. The connection is dropped if the user fails to
   supply the correct password in 3 tries or does not send one before a
   25 second timeout. Existing clients are view-only during this period.
   A list of allowed Unix usernames may also be supplied along with
   per-user settings.

   There is also the -unixpw_nis option for non-shadow-password
   (typically NIS environments, hence the name) systems where the
   traditional getpwnam() and crypt() functions are used instead of
   su(1). The encrypted user passwords must be accessible to the user
   running x11vnc in -unixpw_nis mode, otherwise the logins will always
   fail even when the correct password is supplied. See ypcat(1) and
   shadow(5).

   Two settings are enforced in the -unixpw and -unixpw_nis modes to
   provide extra security: the 1) -localhost and 2) -stunnel or -ssl
   options. Without these one might send the Unix username and password
   data in clear text over the network which is a very bad idea. They can
   be relaxed if you want to provide encryption other than stunnel or
   -ssl (the constraint is automatically relaxed if SSH_CONNECTION is set
   and indicates you have ssh-ed in, however the -localhost requirement
   is still enforced.)

   The two -unixpw modes have been tested on Linux, Solaris, Mac OS X,
   HP-UX, AIX, Tru64, FreeBSD, OpenBSD, and NetBSD. Additional testing is
   appreciated. For the last 4 it appears that su(1) will not prompt for
   a password if su-ing to oneself. Since x11vnc requires a password
   prompt from su, x11vnc forces those logins to fail even when the
   correct password is supplied. On *BSD it appears this can be corrected
   by removing the pam_self.so entry in /etc/pam.d/su.


   Previous older discussion (prior to the -unixpw option):

   Until the VNC protocol and libvncserver support this things will be
   approximate at best.

   One approximate method involves starting x11vnc with the -localhost
   option. This basically requires the viewer user to log into the
   workstation where x11vnc is running via their Unix username and
   password, and then somehow set up a port redirection of his vncviewer
   connection to make it appear to emanate from the local machine. As
   discussed above, ssh is useful for this: "ssh -L 5900:localhost:5900
   user@hostname ..." See the ssh wrapper scripts mentioned elsewhere on
   this page. stunnel does this as well.

   Of course a malicious user could allow other users to get in through
   his channel, but that is a problem with every method. Another thing to
   watch out for is a malicious user on the viewer side (where ssh is
   running) trying to sneak in through the ssh port redirection there.

   Regarding limiting the set of Unix usernames who can connect, the
   traditional way would be to further require a VNC password to supplied
   (-rfbauth, -passwd, etc) and only tell the people allowed in what the
   VNC password is. A scheme that avoids a second password involves using
   the -accept option that runs a program to examine the connection
   information to determine which user is connecting from the local
   machine. That may be difficult to do, but, for example, the program
   could use the ident service on the local machine (normally ident
   should not be trusted over the network, but on the local machine it
   should be accurate: otherwise root has been compromised and so there
   are more serious problems! Unfortunately recent Linux distros seem to
   provide a random string (MD5 hash?) instead of the username.) An
   example script passed in via -accept scriptname that deduces the Unix
   username and limits who can be accepted might look something like
   this:
#!/bin/sh
if [ "$RFB_CLIENT_IP" != "127.0.0.1" -o "$RFB_SERVER_IP" != "127.0.0.1" ]; then
        exit 1  # something fishy... reject it.
fi
user=`echo "$RFB_CLIENT_PORT, $RFB_SERVER_PORT" | nc -w 1 $RFB_CLIENT_IP 113 \
        | grep 'USERID.*UNIX' | head -n 1 | sed -e 's/[\r ]//g' | awk -F: '{pri
nt $4}'`

for okuser in fred barney wilma betty
do
        if [ "X$user" = "X$okuser" ]; then
                exit 0  # accept it
        fi
done
exit 1  # reject it

   For this to work with ssh port redirection, the ssh option
   UsePrivilegeSeparation must be enabled otherwise the userid will
   always be "root".

   Here is a similar example based on Linux netstat(1) output:
#!/bin/sh
#
# accept_local_netstat:  x11vnc -accept command to accept a local
# vncviewer connection from acceptable users.  Linux netstat -nte is used.

PATH=/bin:/usr/bin:$PATH; export PATH;  # set to get system utils

allowed="`id -u fred`";                 # add more user numbers if desired.

# check required settings
ok=1
if [ "X$allowed" = "X" ]; then
        ok=0;   # something wrong with allowed list
fi
if [ "X$RFB_CLIENT_IP" != "X127.0.0.1" -o "X$RFB_SERVER_IP" != "X127.0.0.1" ];
then
        ok=0;   # connection not over localhost
fi
if [ "$RFB_CLIENT_PORT" -le 0 -o "$RFB_SERVER_PORT" -le 0 ]; then
        ok=0;   # something wrong with tcp port numbers
fi
if [ "$ok" = 0 ]; then
        echo "$0: invalid setting:" 1>&2
        env | grep ^RFB | sort 1>&2
        exit 1
fi

# Linux netstat -nte:
# Proto Recv-Q Send-Q Local Address           Foreign Address         State
   User       Inode
# 0     0      0      RFB_CLIENT              RFB_SERVER           ESTABLISHED
   nnnn       ....
#
user=`netstat -nte | grep ESTABLISHED \
        | grep " $RFB_CLIENT_IP:$RFB_CLIENT_PORT  *$RFB_SERVER_IP:$RFB_SERVER_P
ORT "`

echo "netstat match: $user" 1>&2
user=`echo "$user" | head -n 1 | sed -e 's/^.*ESTABLISHED/ /' | awk '{print $1}
'`

ok=0
for u in $allowed
do
        if [ "X$user" = "X$u" ]; then
                ok=1
                break
        fi
done

if [ "X$ok" = "X1" ]; then
        echo "$0: user accepted: '$user'" 1>&2
        exit 0
else
        echo "$0: user '$user' invalid:" 1>&2
        echo "$0: allowed: $allowed" 1>&2
        env | grep ^RFB | sort 1>&2
        exit 1
fi


   Q-39: Can I supply an external program to provide my own custom login
   method (e.g. Dynamic/One-time passwords or non-Unix (LDAP) usernames
   and passwords)?
   Yes, there are several possibilities. For background see the FAQ on
   the -accept where an external program may be run to decide if a VNC
   client should be allowed to try to connect and log in. If the program
   (or local user prompted by a popup) answers "yes", then -accept
   proceeds to the normal VNC and x11vnc authentication methods,
   otherwise the connection is dropped.

   To provide more direct coupling to the VNC client's username and/or
   supplied password the following options were added in Sep/2006:
     * -unixpw_cmd command
     * -passwdfile cmd:command
     * -passwdfile custom:command

   In each case "command" is an external command run by x11vnc. You
   supply it. For example, it may couple to your LDAP system or other
   servers you set up.

   For -unixpw_cmd the normal -unixpw Login: and Password: prompts are
   supplied to the VNC viewer and the strings the client returns are then
   piped into "command" as the first two lines of its standard input. If
   the command returns success, i.e. exit(0), the VNC client is accepted,
   otherwise it is rejected.

   For "-passwdfile cmd:command" the command is run and it returns a
   password list (like a password file, see the -passwdfile read:filename
   mode.) Perhaps a dynamic, one-time password is retrieved from a server
   this way.

   For "-passwdfile custom:command" one gets complete control over the
   VNC challenge-response dialog with the VNC client. x11vnc sends out a
   string of random bytes (16 by the VNC spec) and the client returns the
   same number of bytes in a way the server can verify only the
   authorized user could have created. The VNC protocol specifies DES
   encryption with a password. If you are willing to modify the VNC
   viewers, you can have it be anything you want, perhaps a less
   crackable MD5 hash scheme or one-time pad. Your program will read from
   its standard input the size of the challenge-response followed by a
   newline, then the challenge bytes followed by the response bytes. If
   your command then returns success, i.e. exit(0), the VNC client is
   accepted, otherwise it is rejected.

   In all cases the "RFB_*" environment variables are set as under
   -accept. These variables can provide useful information for the
   externally supplied program to use.


   Q-40: Why does x11vnc exit as soon as the VNC viewer disconnects? And
   why doesn't it allow more than one VNC viewer to connect at the same
   time?

   These defaults are simple safety measures to avoid someone unknowingly
   leaving his X11 desktop exposed (to the internet, say) for long
   periods of time. Use the -forever option (aka -many) to have x11vnc
   wait for more connections after the first client disconnects. Use the
   -shared option to have x11vnc allow multiple clients to connect
   simultaneously.

   Recommended additional safety measures include using ssh (see above),
   stunnel, -ssl, or a VPN to authenticate and encrypt the viewer
   connections or to at least use the -rfbauth passwd-file option to use
   VNC password protection (or -passwdfile) It is up to YOU to apply
   these security measures, they will not be done for you automatically.


   Q-41: Can I limit which machines incoming VNC clients can connect
   from?

   Yes, look at the -allow and -localhost options to limit connections by
   hostname or IP address. E.g.
  x11vnc -allow 192.168.0.1,192.168.0.2

   for those two hosts or
  x11vnc -allow 192.168.0.

   for a subnet. For individual hosts you can use the hostname instead of
   the IP number, e.g.: "-allow snoopy", and "-allow darkstar,wombat".
   Note that -localhost achieves the same thing as "-allow 127.0.0.1"

   For more control, build libvncserver with libwrap support
   (tcp_wrappers) and then use /etc/hosts.allow See hosts_access(5) for
   complete details.


   Q-42: How do I build x11vnc/libvncserver with libwrap (tcp_wrappers)
   support?

   Here is one way to pass this information to the configure script:
  env CPPFLAGS=-DUSE_LIBWRAP LDFLAGS=-lwrap ./configure

   then run make as usual. This requires libwrap and its development
   package (tcpd.h) to be installed on the build machine. If additional
   CPPFLAGS or LDFLAGS options are needed supply them as well using
   quotes.

   The resulting x11vnc then uses libwrap/tcp_wrappers for connections.
   The service name you will use in /etc/hosts.allow and /etc/hosts.deny
   is "vnc", e.g.:
  vnc: 192.168.100.3 .example.com

   Note that if you run x11vnc out of inetd you do not need to build
   x11vnc with libwrap support because the /usr/sbin/tcpd reference in
   /etc/inetd.conf handles the tcp_wrappers stuff.


   Q-43: Can I have x11vnc only listen on one network interface (e.g.
   internal LAN) rather than having it listen on all network interfaces
   and relying on -allow to filter unwanted connections out?

   As of Mar/2005 there is the "-listen ipaddr" option that enables this.
   For ipaddr either supply the desired network interface's IP address
   (or use a hostname that resolves to it) or use the string "localhost".
   For additional filtering simultaneously use the "-allow host1,..."
   option to allow only specific hosts in.

   This option is useful if you want to insure that no one can even begin
   a dialog with x11vnc from untrusted network interfaces (e.g. ppp0.)
   The option -localhost now implies "-listen localhost" since that is
   what most people expect it to do.


   Q-44: Now that -localhost implies listening only on the loopback
   interface, how I can occasionally allow in a non-localhost via the -R
   allowonce remote control command?

   To do this specify "-allow localhost". Unlike -localhost this will
   leave x11vnc listening on all interfaces (but of course only allowing
   in local connections, e.g. ssh redirs.) Then you can later run "x11vnc
   -R allowonce:somehost" or use to gui to permit a one-shot connection
   from a remote host.


   Q-45: Can I fine tune what types of user input are allowed? E.g. have
   some users just be able to move the mouse, but not click or type
   anything?

   As of Feb/2005, the -input option allows you to do this. "K", "M",
   "B", "C", and "F" stand for Keystroke, Mouse-motion, Button-clicks,
   Clipboard, and File-Transfer, respectively. The setting: "-input M"
   makes attached viewers only able to move the mouse. "-input KMBC,M"
   lets normal clients do everything and enables view-only clients to
   move the mouse.

   These settings can also be applied on a per-viewer basis via the
   remote control mechanism or the GUI. E.g. x11vnc -R input:hostname:M


   Q-46: Can I prompt the user at the local X display whether the
   incoming VNC client should be accepted or not? Can I decide to make
   some clients view-only? How about running an arbitrary program to make
   the decisions?

   Yes, look at the "-accept command" option, it allows you to specify an
   external command that is run for each new client. (use quotes around
   the command if it contains spaces, etc.) If the external command
   returns 0 (success) the client is accepted, otherwise with any other
   return code the client is rejected. See below how to also accept
   clients view-only.

   The external command will have the RFB_CLIENT_IP environment variable
   set to the client's numerical IP address, RFB_CLIENT_PORT its port
   number. Similarly for RFB_SERVER_IP and RFB_SERVER_PORT to allow
   identification of the tcp virtual circuit. DISPLAY will be set to that
   of the X11 display being polled. Also, RFB_X11VNC_PID is set to the
   x11vnc process id (e.g. in case you decided to kill it), RFB_CLIENT_ID
   will be an id number, and RFB_CLIENT_COUNT the number of other clients
   currently connected. RFB_MODE will be "accept".

   Built-in Popup Window: As a special case, "-accept popup" will
   instruct x11vnc to create its own simple popup window. To accept the
   client press "y" or click mouse on the "Yes" button. To reject the
   client press "n" or click mouse on the "No" button. To accept the
   client View-only, press "v" or click mouse on the "View" button. If
   the -viewonly option has been supplied, the "View" action will not be
   present: the whole display is view only in that case.

   The popup window times out after 120 seconds, to change this behavior
   use "-accept popup:N" where N is the number of seconds (use 0 for no
   timeout.) More tricks: "-accept popupmouse" will only take mouse click
   responses, while "-accept popupkey" will only take keystroke responses
   (popup takes both.) After any of the 3 popup keywords you can supply a
   position of the window: +N+M, (the default is to center the window)
   e.g. -accept popupmouse+10+10.

   Also as a special case "-accept xmessage" will run the xmessage(1)
   program to prompt the user whether the client should be accepted or
   not. This requires that you have xmessage installed and available via
   PATH. In case it is not already on your system, the xmessage program
   is available at ftp://ftp.x.org/
   (End of Built-in Popup Window:)

   To include view-only decisions for the external commands, prefix the
   command something like this: "yes:0,no:*,view:3 mycommand ..." This
   associates the three actions: yes(accept), no(reject), and
   view(accept-view-only), with the numerical return (i.e. exit()) codes.
   Use "*" instead of a number to set the default action (e.g. in case
   the external command returns an unexpected return code.)

   Here is an example -accept script called accept_or_lock. It uses
   xmessage and xlock (replace with your screen lock command, maybe it is
   "xscreensaver-command -lock", or kdesktop_lock, or "dtaction
   LockDisplay".) It will prompt the user at the X display whether to
   accept, reject, or accept view-only the client, but if the prompt
   times out after 60 seconds the screen is locked and the VNC client is
   accepted. This allows the remote access when no one is at the display.
#!/bin/sh
#
# accept_or_lock: prompt user at X display whether to accept an incoming
#                 VNC connection.  If timeout expires, screen is locked
#                 and the VNC viewer is accepted (allows remote access
#                 when no one is sitting at the display.)
#
# usage: x11vnc ... -forever -accept 'yes:0,no:*,view:4 accept_or_lock'
#
xmessage -buttons yes:2,no:3,view-only:4 -center \
         -timeout 60 "x11vnc: accept connection from $RFB_CLIENT_IP?"
rc=$?
if [ $rc = 0 ]; then
        xlock & # or "xlock -mode blank" for no animations.
        sleep 5
        exit 0
elif [ $rc = 2 ]; then
        exit 0
elif [ $rc = 4 ]; then
        exit 4
fi
exit 1

   Stefan Radman has written a nice dtksh script dtVncPopup for use in
   CDE environments to do the same sort of thing. Information on how to
   use it is found at the top of the file. He encourages you to provide
   feedback to him to help improve the script.

   Note that in all cases x11vnc will block while the external command or
   popup is being run, so attached clients will not receive screen
   updates, etc during this period.

   To run a command when a client disconnects, use the "-gone command"
   option. This is for the user's convenience only: the return code of
   the command is not interpreted by x11vnc. The same environment
   variables are set as in "-accept command" (except that RFB_MODE will
   be "gone".)

   As of Jan/2006 the "-afteraccept command" option will run the command
   only after the VNC client has been accepted and authenticated. Like
   -gone the return code is not interpreted. RFB_MODE will be
   "afteraccept".)


   Q-47: I start x11vnc as root because it is launched via inetd(8) or a
   display manager like gdm(1). Can I have x11vnc later switch to a
   different user?

   As of Feb/2005 x11vnc has the -users option that allows things like
   this. Please read the documentation on it (also in the x11vnc -help
   output) carefully for features and caveats. It's use can often
   decrease security unless care is taken.

   BTW, a nice use of it is "-users +nobody" that switches to the Unix
   user nobody right after connections to the X display are established.

   In any event, while running x11vnc as root, remember it comes with no
   warranty ;-).


   Q-48: I use a screen-lock when I leave my workstation (e.g.
   xscreensaver or xlock.) When I remotely access my workstation desktop
   via x11vnc I can unlock the desktop fine, but I am worried people will
   see my activities on the physical monitor. What can I do to prevent
   this, or at least make it more difficult?

   Probably most work environments would respect your privacy if you
   powered off the monitor. Also remember if people have physical access
   to your workstation they basically can do anything they want with it
   (e.g. install a backdoor for later use, etc.)

   In any event, as of Jun/2004 there is an experimental utility to make
   it more difficult for nosey people to see your x11vnc activities. The
   source for it is blockdpy.c The idea behind it is simple (but
   obviously not bulletproof): when a VNC client attaches to x11vnc put
   the display monitor in the DPMS "off" state, if the DPMS state ever
   changes immediately start up the screen-lock program. The x11vnc user
   will notice something is happening and think about what to do next
   (while the screen is in a locked state.)

   This works (or at least has a chance of working) because if the
   intruder moves the mouse or presses a key on the keyboard, the monitor
   wakes up out of the DPMS off state, and this induces the screen lock
   program to activate as soon as possible. Of course there are cracks in
   this, the eavesdropper could detach your monitor and insert a non-DPMS
   one, and there are race conditions. As mentioned above this is not
   bulletproof. A really robust solution would likely require X server
   and perhaps even video hardware support.

   The blockdpy utility is launched by the -accept option and told to
   exit via the -gone option (the vnc client user should obviously
   re-lock the screen before disconnecting!) Instructions can be found in
   the source code for the utility at the above link. Roughly it is
   something like this:
  x11vnc ... -accept "blockdpy -bg -f $HOME/.bdpy" -gone "touch $HOME/.bdpy"

   but please read the top of the file.

   Update: As of Feb/2007 there is some builtin support for this:
   -forcedpms and -clientdpms however, they are probably less robust than
   the above blockdpy.c scheme, since if the person floods the physical
   machine with mouse or pointer input he can usually see flashes of the
   screen before the monitor is powered off again. See also the -grabkbd,
   -grabptr, and -grabalways options.


   Q-49: Can I have x11vnc automatically lock the screen when I
   disconnect the VNC viewer?

   Yes, a user mentions he uses the -gone option under CDE to run a
   screen lock program:
  x11vnc -display :0 -forever -gone 'dtaction LockDisplay'

   Other possibilities are:
  x11vnc -display :0 -forever -gone 'xscreensaver-command -lock'
  x11vnc -display :0 -forever -gone 'kdesktop_lock'
  x11vnc -display :0 -forever -gone 'xlock &'
  x11vnc -display :0 -forever -gone 'xlock -mode blank &'

   Here is a scheme using the -afteraccept option (in version 0.8) to
   unlock the screen after the first valid VNC login and to lock the
   screen after the last valid VNC login disconnects:
  x11vnc -display :0 -forever -shared -afteraccept ./myxlocker -gone ./myxlocke
r

   Where the script ./myxlocker is:
#!/bin/sh

#/usr/bin/env | grep RFB_ | sort        # for viewing RFB_* settings.

if [ "X$RFB_MODE" = "Xafteraccept" ]; then
        if [ "X$RFB_STATE" = "XNORMAL" ]; then  # require valid login
                if [ "X$RFB_CLIENT_COUNT" = "X1" ]; then
                        killall xlock   # Linux only.
                fi
        fi
elif [ "X$RFB_MODE" = "Xgone" ]; then
        if [ "X$RFB_STATE" = "XNORMAL" ]; then  # require valid login
                if [ "X$RFB_CLIENT_COUNT" = "X0" ]; then
                        xlock -mode blank &
                fi
        fi
fi

   Note the xlock option "-mode blank" to avoid animations.

   There is a problem if you have x11vnc running this way in -forever
   mode and you hit Ctrl-C to stop it. The xlock (or other program) will
   get killed too. To work around this make a little script called
   setpgrp that looks like:
#!/usr/bin/perl
setpgrp(0, 0);
exec @ARGV;

   then use -gone "setpgrp xlock &", etc.
   [Encrypted Connections]

   Q-50: How can I tunnel my connection to x11vnc via an encrypted SSH
   channel between two Unix machines?

   See the description earlier on this page on how to tunnel VNC via SSH
   from Unix to Unix. A number of ways are described along with some
   issues you may encounter.

   Other secure encrypted methods exists, e.g. stunnel, IPSEC, various
   VPNs, etc.

   See also the Enhanced TightVNC Viewer (SSVNC) page where much of this
   is now automated.


   Q-51: How can I tunnel my connection to x11vnc via an encrypted SSH
   channel from Windows using an SSH client like Putty?

   Above we described how to tunnel VNC via SSH from Unix to Unix, you
   may want to review it. To do this from Windows using Putty it would go
   something like this:
     * In the Putty dialog window under 'Session' enter the hostname or
       IP number of the Unix machine with display to be viewed.
     * Make sure the SSH protocol is selected and the server port is
       correct.
     * Under 'Connections/SSH/Tunnels' Add a Local connection with
       'Source port:  5900' and 'Destination:  localhost:5900'
     * Log into the remote machine by pressing 'Open' and supplying
       username, password, etc.
     * In that SSH shell, start up x11vnc by typing the command: x11vnc
       -display :0 plus any other desired options (e.g. -localhost.)
     * Finally, start up your VNC Viewer in Windows and enter
       'localhost:0' as the VNC server.

   You can keep all of the settings in a Putty 'Saved Session'. Also,
   once everything is working, you can consider putting x11vnc -display
   :0 (plus other cmdline options) in the 'Remote command' Putty setting
   under 'Connections/SSH'.

   See also the Enhanced TightVNC Viewer (SSVNC) page where much of this
   is now automated via the Putty plink utility.

   For extra protection feel free to run x11vnc with the -localhost and
   -rfbauth/-passwdfile options.

   If the machine you SSH into via Putty is not the same machine with the
   X display you wish to view (e.g. your company provides incoming SSH
   access to a gateway machine), then you need to change the above Putty
   dialog setting to: 'Destination: otherhost:5900', Once logged in,
   you'll need to do a second login (ssh or rsh) to the workstation
   machine 'otherhost' and then start up x11vnc on it. This can also be
   automated by Chaining SSH's.

   As discussed above another option is to first start the VNC viewer in
   "listen" mode, and then launch x11vnc with the "-connect localhost"
   option to establish the reverse connection. In this case a Remote port
   redirection (not Local) is needed for port 5500 instead of 5900 (i.e.
   'Source port:  5500' and 'Destination:  localhost:5500' for a Remote
   connection.)


   Q-52: How can I tunnel my connection to x11vnc via an encrypted SSL
   channel using an external tool like stunnel?

   It is possible to use a "lighter weight" encryption setup than SSH or
   IPSEC. SSL tunnels such as stunnel (also stunnel.org) provide an
   encrypted channel without the need for Unix users, passwords, and key
   passphrases required for ssh (and at the other extreme SSL can also
   provide a complete signed certificate chain of trust.) On the other
   hand, since SSH is usually installed everywhere and firewalls often
   let its port through, ssh is frequently the path of least resistance
   (it also nicely manages public keys for you.)

   Update: As of Feb/2006 x11vnc has the options -ssl, -stunnel, and
   -sslverify to provide integrated SSL schemes. They are discussed in
   the Next FAQ (you probably want to skip to it now.)

   We include these non-built-in method descriptions below for historical
   reference. They are handy because can be used to create SSL tunnels to
   any VNC (or other type of) server.


   Here are some basic examples using stunnel but the general idea for
   any SSL tunnel utility is the same:
     * Start up x11vnc and constrain it to listen on localhost.
     * Then start up the SSL tunnel running on the same machine to
       forward incoming connections to that x11vnc.
     * Set up and run a similar SSL tunnel for the outgoing connection on
       the VNC viewer machine pointing it to the SSL/x11vnc server.
     * Optionally, set up server (or even client) public/private keys for
       use in authenticating one side to the other.
     * Finally, start the VNC Viewer and tell it to connect to the local
       port (e.g. a vnc display localhost:0) where its outgoing SSL
       tunnel is listening.

   We'll first use the stunnel version 3 syntax since it is the most
   concise and Unixy.

   Start up x11vnc listening on port 5900:
  x11vnc -display :0 -rfbport 5900 -localhost -bg -passwdfile ~/mypass

   Then start stunnel (version 3, not 4) with this command:
  stunnel -d 5901 -r 5900 -p /path/to/stunnel.pem

   The above two commands are run on host "far-away.east". The
   stunnel.pem is the self-signed PEM file certificate created when
   stunnel is built. One can also create certificates signed by
   Certificate Authorities or self-signed if desired using the x11vnc
   utilities described there.

   SSL Viewers:  Next, on the VNC viewer side we need an SSL tunnel to
   encrypt the outgoing connection. The nice thing is any SSL tunnel can
   be used because the protocol is a standard. For this example we'll
   also use stunnel on the viewer side on Unix. First start up the
   client-side stunnel (version 3, not 4):
  stunnel -c -d localhost:5902 -r far-away.east:5901

   Then point the viewer to the local tunnel on port 5902:
  vncviewer -encodings "copyrect tight zrle hextile" localhost:2

   That's it.  Note that the ss_vncviewer script can automate this
   easily, and so can the Enhanced TightVNC Viewer (SSVNC) package.

   Be sure to use a VNC password because unlike ssh by default the
   encrypted SSL channel provides no authentication (only privacy.) With
   some extra configuration one could also set up certificates to provide
   authentication of either or both sides as well (and hence avoid
   man-in-the-middle attacks.) See the stunnel and openssl documentation
   and also the key management section for details.

   stunnel has also been ported to Windows, and there are likely others
   to choose from for that OS. Much info for using it on Windows can be
   found at the stunnel site and in this article The article also shows
   the detailed steps to set up all the authentication certificates. (for
   both server and clients, see also the x11vnc utilities that do this.)
   The default Windows client setup (no certs) is simpler and only 4
   files are needed in a folder: stunnel.exe, stunnel.conf, libssl32.dll,
   libeay32.dll. We used an stunnel.conf containing:
# stunnel.conf:
client = yes
options = ALL
[myvncssl]
accept = localhost:5902
connect = far-away.east:5901

   then double click on the stunnel.exe icon to launch it (followed by
   pointing the VNC viewer to localhost:2).


   stunnel inetd-like mode:

   As an aside, if you don't like the little "gap" of unencrypted TCP
   traffic (and a localhost listening socket) on the local machine
   between stunnel and x11vnc it can actually be closed by having stunnel
   start up x11vnc in -inetd mode:
  stunnel -p /path/to/stunnel.pem -P none -d 5900 -l ./x11vnc_sh

   Where the script x11vnc_sh starts up x11vnc:
#!/bin/sh
x11vnc -q -inetd -display :0 -passwdfile ~/mypass

   Note that this creates a separate x11vnc process for each incoming
   connection (as any inetd x11vnc usage would), but for the case of
   normally just one viewer at a time it should not be a big problem.


   stunnel 4 syntax:

   Somewhat sadly, the stunnel version 4 syntax is not so amenable to the
   command line or scripts. You need to create a config file with the
   parameters. E.g.:
  stunnel x11vnc.cfg

   Where the file x11vnc.cfg contains:
foreground = yes
pid =
cert = /path/to/stunnel.pem
[x11vnc_stunnel]
accept  = 5901
connect = 5900

   One nice thing about version 4 is often the PEM file does not need to
   be specified because stunnel finds it in its installed area. One other
   gotcha the PEM file is usually only readable by root (it has the
   private key afterall), so you'll need to relax the permissions or make
   a copy that the user running x11vnc/stunnel can read.


   SSL VNC Viewers:

   Regarding VNC viewers that "natively" do SSL unfortunately there do
   not seem to be many. The SingleClick UltraVNC Java Viewer is SSL and
   is compatible with x11vnc's -ssl option and stunnel.) Commercial
   versions of VNC seem to have some SSL-like encryption built in, but we
   haven't tried those either and they probably wouldn't work since their
   (proprietary) SSL-like negotiation is likely embedded in the VNC
   protocol unlike our case where it is external.

   Note: as of Mar/2006 libvncserver/x11vnc provides a SSL-enabled Java
   applet that can be served up via the -httpdir or -http options when
   -ssl is enabled. It will also be served via HTTPS via either the VNC
   port (e.g. https://host:5900/) or a 2nd port via the -https option.

   In general current SSL VNC solutions are not particularly "seemless".
   But it can be done, and with a wrapper script on the viewer side and
   the -stunnel or -ssl option on the server side it works well and is
   convenient. Here is a simple script ss_vncviewer that automates
   running stunnel on the VNC viewer side on Unix a little more carefully
   than the commands printed above. (One could probably do a similar
   thing with a .BAT file on Windows in the stunnel folder.)

   Update Jul/2006: we now provide an Enhanced TightVNC Viewer (SSVNC)
   package that starts up STUNNEL automatically along with some other
   features. All binaries (stunnel, vncviewer, and some utilities) are
   provided in the package. It works on Unix, Mac OS X, and Windows.


   Q-53: Does x11vnc have built-in SSL tunneling?

   You can read about non-built-in methods in the Previous FAQ for
   background.

   SSL tunnels provide an encrypted channel without the need for Unix
   users, passwords, and key passphrases required for ssh (and at the
   other extreme SSL can also provide a complete signed certificate chain
   of trust.) On the other hand, since SSH is usually installed
   everywhere and firewalls often let its port through, ssh is frequently
   the path of least resistance.

   Built-in SSL x11vnc options:

   As of Feb/2006 the x11vnc -ssl option automates the SSL tunnel
   creation on the x11vnc server side. An SSL-enabled Java Viewer applet
   is also provided that can be served via HTTP or HTTPS to automate SSL
   on the client side.

   The -ssl mode uses the www.openssl.org library if available at build
   time.

   The mode requires an SSL certificate and key (i.e. .pem file.) These
   are usually created via the openssl(1) program (in fact in for "-ssl"
   (same as "-ssl SAVE") it will run openssl for you automatically.) So
   the SSL is not completely "built-in" since this external tool needs to
   be installed, but at least x11vnc runs it for you automatically.

   An -ssl example:
  x11vnc -display :0 -ssl -passwdfile ~/mypass

   You'll get output like this:
  09/04/2006 19:27:35 Creating a self-signed PEM certificate...
  09/04/2006 19:27:35
  ...

  The SSL VNC desktop is:  far-away.east:0
  PORT=5900
  SSLPORT=5900

   In this case openssl(1) was used to create a PEM automatically. It
   will prompt you if you want to protect it with with a passphrase. Use
   "-ssl SAVE_NOPROMPT" to not be prompted. Use "-ssl TMP" to create a
   temporary self-signed cert that will be discarded when x11vnc exits.

   Update: As of Nov/2008 x11vnc also supports the VeNCrypt SSL/TLS
   tunnel extension to the VNC protocol. The older ANONTLS method (vino)
   is also supported. This support is on by default when the -ssl option
   is in use and can be fine-tuned using these options: -vencrypt,
   -anontls, and -sslonly.

   The normal x11vnc -ssl operation is somewhat like a URL method
   vncs://hostname if vnc://hostname indicates a standard unencrypted VNC
   connection. Just as https://hostname is an SSL encrypted version of
   http://hostname. The entire VNC session goes through the SSL tunnel.
   VeNCrypt, on the other hand, switches to SSL/TLS early in the VNC
   protocol handshake. x11vnc 0.9.6 supports both simultaneously when
   -ssl is active.

   Note: With the advent of OpenSSL 1.1.0, SSLv2 is dropped and SSLv3
   deactivated per default. A couple broken ciphers have also gone, most
   importantly though is that clients trying to connect to x11vnc will
   now have to support TLS if encryption is to be used. You can of
   course always cook up your own build and run time OpenSSL 1.1.x if
   SSLv3 is absolutely required, but it isn't wise from a security point
   of view.


   SSL VNC Viewers:. Viewer-side will need to use SSL as well. See the
   next FAQ and here for SSL enabled VNC Viewers, including SSVNC, to
   connect to the above x11vnc via SSL.


   As seen above, the PEM (privacy enhanced mail) file does not need to
   be supplied if the openssl(1) command is available in PATH, in that
   case a self-signed, certificate good the current and subsequent x11vnc
   sessions is created (this may take a while on very slow machines.)

   In general, the PEM file contains both the Certificate (i.e. public
   key) and the Private Key. Because of the latter, the file should be
   protected from being read by untrusted users. The best way to do this
   is to encrypt the key with a passphrase (note however this requires
   supplying the passphrase each time x11vnc is started up.)

   See the discussion on x11vnc Key Management for some utilities
   provided for creating and managing certificates and keys and even for
   creating your own Certificate Authority (CA) for signing VNC server
   and client certificates. This may be done by importing the certificate
   into Web Browser or Java plugin keystores, or pointing stunnel to it.
   The wrapper script ss_vncviewer provides an example on unix (see the
   -verify option.)

   Here are some notes on the simpler default (non-CA) operation. To have
   x11vnc save the generated certificate and key, use the "SAVE" keyword
   like this:
  x11vnc -ssl SAVE -display :0 ...

   (this is the same as the default: "-ssl".) This way it will be saved
   in the default directory ~/.vnc/certs/ as server.crt (the certificate
   only) and server.pem (both certificate and private key.) This opens up
   the possibility of copying the server.crt to machines where the VNC
   Viewer will be run to enable authenticating the x11vnc SSL VNC server
   to the clients. When authentication takes place this way (or via the
   more sophisticated CA signing described here), then
   Man-In-The-Middle-Attacks are prevented. Otherwise, the SSL encryption
   only provides protection against passive network traffic "sniffing"
   (i.e. you are not protected against M-I-T-M attacks.) Nowadays, most
   people seem mostly concerned mainly about passive sniffing (and the
   default x11vnc SSL mode protects against it.) Note that there are
   hacker tools like dsniff/webmitm and cain that implement SSL
   Man-In-The-Middle attacks. They rely on the client not bothering to
   check the cert.


   One can test to some degree that SSL is working after starting x11vnc
   with the -stunnel or -ssl option. From another machine one can use the
   openssl command something like this:
 openssl s_client -debug -msg -showcerts -connect far-away.east:5900

   After all of the debugging output and informational messages you'll
   see the string "RFB 003.008" that came from x11vnc. Pointing a web
   browser connecting to: https://far-away.east:5900/ and then viewing
   the SSL certificate information about the connection in the panels
   will also work.

   Note: If you serve up the SSL enabled Java VNC Viewer via something
   like:
 x11vnc -ssl -httpdir /usr/local/share/x11vnc/classes/ssl

   (or just the -http option), you can test it out completely using that,
   including using https to download it into the browser and connect to
   x11vnc.


   The older -stunnel option: Before the -ssl option there was a
   convenience option -stunnel that would start an external SSL tunnel
   for you using stunnel. The -ssl method is the preferred way, but for
   historical reference we keep the -stunnel info here.

   The -stunnel mode requires the stunnel.mirt.net command stunnel(8) to
   be installed on the system.

   Some -stunnel examples:
  x11vnc -display :0 -stunnel /path/to/stunnel.pem -passwdfile ~/mypass

  x11vnc -display :0 -stunnel SAVE ...

   You'll get output like this:
  The VNC desktop is:      localhost:50
  The SSL VNC desktop is:  far-away.east:0
  PORT=5950
  SSLPORT=5900

   That indicates stunnel is listening on port 5900 for incoming
   SSL-wrapped VNC connections from viewers. x11vnc is listening for
   local connections on port 5950 in this case (remote viewers cannot
   connect to it directly.) For -stunnel to work the stunnel command must
   be installed on the machine and available in PATH (note stunnel is
   often installed in sbin directories rather than bin.) Note that the
   default "-stunnel" by itself creates a temporary cert (as in "-ssl
   TMP".)


   Q-54: How do I use VNC Viewers with built-in SSL tunneling?

   Notes on using "native" VNC Viewers with SSL:

   There aren't any native VNC Viewers that do SSL (ask your VNC viewer
   developer to add the feature.) So a tunnel must be setup that you
   point the VNC Viewer to. This is often STUNNEL. You can do this
   manually, or use the ss_vncviewer script on Unix, or our Enhanced
   TightVNC Viewer (SSVNC) package on Unix, Windows, or MacOSX. See the
   next section for Java Web browser SSL VNC Viewers (you only need a
   Java-enabled Web browser for it to work.)

   Notes on the SSL enabled Java VNC Viewer provided in x11vnc
   classes/ssl/VncViewer.jar:

   A Java applet VNC Viewer allows you to connect to a VNC Server from a
   Java-enabled Web browser.

   The SSL enabled Java VNC Viewer (VncViewer.jar) in the x11vnc package
   supports only SSL based connections by default. As mentioned above the
   -httpdir can be used to specify the path to .../classes/ssl. A typical
   location might be /usr/local/share/x11vnc/classes/ssl. Or -http can be
   used to try to have it find the directory automatically.

   Also note that the SingleClick UltraVNC Java Viewer is compatible with
   x11vnc's -ssl SSL mode. (We tested it this way: "java -cp
   ./VncViewer.jar VncViewer HOST far-away.east PORT 5900 USESSL 1
   TRUSTALL 1")

   The Java viewer uses SSL to communicate securely with x11vnc. Note
   that the applet can optionally also be downloaded into your web
   browser via HTTPS (which is HTTP over SSL.) This way the HTML page and
   the Java applet itself are also delivered securely with SSL (as
   opposed to only the VNC traffic being encrypted with SSL.)

   For this case the output will be something like this:
  x11vnc -ssl SAVE -http
  ...
  The SSL VNC desktop is:  far-away.east:0
  Java SSL viewer URL:     https://far-away.east:5900/
  Java SSL viewer URL:     http://far-away.east:5800/
  PORT=5900
  SSLPORT=5900

   Indicating the two URLs (the first one encrypted, the second not) one
   could point the web browser at to get the VNC viewer applet. E.g. put
   this
   http://far-away.east:5800/

   or:
   https://far-away.east:5900/

   into your Java-enabled Web browser.

   Note that KDE's Konqueror web browser seems to have problems with
   https Java applets, so you'll have to use the http/5800 with it (if
   you get https/5900 working let us know how you did it.)

   If you are using a router/firewall with port-redirection, and you are
   redirecting ports other than the default ones (5800, 5900) listed
   above see here.

   The https service provided thru the actual VNC port (5900 in the above
   example) can occasionally be slow or unreliable (it has to read some
   input and try to guess if the connection is VNC or HTTP.) If it is
   unreliable for you and you still want to serve the Java applet via
   https, use the -https option to get an additional port dedicated to
   https (its URL will also be printed in the output.)

   Another possibility is to add the GET applet parameter:
  https://far-away.east:5900/?GET=1

   This will have the VNC Viewer send a special HTTP GET string "GET
   /request.https.vnc.connection HTTP/1.0" that x11vnc will notice more
   quickly as a request for a VNC connection. Otherwise it must wait for
   a timeout to expire before it assumes a VNC connection.

   You may also use "urlPrefix=somestring" to have /somestring prepended
   to /request.https.vnc.connection". Perhaps you are using a web server
   proxy scheme to enter a firewall or otherwise have rules applied to
   the URL. If you need to have any slashes "/" in "somestring" use
   "_2F_" (a deficiency in libvncserver prevents using the more natural
   "%2F".)

   You apply multiple applet parameters in the regular URL way, e.g.:
  https://far-away.east:5900/?GET=1&urlPrefix=mysubdir&...

   All of the x11vnc Java Viewer applet parameters are described in the
   file classes/ssl/README


   Tips on Getting the SSL Java Applet Working the First Time:
   Unfortunately, it can be a little tricky getting the SSL VNC Java
   Viewer working with x11vnc. Here are some tips to getting working the
   first time (afterwards you can incrementally customize with more
   complex settings.)
     * First try it on the LAN: Do NOT try to have it work the first time
       going through firewalls, Web proxies, home router port
       redirections, or Apache portal. Just try a direct connection over
       your LAN first (if you only have 1 machine and no LAN, just do a
       direct connection to the same machine: localhost.) If the LAN
       machine you run x11vnc on has its own host-level firewall (most
       linux machine come with that on by default), disable it or at
       least let tcp ports 5800-6000 through.
     * First try HTTP to download the Java Applet: x11vnc can serve both
       the Java Applet jar file and VNC out of the same port (both
       tunneled through SSL, see below.) But it can lead to timing and
       other problems. So first try HTTP instead of HTTPS to download the
       Applet jar file (VncViewer.jar.) That is to say try
       http://hostname:5800 in your web browser first before trying
       https://hostname:5900. x11vnc will print out the ports and URLs it
       is using, so use the HTTP one it prints out.
     * Always Restart the Browser: If you are having failures and have to
       repeatedly retry things ALWAYS restart the browser (i.e.
       completely exit it and then start a new browser process) each
       time. Otherwise as you are changing things the browser may
       "remember" failed applet downloads, etc. and just add to the
       confusion and irreproducibility. If you see it trying to download
       VncViewer.class (instead of VncViewer.jar) you know it is really
       confused and needs to be restarted.
     * Step Lively: If you get Browser or Java VM or VNC Viewer applet
       dialog boxes saying things like "Do you want to trust this
       certificate?" or "The hostname does not match the one on the
       certificate", etc. just go through them as quickly as possible.
       x11vnc cannot wait forever for each SSL connection, and so if you
       dawdle too long inspecting the certs, etc it can lead to problems.
       Get it working first before taking your time to read the details
       in the dialogs, etc.
     * No inetd, Please: Even if you intend to deploy via inetd or xinetd
       eventually, get that working later (and remember do not use
       something like "-ssl TMP" that creates a new temporary SSL
       certificate for every new socket connection.)
     * Nothing Fancy: Do not try fancy stuff like -svc, -create, -unixpw,
       "-users unixpw=", "-users sslpeer=", -sslverify, etc. Just get the
       simplest connection working first and then incrementally add what
       you need.

   So the recommended test command lines are:
   x11vnc -ssl SAVE -http
   x11vnc -ssl SAVE -httpdir /path/to/x11vnc/classes/ssl

   Use the latter if x11vnc cannot automatically find the classes/ssl
   directory (this what the -http option instructs it to do.) Then point
   your browser to the HTTP (not HTTPS) URL it prints out.

   Following the above guidelines, did it work? If so, Congratulations!!
   you created an SSL encrypted connection between the SSL Java applet
   running in your web browser and x11vnc. The fact that you used HTTP
   instead of HTTPS to download the applet is not the end of the world
   (some users do it this way), the main thing is that the VNC traffic is
   encrypted with SSL. If you are having trouble even with the above
   baseline test case feel free to contact me (please send the Full
   x11vnc output, not just part of it; the complete x11vnc command line;
   the URL(s) entered in the browser; the full Java Console output; and
   anything else you can think of.)

   Next, you can add the features you want one by one testing it still
   works each time. I suggest first turning on the HTTPS applet download
   (https://hostname:5900) if that is what you intend to use. That one
   gives the most trouble because of the ambiguity of passing two
   different protocols (HTTP and VNC) through the same SSL service port.

   Next, turn on inetd if you intend to use that (this can be tricky too,
   be sure to use -oa logfile and inspect it carefully if there are
   problems.) If you are going to use non-standard ports (e.g. "-rfbport
   443" as root), work on that next. Then enable the firewall, router
   port redirection channel (you will somehow need to be outside to do
   that, maybe test that through another VNC session.)

   Then, if you plan to use them, enable "fancy stuff" like "-svc" or
   "-unixpw", etc, etc. Be sure to add a password either "-rfbauth" or
   "-unixpw" or both. If you need to have the web browser use a corporate
   Web Proxy (i.e. it cannot connect directly) work on that last. Ditto
   for the Apache portal.


   Router/Firewall port redirs:  If you are doing port redirection at
   your router to an internal machine running x11vnc AND the internet
   facing port is different from the internal machine's VNC port, you
   will need to apply the PORT applet parameter to indicate to the applet
   the Internet facing port number (otherwise by default the internal
   machine's port, say 5900, is sent and that of course is rejected at
   the firewall/router.) For example:
  https://far-away.east:443/?GET=1&PORT=443

   So in this example the user configures his router to redirect
   connections to port 443 on his Internet side to, say, port 5900 on the
   internal machine running x11vnc. See also the -httpsredir option that
   will try to automate this for you.

   To configure your router to do port redirection, see its instructions.
   Typically, from the inside you point a web browser to a special URL
   (e.g. http://192.168.1.1) and you get a web interface to configure it.
   Look for something like "Port Redirection" or "Port Forwarding",
   probably under "Advanced" or something like that. If you have a Linux
   or Unix system acting as your firewall/router, see its firewall
   configuration.

   You can also use x11vnc options -rfbport NNNNN and -httpport NNNNN to
   match the ports that your firewall will be redirecting to the machine
   where x11vnc is run.


   Tedious Dialogs: If you do serve the SSL enabled Java viewer via https
   be prepared for quite a number of "are you sure you trust this site?"
   dialogs:
     * First from the Web browser that cannot verify the self-signed
       certificate when it downloads index.vnc.
     * From the Web browser again noting that the common name on the
       certificate does not match the hostname of the remote machine.
     * Next from the Java VM that cannot verify the self-signed
       certificate when it downloads VncViewer.jar.
     * And also from the Java VM again noting that the common name on the
       certificate does not match the hostname of the remote machine.
     * Finally from the Java VncViewer applet itself saying it cannot
       verify the certificate! (or a popup asking you if you want to see
       the certificate.)

   Note that sometimes if you pause too long at one of the above dialogs
   then x11vnc may exceed a timeout and assume the current socket
   connection is VNC instead of the HTTPS it actually is (but since you
   have paused too long at the dialog the GET request comes too late.)
   Often hitting Reload and going through the dialogs more quickly will
   let you connect. The Java VM dialogs are the most important ones to
   NOT linger at. If you see in the x11vnc output a request for
   VncViewer.class instead of VncViewer.jar it is too late... you will
   need to completely restart the Web browser to get it to try for the
   jar again. You can use the -https option if you want a dedicated port
   for HTTPS connections instead of sharing the VNC port.

   To see example x11vnc output for a successful https://host:5900/
   connection with the Java Applet see This Page. And here is a newer
   example including the Java Console output.

   All of the x11vnc Java Viewer applet parameters are described in the
   file classes/ssl/README


   Notes on the VNC Viewer ss_vncviewer wrapper script:

   If you want to use a native VNC Viewer with the SSL enabled x11vnc you
   will need to run an external SSL tunnel on the Viewer side. There do
   not seem to be any native SSL VNC Viewers outside of our x11vnc and
   SSVNC packages. The basic ideas of doing this were discussed for
   external tunnel utilities here.

   The ss_vncviewer script provided with x11vnc and SSVNC can set up the
   stunnel tunnel automatically on unix as long as the stunnel command is
   installed on the Viewer machine and available in PATH (and vncviewer
   too of course.) Note that on a Debian based system you will need to
   install the package stunnel4 not stunnel. You can set the environment
   variables STUNNEL and VNCVIEWERCMD to point to the correct programs if
   you want to override the defaults.

   Here are some examples:
  1)  ss_vncviewer far-away.east:0

  2)  ss_vncviewer far-away.east:0 -encodings "copyrect tight zrle hextile"

  3)  ss_vncviewer -verify ./server.crt far-away.east:0

  4)  ss_vncviewer -mycert ./client.pem far-away.east:0

  5)  ss_vncviewer -proxy far-away.east:8080 myworkstation:0

   The first one is the default mode and accepts the x11vnc certificate
   without question. The second one is as the first, but adds the
   -encodings options to the vncviewer command line.

   The third one requires that the x11vnc server authenticate itself to
   the client against the certificate in the file ./server.crt (e.g. one
   created by "x11vnc -ssl SAVE" and safely copied to the VNC viewer
   machine.)

   The fourth one is for VNC Viewer authentication, it uses ./client.pem
   to authenticate itself to x11vnc. One can supply both -verify and
   -mycert simultaneously.

   The fifth one shows that Web proxies can be used if that is the only
   way to get out of the firewall. If the "double proxy" situation arises
   separate the two by commas. See this page for more information on how
   Web proxies come into play.

   If one uses a Certificate Authority (CA) scheme described here, the
   wrapper script would use the CA cert instead of the server cert:
  3')  ss_vncviewer -verify ./cacert.crt far-away.east:0

   Update Jul/2006: we now provide an Enhanced TightVNC Viewer (SSVNC)
   package that starts up STUNNEL automatically along with some other
   features. All binaries (stunnel, vncviewer, and some utilities) are
   provided in the package. It works on Unix, Mac OS X, and Windows.


   Q-55: How do I use the Java applet VNC Viewer with built-in SSL
   tunneling when going through a Web Proxy?
   The SSL enabled Java VNC Viewer and firewall Proxies:

   SSL and HTTPS aside, there is a general problem with Firewall Proxies
   and Java Applets that open sockets. The applet is downloaded
   successfully (through the browser) using HTTP and the proxy, but when
   the applet tries to reconnect to the originating host (the only one
   allowed by security) it does not use the proxy channel. So it cannot
   reconnect to the server the applet came from!

   We have found a convenient workaround: in the directory where
   VncViewer.jar resides there is a digitally signed version of the same
   applet called SignedVncViewer.jar. Since the applet is digitally
   signed, there will be an additional dialog from the Java VM plugin
   asking you if you want to trust the applet fully.

   You should say "Yes". If you do, the applet will be run in a mode
   where it can try to determine the firewall proxy host name and port
   (it will ask you for them if it cannot find them.) This way it can
   connect directly to the Proxy and then request the CONNECT method to
   be redirected to the originating host (the x11vnc VNC Server.) SSL is
   then layered over this socket.

   To do this you should use the proxy.vnc HTML file like via this URL in
   your browser:
  https://yourmachine.com:5900/proxy.vnc

   (instead of the unsigned one in https://yourmachine.com:5900/ that
   gives the default index.vnc)

   Proxies that limit CONNECT to ports 443 and 563:

   Things become trickier if the Web proxy restricts which CONNECT ports
   can be redirected to. For security, some (most?) proxies only allow
   port 443 (HTTPS) and 563 (SNEWS) by default. In this case, the only
   thing to do is run x11vnc on that low port, e.g. "-rfbport 443", (or
   use a port redirection on, say, a firewall or router port 443 to the
   internal machine.)

   If you do such a redirection to an internal machine and x11vnc is not
   listening on port 443, you will probably need to edit proxy.vnc.
   Suppose the SSL x11vnc server was listening on port 5901. You should
   change the line in proxy.vnc from:
  <param name=PORT value=$PORT>

   to:
  <param name=PORT value=443>

   Since otherwise $PORT will be expanded to 5901 by x11vnc and the
   viewer applet will fail to connect to that port on the firewall.

   Another way to achieve the same thing is to use the applet PORT
   parameter:
  https://yourmachine.com/proxy.vnc?PORT=443

   this is cleaner because it avoids editing the file, but requires more
   parameters in the URL. See also the -httpsredir x11vnc option that
   will try to automate this for you. To use the GET trick discussed
   above, do:
  https://yourmachine.com/proxy.vnc?GET=1&PORT=443

   All of the x11vnc Java Viewer applet parameters are described in the
   file classes/ssl/README

   Here is an example of Java Console and x11vnc output for the Web proxy
   case.


   Note that both the ss_vncviewer stunnel Unix wrapper script and
   Enhanced TightVNC Viewer (SSVNC) can use Web proxies as well even
   though they do not involve a Web browser.


   Q-56: Can Apache web server act as a gateway for users to connect via
   SSL from the Internet with a Web browser to x11vnc running on their
   workstations behind a firewall?
   Yes. You will need to configure apache to forward these connections.
   It is discussed here. This SSL VNC portal provides a clean alternative
   to the traditional method where the user uses SSH to log in through
   the gateway to create the encrypted port redirection to x11vnc running
   on her desktop.

   Also see the desktop.cgi CGI script method that achieves much of what
   this Apache VNC SSL portal method does (as long as desktop.cgi's 'port
   redirection' mode is enabled.)


   Q-57: Can I create and use my own SSL Certificate Authority (CA) with
   x11vnc?
   Yes, see this page for how to do this and the utility commands x11vnc
   provides to create and manage many types of certificates and private
   keys.



   [Display Managers and Services]

   Q-58: How can I run x11vnc as a "service" that is always available?

   There are a number of ways to do this. The primary thing you need to
   decide is whether you want x11vnc to connect to the X session on the
   machine 1) regardless of who (or if anyone) has the X session, or 2)
   only if a certain user has the X session. Because X sessions are
   protected by X permissions (MIT-MAGIC-COOKIE files XAUTHORITY and
   $HOME/.Xauthority) the automatically started x11vnc will of course
   need to have sufficient permissions to connect to the X display.

   Here are some ideas:
     * Use the description under "Continuously" in the FAQ on x11vnc and
       Display Managers
     * Use the description in the FAQ on x11vnc and inetd(8)
     * Use the description in the FAQ on Unix user logins and inetd(8)
     * Start x11vnc from your $HOME/.xsession (or $HOME/.xinitrc or
       autostart script or ...)
     * Although less reliable, see the x11vnc_loop rc.local hack below.

   The display manager scheme will not be specific to which user has the
   X session unless a test is specifically put into the display startup
   script (often named Xsetup.) The inetd(8) scheme may or may not be
   specific to which user has the X session (and it may not be able to do
   all users via the XAUTHORITY permission issues.)

   The .xsession/.xinitrc scheme is obviously is specific to a particular
   user and only when they are logged into X. If you do not know what a
   $HOME/.xsession script is or how to use one, perhaps your desktop has
   a "session startup commands" configuration option. The command to be
   run in the .xsession or .xinitrc file may look like this:
x11vnc -logfile $HOME/.x11vnc.log -rfbauth $HOME/.vnc/passwd -forever -bg

   plus any other options you desire.

   Depending on your desktop and/or OS/distribution the automatically run
   X startup scripts (traditionally .xsession/.xinitrc) may have to be in
   a different directory or have a different basename. One user
   recommends the description under 'Running Scripts Automatically' at
   this link.

   Firewalls: note all methods will require the host-level firewall to be
   configured to allow connections in on a port. E.g. 5900 (default VNC
   port) or 22 (default SSH port for tunnelling VNC.) Most systems these
   days have firewalls turned on by default, so you will actively have to
   do something to poke a hole in the firewall at the desired port
   number. See your system administration tool for Firewall settings
   (Yast, Firestarter, etc.)


   Q-59: How can I use x11vnc to connect to an X login screen like xdm,
   GNOME gdm, KDE kdm, or CDE dtlogin? (i.e. nobody is logged into an X
   session yet.)

   We describe two scenarios here. The first is called 'One time only'
   meaning you just need to do it quickly once and don't want to repeat;
   and the second is called 'Continuously' meaning you want the access to
   be available after every reboot and after every desktop logout.
     _________________________________________________________________

   One time only:   If the X login screen is running and you just want to
   connect to it once (i.e. a one-shot):

   It is usually possible to do this by just adjusting the XAUTHORITY
   environment variable to point to the correct MIT-COOKIE auth file
   while running x11vnc as root, e.g. for the gnome display manager, GDM:
  x11vnc -auth /var/gdm/:0.Xauth -display :0

   (the -auth option sets the XAUTHORITY variable for you.)

   There will be a similar thing to do for xdm using however a different
   auth directory path (perhaps something like
   /var/lib/xdm/authdir/authfiles/A:0-XQvaJk) for the xdm greeter or
   /var/lib/kdm/A:0-crWk72 (or /var/run/xauth/A:0-qQPftr, etc. etc) for
   the kdm greeter. Of course, the random characters in the file basename
   will vary and you will need to use the actual filename on your system.
   Read your system docs to find out where the display manager cookie
   files are kept.

   Trick: sometimes ps(1) can reveal the X server process -auth argument
   (e.g. "ps wwaux | grep auth") and hence the path to the auth file.

   x11vnc must be run as root for this because the /var/gdm/:0.Xauth,
   /var/lib/kdm/A:0-crWk72, etc. auth files are only readable by root. If
   you do not want to run x11vnc as root, you can copy (as root or sudo)
   the auth file to some location and make it readable by your userid.
   Then run x11vnc as your userid with -auth pointed to the copied file.

   Update Dec/2009: use "-auth guess" to have x11vnc try to guess the
   location of the auth file for you.

   You next connect to x11vnc with a VNC viewer, give your username and
   password to the X login prompt to start your session.

   Note:  GDM: gdm seems to have an annoying setting that causes x11vnc
   (and any other X clients) to be killed after the user logs in. Setting
   KillInitClients=false in the [daemon] section of /etc/X11/gdm/gdm.conf
   (or /etc/gdm/gdm.conf, etc.) avoids this. Otherwise, just restart
   x11vnc and then reconnect your viewer. Other display managers (kdm,
   etc) may also have a similar problem. One user reports having to alter
   "gdm.conf-custom" as well.

   Note:  Solaris: For dtlogin in addition to the above sort of trick
   (BTW, the auth file should be in /var/dt), you'll also need to add
   something like Dtlogin*grabServer:False to the Xconfig file
   (/etc/dt/config/Xconfig or /usr/dt/config/Xconfig on Solaris, see the
   example at the end of this FAQ.) Then restart dtlogin, e.g.:
   /etc/init.d/dtlogin stop; /etc/init.d/dtlogin start or reboot.

   Update Nov/2008: Regarding GDM KillInitClients: see the -reopen option
   for another possible workaround.

   Update Oct/2009: Regarding GDM KillInitClients: starting with x11vnc
   0.9.9 it will try to apply heuristics to detect if a window manager is
   not running (i.e. whether the Display Manager Greeter Login panel is
   still up.) If it thinks the display manager login is still up it will
   delay creating windows or using XFIXES. The former is what GDM uses to
   kill the initial clients, use of the latter can cause a different
   problem: an Xorg server crash. So with 0.9.9 and later it should all
   work without needing to set KillInitClients=false (which is a good
   because recent GDM, v2.24, has removed this option) or use -noxfixes.
   To disable the heuristics and delaying set X11VNC_AVOID_WINDOWS=never;
   to set the delay time explicitly use, e.g., X11VNC_AVOID_WINDOWS=120
   (delays for 120 seconds after the VNC connection; you have that long
   to log in.)
     _________________________________________________________________

   Continuously:   Have x11vnc reattach each time the X server is
   restarted (i.e. after each logout and reboot):

   To make x11vnc always attached to the X server including the login
   screen you will need to add a command to a display manager startup
   script.

   Please consider the security implications of this! The VNC display for
   the X session always accessible (but hopefully password protected.)
   Add -localhost if you only plan to access via a SSH tunnel.

   The name of the display manager startup script file depends on desktop
   used and seem to be:
     GDM (GNOME)  /etc/X11/gdm/Init/Default
                  /etc/gdm/Init/Default
     KDM (KDE)    /etc/kde*/kdm/Xsetup
     XDM          /etc/X11/xdm/Xsetup          (or sometimes xdm/Xsetup_0)
     CDE          /etc/dt/config/Xsetup

   although the exact location can be operating system, distribution, and
   time dependent. See the documentation for your display manager:
   gdm(1), kdm(1), xdm(1), dtlogin(1) for additional details. There may
   also be display number specific scripts: e.g. Xsetup_0 vs. Xsetup, you
   need to watch out for.

   Note:  You should read and understand all of the Note's and Update's
   in the 'One time only' section above. All of the GDM topics apply here
   as well:

   Note:  GDM: The above (in 'One time only') gdm setting of
   KillInitClients=false in /etc/X11/gdm/gdm.conf (or /etc/gdm/gdm.conf,
   etc.) for GDM is needed here as well. Other display managers (KDM,
   etc) may also have a similar problem.

   Also see the Update Oct/2009 above where x11vnc 0.9.9 and later
   automatically avoids being killed.

   Note:  DtLogin: The above (in 'One time only')
   Dtlogin*grabServer:False step for Solaris will be needed for dtlogin
   here as well.

   In any event, the line you will add to the display manager script
   (Xsetup, Default, or whatever) will look something like:
  /usr/local/bin/x11vnc -rfbauth /path/to/the/vnc/passwd -o /var/log/x11vnc.log
 -forever -bg

   where you should customize the exact command to your needs (e.g.
   -localhost for SSH tunnel-only access; -ssl SAVE for SSL access; etc.)

   Happy, happy, joy, joy:  Note that we do not need to specify -display
   or -auth because happily they are already set for us in the DISPLAY
   and XAUTHORITY environment variables for the Xsetup script!!!

   You may also want to force the VNC port with something like "-rfbport
   5900" (or -N) to avoid autoselecting one if 5900 is already taken.
     _________________________________________________________________

   Fedora/gdm: Here is an example of what we did on a vanilla install of
   Fedora-C3 (seems to use gdm by default.) Add a line like this to
   /etc/X11/gdm/Init/:0
  /usr/local/bin/x11vnc -rfbauth /etc/x11vnc.passwd -forever -bg -o /var/log/x1
1vnc.log

   And then add this line to /etc/X11/gdm/gdm.conf (or /etc/gdm/gdm.conf,
   etc.) in the [daemon] section:
  KillInitClients=false

   Then restart: /usr/sbin/gdm-restart (or reboot.) The
   KillInitClients=false setting is important: without it x11vnc will be
   killed immediately after the user logs in. Here are full details on
   how to configure gdm
     _________________________________________________________________

   Solaris/dtlogin: Here is an example of what we did on a vanilla
   install of Solaris:
   Make the directory /etc/dt/config:
  mkdir -p /etc/dt/config

   Copy over the Xconfig file for customization:
  cp /usr/dt/config/Xconfig /etc/dt/config/Xconfig

   Edit /etc/dt/config/Xconfig and uncomment the line:
  Dtlogin*grabServer:        False

   Next, copy over Xsetup for customization:
  cp /usr/dt/config/Xsetup /etc/dt/config/Xsetup

   Edit /etc/dt/config/Xsetup and at the bottom put a line like:
  /usr/local/bin/x11vnc -forever -o /var/log/x11vnc.log -bg

   (tweaked to your local setup and preferences, a password via -rfbauth,
   etc. would be a very good idea.)

   Restart the X server and dtlogin:
  /etc/init.d/dtlogin stop
  /etc/init.d/dtlogin start

   (or reboot or maybe just restart the X session.)
     _________________________________________________________________

   KDM: One user running the kdm display manager reports putting this
   line:
  x11vnc -forever -rfbauth /home/xyz/.vnc/passwd -bg -o /var/log/x11vnc.log

   in /etc/kde/kdm/Xsetup. After rebooting the system it all seemed to
   work fine.
     _________________________________________________________________


   If you do not want to deal with any display manager startup scripts,
   here is a kludgey script that can be run manually or out of a boot
   file like rc.local: x11vnc_loop It will need some local customization
   before running. Because the XAUTHORITY auth file must be guessed by
   this script, use of the display manager script method described above
   is greatly preferred. There is also the -loop option that does
   something similar.

   If the machine is a traditional Xterminal you may want to read this
   FAQ.

   Firewalls: note all methods will require the host-level firewall to be
   configured to allow connections in on a port. E.g. 5900 (default VNC
   port) or 22 (default SSH port for tunnelling VNC.) Most systems these
   days have firewalls turned on by default, so you will actively have to
   do something to poke a hole in the firewall at the desired port
   number. See your system administration tool for Firewall settings
   (Yast, Firestarter, etc.)


   Q-60: Can I run x11vnc out of inetd(8)? How about xinetd(8)?

   Yes, perhaps a line something like this in /etc/inetd.conf will do it
   for you:

  5900 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc_sh

   where the shell script /usr/local/bin/x11vnc_sh uses the -inetd option
   and looks something like (you'll need to customize to your settings.)
#!/bin/sh
/usr/local/bin/x11vnc -inetd -display :0 -auth /home/fred/.Xauthority \
        -rfbauth /home/fred/.vnc/passwd -o /var/log/x11vnc_sh.log

   Important:  Note that you must redirect the standard error output to a
   log file (e.g. -o logfile) or "2>/dev/null" for proper operation via
   inetd (otherwise the standard error also goes to the VNC vncviewer,
   and that confuses it greatly, causing it to abort.) If you do not use
   a wrapper script as above but rather call x11vnc directly in
   /etc/inetd.conf and do not redirect stderr to a file, then you must
   specify the -q (aka -quiet) option: "/usr/local/bin/x11vnc -q -inetd
   ...". When you supply both -q and -inet and no "-o logfile" then
   stderr will automatically be closed (to prevent, e.g. library stderr
   messages leaking out to the viewer.) The recommended practice is to
   use "-o logfile" to collect the output in a file or wrapper script
   with "2>logfile" redirection because the errors and warnings printed
   out are very useful in troubleshooting problems.

   Note also the need to set XAUTHORITY via -auth to point to the
   MIT-COOKIE auth file to get permission to connect to the X display
   (setting and exporting the XAUTHORITY variable accomplishes the same
   thing.) See the x11vnc_loop file in the previous question for more
   ideas on what that auth file may be, etc. The scheme described in the
   FAQ on Unix user logins and inetd(8) works around the XAUTHORITY issue
   nicely.

   Note:  On Solaris you cannot have the bare number 5900 in
   /etc/inetd.conf, you'll need to replace it with a word like x11vnc an
   then put something like "x11vnc 5900/tcp" in /etc/services.

   Since the process runs as root, it might be a bad idea to have the
   logfile in a world-writable area like /tmp if there are untrustworthy
   users on the machine. Perhaps /var/log is a better place.

   Be sure to look at your /etc/hosts.allow and /etc/hosts.deny settings
   to limit the machines that can connect to this service (your desktop!)
   For the above example with /etc/hosts.allow:
  x11vnc_sh : 123.45.67.89

   A really safe way to do things is to limit the above inetd to
   localhost only (via /etc/hosts.allow) and use ssh to tunnel the
   incoming connection. Using inetd for this prevents there being a tiny
   window of opportunity between x11vnc starting up and your vncviewer
   connecting to it. Always use a VNC password to further protect against
   unwanted access.

   For xinetd(8), one user reports he created the file
   /etc/xinetd.d/x11vncservice containing the following:
# default: off
# description:
service x11vncservice
{
        flags           = REUSE NAMEINARGS
        port            = 5900
        type            = UNLISTED
        socket_type     = stream
        protocol        = tcp
        wait            = no
        user            = root
        server          = /usr/sbin/tcpd
        server_args     = /usr/local/bin/x11vnc_sh
        disable         = no
}

   With the contents of /usr/local/bin/x11vnc_sh similar to the example
   given above. One user reports this works with avoiding the wrapper
   script:
service x11vncservice
{
        port            = 5900
        type            = UNLISTED
        socket_type     = stream
        protocol        = tcp
        wait            = no
        user            = root
        server          = /usr/local/bin/x11vnc
        server_args     = -inetd -q -display :0 -auth /var/gdm/:0.Xauth
        disable         = no
}

   (or one can replace the -q with say "-o /var/log/x11vnc.log" to
   capture a log)

   The above works nicely for GDM because the -auth file is a fixed name.
   For KDM or XDM the filename varies. Here is one idea for a x11vnc_sh
   wrapper to try to guess the name:
#!/bin/sh
COLUMNS=256
export COLUMNS
authfile=`ps wwaux | grep '/X.*-auth' | grep -v grep | sed -e 's/^.*-auth *//'
-e 's/ .*$//' | head -n 1`

if [ -r "$authfile" ]; then
        exec /usr/local/bin/x11vnc -inetd -o /var/log/x11vnc.log -display :0 -a
uth "$authfile"
fi
exit 1

   Starting with x11vnc 0.9.3 this can be automated by:
#!/bin/sh
exec /usr/local/bin/x11vnc -inetd -o /var/log/x11vnc.log -find -env FD_XDM=1


   Q-61: Can I have x11vnc advertise its VNC service and port via mDNS /
   Zeroconf (e.g. Avahi) so VNC viewers on the local network can detect
   it automatically?

   Yes, as of Feb/2007 x11vnc supports mDNS / Zeroconf advertising of its
   service via the Avahi client library. Use the option -avahi (same as
   -mdns or -zeroconf) to enable it. Depending on your setup you may need
   to install Avahi (including the development/build packages), enable
   the server: avahi-daemon and avahi-dnsconfd, and possibly open up UDP
   port 5353 on your firewall.

   If the Avahi client library or build environment is not available at
   build-time, then at run-time x11vnc will try to look for external
   helper programs, avahi-browse(1) or dns-sd(1), to do the work.

   The service was tested with Chicken of the VNC ("Use Bonjour"
   selected) on a Mac on the same network and the service was noted and
   listed in the servers list. Clicking on it and then "Connect"
   connected automatically w/o having to enter any hostnames or port
   numbers.

   It appears SuSE 10.1 comes with avahi (or you can add packages, e.g.
   avahi-0.6.5-27) but not the development package (you can use the
   OpenSuSE avahi-devel rpm.) Unfortunately, you may need to disable
   another Zeroconf daemon "/etc/init.d/mdnsd stop", before doing
   "/etc/init.d/avahi-daemon start" and "/etc/init.d/avahi-dnsconfd
   start". We also had to comment out the browse-domains line in
   /etc/avahi/avahi-daemon.conf. Hopefully there is "LessConf" to do on
   other distros/OS's...


   Q-62: Can I have x11vnc allow a user to log in with her UNIX username
   and password and then have it find her X session display on that
   machine and then attach to it? How about starting an X session if one
   cannot be found?

   The easiest way to do this is via inetd(8) using the -unixpw and
   -display WAIT options. The reason inetd(8) makes this easier is that
   it starts a new x11vnc process for each new user connection. Otherwise
   a wrapper would have to listen for connections and spawn new x11vnc's
   (see this example and also the -loopbg option.) inetd(8) is not
   required for this, but it makes some aspects more general.

   Also with inetd(8) users always connect to a fixed VNC display, say
   hostname:0, and do not need to memorize a special VNC display number
   just for their personal use, etc.

   Update: Use the -find, -create, -svc, and -xdmsvc options that are
   shorthand for common FINDCREATEDISPLAY usage modes (e.g. terminal
   services) described below. (i.e. simply use "-svc" instead of the
   cumbersome "-display WAIT:cmd=FINDCREATEDISPLAY-Xvfb -unixpw -users
   unixpw= -ssl SAVE")

   The -display WAIT option makes x11vnc wait until a VNC viewer is
   connected before attaching to the X display.

   Additionally it can be used to run an external command that returns
   the DISPLAY and XAUTHORITY data. We provide some useful builtin ones
   (FINDDISPLAY and FINDCREATEDISPLAY below), but in principle one could
   supply his own script: "-display WAIT:cmd=/path/to/find_display" where
   the script find_display might look something like this.

   A default script somewhat like the above is used under "-display
   WAIT:cmd=FINDDISPLAY" (same as -find) The format for any such command
   is that it returns DISPLAY=:disp as the first line and any remaining
   lines are either XAUTHORITY=file or raw xauth data (the above example
   does the latter.) If applicable (-unixpw mode), the program is run as
   the Unix user name who logged in.

   On Linux if the virtual terminal is known the program appends ",VT=n"
   to the DISPLAY line; a chvt n will be attempted automatically. Or if
   only the X server process ID is known it appends ",XPID=n" (a chvt
   will be attempted by x11vnc.)

   Tip: Note that the -find option is an alias for "-display
   WAIT:cmd=FINDDISPLAY". Use it!

   The -unixpw option allows UNIX password logins. It conveniently knows
   the Unix username whose X display should be found. Here are a couple
   /etc/inetd.conf examples of this usage:
5900  stream  tcp  nowait  nobody  /usr/sbin/tcpd /usr/local/bin/x11vnc -inetd
-unixpw \
      -find -o /var/log/x11vnc.log -ssl SAVE -ssldir /usr/local/certs
5900  stream  tcp  nowait  root    /usr/sbin/tcpd /usr/local/bin/x11vnc -inetd
-unixpw \
      -find -o /var/log/x11vnc.log -ssl SAVE -users unixpw=

   Note we have used the -find alias and the very long lines have been
   split. An alternative is to use a wrapper script, e.g.
   /usr/local/bin/x11vnc.sh that has all of the options. (see also the
   -svc alias.)

   In the first inetd line x11vnc is run as user "nobody" and stays user
   nobody during the whole session. The permissions of the log files and
   certs directory will need to be set up to allow "nobody" to use them.

   In the second one x11vnc is run as root and switches to the user that
   logs in due to the "-users unixpw=" option.

   Note that SSL is required for this mode because otherwise the Unix
   password would be passed in clear text over the network. In general
   -unixpw is not required for this sort of scheme, but it is convenient
   because it determines exactly who the Unix user is whose display
   should be sought. Otherwise the find_display script would have to use
   some method to work out DISPLAY, XAUTHORITY, etc (perhaps you use
   multiple inetd ports and hardwire usernames for different ports.)

   If you really want to disable the SSL or SSH -localhost constraints
   (this is not recommended unless you really know what you are doing:
   Unix passwords sent in clear text is a very bad idea...) read the
   -unixpw documentation.

   A inetd(8) scheme for a fixed user that doesn't use SSL or unix
   passwds could be:
  /usr/local/bin/x11vnc -inetd -users =fred -find -rfbauth /home/fred/.vnc/pass
wd -o /var/log/x11vnc.log

   The "-users =fred" option will cause x11vnc to switch to user fred and
   then find his X display. The VNC password (-rfbauth) as opposed to
   Unix password (-unixpw) is used to authenticate the VNC client.

   Similar looking commands to the above examples can be run directly and
   do not use inetd (just remove the -inetd option and run from the
   cmdline, etc.)


   X Session Creation: An added (Nov/2006) extension to FINDDISPLAY is
   FINDCREATEDISPLAY where if it does not find an X display via the
   FINDDISPLAY method it will create an X server session for the user
   (i.e. desktop/terminal server.) This is the only time x11vnc actually
   tries to start up an X server (normally it just attaches to an
   existing one.)

   For virtual sessions you will need to install the Xvfb program (e.g.
   apt-get install xvfb) or our Xdummy program (see below.)

   By default it will only try to start up virtual (non-hardware) X
   servers: first Xvfb and if that is not available then Xdummy (included
   in the x11vnc source code.) Note that Xdummy only works on Linux
   whereas Xvfb works just about everywhere (and in some situations
   Xdummy must be run as root.) An advantage of Xdummy over Xvfb is that
   Xdummy supports RANDR dynamic screen resizing, which can be handy if
   the user accesses the desktop from different sized screens (e.g.
   workstation and laptop.)

   So an inetd(8) example might look like:
5900 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc -inetd \
      -o /var/log/x11vnc.log -http -prog /usr/local/bin/x11vnc \
      -ssl SAVE -unixpw -users unixpw= -display WAIT:cmd=FINDCREATEDISPLAY

   Where the very long lines have been split. See below where that long
   and cumbersome last line is replaced by the -svc alias.

   The above mode will allow direct SSL (e.g. ss_vncviewer or SSVNC)
   access and also Java Web browers access via: https://hostname:5900/.

   Tip: Note that the -create option is an alias for "-display
   WAIT:cmd=FINDCREATEDISPLAY-Xvfb".

   Tip: Note that -svc is a short hand for the long "-ssl SAVE -unixpw
   -users unixpw= -display WAIT:cmd=FINDCREATEDISPLAY" part. Unlike
   -create, this alias also sets up SSL encryption and Unix password
   login.

   The above inetd example then simplifies to:
5900 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc -inetd \
      -o /var/log/x11vnc.log -http -prog /usr/local/bin/x11vnc \
      -svc

   Tip: In addition to the usual unixpw parameters, inside the VNC viewer
   the user can specify after his username (following a ":" see -display
   WAIT for details) for FINDCREATEDISPLAY they can add "geom=WxH" or
   "geom=WxHxD" to specify the width, height, and optionally the color
   depth. E.g. "fred:geom=800x600" at the login: prompt. Also if the env.
   var X11VNC_CREATE_GEOM is set to the desired WxH or WxHxD that will be
   used by x11vnc.

   You can set the env. var X11VNC_SKIP_DISPLAY to a comma separated list
   of displays to ignore in the FINDDISPLAY process (to force creation of
   new displays in some cases.) The user logging in via the vncviewer can
   also set this via username:nodisplay=...)

   If you do not plan on using the Java Web browser applet you can remove
   the -http (and -prog) option since this will speed up logging-in by a
   few seconds (x11vnc will not have to wait to see if a connection is
   HTTPS or VNC.)

   For reference, xinetd format in the file, say, /etc/xinetd.d/x11vnc:
service x11vnc
{
        type            = UNLISTED
        port            = 5900
        socket_type     = stream
        protocol        = tcp
        wait            = no
        user            = root
        server          = /usr/local/bin/x11vnc
        server_args     = -inetd -o /var/log/x11vnc.log -http -prog /usr/local/
bin/x11vnc -svc
        disable         = no
}

   To print out the script in this case use "-display
   WAIT:cmd=FINDCREATEDISPLAY-print". To change the preference of
   Xservers and which to try list them, e.g.: "-display
   WAIT:cmd=FINDCREATEDISPLAY-X,Xvfb,Xdummy" or use "-create_xsrv
   X,Xvfb,Xdummy". The "X" one means to try to start up a real, hardware
   X server, e.g. startx(1) (if there is already a real X server running
   this may only work on Linux and the chvt program may need to be run to
   switch to the correct Linux virtual terminal.) x11vnc will try to run
   chvt automatically if it can determine which VT should be switched to.

   XDM/GDM/KDM Login Greeter Panel: If you want to present the user with
   a xdm/gdm/kdm display manager "greeter" login you can use Xvfb.xdmcp
   instead of Xvfb, etc in the above list. However, you need to configure
   xdm/gdm/kdm to accept localhost XDMCP messages, this can be done by
   (from -help output):
      If you want the FINDCREATEDISPLAY session to contact an XDMCP login
      manager (xdm/gdm/kdm) on the same machine, then use "Xvfb.xdmcp"
      instead of "Xvfb", etc.  The user will have to supply his username
      and password one more time (but he gets to select his desktop
      type so that can be useful.)  For this to work, you will need to
      enable localhost XDMCP (udp port 177) for the display manager.
      This seems to be:

       for gdm in gdm.conf:   Enable=true in section [xdmcp]
       for kdm in kdmrc:      Enable=true in section [Xdmcp]
       for xdm in xdm-config: DisplayManager.requestPort: 177

   Unless you are also providing XDMCP service to xterminals or other
   machines, make sure that the host access list only allows local
   connections (the name of this file is often Xaccess and it is usually
   setup by default to do just that.) Nowadays, host level firewalling
   will also typically block UDP (port 177 for XDMCP) by default
   effectively limiting the UDP connections to localhost.

   Tip: Note that -xdmsvc is a short hand alias for the long "-ssl SAVE
   -unixpw -users unixpw= -display
   WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp". So we simply use:
service x11vnc
{
        type            = UNLISTED
        port            = 5900
        socket_type     = stream
        protocol        = tcp
        wait            = no
        user            = root
        server          = /usr/local/bin/x11vnc
        server_args     = -inetd -o /var/log/x11vnc.log -xdmsvc
        disable         = no
}

   (Note: use "-svc" instead of "-xdmsvc" for no XDMCP login greeter.)


   Local access (VNC Server and VNC Viewer on the same machine): To
   access your virtual X display session locally (i.e. while sitting at
   the same machine it is running on) one can perhaps have something like
   this in their $HOME/.xinitrc
#!/bin/sh
x11vnc -create -rfbport 5905 -env WAITBG=1
vncviewer -geometry +0+0 -encodings raw -passwd $HOME/.vnc/passwd localhost:5

   You may not need the -passwd. Recent RealVNC viewers might be this:
#!/bin/sh
x11vnc -create -rfbport 5905 -env WAITBG=1
vncviewer -FullScreen -PreferredEncoding raw -passwd $HOME/.vnc/passwd localhos
t:5

   This way a bare X server is run with no window manager or desktop; it
   simply runs only the VNC Viewer on the real X server. The Viewer then
   draws the virtual X session on to the real one. On your system it
   might not be $HOME/.xinitrc, but rather .xsession, .Xclients, or
   something else. You will need to figure out what it is for your system
   and configuration.

   There may be a problem if the resolution (WxH) of the virtual X
   display does not match that of the physical X display.

   If you do not want to or cannot figure out the X startup script name
   (.xinitrc, etc) you could save the above commands to a shell script,
   say "vnclocal", and the log in via the normal KDM or GDM greeter
   program using the "Failsafe" option. Then in the lone xterm that comes
   up type "vnclocal" to connect to your virtual X display via x11vnc and
   vncviewer.

     _________________________________________________________________

   Summary: The "-display WAIT:cmd=FINDCREATEDISPLAY" scheme can be used
   to provide a "desktop service" (i.e. terminal service) on the server
   machine: you always get some desktop there, either a real hardware X
   server or a virtual one (depending on how you set things up.)

   So it provides simple "terminal services" based on Unix username and
   password. The created X server sessions (virtual or real hardware)
   will remain running after you disconnect the VNC viewer and will be
   found again on reconnecting via VNC and logging in. To terminate them
   use the normal way to Exit/LogOut from inside your X session. The user
   does not have to memorize which VNC display number is his. They all go
   the same one (e.g. hostname:0) and it switches based on username.


   Q-63: Can I have x11vnc restart itself after it terminates?

   One could do this in a shell script, but now there is an option -loop
   that makes it easier. Of course when x11vnc restarts it needs to have
   permissions to connect to the (potentially new) X display. This mode
   could be useful if the X server restarts often. Use e.g. "-loop5000"
   to sleep 5000 ms between restarts. Also "-loop2000,5" to sleep 2000 ms
   and only restart 5 times.

   One can also use the -loopbg to emulate inetd(8) to some degree, where
   each connected process runs in the background. It could be combined,
   say, with the -svc option to provide simple terminal services without
   using inetd(8).


   Q-64: How do I make x11vnc work with the Java VNC viewer applet in a
   web browser?

   To have x11vnc serve up a Java VNC viewer applet to any web browsers
   that connect to it, run x11vnc with this option:
  -httpdir /path/to/the/java/classes/dir

   (this directory will contain the files index.vnc and, for example,
   VncViewer.jar) Note that libvncserver contains the TightVNC Java
   classes jar file for your convenience. (it is the file
   classes/VncViewer.jar in the source tree.)

   You will see output something like this:
  14/05/2004 11:13:56 Autoprobing selected port 5900
  14/05/2004 11:13:56 Listening for HTTP connections on TCP port 5800
  14/05/2004 11:13:56   URL http://walnut:5800
  14/05/2004 11:13:56 screen setup finished.
  14/05/2004 11:13:56 The VNC desktop is walnut:0
  PORT=5900

   then you can connect to that URL with any Java enabled browser. Feel
   free to customize the default index.vnc file in the classes directory.

   As of May/2005 the -http option will try to guess where the Java
   classes jar file is by looking in expected locations and ones relative
   to the x11vnc binary.

   Also note that if you wanted to, you could also start the Java viewer
   entirely from the viewer-side by having the jar file there and using
   either the java or appletviewer commands to run the program.
  java -cp ./VncViewer.jar VncViewer HOST far-away.east PORT 5900

   Proxies: See the discussion here if the web browser must use a web
   proxy to connect to the internet. It is tricky to get Java applets to
   work in this case: a signed applet must be used so it can connect to
   the proxy and ask for the redirection to the VNC server. One way to do
   this is to use the signed SSL one referred to in classes/ssl/proxy.vnc
   and set disableSSL=yes (note that this has no encryption; please use
   SSL or SSH as discuss elsewhere on this page) in the URL or the file.


   Q-65: Are reverse connections (i.e. the VNC server connecting to the
   VNC viewer) using "vncviewer -listen" and vncconnect(1) supported?

   As of Mar/2004 x11vnc supports reverse connections. On Unix one starts
   the VNC viewer in listen mode: "vncviewer -listen" (see your
   documentation for Windows, etc), and then starts up x11vnc with the
   -connect option. To connect immediately at x11vnc startup time use the
   "-connect host:port" option (use commas for a list of hosts to connect
   to.) The ":port" is optional (default is VNC listening port is 5500.)

   If a file is specified instead: -connect /path/to/some/file then that
   file is checked periodically (about once a second) for new hosts to
   connect to.

   The -remote control option (aka -R) can also be used to do this during
   an active x11vnc session, e.g.:
x11vnc -display :0 -R connect:hostname.domain

   Use the "-connect_or_exit" option to have x11vnc exit if the reverse
   connection fails. Also, note the "-rfbport 0" option disables TCP
   listening for connections (potentially useful for reverse connection
   mode, assuming you do not want any "forward" connections.)

   Note that as of Mar/2006 x11vnc requires password authentication for
   reverse connections as well as for forward ones (assuming password
   auth has been enabled, e.g. via -rfbauth, -passwdfile, etc.) Many VNC
   servers do not require any password for reverse connections. To regain
   the old behavior supply this option "-env
   X11VNC_REVERSE_CONNECTION_NO_AUTH=1" to x11vnc.

   Vncconnect command: To use the vncconnect(1) program (from the core
   VNC package at www.realvnc.com) specify the -vncconnect option to
   x11vnc (Note: as of Dec/2004 -vncconnect is now the default.)
   vncconnect(1) must be pointed to the same X11 DISPLAY as x11vnc (since
   it uses X properties to communicate with x11vnc.) If you do not have
   or do not want to get the vncconnect(1) program, the following script
   (named "Vncconnect") may work if your xprop(1) supports the -set
   option:
#!/bin/sh
# usage: Vncconnect <host>
#        Vncconnect <host:port>
# note: not all xprop(1) support -set.
#
xprop -root -f VNC_CONNECT 8s -set VNC_CONNECT "$1"


   Q-66: Can reverse connections be made to go through a Web or SOCKS
   proxy or SSH?

   Yes, as of Oct/2007 x11vnc supports reverse connections through
   proxies: use the "-proxy host:port" option. The default is to assume
   the proxy is a Web proxy. Note that most Web proxies only allow proxy
   destination connections to ports 443 (HTTPS) and 563 (SNEWS) and so
   this might not be too useful unless the proxy has been modified
   (AllowCONNECT apache setting) or the VNC viewer listens on one of
   those ports (or the router does a port redir.) A web proxy may also be
   specified via "-proxy http://host:port"

   For SOCKS4 and SOCKS4a proxies use this format "-proxy
   socks://host:port". If the reverse connection hostname is a numerical
   IP or "localhost" then SOCKS4 (no host lookup) is used, otherwise
   SOCKS4a will be used. For SOCKS5 (proxy will do lookup and many other
   things) use "-proxy socks5://host:port". Note that the SSH builtin
   SOCKS proxy "ssh -D port" only does SOCKS4 or SOCKS5, so use socks5://
   for a ssh -D proxy.

   The proxying works for both SSL encrypted and normal reverse
   connections.

   An experimental mode is "-proxy http://host:port/..." where the URL
   (e.g. a CGI script) is retrieved via the GET method. See -proxy for
   more info.

   Another experimental mode is "-proxy ssh://user@host" in which case a
   SSH tunnel is used for the proxying. See -proxy for more info.

   Up to 3 proxies may be chained together by listing them by commas
   e.g.: "-proxy http://host1:port1,socks5://host2:port2" in case one
   needs to ricochet off of several machines to ultimately reach the
   listening viewer.


   Q-67: Can x11vnc provide a multi-user desktop web login service as an
   Apache CGI or PHP script?
   Yes. See the example script desktop.cgi for ideas. It is in the source
   tree in the directory x11vnc/misc. It serves x11vnc's SSL enabled Java
   Applet to the web browser with the correct connection information for
   the user's virtual desktop (an Xvfb session via -create; be sure to
   add the Xvfb package.) HTTPS/SSL enabled Apache should be used to
   serve the script to avoid unix and vnc passwords from being sent in
   cleartext and sniffed.

   By default it uses a separate VNC port for each user desktop (either
   by autoprobing in a range of ports or using a port based on the userid
   number.) The web server's firewall must allow incoming connections to
   these ports.

   It is somewhat difficult to do all of this with x11vnc listening on a
   single port, however there is also a 'fixed port' scheme described in
   the script based on -loopbg that works fairly well (but more
   experience is needed to see what problems contention for the same port
   causes; however at worst one user may need to re-login.)

   There is also an optional 'port redirection' mode for desktop.cgi that
   allows redirection to other machines inside the firewall already
   running SSL enabled VNC servers. This provides much of the
   functionality as the SSL Portal and is easier to set up.


   Q-68: Can I use x11vnc as a replacement for Xvnc? (i.e. not for a real
   display, but for a virtual one I keep around.)

   You can, but you would not be doing this for performance reasons (for
   virtual X sessions via VNC, Xvnc should give the fastest response.)
   You may want to do this because Xvnc is buggy and crashes, does not
   support an X server extension you desire, or you want to take
   advantage of one of x11vnc's unending number of options and features.

   One way to achieve this is to have a Xvfb(1) virtual framebuffer X
   server running in the background and have x11vnc attached to it.
   Another method, faster and more accurate, is to use the "dummy" Device
   Driver in XFree86/Xorg (see below.)

   For these virtual sessions you will need to install the Xvfb program
   (e.g. apt-get install xvfb) or our Xdummy program (see below.)

   In either case, one can view this desktop both remotely and also
   locally using vncviewer. Make sure vncviewer's "-encodings raw" is in
   effect for local viewing (compression seems to slow things down
   locally.) For local viewing you set up a "bare" window manager that
   just starts up vncviewer and nothing else (See how below.)

   Here is one way to start up Xvfb:
  xinit -- /usr/bin/Xvfb :1 -cc 4 -screen 0 1024x768x16

   This starts up a 16bpp virtual display. To export it via VNC use
  x11vnc -display :1 ...

   Then have the remote vncviewer attach to x11vnc's VNC display (e.g. :0
   which is port 5900.)

   The "-cc 4" Xvfb option is to force it to use a TrueColor visual
   instead of DirectColor (this works around a recent bug in the Xorg
   Xvfb server.)

   One good thing about Xvfb is that the virtual framebuffer exists in
   main memory (rather than in the video hardware), and so x11vnc can
   "screen scrape" it very efficiently (more than, say, 100X faster than
   normal video hardware.)

   Update Nov/2006: See the FINDCREATEDISPLAY discussion of the "-display
   WAIT:cmd=FINDDISPLAY" option where virtual (Xvfb or Xdummy, or even
   real ones by changing an option) X servers are started automatically
   for new users connecting. This provides a "desktop service" for the
   machine. You either get your real X session or your virtual
   (Xvfb/Xdummy) one whenever you connect to the machine (inetd(8) is a
   nice way to provide this service.) The -find, -create, -svc, and
   -xdmsvc aliases can also come in handy here.

   There are some annoyances WRT Xvfb however. The default keyboard
   mapping seems to be very poor. One should run x11vnc with -add_keysyms
   option to have keysyms added automatically. Also, to add the Shift_R
   and Control_R modifiers something like this is needed:
#!/bin/sh
xmodmap -e "keycode any = Shift_R"
xmodmap -e "add Shift = Shift_L Shift_R"
xmodmap -e "keycode any = Control_R"
xmodmap -e "add Control = Control_L Control_R"
xmodmap -e "keycode any = Alt_L"
xmodmap -e "keycode any = Alt_R"
xmodmap -e "keycode any = Meta_L"
xmodmap -e "add Mod1 = Alt_L Alt_R Meta_L"

   (note: these are applied automatically in the FINDCREATEDISPLAY mode
   of x11vnc.) Perhaps the Xvfb options -xkbdb or -xkbmap could be used
   to get a better default keyboard mapping...

   Dummy Driver:  A user points out a faster and more accurate method is
   to use the "dummy" Device Driver of XFree86/Xorg instead of Xvfb. He
   uses this to create a persistent and resizable desktop accessible from
   anywhere. In the Device Section of the config file set Driver "dummy".
   You may also need to set VideoRam NNN to be large enough to hold the
   framebuffer. The framebuffer is kept in main memory like Xvfb except
   that the server code is closely correlated with the real XFree86/Xorg
   Xserver unlike Xvfb.

   The main drawback to this method (besides requiring extra
   configuration and possibly root permission) is that it also does the
   Linux Virtual Console/Terminal (VC/VT) switching even though it does
   not need to (since it doesn't use a real framebuffer.) There are some
   "dual headed" (actually multi-headed/multi-user) patches to the X
   server that turn off the VT usage in the X server. Update: As of
   Jul/2005 we have an LD_PRELOAD script Xdummy that allows you to use a
   stock (i.e. unpatched) Xorg or XFree86 server with the "dummy" driver
   and not have any VT switching problems! An advantage of Xdummy over
   Xvfb is that Xdummy supports RANDR dynamic screen resizing.

   The standard way to start the "dummy" driver would be:
startx -- :1 -config /etc/X11/xorg.conf.dummy

   where the file /etc/X11/xorg.conf.dummy has its Device Section
   modified as described above. To use the LD_PRELOAD wrapper script:
startx -- /path/to/Xdummy :1

   An xdm(1) example is also provided.

   In general, one can use these sorts of schemes to use x11vnc to export
   other virtual X sessions, say Xnest or even Xvnc itself (useful for
   testing x11vnc.)

   Local access (VNC Server and VNC Viewer on the same machine): You use
   a VNC viewer to access the display remotely; to access your virtual X
   display locally (i.e. while sitting at the same machine it is running
   on) one can perhaps have something like this in their $HOME/.xinitrc
#!/bin/sh
x11vnc -display :5 -rfbport 5905 -bg
vncviewer -geometry +0+0 -encodings raw -passwd $HOME/.vnc/passwd localhost:5

   The display numbers (VNC and X) will likely be different (you could
   also try -find), and you may not need the -passwd. Recent RealVNC
   viewers might be this:
#!/bin/sh
x11vnc -display :5 -rfbport 5905 -bg
vncviewer -FullScreen -PreferredEncoding raw -passwd $HOME/.vnc/passwd localhos
t:5

   This way a bare X server is run with no window manager or desktop; it
   simply runs only the VNC Viewer on the real X server. The Viewer then
   draws the virtual X session on to the real one. On your system it
   might not be $HOME/.xinitrc, but rather .xsession, .Xclients, or
   something else. You will need to figure out what it is for your system
   and configuration.


   XDM/GDM/KDM One-Shot X sessions: For the general replacement of Xvnc
   by Xvfb+x11vnc, one user describes a similar setup he created where
   the X sessions are one-shot's (destroyed after the vncviewer
   disconnects) and it uses the XDM/GDM/KDM login greeter here.


   Q-69: How can I use x11vnc on "headless" machines? Why might I want
   to?

   An interesting application of x11vnc is to let it export displays of
   "headless" machines. For example, you may have some lab or server
   machines with no keyboard, mouse, or monitor, but each one still has a
   video card. One can use x11vnc to provide a simple "desktop service"
   from these server machines.

   An X server can be started on the headless machine (sometimes this
   requires configuring the X server to not fail if it cannot detect a
   keyboard or mouse, see the next paragraph.) Then you can export that X
   display via x11vnc (e.g. see this FAQ) and access it from anywhere on
   the network via a VNC viewer.

   Some tips on getting X servers to start on machines without keyboard
   or mouse: For XFree86/Xorg the Option "AllowMouseOpenFail" "true"
   "ServerFlags" config file option is useful. On Solaris Xsun the
   +nkeyboard and +nmouse options are useful (put them in the server
   command line args in /etc/dt/config/Xservers.) There are patches
   available for Xsun at lease back to Solaris 8 that support this. See
   Xserver(1) for more info.

   Although this usage may sound strange it can be quite useful for a GUI
   (or other) testing or QA setups: the engineers do not need to walk to
   lab machines running different hardware, OS's, versions, etc (or have
   many different machines in their office.) They just connect to the
   various test machines over the network via VNC. The advantage to
   testing this way instead of using Xvnc or even Xvfb is that the test
   is done using the real X server, fonts, video hardware, etc. that will
   be used in the field.

   One can imagine a single server machine crammed with as many video
   cards as it can hold to provide multiple simultaneous access or
   testing on different kinds of video hardware.

   See also the FINDCREATEDISPLAY discussion of the "-display
   WAIT:cmd=FINDDISPLAY" option where virtual Xvfb or Xdummy, or real X
   servers are started automatically for new users connecting. The -find,
   -create, -svc, and -xdmsvc aliases can also come in handy here.

   [Resource Usage and Performance]

   Q-70: I have lots of memory, but why does x11vnc fail with    shmget:
   No space left on device    or    Minor opcode of failed request: 1
   (X_ShmAttach)?

   It is not a matter of free memory, but rather free shared memory (shm)
   slots, also known as shm segments. This often occurs on a public
   Solaris machine using the default of only 100 slots. You (or the owner
   or root) can clean them out with ipcrm(1). x11vnc tries hard to
   release its slots, but it, and other programs, are not always able to
   (e.g. if kill -9'd.)

   Sometimes x11vnc will notice the problem with shm segments and tries
   to get by with fewer, only giving a warning like this:
  19/03/2004 10:10:58 shmat(tile_row) failed.
  shmat: Too many open files
  19/03/2004 10:10:58 error creating tile-row shm for len=4
  19/03/2004 10:10:58 reverting to single_copytile mode

   Here is a shell script shm_clear to list and prompt for removal of
   your unattached shm segments (attached ones are skipped.) I use it
   while debugging x11vnc (I use "shm_clear -y" to assume "yes" for each
   prompt.) If x11vnc is regularly not cleaning up its shm segments,
   please contact me so we can work to improve the situation.

   Longer term, on Solaris you can put something like this in
   /etc/system:
  set shmsys:shminfo_shmmax = 0x2000000
  set shmsys:shminfo_shmmni = 0x1000

   to sweep the problem under the rug (4096 slots.) On Linux, examine
   /proc/sys/kernel/shmmni; you can modify the value by writing to that
   file.

   Things are even more tight on Solaris 8 and earlier, there is a
   default maximum number of shm segments per process of 6. The error is
   the X server (not x11vnc) being unable to attach to the segments, and
   looks something like this:
  30/04/2004 14:04:26 Got connection from client 192.168.1.23
  30/04/2004 14:04:26   other clients:
  X Error of failed request:  BadAccess (attempt to access private resource den
ied)
     Major opcode of failed request:  131 (MIT-SHM)
     Minor opcode of failed request:  1 (X_ShmAttach)
     Serial number of failed request:  14
     Current serial number in output stream:  17

   This tight limit on Solaris 8 can be increased via:
  set shmsys:shminfo_shmseg = 100

   in /etc/system. See the next paragraph for more workarounds.

   To minimize the number of shm segments used by x11vnc try using the
   -onetile option (corresponds to only 3 shm segments used, and adding
   -fs 1.0 knocks it down to 2.) If you are having much trouble with shm
   segments, consider disabling shm completely via the -noshm option.
   Performance will be somewhat degraded but when done over local machine
   sockets it should be acceptable (see an earlier question discussing
   -noshm.)


   Q-71: How can I make x11vnc use less system resources?

   The -nap (now on by default; use -nonap to disable) and "-wait n"
   (where n is the sleep between polls in milliseconds, the default is 30
   or so) option are good places to start. In addition, something like
   "-sb 15" will cause x11vnc to go into a deep-sleep mode after 15
   seconds of no activity (instead of the default 60.)

   Reducing the X server bits per pixel depth (e.g. to 16bpp or even
   8bpp) will further decrease memory I/O and network I/O. The ShadowFB X
   server setting will make x11vnc's screen polling less severe. Using
   the -onetile option will use less memory and use fewer shared memory
   slots (add -fs 1.0 for one less slot.)


   Q-72: How can I make x11vnc use MORE system resources?

   You can try -threads (note this mode can be unstable and/or crash; and
   as of May/2008 is strongly discouraged, see the option description) or
   dial down the wait time (e.g. -wait 1) and possibly dial down -defer
   as well. Note that if you try to increase the "frame rate" too much
   you can bog down the server end with the extra work it needs to do
   compressing the framebuffer data, etc.

   That said, it is possible to "stream" video via x11vnc if the video
   window is small enough. E.g. a 256x192 xawtv TV capture window (using
   the x11vnc -id option) can be streamed over a LAN or wireless at a
   reasonable frame rate. If the graphics card's framebuffer read rate is
   faster than normal then the video window size and frame rate can be
   much higher. The use of TurboVNC and/or TurboJPEG can make the frame
   rate somewhat higher still (but most of this hinges on the graphics
   card's read rate.)


   Q-73: I use x11vnc over a slow link with high latency (e.g. dialup
   modem or broadband), is there anything I can do to speed things up?

   Some things you might want to experiment with (many of which will help
   performance on faster links as well):

     X server/session parameters:
     * Configure the X server bits per pixel to be 16bpp or even 8bpp.
       (reduces amount of data needed to be polled, compressed, and sent)
     * Use a smaller desktop size (e.g. 1024x768 instead of 1280x1024)
     * Make sure the desktop background is a solid color (the background
       is resent every time it is re-exposed.) Consider using the -solid
       [color] option to try to do this automatically.
     * Configure your window manager or desktop "theme" to not use fancy
       images, shading, and gradients for the window decorations, etc.
       Disable window animations, etc. Maybe your desktop has a "low
       bandwidth" theme you can easily switch into and out of. Also in
       Firefox disable eye-candy, e.g.: Edit -> Preferences -> Advanced
       -> Use Smooth Scrolling (deselect it.)
     * Avoid small scrolls of large windows using the Arrow keys or
       scrollbar. Try to use PageUp/PageDown instead. (not so much of a
       problem in x11vnc 0.7.2 if -scrollcopyrect is active and detecting
       scrolls for the application.)
     * If the -wireframe option is not available (earlier than x11vnc
       0.7.2 or you have disabled it via -nowireframe) then Disable
       Opaque Moves and Resizes in the window manager/desktop.
     * However if -wireframe is active (on by default in x11vnc 0.7.2)
       then you should Enable Opaque Moves and Resizes in the window
       manager! This seems counter-intuitive, but because x11vnc detects
       the move/resize events early there is a huge speedup over a slow
       link when Opaque Moves and Resizes are enabled. (e.g. CopyRect
       encoding will be used.)
     * Turn off Anti-aliased fonts on your system, web browser, terminal
       windows, etc. AA fonts do not compress as well as traditional
       fonts (sometimes 10X less.)
     * On Firefox/Mozilla (and anything else) turn off "Smooth Scroll"
       animations. In Firefox put in the URL "about:config" and set
       general.smoothScroll to false.
     * On Xorg/XFree86 turn on the Shadow Framebuffer to speed up
       reading. (Option "ShadowFB" "true" in the Device section of
       /etc/X11/XF86Config) This disables 2D acceleration on the physical
       display and so may not be worth it (if you play games, etc), but
       could be of use in some situations. Note: If the network link is
       very slow, this speedup may not be noticed.

     VNC viewer parameters:
     * Use a TightVNC enabled viewer! (Actually, RealVNC 4.x viewer with
       ZRLE encoding is not too bad either; some claim it is faster.)
     * Make sure the tight (or zrle) encoding is being used (look at
       vncviewer and x11vnc outputs)
     * Request 8 bits per pixel using -bgr233 (up to 4X speedup over
       depth 24 TrueColor (32bpp), but colors will be off)
     * RealVNC 4.x viewer has some extremely low color modes (only 64 and
       even 8 colors.) SSVNC does too. The colors are poor, but it is
       usually noticeably faster than bgr233 (256 colors.)
     * Try increasing the TightVNC -compresslevel (compresses more on
       server side before sending, but uses more CPU)
     * Try reducing the TightVNC -quality (increases JPEG compression,
       but is lossy with painting artifacts)
     * Try other VNC encodings via -encodings (tight may be the fastest,
       but you should compare it to zrle and maybe some of the others)
     * On the machine where vncviewer is run, make sure Backing Store is
       enabled (Xorg/XFree86 disables it by default causing re-exposures
       of vncviewer to be very slow) Option "backingstore" in config
       file.

     x11vnc parameters:
     * Make sure the -wireframe option is active (it should be on by
       default) and you have Opaque Moves/Resizes Enabled in the window
       manager.
     * Make sure the -scrollcopyrect option is active (it should be on by
       default.) This detects scrolls in many (but not all) applications
       an applies the CopyRect encoding for a big speedup.
     * Enforce a solid background when VNC viewers are connected via
       -solid
     * Try x11vnc's client-side caching client-side caching scheme:
       -ncache
     * Specify -speeds modem to force the wireframe and scrollcopyrect
       heuristic parameters (and any future ones) to those of a dialup
       modem connection (or supply the rd,bw,lat numerical values that
       characterize your link.)
     * If wireframe and scrollcopyrect aren't working, try using the more
       drastic -nodragging (no screen updates when dragging mouse, but
       sometimes you miss visual feedback)
     * Set -fs 1.0 (disables fullscreen updates)
     * Try increasing -wait or -defer (reduces the maximum "frame rate",
       but won't help much for large screen changes)
     * Try the -progressive pixelheight mode with the block pixelheight
       100 or so (delays sending vertical blocks since they may change
       while viewer is receiving earlier ones)
     * If you just want to watch one (simple) window use -id or -appshare
       (cuts down extraneous polling and updates, but can be buggy or
       insufficient)
     * Set -nosel (disables all clipboard selection exchange)
     * Use -nocursor and -nocursorpos (repainting the remote cursor
       position and shape takes resources and round trips)
     * On very slow links (e.g. <= 28.8) you may need to increase the
       -readtimeout n setting if it sometimes takes more than 20sec to
       paint the full screen, etc.
     * Do not use -fixscreen to automatically refresh the whole screen,
       tap three Alt_L's then the screen has painting errors (rare
       problem.)


   Example for the KDE desktop:

   Launch the "KDE Control Center" utility. Sometimes this is called
   "Personal Settings".

   Select "Desktop".

    Then Select "Window Behavior". In the "Moving" Tab set these:
     * YES - Display content in moving windows
     * YES - Display content in resizing windows
     * NO   - Display window geometry when moving or resizing
     * NO   - Animate minimize and restore

    In the "Translucency" Tab set:
     * NO   - Use translucency/shadows

   Next hit "Back" and then select "Panels".

    In the "Appearance" Tab set:
     * NO   - Enable icon mouseover effects
     * NO   - Enable transparency

   Now go all the way back up to the top and Select "Appearance &
   Themes".

    Select "Background" and set:
     * YES - No picture
     * Colors: Single Color

    Select "Fonts" and disable anti-aliased fonts if you are bold enough.

    Select "Launch Feedback" and set:
     * Busy Cursor: No Busy Cursor
     * NO   - Enable taskbar notification

    Select "Screen Saver" and set:
     * Screen Saver: Blank Screen

    Select "Style" and in the "Effects" Tab set:
     * NO   - Enable GUI effects


   Example for the GNOME desktop:
     * TBD.


   Q-74: Does x11vnc support the X DAMAGE Xserver extension to find
   modified regions of the screen quickly and efficiently?

   Yes, as of Mar/2005 x11vnc will use the X DAMAGE extension by default
   if it is available on the display. This requires libXdamage to be
   available in the build environment as well (recent Linux distros and
   Solaris 10 have it.)

   The DAMAGE extension enables the X server to report changed regions of
   the screen back to x11vnc. So x11vnc doesn't have to guess where the
   changes are (by polling every pixel of the entire screen every 2-4
   seconds.) The use of X DAMAGE dramatically reduces the load when the
   screen is not changing very much (i.e. most of the time.) It also
   noticeably improves updates, especially for very small changed areas
   (e.g. clock ticking, cursor flashing, typing, etc.)

   Note that the DAMAGE extension does not speed up the actual reading of
   pixels from the video card framebuffer memory, by, say, mirroring them
   in main memory. So reading the fb is still painfully slow (e.g.
   5MB/sec), and so even using X DAMAGE when large changes occur on the
   screen the bulk of the time is still spent retrieving them. Not ideal,
   but use of the ShadowFB XFree86/Xorg option speeds up the reading
   considerably (at the cost of h/w acceleration.)

   Unfortunately the current Xorg DAMAGE extension implementation can at
   times be overly conservative and report very large rectangles as
   "damaged" even though only a small portion of the pixels have actually
   been modified. This behavior is often the fault of the window manager
   (e.g. it redraws the entire, unseen, frame window underneath the
   application window when it gains focus), or the application itself
   (e.g. does large, unnecessary repaints.)

   To work around this deficiency, x11vnc currently only trusts small
   DAMAGE rectangles to contain real damage. The larger rectangles are
   only used as hints to focus the traditional scanline polling (i.e. if
   a scanline doesn't intersect a recent DAMAGE rectangle, the scan is
   skipped.) You can use the "-xd_area A" option to adjust the size of
   the trusted DAMAGE rectangles. The default is 20000 pixels (e.g. a
   140x140 square, etc.) Use "-xd_area 0" to disable the cutoff and trust
   all DAMAGE rectangles.

   The option "-xd_mem f" may also be of use in tuning the algorithm. To
   disable using DAMAGE entirely use "-noxdamage".


   Q-75: My OpenGL application shows no screen updates unless I supply
   the -noxdamage option to x11vnc.
   One user reports in his environment (MythTV using the NVIDIA OpenGL
   drivers) he gets no updates after the initial screen is drawn unless
   he uses the "-noxdamage" option.

   This seems to be a bug in the X DAMAGE implementation of that driver.
   You may have to use -noxdamage as well. A way to autodetect this will
   be tried, probably the best it will do is automatically stop using X
   DAMAGE.

   A developer for MiniMyth reports that the 'alphapulse' tag of the
   theme G.A.N.T. can also cause problems, and should be avoided when
   using VNC.

   Update: see this FAQ too.


   Q-76: When I drag windows around with the mouse or scroll up and down
   things really bog down (unless I do the drag in a single, quick
   motion.) Is there anything to do to improve things?

   This problem is primarily due to slow hardware read rates from video
   cards: as you scroll or move a large window around the screen changes
   are much too rapid for x11vnc to keep up them (it can usually only
   read the video card at about 5-10 MB/sec, so it can take a good
   fraction of a second to read the changes induce from moving a large
   window, if this to be done a number of times in succession the window
   or scroll appears to "lurch" forward.) See the description in the
   -pointer_mode option for more info. The next bottleneck is compressing
   all of these changes and sending them out to connected viewers,
   however the VNC protocol is pretty much self-adapting with respect to
   that (updates are only packaged and sent when viewers ask for them.)

   As of Jan/2004 there are some improvements to libvncserver. The
   default should now be much better than before and dragging small
   windows around should no longer be a huge pain. If for some reason
   these changes make matters worse, you can go back to the old way via
   the "-pointer_mode 1" option.

   Also added was the -nodragging option that disables all screen updates
   while dragging with the mouse (i.e. mouse motion with a button held
   down.) This gives the snappiest response, but might be undesired in
   some circumstances when you want to see the visual feedback while
   dragging (e.g. menu traversal or text selection.)

   As of Dec/2004 the -pointer_mode n option was introduced. n=1 is the
   original mode, n=2 an improvement, etc.. See the -pointer_mode n help
   for more info.

   Also, in some circumstances the -threads option can improve response
   considerably. Be forewarned that if more than one vncviewer is
   connected at the same time then libvncserver may not be thread safe
   (try to get the viewers to use different VNC encodings, e.g. tight and
   ZRLE.) This option can be unstable and so as of Feb/2008 it is
   disabled by default. Set env. X11VNC_THREADED=1 to re-enable.

   As of Apr/2005 two new options (see the wireframe FAQ and
   scrollcopyrect FAQ below) provide schemes to sweep this problem under
   the rug for window moves or resizes and for some (but not all) window
   scrolls. These are the preferred way of avoiding the "lurching"
   problem, contact me if they are not working. Note on SuSE and some
   other distros the RECORD X extension used by scrollcopyrect is not
   enabled by default, turn it on in xorg.conf:
Section "Module"
        ...
        Load  "record"
        ...
EndSection


   Q-77: Why not do something like wireframe animations to avoid the
   windows "lurching" when being moved or resized?

   Nice idea for a hack! As of Apr/2005 x11vnc by default will apply
   heuristics to try to guess if a window is being (opaquely) moved or
   resized. If such a change is detected framebuffer polling and updates
   will be suspended and only an animated "wireframe" (a rectangle
   outline drawn where the moved/resized window would be) is shown. When
   the window move/resize stops, it returns to normal processing: you
   should only see the window appear in the new position. This spares you
   from interacting with a "lurching" window between all of the
   intermediate steps. BTW the lurching is due to slow video card read
   rates (see here too.) A displacement, even a small one, of a large
   window requires a non-negligible amount of time, a good fraction of a
   second, to read in from the hardware framebuffer.

   Note that Opaque Moves/Resizes must be Enabled by your window manager
   for -wireframe to do any good.

   The mode is currently on by default because most people are afflicted
   with the problem. It can be disabled with the -nowireframe option (aka
   -nowf.) Why might one want to turn off the wireframing? Since x11vnc
   is merely guessing when windows are being moved/resized, it may guess
   poorly for your window-manager or desktop, or even for the way you
   move the pointer. If your window-manager or desktop already does its
   own wireframing then this mode is a waste of time and could do the
   wrong thing occasionally. There may be other reasons the new mode
   feels unnatural. If you have very expensive video hardware (SGI, well
   now even proprietary Xorg drivers are fast at reading) or are using an
   in-RAM video framebuffer (SunRay, ShadowFB, Xvfb), the read rate from
   that framebuffer may be very fast (100's of MB/sec) and so you don't
   really see much lurching (at least over a fast LAN): opaque moves look
   smooth in x11vnc. Note: ShadowFB is often turned on when you are using
   the vesafb or fbdev XFree86 video driver instead of a native one so
   you might be using it already and not know.

   The heuristics used to guess window motion or resizing are simple, but
   are not fool proof: x11vnc is sometimes tricked and so you'll
   occasionally see the lurching opaque move and rarely something even
   worse.

   First it assumes that the move/resize will occur with a mouse button
   pressed, held down and dragged (of course this is only mostly true.)
   Next it will only consider a window for wireframing if the mouse
   pointer is initially "close enough" to the edges of the window frame,
   e.g. you have grabbed the title bar or a resizer edge (this
   requirement can be disabled and it also not applied if a modifier key,
   e.g. Alt, is pressed.) If these are true, it will wait an amount of
   time to see if the window starts moving or resizing. If it does, it
   starts drawing the wireframe "outline" of where the window would be.
   When the mouse button is released, or a timeout occurs, it goes back
   to the standard mode to allow the actual framebuffer changes to
   propagate to the viewers.

   These parameters can be tweaked:
     * Color/Shade of the wireframe.
     * Linewidth of the outline frame.
     * Cutoff size of windows to not apply wireframing to.
     * Cutoffs for closeness to Top, Bottom, Left, and Right edges of
       window.
     * Modifier keys to enable interior window grabbing.
     * Maximum time to wait for dragging pointer events.
     * Maximum time to wait for the window to start moving/resizing.
     * Maximum time to show a wireframe animation.
     * Minimum time between sending wireframe outlines.

   See the "-wireframe tweaks" option for more details. On a slow link,
   e.g. dialup modem, the parameters may be automatically adjusted for
   better response.


   CopyRect encoding:  In addition to the above there is the
   "-wirecopyrect mode" option. It is also on by default. This instructs
   x11vnc to not only show the wireframe animation, but to also instruct
   all connected VNC viewers to locally translate the window image data
   from the original position to the new position on the screen when the
   animation is done. This speedup is the VNC CopyRect encoding: the
   framebuffer update doesn't need to send the actual new image data.
   This is nice in general, and very convenient over a slow link, but
   since it is based on heuristics you may need to disable it with the
   -nowirecopyrect option (aka -nowcr) if it works incorrectly or
   unnaturally for you.

   The -wirecopyrect modes are: "never" (same as -nowirecopyrect); "top",
   only apply the CopyRect if the window is appears to be on the top of
   the window stack and is not obstructed by other windows; and "always"
   to always try to apply the CopyRect (obstructed regions are usually
   clipped off and not translated.)

   Note that some desktops (KDE and xfce) appear to mess with the window
   stacking in ways that are not yet clear. In these cases x11vnc works
   around the problem by applying the CopyRect even if obscuring windows'
   data is translated! Use -nowirecopyrect if this yields undesirable
   effects for your desktop.

   Also, the CopyRect encoding may give incorrect results under -scale
   (depending on the scale factor the CopyRect operation is often only
   approximate: the correctly scaled framebuffer will be slightly
   different from the translated one.) x11vnc will try to push a
   "cleanup" update after the CopyRect if -scale is in effect. Use
   -nowirecopyrect if this or other painting errors are unacceptable.


   Q-78: Can x11vnc try to apply heuristics to detect when a window is
   scrolling its contents and use the CopyRect encoding for a speedup?

   Another nice idea for a hack! As of May/2005 x11vnc will by default
   apply heuristics to try to detect if the window that has the input
   focus is scrolling its contents (but only when x11vnc is feeding user
   input, keystroke or pointer, to the X server.) So, when detected,
   scrolls induced by dragging on a scrollbar or by typing (e.g. Up or
   Down arrows, hitting Return in a terminal window, etc), will show up
   much more quickly than via the standard x11vnc screen polling update
   mechanism.

   There will be a speedup for both slow and fast links to viewers. For
   slow links the speedup is mostly due to the CopyRect encoding not
   requiring the image data to be transmitted over the network. For fast
   links the speedup is primarily due to x11vnc not having to read the
   scrolled framebuffer data from the X server (recall that reading from
   the hardware framebuffer is slow.)

   To do this x11vnc uses the RECORD X extension to snoop the X11
   protocol between the X client with the focus window and the X server.
   This extension is usually present on most X servers (but SuSE disables
   it for some reason.) On XFree86/Xorg it can be enabled via Load
   "record" in the Module section of the config file if it isn't already:
Section "Module"
        ...
        Load  "record"
        ...
EndSection

   Currently the RECORD extension is used as little as possible so as to
   not slow down regular use. Only simple heuristics are applied to
   detect XCopyArea and XConfigureWindow calls from the application.
   These catch a lot of scrolls, e.g. in mozilla/firefox and in terminal
   windows like gnome-terminal and xterm. Unfortunately the toolkits KDE
   applications use make scroll detection less effective (only rarely are
   they detected: i.e. Konqueror and Konsole don't work.) An interesting
   project, that may be the direction x11vnc takes, is to record all of
   the X11 protocol from all clients and try to "tee" the stream into a
   modified Xvfb watching for CopyRect and other VNC speedups. A
   potential issue is the RECORD stream is delayed from actual view on
   the X server display: if one falls too far behind it could become a
   mess...

   The initial implementation of -scrollcopyrect option is useful in that
   it detects many scrolls and thus gives a much nicer working
   environment (especially when combined with the -wireframe
   -wirecopyrect options, which are also on by default; and if you are
   willing to enable the ShadowFB things are very fast.) The fact that
   there aren't long delays or lurches during scrolling is the primary
   improvement.

   But there are some drawbacks:
     * Not all scrolls are detected. Some apps scroll windows in ways
       that cannot currently be detected, and other times x11vnc "misses"
       the scroll due to timeouts, etc. Sometimes it is more distracting
       that a speedup occasionally doesn't work as opposed to being
       consistently slow!
     * For rapid scrolling (i.e. sequence of many scrolls over a short
       period) there can be painting errors (tearing, bunching up, etc.)
       during the scroll. These will repair themselves after the scroll
       is over, but when they are severe it can be distracting. Try to
       think of the approximate window contents as a quicker and more
       useful "animation" compared to the slower polling scheme...
     * Scrolling inside shells in terminal windows (gnome-terminal,
       xterm), can lead to odd painting errors. This is because x11vnc
       did not have time to detect a screen change just before the scroll
       (most common is the terminal undraws the block cursor before
       scrolling the text up: in the viewer you temporarily see multiple
       block cursors.) Another issue is with things like more(1): scroll
       detection for 5-6 lines happens nicely, but then it can't keep up
       and so there is a long pause for the standard polling method to
       deliver the remaining updates.
     * More rarely sometimes painting errors are not repaired after the
       scroll is over. This may be a bug in x11vnc or libvncserver, or it
       may be an inescapable fact of the CopyRect encoding and the delay
       between RECORD callbacks and what is actually on the X display.
       One can tap the Alt_L key (Left "Alt" key) 3 times in a row to
       signal x11vnc to refresh the screen to all viewers. Your
       VNC-viewer may have its own screen refresh hot-key or button. See
       also: -fixscreen
     * Some applications, notably OpenOffice, do XCopyArea scrolls in
       weird ways that assume ancestor window clipping is taking place.
       See the -scr_skip option for ways to tweak this on a
       per-application basis.
     * Selecting text while dragging the mouse may be slower, especially
       if the Button-down event happens near the window's edge. This is
       because the scrollcopyrect scheme is watching for scrolls via
       RECORD and has to wait for a timeout to occur before it does the
       update.
     * For reasons not yet understood the RECORD extension can stop
       responding (and hence scrolls are missed.) As a workaround x11vnc
       attempts to reset the RECORD connection every 60 seconds or so.
       Another workaround is to type 4 Super_L (Left Super/Windows-Flag
       key) in a row to reset RECORD. Work is in progress to try to fix
       this bug.
     * Sometimes you need to "retrain" x11vnc for a certain window
       because it fails to detect scrolls in it. Sometimes clicking
       inside the application window or selecting some text in it to
       force the focus helps.
     * When using the -scale option there will be a quick CopyRect
       scroll, but it needs to be followed by a slower "cleanup" update.
       This is because for a fixed finite screen resolution (e.g. 75 dpi)
       scaling and copyrect-ing are not exactly independent. Scaling
       involves a blending of nearby pixels and if you translate a pixel
       the neighbor pixel weighting may be different. So you have to wait
       a bit for the cleanup update to finish. On slow links x11vnc may
       automatically decide to not detect scrolls when -scale is in
       effect. In general it will also try to defer the cleanup update if
       possible.

   If you find the -scrollcopyrect behavior too approximate or
   distracting you can go back to the standard polling-only update method
   with the -noscrollcopyrect (or -noscr for short.) If you find some
   extremely bad and repeatable behavior for -scrollcopyrect please
   report a bug.

   Alternatively, as with -wireframe, there are many tuning parameters to
   try to improve the situation. You can also access these parameters
   inside the gui under "Tuning". These parameters can be tweaked:
     * The minimum pixel area of a rectangle to be watched for scrolls.
     * A list if application names to skip scroll detection.
     * Which keystrokes should trigger scroll detection.
     * Which applications should have a "terminal" tweak applied to them.
     * When repeating keys (e.g. Up arrow) should be discarded to
       preserve a scroll.
     * Cutoffs for closeness to Top, Bottom, Left, and Right edges of
       window for mouse induced scrolls.
     * Set timeout parameters for keystroke induced scrolls.
     * Set timeout parameters for mouse pointer induced scrolls.
     * Have the full screen be periodically refreshed to fix painting
       errors.


   Q-79: Can x11vnc do client-side caching of pixel data? I.e. so when
   that pixel data is needed again it does not have to be retransmitted
   over the network.

   As of Dec/2006 in the 0.9 development tarball there is an experimental
   client-side caching implementation enabled by the "-ncache n" option.
   In fact, during the test period it was on by default with n set to 10.
   To disable it use "-noncache".

   It is a simple scheme where a (very large) lower portion of the
   framebuffer (i.e. starting just below the user's actual desktop
   display) is used for storing pixel data. CopyRect; a fast, essentially
   local viewer-side VNC encoding; is used to swap the pixel data in and
   out of the actual display area. It gives an excellent speedup for
   iconifying/deiconifying and moving windows and re-posting of menus
   (often it doesn't feel like VNC at all: there is no delay waiting for
   the pixel data to fill in.)

   This scheme is nice because it does all of this within the existing
   VNC protocol, and so it works with all VNC viewers.

   A challenge to doing more sophisticated (e.g. compressed and/or
   shared) client-side caching is that one needs to extend the VNC
   protocol, modify a viewer and then also convince users to adopt your
   modified VNC Viewer (or get the new features to be folded into the
   main VNC viewers, patches accepted, etc... likely takes many years
   before they might be deployed in the field.) So it is convenient that
   the "-ncache n" works with any unaltered VNC viewer.

   A drawback of the "-ncache n" method is that in the VNC Viewer you can
   scroll down and actually see the cached pixel data. So it looks like
   there is a bug: you can scroll down in your viewer and see a strange
   "history" of windows on your desktop. This is working as intended. One
   will need to try to adjust the size of his VNC Viewer window so the
   cache area cannot be seen. SSVNC (see below) can do this
   automatically.

   At some point LibVNCServer may implement a "rfbFBCrop" pseudoencoding
   that viewers can use to learn which portion of the framebuffer to
   actually show to the users (with the hidden part used for caching, or
   perhaps something else, maybe double buffering or other offscreen
   rendering...)

   The Enhanced TightVNC Viewer (SSVNC) Unix viewer has a nice -ycrop
   option to help hide the pixel cache area from view. It will turn on
   automatically if the framebuffer appears to be very tall (height more
   than twice the width), or you can supply the actual value for the
   height. If the screen is resized by scaling, etc, the ycrop value is
   scaled as well. In fullscreen mode you cannot scroll past the end of
   the actual screen, and in non-fullscreen mode the window manager frame
   is adjusted to fit the actual display (so you don't see the pixel
   cache region) and the scrollbars are very thin to avoid distraction
   and trouble fitting inside your display. Use the "-sbwidth n" viewer
   option to make the scrollbars thicker if you like.

   Another drawback of the scheme is that it is VERY memory intensive,
   the n in "-ncache n" is the factor of increase over the base
   framebuffer size to use for caching. It is an even integer and should
   be fairly large, 6-12, to achieve good response. This usually requires
   about 50-100MB of additional RAM on both the client and server sides.
   For example with n=6 a 1280x1024 display will use a framebuffer that
   is 1280x7168: everything below row 1024 is the pixel buffer cache. If
   you are running on low memory machines or memory is tight because of
   other running applications you should not use -ncache.

   The reason for so much memory is because the pixel data is not
   compressed and so the whole window to be saved must be stored
   "offscreen". E.g. for a large web browser window this can be nearly 1
   million pixels, and that is only for a single window! One typically
   wants to cycle between 5-10 large active windows. Also because both
   backing-store (the window's actual contents) and save-unders (the
   pixels covered up by the window) are cached offscreen that introduces
   an additional factor of 2 in memory use.

   However, even in the smallest usage mode with n equal 2 and
   -ncache_no_rootpixmap set (this requires only 2X additional
   framebuffer memory) there is still a noticable improvement for many
   activities, although it is not as dramatic as with, say n equal 12 and
   rootpixmap (desktop background) caching enabled.

   The large memory consumption of the current implementation can be
   thought of as a tradeoff to providing caching and being compatible
   with all VNC viewers and also ease of implementing. Hopefully it can
   be tuned to use less, or the VNC community will extend the protocol to
   allow caching and replaying of compressed blobs of data.

   Another option to experiment with is "-ncache_cr". By specifying it,
   x11vnc will try to do smooth opaque window moves instead of its
   wireframe. This can give a very nice effect (note: on Unix the realvnc
   viewer seems to be smoother than the tightvnc viewer), but can lead to
   some painting problems, and can be jerky in some circumstances.

   Surprisingly, for very slow connections, e.g. modem, the -ncache_cr
   option can actually improve window drags. This is probably because no
   pixel data (only CopyRect instructions) are sent when dragging a
   window. Normally, the wireframe must be sent and this involves
   compressing and sending the lines that give rise to the moving box
   effect (note that real framebuffer data is sent to "erase" the white
   lines of the box.)

   If you experience painting errors you can can tap the Alt_L key (Left
   "Alt" key) 3 times in a row to signal x11vnc to refresh the screen to
   all viewers. You may also need to iconify and then deiconify any
   damaged windows to correct their cache data as well. Note that if you
   change color viewer depth (e.g. 8bpp to full color) dynamically that
   will usually lead to the entire extended framebuffer being resent
   which can take a long time over very slow links: it may be better to
   reconnect and reset the format right after doing so. x11vnc will try
   to detect the format change and clear (make completely black) the
   cache region.

   Gotcha for older Unix VNC Viewers: The older Unix VNC viewers (e.g.
   current TightVNC Unix Viewer) require X server backingstore to keep
   off-viewer screen data local. If the viewer-side X server has
   backingstore disabled (sadly, currently the default on Linux, etc),
   then to get the offscreen pixels the viewer has to ask for a refresh
   over the network, thereby defeating the caching. Use something like
   this in your viewer-side /etc/X11/xorg.conf file (or otherwise get
   your viewer-side system to do it)
Section "Device"
        ...
        Option  "backingstore"
        ...
EndSection

   No problems like this have been observed with Windows VNC Viewers:
   they all seem to keep their entire framebuffer in local memory.

   Gotcha for KDE krdc VNC Viewer: One user found that KDE's krdc viewer
   has some sort of hardwired limit on the maximum size of the
   framebuffer (64MB?). It fails quickly saying "The connection to the
   host has been interrupted." The workaround for his 1280x1024
   x11vnc-side display was to run with "-ncache 10", i.e. a smaller value
   to be under the krdc threshold.

   Although this scheme is not as quick (nor as compressed) as
   nx/nomachine, say, it does provide a good step in the direction of
   improving VNC performance by client side caching.


   Q-80: Does x11vnc support TurboVNC?

   As of Feb/2009 (development tarball) there is an experimental kludge
   to let you build x11vnc using TurboVNC's modified TightVNC encoding.
   TurboVNC is part of the VirtualGL project. It does two main things to
   speed up the TightVNC encoding:
     * It eliminates bottlenecks, overheads, wait-times in the TightVNC
       encoding implementation and instead only worries about sending
       very well (and quickly) compressed JPEG data.
     * A fast proprietary JPEG implemention is used (Intel IPP on x86)
       instead of the usual libjpeg implementation. TurboJPEG is an
       interface library, libturbojpeg, provided by the project that
       achieves this.

   TurboVNC works very well over LAN and evidently fast Broadband too.
   When using it with x11vnc in such a situation you may want to dial
   down the delays, e.g. "-wait 5" and "-defer 5" (or even a smaller
   setting) to poll and pump things out more quickly.

   See the instructions in "x11vnc/misc/turbovnc/README" for how to build
   x11vnc with TurboVNC support. You will also need to download the
   TurboJPEG software.

   In brief, the steps look like this:
  cd x11vnc-x.y.z/x11vnc/misc/turbovnc
  ./apply_turbovnc
  cd ../../..
  env LDFLAGS='-L/DIR -Xlinker --rpath=/DIR' ./configure
  make AM_LDFLAGS='-lturbojpeg'

   where you replace "/DIR" with the directory containing libturbojpeg.so
   you downloaded separately. If it works out well enough TurboVNC
   support will be integrated into x11vnc and more of its tuning features
   will be implemented. Support for TurboVNC in SSVNC viewer has been
   added as an experiment as well. If you try either one, let us know how
   it went.

   There also may be some Linux.i686 and Darwin.i386 x11vnc binaries with
   TurboVNC support in the misc. bins directory. For other platforms you
   will need to compile yourself.

   On relatively cheap and old hardware (Althon64 X2 5000+ / GeForce
   6200) x11vnc and SSVNC, both TurboVNC enabled, were able to sustain
   13.5 frames/sec (fps) and 15 Megapixels/sec using the VirtualGL
   supplied OpenGL benchmark program glxspheres. VirtualGL on higher-end
   hardware can sustain 20-30 fps with the glxspheres benchmark.

   Potential Slowdown: As we describe elsewhere, unless you use x11vnc
   with an X server using, say, NVidia proprietary drivers (or a virtual
   X server like Xvfb or Xdummy, or in ShadowFB mode), then the read rate
   from the graphics card can be rather slow (e.g. 10 MB/sec) and becomes
   the bottleneck when using x11vnc over fast networks. Note that all of
   Xorg's drivers currently (2009) have slow read rates (only proprietary
   drivers appear to have optimized reads.)

   So under these (more or less typical) conditions, the speed
   improvement provided by TurboVNC may only be marginal. Look for this
   output to see your read rate:
  28/02/2009 11:11:07 Autoprobing TCP port
  28/02/2009 11:11:07 Autoprobing selected port 5900
  28/02/2009 11:11:08 fb read rate: 10 MB/sec
  28/02/2009 11:11:08 screen setup finished.

   A rate of 10 MB/sec means a 1280x1024x24 screen takes 0.5 seconds to
   read in. TurboVNC compresses that to JPEG in a much shorter time. On
   the other hand, an NVidia driver may have a read rate of 250 MB/sec
   and so only takes 0.02 seconds to read the entire screen in.



   [Mouse Cursor Shapes]

   Q-81: Why isn't the mouse cursor shape (the little icon shape where
   the mouse pointer is) correct as I move from window to window?

   On X servers supporting XFIXES or Solaris/IRIX Overlay extensions it
   is possible for x11vnc to do this correctly. See a few paragraphs down
   for the answer.

   Historically, the X11 mouse cursor shape (i.e. little picture: an
   arrow, X, I-beam, resizer, etc) is one of the few WRITE-only objects
   in X11. That is, an application can tell the X server what the cursor
   shape should be when the pointer is in a given window, but a program
   (like x11vnc) unfortunately cannot read this information. I believe
   this is because the cursor shape is often downloaded to the graphics
   hardware (video card), but I could be mistaken.

   A simple kludge is provided by the "-cursor X" option that changes the
   cursor when the mouse is on the root background (or any window has the
   same cursor as the root background.) Note that desktops like GNOME or
   KDE often cover up the root background, so this won't work for those
   cases. Also see the "-cursor some" option for additional kludges.

   Note that as of Aug/2004 on Solaris using the SUN_OVL overlay
   extension and IRIX, x11vnc can show the correct mouse cursor when the
   -overlay option is supplied. See this FAQ for more info.

   Also as of Dec/2004 XFIXES X extension support has been added to allow
   exact extraction of the mouse cursor shape. XFIXES fixes the problem
   of the cursor-shape being write-only: x11vnc can now query the X
   server for the current shape and send it back to the connected
   viewers. XFIXES is available on recent Linux Xorg based distros and
   Solaris 10.

   The only XFIXES issue is the handling of alpha channel transparency in
   cursors. If a cursor has any translucency then in general it must be
   approximated to opaque RGB values for use in VNC. There are some
   situations where the cursor transparency can also handled exactly:
   when the VNC Viewer requires the cursor shape be drawn into the VNC
   framebuffer or if you apply a patch to your VNC Viewer to extract
   hidden alpha channel data under 32bpp. Details can be found here.


   Q-82: When using XFIXES cursorshape mode, some of the cursors look
   really bad with extra black borders around the cursor and other cruft.
   How can I improve their appearance?

   This happens for cursors with transparency ("alpha channel"); regular
   X cursors (bitmaps) should be correct. Unfortunately x11vnc 0.7 was
   released with a very poor algorithm for approximating the
   transparency, which led to the ugly black borders.

   The problem is as follows: XFIXES allows x11vnc to retrieve the
   current X server cursor shape, including the alpha channel for
   transparency. For traditional bitmap cursors the alpha value will be 0
   for completely transparent pixels and 255 for completely opaque
   pixels; whereas for modern, eye-candy cursors an alpha value between 0
   and 255 means to blend in the background colors to that degree with
   the cursor colors. The pixel color blending formula is something like
   this: Red = Red_cursor * a + Red_background * (1 - a), (where here 0
   =< a =< 1), with similar for Green and Blue. The VNC protocol does not
   currently support an alpha channel in cursors: it only supports
   regular X bitmap cursors and Rich Cursors that have RGB (Red, Green,
   Blue) color data, but no "A" = alpha data. So in general x11vnc has to
   approximate a cursor with transparency to create a Rich Cursor. This
   is easier said than done: some cursor themes have cursors with
   complicated drop shadows and other forms of translucency.

   Anyway, for the x11vnc 0.7.1 release the algorithm for approximating
   transparency is much improved and hopefully gives decent cursor shapes
   for most cursor themes and you don't have to worry about it.

   In case it still looks bad for your cursor theme, there are (of
   course!) some tunable parameters. The "-alphacut n" option lets you
   set the threshold "n" (between 0 and 255): cursor pixels with alpha
   values below n will be considered completely transparent while values
   equal to or above n will be completely opaque. The default is 240. The
   "-alphafrac f" option tries to correct individual cursors that did not
   fare well with the default -alphacut value: if a cursor has less than
   fraction f (between 0.0 and 1.0) of its pixels selected by the default
   -alphacut, the threshold is lowered until f of its pixels are
   selected. The default fraction is 0.33.

   Finally, there is an option -alpharemove that is useful for themes
   where many cursors are light colored (e.g. "whiteglass".) XFIXES
   returns the cursor data with the RGB values pre-multiplied by the
   alpha value. If the white cursors look too grey, specify -alpharemove
   to brighten them by having x11vnc divide out the alpha value.

   One user played with these parameters and reported back:
 Of the cursor themes present on my system:

   gentoo and gentoo-blue:   alphacut:192 - noalpharemove

   gentoo-silver:            alphacut:127 and alpharemove

   whiteglass and redglass (presumably also handhelds, which is based
   heavily on redglass) look fine with the apparent default of alphacut:255.


   Q-83: In XFIXES mode, are there any hacks to handle cursor
   transparency ("alpha channel") exactly?

   As of Jan/2005 libvncserver has been modified to allow an alpha
   channel (i.e. RGBA data) for Rich Cursors. So x11vnc can now send the
   alpha channel data to libvncserver. However, this data will only be
   used for VNC clients that do not support the CursorShapeUpdates VNC
   extension (or have disabled it.) It can be disabled for all clients
   with the -nocursorshape x11vnc option. In this case the cursor is
   drawn, correctly blended with the background, into the VNC framebuffer
   before being sent out to the client. So the alpha blending is done on
   the x11vnc side. Use the -noalphablend option to disable this behavior
   (always approximate transparent cursors with opaque RGB values.)

   The CursorShapeUpdates VNC extension complicates matters because the
   cursor shape is sent to the VNC viewers supporting it, and the viewers
   draw the cursor locally. This improves response over slow links. Alpha
   channel data for these locally drawn cursors is not supported by the
   VNC protocol.

   However, in the libvncserver CVS there is a patch to the TightVNC
   viewer to make this work for CursorShapeUpdates under some
   circumstances. This hack is outside of the VNC protocol. It requires
   the screens on both sides to be depth 24 at 32bpp (it uses the extra 8
   bits to secretly hide the cursor alpha channel data.) Not only does it
   require depth 24 at 32bpp, but it also currently requires the client
   and server to be of the same endianness (otherwise the hidden alpha
   data gets reset to zero by a libvncserver translation function; we can
   fix this at some point if there is interest.) The patch is for the
   TightVNC 1.3dev5 Unix vncviewer and it enables the TightVNC viewer to
   do the cursor alpha blending locally. The patch code should give an
   example on how to change the Windows TightVNC viewer to achieve the
   same thing (send me the patch if you get that working.)

   This patch is applied to the Enhanced TightVNC Viewer (SSVNC) package
   we provide.

   [Mouse Pointer]

   Q-84: Why does the mouse arrow just stay in one corner in my
   vncviewer, whereas my cursor (that does move) is just a dot?

   This default takes advantage of a tightvnc extension
   (CursorShapeUpdates) that allows specifying a cursor image shape for
   the local VNC viewer. You may disable it with the -nocursor option to
   x11vnc if your viewer does not have this extension.

   Note: as of Aug/2004 this should be fixed: the default for
   non-tightvnc viewers (or ones that do not support CursorShapeUpdates)
   will be to draw the moving cursor into the x11vnc framebuffer. This
   can also be disabled via -nocursor.


   Q-85: Can I take advantage of the TightVNC extension to the VNC
   protocol where Cursor Positions Updates are sent back to all connected
   clients (i.e. passive viewers can see the mouse cursor being moved
   around by another viewer)?

   Use the -cursorpos option when starting x11vnc. A VNC viewer must
   support the Cursor Positions Updates for the user to see the mouse
   motions (the TightVNC viewers support this.) As of Aug/2004 -cursorpos
   is the default. See also -nocursorpos and -nocursorshape.


   Q-86: Is it possible to swap the mouse buttons (e.g. left-handed
   operation), or arbitrarily remap them? How about mapping button clicks
   to keystrokes, e.g. to partially emulate Mouse wheel scrolling?

   You can remap the mouse buttons via something like: -buttonmap 13-31
   (or perhaps 12-21.) Also, note that xmodmap(1) lets you directly
   adjust the X server's button mappings, but in some circumstances it
   might be more desirable to have x11vnc do it.

   One user had an X server with only one mouse button(!) and was able to
   map all of the VNC client mouse buttons to it via: -buttonmap 123-111.

   Note that the -debug_pointer option prints out much info for every
   mouse/pointer event and is handy in solving problems.

   To map mouse button clicks to keystrokes you can use the alternate
   format where the keystrokes are enclosed between colons like this
   :<KeySym>: in place of the mouse button digit. For a sequence of
   keysyms separate them with "+" signs. Look in the include file
   <X11/keysymdef.h>, or use xev(1), or -debug_keyboard to find the
   keysym names. Button clicks can also be included in the sequence via
   the fake keysyms Button1, etc.

   As an example, suppose the VNC viewer machine has a mouse wheel (these
   generate button 4 and 5 events), but the machine that x11vnc is run on
   only has the 3 regular buttons. In normal operation x11vnc will
   discard the button 4 and 5 events. However, either of the following
   button maps could possibly be of use emulating the mouse wheel events
   in this case:
  -buttonmap 12345-123:Prior::Next:
  -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:

   Exactly what keystroke "scrolling" events they should be bound to
   depends on one's taste. If this method is too approximate, one could
   consider not using -buttonmap but rather configuring the X server to
   think it has a mouse with 5 buttons even though the physical mouse
   does not. (e.g. 'Option "ZAxisMapping" "4 5"'.)

   Note that when a keysym-mapped mouse button is clicked down this
   immediately generates the key-press and key-release events (for each
   keysym in turn if the mapping has a sequence of keysyms.) When the
   mouse button goes back up nothing is generated.

   If you include modifier keys like Shift_L instead of key-press
   immediately followed by key-release the state of the modifier key is
   toggled (however the initial state of the modifier key is ignored.) So
   to map the right button to type my name 'Karl Runge' I could use this:
  -buttonmap 3-:Shift_L+k+Shift_L+a+r+l+space+Shift_L+r+Shift_L+u+n+g+e:

   (yes, this is getting a little silly.)

   BTW, Coming the other way around, if the machine you are sitting at
   does not have a mouse wheel, but the remote machine does (or at least
   has 5 buttons configured), this key remapping can be useful:
  -remap Super_R-Button4,Menu-Button5

   you just tap those two keys to get the mouse wheel scrolls (this is
   more useful than the Up and Down arrow keys because a mouse wheel
   "click" usually gives a multi-line scroll.)
   [Keyboard Issues]

   Q-87: How can I get my AltGr and Shift modifiers to work between
   keyboards for different languages?

   The option -modtweak should help here. It is a mode that monitors the
   state of the Shift and AltGr Modifiers and tries to deduce the correct
   keycode to send, possibly by sending fake modifier key presses and
   releases in addition to the actual keystroke.

   Update:  As of Jul/2004 -modtweak is now the default (use -nomodtweak
   to get the old behavior.) This was done because it was noticed on
   newer XFree86 setups even on bland "us" keyboards like "pc104 us"
   XFree86 included a "ghost" key with both "<" and ">" it. This key does
   not exist on the keyboard (see this FAQ for more info.) Without
   -modtweak there was then an ambiguity in the reverse map keysym =>
   keycode, making it so the "<" symbol could not be typed.

   Also see the FAQ about the -xkb option for a more powerful method of
   modifier tweaking for use on X servers with the XKEYBOARD extension.

   When trying to resolve keyboard mapping problems, note that the
   -debug_keyboard option prints out much info for every keystroke and so
   can be useful debugging things.

   Note that for some users, the solution is to disable all of the above,
   and use -nomodtweak. This is the simplest form of keystroke insertion and
   it actually solved the problem. Try it if the other options don't help.


   Q-88: When I try to type a "<" (i.e. less than) instead I get ">"
   (i.e. greater than)! Strangely, typing ">" works OK!!

   Does your keyboard have a single key with both "<" and ">" on it? Even
   if it doesn't, your X server may think your keyboard has such a key
   (e.g. pc105 in the XF86Config file when it should be something else,
   say pc104.)

   Short Cut: Try the -xkb or -sloppy_keys options and see if that helps
   the situation. The discussion below is a bit outdated (e.g. -modtweak
   is now the default) but it is useful reference for various tricks and
   so is kept.


   The problem here is that on the Xserver where x11vnc is run there are
   two keycodes that correspond to the "<" keysym. Run something like
   this to see:

  xmodmap -pk | egrep -i 'KeyCode|less|greater'
  There are 4 KeySyms per KeyCode; KeyCodes range from 8 to 255.
      KeyCode     Keysym (Keysym) ...
       59         0x002c (comma)  0x003c (less)
       60         0x002e (period) 0x003e (greater)
       94         0x003c (less)   0x003e (greater)

   That keycode 94 is the special key with both "<" and ">". When x11vnc
   receives the "<" keysym over the wire from the remote VNC client, it
   unfortunately maps it to keycode 94 instead of 59, and sends 94 to the
   X server. Since Shift is down (i.e. you are Shifting the comma key),
   the X server interprets this as Shifted-94, which is ">".

   A workaround in the X server configuration is to "deaden" that special
   key:

  xmodmap -e "keycode 94 = "

   However, one user said he had to do this:

  xmodmap -e "keycode 94 = 0x002c 0x003c"

   (If the numerical values are different for your setup, substitute the
   ones that correspond to your display. The above xmodmap scheme can
   often be used to work around other ambiguous keysym to keycode
   mappings.)

   Alternatively, here are some x11vnc options to try to work around the
   problem:
   -modtweak

   and
   -remap less-comma

   These are convenient in that they do not modify the actual X server
   settings. The former (-modtweak) is a mode that monitors the state of
   the Shift and AltGr modifiers and tries to deduce the correct keycode
   sequence to send. Since Jul/2004 -modtweak is now the default. The
   latter (-remap less-comma) is an immediate remapping of the keysym
   less to the keysym comma when it comes in from a client (so when Shift
   is down the comma press will yield "<".)

   See also the FAQ about the -xkb option as a possible workaround using
   the XKEYBOARD extension.

   Note that the -debug_keyboard option prints out much info for every
   keystroke to aid debugging keyboard problems.


   Q-89: Extra Character Inserted, E.g.: When I try to type a "<" (i.e.
   less than) instead I get "<," (i.e. an extra comma.)

   This is likely because you press "Shift" then "<" but then released
   the Shift key before releasing the "<". Because of a keymapping
   ambiguity the last event "< up" is interpreted as "," because that key
   unshifted is the comma.

   This extra character insertion will happen for other combinations of
   characters: in general it can happen whenever the Shift key is
   released early.

   This should not happen in -xkb mode, because it works hard to resolve
   the ambiguities. If you do not want to use -xkb, try the option
   -sloppy_keys to attempt a similar type of algorithm.

   One user had this problem for Italian and German keyboards with the
   key containing ":" and "." When he typed ":" he would get an extra "."
   inserted after the ":". The solution was -sloppy_keys.


   Q-90: I'm using an "international" keyboard (e.g. German "de", or
   Danish "dk") and the -modtweak mode works well if the VNC viewer is
   run on a Unix/Linux machine with a similar keyboard.   But if I run
   the VNC viewer on Unix/Linux with a different keyboard (e.g. "us") or
   Windows with any keyboard, I can't type some keys like:   "@", "$",
   "<", ">", etc. How can I fix this?

   The problem with Windows is it does not seem to handle AltGr well. It
   seems to fake it up by sending Control_L+Alt_R to applications. The
   Windows VNC viewer sends those two down keystrokes out on the wire to
   the VNC server, but when the user types the next key to get, e.g., "@"
   the Windows VNC viewer sends events bringing the up the
   Control_L+Alt_R keys, and then sends the "@" keysym by itself.

   The Unix/Linux VNC viewer on a "us" keyboard does a similar thing
   since "@" is the Shift of the "2" key. The keysyms Shift and "@" are
   sent to the VNC server.

   In both cases no AltGr is sent to the VNC server, but we know AltGr is
   needed on the physical international keyboard to type a "@".

   This all worked fine with x11vnc running with the -modtweak option (it
   figures out how to adjust the Modifier keys (Shift or AltGr) to get
   the "@".) However it fails under recent versions of XFree86 (and the
   X.org fork.) These run the XKEYBOARD extension by default and make
   heavy use of it to handle international keyboards.

   To make a long story short, on these newer XFree86 setups the
   traditional X keymap lookup x11vnc uses is no longer accurate. x11vnc
   can't find the keysym "@" anywhere in the keymapping! (even though it
   is in the XKEYBOARD extended keymapping.)

   How to Solve: As of Jul/2004 x11vnc has two changes:
     * -modtweak (tweak Modifier keys) is now the default (use
       -nomodtweak to go back to the old way)
     * there is a new option -xkb to use the XKEYBOARD extension API to
       do the Modifier key tweaking.

   The -xkb option seems to fix all of the missing keys: "@", "<", ">",
   etc.: it is recommended that you try it if you have this sort of
   problem. Let us know if there are any remaining problems (see the next
   paragraph for some known problems.) If you specify the -debug_keyboard
   (aka -dk) option twice you will get a huge amount of keystroke
   debugging output (send it along with any problems you report.)

   Update: as of Jun/2005 x11vnc will try to automatically enable -xkb if
   it appears that would be beneficial (e.g. if it sees any of "@", "<",
   ">", "[" and similar keys are mapped in a way that needs the -xkb to
   access them.) To disable this automatic check use -noxkb.

   Known problems:
     * One user had to disable a "ghost" Mode_switch key that was causing
       problems under -xkb. His physical AltGr key was bound to
       ISO_Level3_Shift (which seems to be the XKEYBOARD way of doing
       things), while there was a ghost key Mode_switch (which seems to
       be obsolete) in the mapping as well. Both of these keysyms were
       bound to Mod5 and x11vnc was unfortunately choosing Mode_switch.
       From the x11vnc -xkb -dk -dk output it was noted that Mode_switch
       was attached to keycode 93 (no physical key generates this
       keycode) while ISO_Level3_Shift was attached to keycode 113. The
       keycode skipping option was used to disable the ghost key:
       -skip_keycodes 93
     * In implementing -xkb we noticed that some characters were still
       not getting through, e.g. "~" and "^". This is not really an
       XKEYBOARD problem. What was happening was the VNC viewer was
       sending the keysyms asciitilde and asciicircum to x11vnc, but on
       the X server with the international keyboard those keysyms were
       not mapped to any keys. So x11vnc had to skip them (Note: as of
       May/2005 they are added by default see -add_keysyms below.)
       The way these characters are typically entered on international
       keyboards is by "dead" (aka "mute") keys. E.g. to enter "~" at the
       physical display the keysym dead_tilde is pressed and released
       (this usually involves holding AltGr down while another key is
       pressed) and then space is pressed. (this can also be used get
       characters with the "~" symbol on top, e.g. "\E3" by typing "a"
       instead of space.)
       What to do? In general the VNC protocol has not really solved this
       problem: what should be done if the VNC viewer sends a keysym not
       recognized by the VNC server side? Workarounds can possibly be
       created using the -remap x11vnc option:
  -remap asciitilde-dead_tilde,asciicircum-dead_circumflex
       etc. Use -remap filename if the list is long. Please send us your
       workarounds for this problem on your keyboard. Perhaps we can have
       x11vnc adjust automatically at some point. Also see the
       -add_keysyms option in the next paragraph.
       Update: for convenience "-remap DEAD" does many of these mappings
       at once.
     * To complement the above workaround using the -remap, an option
       -add_keysyms was added. This option instructs x11vnc to bind any
       unknown Keysyms coming in from VNC viewers to unused Keycodes in
       the X server. This modifies the global state of the X server. When
       x11vnc exits it removes the extra keymappings it created. Note
       that the -remap mappings are applied first, right when the Keysym
       is received from a VNC viewer, and only after that would
       -add_keysyms, or anything else, come into play.
       Update: -add_keysyms is now on by default. Use -noadd_keysyms to
       disable.


   Q-91: When typing I sometimes get double, triple, or more of my
   keystrokes repeated. I'm sure I only typed them once, what can I do?

   This may be due to an interplay between your X server's key autorepeat
   delay and the extra time delays caused by x11vnc processing.

   Short answer: disable key autorepeating by running the command "xset r
   off" on the Xserver where x11vnc is run (restore via "xset r on") or
   use the new (Jul/2004) -norepeat x11vnc option. You will still have
   autorepeating because that is taken care of on your VNC viewer side.

   Update: as of Dec/2004 -norepeat is now the default. Use -repeat to
   disable it.

   Details:
   suppose you press a key DOWN and it generates changes in large regions
   of the screen. The CPU and I/O work x11vnc does for the large screen
   change could be longer than your X server's key autorepeat delay.
   x11vnc may not get to processing the key UP event until after the
   screen work is completed. The X server believes the key has been held
   down all this time, and applies its autorepeat rules.

   Even without inducing changes in large regions of the screen, this
   problem could arise when accessing x11vnc via a dialup modem or
   otherwise high latency link (e.g. > 250 ms latency.)

   Look at the output of "xset q" for the "auto repeat delay" setting. Is
   it low (e.g. < 300 ms)? If you turn off autorepeat completely: "xset r
   off", does the problem go away?

   The workaround is to manually apply "xset r off" and "xset r on" as
   needed, or to use the -norepeat (which has since Dec/2004 been made
   the default.) Note that with X server autorepeat turned off the VNC
   viewer side of the connection will (nearly always) do its own
   autorepeating so there is no big loss here, unless someone is also
   working at the physical display and misses his autorepeating.


   Q-92: The x11vnc -norepeat mode is in effect, but I still get repeated
   keystrokes!!

   Are you using x11vnc to log in to an X session via display manager?
   (as described in this FAQ) If so, x11vnc is starting before your
   session and it disables autorepeat when you connect, but then after
   you log in your session startup (GNOME, KDE, ...) could be resetting
   the autorepeat to be on. Or it could be something inside your desktop
   trying to be helpful that decides to turn it back on.

   x11vnc in -norepeat mode will by default reset autorepeat to off 2
   times (to help get thru the session startup problem), but it will not
   continue to battle with things turning autorepeat back on. It will
   also turn autorepeat off whenever it goes from a state of zero clients
   to one client. You can adjust the number of resets via "-norepeat N",
   or use "-norepeat -1" to have it keep resetting it whenever autorepeat
   gets turned back on when clients are connected.

   In general you can manually turn autorepeating off by typing "xset r
   off", or a using desktop utility/menu, or "x11vnc -R norepeat". If
   something in your desktop is automatically turning it back on you
   should figure out how to disable that somehow.


   Q-93: After using x11vnc for a while, I find that I cannot type some
   (or any) characters or my mouse clicks and drags no longer have any
   effect, or they lead to strange effects. What happened?

   Probably a modifier key, e.g. Control or Alt is "stuck" in a pressed
   down state.

   This happens for VNC in general by the following mechanism. Suppose on
   the Viewer side desktop there is some hot-key to switch
   desktops/rooms/spaces, etc. E.g. suppose Alt+LeftArrow moves to the
   left desktop/room/space. Or suppose an Alt+hotkey combination
   iconifies a window. This can leave the Alt key pressed down on the
   remote side.

   Consider the sequence that happens. The Alt_L key and then the
   LeftArrow key go down. Since you are inside the viewer the Alt_L key
   press is sent to the other side (x11vnc) and so it is pressed down in
   the remote desktop as well. (by "Alt_L" we mean the Alt key on the
   left-hand side of the keyboard.) Your local desktop (where the VNC
   Viewer is running) then warps to the new desktop/room/space: Leaving
   the Alt_L key still pressed down in the remote desktop.

   If someone is sitting at the desktop, or when you return in the viewer
   it may be very confusing because the Alt_L is still pressed down but
   you (or the person sitting at the desktop) do not realize this.
   Depending on which remote desktop (x11vnc side) is used, it can act
   very strangely.

   A quick workaround when you notice this is to press and release all of
   the Alt, Shift, Control, Windows-Flag, modifier keys to free the
   pressed one. You need to do this for both the left and right Shift,
   Alt, Control, etc. keys to be sure.

   Note that many VNC Viewers try to guard against this when they are
   notified by the window system that the viewer app has "lost focus".
   When it receives the "lost focus" event, the viewer sends VNC
   Key-Release events for all modifier keys that are currently pressed
   down. This does not always work, however, since it depends on how the
   desktop manages these "warps". If the viewer is not notified it cannot
   know it needs to release the modifiers.

   You can also use the -clear_mods option to try to clear all of the
   modifier keys at x11vnc startup. You will still have to be careful
   that you do not leave the modifier key pressed down during your
   session. It is difficult to prevent this problem from occurring (short
   of using -remap to prevent sending all of the problem modifier keys,
   which would make the destkop pretty unusable.)

   During a session these x11vnc remote control commands can also help:
   x11vnc -R clear_mods
   x11vnc -R clear_keys
   x11vnc -R clear_locks
   x11vnc -R clear_all

   A similar problem can occur if you accidentally press the Caps_Lock or
   Num_Lock down. When these are locked on the remote side it can
   sometimes lead to strange desktop behavior (e.g. cannot drag or click
   on windows.) As above you may not notice this because the lock isn't
   down on the local (Viewer) side. See this FAQ on lock keys problem.
   These options may help avoid the problem: -skip_lockkeys and
   -capslock. See also -clear_all.


   Q-94: The machine where I run x11vnc has an AltGr key, but the local
   machine where I run the VNC viewer does not. Is there a way I can map
   a local unused key to send an AltGr? How about a Compose key as well?

   Something like "-remap Super_R-Mode_switch" x11vnc option may work.
   Note that Super_R is the "Right Windoze(tm) Flaggie" key; you may want
   to choose another. The -debug_keyboard option comes in handy in
   finding keysym names (so does xev(1).)

   For Compose how about "-remap Menu-Multi_key" (note that Multi_key is
   the official name for Compose.) To do both at the same time: "-remap
   Super_R-Mode_switch,Menu-Multi_key" or use "-remap filename" to
   specify remappings from a file.


   Q-95: I have a Sun machine I run x11vnc on. Its Sun keyboard has just
   one Alt key labelled "Alt" and two Meta keys labelled with little
   diamonds. The machine where I run the VNC viewer only has Alt keys.
   How can I send a Meta keypress? (e.g. emacs needs this)

   Here are a couple ideas. The first one is to simply use xmodmap(1) to
   adjust the Sun X server. Perhaps xmodmap -e "keysym Alt_L = Meta_L
   Alt_L" will do the trick. (there are other ways to do it, one user
   used: xmodmap -e "keycode 26 = Meta_L" for his setup.)

   Since xmodmap(1) modifies the X server mappings you may not want to do
   this (because it affects local work on that machine.) Something like
   the -remap Alt_L-Meta_L to x11vnc may be sufficient for ones needs,
   and does not modify the X server environment. Note that you cannot
   send Alt_L in this case, maybe -remap Super_L-Meta_L would be a better
   choice if the Super_L key is typically unused in Unix.


   Q-96: Running x11vnc on HP-UX I cannot type "#" I just get a "3"
   instead.

   One user reports this problem on HP-UX Rel_B.11.23. The problem was
   traced to a strange keyboard mapping for the machine (e.g. xmodmap -pk
   output) that looked like:
  ...
  039  2                  at                 at               at
  ...
  047  3                  numbersign         numbersign       numbersign

   and similar triple mappings (with two in the AltGr/Mode_switch group)
   of a keysum to a single keycode.

   Use the -nomodtweak option as a workaround. You can also use xmodmap
   to correct these mappings in the server, e.g.:
  xmodmap -e "keycode 47 = 3 numbersign"

   Also, as of Feb/2007, set the environment variable MODTWEAK_LOWEST=1
   (either in your shell or via "-env MODTWEAK_LOWEST=1" option) to
   handle these mappings better.


   Q-97: Can I map a keystroke to a mouse button click on the remote
   machine?

   This can be done directly in some X servers using AccessX and
   Pointer_EnableKeys, but is a bit awkward. It may be more convenient to
   have x11vnc do the remapping. This can be done via the -remap option
   using the fake "keysyms" Button1, Button2, etc. as the "to" keys (i.e.
   the ones after the "-")

   As an example, consider a laptop where the VNC viewer is run that has
   a touchpad with only two buttons. It is difficult to do a middle
   button "paste" because (using XFree86/Xorg Emulate3Buttons) you have
   to click both buttons on the touch pad at the same time. This
   remapping:
  -remap Super_R-Button2

   maps the Super_R "flag" key press to the Button2 click, thereby making
   X pasting a bit easier.

   Note that once the key goes down, the button down and button up events
   are generated immediately on the x11vnc side. When the key is released
   (i.e. goes up) no events are generated.

   Q-98: How can I get Caps_Lock to work between my VNC viewer and
   x11vnc?

   This is a little tricky because it is possible to get the Caps_Lock
   state out of sync between your viewer-side machine and the x11vnc-side
   X server. For best results, we recommend not ever letting the
   Caps_Lock keypresses be processed by x11vnc. That way when you press
   Caps_Lock in the viewer your local machine goes into the Caps_Lock on
   state and sends keysym "A" say when you press "a". x11vnc will then
   fake things up so that Shift is held down to generate "A". The
   -skip_lockkeys option should help to accomplish this. For finer grain
   control use something like: "-remap Caps_Lock-None".

   Also try the -nomodtweak and -capslock options.

   Another useful option that turns off any Lock keys on the remote side
   at startup and end is the -clear_all option. During a session you can
   run these remote control commands to modify the Lock keys:
   x11vnc -R clear_locks
   x11vnc -R clear_all

   the former will try to unset any Lock keys, the latter will do same
   and also try to make it so no key is pressed down (e.g. "stuck" Alt_L,
   etc.)
   [Screen Related Issues and Features]

   Q-99: The remote display is larger (in number of pixels) than the
   local display I am running the vncviewer on. I don't like the
   vncviewer scrollbars, what I can do?

   vncviewer has a option (usually accessible via F8 key or -fullscreen
   option) for vncviewer to run in full screen, where it will
   automatically scroll when the mouse is near the edge of the current
   view. For quick scrolling, also make sure Backing Store is enabled on
   the machine vncviewer is run on. (XFree86/Xorg disables it by default
   for some reason, add Option "backingstore" to XF86Config on the
   vncviewer side.)

   BTW, contact me if you are having problems with vncviewer in
   fullscreen mode with your window manager (i.e. no keyboard response.)
   I have a workaround for vncviewer using XGrabServer().

   There may also be scaling viewers out there (e.g. TightVNC or UltraVNC
   on Windows) that automatically shrink or expand the remote framebuffer
   to fit the local display. Especially for hand-held devices. See also
   the next FAQ on x11vnc scaling.


   Q-100: Does x11vnc support server-side framebuffer scaling? (E.g. to
   make the desktop smaller.)

   As of Jun/2004 x11vnc provides basic server-side scaling. It is a
   global scaling of the desktop, not a per-client setting. To enable it
   use the "-scale fraction" option. "fraction" can either be a floating
   point number (e.g. -scale 0.75) or the alternative m/n fraction
   notation (e.g. -scale 3/4.) Note that if fraction is greater than one
   the display is magnified.

   Extra resources (CPU, memory I/O, and memory) are required to do the
   scaling. If the machine is slow where x11vnc is run with scaling
   enabled, the interactive response can be unacceptable. OTOH, if run
   with scaling on a fast machine the performance degradation is usually
   not a big issue or even noticeable.

   It may help to compile x11vnc with compiler option -O3 or -O4 to speed
   up the scaling code. Set the CFLAGS env. var. before running
   configure.

   Also, if you just want a quick, rough "thumbnail" of the display you
   can append ":nb" to the fraction to turn on "no blending" mode. E.g.:
   "-scale 1/3:nb" Fonts will be difficult to read, but the larger
   features will be recognizable. BTW, "no blending" mode is forced on
   when scaling 8bpp PseudoColor displays (because blending an indexed
   colormap is a bad idea and leads to random colors, use :fb to force it
   on.)

   One can also use the ":nb" with an integer scale factor (say "-scale
   2:nb") to use x11vnc as a screen magnifier for vision impaired
   applications. Since with integer scale factors the framebuffers become
   huge and scaling operations time consuming, be sure to use ":nb" for
   the fastest response.

   In general for a scaled display if you are using a TightVNC viewer you
   may want to turn off jpeg encoding (e.g. vncviewer -nojpeg host:0.)
   There appears to be a noise enhancement effect, especially for regions
   containing font/text: the scaling can introduce some pixel artifacts
   that evidently causes the tight encoding algorithm to incorrectly
   detect the regions as image data and thereby introduce additional
   pixel artifacts due to the lossiness of the jpeg compression
   algorithm. Experiment to see if -nojpeg vncviewer option improves the
   readability of text when using -scale to shrink the display size. Also
   note that scaling may actually slow down the transfer of text regions
   because after being scaled they do not compress as well. (this can
   often be a significant slowdown, e.g. 10X.)

   Another issue is that it appears VNC viewers require the screen width
   to be a multiple of 4. When scaling x11vnc will round the width to the
   nearest multiple of 4. To disable this use the ":n4" sub option (like
   ":nb" in the previous paragraph; to specify both use a comma:
   ":nb,n4", etc.)

   If one desires per-client scaling for something like 1:1 from a
   workstation and 1:2 from a smaller device (e.g. handheld), currently
   the only option is to run two (or more) x11vnc processes with
   different scalings listening on separate ports (-rfbport option, etc.)

   Update: As of May/2006 x11vnc also supports the UltraVNC server-side
   scaling. This is a per-client scaling by factors 1/2, 1/3, ... and so
   may be useful for PDA's ("-scale 1/2", etc. will give similar results
   except that it applies to all clients.) You may need to supply
   "-rfbversion 3.6" for this to be recognized by UltraVNC viewers.

   BTW, whenever you run two or more x11vnc's on the same X display and
   use the GUI, then to avoid all of the x11vnc's simultaneously
   answering the gui you will need to use something like "-connect file1
   -gui ..." with different connect files for each x11vnc you want to
   control via the gui (or remote-control.) The "-connect file1" usage
   gives separate communication channels between a x11vnc process and the
   gui process. Otherwise they all share the same X property channels:
   VNC_CONNECT and X11VNC_REMOTE.

   Update: As of Mar/2005 x11vnc now scales the mouse cursor with the
   same scale factor as the screen. If you don't want that, use the
   "-scale_cursor frac" option to set the cursor scaling to a different
   factor (e.g. use "-scale_cursor 1" to keep the cursor at its natural
   unscaled size.)


   Q-101: Does x11vnc work with Xinerama? (i.e. multiple monitors joined
   together to form one big, single screen.)

   Yes, it should generally work because it simply polls the big
   effective screen.

   If the viewing-end monitor is not as big as the remote Xinerama
   display, then the vncviewer scrollbars, etc, will have to be used to
   pan across the large area. However one user started two x11vnc's, one
   with "-clip 1280x1024+0+0" and the other with "-clip 1280x1024+1280+0"
   to split the big screen into two and used two VNC viewers to access
   them.

   As of Jun/2008: Use "-clip xinerama0" to clip to the first xinerama
   sub-screen (if xinerama is active.) xinerama1 for the 2nd sub-screen,
   etc. This way you don't need to figure out the WxH+X+Y of the desired
   xinerama sub-screen. screens are sorted in increasing distance from
   the (0,0) origin (I.e. not the Xserver's order.)

   There are a couple potential issues with Xinerama however. If the
   screen is not rectangular (e.g. 1280x1024 and 1024x768 monitors joined
   together), then there will be "non-existent" areas on the screen. The
   X server will return "garbage" image data for these areas and so they
   may be distracting to the viewer. The -blackout x11vnc option allows
   you to blacken-out rectangles by manually specifying their WxH+X+Y
   geometries. If your system has the libXinerama library, the -xinerama
   x11vnc option can be used to have it automatically determine the
   rectangles to be blackened out. (Note on 8bpp PseudoColor displays the
   fill color may not be black.) Update: -xinerama is now on by default.

   Some users have reported that the mouse does not behave properly for
   their Xinerama display: i.e. the mouse cannot be moved to all regions
   of the large display. If this happens try using the -xwarppointer
   option. This instructs x11vnc to fake mouse pointer motions using the
   XWarpPointer function instead of the XTestFakeMotionEvent XTEST
   function. (This may be due to a bug in the X server for XTEST when
   Xinerama is enabled.) Update: As of Dec/2006 -xwarppointer will be
   applied automatically if Xinerama is detected. To disable use:
   -noxwarppointer


   Q-102: Can I use x11vnc on a multi-headed display that is not Xinerama
   (i.e. separate screens :0.0, :0.1, ... for each monitor)?

   You can, but it is a little bit awkward: you must start separate
   x11vnc processes for each screen, and on the viewing end start up
   separate VNC viewer processes connecting to them. e.g. on the remote
   end:
  x11vnc -display :0.0 -bg -q -rfbport 5900
  x11vnc -display :0.1 -bg -q -rfbport 5901

   (this could be automated in the display manager Xsetup for example)
   and then on the local machine where you are sitting:
  vncviewer somehost:0 &
  vncviewer somehost:1 &

   Note: if you are running on Solaris 8 or earlier you can easily hit up
   against the maximum of 6 shm segments per process (for Xsun in this
   case) from running multiple x11vnc processes. You should modify
   /etc/system as mentioned in another FAQ to increase the limit. It is
   probably also a good idea to run with the -onetile option in this case
   (to limit each x11vnc to 3 shm segments), or even -noshm to use no shm
   segments.


   Q-103: Can x11vnc show only a portion of the display? (E.g. for a
   special purpose application or a very large screen.)

   As of Mar/2005 x11vnc has the "-clip WxH+X+Y" option to select a
   rectangle of width W, height H and offset (X, Y). Thus the VNC screen
   will be the clipped sub-region of the display and be only WxH in size.
   One user used -clip to split up a large Xinerama screen into two more
   managable smaller screens.

   This also works to view a sub-region of a single application window if
   the -id or -sid options are used. The offset is measured from the
   upper left corner of the selected window.


   Q-104: Does x11vnc support the XRANDR (X Resize, Rotate and
   Reflection) extension? Whenever I rotate or resize the screen x11vnc
   just seems to crash.

   As of Dec/2004 x11vnc supports XRANDR. You enable it with the -xrandr
   option to make x11vnc monitor XRANDR events and also trap X server
   errors if the screen change occurred in the middle of an X call like
   XGetImage. Once it traps the screen change it will create a new
   framebuffer using the new screen.

   If the connected vnc viewers support the NewFBSize VNC extension
   (Windows TightVNC viewer and RealVNC 4.0 windows and Unix viewers do)
   then the viewer will automatically resize. Otherwise, the new
   framebuffer is fit as best as possible into the original viewer size
   (portions of the screen may be clipped, unused, etc.) For these
   viewers you can try the -padgeom option to make the region big enough
   to hold all resizes and rotations. We have fixed this problem for the
   TightVNC Viewer on Unix: SSVNC

   If you specify "-xrandr newfbsize" then vnc viewers that do not
   support NewFBSize will be disconnected before the resize. If you
   specify "-xrandr exit" then all will be disconnected and x11vnc will
   terminate.


   Q-105: Independent of any XRANDR, can I have x11vnc rotate and/or
   reflect the screen that the VNC viewers see? (e.g. for a handheld
   whose screen is rotated 90 degrees.)

   As of Jul/2006 there is the -rotate option allow this. E.g's: "-rotate
   +90", "-rotate -90", "-rotate x", etc.


   Q-106: Why is the view in my VNC viewer completely black? Or why is
   everything flashing around randomly?

   See the next FAQ for a possible explanation.


   Q-107: I use Linux Virtual Terminals (VT's) to implement 'Fast User
   Switching' between users' sessions (e.g. Betty is on Ctrl-Alt-F7,
   Bobby is on Ctrl-Alt-F8, and Sid is on Ctrl-Alt-F1: they use those
   keystrokes to switch between their sessions.)   How come the view in a
   VNC viewer connecting to x11vnc is either completely black or
   otherwise all messed up unless the X session x11vnc is attached to is
   in the active VT?

   This seems to have to do with how applications (the X server processes
   in this case) must "play nicely" if they are not on the active VT
   (sometimes called VC for virtual console.) That is, they should not
   read from the keyboard or mouse or manage the video display unless
   they have the active VT. Given that it appears the XGetImage() call
   must ultimately retrieve the framebuffer data from the video hardware
   itself, it would make sense x11vnc's polling wouldn't work unless the
   X session had active control of the VT.

   There does not seem to be an easy way to work around this. Even xwd(1)
   doesn't work in this case (try it.) Something would need to be done at
   a lower level, say in the XFree86/Xorg X server. Also, using the
   Shadow Framebuffer (a copy of the video framebuffer is kept in main
   memory) does not appear to fix the problem.

   If no one is sitting at the workstation and you just want to remotely
   switch the VT over to the one associated with your X session (so
   x11vnc can poll it correctly), one can use the chvt(1) command, e.g.
   "chvt 7" for VT #7.


   Q-108: I am using x11vnc where my local machine has "popup/hidden
   taskbars" and the remote display where x11vnc runs also has
   "popup/hidden taskbars" and they interfere and fight with each other.
   What can I do?

   When you move the mouse to the edge of the screen where the popups
   happen, the taskbars interfere with each other in strange ways. This
   sometimes happens where the local machine is GNOME or Mac OS X and the
   remote machine is GNOME. Is there a way to temporarily disable one or
   both of these magic desktop taskbars?

   One x11vnc user suggests: it should be straightforward to right mouse
   click on the task bar panel, and uncheck "enable auto-hide" from the
   panel properties dialog box. This will make the panel always visible.

   Q-109: Help! x11vnc and my KDE screensaver keep switching each other
   on and off every few seconds.

   This is a new (Jul/2006) problem seen, say, on the version of KDE that
   is shipped with SuSE 10.1. It is not yet clear what is causing this...
   If you move the mouse through x11vnc the screensaver shuts off like it
   should but then a second or two after you stop moving the mouse the
   screensaver snaps back on.

   This may be a bug in kdesktop_lock. For now the only workaround is to
   disable the screensaver. You can try using another one such as
   straight xscreensaver (see the instructions here for how to disable
   kdesktop_lock.) If you have more info on this or see it outside of KDE
   please let us know.

   Update: It appears this is due to kdesktop_lock enabling the screen
   saver when the Monitor is in DPMS low-power state (e.g. standby,
   suspend, or off.) In Nov/2006 the x11vnc -nodpms option was added as a
   workaround. Normally it is a good thing that the monitor powers down
   (since x11vnc can still poll the framebuffer in this state), but if
   you experience the kdesktop_lock problem you can specify the "-nodpms"
   option to keep the Monitor out of low power state while VNC clients
   are connected. This is basically the same as typing "xset dpms force
   on" periodically. (if you don't want to do these things just disable
   the screensaver.) Feel free to file a bug against kdesktop_lock with
   KDE.

   Q-110: I am running the compiz 3D window manager (or beryl, MythTv,
   Google Earth, or some other OpenGL app) and I do not get screen
   updates in x11vnc.

   This appears to be because the 3D OpenGL/GLX hardware screen updates
   do not get reported via the XDAMAGE mechanism. So this is a bug in
   compiz/beryl or XDAMAGE/Xorg or the (possibly 3rd party) video card
   driver.

   As a workaround apply the -noxdamage option. As of Feb/2007 x11vnc
   will try to autodetect the problem and disable XDAMAGE if is appears
   to be missing a lot of updates. But if you know you are using compiz
   you might as well always supply -noxdamage. Thanks to this user who
   reported the problem and discovered the workaround.

   A developer for MiniMyth reports that the 'alphapulse' tag of the
   theme G.A.N.T. can also cause problems, and should be avoided when
   using VNC.

   Please report a bug or complaint to Beryl/Compiz and/or Xorg about
   this: running x11vnc with -noxdamage disables a nice improvement in
   responsiveness (especially for typing) and also leads to unnecessary
   CPU and memory I/O load due to the extra polling.

   Update: as of May/2010 NVIDIA may have fixed this problem in their
   proprietary drivers. See the NVIDIA Release Notes. (look for
   'x11vnc'.)

   Q-111: Can I use x11vnc to view my VMWare session remotely?

   Yes, since VMWare usually runs as an X application you can view it via
   x11vnc in the normal way.

   Note that VMWare has several viewing modes:
     * Normal X application window  (with window manager frame)
     * Quick-Switch mode  (with no window manager frame)
     * Fullscreen mode

   The way VMWare does Fullscreen mode on Linux is to display the Guest
   desktop in a separate Virtual Terminal (e.g. VT 8) (see this FAQ on
   VT's for background.) Unfortunately, this Fullscreen VT is not an X
   server. So x11vnc cannot access it (however, see this discussion of
   -rawfb for a possible workaround.) x11vnc works fine with "Normal X
   application window" and "Quick-Switch mode" because these use X.

   Update: It appears the in VMWare 5.x the Fullscreen mode is X, so
   x11vnc access does work.

   One user reports he left his machine with VMWare in the Fullscreen
   mode, and even though his X session wasn't in the active VT, he could
   still connect x11vnc to the X session and pass the keystrokes Ctrl-Alt
   (typing "blind") to the VMWare X app. This induced VMWare to switch
   out of Fullscreen into Normal X mode and he could continue working in
   the Guest desktop remotely.


   Aside: Sometimes it is convenient (for performance, etc.) to start
   VMWare in its own X session using startx(1). This can be used to have
   a minimal window manger (e.g. twm or even no window manager), to
   improve response. One can also cut the display depth (e.g. to 16bpp)
   in this 2nd X session to improve video performance. This 2nd X session
   emulates Fullscreen mode to some degree and can be viewed via x11vnc
   as long as the VMWare X session is in the active VT.

   Also note that with a little bit of playing with "xwininfo -all
   -children" output one can extract the (non-toplevel) window-id of the
   of the Guest desktop only when VMWare is running as a normal X
   application. Then one can export just the guest desktop (i.e. without
   the VMWare menu buttons) by use of the -id windowid option. The
   caveats are the X session VMWare is in must be in the active VT and
   the window must be fully visible, so this mode is not terribly
   convenient, but could be useful in some circumstances (e.g. running
   VMWare on a very powerful server machine in a server room that happens
   to have a video card, (but need not have a monitor, Keyboard or
   mouse).)



   [Exporting non-X11 devices via VNC]

   Q-112: Can non-X devices (e.g. a raw framebuffer) be viewed (and even
   controlled) via VNC with x11vnc?

   As of Apr/2005 there is support for this. Two options were added:
   "-rawfb string" (to indicate the raw frame buffer device, file, etc.
   and its parameters) and "-pipeinput command" (to provide an external
   program that will inject or otherwise process mouse and keystroke
   input.) Some useful -pipeinput schemes, VID, CONSOLE, and UINPUT, have
   since been built into x11vnc for convenience.

   This non-X mode for x11vnc is somewhat experimental because it is so
   removed in scope from the intended usage of the tool. Incomplete
   attempt is made to make all of the other options consistent with non-X
   framebuffer polling. So all of the X-related options (e.g.
   -add_keysyms, -xkb) are just ignored or may cause an error if used. Be
   careful applying such an option via remote control.

   The format for the -rawfb string is:
    -rawfb <type>:<object>@<W>x<H>x<bpp>[-<BPL>][:<R>/<G>/<B>][+<offset>]

   There are also some useful aliases (e.g. "console".) Some examples:
    -rawfb shm:210337933@800x600x32:ff/ff00/ff0000

    -rawfb map:/dev/fb0@1024x768x16

    -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232

    -rawfb file:/tmp/my.pnm@250x200x24+37

    -rawfb file:/dev/urandom@128x128x8

    -rawfb snap:/dev/video0@320x240x24 -24to32

    -rawfb console

    -rawfb vt2

    -rawfb video

    -rawfb setup:mycmd.sh

   So the type can be "shm" for shared memory objects, and "map" or
   "file" for file objects. "map" uses mmap(2) to map the file into
   memory and is preferred over "file" (that uses the slower lseek(2)
   access method.) Only use file if map isn't working. BTW, "mmap" is an
   alias for "map" and if you do not supply a type and the file exists,
   map is assumed (see the -help output and below for some exceptions to
   this.) The "snap:" setting applies the -snapfb option with "file:"
   type reading (this is useful for exporting webcams or TV tuner video;
   see the next FAQ for more info.)

   Also, if the string is of the form "setup:cmd" then cmd is run and the
   first line of its output retrieved and used as the rawfb string. This
   allows initializing the device, determining WxHxB, etc.

   The object will be the numerical shared memory id for the case of shm.
   The idea here is some other program has created this shared memory
   segment and periodically updates it with new framebuffer data. x11vnc
   polls the area for changes. See shmat(2) and ipcs(8) for more info.
   The ipcs command will list current shared memory segments on the
   system. Sometimes you can snoop on a program's framebuffer it did not
   expect you would be polling!

   The object will be the path to the regular or character special file
   for the cases of map and file. The idea here is that in the case of a
   regular file some other program is writing/updating framebuffer image
   data to it. In the case of a character special (e.g. /dev/fb0) it is
   the kernel that is "updating" the framebuffer data.

   In most cases x11vnc needs to be told the width, height, and number of
   bits per pixel (bpp) of the framebuffer. This is the @WxHxB field. For
   the case of the Linux framebuffer device, /dev/fb0, the fbset(8) may
   be of use (but may not always be accurate for what is currently
   viewable.) In general some guessing may be required, especially for
   the bpp. Update: in "-rawfb console" mode x11vnc will use the linuxfb
   API to try to guess (it is still not always accurate.) Also try
   "-rawfb vtN" (on x11vnc 0.9.7 and later) for the N-th Linux text
   console (aka virtual terminal.) If the number of Bytes Per Line is not
   WxHxB/8 (i.e. the framebuffer lines are padded) you can specify this
   information after WxHxB via "-BPL", e.g. @800x600x16-2048

   Based on the bpp x11vnc will try to guess the red, green, and blue
   masks (these indicate which bits correspond to each color.) It if gets
   it wrong you can specify them manually via the optional ":R/G/B"
   field. E.g. ":0xff0000/0x00ff00/0x0000ff" (this is the default for
   32bpp.)

   Finally, the framebuffer may not begin at the beginning of the memory
   object, so use the optional "+offset" parameter to indicate where the
   framebuffer information starts. So as an example, the Xvfb virtual
   framebuffer has options -shmem and -fbdir for exporting its virtual
   screen to either shm or a mapped file. The format of these is XWD and
   so the initial header should be skipped. BTW, since XWD is not
   strictly RGB the view will only be approximate, but usable. Of course
   for the case of Xvfb x11vnc can poll it much better via the X API, but
   you get the idea.

   By default in -rawfb mode x11vnc will actually close any X display it
   happened to open. This is basically to shake out bugs (e.g it will
   crash rather than mysteriously interacting with the X display.) If you
   want x11vnc to keep the X display open while polling the raw
   framebuffer prefix a "+" sign at the beginning of the string (e.g.
   +file:/dev/urandom@64x64x8) This could be convenient for keeping the
   remote control channel active (it uses X properties.) The "-connect
   /path/to/file" mechanism could also be used for remote control to
   avoid the X property channel. Rare usage, but if you also supply
   -noviewonly in this "+" mode then the mouse and keyboard input are
   still sent to the X display, presumably for doing something amusing
   with /dev/fb...

   Interesting Devices:. Here are some aliases for interesting device
   files that can be polled via -rawfb:
   -rawfb console               /dev/fb0        Linux Console
   -rawfb vt2                   /dev/vcsa2      Linux Console (e.g. virtual ter
minal #2)
   -rawfb video                 /dev/video0     Video4Linux Capture device
   -rawfb rand                  /dev/urandom    Random Bytes
   -rawfb null                  /dev/zero       Zero Bytes (black screen)

   The Linux console, /dev/fb0, etc needs to have its driver enabled in
   the kernel. Some of the drivers are video card specific and
   accelerated. The console is either the Text consoles (usually
   tty1-tty6), or X graphical display (usually starting at tty7.) In
   addition to the text console other graphical ones may be viewed and
   interacted with as well, e.g. DirectFB or SVGAlib apps, VMWare non-X
   fullscreen, or Qt-embedded apps (PDAs/Handhelds.) By default the
   pipeinput mechanisms UINPUT and CONSOLE (keystrokes only) are
   automatically attempted in this mode under "-rawfb console".

   The Video4Linux Capture device, /dev/video0, etc is either a Webcam or
   a TV capture device and needs to have its driver enabled in the
   kernel. See this FAQ for details. If specified via "-rawfb Video" then
   the pipeinput method "VID" is applied (it lets you change video
   parameters dynamically via keystrokes.)

   The last two, /dev/urandom and /dev/zero are just for fun, but are
   also useful in testing.


   All of the above -rawfb options are just for viewing the raw
   framebuffer (although some of the aliases do imply keystroke and mouse
   pipeinput methods.) That may be enough for certain applications of
   this feature (e.g. suppose a video camera mapped its framebuffer into
   memory and you just wanted to look at it via VNC.)
   To handle the pointer and keyboard input from the viewer users the
   "-pipeinput cmd" option was added to indicate a helper program to
   process the user input. The input is streamed to it and looks
   something like this:
   Pointer 1 205 257 0 None
   Pointer 1 198 253 0 None
   Pointer 1 198 253 1 ButtonPress-1
   Pointer 1 198 253 0 ButtonRelease-1
   Pointer 1 198 252 0 None
   Keysym 1 1 119 w KeyPress
   Keysym 1 0 119 w KeyRelease
   Keysym 1 1 65288 BackSpace KeyPress
   Keysym 1 0 65288 BackSpace KeyRelease
   Keysym 1 1 112 p KeyPress
   Keysym 1 0 112 p KeyRelease

   Run "-pipeinput tee:/bin/cat" to get a description of the format. Note
   that the -pipeinput option is independent of -rawfb mode and so may
   have some other interesting uses. The "tee:" prefix means x11vnc will
   both process the user input and pipe it to the command. The default is
   to just pipe it to the -pipeinput command.

   Note the -pipeinput helper program could actually control the raw
   framebuffer. In the libvncserver CVS a simple example program
   x11vnc/misc/slide.pl is provided that demonstrates a simple jpeg
   "slideshow" application. Also the builtin "-pipeinput VID" mode does
   this for webcams and TV capture devices (/dev/video0.)

   The -pipeinput program is run with these environment variables set:
   X11VNC_PID, X11VNC_PROG, X11VNC_CMDLINE, X11VNC_RAWFB_STR to aid its
   knowing what is up.

   Another example provided in libvncserver CVS is a script to inject
   keystrokes into the Linux console (e.g. the virtual consoles:
   /dev/tty1, /dev/tty2, etc) in x11vnc/misc/vcinject.pl. It is based on
   the vncterm/LinuxVNC.c program also in the libvncserver CVS. So to
   view and interact with VT #2 (assuming it is the active VT) one can
   run something like:
  x11vnc -rawfb map:/dev/fb0@1024x768x16 -pipeinput './vcinject.pl 2'

   This assumes your Linux framebuffer device (/dev/fb0) is properly
   configured. See fbset(8) and other documentation. Try
   "file:/dev/fb0@WxHxB" as a last resort. Starting with x11vnc 0.8.1,
   the above VT injection is built in, as well as WxHxB determination.
   Just use something like:
  x11vnc -rawfb console

   this will try to guess the active virtual console (via /dev/tty0) and
   also the /dev/fb0 WxHxB and rgb masks automatically. Use, e.g.,
   "-rawfb console3" to force the VT number. This input method can be
   used generally via "-pipeinput CONSOLE". Also starting with x11vnc
   0.8.2 the "-pipeinput UINPUT" mode is tried first (it does both
   keyboard and mouse input) and then falls back to CONSOLE mode if it is
   not available. Here is the -help output for this mode:

     If the rawfb string begins with "console" the framebuffer device
     /dev/fb0 is opened (this requires the appropriate kernel modules to
     be installed) and so is /dev/tty0. The latter is used to inject
     keystrokes (not all are supported, but the basic ones are.) You
     will need to be root to inject keystrokes. /dev/tty0 refers to the
     active VT, to indicate one explicitly, use "console2", etc. using
     the VT number.

     If the Linux version seems to be 2.6 or later and the "uinput"
     module appears to be present, then the uinput method will be used
     instead of /dev/ttyN. uinput allows insertion of BOTH keystrokes
     and mouse input and so it preferred when accessing graphical (e.g.
     Qt-embedded) linux console apps. See -pipeinput UINPUT below for
     more information on this mode (you may want to also use the
     -nodragging and -cursor none options.) Use "console0", etc or
     -pipeinput CONSOLE to force the /dev/ttyN method.

     Note you can change VT remotely using the chvt(1) command.
     Sometimes switching out and back corrects the framebuffer state.

     To skip input injecting entirely use "consolex".

     The string "/dev/fb0" (1, etc) can be used instead of "console".
     This can be used to specify a different framebuffer device, e.g.
     /dev/fb1. As a shortcut the "/dev/" can be dropped. If the name is
     something nonstandard, use "console:/dev/foofb"

     If you do not want x11vnc to guess the framebuffer's WxHxB and
     masks automatically (sometimes the kernel gives inaccurate
     information), specify them with a @WxHxB at the end of the string.

   The above is just an example of what can be done. Note that if you
   really want to view and interact with the Linux Text console it is
   better to use the more accurate and faster LinuxVNC program. The
   advantage x11vnc -rawfb might have is that it can allow interaction
   with a non-text application, e.g. one based on SVGAlib or Qt-embedded
   Also, for example the VMWare Fullscreen mode is actually viewable
   under -rawfb and can be interacted with if uinput is enabled.

   If the Linux uinput driver is available then full keystroke and mouse
   input into the Linux console can be performed. You may be able to
   enable uinput via commands like these:
  modprobe uinput
  mknod /dev/input/uinput c 10 223

   The -rawfb and -pipeinput features are intended to help one creatively
   "get out of a jam" (say on a legacy or embedded device) where X is
   absent or doesn't work properly. Feedback and bug reports are welcome.
   For more control and less overhead use libvncserver in your own C
   program that passes the framebuffer to libvncserver.


   Q-113: Can I export the Linux Console (Virtual Terminals) via VNC
   using x11vnc?

   Yes, you may need to be root to access the devices that make up the
   linux console.

   To access the active Linux console via the computer's framebuffer try
   something like:
  x11vnc -rawfb console
  x11vnc -rawfb console2

   These will try to access the framebuffer through /dev/fb (or /dev/fb0,
   etc.) and if it succeeds it will show any text or graphics that is
   currently displayed. Keystrokes will be injected via the device
   /dev/tty0 (to force an explicit virtual terminal append a number, e.g.
   "console2" to select /dev/tty2.)

   If your Linux system does not have a framebuffer device (/dev/fb) you
   can get one by adding, e.g., vga=0x31B boot parameter. This enables
   the VGA framebuffer device at 1280x1024x24. 0x317 gives 1024x768x16,
   etc. You can also enable a Linux framebuffer device by modprobing a
   framebuffer driver specific to your video card.

   Note that this "-rawfb console" mode shows the contents of the
   hardware framebuffer, and so will show whatever is on the screen. It
   has no concept of Virtual Terminals WRT what there is to view, it
   always shows the active virtual terminal.

   Another mode is specific to the Linux text Virtual Terminals, it shows
   their text and colors (but no graphics) regardless of whether it is
   the active VT or not. It is available on x11vnc 0.9.7 and later.
   Enable this mode like this:
  x11vnc -rawfb vt
  x11vnc -rawfb vt2

   The former will select the active one, the latter the 2nd VT. x11vnc
   implements this mode by opening the current console text file
   "/dev/vcsa2" instead of "/dev/fb". In this way it provides the basic
   functionality of the LibVNCServer LinuxVNC program.

   The vt mode can be a useful way to try to get a machine's X server
   working remotely, e.g. you edit /etc/X11/xorg.conf and then type
   startx (or similar, e.g. gdm) in the virtual terminal. A 2nd x11vnc
   could be used to see if the X server is now working correctly.

   Q-114: Can I export via VNC a Webcam or TV tuner framebuffer using
   x11vnc?

   Yes, this is possible to some degree with the -rawfb option. There is
   no X11 involved: snapshots from the video capture device are used for
   the screen image data. See the previous FAQ on -rawfb for background.
   For best results, use x11vnc version 0.8.1 or later.

   Roughly, one would do something like this:
  x11vnc -rawfb snap:/dev/video@320x240x32

   This requires that the system allows simple read(2) access to the
   video device. This is true for video4Linux on Linux kernel 2.6 and
   later (it won't work for 2.4, you'll need a separate program to
   snapshot to a file that you point -rawfb to; ask me if it is not clear
   what to do.)

   The "snap:" enforces -snapfb mode which appears to be necessary. The
   read pointer for video capture devices cannot be repositioned (which
   would be needed for scanline polling), but you can read a full frame
   of data from the device.

   On Linux, if the Video4Linux API is present or the v4l-info(1) program
   (related to xawtv) exists in in PATH, then x11vnc can be instructed to
   try it to determine the -rawfb WxHxB parameters for you automatically.
   In this case one would just type:
  x11vnc -rawfb video

   or "-rawfb video1" for the 2nd video device, etc.

   x11vnc has also been extended to use the Video4Linux API over v4l-info
   if it is available at build time. This enables setting parameters
   (e.g. size and brightness) via x11vnc. See the description below.
   Without Video4Linux you will need to initialize the settings of the
   video device using something like xawtv or spcaview (and then hope the
   settings persist until x11vnc reopens the device.)

   Many video4linux drivers tend to set the framebuffer to be 24bpp (as
   opposed to 32bpp.) Since this can cause problems with VNC viewers,
   etc, the -24to32 option will be automatically imposed when in 24bpp.

   Note that by its very nature, video capture involves rapid change in
   the framebuffer. This is especially true for cameras where slight
   wavering in brightness is always happening. This can lead to much
   network bandwidth consumption for the VNC traffic and also local CPU
   and I/O resource usage. You may want to experiment with "dialing down"
   the framerate via the -wait, -slow_fb, or -defer options. Decreasing
   the window size and bpp also helps.


   Setting Camera/Tuner parameters via x11vnc:

   There is also some support for setting parameters of the capture
   device. This is done via "-rawfb video:<settings>". This could be
   useful for unattended startup at boottime, etc. Here is the -help
   description:

     A more sophisticated video device scheme allows initializing the
     device's settings using:

           -rawfb video:<settings>

     The prefix could also be, as above, e.g. "video1:" to specify the
     device file. The v4l API must be available for this to work.
     Otherwise, you will need to try to initialize the device with an
     external program, e.g. xawtv, spcaview, and hope they persist when
     x11vnc re-opens the device.

     <settings> is a comma separated list of key=value pairs. The
     device's brightness, color, contrast, and hue can be set to
     percentages, e.g. br=80,co=50,cn=44,hu=60.

     The device filename can be set too if needed (if it does not start
     with "video"), e.g. fn=/dev/qcam.

     The width, height and bpp of the framebuffer can be set via, e.g.,
     w=160,h=120,bpp=16.

     Related to the bpp above, the pixel format can be set via the
     fmt=XXX, where XXX can be one of: GREY, HI240, RGB555, RGB565,
     RGB24, and RGB32 (with bpp 8, 8, 16, 16, 24, and 32 respectively.)
     See http://www.linuxtv.org for more info (V4L api.)

     For TV/rf tuner cards one can set the tuning mode via tun=XXX where
     XXX can be one of PAL, NTSC, SECAM, or AUTO.

     One can switch the input channel by the inp=XXX setting, where XXX
     is the name of the input channel (Television, Composite1, S-Video,
     etc.) Use the name that is in the information about the device that
     is printed at startup.

     For input channels with tuners (e.g. Television) one can change
     which station is selected by the sta=XXX setting. XXX is the
     station number. Currently only the ntsc-cable-us (US cable)
     channels are built into x11vnc. See the -freqtab option below to
     supply one from xawtv. If XXX is greater than 500, then it is
     interpreted as a raw frequency in KHz.

     Example:

     -rawfb video:br=80,w=320,h=240,fmt=RGB32,tun=NTSC,sta=47

     one might need to add inp=Television too for the input channel to
     be TV if the card doesn't come up by default in that one.

     Note that not all video capture devices will support all of the
     above settings.

     See the -pipeinput VID option below for a way to control the
     settings through the VNC Viewer via keystrokes.

     As above, if you specify a "@WxHxB..." after the <settings> string
     they are used verbatim: the device is not queried for the current
     values. Otherwise the device will be queried.

   Also, if you supply the "-pipeinput VID" (or use "-rawfb Video")
   option you can control the settings to some degree via keystroke
   mappings, e.g. B to increase the brightness or Up arrow to change the
   TV station:

     For "-pipeinput VID" and you are using the -rawfb for a video
     capture device, then an internal list of keyboard mappings is used
     to set parameters of the video. The mappings are:

         "B" and "b" adjust the brightness up and down.
         "H" and "h" adjust the hue.
         "C" and "c" adjust the colour.
         "N" and "n" adjust the contrast.
         "S" and "s" adjust the size of the capture screen.
         "I" and "i" cycle through input channels.
         Up and Down arrows adjust the station (if a tuner)
         F1, F2, ..., F6 will switch the video capture pixel
         format to HI240, RGB565, RGB24, RGB32, RGB555, and
         GREY respectively. See -rawfb video for details.

   See also the -freqtab option to supply your own xawtv channel to
   frequency mappings for your country (only ntsc-cable-us is built into
   x11vnc.)


   Q-115: Can I connect via VNC to a Qt-embedded/Qt-enhanced/Qtopia
   application running on my handheld, cell phone, or PC using the Linux
   console framebuffer (i.e. not X11)?

   Yes, the basic method for this is the -rawfb scheme where the Linux
   console framebuffer (usually /dev/fb0) is polled and the uinput driver
   is used to inject keystrokes and mouse input. Often you will just have
   to type:
  x11vnc -rawfb console

   (you may need to enable the uinput driver on the system via "modprobe
   uinput; mknod /dev/input/uinput c 10 223") If this does not find the
   correct frame buffer properties figure them out or guess them and use
   something like:
  x11vnc -rawfb /dev/fb0@640x480x16

   Also, to force usage of the uinput injection method use "-pipeinput
   UINPUT". See the -pipeinput description for tunable parameters, etc.

   One problem with the x11vnc uinput scheme is that it cannot guess the
   mouse motion "acceleration" used by the windowing application (e.g.
   QWS or X11.) For X11 and Qt-embedded the acceleration is usually 2
   (i.e. a dx of 1 from the mouse yields a 2 pixel displacement of the
   mouse cursor.) The default x11vnc uses is 2, since that is often used.
   However for one Qt-embedded system we needed to do:
  x11vnc -rawfb console  -pipeinput UINPUT:accel=4.0

   to get reasonable positioning of the mouse.

   Even with the correct acceleration setting there is still some drift
   (probably because of the mouse threshold where the acceleration kicks
   in) and so x11vnc needs to reposition the cursor from 0,0 about 5
   times a second. See the -pipeinput UINPUT option for tuning parameters
   that can be set (there are some experimental thresh=N tuning
   parameters as well)

   Currently, one can expect mouse input to be a little flakey. All in
   all, the Linux framebuffer input mechanism for Qt-embedded framebuffer
   apps is not perfect, but it is usable.

   If you need to create a smaller x11vnc binary for a handheld
   environment be sure to run strip(1) on it and also consider
   configuring with, e.g. "env CPPFLAGS='-DSMALL_FOOTPRINT=1' ./configure
   ..." to remove rarely used features and large texts (use 2 or 3
   instead of 1 to remove more.) Currently (Jul/2006) this can lower the
   size of the x11vnc from 1.1MB to 0.6-0.7MB.

   The x11vnc uinput method applies to nearly anything on the Linux
   framebuffer console, not just Qt-embedded/Qtopia. DirectFB, SDL using
   fbcon driver, SVGAlib applications can also be viewed and interacted
   with. Even a Linux X session can be viewed and interacted with without
   using X11 (and x11vnc does not have to terminate when the X server
   restarts!) The Linux Text consoles (F1-F6) also work.

   Note that Qt-embedded supplies its own VNC graphics driver, but it
   cannot do both the Linux console framebuffer and VNC at the same time,
   which is often what is desired from VNC.

   Update: We are finding some setups like Qtopia on the IPAQ do not
   allow mouse input via uinput. Please help us debug this problem by
   trying x11vnc on your device and letting us know what does and does
   not work. See the next FAQ for a possible workaround for touchscreens.


   Q-116: How do I inject touch screen input into an
   Qt-embedded/Qt-enhanced/Qtopia cell phone such as openmoko/qtmoko Neo
   Freerunner?

   The qtmoko project does not use X11 for the graphical display.
   Unfortunately the Linux uinput method described in the previous FAQ
   does not work because Qt is using TSLIB (touch screen library) to
   process the input and it only reads from one device (often
   /dev/input/event1) and not from the new UINPUT device that x11vnc
   creates (under -pipeinput UINPUT)

   So something else needs to be done. It was discovered that by simply
   writing the touchscreen events directly to /dev/input/event1 then
   input can be injected into the system. There is no x11vnc builtin mode
   for this yet (until we understand it better), but there is a working
   script provided in x11vnc/misc/qt_tslib_inject.pl. So one could use it
   this way for example:
  x11vnc ... -rawfb console -pipeinput path/to/qt_tslib_inject.pl -env INJECT_O
PTIONS=clickonly,cal=/etc/pointercal

   Read the script for how to enable other options and what the above
   options mean (e.g. /etc/pointercal contains TSLIB's calibration
   parameters and are necessary to achieve accurate pointing.)

   The x11vnc/misc/qt_tslib_inject.pl script can potentially be modified
   to handle other devices where the uinput method fails. It could also
   be modified to create 'hot keys', etc.

   Please let us know how things go if you try this out; there is much to
   learn about synthetic input injection in handhelds and cell phones. As
   we learn more we can develop a builtin x11vnc mode for this sort of
   injection.

   Update Dec/2010: There is experimental built-in UINPUT support in the
   x11vnc development tarball for qtmoko with touchpad managed by tslib.
   See -pipeinput UINPUT for more info. Here is an example:
   x11vnc -rawfb console -pipeinput UINPUT:touch,tslib_cal=/etc/pointercal,dire
ct_abs=/dev/input/event1,nouinput,dragskip=3


   Q-117: Now that non-X11 devices can be exported via VNC using x11vnc,
   can I build it with no dependencies on X11 header files and libraries?

   Yes, as of Jul/2006 x11vnc enables building for -rawfb only support.
   Just do something like when building:
  ./configure --without-x    (plus any other flags)
  make

   You can then test via "ldd x11vnc" that the binary does not depend on
   libX11.so, etc. See the previous FAQ's for non-X11 framebuffer usage.
   If you use this for an interesting non-X11 application please let us
   know what you did.


   Q-118: How do I cross compile x11vnc for a different architecture than
   my Linux i386 or amd64 PC?

   You will need a cross-compiling toolchain. Perhaps your distro
   provides these or you can find a HOWTO for your distro. We found a
   nice one at qtmoko.org for building armel binaries on Debian Linux
   i386 machines. It includes most of the libraries that x11vnc needs. We
   use that example here.

   We ran this script to set PATH, configure, and build:
#!/bin/sh

# toolchain from: qtmoko-debian-toolchain-armv4t-eabi.tar.gz

export PATH=/opt/toolchains/arm920t-eabi/bin:$PATH

env CC=arm-linux-gcc ./configure --host=arm-linux --without-avahi

make

arm-linux-strip ./x11vnc/x11vnc
ls -l ./x11vnc/x11vnc

   Note we had to include --without-avahi due to lack of
   libavahi-client.so.3 supplied by the toolchain we used. One would need
   to add it if it was desired on the target machine. We also stripped
   the binary to make it smaller.

   For an embedded system one may also want to add --without-x if the
   embedded system does not use X11 and the -rawfb mechanism must be
   used.


   Q-119: Does x11vnc support Mac OS X Aqua/Quartz displays natively
   (i.e. no X11 involved)?

   Yes, since Nov/2006 in the development tree (x11vnc-0.8.4 tarball)
   there is support for native Mac OS X Aqua/Quartz displays using the
   -rawfb mechanism described above. The mouse and keyboard input is
   achieved via Mac OS X API's.

   So you can use x11vnc as an alternative to OSXvnc (aka Vine Server),
   or Apple Remote Desktop (ARD). Perhaps there is some x11vnc feature
   you'd like to use on Mac OS X, etc. For a number of activities (e.g.
   window drags) it seems to be faster than OSXvnc.

   Notes:

   X11:  x11vnc will also work (as it has for years) with a X11 server
   (XDarwin) running on Mac OS X (people often install this software to
   display remote X11 apps on their Mac OS X system, or use some old
   favorites locally such as xterm.) However in this case x11vnc will
   only work reasonably in single window -id windowid mode (and the
   window may need to have mouse focus.)

   If you do not have the DISPLAY env. variable set, x11vnc will assume
   native Aqua/Quartz on Mac OS X, however if DISPLAY is set it will
   assume an X11 connection. Use "-rawfb console" to force the native
   display (or unset DISPLAY.)

   Update: Leopard sets DISPLAY by default in all sessions. Since it
   starts with the string "/tmp/" x11vnc will use that to know if it
   should ignore it. Use "-display :0.0" to force it.

   Building:  If you don't have the X11 build and runtime packages
   installed you will need to build it like this:
   (cd to the e.g. x11vnc-0.9, source directory)
   ./configure --without-x
   make

   Win2VNC/x2vnc:  One handy use is to use the -nofb mode to redirect
   mouse and keyboard input to a nearby Mac (i.e. one to the side of your
   desk) via x2vnc or Win2VNC. See this FAQ for more info.

   Options:  Here are the Mac OS X specific x11vnc options:
   -macnodim              For the native Mac OS X server, disable dimming.
   -macnosleep            For the native Mac OS X server, disable display sleep
.
   -macnosaver            For the native Mac OS X server, disable screensaver.
   -macnowait             For the native Mac OS X server, do not wait for the
                          user to switch back to his display.
   -macwheel n            For the native Mac OS X server, set the mouse wheel
                          speed to n (default 5.)
   -macnoswap             For the native Mac OS X server, do not swap mouse
                          buttons 2 and 3.
   -macnoresize           For the native Mac OS X server, do not resize or rese
t
                          the framebuffer even if it is detected that the scree
n
                          resolution or depth has changed.
   -maciconanim n         For the native Mac OS X server, set n to the number
                          of milliseconds that the window iconify/deiconify
                          animation takes.  In -ncache mode this value will be
                          used to skip the animation if possible. (default 400)
   -macmenu               For the native Mac OS X server, in -ncache client-sid
e
                          caching mode, try to cache pull down menus (not perfe
ct
                          because they have animated fades, etc.)

   PasteBoard/Clipboard:   There is a bug that the Clipboard (called
   PasteBoard on Mac it appears) exchange will not take place unless
   x11vnc was started from inside the Aqua display (e.g. started inside a
   Terminal app window.) Otherwise it cannot connect to the PasteBoard
   server. So Clipboard exchange won't work for our standard "ssh in"
   startup scheme.

   Hopefully this deficiency can be removed, but until then for Clipboard
   exchange to work you will need to start x11vnc inside the desktop
   session (i.e. either start it running before you leave, or start up a
   2nd x11vnc inside from a 1st one started outside, or use the apple
   script below)

   Here also is a osascript trick that seems to work (it opens the
   Terminal app and instructs it to start x11vnc):

#!/bin/sh
#
# start_x11vnc: start x11vnc in a Terminal window
# (this will allow Clipboard/Pasteboard exchange to work)

tmp=/tmp/start_x11vnc.$$

cat > $tmp <<END

tell application "Terminal"
        activate
        do script with command "$HOME/x11vnc -rfbauth .vnc/passwd -ssl SAVE"
end tell

END

osascript $tmp
rm -f $tmp

   where you should customize the x11vnc command line to your needs and
   the full path to the binary. Save it in a file e.g. "start_x11vnc" and
   then after you SSH in just type "./start_x11vnc" (or have ssh run the
   command for you.) Then once you are connected via VNC, iconify the
   Terminal windows (you can't delete them since that will kill x11vnc.)

   Update Aug/2010: A user reports the following useful information:
This is not a problem on Mac OS X 10.6.x (Snow Leopard) when connecting
via ssh to start x11vnc.  And, on Mac OS X 10.5.x (Leopard), the problem
can be permanently eliminated by doing this:


sudo /usr/libexec/PlistBuddy -c 'delete :LimitLoadToSessionType' \
   -c 'add :LimitLoadToSessionType string Background' \
   /System/Library/LaunchAgents/com.apple.pboard.plist
# ignore any 'Delete: Entry, ":LimitLoadToSessionType", Does Not Exist' message

and then restarting (yes, you must restart not just log off).  But
ONLY do that for Mac OS X 10.5.x and NOT for 10.6.x (which doesn't
need it anyway).

   We recently got access to a MacOSX 10.6.4 (Snow Leopard) macbook and
   have confirmed that the above is correct.


   Q-120: Can x11vnc be used as a VNC reflector/repeater to improve
   performance for the case of a large number of simultaneous VNC viewers
   (e.g. classroom broadcasting or a large demo)?

   Yes, as of Feb/2007 there is the "-reflect host:N" option to connect
   to the VNC server "host:N" (either another x11vnc or any other VNC
   server) and re-export it. VNC viewers then connect to the x11vnc(s)
   running -reflect.

   The -reflect option is the same as: "-rawfb vnc:host:N". See the
   -rawfb description under "VNC HOST" for more details.

   You can replace "host:N" with "listen" or "listen:port" for reverse
   connections.

   One can set up a number of such reflectors/repeaters to spread the
   resource usage around, e.g.:
       C -------<-------|
       C -------<-------|
       C -------<-------|---- R -----|
       C -------<-------|            |
       C -------<-------|            |
                                     |
       C -------<-------|            |
       C -------<-------|            |
       C -------<-------|---- R -----|
       C -------<-------|            |
       C -------<-------|            |
                                     |====== S
       C -------<-------|            |
       C -------<-------|            |
       C -------<-------|---- R -----|
       C -------<-------|            |
       C -------<-------|            |
                                     |
       C -------<-------|            |
       C -------<-------|            |
       C -------<-------|---- R -----|
       C -------<-------|
       C -------<-------|

   Where "S" is the original VNC Server, "C" denote VNC viewer clients,
   and "R" denotes an x11vnc running -reflect to "S".

   Ideally, a client "C" will be fairly close network-wise to its "R". It
   is fine to run the "R" on the same machine as one of its "C's". A nice
   setup for a large, (e.g. 64-128) viewer classroom broadcast case would
   be to run R's on areas isolated by network switches, e.g. one R per
   switch.

   In an extreme case (e.g. 1000 viewers) one might actually need a 2nd
   layer of R's in the tree. If you try something like that let us know!

   There are many resource savings in doing something like the above. The
   first obvious one is network bandwidth savings. Another is less CPU
   load on "S" since it handles many fewer simultaneous connections.
   Also, if there are a few clients C on very slow links, their presence
   does not slow down every other client, just the clients on their "R".
   One way a slow client affects things is if there are some large
   framebuffer writes (e.g. jpeg image region) then the repeater may
   block waiting for that large write to finish before going onto the
   next client (however, if the write is small enough, the kernel will
   buffer it and the server can go on to service the next client.)

   The x11vnc -reflect implementation uses the libvncclient library in
   the LibVNCServer project to handle the connection to "S". It is not
   currently very efficient since it simply does its normal framebuffer
   polling scheme on the libvncclient framebuffer (which it then
   re-exports via VNC to its clients C.) However, CopyRect and
   CursorShape encodings are preserved in the reflection and that helps.
   Dragging windows with the mouse can be a problem (especially if S is
   not doing wireframing somehow, consider -nodragging if the problem is
   severe) For a really fast reflector/repeater it would have to be
   implemented from scratch with performance in mind. See these other
   projects:
    http://sourceforge.net/projects/vnc-reflector/,
    http://www.tightvnc.com/projector/                (closed source?),


   Automation via Reverse Connections:   Instead of having the R's
   connect directly to S and then the C's connect directly to the R they
   should use, some convenience can be achieved by using reverse
   connections (the x11vnc ""-connect host1,host2,..." option.) Suppose
   all the clients "C" are started up in Listen mode:
    client1>  vncviewer -listen
    client2>  vncviewer -listen
    client3>  vncviewer -listen
    ...
    client64> vncviewer -listen

   (e.g. client1> is the cmdline prompt on machine client1 ... etc) and
   all the repeaters R are started like this:
    repeater1> x11vnc -reflect listen -connect client1,client2,...client8
    repeater2> x11vnc -reflect listen -connect client9,client10,...client16
    ...
    repeater8> x11vnc -reflect listen -connect client57,client58,...client64

   and finally the main server is started to kick the whole thing into
   motion:
    vncserver> x11vnc -display :0 -connect repeater1,repeater2,...repeater8

   (or instruct a non-x11vnc VNC server to reverse connect to the
   repeaters.) For a classroom broadcasting setup one might have the
   first two sets of commands start automatically at bootup or when
   someone logs in, and then start everything up with the S server. One
   may even be able to script the forward connection bootstrap case, let
   us know what you did. A really nice thing would be some sort of
   auto-discovery of your repeater, etc...

   Q-121: Can x11vnc be used during a Linux, Solaris, etc. system
   Installation so the Installation can be done remotely?

   This can be done, but it doesn't always work because it depends on how
   the OS does its install. We have to "sneak in" somehow. Note that some
   OS's have a remote install (ssh etc.) built in and so you might want
   to use that instead.

   Usually the OS install will have to be a network-install in order to
   have networking up during the install. Otherwise, you may have a
   (slim) chance to configure the networking manually (ifconfig(8) and
   route(8).)

   To avoid library dependencies problems in the typical minimal (e.g.
   busybox) installation OS it is a good idea to build a statically
   linked x11vnc binary. A way that often works is to do a normal build
   and then paste the final x11vnc link line into a shell script. Then
   change the "gcc" to "gcc -static" and run the shell script. You may
   need to disable features (e.g. "--without-xfixes") if there is not a
   static library for the feature available. You may also need to add
   extra link options (e.g. "-lXrender") to complete library dependencies
   manually.

   Let's call the binary x11vnc.static. Place it on a webserver
   somewhere. It may be possible to retrieve it via scp(1) too.

   During the install you need to get a shell to retreive x11vnc.static
   and run it.

   If the Solaris install is an older X-based one, there will be a menu
   for you to get a terminal window. From that window you might be able
   to retrieve x11vnc.static via wget, scp, or ftp. Remember to do "chmod
   755 ./x11vnc.static" and then find the -auth file as in this FAQ.

   If it is a Linux install that uses an X server (e.g. SuSE and probably
   Fedora), then you can often get a shell by pressing Ctrl-Alt-F2 or
   similar. Then get the x11vnc binary via something like this:
   cd /tmp
   wget http://192.168.0.22/x11vnc.static
   chmod 755 ./x11vnc.static

   Find the name of the auth file as in this FAQ. (maybe run "ps wwaux |
   grep auth".) Then run it like this:
   ./x11vnc.static -forever -nopw -display :0 -auth /tmp/wherever/the/authfile

   then press Alt-F7 to go back to the X install. You should now be able
   to connect via a vnc viewer and continue the install. Watch out for
   the display being :1, etc.

   If there is a firewall blocking incoming connections during the
   install, use the "-connect hostname" option option for a reverse
   connection to the hostname running the VNC viewer in listen mode.

   Debian based installs are either console-text or console-framebuffer
   based. These are install (or expert) and installgui (or expertgui)
   boot lines, respectively. For the console-text based installs you
   probably need to add a boot cmd line option like vga=0x314 (which is
   800x600x16) to get the console-text to use the linux framebuffer
   device properly.

   For a Debian console-text based install after the network is
   configured press Ctrl-Alt-F2 to get a shell. Retrieve the binary via
   wget as above and chmod 755 it. Then run it something like this:
   sleep 10; ./x11vnc.static -forever -nopw -rawfb console

   then before the sleep is over press Alt-F1 to get back to the install
   virtual console. You should be able to connect via a VNC viewer and
   continue with the install.

   For a recent (2009) Debian install we booted with "expert vga=0x301"
   and "expert vga=0x311" to get console text based installs at 640x480x8
   and 640x480x16, respectively (replace "expert" with "install" if you
   like.) Otherwise it was giving a 16 color 640x480x4 (4 bit per pixel)
   display which x11vnc could not handle.

   For Debian console-framebuffer GUI based installs (installgui or
   expertgui) we have not be able to enter keystrokes or mouse motions.
   This may be resolved if the install had the Linux kernel module
   uinput, but it doesn't; one can wget uinput.ko and then run insmod on
   it, but the module must match the installation kernel. So, failing
   that, you can only do the GUI view-only, which can be handy to watch a
   long network install from your desk instead of in front of the machine
   being installed. For these, after the network is configured press
   Ctrl-Alt-F2 to get a shell. Retrieve the binary via wget as above and
   chmod 755 it. Then run it something like this:
   sleep 10; ./x11vnc.static -forever -nopw -rawfb console

   then before the sleep is over press Alt-F5 to get back to the GUI
   install console. You should be able to connect via a VNC viewer and
   watch the install.
   [Misc: Clipboard, File Transfer/Sharing, Printing, Sound, Beeps,
   Thanks, etc.]

   Q-122: Does the Clipboard/Selection get transferred between the
   vncviewer and the X display?

   As of Jan/2004 x11vnc supports the "CutText" part of the RFB (aka VNC)
   protocol. When text is selected/copied in the X session that x11vnc is
   polling it will be sent to connected VNC viewers. And when CutText is
   received from a VNC viewer then x11vnc will set the X11 selections
   PRIMARY, CLIPBOARD, and CUTBUFFER0 to it. x11vnc is able to hold the
   PRIMARY and CLIPBOARD selections (Xvnc does not seem to do this.)

   The X11 selections can be confusing, especially to those coming from
   Windows or MacOSX where there is just a single 'Clipboard'. The X11
   CLIPBOARD selection is a lot like that of Windows and MacOSX, e.g.
   highlighted text is sent to the clipboard when the user activates
   "Edit -> Copy" or presses "Control+C" (and pasting it via "Edit ->
   Paste" or "Control+V".) The X11 PRIMARY selection has been described
   as 'for power users' or 'an Easter Egg'. As soon as text is
   highlighted it is set to the PRIMARY selection and so it is
   immediately ready for pasting, usually via the Middle Mouse Button or
   "Shift+Insert". See this jwz link for more information.

   x11vnc's default behavior is to watch both CLIPBOARD and PRIMARY and
   whenever one of them changes, it sends the new text to connected
   viewers. Note that since the RFB protocol only has a single "CutText"
   then both selections are "merged" to some degree (and this can lead to
   confusing results.) One user was confused why x11vnc was "forgetting"
   his CLIPBOARD selection and the reason was he also changed PRIMARY
   some time after he copied text to the clipboard. Usually an app will
   set PRIMARY as soon as any text is highlighted so it easy to see how
   CLIPBOARD was forgotten. Use the -noprimary described below as a
   workaround. Similarly, by default when x11vnc receives CutText it sets
   both CLIPBOARD and PRIMARY to it (this is probably less confusing, but
   could possibly lead to some failure modes as well.)

   You may not like these defaults. Here are ways to change the behavior:
     * If you don't want the Clipboard/Selection exchanged at all use the
       -nosel option.
     * If you want changes in PRIMARY to be ignored use the -noprimary
       option.
     * If you want changes in CLIPBOARD to be ignored use the
       -noclipboard option.
     * If you don't want x11vnc to set PRIMARY to the "CutText" received
       from viewers use the -nosetprimary option.
     * If you don't want x11vnc to set CLIPBOARD to the "CutText"
       received from viewers use the -nosetclipboard option.

   You can also fine-tune it a bit with the -seldir dir option and also
   -input.

   You may need to watch out for desktop utilities such as KDE's
   "Klipper" that do odd things with the selection, clipboard, and
   cutbuffers.


   Q-123: Can I use x11vnc to record a Shock Wave Flash (or other format)
   video of my desktop, e.g. to record a tutorial or demo?

   Yes, it is possible with a number of tools that record VNC and
   transform it to swf format or others. One such popular tool is
   pyvnc2swf. There are a number of tutorials (broken link?) on how to do
   this. Another option is to use the vnc2mpg that comes in the
   LibVNCServer package.
   An important thing to remember when doing this is that tuning
   parameters should be applied to x11vnc to speed up its polling for
   this sort of application, e.g. "-wait 10 -defer 10".

   Q-124: Can I transfer files back and forth with x11vnc?

   As of Oct/2005 and May/2006 x11vnc enables, respectively, the TightVNC
   and UltraVNC file transfer implementations that were added to
   libvncserver. This currently works with TightVNC and UltraVNC viewers
   (and Windows viewers only support filetransfer it appears... but they
   do work to some degree under Wine on Linux.)

   The SSVNC Unix VNC viewer supports UltraVNC file transfer by use of a
   Java helper program.

   TightVNC file transfer is off by default, if you want to enable it use
   the -tightfilexfer option.

   UltraVNC file transfer is off by default, to enable it use something
   like "-rfbversion 3.6 -permitfiletransfer"
   options (UltraVNC incorrectly uses the RFB protocol version to
   determine if its features are available, so x11vnc has to pretend to
   be version 3.6.) As of Sep/2006 "-ultrafilexfer" is an alias for these
   two options. Note that running as RFB version 3.6 may confuse other
   VNC Viewers.

   Sadly you cannot do both -tightfilexfer and -ultrafilexfer at the same
   time because the latter requires setting the version to 3.6 and
   tightvnc will not do filetransfer when it sees that version number.

   Also, because of the way the LibVNCServer TightVNC file transfer is
   implemented, you cannot do Tightvnc file transfer in -unixpw mode.
   However, UltraVNC file transfer does work in -unixpw (but if a client
   tries it do a filetransfer during the login process it will be
   disconnected.)

   IMPORTANT: please understand if -ultrafilexfer or -tightfilexfer is
   specified and you run x11vnc as root for, say, inetd or display
   manager (gdm, kdm, ...) access and you do not have it switch users via
   the -users option, then VNC Viewers that connect are able to do
   filetransfer reads and writes as *root*.

   The UltraVNC and TightVNC settings can be toggled on and off inside
   the gui or by -R remote control. However for TightVNC the changed
   setting only applies for NEW clients, current clients retain their
   TightVNC file transfer ability. For UltraVNC it works better, however
   if an UltraVNC client has initiated a file transfer dialog it will
   remain in effect until the dialog is closed. If you want to switch
   between UltraVNC and TightVNC file transfer in the gui or by remote
   control you will probably be foiled by the "-rfbversion 3.6" issue.


   Q-125: Which UltraVNC extensions are supported?

   Some of them are supported. To get UltraVNC Viewers to attempt to use
   these extensions you will need to supply this option to x11vnc:
   -rfbversion 3.6

   Or use -ultrafilexfer which is an alias for the above option and
   "-permitfiletransfer". UltraVNC evidently treats any other RFB version
   number as non-UltraVNC.

   Here are a list of the UltraVNC extensions supported by x11vnc:
     * ServerInput: "Toggle Remote Input and Remote Blank Monitor"
     * FileTransfer: "Open File Transfer..."
     * SingleWindow: "Select Single Window..."
     * TextChat: "Open Chat..."
     * 1/n Server Scaling

   The SSVNC Unix VNC viewer supports these UltraVNC extensions.

   To disable SingleWindow and ServerInput use -noultraext (the others
   are managed by LibVNCServer.) See this option too: -noserverdpms.

   Also, the UltraVNC repeater proxy is supported for use with reverse
   connections: "-connect repeater://host:port+ID:NNNN". Use it for both
   plaintext and SSL connections. This mode can send any string before
   switching to the VNC protocol, and so could be used with other
   proxy/gateway tools. Also, a perl repeater implemention is here:
   ultravnc_repeater.pl


   Q-126: Can x11vnc emulate UltraVNC's Single Click helpdesk mode for
   Unix? I.e. something very simple for a naive user to initiate a
   reverse vnc connection from their Unix desktop to a helpdesk
   operator's VNC Viewer.

   Yes, UltraVNC's Single Click (SC) mode can be emulated fairly well on
   Unix.

   We use the term "helpdesk" below, but it could be any sort of remote
   assistance you want to set up, e.g. something for Unix-using friends
   or family to use. This includes Mac OS X.

   Assume you create a helpdesk directory "hd" on your website:
   http://www.mysite.com/hd (any website that you can upload files to
   should work, although remember the user will be running the programs
   you place there.)

   In that "hd" subdirectory copy an x11vnc binary to be run on the Unix
   user's machine (e.g. Linux, etc) and also create a file named "vnc"
   containing the following:
#!/bin/sh

webhost="http://www.mysite.com/hd"  # Your helpdesk dir URL.

vnchost="ip.someplace.net"          # Your host running 'vncviewer -listen'
                                    # It could also be your IP number. If it is
                                    # a router/firewall, you will need to
                                    # configure it to redirect port 5500 to you
r
                                    # workstation running 'vncviewer -listen'

dir=/tmp/vnc_helpdesk.$$            # Make a temporary working dir.
mkdir $dir || exit 1
cd $dir || exit 1

trap "cd /tmp; rm -rf $dir" 0 2 15  # Cleans up on exit.

wget $webhost/x11vnc                # Fetch x11vnc binary.  If multi-
chmod 755 ./x11vnc                  # platform, use $webhost/`uname`/x11vnc
                                    # or similar.

./x11vnc -connect_or_exit $vnchost -rfbport 0 -nopw

   with the hostnames / IP addresses customized to your case.

   On the helpdesk VNC viewer machine (ip.someplace.net in this example)
   you have the helpdesk operator running VNC viewer in listen mode:
   vncviewer -listen

   or if on Windows, etc. somehow have the VNC viewer be in "listen"
   mode.

   Then, when the naive user needs assistance you instruct him to open up
   a terminal window on his Unix desktop and paste the following into the
   shell:
   wget -qO - http://www.mysite.com/hd/vnc | sh -

   and then press Enter. You could have this instruction on a web page or
   in an email you send him, etc. This requires that the wget is
   installed on the user's Unix machine (he might only have curl or lynx,
   see below for more info.)


   So I guess this is about 3-4 clicks (start a terminal and paste) and
   pressing "Enter" instead of "single click"...

   See this page for some variations on this method, e.g. how to add a
   password, SSL Certificates, etc.


   If you don't have a website (there are many free ones) or don't want
   to use one you will have to email him all of the ingredients (x11vnc
   binary and a launcher script) and tell him how to run it. This could
   be easy or challenging depending on the skill of the naive unix
   user...

   A bit of obscurity security could be put in with a -passwd, -rfbauth
   options, etc. (note that x11vnc will require a password even for
   reverse connections.) More info here.


   Firewalls: If the helpdesk (you) with the vncviewer is behind a
   NAT/Firewall/Router the router will have to be configured to redirect
   a port (i.e. 5500 or maybe different one if you like) to the vncviewer
   machine. If the vncviewer machine also has its own host-level
   firewall, you will have to open up the port there as well.

   NAT-2-NAT: There is currently no way to go "NAT-2-NAT", i.e. both User
   and Helpdesk workstations behind NAT'ing Firewall/Routers without
   configuring a router to do a port redirection (i.e. on your side, the
   HelpDesk.) To avoid modifying either firewall/router, one would need
   some public (IP address reachable on the internet) redirection/proxy
   service. Perhaps such a thing exists. http://sc.uvnc.com provides this
   service for their UltraVNC Single Click users.

   Update: It may be possible to do "NAT-2-NAT" with a UDP tunnel such as
   http://samy.pl/pwnat/. All that is required is that both NAT firewalls
   allow in UDP packets from an IP address to which a UDP packet has
   recently been sent to. If you try it out let us know how it went.


   Very Naive Users:

   If it is beyond the user how to open a terminal window and paste in a
   command (you have my condolences...) you would have to somehow setup
   his Web browser to download the "vnc" file (or a script containing the
   above wget line) and prompt the user if he wants to run it. This may
   be tricky to set up (which is probably a good thing to not have the
   web browser readily run arbitrary programs downloaded from the
   internet...)

   One command-line free way, tested with KDE, is to name the file vnc.sh
   and then instruct the user to right-click on the link and do "Save
   Link As" to his Desktop. It will appear as an icon, probably one that
   looks like a terminal or a command line prompt. He next should
   right-click on the icon and select "Properties" and go to the
   "Permissions" tab. Then in that dialog select the checkbox "Is
   executable". He should then be able to click on the icon to launch it.
   Another option is to right-click on the icon and select "Open With ->
   Other ..." and for the name of the application type in "/bin/sh".
   Unfortunately in both cases the command output is lost and so errors
   cannot be debugged as easily. A similar thing appears to work in GNOME
   if under "Properties -> Permissions" they click on "Execute" checkbox
   for "Owner". Then when they click on the icon, they will get a dialog
   where they can select "Run in Terminal". In general for such cases, if
   it is feasible, it might be easier to ssh to his machine and set
   things up yourself...


   SSL Encrypted Helpdesk Connections:

   As of Apr/2007 x11vnc supports reverse connections in SSL and so we
   can do this. On the Helpdesk side (Viewer) you will need STUNNEL or
   better use the Enhanced TightVNC Viewer (SSVNC) package we provide
   that automates all of the SSL for you.

   To do this create a file named "vncs" in the website "hd" directory
   containing the following:
#!/bin/sh

webhost="http://www.mysite.com/hd"  # Your helpdesk dir URL.

vnchost="ip.someplace.net"          # Your host running 'vncviewer -listen'
                                    # It could also be your IP number. If it is
                                    # a router/firewall, you will need to
                                    # configure it to redirect port 5500 to you
r
                                    # workstation running 'vncviewer -listen'

dir=/tmp/vnc_helpdesk.$$            # Make a temporary working dir.
mkdir $dir || exit 1
cd $dir || exit 1

trap "cd /tmp; rm -rf $dir" 0 2 15  # Cleans up on exit.

wget $webhost/x11vnc                # Fetch x11vnc binary.  If multi-
chmod 755 ./x11vnc                  # platform, use $webhost/`uname`/x11vnc
                                    # or similar.

./x11vnc -connect_or_exit $vnchost -rfbport 0 -nopw -ssl    # Note -ssl option.

   with the hostnames or IP addresses customized to your case.

   The only change from the "vnc" above is the addition of the -ssl
   option to x11vnc. This will create a temporary SSL cert: openssl(1)
   will need to be installed on the user's end. A fixed SSL cert file
   could be used to avoid this (and provide some authentication; more
   info here.)

   The naive user will be doing this:
   wget -qO - http://www.mysite.com/hd/vncs | sh -

   (or perhaps even use https:// if available.)

   But before that, the helpdesk operator needs to have "vncviewer
   -listen" running as before, however he needs an SSL tunnel at his end.
   The easiest way to do this is use Enhanced TightVNC Viewer (SSVNC).
   Start it, and select Options -> 'Reverse VNC Connection (-listen)'.
   Then UN-select 'Verify All Certs' (this can be enabled later if you
   want; you'll need the x11vnc SSL certificate), and click 'Listen'.

   If you don't want to use SSVNC for the viewer, but rather set up
   STUNNEL manually instead, make a file "stunnel.cfg" containing:
foreground = yes
pid =

[vnc]
accept = 5500
connect = localhost:5501

   and run:
  stunnel ./stunnel.cfg

   and then start the "vncviewer -listen 1" (i.e. 1 to correspond to the
   5501 port.) Note that this assumes the stunnel install created a
   Server SSL cert+key, usually /etc/stunnel/stunnel.pem (not all distros
   will do this.) Also, that file is by default only readable by root, so
   stunnel needs to be run as root. If your system does not have a key
   installed or you do not want to run stunnel as root (or change the
   permissions on the file), you can use x11vnc to create one for you for
   example:
  x11vnc -sslGenCert server self:mystunnel

   answer the prompts with whatever you want; you can take the default
   for all of them if you like. The openssl(1) package must be installed.
   See this link and this one too for more info on SSL certs. This
   creates $HOME/.vnc/certs/server-self:mystunnel.pem, then you would
   change the "stunnel.cfg" to look something like:
foreground = yes
pid =
cert = /home/myusername/.vnc/certs/server-self:mystunnel.pem

[vnc]
accept = 5500
connect = localhost:5501

   In any event, with stunnel having been setup, the naive user is
   instructed to paste in and run:
   wget -qO - http://www.mysite.com/hd/vncs | sh -

   to pick up the vncs script this time.

   Of course if a man-in-the-middle can alter what the user downloads
   then all bets are off!.

   More SSL variations and info about certificates can be found here.


   OpenSSL libssl.so.0.9.7 problems:

   If you build your own stunnel or x11vnc for deployment, you may want
   to statically link libssl.a and libcrypto.a into it because Linux
   distros are currently a bit of a mess regarding which version of
   libssl is installed.

   You will find the details here.


   Q-127: Can I (temporarily) mount my local (viewer-side) Windows/Samba
   File share on the machine where x11vnc is running?

   You will have to use an external network redirection for this.
   Filesystem mounting is not part of the VNC protocol.

   We show a simple Samba example here.

   First you will need a tunnel to redirect the SMB requests from the
   remote machine to the one you sitting at. We use an ssh tunnel:
  sitting-here> ssh -C -R 1139:localhost:139 far-away.east

   Or one could combine this with the VNC tunnel at the same time, e.g.:
  sitting-here> ssh -C -R 1139:localhost:139 -t -L 5900:localhost:5900 far-away
.east 'x11vnc -localhost -display :0'

   Port 139 is the Windows Service port. For Windows systems instead of
   Samba, you may need to use the actual IP address of the Window machine
   instead of "localhost" in the -R option (since the Windows service
   does not listen on localhost by default.)

   Note that we use 1139 instead of 139 on the remote side because 139
   would require root permission to listen on (and you may have a samba
   server running on it already.)

   The ssh -C is to enable compression, which might speed up the data
   transfers.

   Depending on the remote system side configuration, it may or may not
   be possible to mount the SMB share as a non-root user. Try it first as
   a non-root user and if that fails you will have to become root.

   We will assume the user name is "fred" and we will try to mount the
   viewer-side Windows SMB share "//haystack/pub" in
   /home/fred/smb-haystack-pub.
  far-away> mkdir -p /home/fred/smb-haystack-pub
  far-away> smbmount //haystack/pub /home/fred/smb-haystack-pub -o username=fre
d,ip=127.0.0.1,port=1139

   (The 2nd command may need to be run as root.) Then run "df" or "ls -l
   /home/fred/smb-haystack-pub" to see if it is mounted properly. Consult
   the smbmount(8) and related documentation (it may require some
   fiddling to get write permissions correct, etc.) To unmount:
  far-away> smbumount /home/fred/smb-haystack-pub

   At some point we hope to fold some automation for SMB ssh redir setup
   into the Enhanced TightVNC Viewer (SSVNC) package we provide (as of
   Sep 2006 it is there for testing.)


   Q-128: Can I redirect CUPS print jobs from the remote desktop where
   x11vnc is running to a printer on my local (viewer-side) machine?

   You will have to use an external network redirection for this.
   Printing is not part of the VNC protocol.

   We show a simple Unix to Unix CUPS example here. Non-CUPS port
   redirections (e.g. LPD) should also be possible, but may be a bit more
   tricky. If you are viewing on Windows SMB and don't have a local cups
   server it may be trickier still (see below.)

   First you will need a tunnel to redirect the print requests from the
   remote machine to the one you sitting at. We use an ssh tunnel:
  sitting-here> ssh -C -R 6631:localhost:631 far-away.east

   Or one could combine this with the VNC tunnel at the same time, e.g.:
  sitting-here> ssh -C -R 6631:localhost:631 -t -L 5900:localhost:5900 far-away
.east 'x11vnc -localhost -display :0'

   Port 631 is the default CUPS port. The above assumes you have a Cups
   server running on your viewer machine (localhost:631), if not, use
   something like my-cups-srv:631 (the viewer-side Cups server) in the -R
   instead.

   Note that we use 6631 instead of 631 on the remote side because 631
   would require root permission to listen on (and you likely have a cups
   server running on it already.)

   Now the tricky part: to get applications to notice your cups
   server/printer on localhost:6631.

   If you have administrative privilege (i.e. root password) on the
   x11vnc side where the desktop is running, it should be easy to add the
   printer through some configuration utility (e.g. in KDE: Utilities ->
   Printing -> Printing Manager, and then supply admin password, and then
   Add Printer/Class, and then fill in the inquisitive wizard. Most
   important is the "Remote IPP server" panel where you put in localhost
   for Host and 6631 for Port.) The main setting you want to convey is
   the host is localhost and the port is non-standard (e.g. 6631.) Some
   configuration utilities will take an Internet Printing Protocol (IPP)
   URI, e.g. http://localhost:6631/printers/,
   ipp://localhost:6631/printers/printer-name,
   ipp://localhost:6631/ipp/printer-name, etc. Check your CUPS
   documentation and admin interfaces to find what the syntax is and what
   the "printer name" is.

   If you do not have root or print admin privileges, but are running a
   recent (version 1.2 or greater) of the Cups client software, then an
   easy way to temporarily switch Cups servers is to create the directory
   and file: $HOME/.cups/client.conf on the remote side with a line like:
  ServerName localhost:6631

   When not using x11vnc for remote access you can comment the above line
   out with a '#' (or rename the client.conf file), to have normal cups
   operation.

   Unfortunately, running applications may need to be restarted to notice
   the new printers (libcups does not track changes in client.conf.)
   Depending on circumstances, a running application may actually notice
   the new printers without restarting (e.g. no print dialog has taken
   place yet, or there are no CUPS printers configured on the remote
   side.)

   Cups client software that is older (1.1) does not support appending
   the port number, and for newer ones there is a bug preventing it from
   always working (fixed in 1.2.3.) Kludges like these at the command
   line will work:
  far-away> env CUPS_SERVER=localhost IPP_PORT=6631 lpstat -p -d
  far-away> env CUPS_SERVER=localhost IPP_PORT=6631 lpr -P myprinter file.ps
  far-away> env CUPS_SERVER=localhost IPP_PORT=6631 firefox

   but are somewhat awkward since you have to retroactively set the env.
   var IPP_PORT. Its value cannot be broadcast to already running apps
   (like the $HOME/.cups/client.conf trick sometimes does.) A common
   workaround for an already running app is to somehow get it to "Print
   To File", e.g. file.ps and then use something like the lpr example
   above. Also, the option "-h host:port" works with CUPS lp(1) and
   lpr(1).

   You can also print to Windows shares printers in principle. You may do
   this with the smbspool(8) command, or configure the remote CUPS via
   lpadmin(8), etc, to use a printer URI something like
   smb://machine:port/printer (this may have some name resolution
   problems WRT localhost.) Also, as with SMB mounting, the port redir
   (-R) to the Windows machine must use the actual IP address instead of
   "localhost".

   At some point we hope to fold some automation for CUPS ssh redir setup
   into the Enhanced TightVNC Viewer (SSVNC) package we provide (as of
   Sep 2006 it is there for testing.)


   Q-129: How can I hear the sound (audio) from the remote applications
   on the desktop I am viewing via x11vnc?

   You will have to use an external network audio mechanism for this.
   Audio is not part of the VNC protocol.

   We show a simple Unix to Unix esd example here (artsd should be
   possible too, we have also verified the esd Windows port works for the
   method described below.)

   First you will need a tunnel to redirect the audio from the remote
   machine to the one you sitting at. We use an ssh tunnel:
  sitting-here> ssh -C -R 16001:localhost:16001 far-away.east

   Or one could combine this with the VNC tunnel at the same time, e.g.:
  sitting-here> ssh -C -R 16001:localhost:16001 -t -L 5900:localhost:5900 far-a
way.east 'x11vnc -localhost -display :0'

   Port 16001 is the default ESD uses. So when an application on the
   remote desktop makes a sound it will connect to this tunnel and be
   redirected to port 16001 on the local machine (sitting-here in this
   example.) The -C option is an attempt to compress the audio a little
   bit.

   So we next need a local (sitting-here) esd daemon running that will
   receive those requests and play them on the local sound device:
  sitting-here> esd -promiscuous -port 16001 -tcp -bind 127.0.0.1

   See the esd(1) man page for the meaning of the options (the above are
   not very secure.) (This method also works with the EsounD windows port
   esd.exe)

   To test this sound tunnel, we use the esdplay program to play a simple
   .wav file:
  far-away> esdplay -s localhost:16001 im_so_happy.wav

   If you hear the sound (Captain Kirk in this example), that means you
   are in great shape.

   To run individual audio applications you can use the esddsp(1)
   command:
  far-away> esddsp -s localhost:16001 xmms

   Then you could try playing some sounds inside xmms. You could also set
   the environment variable ESPEAKER=localhost:16001 to not need to
   supply the -s option all the time. (for reasons not clear, sometimes
   esddsp can figure it out on its own.) All the script esddsp does is to
   set ESPEAKER and LD_PRELOAD for you so that when the application opens
   the sound device (usually /dev/dsp) its interactions with the device
   will be intercepted and sent to the esd daemon running on sitting-here
   (that in turn writes them to the real, local /dev/dsp.)

   Redirecting All sound:

   It does not seem to be possible to switch all of the sound of the
   remote machine from its sound device to the above esd+ssh tunnel
   without some preparation. But it can be done reasonably well if you
   prepare (i.e. restart) the desktop with this in mind.

   Here is one way to redirect all sound. The idea is we run the entire
   desktop with sound directed to localhost:16001. When we are sitting at
   far-away.east we run "esd -promiscuous -port 16001 -tcp -bind
   127.0.0.1" on far-away.east (to be able to hear the sound.) However,
   when we are sitting at sitting-here.west we kill that esd process and
   run that same esd command on sitting-here.west and start up the above
   ssh tunnel. This is a little awkward, but with some scripts one would
   probably kill and restart the esd processes automatically when x11vnc
   is used.

   So next we have to run the whole desktop pointing toward our esd. Here
   is a simple way to test. Log in to the machine via the "FailSafe"
   desktop. Then in the lone terminal type something like:
  esddsp -s localhost:16001 gnome-session
or:
  esddsp -s localhost:16001 startkde

   where the last part is whatever command starts your desktop (even
   fvwm2.) This causes the environment variables ESPEAKER and LD_PRELOAD
   to be set appropriately and every application (processes with the
   desktop as an ancestor) will use them. If this scheme works well you
   can make it less klunky by adding the command to your ~/.xsession,
   etc. file that starts your default desktop. Or you may be able to
   configure your desktop to use localhost:16001, or whatever is needed,
   via a gui configuration panel. Some Notes:
     * Not all audio applications are compatible with the esd and artsd
       mechanisms, but many are.
     * The audio is not compressed so you probably need a broadband or
       faster connection. Listening to music may not be very pleasant...
       (Although we found streaming music from across the US over cable
       modem worked OK, but took 200 KB/sec, to use less bandwidth
       consider something like "ssh far-away.east 'cat favorite.mp3' |
       mpg123 -b 4000 -")
     * Linux does not seem to have the concept of LD_PRELOAD_64 so if you
       run on a mixed 64- and 32-bit ABI system (e.g. AMD x86_64) some of
       the applications will fail to run because LD_PRELOAD will point to
       libraries of the wrong wordsize.
     * At some point we hope to fold some automation for esd or artsd ssh
       redir setup into the Enhanced TightVNC Viewer (SSVNC) package we
       provide (as of Sep/2006 it is there for testing.)


   Q-130: Why don't I hear the "Beeps" in my X session (e.g. when typing
   tput bel in an xterm)?

   As of Dec/2003 "Beep" XBell events are tracked by default. The X
   server must support the XKEYBOARD extension (this is not on by default
   in Solaris, see Xserver(1) for how to turn it on via +kb), and so you
   won't hear them if the extension is not present.

   If you don't want to hear the beeps use the -nobell option. If you
   want to hear the audio from the remote applications, consider trying a
   redirector such as esd.


   Q-131: Does x11vnc work with IPv6?

   Update: as of Apr/2010 in the 0.9.10 x11vnc development tarball, there
   is now built-in support for IPv6 (128 bit internet addresses.) See the
   -6 and -connect options for details.

   The remainder of this FAQ entry shows how to do with this with pre
   0.9.10 x11vnc using IPv6 helper tools.
     _________________________________________________________________

   Using an external IPv6 helper:
   A way to do this is via a separate helper program such as inetd (or
   for encrypted connections: ssh or stunnel.) For example, you configure
   x11vnc to be run from inetd or xinetd and instruct it to listen on an
   IPv6 address. For xinetd the setting "flags = IPv6" will be needed.
   For inetd.conf, an example is:
  5900 stream tcp6 nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc_wrapper.sh

   We also provide a transitional tool in "x11vnc/misc/inet6to4" that
   acts as a relay for any IPv4 application to allow connections over
   IPv6. For example:
  inet6to4 5900 localhost:5900

   where x11vnc is listening on IPv4 port 5900.

   Also note that not all VNC Viewers are IPv6 enabled, so a redirector
   may also be needed for them. The tool "inet6to4 -r ..." can do this as
   well. SSVNC (see below) supports IPv6 without need for the helper.

  # ./inet6to4 -help

  inet6to4:  Act as an ipv6-to-ipv4 relay for tcp applications that
             do not support ipv6.

  Usage:     inet6to4
             inet6to4 -r

  Examples:  inet6to4 5900 localhost:5900
             inet6to4 8080 web1:80
             inet6to4 -r 5900 fe80::217:f2ff:fee6:6f5a%eth0:5900

  The -r option reverses the direction of translation (e.g. for ipv4
  clients that need to connect to ipv6 servers.)  Reversing is the default
  if this script is named 'inet4to6' (e.g. by a symlink.)

  Use Ctrl-C to stop this program.

  You can also set env. vars INET6TO4_LOOP=1 or INET6TO4_LOOP=BG
  to have an outer loop restarting this program (BG means do that
  in the background), and INET6TO4_LOGFILE for a log file.
  Also set INET6TO4_VERBOSE to verbosity level and INET6TO4_WAITTIME
  and INET6TO4_PIDFILE (see below.)

   The "INET6TO4_LOOP=BG" and "INET6TO4_LOGFILE=..." env. variables make
   the tool run reliably as a daemon for very long periods. Read the top
   part of the script for more information.
     _________________________________________________________________

   Encrypted Tunnels with IPv6 Support:
   For SSH tunnelled encrypted VNC connections, one can of course use the
   IPv6 support in ssh(1).

   For SSL encrypted VNC connections, one possibility is to use the IPv6
   support in stunnel(1). This includes the built-in support via the
   -stunnel option. For example:
  x11vnc -stunnel SAVE -env STUNNEL_LISTEN=:: -env STUNNEL_DEBUG=1 ...
     _________________________________________________________________

   SSH IPv6 Tricks:
   It is interesting to note that ssh(1) can do basically the same thing
   as inet6to4 above by:
  ssh -g -L 5900:localhost:5901 localhost "printf 'Press Enter to Exit: '; read
 x"

   (where we have x11vnc running via "-rfbport 5901" in this case.)

   Note that one can also make a home-brew SOCKS5 ipv4-to-ipv6 gateway
   proxy using ssh like this:
  ssh -D '*:1080' localhost "printf 'Press Enter to Exit: '; read x"

   then specify a proxy like socks://hostname:1080 where hostname is the
   machine running the above ssh command (add -v to ssh for connection
   logging info.)
     _________________________________________________________________

   IPv6 SSVNC Viewer:
   Our SSVNC VNC Viewer is basically a wrapper for ssh(1) and stunnel(1),
   and so it already has good IPv6 support because these two commands do.
   On Unix, MacOSX, and Windows nearly all of the the remaining parts of
   SSVNC (e.g. the built-in proxying and un-encrypted connections) have
   been modified to support IPv6 in SSVNC 1.0.26.






    Contributions:

   Q-132: Thanks for your program or for your help! Can I make a
   donation?

   Please do (any amount is appreciated; very few have donated) and thank
   you for your support! Click on the PayPal button below for more info.

   [x-click-but04.gif]-Submit


   Q-133: I am experiencing extreme framebuffer update lags and am
   using an Intel graphics card. What to do?

   Depending on your graphics card model and x.org driver used, several
   approaches might work out for you:

   Some users [have reported](https://github.com/LibVNC/x11vnc/issues/58)
   that when using the 'intel' x.org driver, switching  the driver's
   option named "AccelMethod" to "UXA" helped.

   Others [reported](https://github.com/LibVNC/x11vnc/issues/100) that
   using the 'modesetting' x.org driver caused the lags and switching to
   the 'intel' x.org driver helped.

   Some [reported](https://github.com/LibVNC/x11vnc/issues/102) that
   lags only occured with xfwm as window manager and with x11vnc started
   with monitors off, no matter what the x.org driver. In their case, one
   of disabling vsync, using 'modesetting' with "AccelMethod" "none" or
   disabling compositing all helped.


=======================================================================
http://www.karlrunge.com/x11vnc/chainingssh.html:


     _________________________________________________________________

   Chaining ssh's: Note that for use of a ssh gateway and -L redirection
   to an internal host (e.g. "-L 5900:otherhost:5900") the VNC traffic
   inside the firewall is not encrypted and you have to manually log into
   otherhost to start x11vnc. Kyle Amon shows a method where you chain
   two ssh's together that encrypts all network traffic and also
   automatically starts up x11vnc on the internal workstation:
#!/bin/sh
#
gateway="example.com"   # or "user@example.com"
host="labyrinth"        # or "user@hostname"
user="kyle"

# Need to sleep long enough for all of the passwords and x11vnc to start up.
# The </dev/null below makes the vncviewer prompt for passwd via popup window.
#
(sleep 10; vncviewer -encodings "copyrect tight zrle zlib hextile" \
    localhost:0 </dev/null >/dev/null) &

# Chain the vnc connection thru 2 ssh's, and connect x11vnc to user's display:
#
exec /usr/bin/ssh -t -L 5900:localhost:5900 $gateway \
     /usr/bin/ssh -t -L 5900:localhost:5900 $host \
     sudo /usr/bin/x11vnc -localhost -auth /home/$user/.Xauthority \
         -rfbauth .vnc/passwd -display :0

   Also note the use of sudo(1) to switch to root so that the different
   user's .Xauthority file can be accessed. See the visudo(8) manpage for
   details on how to set this up (remove the sudo if you do not want to
   do this). One can also chain together ssh's for reverse connections
   with vncviewers using the -listen option. For this case -R would
   replace the -L (and 5500 the 5900, see the #2 example script above).
   If the gateway machine's sshd is configured with GatewayPorts=no (the
   default) then the double chaining of "ssh -R ..." will be required for
   reverse connections to work.
	
=======================================================================
http://www.karlrunge.com/x11vnc/miscbuild.html:


     _________________________________________________________________

   Misc. Build problems:   We collect here rare build problems some users
   have reported and the corresponding workarounds. See also the FAQ's on
   building.
     _________________________________________________________________

   ENV parameter: One user had a problem where the build script below was
   failing because his work environment had the ENV variable set to a
   script that was resetting his PATH so that gcc could no longer be
   found. Make sure you do not have any ENV or BASH_ENV in your
   environment doing things like that. Typing "unset ENV", etc. before
   configuring and building should clear it.
     _________________________________________________________________

   Bash xpg: One user had his bash shell compiled with
   --enable-xpg-echo-default that causes some strange behavior with
   things like echo "\\1 ..." the configure script executes. In
   particular instead of getting "\1" the non-printable character "^A" is
   produced, and causes failures at compile time like:
  ../rfb/rfbconfig.h:9:22: warning: extra tokens at end of #ifndef directive

   The workaround is to configure like this:
  env CONFIG_SHELL=/bin/sh /bin/sh ./configure

   i.e. avoid using the bash with the misbehavior. A bug has been filed
   against autoconf to guard against this.
     _________________________________________________________________

   AIX: one user had to add the "X11.adt" package to AIX to get build
   header files like XShm.h, etc.
     _________________________________________________________________

   Ubuntu Feisty Fawn 7.04: In May/2007 one user said he needed to add
   these packages to compile x11vnc on that Linux distro and version:
  apt-get install build-essential make bin86 libjpeg62-dev libssl-dev libxtst-d
ev

   Note that Ubuntu is based on Debian, so perhaps this is the list
   needed on Debian (testing?) as well. To build in Avahi (mDNS service
   advertising) support it would appear that libavahi-client-dev is
   needed as well.
     _________________________________________________________________

   Exceedingly slow compilation: x11vnc has a couple of files which
   contain very large "case statements" (over 100 cases) that on some
   platforms can take a very long time to compile (in extreme cases over
   an hour). However on 32bit Linux with intel/amd processor and gcc
   these files usually take less than 10 seconds to compile. For 64bit
   systems using gcc the problem appears to be much worse.

   The two files with the large number of cases, remote.c and x11vnc.c,
   have no real need to be optimized (the code is used only very
   infrequently). So it is fine to supply "-O0" (disables optimization)
   to CFLAGS when compiling them. However, it is tricky with
   autoconf/automake to do this (especially since both the compiler and
   make versions have a big effect).

   So if the compile times are getting too long for you for these two
   files you will need to manually change some things. First, run
   configure and when it has finished, edit the generated file
   x11vnc/Makefile and put these lines at the very top:
x11vnc-x11vnc.o :  CFLAGS += -O0
x11vnc-remote.o :  CFLAGS += -O0

   Those lines assume gnu make (gmake) is being used. If you are using
   another make, say Solaris make, insert these instead:
x11vnc-x11vnc.o := CFLAGS += -O0
x11vnc-remote.o := CFLAGS += -O0

   You could write a build shell script that modified the Makefile this
   way before running make.

   The "-O0" (note it is "capital Oh" followed by "zero") assumes the gcc
   compiler. If you are using a different compiler you will need to find
   the command line option to disable optimization, or otherwise have the
   lines set CFLAGS to the empty string.
     _________________________________________________________________

   Broken Thread Local Storage on SuSE 9.2: Starting with x11vnc 0.9.8
   the bundled libvncserver uses the __thread keyword to make some of the
   encodings (i.e. tight) thread safe (multiple VNC clients can be using
   tight at the same time in x11vnc -threads mode.) Evidently on the old
   SuSE 9.2 system the compiler does not support the thread local storage
   properly. Here is an example build failure:
tight.c:1126: error: unrecognizable insn:
(insn:HI 11 10 13 0 (nil) (set (reg/f:SI 59)
        (const:SI (plus:SI (symbol_ref:SI ("%lpalette"))
                (const_int 2048 [0x800])))) -1 (nil)
    (expr_list:REG_EQUAL (const:SI (plus:SI (symbol_ref:SI ("%lpalette"))
                (const_int 2048 [0x800])))
        (nil)))
tight.c:1126: internal compiler error: in extract_insn, at recog.c:2175
Please submit a full bug report,
with preprocessed source if appropriate.
See URL:http://www.suse.de/feedback for instructions.

   The workaround is to disable thread local storage at configure time
   like this:
env CPPFLAGS="-DTLS=''" ./configure

   and then build it.
     _________________________________________________________________
	
=======================================================================
http://www.karlrunge.com/x11vnc/sunray.html:


    Sun Ray Notes:

   You can run x11vnc on your (connected or disconnected) SunRay session
   (Please remember to use settings like -wait 200, -sb 15, and not
   running a screensaver animation (blank instead) to avoid being a
   resource hog! x11vnc does induce a lot of memory I/O from polling the
   X server. It also helps to have a solid background color, e.g.
   -solid).

   News: Sun Ray Remote Control Toolkit: See the nice set of tools in the
   Sun Ray Remote Control Toolkit that launch x11vnc automatically for
   you for certain usage modes.

   You have to know the name of the machine your SunRay session X server
   is running on (so you can ssh into it and start x11vnc). You also need
   to know the X11 DISPLAY number for the session: on a SunRay it could
   be a large number, e.g. :137, since there are many people with X
   sessions (Xsun processes) on the same machine. If you don't know it,
   you can get it by running who(1) in a shell on the SunRay server and
   looking for the dtlocal entry with your username (and if you don't
   even know which server machine has your session, you could login to
   all possible ones looking at the who output for your username...).

   I put some code in my ~/.dtprofile script that stores $DISPLAY
   (including the hostname) in a ~/.sunray_current file at session
   startup (and deletes it when the X session ends) to make it easy to
   get at the hostname and X11 display number info for my current X
   sessions when I ssh in and am about to start x11vnc.

   SunRay Gotcha #1:   Note that even though your SunRay X11 DISPLAY is
   something like :137, x11vnc still tries for port 5900 as its listening
   port if it can get it, in which case the VNC display (i.e. the
   information you supply to the VNC viewer) is something like
   sunray-server:0   (note the :0 corresponding to port 5900, it is not
   :137). If it cannot get 5900, it tries for 5901, and so on. You can
   also try to force the port (and thereby the VNC display) using the
   -rfbport NNNN option.

   Especially on a busy Sun Ray server it is often difficult to find free
   ports for both VNC and the HTTP Java applet server to listen on. This
   script, vnc_findports may be of use for doing this automatically. It
   suggests x11vnc command line options based on netstat output that
   lists the occupied ports. It is even more difficult to start
   vncserver/Xvnc on a busy Sun Ray because then 3 ports (HTTP, VNC, and
   X11), all separated by 100 are needed! This script, findvncports may
   be helpful as well. Both scripts start at VNC display :10 and work
   their way up.

   SunRay Gotcha #2:   If you get an error like:
        shmget(tile) failed.
        shmget: No space left on device

   when starting up x11vnc that most likely means all the shared memory
   (shm) slots are filled up on your machine. The Solaris default is only
   100, and that can get filled up in a week or so on a SunRay server
   with lots of users. If the shm slot is orphaned (e.g. creator process
   dies) the slot is not reclaimed. You can view the shm slots with the
   "ipcs -mA" command. If there are about 100 then you've probably hit
   this problem. They can be cleaned out (by the owner or by root) using
   the ipcrm command. I wrote a script shm_clear that finds the orphans
   and lists or removes them. Longer term, have your SunRay sysadmin add
   something like this to /etc/system:
        set shmsys:shminfo_shmmax = 0x2000000
        set shmsys:shminfo_shmmni = 0x1000

   SunRay Gotcha #3:   Some SunRay installations have implemented
   suspending certain applications when a SunRay session is in a
   disconnected state (e.g. Java Badge pulled out, utdetach, etc). This
   is a good thing because it limits hoggy or runaway apps from wasting
   the shared CPU resource. Think how much CPU and memory I/O is wasted
   by a bunch of Firefox windows running worthless Flash animations while
   your session is disconnected!

   So some sites have implemented scripts to suspend (e.g. kill -STOP)
   certain apps when your badge is removed from the SunRay terminal. When
   you reattach, it kill -CONT them. This causes problems for viewing the
   detached SunRay session via x11vnc: those suspended apps will not
   respond (their windows will be blank or otherwise inactive).

   What to do? Well, since you are going to be using the application you
   might as well unfreeze it rather than starting up a 2nd instance. Here
   is one way to do it using the kill -CONT mechanism:
   kill -CONT `ps -ealf | grep ' T ' | grep $LOGNAME | awk '{print $4}'`

   If you want to be a good citizen and re-freeze them before you exit
   x11vnc this script could be of use:
#!/bin/sh
#
# kill -STOP/-CONT script for x11vnc (or other) SunRay usage ("freezes"
# certain apps from hogging resources when disconnected).
#
# Put here a pattern that matches the apps that are frozen:
#
appmatch="java_vm|jre|netscape-bin|firefox-bin|realplay|acroread|mozilla-bin"

if [ "X$1" = "Xfreeze" ]; then
        pkill -STOP -U $LOGNAME "$appmatch"
elif [ "X$1" = "Xthaw" ]; then
        pkill -CONT -U $LOGNAME "$appmatch"

elif [ "$RFB_MODE" = "afteraccept" -a "$RFB_STATE" = "NORMAL" ]; then
        # a valid x11vnc login.
        if [ "$RFB_CLIENT_COUNT" = "1" ]; then
                # only one client present.
                pkill -CONT -U $LOGNAME "$appmatch"
        fi
elif [ "$RFB_MODE" = "gone" -a "$RFB_STATE" = "NORMAL" ]; then
        # a valid x11vnc login.
        if [ "$RFB_CLIENT_COUNT" = "0" ]; then
                # last client present has just left.
                pkill -STOP -U $LOGNAME "$appmatch"
        fi
fi
exit 0

   If you called the script "goodcitizen" you could type "goodcitizen
   thaw" to unfreeze them, and then "goodcitizen freeze" to refreeze
   them. One could also use these x11vnc options "-afteraccept
   goodcitizen -gone goodcitizen" to do it automatically.

   SunRay Gotcha #4:   Recent versions of the Sun Ray Server Software
   SRSS (seems to be version 3.0 or 3.1) have a "misfeature" that when
   the session is disconnected (i.e. badge/smartcard out) the screen
   locker (xscreensaver) will freeze the X server just when the "Enter
   Password" dialog box appears. So you cannot unlock the screen remotely
   via x11vnc!

   Update: please see Bob Doolittle's detailed description of the this
   issue at the bottom of this section.

   Here "freeze" means "stop other X clients from inserting keyboard and
   mouse input and from viewing the current contents of the screen". Or
   something like that; the upshot is x11vnc can't do its normal thing.

   There are several workarounds for this.

   1) The easiest one by far is to put these lines in your
   $HOME/.dtprofile file:
SUN_SUNRAY_UTXLOCK_PREF="/usr/openwin/bin/xlock -mode blank"
export SUN_SUNRAY_UTXLOCK_PREF

   One might argue that xlock isn't particularly "pretty". (Just IMHO,
   but if something like this not being pretty actually gets in the way
   of your work I think some introspection may be in order. :-)

   2) The problem has been traced to the pam_sunray.so PAM module.
   Evidently xscreensaver invokes this pam module and it communicates
   with utsessiond who in turn instructs the Xsun server to not process
   any synthetic mouse/keyboard input or to update the screen
   framebuffer. It is not clear if this is by design (security?) or
   something else.

   In any event, the problem can be avoided, somewhat drastically, by
   commenting out the corresponding line in /etc/pam.conf:
#xscreensaver auth sufficient /opt/SUNWut/lib/pam_sunray.so syncondisplay

   Leave the other xscreensaver pam authentication lines unchanged. The
   dtsession-SunRay line may also need to be commented out to avoid the
   problem for CDE sessions. N.B. it is possible the application of a
   SSRS patch, etc, may re-enable that /etc/pam.conf line. It may be
   difficult to convince a sysadmin to make this change.

   3) A more forceful way is to kill the xscreensaver process from a
   shell prompt whenever you connect via x11vnc and the screen is in a
   locked state:
pkill -U $LOGNAME '^xscreensaver$'

   And then after you are in be sure to restart it by typing something
   like:
xscreensaver &

   You may want to avoid restarting it until you are about to disconnect
   your VNC viewer (since if it locks the screen while you are working
   you'll be stuck again).

   3') The above idea can be done a bit more cleanly by having x11vnc do
   it. Suppose we called the following script xss_killer:
#!/bin/sh
#
# xss_killer: kill xscreensaver after a valid x11vnc client logs in.
#             Restart xscreensaver and lock it when the last client
#             disconnects.

PATH=/usr/openwin/bin:/usr/bin:$PATH
export PATH

if [ "$RFB_MODE" = "afteraccept" -a "$RFB_STATE" = "NORMAL" ]; then
        # a valid x11vnc login.
        if [ "$RFB_CLIENT_COUNT" = "1" ]; then
                # only one client present.
                pkill -U $LOGNAME '^xscreensaver$'
                pkill -KILL -U $LOGNAME -f xscreensaver/hacks
        fi
elif [ "$RFB_MODE" = "gone" -a "$RFB_STATE" = "NORMAL" ]; then
        # a valid x11vnc login.
        if [ "$RFB_CLIENT_COUNT" = "0" ]; then
                # last client present has just left.
                xscreensaver -nosplash &
                sleep 1
                xscreensaver-command -lock &
        fi
fi

   Then we would run x11vnc with these options: "-afteraccept xss_killer
   -gone xss_killer". The -afteraccept option (introduced in version 0.8)
   is used to run a command after a vncviewer has successfully logged in
   (note that this is a VNC login, not a Unix login, so you may not want
   to do this if you are really paranoid...)

   Note if you use the above script and also plan to Ctrl-C (SIGINT)
   x11vnc you have to run the xscreensaver in a new process group to
   avoid killing it as well. One way to do this is via this kludge:
perl -e 'setpgrp(0,0); exec "xscreensaver -nosplash &"'

   in the above script.

   4) There appears to be a bug in pam_sunray.so in that it doesn't seem
   to honor the convention that, say, DISPLAY=unix:3 means to use Unix
   sockets to connect to display 3 on the local machine (this is a bit
   faster than TCP sockets). Rather, it thinks the display is a non-local
   one to a machine named "unix" (that usually does not resolve to an IP
   address).

   Amusingly, this can be used to bypass the pam_sunray.so blocking of
   Xsun that prevents one from unlocking the screen remotely via x11vnc.
   One could put something like this in $HOME/.dtprofile to kill any
   existing xscreensavers and then start up a fresh xscreensaver using
   DISPLAY=unix:N
# stop/kill any running xscreensavers (probably not running yet, but to be sure
)
xscreensaver-command -exit
pkill -U $LOGNAME '^xscreensaver$'
env DISPLAY=`echo $DISPLAY | sed -e 's/^.*:/unix:/'` xscreensaver &


   Important: Note that all of the above workarounds side-step the
   pam_sunray.so PAM module in one way or another. You'll need to see if
   that is appropriate for your site's SunRay / smartcard usage. Also,
   these hacks may break other things and so you may want to test various
   scenarios carefully. E.g. check corner cases like XDMCP/dtremote,
   NSCM, etc.


   Update May 2008: Here is a useful description of this issue from Bob
   Doolittle who is a developer for Sun Ray at Sun. I don't have the time
   to digest and distill it and then adjust the above methods to provide
   a clearer description, so I just include below the description he sent
   me with the hope that it will help some users:

     In SRSS 4.0 and earlier, the purpose of pam_sunray.so in the "auth"
     PAM stack of screensavers is to enable NSCM (and, although this is
     much less commonly used, "SC", which is configured when 3rd-party
     software is installed to allow smartcards to be used as part of the
     authentication process) to work. It should have no effect with
     smartcards. Currently, however, it does block the PAM stack for all
     sessions, which causes xscreensaver, when it locks a disconnected
     session, to not process any mouse or keyboard events as you
     describe (unless xscreensaver does an X server grab, however, other
     applications should still be able to draw in the session although
     xscreensaver may be playing tricks like putting a black window on
     top of everything). In both of the NSCM and SC models,
     authentication occurs in a separate session before SRSS will
     reconnect to the user session, in which case pam_sunray.so causes
     xscreensaver to just unlock the screen without prompting the user
     to enter their password again. To do this, pam_sunray.so has to
     block until the session becomes reconnected, so it can query SRSS
     at that time to determine whether the user has already
     authenticated or not. In SRSS 4.0 and earlier releases,
     pam_sunray.so could have been optimized to not block smartcard
     sessions, although since the session is disconnected this typically
     isn't important (except in the x11vnc case, as you've observed).

     In SRSS 4.1, however, for increased security the out-of-session
     authentication model has been extended to *all* session types, so
     pam_sunray.so will be required in all cases unless users are
     willing to authenticate twice upon hotdesking (e.g. when their card
     is inserted). In future, we may do away with pam_sunray.so, and in
     fact with any traditional screen locker in the user session, since
     SRSS itself will be providing better security than a screen locker
     running entirely within the user's X session is capable of
     providing.

     Your trick of setting DISPLAY to unix:DPY will effectively disable
     pam_sunray.so (I'm not sure I'd call that a bug - you're going out
     of your way to do something that wouldn't occur in the normal
     course of events, and really provides no useful value other than to
     tickle this behavior in pam_sunray.so). This will mean that, in
     SRSS 4.0 and earlier releases, users will be prompted for their
     passwords twice when reconnecting to their sessions for NSCM and SC
     session types. In 4.1, disabling pam_sunray.so in this way will
     cause this double-authentication to occur for *all* sessions,
     including simple smartcard sessions. Users may be willing to pay
     that price in order to be able to use x11vnc in disconnected
     sessions. I like this hack, personally. It's a little less
     convenient than some of the other approaches you describe, but it's
     lighter-weight and more secure than most of the other approaches,
     and provides the value of being able to use x11vnc in locked
     sessions.

     Here are some other minor notes: - I wouldn't recommend storing
     your display in your .dtprofile, unless you're willing to live with
     a single session at a time. Personally, I often find myself using
     several sessions, in several FoGs, for short periods of time so
     this would certainly break. IMO it's pretty easy to use $DISPLAY to
     do what you want on the fly, as needed, so I don't think the price
     of breaking multiple-session functionality would be worth the
     convenience, to me at least. Here's some ksh/bash syntax to extract
     the hostname and display number on the fly which you may find
     useful:
HOSTNAME=${DISPLAY%:*}
FULLDPY=${DISPLAY#*:}
DPYNUM=${FULLDPY%.*}

     A final note may give you some insight into other clever hacks in
     this area: - Check out utaction. It's a very handy little utility
     that can be run as a daemon in the user session which will invoke a
     specified command upon session connects and/or disconnects.
     Personally, I start one up in my .dtprofile as follows:
utaction -c $HOME/.srconnectrc -d $HOME/.srdisconnectrc &

     This then allows me to construct a .srconnectrc script containing
     useful commands I'd like to have run every time I insert my
     smartcard, and a .srdisconnectrc script of commands to be run every
     time I remove my smartcard (or, connect/disconnect to my session
     via NSCM or SC). This can be used for things like notifying a chat
     client of away status, as well as some of the hacks you've
     described on your page such as freeze/unfreeze, or perhaps to
     terminate an xscreensaver and start up a new one with the unix:DPY
     $DISPLAY specification as you describe (although it probably makes
     most sense to do this at login time, as opposed to every connect or
     disconnect event).
	
=======================================================================
http://www.karlrunge.com/x11vnc/ssl.html:


     _________________________________________________________________

   Notes on x11vnc SSL Certificates and Key Management:

   The simplest scheme ("x11vnc -ssl TMP") is where x11vnc generates a
   temporary, self-signed certificate each time (automatically using
   openssl(1)) and the VNC viewer client accepts the certificate without
   question (e.g. user clicks "Yes" in a dialog box. Perhaps the dialog
   allows them to view the certificate too). Also note stunnel's default
   is to quietly accept all certificates.

   The encryption this provides protects against all passive sniffing of
   the VNC traffic and passwords on the network and so it is quite good,
   but it does not prevent a Man-In-The-Middle active attack: e.g. an
   attacker intercepts the VNC client stream and sends it his own Public
   key for SSL negotiation (pretending to be the server). Then it makes a
   connection to SSL x11vnc itself and forwards the data back and forth.
   He can see all the traffic and modify it as well.

   Most people don't seem to worry about Man-In-The-Middle attacks these
   days; they are more concerned about passive sniffing of passwords,
   etc. Perhaps someday that will change if attack tools are used more
   widely to perform the attack. NOTE: There are hacker tools like
   dsniff/webmitm and cain that implement SSL Man-In-The-Middle attacks.
   They all rely on the client not bothering to check that the cert is
   valid.

   If you are not worried about Man-In-The-Middle attacks you do not have
   to read the techniques described in the rest of this document.

   To prevent Man-In-The-Middle attacks, certificates must somehow be
   verified. This requires the VNC client side have some piece of
   information that can be used to verify the SSL x11vnc server.
   Alternatively, although rarely done, x11vnc can verify VNC Clients'
   certificates, see the -sslverify option that is discussed below.

   There are a number of ways to have the client authenticate the SSL
   x11vnc server. The quickest way perhaps would be to copy (safely) the
   certificate x11vnc prints out:
26/03/2006 21:12:00 Creating a temporary, self-signed PEM certificate...
...
-----BEGIN CERTIFICATE-----
MIIC4TCCAkqgAwIBAgIJAMnwCaOjvEKaMA0GCSqGSIb3DQEBBAUAMIGmMQswCQYD
VQQGEwJBVTEOMAwGA1UEBxMFTGludXgxITAfBgNVBAsTGGFuZ2VsYS0xMTQzNDI1
NTIwLjQxMTE2OTEPMA0GA1UEChMGeDExdm5jMS4wLAYDVQQDEyV4MTF2bmMtU0VM
(more lines) ...
-----END CERTIFICATE-----

   to the client machine(s) and have the client's SSL machinery (e.g.
   stunnel, Web Browser, or Java plugin) import the certificate. That way
   when the connection to x11vnc is made the client can verify that is it
   the desired server on the other side of the SSL connection.

   So, for example suppose the user is using the SSL enabled Java VNC
   Viewer and has incorporated the x11vnc certificate into his Web
   browser on the viewing side. If he gets a dialog that the certificate
   is not verified he knows something is wrong. It may be a
   Man-In-The-Middle attack, but more likely x11vnc certificate has
   changed or expired or his browser was reinstalled and/or lost the
   certificate, etc, etc.

   As another example, if the user was using stunnel with his VNC viewer
   (this is mentioned in this FAQ), e.g. STUNNEL.EXE on Windows, then he
   would have to set the "CAfile = path-to-the-cert" and "verify = 2"
   options in the stunnel.conf file before starting up the tunnel. If a
   x11vnc certificate cannot be verified, stunnel will drop the
   connection (and print a failure message in its log file).

   A third example, using the VNC viewer on Unix with stunnel the wrapper
   script can be used this way: "ss_vncviewer -verify ./x11vnc.crt
   far-away.east:0" where ./x11vnc.crt is the copied certificate x11vnc
   printed out.

   As fourth example, our SSVNC enhanced tightvnc viewer can also use
   these certificate files for server authentication. You can load them
   via the SSVNC 'Certs...' dialog and set 'ServerCert' to the
   certificate file you safely copied there.

   Note that in principle the copying of the certificate to the client
   machine(s) itself could be altered by a Man-In-The-Middle attack! You
   can't win; it is very difficult to be completely secure. It is
   unlikely the attacker could predict how you were going to send it
   unless you had, say, done it many times before the same way. SSH is a
   very good way to send it (but of course it too depends on public keys
   being sent unaltered between the two machines!).

   If you are really paranoid, I'm sure you'll figure out a really good
   way to transport the certificates. See the Certificate Authority
   scheme below for a way to make this easier (you just have to do it
   once).

     _________________________________________________________________

   Saving SSL certificates and keys:

   Now, it would be very inconvenient to copy the new temporary
   certificate every time x11vnc is run in SSL mode. So for convenience
   there is the "SAVE" keyword to instruct x11vnc to save the certificate
   it creates:
  x11vnc -ssl SAVE -display :0 ...

   This behavior is now the default, you must use "TMP" for a temporary
   one. It will save the certificate and private key in these files:
  ~/.vnc/certs/server.crt
  ~/.vnc/certs/server.pem

   The ".crt" file contains only the certificate and should be safely
   copied to the VNC Viewer machine(s) that will be authenticating the
   x11vnc server. The ".pem" file contains both the certificate and the
   private key and should be kept secret. (If you don't like the default
   location ~/.vnc/certs, e.g. it is on an NFS share and you are worried
   about local network sniffing, use the -ssldir dir option to point to a
   different directory.)

   So the next time you run "x11vnc -ssl SAVE ..." it will read the
   server.pem file directly instead of creating a new one.

   You can manage multiple SSL x11vnc server keys in this simple way by
   using:
  x11vnc -ssl SAVE-key2 -display :0 ...

   etc, where you put whatever name you choose for the key after "SAVE-".
   E.g. "-ssl SAVE-fred".

   Also, if you want to be prompted to possibly change the made up names,
   etc. that x11vnc creates (e.g. "x11vnc-SELF-SIGNED-CERT-7762" for the
   CommonName) for the certificates distinguished name (DN), then use
   "x11vnc -ssl SAVE_PROMPT ...", "x11vnc -ssl SAVE_PROMPT-fred ..." etc.
   when you create the key the first time.

   Tip: when prompting, if you choose the CommonName entry to be the full
   internet hostname of the machine the clients will be connecting to
   then that will avoid an annoying dialog box in their Web browsers that
   warn that the CommonName doesn't match the hostname.

     _________________________________________________________________

   Passphrases for server keys:

   Well, since now with the "SAVE" keyword the certificate and key will
   be longer lived, one can next worry about somebody stealing the
   private key and pretending to be the x11vnc server! How to guard
   against this?

   The first is that the file is created with perms 600 (i.e. -rw-------)
   to make it harder for an untrusted user to copy the file. A better way
   is to also encrypt the private key with a passphrase. You are prompted
   whether you want to do this or not when the key is first created under
   "-ssl SAVE" mode ("Protect key with a passphrase? y/n"). It is
   suggested that you use a passphrase. The inconvenience is every time
   you run "x11vnc -ssl SAVE ..." you will need to supply the passphrase
   to access the private key:
  06/04/2006 11:39:11 using PEM /home/runge/.vnc/certs/server.pem  0.000s

  A passphrase is needed to unlock an OpenSSL private key (PEM file).
  Enter passphrase>

   before x11vnc can continue.

     _________________________________________________________________

   Being your own Certificate Authority:

   A very sophisticated way that scales well if the number of users is
   large is to use a Certificate Authority (CA) whose public certificate
   is available to all of the VNC clients and whose private key has been
   used to digitally sign the x11vnc server certificate(s).

   The idea is as follows:
     * A special CA cert and key is generated.
     * Its private key is always protected by a good passphrase since it
       is only used for signing.
     * The CA cert is (safely) distributed to all machines where VNC
       clients will run.
     * One or more x11vnc server certs and keys are generated.
     * The x11vnc server cert is signed with the CA private key.
     * x11vnc is run using the server key. (e.g. "-ssl SAVE")
     * VNC clients (viewers) can now authenticate the x11vnc server
       because they have the CA certificate.

   The advantage is the CA cert only needs to be distributed once to the
   various machines, that can be done even before x11vnc server certs are
   generated.

   As above, it is important the CA private key and the x11vnc server key
   are kept secret, otherwise someone could steal them and pretend to be
   the CA or the x11vnc server if they copied the key. It is recommended
   that the x11vnc server keys are also protected via a passphrase (see
   the previous section).

   Optionally, VNC viewer certs and keys could also be generated to
   enable the x11vnc server to authenticate each client. This is not
   normally done (usually a simple viewer password scheme is used), but
   this can be useful in some situations. These optional steps go like
   this:
     * One or more VNC client certs and keys are generated.
     * These VNC client certs are signed with the CA private key.
     * The VNC client certs+keys are safely distributed to the
       corresponding client machines.
     * x11vnc is told to verify clients by using the CA cert. (e.g.
       "-sslverify CA")
     * When VNC clients (viewers) connect, they must authenticate
       themselves to x11vnc by using their client key.

   Again, it is a good idea if the client private keys are protected with
   a passphrase, otherwise if stolen they could be used to gain access to
   the x11vnc server. Once distributed to the client machines, there is
   no need to keep the client key on the CA machine that generated and
   signed it. You can keep the client certs if you like because they are
   public.

     _________________________________________________________________

   How to do the above CA steps with x11vnc:

   Some utility commands are provided to ease the cert+key creation,
   signing, and management: -sslGenCA, -sslGenCert, -sslDelCert,
   -sslEncKey, -sslCertInfo. They basically run the openssl(1) command
   for you to manage the certs/keys. It is required that openssl(1) is
   installed on the machine and available in PATH. All commands can be
   pointed to an alternate toplevel certificate directory via the -ssldir
   option if you don't want to use the default ~/.vnc/certs.

   1) To generate your Certificate Authority (CA) cert and key run this:
  x11vnc -sslGenCA

   Follow the prompts, you can modify any informational strings you care
   to. You will also be required to encrypt the CA private key with a
   passphrase. This generates these files:
  ~/.vnc/certs/CA/cacert.pem             (the CA public certificate)
  ~/.vnc/certs/CA/private/cakey.pem      (the encrypted CA private key)

   If you want to use a different directory use -ssldir It must supplied
   with all subsequent SSL utility options to point them to the correct
   directory.

   2) To generate a signed x11vnc server cert and key run this:
  x11vnc -sslGenCert server

   As with the CA generation, follow the prompts and you can modify any
   informational strings that you care to. This will create the files:
  ~/.vnc/certs/server.crt             (the server public certificate)
  ~/.vnc/certs/server.pem             (the server private key + public cert)

   It is recommended to protect the server private key with a passphrase
   (you will be prompted whether you want to). You will need to provide
   it whenever you start x11vnc using this key.

   3) Start up x11vnc using this server key:
  x11vnc -ssl SAVE -display :0 ...

   (SAVE corresponds to server.pem, see -sslGenCert server somename info
   on creating additional server keys, server-somename.crt ...)

   4) Next, safely copy the CA certificate to the VNC viewer (client)
   machine(s). Perhaps:
  scp ~/.vnc/CA/cacert.pem clientmachine:.

   5) Then the tricky part, make it so the SSL VNC Viewer uses this
   certificate! There are a number of ways this might be done, it depends
   on what your client and/or SSL tunnel is. Some examples:

   For the SSL Java VNC viewer supplied with x11vnc in
   classes/ssl/VncViewer.jar or classes/ssl/SignedVncViewer.jar:
     * Import the cacert.pem cert into your Web Browser (e.g. Edit ->
       Preferences -> Privacy & Security -> Manage Certificates ->
       WebSites -> Import)
     * Or Import the cacert.pem cert into your Java Plugin (e.g. run
       ControlPanel, then Security -> Certificates -> Secure Site ->
       Import)

   When importing, one would give the browser/java-plugin the path to the
   copied cacert.pem file in some dialog. Note that the Web browser or
   Java plugin is used for the server authentication. If the user gets a
   "Site not verified" message while connecting he should investigate
   further.

   For the use of stunnel (e.g. on Windows) one would add this to the
   stunnel.conf:
  # stunnel.conf:
  client = yes
  options = ALL
  CAfile = /path/to/cacert.pem          # or maybe C:\path\to\cacert.pem
  [myvncssl]
  accept = 5901
  connect = far-away.east:5900

   (then point the VNC viewer to localhost:1).

   Here is an example for the Unix stunnel wrapper script ss_vncviewer in
   our SSVNC package:
  ss_vncviewer -verify ./cacert.pem far-away.east:0

   Our SSVNC enhanced tightvnc viewer GUI can also use the certificate
   file for server authentication. You can load it via the SSVNC
   'Certs...' dialog and set 'ServerCert' to the cacert.pem file you
   safely copied there.

     _________________________________________________________________

   Tricks for server keys:

   To create additional x11vnc server keys do something like this:
  x11vnc -sslGenCert server myotherkey

   and use it this way:
  x11vnc -ssl SAVE-myotherkey ...

   The files will be ~/.vnc/certs/server-myotherkey.{crt,pem}

   You can also create a self-signed server key:
  x11vnc -sslGenCert server self:third_key

   and use it this way:
  x11vnc -ssl SAVE-self:third_key ...

   This key is not signed by your CA. This can be handy to have a key set
   separate from your CA when you do not want to create a 2nd CA
   cert+key.

     _________________________________________________________________

   Using external CA's:

   You don't have to use your own CA cert+key, you can use a third
   party's instead. Perhaps you have a company-wide CA or you can even
   have your x11vnc certificate signed by a professional CA (e.g.
   www.thawte.com or www.verisign.com or perhaps the free certificate
   service www.startcom.org or www.cacert.org).

   The advantage to doing this is that the VNC client machines will
   already have the CA certificates installed and you don't have to
   install it on each machine.

   To generate an x11vnc server cert+key this way you should generate a
   "request" for a certicate signing something like this (we use the name
   "external" in this example, it could be anything you want):
  x11vnc -sslGenCert server req:external

   This will create the request file:
  ~/.vnc/certs/server-req:external.req

   Which you should send to the external CA. When you get the signed
   certificate back from them, save it in the file:
  ~/.vnc/certs/server-req:external.crt

   and create the .pem this way:
  mv  ~/.vnc/certs/server-req:external.key    ~/.vnc/certs/server-req:external.
pem
  chmod 600 ~/.vnc/certs/server-req:external.pem
  cat ~/.vnc/certs/server-req:external.crt >> ~/.vnc/certs/server-req:external.
pem

   You also rename the two files (.crt and .pem) to have a shorter
   basename if you like. E.g.:
  mv  ~/.vnc/certs/server-req:external.pem  ~/.vnc/certs/server-ext.pem
  mv  ~/.vnc/certs/server-req:external.crt  ~/.vnc/certs/server-ext.crt

   and the use via "x11vnc -ssl SAVE-ext ...", etc.

   On the viewer side make sure the external CA's certificate is
   installed an available for the VNC viewer software you plan to use.

     _________________________________________________________________

   Using Client Keys for Authentication:

   You can optionally create certs+keys for your VNC client machines as
   well. After distributing them to the client machines you can have
   x11vnc verify the clients using SSL. Here is how to do this:

  x11vnc -sslGenCert client dilbert
  x11vnc -sslGenCert client wally
  x11vnc -sslGenCert client alice
  ...

   As usual, follow the prompts if you want to change any of the info
   field values. As always, it is a good idea (although inconvenient) to
   protect the private keys with a passphrase. These files are created:
  ~/.vnc/certs/clients/dilbert.crt
  ~/.vnc/certs/clients/dilbert.pem
  ...

   Note that these are kept in a clients subdirectory.

   Next, safely copy the .pem files to each corresponding client machine
   and incorporate them into the VNC viewer / SSL software (see the ideas
   mentioned above for the CA and server keys). The only difference is
   these certificates might be referred to as "My Certificates" or
   "Client Certificates". They are used for client authentication (which
   is relatively rare for SSL).

   After copying them you can delete the clients/*.pem files for extra
   safety because the private keys are not needed by the x11vnc server.
   You don't really need the clients/*.crt files either (because they
   have been signed by the CA). But they could come in handy for tracking
   or troubleshooting, etc.

   Now start up x11vnc and instruct it to verify connecting clients via
   SSL and the CA cert:
  x11vnc -ssl SAVE -sslverify CA

   The "CA" special token instructs x11vnc to use its CA signed certs for
   verification.

   For arbitrary self-signed client certificates (no CA) it might be
   something like this:
  x11vnc -ssl SAVE -sslverify path/to/client.crt
  x11vnc -ssl SAVE -sslverify path/to/client-hash-dir
  x11vnc -ssl SAVE -sslverify path/to/certs.txt

   Where client.crt would be an individual client certificate;
   client-hash-dir a directory of file names based on md5 hashes of the
   certs (see -sslverify); and certs.txt signifies a single file full of
   client certificates.

   Finally, connect with your VNC viewer using the key. Here is an
   example for the Unix stunnel wrapper script ss_vncviewer: using client
   authentication (and the standard server authentication with the CA
   cert):
  ss_vncviewer -mycert ./dilbert.pem -verify ./cacert.pem far-away.east:0

   Our SSVNC enhanced tightvnc viewer can also use these openssl .pem
   files (you can load them via Certs... -> MyCert dialog).

   It is also possible to use -sslverify on a per-client key basis, and
   also using self-signed client keys (x11vnc -sslGenCert client
   self:dilbert)

   Now a tricky part is to get Web browsers or Java Runtime to import and
   use the openssl .pem cert+key files. See the next paragraph on how to
   convert them to pkcs12 format. If you find a robust way to import them
   and and get them to use the cert please let us know!

   Here is how to convert our openssl crt/pem files to pkcs12 format
   (contains both the client certificate and key) that can be read by Web
   browsers and Java for use in client authentication:
  openssl pkcs12 -export -in mycert.crt -inkey mycert.pem -out mycert.p12

   it will ask for a passphrase to protect mycert.p12. Some software
   (e.g. Java ControlPanel) may require a non-empty passphrase. Actually,
   since our .pem contains both the certificate and private key, you
   could just supply it for the -in and remove the -inkey option. It
   appears that for certificates only importing, our .crt file is
   sufficient and can be read by Mozilla/Firefox and Java...

   If you have trouble getting your Java Runtime to import and use the
   cert+key, there is a workaround for the SSL-enabled Java applet. On
   the Web browser URL that retrieves the VNC applet, simply add a
   "/?oneTimeKey=..." applet parameter (see ssl-portal for more details
   on applet parameters; you don't need to do the full portal setup
   though). The value of the oneTimeKey will be the very long string that
   is output of the onetimekey program found in the classes/ssl x11vnc
   directory. Or you can set oneTimeKey=PROMPT in which case the applet
   will ask you to paste in the long string. These scheme is pretty ugly,
   but it works. A nice application of it is to make one time keys for
   users that have already logged into a secure HTTPS site via password.
   A cgi program then makes a one time key for the logged in user to use:
   it is passed back over HTTPS as the applet parameter in the URL and so
   cannot be sniffed. x11vnc is run to use that key via -sslverify.

   Update: as of Apr 2007 in the 0.9.1 x11vnc tarball there is a new
   option setting "-users sslpeer=" that will do a switch user much like
   -unixpw does, but this time using the emailAddress field of the
   Certificate subject of the verified Client. This mode requires
   -sslverify turned on to verify the clients via SSL. This mode can be
   useful in situations using -create or -svc where a new X server needs
   to be started up as the authenticated user (but unlike in -unixpw
   mode, the unix username is not obviously known).

     _________________________________________________________________

   Revoking Certificates:

   A large, scaled-up installation may benefit from being able to revoke
   certificates (e.g. suppose a user's laptop with a vnc client or server
   key is compromised.) You can use this option with x11vnc: -sslCRL. See
   the info at that link for a guide on what openssl(1) commands you will
   need to run to revoke a certificate.

     _________________________________________________________________

   Additional utlities:

   You can get information about your keys via -sslCertInfo. These lists
   all your keys:
  x11vnc -sslCertInfo list
  x11vnc -sslCertInfo ll

   (the latter is long format).

   These print long output, including the public certificate, for
   individual keys:
  x11vnc -sslCertInfo server
  x11vnc -sslCertInfo dilbert
  x11vnc -sslCertInfo all             (every key, very long)

   If you want to add a protecting passphrase to a key originally created
   without one:
  x11vnc -sslEncKey SAVE
  x11vnc -sslEncKey SAVE-fred

   To delete a cert+key:
  x11vnc -sslDelCert SAVE
  x11vnc -sslDelCert SAVE-fred
  x11vnc -sslDelCert wally

   (but rm(1) will be just as effective).

     _________________________________________________________________

   Chained Certificates:

   There is increasing interest in using chained CA's instead of a single
   CA. The merits of using chained CA's are not described here besides to
   say its use may make some things easier when a certificate needs to be
   revoked.

   x11vnc supports chained CA certificates. We describe a basic use case
   here.

   Background: Of course the most straight forward way to use SSL with
   x11vnc is to use no CA at all (see above): a self-signed certificate
   and key is used and its certificate needs to be safely copied to the
   client side. This is basically the same as the SSH style of managing
   keys. Next level up, one can use a single CA to sign server keys: then
   only the CA's certificate needs to be safely copied to the client
   side, this can happen even before any server certs are created (again,
   see all of the discussion above.)

   With a certificate chain there are two or more CA's involved. Perhaps
   it looks like this:
  root_CA ---> intermediate_CA ---> server_cert

   Where the arrow basically means "signs".

   In this usage mode the client (viewer-side) will have root_CA's
   certificate available for verifying (and nothing else.) If the viewer
   only received server_cert's certificate, it would not have enough info
   to verify the server. The client needs to have intermediate_CA's cert
   as well. The way to do this with x11vnc (i.e. an OpenSSL using app) is
   to concatenate the server_cert's pem and the intermediate_CA's
   certificate together.

   For example, suppose the file intermediate_CA.crt had
   intermediate_CA's certificate. And suppose the file server_cert.pem
   had the server's certificate and private key pair as described above
   on this page. We need to do this:
  cat intermediate_CA.crt >> server_cert.pem

   (Note: the order of the items inside the file matters; intermediate_CA
   must be after the server key and cert) and then we run x11vnc like
   this:
  x11vnc -ssl ./server_cert.pem ...

   Then, on the VNC viewer client side, the viewer authenticates the
   x11vnc server by using root_CA's certificate. Suppose that is in a
   file named root_CA.crt, then using the SSVNC wrapper script
   ss_vncviewer (which is also included in the SSVNC package) as our
   example, we have:
  ss_vncviewer -verify ./root_CA.crt hostname:0

   (where "hostname" is the machine where x11vnc is running.) One could
   also use the SSVNC GUI setting Certs -> ServerCert to the root_CA.crt
   file. Any other SSL enabled VNC viewer would use root_CA.crt in a
   similar way.
     _________________________________________________________________

   Creating Chained Certificates:

   Here is a fun example using VeriSign's "Trial Certificate" program.
   Note that VeriSign has a Root CA and also an Intermediate CA and uses
   the latter to sign customers certificates. So this provides an easy
   way to test out the chained certificates mechanism with x11vnc.

   First we created a test x11vnc server key:
  openssl genrsa -out V1.key 1024

   then we created a certificate signing request (CSR) for it:
  openssl req -new -key V1.key -out V1.csr

   (we followed the prompts and supplied information for the various
   fields.)

   Then we went to VeriSign's page http://www.verisign.com/ssl/index.html
   and clicked on "FREE TRIAL" (the certificate is good for 14 days.) We
   filled in the forms and got to the point where it asked for the CSR
   and so we pasted in the contents of the above V1.csr file. Then, after
   a few more steps, VeriSign signed and emailed us our certificate.

   The VeriSign Trial certificates were found here:
  http://www.verisign.com/support/verisign-intermediate-ca/Trial_Secure_Server_
Root/index.html
  http://www.verisign.com/support/verisign-intermediate-ca/trial-secure-server-
intermediate/index.html

   The former was pasted into a file V-Root.crt and the latter was pasted
   into V-Intermediate.crt

   We pasted our Trial certificate that VeriSign signed and emailed to us
   into a file named V1.crt and then we typed:
  cat V1.key V1.crt > V1.pem
  cat V1.pem V-Intermediate.crt > V1-combined.pem
  chmod 600 V1.pem V1-combined.pem

   So now the file V1-combined.pem has our private key and (VeriSign
   signed) certificate and VeriSign's Trial Intermediate certificate.

   Next, we start x11vnc:
  x11vnc -ssl ./V1-combined.pem ...

   and finally, on the viewer side (SSVNC wrapper script example):
  ss_vncviewer -verify ./V-Root.crt hostname:0

   One will find that only that combination of certs and keys will work,
   i.e. allow the SSL connection to be established. Every other
   combination we tried failed (note that ss_vncviewer uses the external
   stunnel command to handle the SSL so we are really testing stunnel's
   SSL implementation on the viewer side); and so the system works as
   expected.
     _________________________________________________________________

   VNC Client Authentication using Certificate Chains:

   Now, going the other way around with the client authenticating himself
   via this chain of SSL certificates, x11vnc is run this way:
  x11vnc -ssl SAVE -sslverify ./V-Root.crt ...

   (note since the server must always supply a cert, we use its normal
   self-signed, etc., one via "-ssl SAVE" and use the VeriSign root cert
   for client authentication via -sslverify. The viewer must now supply
   the combined certificates, e.g.:
  ss_vncviewer -mycert ./V1-combined.pem hostname:0
     _________________________________________________________________

   Using OpenSSL and x11vnc to create Certificate Chains:

   Although the x11vnc CA mechanism (-sslGenCA and -sslGenCert; see
   above) was designed to only handle a single root CA (to sign server
   and/or client certs) it can be coerced into creating a certificate
   chain by way of an extra openssl(1) command.

   We will first create two CA's via -sslGenCA; then use one of these CA
   to sign the other; create a new (non-CA) server cert; and append the
   intermediate CA's cert to the server cert to have everything needed in
   the one file.

   Here are the commands we ran to do what the previous paragraph
   outlines.

   First we create the two CA's, called CA_root and CA_Intermediate here,
   in separate directories via x11vnc:
  x11vnc -ssldir ~/CA_Root -sslGenCA
     (follow the prompts, we included "CA_Root", e.g. Common Name, to aid ident
ifying it)

  x11vnc -ssldir ~/CA_Intermediate -sslGenCA
     (follow the prompts, we included "CA_Intermediate", e.g. Common Name, to a
id identifying it)

   Next backup CA_Intermediate's cert and then sign it with CA_Root:
  mv ~/CA_Intermediate/CA/cacert.pem ~/CA_Intermediate/CA/cacert.pem.ORIG
  cd ~/CA_Root
  openssl ca -config ./CA/ssl.cnf -policy policy_anything -extensions v3_ca -no
text -ss_cert ~/CA_Intermediate/CA/cacert.pem.ORIG -out ~/CA_Intermediate/CA/ca
cert.pem

   Note that it is required to cd to the ~/CA_Root directory and run the
   openssl command from there.

   You can print out info about the cert you just modified by:
  openssl x509 -noout -text -in ~/CA_Intermediate/CA/cacert.pem

   Now we create an x11vnc server cert named "test_chain" that is signed
   by CA_Intermediate:
  x11vnc -ssldir ~/CA_Intermediate -sslGenCert server test_chain
     (follow the prompts)

   You can print out information about this server cert just created via
   this command:
  x11vnc -ssldir ~/CA_Intermediate -sslCertInfo SAVE-test_chain

   This will tell you the full path to the server certificate, which is
   needed because we need to manually append the CA_Intermediate cert for
   the chain to work:
  cat ~/CA_Intermediate/CA/cacert.pem >> ~/CA_Intermediate/server-test_chain.pe
m

   Now we are finally ready to use it. We can run x11vnc using this
   server cert+key by either this command:
  x11vnc -ssldir ~/CA_Intermediate -ssl SAVE-test_chain ...

   or this command:
  x11vnc -ssl ~/CA_Intermediate/server-test_chain.pem ...

   since they are equivalent (both load the same pem file.)

   Finally we connect via VNC viewer that uses CA_Root to verify the
   server. As before we use ss_vncviewer:
  ss_vncviewer -verify ~/CA_Root/CA/cacert.pem hostname:0

   Client Certificates (see above) work in a similar manner.

   So although it is a little awkward with the extra steps (e.g.
   appending the CA_Intermediate cert) it is possible. If you want to do
   this entirely with openssl(1) you will have to learn the openssl
   commands corresponding to -genCA and -genCert. You may be able to find
   guides on the Internet to do this. Starting with x11vnc 0.9.10, you
   can have it print out the wrapper scripts it uses via: -sslScripts
   (you will still need to fill in a few pieces of information; ask if it
   is not clear from the source code.)

     _________________________________________________________________

   More info:

   See also this article for some some general info and examples using
   stunnel and openssl on Windows with VNC. Also
   http://www.stunnel.org/faq/certs.html is a very good source of
   information on SSL certificate creation and management.
	
=======================================================================
http://www.karlrunge.com/x11vnc/ssl-portal.html:


     _________________________________________________________________

   Using Apache as an SSL Gateway to multiple x11vnc servers inside a
   firewall:

   Background:

   The typical way to allow access to x11vnc (or any other VNC server)
   running on multiple workstations inside a firewall is via SSH. The
   user somewhere out on the Internet logs in to the SSH gateway machine
   and uses port forwarding (e.g. ssh -t -L 5900:myworkstation:5900
   user@gateway) to set up the encrypted channel that VNC is then
   tunneled through. Next he starts up the VNC viewer on the machine
   where he is sitting directed to the local tunnel port (e.g.
   localhost:0).

   The SSH scheme is nice because it is a widely used and well tested
   login technique for users connecting to machines inside their company
   or home firewall. For VNC access it is a bit awkward, however, because
   SSH needs to be installed on the Viewer machine and the user usually
   has to rig up his own port redirection plumbing (however, see our
   other tool).

   Also, some users have restrictive work environments where SSH and
   similar applications are prohibited (i.e. only outgoing connections to
   standard WWW ports from a browser are allowed, perhaps mediated by a
   proxy server). These users have successfully used the method described
   here for remote access.

   With the SSL support in x11vnc and the SSL enabled Java VNC viewer
   applet, a convenient and secure alternative exists that uses the
   Apache webserver as a gateway. The idea is that the company or home
   internet connection is already running apache as a web server (either
   SSL or non-SSL) and we add to it the ability to act as a gateway for
   SSL VNC connections. The only thing needed on the Viewer side is a
   Java enabled Web Browser: the user simply enters a URL that starts the
   entire VNC connection process. No VNC or SSH specific software needs
   to be installed on the viewer side machine.

   The stunnel VNC viewer stunnel wrapper script provided (ss_vncviewer)
   can also take advantage of the method described here with its -proxy
   option.

     _________________________________________________________________

   Simpler Solutions: This apache SSL VNC portal solution may be too much
   for you. It is mainly intended for automatically redirecting to
   MULTIPLE workstations inside the firewall. If you only have one or two
   inside machines that you want to access, the method described here is
   overly complicated! See below for some simpler (and still non-SSH)
   encrypted setups.

   Also see the recent (Mar/2010) desktop.cgi x11vnc desktop web login
   CGI script that achieves much of what the method describes here
   (especially if its 'port redirection' feature is enabled.)
     _________________________________________________________________



   There are numerous ways to achieve this with Apache. We present one of
   the simplest ones here.

   Important: these sorts of schemes allow incoming connections from
   anywhere on the Internet to fixed ports on machines inside the
   firewall. Care must be taken to implement and test thoroughly. If one
   is paranoid one can (and should) add extra layers of protection. (e.g.
   extra passwords, packet filtering, SSL certificate verification, etc).

   Also, it is easy to miss the point that unless precautions are taken
   to verify SSL Certificates, then the VNC Viewer is vulnerable to
   man-in-the-middle attacks (but not to the more common passive sniffing
   attacks). Note that there are hacker tools like dsniff/webmitm and
   cain that implement SSL Man-In-The-Middle attacks. They rely on the
   client not bothering to check the cert.
     _________________________________________________________________

   The Holy Grail: a single https port (443)

   Before we discuss the self-contained apache examples here, we want to
   mention that many x11vnc users who read this page and implement the
   apache SSL VNC portal ask for something that (so far) seems difficult
   or impossible to do entirely inside apache:
     * A single port, 443 (the default https:// port), is open to the
       Internet
     * It is HTTPS/SSL encrypted
     * It handles both VNC traffic and Java VNC Applet downloads.
     * And the server can also serve normal HTTPS webpages, CGI, etc.

   It is the last item that makes it tricky (otherwise the method
   described on this page will work). If you are interested in such a
   solution and are willing to run a separate helper program
   (connect_switch) look here. Also, see this apache patch.
     _________________________________________________________________

   Example:

   The scheme described here sets up apache on the firewall/gateway as a
   regular Web proxy into the intranet and allows connections to a single
   fixed port on a limited set of machines.

   The configuration described in this section does not use the mod_ssl
   apache module (the optional configuration described in the section
   "Downloading the Java applet to the browser via HTTPS" does take
   advantage of mod_ssl)

   In this example suppose the gateway machine running apache is named
   "www.gateway.east" (e.g. it may also provide normal web service). We
   also choose the Internet-facing port for this VNC service to be port
   563. One could choose any port, including the default HTTP port 80.

   Detail: We choose 563 because it is the rarely used SNEWS port that is
   often allowed by Web proxies for the CONNECT method. The idea is the
   user may be coming out of another firewall using a proxy (not the one
   we describe here, that is, the case when two proxies are involved,
   e.g. one at work and another Apache (described here) at home
   redirecting into our firewall; the "double proxy" or "double firewall"
   problem). Using port 563 simplifies things because CONNECT's to it are
   usually allowed by default.

   We also assume all of the x11vnc servers on the internal machines are
   all listening on port 5915 ("-rfbport 5915") instead of the default
   5900. This is to limit any unintended proxy redirections to a lesser
   used port, and also to stay out of the way of normal VNC servers on
   the same machines. One could obviously implement a scheme that handles
   different ports, but we just discuss this simple setup here.

   So we basically assume x11vnc has been started this way on all of the
   workstations to be granted VNC access:
  x11vnc -ssl SAVE -http -display :0 -forever -rfbauth ~/.vnc/passwd -rfbport 5
915

   i.e. we force SSL VNC connections, port 5915, serve the Java VNC
   viewer applet, and require a VNC password (another option would be
   -unixpw). The above command could also be run out of inetd(8). It can
   also be used to autodetect the user's display and Xauthority data.


   These sections are added to the httpd.conf apache configuration file
   on www.gateway.east:

# In the global section you need to enable these modules.
# Note that the ORDER MATTERS! mod_rewrite must be before mod_proxy
# (so that we can check the allowed host list via rewrite)
#
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule proxy_module modules/mod_proxy.so
LoadModule proxy_connect_module modules/mod_proxy_connect.so
LoadModule proxy_ftp_module modules/mod_proxy_ftp.so
LoadModule proxy_http_module modules/mod_proxy_http.so
<IfDefine SSL>
LoadModule ssl_module modules/mod_ssl.so
</IfDefine>


# Near the bottom of httpd.conf you put the port 563 virtual host:

Listen 563

<VirtualHost *:563>

   # Allow proxy CONNECT requests *only* to port 5915.
   # If the machines use different ports, e.g. 5916 list them here as well:
   #
   ProxyRequests On
   AllowCONNECT 5915

   RewriteEngine On

   # Convenience rules to expand applet parameters.  These do not have a traili
ng "/"
   #
   # /vnc   for http jar file downloading:
   #
   RewriteRule /vnc/([^/]+)$               /vnc/$1/index.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1 [R,NE,L]
   RewriteRule /vnc/trust/([^/]+)$         /vnc/$1/index.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&trustAllVncCerts=yes [R,NE,L]
   RewriteRule /vnc/proxy/([^/]+)$         /vnc/$1/proxy.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes [R,NE,L]
   RewriteRule /vnc/trust/proxy/([^/]+)$   /vnc/$1/proxy.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes&trustAllVncCerts=yes [R,NE,L]

   # Read in the allowed host to vnc display mapping file.  It looks like:
   #
   #   host1     15
   #   host2     15
   #   ...
   #
   # the display "15" means 5815 for http applet download, 5915 for SSL vnc.
   #
   RewriteMap vnchosts txt:/dist/apache/conf/vnc.hosts

   # Proxy: check for the CONNECT hostname and port being in the vnc.hosts list
.
   #
   RewriteCond %{THE_REQUEST} ^CONNECT [NC]
   RewriteCond %{REQUEST_URI} ^(.*):(.*)$
   RewriteCond ${vnchosts:%1|NOTFOUND} NOTFOUND
   RewriteRule ^.*$ /VNCFAIL [F,L]

   RewriteCond %{THE_REQUEST} ^CONNECT [NC]
   RewriteCond %{REQUEST_URI} ^(.*):(.*)$
   RewriteCond 59${vnchosts:%1}=%2 !^(.*)=(\1)$
   RewriteRule ^.*$ /VNCFAIL [F,L]


   # Remap /vnc to the proxy http download (e.g. http://host:5815)
   #
   # First, fail if it starts with the string /vnc0:
   #
   RewriteRule ^/vnc0.*            /VNCFAIL [F,L]
   #
   # Next, map the prefix to /vnc0/host:protocol:port
   #
   RewriteRule ^/vnc/([^/]+)/(.*)  /vnc0/$1:http:58${vnchosts:$1|NOTFOUND}/$2
[NE]
   #
   # Drop any not found:
   #
   RewriteRule ^/vnc0.*NOTFOUND.*  /VNCFAIL [F,L]

   # Construct the proxy URL and retrieve it:
   #
   RewriteRule ^/vnc0/([^/]+):([^/]+):([^/]+)/(.*) $2://$1:$3/$4 [P,NE,L]

</VirtualHost>

   Then restart apache (perhaps: "apachectl stop; apachectl start").

   Note that the listing of allowed internal workstations is done in an
   external file (/dist/apache/conf/vnc.hosts in the example above), the
   format is like this:
# allowed vnc hosts file:
hostname1  15
hostname2  15
...

   You list the hostname and the VNC display (always 15 in our example).
   Only to these hosts will the external VNC viewers be able to connect
   to (via the HTTP CONNECT method).

   The above setup requires mod_rewrite and mod_proxy be enabled in the
   apache web server. In this example they are loaded as modules (and
   note that mod_rewrite must be listed before mod_proxy);

   The user at the Java enabled Web browser would simply enter this URL
   into the browser:
   http://www.gateway.east:563/vnc/host2

   to connect to internal workstation host2, etc.

   Important: do not put a trailing "/" on the URL, since that will
   defeat the RewriteRules that look for the hostname at the very end.

   There will be a number of SSL certificate, etc, dialogs he will have
   to respond to in addition to any passwords he is required to provide
   (this depends on how you set up user authentication for x11vnc).

   If a second Web proxy is involved (i.e. the user's browser is inside
   another firewall and policy requires using a Web proxy server) then
   use this URL:
   http://www.gateway.east:563/vnc/proxy/host2

   This will involve downloading a signed java viewer applet jar file
   that is able to interact with the internal proxy for the VNC
   connection. See this FAQ for more info on how this works. Note:
   sometimes with the Proxy case if you see 'Bad Gateway' error you will
   have to wait 10 or so seconds and then hit reload. This seems to be
   due to having to wait for a Connection Keepalive to terminate...

   For completeness, the "trust" cases that skip a VNC certificate dialog
   (discussed below) would be entered as:
   http://www.gateway.east:563/vnc/trust/host2
   http://www.gateway.east:563/vnc/trust/proxy/host2

   You can of course choose shorter or more easy to remember URL formats.
   Just change the Convenience RewriteRules in httpd.conf.

     _________________________________________________________________

   Port Variations:

   Note that you can run this on the default HTTP port 80 instead of port
   563. If you do not expect to have a browser connecting from inside a
   proxying firewall (where sometimes only connections to ports 443 and
   563 are allowed) this should be fine. Use "80" instead of "563" in the
   httpd.conf config file (you may need to merge it with other default
   port 80 things you have there).

   Then the URL's will be a bit simpler:
   http://www.gateway.east/vnc/host2
   http://www.gateway.east/vnc/trust/host2

   etc.

   Besides 80 one could use any other random port number (since there are
   so many port scans on 80, a little obscurity might be useful).

   One option is to use port "443" (the default https:// port) instead of
   "563". In this case Apache is not configured for mod_ssl; we just
   happen to use port "443" in the way any random port would be used.
   This could be handy if the Viewer side environment is restrictive in
   that it only allows outgoing connections to ports 80 and 443 (and,
   say, you didn't want to use port 80, or you wanted to use 80 for
   something else). Another reason for using 443 would be some web proxy
   environments only allow the CONNECT method to go to port 443 (and not
   even the case 563 we use above).

     _________________________________________________________________

   Details:

   Let's go through the httpd.conf additions in detail from the top.

   The LoadModules directives load the necessary apache modules. Note
   that mod_rewrite must be listed first. If you are compiling from
   scratch something like this worked for us:
  ./configure --enable-proxy=shared --enable-proxy-connect=shared --enable-ssl=
shared --enable-rewrite=shared --prefix=/dist/apache

   Then the VirtualHost *:563 virtual host section starts.

   The "ProxyRequests On" and "AllowCONNECT 5915" enable the web server
   to forward proxy requests to port 5915 (and only this port) INSIDE the
   firewall. Think about the implications of this thoroughly and test it
   carefully.

   The RewriteRule's are for convenience only so that the URL entered
   into the Web browser does not need the various extra parameters, e.g.:
   http://www.gateway.east:563/vnc/host2/index.vnc?CONNECT=host2+5915&PORT=563,
blah,blah...

   (or otherwise make direct edits to index.vnc to set these parameters).
   The forceProxy=yes parameter is passed to the applet to force the use
   of a outgoing proxy socket connection. Use it only if the Web browser
   is inside a separate Web proxying environment (i.e. large corporation)

   The rewrites with parameter urlPrefix are described under Tricks for
   Better Response. The "trust" ones (also described under Tricks) with
   trustAllVncCerts tell the Java VNC applet to skip a dialog asking
   about the VNC Certificate. They are a bit faster and more reliable
   than the original method. In the best situation they lead to being
   logged in 20 seconds or less (without them the time to login can be
   much longer since a number of connections must timeout).

   All of the x11vnc Java Viewer applet parameters are described in the
   file classes/ssl/README

   The external file /dist/apache/conf/vnc.hosts containing the allowed
   VNC server hostnames is read in. Its 2nd column contains the VNC
   display of the host (always 15 in our example; if you make it vary you
   will need to adjust some lines in the httpd.conf accordingly, e.g.
   AllowCONNECT). This list is used to constrain both the Jar file
   download URL and the proxy CONNECT the VNC viewer makes to only the
   intended VNC servers.

   Limiting the proxy CONNECT is done with the two sets of RewriteCond
   conditions.

   Limiting the Jar file download URL is done in the remaining 4
   RewriteRule's.

   Note that these index.vnc and VncViewer.jar downloads to the browser
   are not encrypted via SSL, and so in principle could be tampered with
   by a really bad guy. The subsequent VNC connection, however, is
   encrypted through a single SSL connection (it makes a CONNECT straight
   to x11vnc). See below for how to have these initial downloads
   encrypted as well (if the apache web server has SSL/mod_ssl, i.e.
   https, enabled and configured).

   Unfortunately the Java VNC viewer applet currently is not able to save
   its own list of Certificates (e.g. the user says trust this VNC
   certificate 'always'). This is because an applet it cannot open local
   files, etc. Sadly, the applet cannot even remember certificates in the
   same browser session because it is completely reinitialized for each
   connection (see below).

     _________________________________________________________________

   Too Much?

   If these apache rules are a little too much for you, there is a little
   bit simpler scheme where you have to list each of the individual
   machines in the httpd.conf and ssl.conf files. It may be a little more
   typing to maintain, but perhaps being more straight forward (less
   RewriteRule's) is desirable.

     _________________________________________________________________

   Problems?

   To see example x11vnc output for a successful https://host:5900/
   connection with the Java Applet see This Page.

     _________________________________________________________________

   Some Ideas for adding extra authentication, etc. for the paranoid:
     * VNC passwords: -rfbauth, -passwdfile, or -usepw. Even adding a
       simple company-wide VNC password helps block unwanted access.
     * Unix passwords: -unixpw
     * SSL Client certificates: -sslverify
     * Apache AuthUserFile directive: .htaccess, etc.
     * Filter connections based on IP address or hostname.
     * Use Port-knocking on your firewall as described in: Enhanced
       TightVNC Viewer (ssvnc).
     * Add proxy password authentication (requires Viewer changes?)
     * Run a separate instance of Apache that provides this VNC service
       so it can be brought up and down independently of the normal web
       server.
     * How secure is the Client side? Public machines in internet cafes,
       etc, are often hacked, with backdoors and VNC servers of their
       own. Prefer using your own firewalled laptop to a public machine.


     _________________________________________________________________

   Using non-Java viewers with this scheme:

   The ss_vncviewer stunnel wrapper script for VNC viewers has the -proxy
   option that can take advantage of this method.
   ss_vncviewer -proxy www.gateway.east:563   host1:15

   For the case of the "double proxy" situation (see below) supply both
   separated by a comma.
   ss_vncviewer -proxy proxy1.foobar.com:8080,www.gateway.east:563   host1:15

   For the Enhanced TightVNC Viewer (ssvnc) GUI (it uses ss_vncviewer on
   Unix) put 'host1:15' into the 'VNC Server' entry box, and here are
   possible Proxy/Gateway entries
   Proxy/Gateway:   www.gateway.east:563
   Proxy/Gateway:   proxy1.foobar.com:8080,www.gateway.east:563

   then click on the 'Connect' button.

     _________________________________________________________________

   Downloading the Java applet to the browser via HTTPS:

   To have the Java applet downloaded to the user's Web Browser via an
   encrypted (and evidently safer) SSL connection the Apache webserver
   should be configured for SSL via mod_ssl.

   It is actually possible to use the x11vnc Key Management utility
   "-sslGenCert" to generate your Apache/SSL .crt and .key files. (In
   brief, run something like "x11vnc -sslGenCert server self:apache" then
   copy the resulting self:apache.crt file to conf/ssl.crt/server.crt and
   extract the private key part from self:apache.pem and paste it into
   conf/ssl.key/server.key). Setting the env var REQ_ARGS='-days 1095'
   before running x11vnc will bump up the expiration date (3 years in
   this case).

   Or you can use the standard methods described in the Apache mod_ssl
   documentation to create your keys. Then restart Apache, usually
   something like "apachectl stop" followed by "apachectl startssl"

   In addition to the above sections in httpd.conf one should add the
   following to ssl.conf:
   SSLProxyEngine  On

   RewriteEngine On

   # Convenience rules to expand applet parameters.  These do not have a traili
ng "/"
   #
   # /vnc   http jar file downloading:
   #
   RewriteRule /vnc/([^/]+)$                        /vnc/$1/index.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vnc_2F_$1 [R,NE,L]
   RewriteRule /vnc/proxy/([^/]+)$                  /vnc/$1/proxy.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes [R,N
E,L]
   #
   # (we skipped the "trust" ones above, put them in if you like)
   #
   # /vncs  https jar file downloading:
   #
   RewriteRule /vncs/([^/]+)$                      /vncs/$1/index.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1 [R,NE,L]
   RewriteRule /vncs/proxy/([^/]+)$                /vncs/$1/proxy.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes [R,
NE,l]
   RewriteRule /vncs/trust/([^/]+)$                /vncs/$1/index.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&trustAllVncCerts=y
es [R,NE,L]
   RewriteRule /vncs/trust/proxy/([^/]+)$          /vncs/$1/proxy.vnc?CONNECT=$
1+5915&PORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes&tru
stAllVncCerts=yes [R,NE,L]

   # Convenience rules used for the connect_switch helper (requires Listen 127.
0.0.1:443 above):
   #
   RewriteRule /vnc443/([^/]+)$                    /vncs/$1/index.vnc?CONNECT=$
1+5915&PORT=443&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1 [R,NE,L]
   RewriteRule /vnc443/proxy/([^/]+)$              /vncs/$1/proxy.vnc?CONNECT=$
1+5915&PORT=443&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes [R,
NE,L]
   RewriteRule /vnc443/trust/([^/]+)$              /vncs/$1/index.vnc?CONNECT=$
1+5915&PORT=443&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&trustAllVncCerts=y
es [R,NE,L]
   RewriteRule /vnc443/trust/proxy/([^/]+)$        /vncs/$1/proxy.vnc?CONNECT=$
1+5915&PORT=443&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes&tru
stAllVncCerts=yes [R,NE,L]

   # Read in the allowed host to vnc display mapping file.  It looks like:
   #
   #   host1     15
   #   host2     15
   #   ...
   #
   # the display "15" means 5915 for SSL VNC and 5815 for http applet download.
   #
   RewriteMap vnchosts txt:/dist/apache/conf/vnc.hosts


   # Remap /vnc and /vncs to the proxy http download (e.g. https://host:5915)
   #
   # First, fail if it starts with the string /vnc0:
   #
   RewriteRule ^/vnc0.*            /VNCFAIL [F,L]
   #
   # Next, map the prefix to /vnc0:host:protocol:port
   #
   RewriteRule ^/vnc/([^/]+)/(.*)  /vnc0/$1:http:58${vnchosts:$1|NOTFOUND}/$2
[NE]
   RewriteRule ^/vncs/([^/]+)/(.*) /vnc0/$1:https:59${vnchosts:$1|NOTFOUND}/$2
[NE]
   #
   # Drop any not found:
   #
   RewriteRule ^/vnc0.*NOTFOUND.*  /VNCFAIL [F,L]

   # Construct the proxy URL and retrieve it:
   #
   RewriteRule ^/vnc0/([^/]+):([^/]+):([^/]+)/(.*) $2://$1:$3/$4 [P,NE,L]

   This is all in the "<VirtualHost _default_:443>" section of ssl.conf.

   The user could then point the Web Browser to:
   https://www.gateway.east/vnc/host2

   or
   https://www.gateway.east/vnc/proxy/host2

   for the "double proxy" case. (Important: do not put a trailing "/" on
   the URL, since that will defeat the RewriteRules.)

   As with the httpd.conf case, the external file
   (/dist/apache/conf/vnc.hosts in the above example) contains the
   hostnames of the allowed VNC servers.

   Note that inside the firewall the Java applet download traffic is not
   encrypted (only over the Internet is SSL used) for these cases:
   https://www.gateway.east/vnc/host2
   https://www.gateway.east/vnc/proxy/host2

   However for the special "vncs" rules above:
   https://www.gateway.east/vncs/host2

   the Java applet download is encrypted via SSL for both legs. Note that
   the two legs are two separate SSL sessions. So the data is decrypted
   inside an apache process and reencrypted by the apache process for the
   2nd SSL session inside the same apache process (a very small gap one
   might overlook).

   The "vncs/trust" ones are like the "trust" ones described earlier
   https://www.gateway.east/vncs/trust/mach2

   and similarly for the httpsPort ones. See Tricks for Better Response.

   In all of the above cases the VNC traffic from Viewer to x11vnc is
   encrypted end-to-end in a single SSL session, even for the "double
   proxy" case because the CONNECT method is used (there are actually two
   CONNECT's for the "double proxy" case). This part (the VNC traffic) is
   the most important part to have encrypted.

   Note that the Certificate dialogs the user has in his web browser will
   be for the Apache Certificate, while for the Java applet it will be
   the x11vnc certificate.

   Note also that you can have Apache serve up the Jar file VncViewer.jar
   and/or index.vnc/proxy.vnc instead of each x11vnc if you want to.

   The rules in ssl.conf are similar to the ones in httpd.conf and so are
   not discussed in detail. The only really new thing is the /vncs
   handling to download the applet jar via HTTPS on port 5915.

   The special entries "/vnc443" are only used for the special helper
   program (connect_switch) for the https port 443 only mode discussed
   here.

     _________________________________________________________________

   INETD automation:

   The "single-port" (i.e. 5915) HTTPS applet download and VNC connection
   aspect shown here is convenient and also enables having x11vnc run out
   of inetd. That way x11vnc is run on demand instead of being run all
   the time (the user does not have to remember to start it). The first
   connections to inetd download index.vnc and the Jar file (via https)
   and the the last connection to inetd establishes the SSL VNC
   connection. Since x11vnc is restarted for each connection, this will
   be a bit slower than the normal process.

   For example, the /etc/inetd.conf line could be:
  5915 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc_ssl.sh

   where the script x11vnc_ssl.sh looks something like this:
#!/bin/sh

/usr/local/bin/x11vnc -inetd -oa /var/log/x11vnc-15.log \
        -ssl SAVE -http -unixpw -localhost \
        -display :0 -auth /home/THE_USER/.Xauthority

   where, as usual, the inetd launching needs to know which user is
   typically using the display on that machine. One could imagine giving
   different users different ports, 5915, 5916, etc. to distinguish (then
   the script would need to be passed the username). mod_rewrite could be
   used to automatically map username in the URL to his port number.

   A better way is to use the "-display WAIT:cmd=FINDDISPLAY" feature to
   autodetect the user and Xauthority data:
#!/bin/sh

/usr/local/bin/x11vnc -inetd -oa /var/log/x11vnc-15.log \
        -ssl SAVE -http -unixpw -localhost -users unixpw= \
        -find

   (we have used the alias -find for "-display WAIT:cmd=FINDDISPLAY".)
   This way the user must supply his Unix username and password and then
   his display and Xauthority data on that machine will be located and
   returned to x11vnc to allow it to attach. If he doesn't have a display
   running on that machine or he fails to log in correctly, the
   connection will be dropped.

   The variant "-display WAIT:cmd=FINDCREATEDISPLAY" (aliased by
   "-create") will actually create a (virtual or real) X server session
   for the user if one doesn't already exist. See here for details.

   To enable inetd operation for the non-HTTPS Java viewer download (port
   5815 in the above httpd.conf example) you will need to run x11vnc in
   HTTPONCE mode on port 5815: For example, the /etc/inetd.conf line
   could be:
  5815 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc \
       -inetd -prog /usr/local/bin/x11vnc -oa /var/log/x11vnc-15.log \
       -http_ssl -display WAIT:cmd=HTTPONCE

   where the long inetd.conf line has been split. Note how the -http_ssl
   tries to automatically find the .../classes/ssl subdirectory. This
   requires the -prog option available in x11vnc 0.8.4 (a shell script
   wrapper, e.g. /usr/local/bin/x11vnc_http.sh can be used to work around
   this).

   Also note the use of "-ssl SAVE" above. This way a saved server.pem is
   used for each inetd invocation (rather generating a new one each time
   as happens for "-ssl TMP"). Note that it cannot have a protecting
   passphrase because inetd will not be able to supply it.

   Another option is:
  5815 stream tcp nowait root /usr/sbin/tcpd /usr/local/bin/x11vnc \
       -inetd -httpdir /usr/local/share/x11vnc/classes/ssl \
       -oa /var/log/x11vnc-15.log -display WAIT:cmd=HTTPONCE

   (this also requires a feature found in x11vnc 0.8.4).
     _________________________________________________________________

   Other Ideas:

   - The above schemes work, but they are a bit complicated with all of
   the rigging. There should be more elegant ways to configure Apache to
   do these, but we have not found them (please let us know if you
   discover something nice). However, once this scheme has been set up
   and is working it is easy to maintain and add/delete workstations,
   etc.

   - In general Apache is not required, but it makes things convenient.
   The firewall itself could do the port redirection via its firewall
   rules. Evidently different Internet-facing ports would be required for
   each workstation. This could be set up using iptables rules for
   example. If there were just one or two machines this would be the
   easiest method. For example:
  iptables -t nat -A PREROUTING -p tcp -d 24.35.46.57 --dport 5901 -j DNAT --to
-destination 192.168.1.2:5915
  iptables -t nat -A PREROUTING -p tcp -d 24.35.46.57 --dport 5902 -j DNAT --to
-destination 192.168.1.3:5915

   Where 24.35.46.57 is the internet IP address of the gateway. In this
   example 24.35.46.57:5901 is redirected to the internal machine
   192.168.1.2:5915 and 24.35.46.57:5902 is redirected to another
   internal machine 192.168.1.3:5915, both running x11vnc -ssl ... in SSL
   mode. For this example, the user would point the web browser to, e.g.:
  https://24.35.46.57:5901/?PORT=5901

   or using the stunnel wrapper script:
  ss_vncviewer 24.35.46.57:1

   One can achieve similar things with dedicated firewall/routers (e.g.
   Linksys) using the device's web or other interface to configure the
   firewall.

   If the user may be coming out of a firewall using a proxy it may be
   better to redirect ports 443 and 563 (instead of 5901 and 5902) to the
   internal machines so that the user's proxy will allow CONNECTing to
   them.

   - The redirection could also be done at the application level using a
   TCP redirect program (e.g. ip_relay or fancier ones). Evidently more
   careful internal hostname checking, etc., could be performed by the
   special purpose application to add security. See connect_switch which
   is somewhat related.

   - One might imagine the ProxyPass could be done for the VNC traffic as
   well (for the ssl.conf case) to avoid the CONNECT proxying completely
   (which would be nice to avoid). Unfortunately we were not able to get
   this to work. Since HTTP is a request-response protocol (as opposed to
   a full bidirectional link required by VNC that CONNECT provides) this
   makes it difficult to do. It may be possible, but we haven't found out
   how yet.

   All of the x11vnc Java Viewer applet parameters are described in the
   file classes/ssl/README

     _________________________________________________________________

   Tricks for Better Response and reliability:

   The "original scheme" using httpd.conf and ssl.conf rewrites without
   urlPrefix and trustAllVncCerts above should work OK, but may lead to
   slow and/or unreliable loading of the applet and final connection to
   x11vnc. The following are what I do now to get better response and
   reliability. YMMV.

   The problem with the "original scheme" is that there is a point where
   the VNC Viewer applet can try up to 3 times to retrieve the x11vnc
   certificate, since it needs to get it to show it to you and ask you if
   you accept it. This can add about 45 seconds to the whole process
   (which takes 1 to 1.5 minutes with all the dialogs) since a couple of
   those connections must time out. The "trust" items in the config add a
   parameter trustAllVncCerts=yes similar to the forceProxy=yes
   parameter. This can cut the total time to the VNC password prompt down
   to 15 seconds which is pretty good. (Note by ignoring the certificate
   this does not protect against man-in-the-middle attacks which are
   rare, but maybe the won't be so rare in the future... see
   dsniff/webmitm and cain)

   First make sure the x11vnc SSL certificate+key is the same as
   Apache's. (otherwise you may get one extra dialog and/or one extra
   connection that has to time out).

   The following RewriteRule's are the same now advocated in the
   instructions above.

   The httpsPort and urlPrefix= parameters give hints to the applet to
   improve connecting: This is what goes in httpd.conf:
   RewriteEngine On
   RewriteRule /vnc/([^/]+)$               /vnc/$1/index.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1 [R,NE]
   RewriteRule /vnc/trust/([^/]+)$         /vnc/$1/index.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&trustAllVncCerts=yes [R,NE]
   RewriteRule /vnc/proxy/([^/]+)$         /vnc/$1/proxy.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes [R,NE]
   RewriteRule /vnc/trust/proxy/([^/]+)$   /vnc/$1/proxy.vnc?CONNECT=$1+5915&PO
RT=563&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes&trustAllVncCerts=yes [R,NE]

   The httpsPort and urlPrefix provide useful hints to the VNC Viewer
   applet when it connects to x11vnc to glean information about Proxies,
   certificates, etc.

   This is what goes into ssl.conf:
   RewriteEngine On
   RewriteRule /vnc/([^/]+)$                /vnc/$1/index.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vnc_2F_$1 [R,NE]
   RewriteRule /vnc/proxy/([^/]+)$          /vnc/$1/proxy.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vnc_2F_$1&forceProxy=yes [R,NE]
   RewriteRule /vncs/([^/]+)$              /vncs/$1/index.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1 [R,NE]
   RewriteRule /vncs/proxy/([^/]+)$        /vncs/$1/proxy.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes [R,NE]
   RewriteRule /vncs/trust/([^/]+)$        /vncs/$1/index.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&trustAllVncCerts=yes [R,NE
]
   RewriteRule /vncs/trust/proxy/([^/]+)$  /vncs/$1/proxy.vnc?CONNECT=$1+5915&P
ORT=563&httpsPort=443&GET=1&urlPrefix=_2F_vncs_2F_$1&forceProxy=yes&trustAllVnc
Certs=yes [R,NE]

   The rest is the same.

   The httpsPort and urlPrefix and GET provide useful hints to the VNC
   Viewer applet when it connects to x11vnc to glean information about
   Proxies, certificates, etc, and also for the ultimate VNC connection
   (GET speeds this up by sending a special HTTP GET to cause x11vnc to
   immediately switch to the VNC protocol).

   To turn these into URLs, as was done above, take the string in the
   RewriteRule, e.g. /vncs and turn it into
   https://gateway/vncs/machinename Similarly for non-https:
   http://gateway:563/vnc/machinename

   If you use the 'trust' ones, you are performing NO checks, visual or
   otherwise, on the VNC SSL certificate. It is trusted without question.
   This speeds things up because it avoids a dialog about certificates,
   but of course has some risk WRT Man in the Middle attacks. I don't
   recommend them. It is better to use /vnc or /vncs and the first time
   you connect carefully check the Certificate and then tell your Browser
   and Java Virtual Machine to trust the certificate 'Always'. Then if
   you later get an unexpected dialog, you know something is wrong.
   Nearly always it is just a changed or expired certificate, but better
   safe than sorry...
	
=======================================================================
http://www.karlrunge.com/x11vnc/enhanced_tightvnc_viewer.html:


     _________________________________________________________________

Enhanced TightVNC Viewer   (SSVNC:   SSL/SSH VNC viewer)

   (To Downloads)  (To Quick Start)

   [ssvnc.gif] [ssvnc_windows.gif] [ssvnc_macosx.gif] . .


   The Enhanced TightVNC Viewer, SSVNC, adds encryption security to VNC
   connections.

   The package provides a GUI for Windows, Mac OS X, and Unix that
   automatically starts up an STUNNEL SSL tunnel for SSL or ssh/plink for
   SSH connections to any VNC server, such as x11vnc, and then launches
   the VNC Viewer to use the encrypted tunnel.

   The x11vnc server has built-in SSL support, however SSVNC can make SSL
   encrypted VNC connections to any VNC Server if they are running an SSL
   tunnel, such as STUNNEL or socat, at their end. SSVNC's SSH tunnel
   will work to any VNC Server host running sshd that you can log into.

   The Enhanced TightVNC Viewer package started as a project to add some
   patches to the long neglected Unix TightVNC Viewer. However, now the
   front-end GUI, encryption, and wrapper scripts features possibly
   outweigh the Unix TightVNC Viewer improvements (see the lists below to
   compare).

   The SSVNC Unix vncviewer can also be run without the SSVNC encryption
   GUI as an enhanced replacement for the xvncviewer, xtightvncviewer,
   etc., viewers.

   In addition to normal SSL, SSVNC also supports the VeNCrypt SSL/TLS
   and Vino/ANONTLS encryption extensions to VNC on Unix, Mac OS X, and
   Windows. Via the provided SSVNC VeNCrypt bridge, VeNCrypt and ANONTLS
   encryption also works with any third party VNC Viewer (e.g. RealVNC,
   TightVNC, UltraVNC, etc...) you select via 'Change VNC Viewer'.

   The short name for this project is "ssvnc" for SSL/SSH VNC Viewer.
   This is the name of the command to start it.

   There is a simplified SSH-Only mode (sshvnc). And an even more
   simplified Terminal-Services mode (tsvnc) for use with x11vnc on the
   remote side.

   The tool has many additional features; see the descriptions below.

   It is a self-contained bundle, you could carry it around on, say, a
   USB memory stick / flash drive for secure VNC viewing from almost any
   machine, Unix, Mac OS X, and Windows (and if you create a directory
   named "Home" in the toplevel ssvnc directory on the drive your VNC
   profiles and certs will be kept there as well). For Unix, there is
   also a conventional source tarball to build and install in the normal
   way and not use a pre-built bundle.

     _________________________________________________________________

    Announcements:

   Important: If you created any SSL certificates with SSVNC (or anything
   else) on a Debian or Ubuntu system from Sept. 2006 through May 2008,
   then those keys are likely extremely weak and can be easily cracked.
   The certificate files should be deleted and recreated on a non-Debian
   system or an updated one. See
   http://www.debian.org/security/2008/dsa-1571 for details. The same
   applies to SSH keys.

   Please read this information on using SSVNC on workstations with
   Untrusted Local Users.

     _________________________________________________________________

    Feature List:

   Wrapper scripts and a tcl/tk GUI were written to create these features
   for Unix, Mac OS X, and Windows:
     * SSL support for connections using the bundled stunnel program.
     * Automatic SSH connections from the GUI (system ssh is used on Unix
       and MacOS X; bundled plink is used on Windows)
     * Ability to Save and Load VNC profiles for different hosts.
     * You can also use your own VNC Viewer, e.g. UltraVNC or RealVNC,
       with the SSVNC encryption GUI front-end if you prefer.
     * Create or Import SSL Certificates and Private Keys.
     * Reverse (viewer listening) VNC connections via SSL and SSH.
     * VeNCrypt SSL/TLS VNC encryption support (used by VeNCrypt, QEMU,
       ggi, libvirt/virt-manager/xen, vinagre/gvncviewer/gtk-vnc)
     * ANONTLS SSL/TLS VNC encryption support (used by Vino)
     * VeNCrypt and ANONTLS are also enabled for any 3rd party VNC Viewer
       (e.g. RealVNC, TightVNC, UltraVNC ...) on Unix, MacOSX, and
       Windows via the provided SSVNC VeNCrypt Viewer Bridge tool (use
       'Change VNC Viewer' to select the one you want.)
     * Support for Web Proxies, SOCKS Proxies, and the UltraVNC repeater
       proxy (e.g. repeater://host:port+ID:1234). Multiple proxies may be
       chained together (3 max).
     * Support for SSH Gateway connections and non-standard SSH ports.
     * Automatic Service tunnelling via SSH for CUPS and SMB Printing,
       ESD/ARTSD Audio, and SMB (Windows/Samba) filesystem mounting.
     * Sets up any additional SSH port redirections that you want.
     * Zeroconf (aka Bonjour) is used on Unix and Mac OS X to find VNC
       servers on your local network if the avahi-browse or dns-sd
       program is available and in your PATH.
     * Port Knocking for "closed port" SSH/SSL connections. In addition
       to a simple fixed port sequence and one-time-pad implementation, a
       hook is also provided to run any port knocking client before
       connecting.
     * Support for native MacOS X usage with bundled Chicken of the VNC
       viewer (the Unix X11 viewer is also provided for MacOS X, and is
       better IMHO. It is now the default on MacOS X.)
     * Dynamic VNC Server Port determination and redirection (using ssh's
       builtin SOCKS proxy, ssh -D) for servers like x11vnc that print
       out PORT= at startup.
     * Unix Username and Password entry for use with "x11vnc -unixpw"
       type login dialogs.
     * Simplified mode launched by command "sshvnc" that is SSH Only.
     * Simplified mode launched by command "tsvnc" that provides a VNC
       "Terminal Services" mode (uses x11vnc on the remote side).
     * IPv6 support for all connection modes on Unix, MacOSX, and
       Windows.

   Patches to TightVNC 1.3.9 vnc_unixsrc tree were created for Unix
   TightVNC Viewer improvements (these only apply to the Unix VNC viewer,
   including MacOSX XQuartz):
     * rfbNewFBSize VNC support (dynamic screen resizing)
     * Client-side Scaling of the Desktop in the viewer.
     * ZRLE VNC encoding support (RealVNC's encoding)
     * Support for the ZYWRLE encoding, a wavelet based extension to ZRLE
       to improve compression of motion video and photo regions.
     * TurboVNC support (VirtualGL's modified TightVNC encoding; requires
       TurboJPEG library)
     * Pipelined Updates of the framebuffer as in TurboVNC (asks for the
       next update before the current one has finished downloading; this
       gives some speedup on high latency connections.)
     * Cursor alphablending with x11vnc at 32bpp (-alpha option)
     * Option "-unixpw ..." for use with "x11vnc -unixpw" type login
       dialogs.
     * Support for UltraVNC extensions: 1/n Server side scaling, Text
       Chat, Single Window, Disable Server-side Input. Both UltraVNC and
       x11vnc servers support these extensions.
     * UltraVNC File Transfer via an auxiliary Java helper program (java
       must be in $PATH). Note that the x11vnc server also supports
       UltraVNC file transfer.
     * Connection support for the UltraVNC repeater proxy (-repeater
       option).
     * Support for UltraVNC Single Click operation. (both unencrypted: SC
       I, and SSL encrypted: SC III)
     * Support for UltraVNC DSM Encryption Plugin symmetric encryption
       mode. (ARC4, AESV2, MSRC4, and SecureVNC)
     * Support for UltraVNC MS-Logon authentication (NOTE: the UltraVNC
       MS-Logon key exchange implementation is very weak; an eavesdropper
       on the network can recover your Windows password easily in a few
       seconds; you need to use an additional encrypted tunnel with
       MS-Logon.)
     * Support for symmetric encryption (including blowfish and 3des
       ciphers) to Non-UltraVNC Servers. Any server using the same
       encryption method will work, e.g.:  x11vnc -enc blowfish:./my.key
     * Instead of hostname:display one can also supply "exec=command
       args..." to connect the viewer to the stdio of an external command
       (e.g. stunnel or socat) rather than using a TCP/IP socket. Unix
       domain sockets, e.g. /path/to/unix/socket, and a previously opened
       file descriptor fd=0, work too.
     * Local Port Protections for STUNNEL and SSH: avoid having for long
       periods of time a listening port on the the local (VNC viewer)
       side that redirects to the remote side.
     * Reverse (viewer listening) VNC connections can show a Popup dialog
       asking whether to accept the connection or not (-acceptpopup.) The
       extra info provided by UltraVNC Single Click reverse connections
       is also supported (-acceptpopupsc)
     * Extremely low color modes: 64 and 8 colors in 8bpp
       (-use64/-bgr222, -use8/-bgr111)
     * Medium color mode: 16bpp mode on a 32bpp Viewer display
       (-16bpp/-bgr565)
     * For use with x11vnc's client-side caching -ncache method use the
       cropping option -ycrop n. This will "hide" the large pixel buffer
       cache below the actual display. Set to the actual height or use -1
       for autodetection (also, tall screens, H > 2*W, are autodetected
       by default).
     * Escape Keys: specify a set of modifier keys so that when they are
       all pressed down you can invoke Popup menu actions via keystrokes.
       I.e., a set of 'Hot Keys'. One can also pan (move) the desktop
       inside the viewport via Arrow keys or a mouse drag.
     * Scrollbar width setting: -sbwidth n, the default is very thin, 2
       pixels, for less distracting -ycrop usage.
     * Selection text sending and receiving can be fine-tuned with the
       -sendclipboard, -sendalways, and -recvtext options.
     * TightVNC compression and quality levels are automatically set
       based on observed network latency (n.b. not bandwidth.)
     * Improvements to the Popup menu, all of these can now be changed
       dynamically via the menu: ViewOnly, Toggle Bell, CursorShape
       updates, X11 Cursor, Cursor Alphablending, Toggle Tight/ZRLE,
       Toggle JPEG, FullColor/16bpp/8bpp (256/64/8 colors), Greyscale for
       low color modes, Scaling the Viewer resolution, Escape Keys,
       Pipeline Updates, and others, including UltraVNC extensions.
     * Maintains its own BackingStore if the X server does not.
     * The default for localhost:0 connections is not raw encoding since
       same-machine connections are pretty rare. Default assumes you are
       using a SSL or SSH tunnel. Use -rawlocal to revert.
     * XGrabServer support for fullscreen mode, for old window managers
       (-grab/-graball option).
     * Fix for Popup menu positioning for old window managers (-popupfix
       option).
     * The VNC Viewer ssvncviewer supports IPv6 natively (no helpers
       needed.)

   The list of 3rd party software bundled in the archive files:
     * TightVNC Viewer  (windows, unix, macosx)
     * Chicken of the VNC Viewer  (macosx)
     * Stunnel  (windows, unix, macosx)
     * Putty/Plink/Pageant  (windows)
     * OpenSSL  (windows)
     * esound  (windows)

   These are all self-contained in the bundle directory: they will not be
   installed on your system. Just un-zip or un-tar the file you
   downloaded and run the frontend ssvnc straight from its directory.
   Alternatively, on Unix you can use the conventional source tarball.

     _________________________________________________________________

   Here is the Quick Start info from the README for how to setup and use
   SSVNC:
Quick Start:
-----------

Unix and Mac OS X:

    Inside a Terminal do something like the following.

    Unpack the archive:

        % gzip -dc ssvnc-1.0.29.tar.gz | tar xvf -

    Run the GUI:

        % ./ssvnc/Unix/ssvnc               (for Unix)

        % ./ssvnc/MacOSX/ssvnc             (for Mac OS X)

    The smaller file "ssvnc_no_windows-1.0.29.tar.gz"
    could have been used as well.

    On MacOSX you could also click on the SSVNC app icon in the Finder.

    On MacOSX if you don't like the Chicken of the VNC (e.g. no local
    cursors, no screen size rescaling, and no password prompting), and you
    have the XDarwin X server installed, you can set DISPLAY before starting
    ssvnc (or type DISPLAY=... in Host:Disp and hit Return).  Then our
    enhanced TightVNC viewer will be used instead of COTVNC.
    Update: there is now a 'Use X11 vncviewer on MacOSX' under Options ...


    If you want a SSH-only tool (without the distractions of SSL) run
    the command:

                sshvnc

    instead of "ssvnc".  Or click "SSH-Only Mode" under Options.
    Control-h will toggle between the two modes.


    If you want a simple VNC Terminal Services only mode (requires x11vnc
    on the remote server) run the command:

                tsvnc

    instead of "ssvnc".  Or click "Terminal Services" under Options.
    Control-t will toggle between the two modes.

    "tsvnc profile-name" and "tsvnc user@hostname" work too.


Unix/MacOSX Install:

    There is no standard install for the bundles, but you can make
    symlinks like so:

        cd /a/directory/in/PATH
        ln -s /path/to/ssvnc/bin/{s,t}* .

    Or put /path/to/ssvnc/bin, /path/to/ssvnc/Unix, or /path/to/ssvnc/MacOSX
    in your PATH.

    For the conventional source tarball it will compile and install, e.g.:

       gzip -dc ssvnc-1.0.29.src.tar.gz | tar xvf -
       cd ssvnc-1.0.29
       make config
       make all
       make PREFIX=/my/install/dir install

    then have /my/install/dir/bin in your PATH.



Windows:

    Unzip, using WinZip or a similar utility, the zip file:

        ssvnc-1.0.29.zip

    Run the GUI, e.g.:

        Start -> Run -> Browse

    and then navigate to

        .../ssvnc/Windows/ssvnc.exe

    select Open, and then OK to launch it.

    The smaller file "ssvnc_windows_only-1.0.29.zip"
    could have been used as well.

    You can make a Windows shortcut to this program if you want to.

    See the Windows/README.txt for more info.


    If you want a SSH-only tool (without the distractions of SSL) run
    the command:

                sshvnc.bat

    Or click "SSH-Only Mode" under Options.


    If you want a simple VNC Terminal Services only mode (requires x11vnc
    on the remote server) run the command:

                tsvnc.bat

    Or click "Terminal Services" under Options.  Control-t will toggle
    between the two modes.  "tsvnc profile-name" and "tsvnc user@hostname"
    work too.

     _________________________________________________________________

   You can read all of the SSVNC GUI's Online Help Text here.
     _________________________________________________________________

   The bundle unpacks a directory/folder named: ssvnc. It contains these
   programs to launch the GUI:
        Windows/ssvnc.exe        for Windows
        MacOSX/ssvnc             for Mac OS X
        Unix/ssvnc               for Unix

   (the Mac OS X and Unix launchers are simply links to the bin
   directory). See the README for more information.

   The SSH-Only mode launcher program has name sshvnc. The Terminal
   Services mode launcher program (assumes x11vnc 0.8.4 or later and Xvfb
   installed on the server machine) has name tsvnc.

   The Viewer SSL support is done via a wrapper script (bin/ssvnc_cmd
   that calls bin/util/ss_vncviewer) that starts up the STUNNEL tunnel
   first and then starts the TightVNC viewer pointed at that tunnel. The
   bin/ssvnc program is a GUI front-end to that script. See this FAQ for
   more details on SSL tunnelling. In SSH connection mode, the wrappers
   start up SSH appropriately.


   Memory Stick Usage: If you create a directory named "Home" in that
   toplevel ssvnc directory then that will be used as the base for
   storing VNC profiles and certificates. Also, for convenience, if you
   first run the command with "." as an argument (e.g. "ssvnc .") it will
   automatically create the "Home" directory for you. This is handy if
   you want to place SSVNC on a USB flash drive that you carry around for
   mobile use and you want the profiles you create to stay with the drive
   (otherwise you'd have to browse to the drive directory each time you
   load or save).

   One user on Windows created a BAT file to launch SSVNC and needed to
   do this to get the Home directory correct:
cd \ssvnc\Windows
start \ssvnc\Windows\ssvnc.exe

   (an optional profile name can be supplied to the ssvnc.exe line)

   WARNING: if you use ssvnc from an "Internet Cafe", i.e. some untrusted
   computer, please be aware that someone may have set up that machine to
   be capturing your keystrokes, etc.


   SSH-Only version: The command "sshvnc" can be run instead of "ssvnc"
   to get an SSH-only version of the tool:

   [sshvnc.gif]

   These also work: "sshvnc myprofile" and "sshvnc user@hostname". To
   switch from the regular SSVNC mode, click "SSH-Only Mode" under
   Options. This mode is less distracting if you never plan to use SSL,
   manage certificates, etc.


   Terminal Services Only: The command "tsvnc" can be run instead of
   "ssvnc" to get a "Terminal Services" only version of the tool:

   [tsvnc.gif]

   These also work: "tsvnc myprofile" and "tsvnc user@hostname". To
   switch from the regular SSVNC mode, click "Terminal Services" under
   Options.

   This mode requires x11vnc (0.9.3 or later) installed on the remote
   machine to find, create, and manage the user sessions. SSH is used to
   create the encrypted and authenticated tunnel. The Xvfb (virtual
   framebuffer X server) program must also be installed on the remote
   system. However tsvnc will also connect to a real X session (i.e. on
   the physical hardware) if you are already logged into the X session;
   this is a useful access mode and does not require Xvfb on the remote
   system.

   This mode should be very easy for beginner users to understand and
   use. On the remote end you only need to have x11vnc and Xvfb available
   in $PATH, and on the local end you just run something like:
   tsvnc myname@myhost.com

   (or start up the tsvnc GUI first and then enter myname@myhost.com and
   press "Connect").

   Normally the Terminal Services sessions created are virtual (RAM-only)
   ones (e.g. Xvfb, Xdummy, or Xvnc), however a nice feature is if you
   have a regular X session (i.e displaying on the physical hardware) on
   the remote machine that you are ALREADY logged into, then the x11vnc
   run from tsvnc will find it for you as well.

   Also, there is setting "X Login" under Advanced Options that allows
   you to attach to a real X server with no one logged in yet (i.e.
   XDM/GDM/KDM Login Greeter screen) as long as you have sudo(1)
   permission on the remote machine.

   Nice features to soon to be added to the tsvnc mode are easy CUPS
   printing (working fairly well) and Sound redirection (needs much work)
   of the Terminal Services Desktop session. It is easier in tsvnc mode
   because the entire desktop session can be started with the correct
   environment. ssvnc tries to handle the general case of an already
   started desktop and that is more difficult.


   Proxies: Web proxies, SOCKS proxies, and the UltraVNC repeater proxy
   are supported to allow the SSVNC connection to go through the proxy to
   the otherwise unreachable VNC Server. SSH gateway machines can be used
   in the same way. Read more about SSVNC proxy support here.


   Dynamic VNC Server Port determination: If you are running SSVNC on
   Unix and are using SSH to start the remote VNC server and the VNC
   server prints out the line "PORT=NNNN" to indicate which dynamic port
   it is using (x11vnc does this), then if you prefix the SSH command
   with "PORT=" SSVNC will watch for the PORT=NNNN line and uses ssh's
   built in SOCKS proxy (ssh -D ...) to connect to the dynamic VNC server
   port through the SSH tunnel. For example:
        VNC Host:Display     user@somehost.com
        Remote SSH Command:  PORT= x11vnc -find

   or "PORT= x11vnc -display :0 -localhost", etc. Or use "P= x11vnc ..."

   There is also code to detect the display of the regular Unix
   vncserver(1). It extracts the display (and hence port) from the lines
   "New 'X' desktop is hostname:4" and also "VNC server is already
   running as :4". So you can use something like:
        PORT= vncserver; sleep 15
or:     PORT= vncserver :4; sleep 15

   the latter is preferred because when you reconnect with it will find
   the already running one. The former one will keep creating new X
   sessions if called repeatedly.

   If you use PORT= on Windows, a large random port is selected instead
   and the -rfbport option is passed to x11vnc (it does not work with
   vncserver).



   Patches for Unix Tightvnc viewer:

   The rfbNewFBSize support allows the enhanced TightVNC Unix viewer to
   resize when the server does (e.g. "x11vnc -R scale=3/4" remote control
   command).

   The cursor alphablending is described here.

   The RealVNC ZRLE encoding is supported, in addition to some low colors
   modes (16bpp and 8bpp at 256, 64, and even 8 colors, for use on very
   slow connections). Greyscales are also enabled for the low color
   modes.

   The Popup menu (F8) is enhanced with the ability to change many things
   on the fly. F9 is added as a shortcut to toggle FullScreen mode.

   Client Side Caching: The x11vnc client-side caching is handled nicely
   by this viewer. The very large pixel cache below the actual display in
   this caching method is distracting. Our Unix VNC viewer will
   automatically try to autodetect the actual display height if the
   framebuffer is very tall (more than twice as high as it is wide). One
   can also set the height to the known value via -ycrop n, or use -ycrop
   -1 to force autodection. In fullscreen mode one is not possible to
   scroll down to the pixel cache region. In non-fullscreen mode the
   window manager frame is "shrink-wrapped" around the actual screen
   display. You can still scroll down to the pixel cache region. The
   scrollbars are set to be very thin (2 pixels) to be less distracting.
   Use the -sbwidth n to make them wider.

   Probably nobody is interested in the grabserver patch for old window
   managers when the viewer is in fullscreen mode... This and some other
   unfixed bugs have been fixed in our patches (fullscreen toggle works
   with KDE, -x11cursor has been fixed, and the dot cursor has been made
   smaller).

   From the -help output:
SSVNC Viewer (based on TightVNC viewer version 1.3.9)

Usage: vncviewer [<OPTIONS>] [<HOST>][:<DISPLAY#>]
       vncviewer [<OPTIONS>] [<HOST>][::<PORT#>]
       vncviewer [<OPTIONS>] exec=[CMD ARGS...]
       vncviewer [<OPTIONS>] fd=n
       vncviewer [<OPTIONS>] /path/to/unix/socket
       vncviewer [<OPTIONS>] -listen [<DISPLAY#>]
       vncviewer -help

<OPTIONS> are standard Xt options, or:
        -via <GATEWAY>
        -shared (set by default)
        -noshared
        -viewonly
        -fullscreen
        -noraiseonbeep
        -passwd <PASSWD-FILENAME> (standard VNC authentication)
        -user <USERNAME> (Unix login authentication)
        -encodings <ENCODING-LIST> (e.g. "tight,copyrect")
        -bgr233
        -owncmap
        -truecolour
        -depth <DEPTH>
        -compresslevel <COMPRESS-VALUE> (0..9: 0-fast, 9-best)
        -quality <JPEG-QUALITY-VALUE> (0..9: 0-low, 9-high)
        -nojpeg
        -nocursorshape
        -x11cursor
        -autopass

Option names may be abbreviated, e.g. -bgr instead of -bgr233.
See the manual page for more information.


Enhanced TightVNC viewer (SSVNC) options:

   URL http://www.karlrunge.com/x11vnc/ssvnc.html

   Note: ZRLE and ZYWRLE encodings are now supported.

   Note: F9 is shortcut to Toggle FullScreen mode.

   Note: In -listen mode set the env var. SSVNC_MULTIPLE_LISTEN=1
         to allow more than one incoming VNC server at a time.
         This is the same as -multilisten described below.  Set
         SSVNC_MULTIPLE_LISTEN=MAX:n to allow no more than "n"
         simultaneous reverse connections.

   Note: If the host:port is specified as "exec=command args..."
         then instead of making a TCP/IP socket connection to the
         remote VNC server, "command args..." is executed and the
         viewer is attached to its stdio.  This enables tunnelling
         established via an external command, e.g. an stunnel(8)
         that does not involve a listening socket.  This mode does
         not work for -listen reverse connections.

         If the host:port is specified as "fd=n" then it is assumed
         n is an already opened file descriptor to the socket. (i.e
         the parent did fork+exec)

         If the host:port contains a '/' it is interpreted as a
         unix-domain socket (AF_LOCAL insead of AF_INET)

        -multilisten  As in -listen (reverse connection listening) except
                    allow more than one incoming VNC server to be connected
                    at a time.  The default for -listen of only one at a
                    time tries to play it safe by not allowing anyone on
                    the network to put (many) desktops on your screen over
                    a long window of time. Use -multilisten for no limit.

        -acceptpopup  In -listen (reverse connection listening) mode when
                    a reverse VNC connection comes in show a popup asking
                    whether to Accept or Reject the connection.  The IP
                    address of the connecting host is shown.  Same as
                    setting the env. var. SSVNC_ACCEPT_POPUP=1.

        -acceptpopupsc  As in -acceptpopup except assume UltraVNC Single
                    Click (SC) server.  Retrieve User and ComputerName
                    info from UltraVNC Server and display in the Popup.

        -use64      In -bgr233 mode, use 64 colors instead of 256.
        -bgr222     Same as -use64.

        -use8       In -bgr233 mode, use 8 colors instead of 256.
        -bgr111     Same as -use8.

        -16bpp      If the vnc viewer X display is depth 24 at 32bpp
                    request a 16bpp format from the VNC server to cut
                    network traffic by up to 2X, then tranlate the
                    pixels to 32bpp locally.
        -bgr565     Same as -16bpp.

        -grey       Use a grey scale for the 16- and 8-bpp modes.

        -alpha      Use alphablending transparency for local cursors
                    requires: x11vnc server, both client and server
                    must be 32bpp and same endianness.

        -scale str  Scale the desktop locally.  The string "str" can
                    a floating point ratio, e.g. "0.9", or a fraction,
                    e.g. "3/4", or WxH, e.g. 1280x1024.  Use "fit"
                    to fit in the current screen size.  Use "auto" to
                    fit in the window size.  "str" can also be set by
                    the env. var. SSVNC_SCALE.

                    If you observe mouse trail painting errors, enable
                    X11 Cursor mode (either via Popup or -x11cursor.)

                    Note that scaling is done in software and so can be
                    slow and requires more memory.  Some speedup Tips:

                        ZRLE is faster than Tight in this mode.  When
                        scaling is first detected, the encoding will
                        be automatically switched to ZRLE.  Use the
                        Popup menu if you want to go back to Tight.
                        Set SSVNC_PRESERVE_ENCODING=1 to disable this.

                        Use a solid background on the remote side.
                        (e.g. manually or via x11vnc -solid ...)

                        If the remote server is x11vnc, try client
                        side caching: x11vnc -ncache 10 ...

        -ycrop n    Only show the top n rows of the framebuffer.  For
                    use with x11vnc -ncache client caching option
                    to help "hide" the pixel cache region.
                    Use a negative value (e.g. -1) for autodetection.
                    Autodetection will always take place if the remote
                    fb height is more than 2 times the width.

        -sbwidth n  Scrollbar width for x11vnc -ncache mode (-ycrop),
                    default is very narrow: 2 pixels, it is narrow to
                    avoid distraction in -ycrop mode.

        -nobell     Disable bell.

        -rawlocal   Prefer raw encoding for localhost, default is
                    no, i.e. assumes you have a SSH tunnel instead.

        -notty      Try to avoid using the terminal for interactive
                    responses: use windows for messages and prompting
                    instead.  Messages will also be printed to terminal.

        -sendclipboard  Send the X CLIPBOARD selection (i.e. Ctrl+C,
                        Ctrl+V) instead of the X PRIMARY selection (mouse
                        select and middle button paste.)

        -sendalways     Whenever the mouse enters the VNC viewer main
                        window, send the selection to the VNC server even if
                        it has not changed.  This is like the Xt resource
                        translation SelectionToVNC(always)

        -recvtext str   When cut text is received from the VNC server,
                        ssvncviewer will set both the X PRIMARY and the
                        X CLIPBOARD local selections.  To control which
                        is set, specify 'str' as 'primary', 'clipboard',
                        or 'both' (the default.)

        -graball    Grab the entire X server when in fullscreen mode,
                    needed by some old window managers like fvwm2.

        -popupfix   Warp the popup back to the pointer position,
                    needed by some old window managers like fvwm2.
        -sendclipboard  Send the X CLIPBOARD selection (i.e. Ctrl+C,
                        Ctrl+V) instead of the X PRIMARY selection (mouse
                        select and middle button paste.)

        -sendalways     Whenever the mouse enters the VNC viewer main
                        window, send the selection to the VNC server even if
                        it has not changed.  This is like the Xt resource
                        translation SelectionToVNC(always)

        -recvtext str   When cut text is received from the VNC server,
                        ssvncviewer will set both the X PRIMARY and the
                        X CLIPBOARD local selections.  To control which
                        is set, specify 'str' as 'primary', 'clipboard',
                        or 'both' (the default.)

        -graball    Grab the entire X server when in fullscreen mode,
                    needed by some old window managers like fvwm2.

        -popupfix   Warp the popup back to the pointer position,
                    needed by some old window managers like fvwm2.

        -grabkbd    Grab the X keyboard when in fullscreen mode,
                    needed by some window managers. Same as -grabkeyboard.
                    -grabkbd is the default, use -nograbkbd to disable.

        -bs, -nobs  Whether or not to use X server Backingstore for the
                    main viewer window.  The default is to not, mainly
                    because most Linux, etc, systems X servers disable
                    *all* Backingstore by default.  To re-enable it put

                        Option "Backingstore"

                    in the Device section of /etc/X11/xorg.conf.
                    In -bs mode with no X server backingstore, whenever an
                    area of the screen is re-exposed it must go out to the
                    VNC server to retrieve the pixels. This is too slow.

                    In -nobs mode, memory is allocated by the viewer to
                    provide its own backing of the main viewer window. This
                    actually makes some activities faster (changes in large
                    regions) but can appear to "flash" too much.

        -noshm      Disable use of MIT shared memory extension (not recommended
)

        -termchat   Do the UltraVNC chat in the terminal vncviewer is in
                    instead of in an independent window.

        -unixpw str Useful for logging into x11vnc in -unixpw mode. "str" is a
                    string that allows many ways to enter the Unix Username
                    and Unix Password.  These characters: username, newline,
                    password, newline are sent to the VNC server after any VNC
                    authentication has taken place.  Under x11vnc they are
                    used for the -unixpw login.  Other VNC servers could do
                    something similar.

                    You can also indicate "str" via the environment
                    variable SSVNC_UNIXPW.

                    Note that the Escape key is actually sent first to tell
                    x11vnc to not echo the Unix Username back to the VNC
                    viewer. Set SSVNC_UNIXPW_NOESC=1 to override this.

                    If str is ".", then you are prompted at the command line
                    for the username and password in the normal way.  If str is
                    "-" the stdin is read via getpass(3) for username@password.
                    Otherwise if str is a file, it is opened and the first line
                    read is taken as the Unix username and the 2nd as the
                    password. If str prefixed by "rm:" the file is removed
                    after reading. Otherwise, if str has a "@" character,
                    it is taken as username@password. Otherwise, the program
                    exits with an error. Got all that?

     -repeater str  This is for use with UltraVNC repeater proxy described
                    here: http://www.uvnc.com/addons/repeater.html.  The "str"
                    is the ID string to be sent to the repeater.  E.g. ID:1234
                    It can also be the hostname and port or display of the VNC
                    server, e.g. 12.34.56.78:0 or snoopy.com:1.  Note that when
                    using -repeater, the host:dpy on the cmdline is the repeate
r
                    server, NOT the VNC server.  The repeater will connect you.

                    Example: vncviewer ... -repeater ID:3333 repeat.host:5900
                    Example: vncviewer ... -repeater vhost:0 repeat.host:5900

                    Use, e.g., '-repeater SCIII=ID:3210' if the repeater is a
                    Single Click III (SSL) repeater (repeater_SSL.exe) and you
                    are passing the SSL part of the connection through stunnel,
                    socat, etc. This way the magic UltraVNC string 'testB'
                    needed to work with the repeater is sent to it.

     -rfbversion str Set the advertised RFB version.  E.g.: -rfbversion 3.6
                    For some servers, e.g. UltraVNC this needs to be done.

     -ultradsm      UltraVNC has symmetric private key encryption DSM plugins:
                    http://www.uvnc.com/features/encryption.html. It is assumed
                    you are using a unix program (e.g. our ultravnc_dsm_helper)
                    to encrypt and decrypt the UltraVNC DSM stream. IN ADDITION
                    TO THAT supply -ultradsm to tell THIS viewer to modify the
                    RFB data sent so as to work with the UltraVNC Server. For
                    some reason, each RFB msg type must be sent twice under DSM
.

     -mslogon user  Use Windows MS Logon to an UltraVNC server.  Supply the
                    username or "1" to be prompted.  The default is to
                    autodetect the UltraVNC MS Logon server and prompt for
                    the username and password.

                    IMPORTANT NOTE: The UltraVNC MS-Logon Diffie-Hellman
                    exchange is very weak and can be brute forced to recover
                    your username and password in a few seconds of CPU time.
                    To be safe, be sure to use an additional encrypted tunnel
                    (e.g. SSL or SSH) for the entire VNC session.

     -chatonly      Try to be a client that only does UltraVNC text chat. This
                    mode is used by x11vnc to present a chat window on the
                    physical X11 console (i.e. chat with the person at the
                    display).

     -env VAR=VALUE To save writing a shell script to set environment variables
,
                    specify as many as you need on the command line.  For
                    example, -env SSVNC_MULTIPLE_LISTEN=MAX:5 -env EDITOR=vi

     -noipv6        Disable all IPv6 sockets.  Same as VNCVIEWER_NO_IPV6=1.

     -noipv4        Disable all IPv4 sockets.  Same as VNCVIEWER_NO_IPV4=1.

     -printres      Print out the Ssvnc X resources (appdefaults) and then exit
                    You can save them to a file and customize them (e.g. the
                    keybindings and Popup menu)  Then point to the file via
                    XENVIRONMENT or XAPPLRESDIR.

     -pipeline      Like TurboVNC, request the next framebuffer update as soon
                    as possible instead of waiting until the end of the current
                    framebuffer update coming in.  Helps 'pipeline' the updates
.
                    This is currently the default, use -nopipeline to disable.

     -appshare      Enable features for use with x11vnc's -appshare mode where
                    instead of sharing the full desktop only the application's
                    windows are shared.  Viewer multilisten mode is used to
                    create the multiple windows: -multilisten is implied.
                    See 'x11vnc -appshare -help' more information on the mode.

                    Features enabled in the viewer under -appshare are:
                    Minimum extra text in the title, auto -ycrop is disabled,
                    x11vnc -remote_prefix X11VNC_APPSHARE_CMD: message channel,
                    x11vnc initial window position hints.  See also Escape Keys
                    below for additional key and mouse bindings.

     -escape str    This sets the 'Escape Keys' modifier sequence and enables
                    escape keys mode.  When the modifier keys escape sequence
                    is held down, the next keystroke is interpreted locally
                    to perform a special action instead of being sent to the
                    remote VNC server.

                    Use '-escape default' for the default modifier sequence.
                    (Unix: Alt_L,Super_L and MacOSX: Control_L,Meta_L)

    Here are the 'Escape Keys: Help+Set' instructions from the Popup Menu:

    Escape Keys:  Enter a comma separated list of modifier keys to be the
    'escape sequence'.  When these keys are held down, the next keystroke is
    interpreted locally to invoke a special action instead of being sent to
    the remote VNC server.  In other words, a set of 'Hot Keys'.

    To enable or disable this, click on 'Escape Keys: Toggle' in the Popup.

    Here is the list of hot-key mappings to special actions:

       r: refresh desktop  b: toggle bell   c: toggle full-color
       f: file transfer    x: x11cursor     z: toggle Tight/ZRLE
       l: full screen      g: graball       e: escape keys dialog
       s: scale dialog     +: scale up (=)  -: scale down (_)
       t: text chat                         a: alphablend cursor
       V: toggle viewonly  Q: quit viewer   1 2 3 4 5 6: UltraVNC scale 1/n

       Arrow keys:         pan the viewport about 10% for each keypress.
       PageUp / PageDown:  pan the viewport by a screenful vertically.
       Home   / End:       pan the viewport by a screenful horizontally.
       KeyPad Arrow keys:  pan the viewport by 1 pixel for each keypress.
       Dragging the Mouse with Button1 pressed also pans the viewport.
       Clicking Mouse Button3 brings up the Popup Menu.

    The above mappings are *always* active in ViewOnly mode, unless you set the
    Escape Keys value to 'never'.

    If the Escape Keys value below is set to 'default' then a default list of
    of modifier keys is used.  For Unix it is: Alt_L,Super_L and for MacOSX it
    is Control_L,Meta_L.  Note: the Super_L key usually has a Windows(TM) Flag
    on it.  Also note the _L and _R mean the key is on the LEFT or RIGHT side
    of the keyboard.

    On Unix   the default is Alt and Windows keys on Left side of keyboard.
    On MacOSX the default is Control and Command keys on Left side of keyboard.

    Example: Press and hold the Alt and Windows keys on the LEFT side of the
    keyboard and then press 'c' to toggle the full-color state.  Or press 't'
    to toggle the ultravnc Text Chat window, etc.

    To use something besides the default, supply a comma separated list (or a
    single one) from: Shift_L Shift_R Control_L Control_R Alt_L Alt_R Meta_L
    Meta_R Super_L Super_R Hyper_L Hyper_R or Mode_switch.


   New Popup actions:

        ViewOnly:                ~ -viewonly
        Disable Bell:            ~ -nobell
        Cursor Shape:            ~ -nocursorshape
        X11 Cursor:              ~ -x11cursor
        Cursor Alphablend:       ~ -alpha
        Toggle Tight/Hextile:    ~ -encodings hextile...
        Toggle Tight/ZRLE:       ~ -encodings zrle...
        Toggle ZRLE/ZYWRLE:      ~ -encodings zywrle...
        Quality Level            ~ -quality (both Tight and ZYWRLE)
        Compress Level           ~ -compresslevel
        Disable JPEG:            ~ -nojpeg  (Tight)
        Pipeline Updates         ~ -pipeline

        Full Color                 as many colors as local screen allows.
        Grey scale (16 & 8-bpp)  ~ -grey, for low colors 16/8bpp modes only.
        16 bit color (BGR565)    ~ -16bpp / -bgr565
        8  bit color (BGR233)    ~ -bgr233
        256 colors               ~ -bgr233 default # of colors.
         64 colors               ~ -bgr222 / -use64
          8 colors               ~ -bgr111 / -use8
        Scale Viewer             ~ -scale
        Escape Keys: Toggle      ~ -escape
        Escape Keys: Help+Set    ~ -escape
        Set Y Crop (y-max)       ~ -ycrop
        Set Scrollbar Width      ~ -sbwidth
        XGrabServer              ~ -graball

        UltraVNC Extensions:

          Set 1/n Server Scale     Ultravnc ext. Scale desktop by 1/n.
          Text Chat                Ultravnc ext. Do Text Chat.
          File Transfer            Ultravnc ext. File xfer via Java helper.
          Single Window            Ultravnc ext. Grab and view a single window.
                                   (select then click on the window you want).
          Disable Remote Input     Ultravnc ext. Try to prevent input and
                                   viewing of monitor at physical display.

        Note: the Ultravnc extensions only apply to servers that support
              them.  x11vnc/libvncserver supports some of them.

        Send Clipboard not Primary  ~ -sendclipboard
        Send Selection Every time   ~ -sendalways

   Nearly all of these can be changed dynamically in the Popup menu
   (press F8 for it):

   [viewer_menu.gif] [unixviewer.jpg]

     _________________________________________________________________

   Windows:

   For Windows, SSL Viewer support is provided by a GUI Windows/ssvnc.exe
   that prompts for the VNC display and then starts up STUNNEL followed
   by the Stock TightVNC Windows Viewer. Both are bundled in the package
   for your convenience. The GUI has other useful features. When the
   connection is finished, you will be asked if you want to terminate the
   STUNNEL program. For SSH connections from Windows the GUI will use
   PLINK instead of STUNNEL.

   Unix and Mac OS X:

   Run the GUI (ssvnc, see above) and let me know how it goes.
     _________________________________________________________________

   Hopefully this tool will make it convenient for people to help test
   and use the built-in SSL support in x11vnc. Extra testing of this
   feature is much appreciated!! Thanks.

   Please Help Test the newly added features:
     * Automatic Service tunnelling via SSH for CUPS and SMB Printing
     * ESD/ARTSD Audio
     * SMB (Windows/Samba) filesystem mounting

   These allow you to print from the remote (VNC Server) machine to local
   printers, listen to sounds (with some limitations) from the remote VNC
   Server machine, and to mount your local Windows or Samba shares on the
   remote VNC Server machine. Basically these new features try to
   automate the tricks described here:
    http://www.karlrunge.com/x11vnc/faq.html#faq-smb-shares
    http://www.karlrunge.com/x11vnc/faq.html#faq-cups
    http://www.karlrunge.com/x11vnc/faq.html#faq-sound
     _________________________________________________________________

   Downloading: Downloads for this project are hosted at Sourceforge.net.

   Choose the archive file bundle that best suits you (e.g. no source
   code, windows only, unix only, zip, tar etc).

   A quick guide:

      On some flavor of Unix, e.g. Linux or Solaris? Use
   "ssvnc_unix_only" (or "ssvnc_no_windows" to recompile).
      On Mac OS X? Use "ssvnc_no_windows".
      On Windows? Use "ssvnc_windows_only".
  ssvnc_windows_only-1.0.28.zip      Windows Binaries Only.  No source included
 (6.2MB)
  ssvnc_no_windows-1.0.28.tar.gz     Unix and Mac OS X Only. No Windows binarie
s.  Source included. (10.1MB)
  ssvnc_unix_only-1.0.28.tar.gz      Unix Binaries Only.     No source included
. (7.2MB)
  ssvnc_unix_minimal-1.0.28.tar.gz   Unix Minimal.  You must supply your own vn
cviewer and stunnel. (0.2MB)

  ssvnc-1.0.28.tar.gz                All Unix, Mac OS X, and Windows binaries a
nd source TGZ. (16.1MB)
  ssvnc-1.0.28.zip                   All Unix, Mac OS X, and Windows binaries a
nd source ZIP. (16.4MB)
  ssvnc_all-1.0.28.zip               All Unix, Mac OS X, and Windows binaries a
nd source AND full archives in the zip dir. (19.2MB)


   Here is a conventional source tarball:
  ssvnc-1.0.28.src.tar.gz            Conventional Source for SSVNC GUI and Unix
 VNCviewer  (0.5MB)

   it will be of use to those who do not want the SSVNC
   "one-size-fits-all" bundles. For example, package/distro maintainers
   will find this more familiar and useful to them (i.e. they run: "make
   config; make all; make install"). Note that it does not include the
   stunnel source, and so has a dependency that the system stunnel is
   installed.

   Read the README.src file for more information on using the
   conventional source tarball.


   Note: even with the Unix bundles, e.g. "ssvnc_no_windows" or
   "ssvnc_all", you may need to run the "./build.unix" script in the top
   directory to recompile for your operating system.

   Here are the corresponding 1.0.29 development bundles (Please help
   test them):

  ssvnc_windows_only-1.0.29.zip
  ssvnc_no_windows-1.0.29.tar.gz
  ssvnc_unix_only-1.0.29.tar.gz
  ssvnc_unix_minimal-1.0.29.tar.gz

  ssvnc-1.0.29.tar.gz
  ssvnc-1.0.29.zip
  ssvnc_all-1.0.29.zip

  ssvnc-1.0.29.src.tar.gz            Conventional Source for SSVNC GUI and Unix
 VNCviewer  (0.5MB)


   For any Unix system, a self-extracting and running file for the
   "ssvnc_unix_minimal" package is here: ssvnc. Save it as filename
   "ssvnc", type "chmod 755 ./ssvnc", and then launch the GUI via typing
   "./ssvnc". Note that this "ssvnc_unix_minimal" mode requires you
   install the "stunnel" and "vncviewer" programs externally (for
   example, install your distros' versions, e.g. on debian: "apt-get
   install stunnel4 xtightvncviewer".) It will work, but many of the
   SSVNC features will be missing.

   Previous releases:
      Release 1.0.18 at Sourceforge.net
      Release 1.0.19 at Sourceforge.net
      Release 1.0.20 at Sourceforge.net
      Release 1.0.21 at Sourceforge.net
      Release 1.0.22 at Sourceforge.net
      Release 1.0.23 at Sourceforge.net
      Release 1.0.24 at Sourceforge.net
      Release 1.0.25 at Sourceforge.net
      Release 1.0.26 at Sourceforge.net
      Release 1.0.27 at Sourceforge.net
      Release 1.0.28 at Sourceforge.net


   Please help test the UltraVNC File Transfer support in the native Unix
   VNC viewer! Let us know how it went.

   Current Unix binaries in the archives:
    Linux.i686
    Linux.x86_64
    Linux.ppc64    X (removed)
    Linux.alpha    X (removed)
    SunOS.sun4u
    SunOS.sun4m
    SunOS.i86pc
    Darwin.Power.Macintosh
    Darwin.i386
    HP-UX.9000     X (removed)
    FreeBSD.i386   X (removed)
    NetBSD.i386    X (removed)
    OpenBSD.i386   X (removed)

   (some of these are out of date, marked with 'X' above, because I no
   longer have access to machines running those OS's. Use the
   "build.unix" script to recompile on your system).

   Note: some of the above binaries depend on libssl.so.0.9.7, whereas
   some recent distros only provide libssl.so.0.9.8 by default (for
   compatibility reasons they should install both by default but not all
   do). So you may need to instruct your distro to install the 0.9.7
   library (it is fine to have both runtimes installed simultaneously
   since the libraries have different names). Update: I now try to
   statically link libssl.a for all of the binaries in the archive.

   You can also run the included build.unix script to try to
   automatically build the binaries if your OS is not in the above list
   or the included binary does not run properly on your system. Let me
   know how that goes.
     _________________________________________________________________

   IMPORTANT: there may be restrictions for you to download, use, or
   redistribute the above because of cryptographic software they contain
   or for other reasons. Please check out your situation and information
   at the following and related sites:
        http://stunnel.mirt.net
        http://www.stunnel.org
        http://www.openssl.org
        http://www.chiark.greenend.org.uk/~sgtatham/putty/
        http://www.tightvnc.com
        http://www.realvnc.com
        http://sourceforge.net/projects/cotvnc/
     _________________________________________________________________

   README: Here is the toplevel README from the bundle.
	
=======================================================================
http://www.karlrunge.com/x11vnc/x11vnc_opts.html:


     _________________________________________________________________

x11vnc: a VNC server for real X displays

   Here are all of x11vnc command line options:
% x11vnc -opts      (see below for -help long descriptions)

x11vnc: allow VNC connections to real X11 displays. 0.9.13 lastmod: 2010-12-27

x11vnc options:
  -display disp            -auth file               -N                     
  -autoport n              -rfbport str             -6                     
  -no6                     -noipv6                  -noipv4                
  -reopen                  -reflect host:N          -id windowid           
  -sid windowid            -appshare                -clip WxH+X+Y          
  -flashcmap               -shiftcmap n             -notruecolor           
  -advertise_truecolor     -visual n                -overlay               
  -overlay_nocursor        -8to24 [opts]            -24to32                
  -scale fraction          -geometry WxH            -scale_cursor frac     
  -viewonly                -shared                  -once                  
  -forever                 -loop                    -timeout n             
  -sleepin n               -inetd                   -tightfilexfer         
  -ultrafilexfer           -http                    -http_ssl              
  -avahi                   -mdns                    -zeroconf              
  -connect string          -connect_or_exit str     -proxy string          
  -vncconnect              -novncconnect            -allow host1[,host2..] 
  -localhost               -unixsock str            -listen6 str           
  -nolookup                -input string            -grabkbd               
  -grabptr                 -ungrabboth              -grabalways            
  -viewpasswd string       -passwdfile filename     -showrfbauth filename  
  -unixpw [list]           -unixpw_nis [list]       -unixpw_cmd cmd        
  -find                    -finddpy                 -listdpy               
  -findauth [disp]         -create                  -xdummy                
  -xvnc                    -xvnc_redirect           -xdummy_xvfb           
  -create_xsrv str         -svc                     -svc_xdummy            
  -svc_xvnc                -svc_xdummy_xvfb         -xdmsvc                
  -sshxdmsvc               -unixpw_system_greeter   -redirect port         
  -display WAIT:...        -vencrypt mode           -anontls mode          
  -sslonly                 -dhparams file           -nossl                 
  -ssl [pem]               -ssltimeout n            -sslnofail             
  -ssldir dir              -sslverify path          -sslCRL path           
  -sslGenCA [dir]          -sslGenCert type name    -sslEncKey pem         
  -sslCertInfo pem         -sslDelCert pem          -sslScripts            
  -stunnel [pem]           -stunnel3  [pem]         -enc cipher:keyfile    
  -https [port]            -httpsredir [port]       -http_oneport          
  -ssh user@host:disp      -usepw                   -storepasswd pass file 
  -nopw                    -accept string           -afteraccept string    
  -gone string             -users list              -noshm                 
  -flipbyteorder           -onetile                 -solid [color]         
  -blackout string         -xinerama                -noxinerama            
  -xtrap                   -xrandr [mode]           -rotate string         
  -padgeom WxH             -o logfile               -flag file             
  -rmflag file             -rc filename             -norc                  
  -env VAR=VALUE           -prog /path/to/x11vnc    -h, -help              
  -?, -opts                -V, -version             -license               
  -dbg                     -q, -quiet               -v, -verbose           
  -bg                      -modtweak                -nomodtweak            
  -xkb                     -noxkb                   -capslock              
  -skip_lockkeys           -noskip_lockkeys         -skip_keycodes string  
  -sloppy_keys             -skip_dups               -noskip_dups           
  -add_keysyms             -noadd_keysyms           -clear_mods            
  -clear_keys              -clear_all               -remap string          
  -norepeat                -repeat                  -nofb                  
  -nobell                  -nosel                   -noprimary             
  -nosetprimary            -noclipboard             -nosetclipboard        
  -seldir string           -cursor [mode]           -nocursor              
  -cursor_drag             -arrow n                 -noxfixes              
  -alphacut n              -alphafrac fraction      -alpharemove           
  -noalphablend            -nocursorshape           -cursorpos             
  -nocursorpos             -xwarppointer            -noxwarppointer        
  -always_inject           -buttonmap string        -nodragging            
  -ncache n                -ncache_cr               -ncache_no_moveraise   
  -ncache_no_dtchange      -ncache_no_rootpixmap    -ncache_keep_anims     
  -ncache_old_wm           -ncache_pad n            -debug_ncache          
  -wireframe [str]         -nowireframe             -nowireframelocal      
  -wirecopyrect mode       -nowirecopyrect          -debug_wireframe       
  -scrollcopyrect mode     -noscrollcopyrect        -scr_area n            
  -scr_skip list           -scr_inc list            -scr_keys list         
  -scr_term list           -scr_keyrepeat lo-hi     -scr_parms string      
  -fixscreen string        -debug_scroll            -noxrecord             
  -grab_buster             -nograb_buster           -debug_grabs           
  -debug_sel               -pointer_mode n          -input_skip n          
  -allinput                -input_eagerly           -speeds rd,bw,lat      
  -wmdt string             -debug_pointer           -debug_keyboard        
  -defer time              -wait time               -extra_fbur n          
  -wait_ui factor          -setdefer n              -nowait_bog            
  -slow_fb time            -xrefresh time           -nap                   
  -nonap                   -sb time                 -readtimeout n         
  -ping n                  -nofbpm                  -fbpm                  
  -nodpms                  -dpms                    -forcedpms             
  -clientdpms              -noserverdpms            -noultraext            
  -chatwindow              -noxdamage               -xd_area A             
  -xd_mem f                -sigpipe string          -threads               
  -nothreads               -fs f                    -gaps n                
  -grow n                  -fuzz n                  -debug_tiles           
  -snapfb                  -rawfb string            -freqtab file          
  -pipeinput cmd           -macnodim                -macnosleep            
  -macnosaver              -macnowait               -macwheel n            
  -macnoswap               -macnoresize             -maciconanim n         
  -macmenu                 -macuskbd                -macnoopengl           
  -macnorawfb              -gui [gui-opts]          -remote command        
  -query variable          -QD variable             -sync                  
  -query_retries str       -remote_prefix str       -noremote              
  -yesremote               -unsafe                  -safer                 
  -privremote              -nocmds                  -allowedcmds list      
  -deny_all              

LibVNCServer options:
-rfbport port          TCP port for RFB protocol
-rfbwait time          max time in ms to wait for RFB client
-rfbauth passwd-file   use authentication on RFB protocol
                       (use 'storepasswd' to create a password file)
-rfbversion 3.x        Set the version of the RFB we choose to advertise
-permitfiletransfer    permit file transfer support
-passwd plain-password use authentication 
                       (use plain-password as password, USE AT YOUR RISK)
-deferupdate time      time in ms to defer updates (default 40)
-deferptrupdate time   time in ms to defer pointer updates (default none)
-desktop name          VNC desktop name (default "LibVNCServer")
-alwaysshared          always treat new clients as shared
-nevershared           never treat new clients as shared
-dontdisconnect        don't disconnect existing clients when a new non-shared
                       connection comes in (refuse new connection instead)
-httpdir dir-path      enable http server using dir-path home
-httpport portnum      use portnum for http connection
-enablehttpproxy       enable http proxy support
-progressive height    enable progressive updating for slow links
-listen ipaddr         listen for connections only on network interface with
                       addr ipaddr. '-listen localhost' and hostname work too.

libvncserver-tight-extension options:
-disablefiletransfer   disable file transfer
-ftproot string        set ftp root




% x11vnc -help

x11vnc: allow VNC connections to real X11 displays. 0.9.13 lastmod: 2010-12-27

(type "x11vnc -opts" to just list the options.)

Typical usage is:

   Run this command in a shell on the remote machine "far-host"
   with X session you wish to view:

       x11vnc -display :0

   Then run this in another window on the machine you are sitting at:

       vncviewer far-host:0

Once x11vnc establishes connections with the X11 server and starts listening
as a VNC server it will print out a string: PORT=XXXX where XXXX is typically
5900 (the default VNC server port).  One would next run something like
this on the local machine: "vncviewer hostname:N" where "hostname" is
the name of the machine running x11vnc and N is XXXX - 5900, i.e. usually
"vncviewer hostname:0".

By default x11vnc will not allow the screen to be shared and it will exit
as soon as the client disconnects.  See -shared and -forever below to override
these protections.  See the FAQ for details how to tunnel the VNC connection
through an encrypted channel such as ssh(1).  In brief:

       ssh -t -L 5900:localhost:5900 far-host 'x11vnc -localhost -display :0'

       vncviewer -encodings 'copyrect tight zrle hextile' localhost:0

Also, use of a VNC password (-rfbauth or -passwdfile) is strongly recommended.

For additional info see: http://www.karlrunge.com/x11vnc/
                    and  http://www.karlrunge.com/x11vnc/faq.html


Config file support: if the file $HOME/.x11vncrc exists then each line in
it is treated as a single command line option.  Disable with -norc.  For
each option name, the leading character "-" is not required.  E.g. a line
that is either "forever" or "-forever" may be used and are equivalent.
Likewise "wait 100" or "-wait 100" are acceptable and equivalent lines.
The "#" character comments out to the end of the line in the usual way
(backslash it for a literal).  Leading and trailing whitespace is trimmed off.
Lines may be continued with a "\" as the last character of a line (it
becomes a space character).

Options:

-display disp          X11 server display to connect to, usually :0.  The X
                       server process must be running on same machine and
                       support MIT-SHM.  Equivalent to setting the DISPLAY
                       environment variable to "disp".

                       See the description below of the "-display WAIT:..."
                       extensions, where alias "-find" will find the user's
                       display automatically, and "-create" will create a
                       Xvfb session if no session is found.

-auth file             Set the X authority file to be "file", equivalent to
                       setting the XAUTHORITY environment variable to "file"
                       before startup.  Same as -xauth file.  See Xsecurity(7),
                       xauth(1) man pages for more info.

                       Use '-auth guess' to have x11vnc use its -findauth
                       mechanism (described below) to try to guess the
                       XAUTHORITY filename and use it.

                       XDM/GDM/KDM: if you are running x11vnc as root and want
                       to find the XAUTHORITY before anyone has logged into an
                       X session yet, use: x11vnc -env FD_XDM=1 -auth guess ...
                       (This will also find the XAUTHORITY if a user is already
                       logged into the X session.)  When running as root,
                       FD_XDM=1 will be tried if the initial -auth guess fails.

-N                     If the X display is :N, try to set the VNC display to
                       also be :N This just sets the -rfbport option to 5900+N
                       The program will exit immediately if that port is not
                       available. The -N option only works with normal -display
                       usage, e.g. :0 or :8, -N is ignored in the -display
                       WAIT:..., -create, -find, -svc, -redirect, etc modes.

-autoport n            Automatically probe for a free VNC port starting at n.
                       The default is to start probing at 5900.  Use this to
                       stay away from other VNC servers near 5900.

-rfbport str           The VNC port to listen on (a LibVNCServer option), e.g.
                       5900, 5901, etc.  If specified as "-rfbport PROMPT"
                       then the x11vnc -gui is used to prompt the user to
                       enter the port number.

-6                     IPv6 listening support.  In addition to IPv4, the
                       IPv6 address is listened on for incoming connections.
                       The same port number as IPv4 is used.

                       NOTE:  This x11vnc binary was compiled to have the
                       "-6" IPv6 listening mode ENABLED by default (CPPFLAGS
                       -DX11VNC_LISTEN6=1).  So to disable IPv6 listening mode
                       you MUST supply the "-no6" option (see below.)

                       The "-6" mode works for both normal connections and
                       -ssl encrypted ones.  Nearly everything is supported
                       for the IPv6 case, but there are a few exceptions.
                       See -stunnel for its IPv6 support.

                       Currently, for absolutely everything to work correctly
                       the machine may need to have some IPv4 support, at the
                       least for the loopback interface.  However, for nearly
                       all usage modes no IPv4 support is required. See -noipv4
.

                       If you have trouble compiling or running in IPv6 mode,
                       set -DX11VNC_IPV6=0 in CPPFLAGS when configuring to
                       disable IPv6 support.

-no6                   Disable IPv6 listening support (only useful if the
                       "-6" mode is compiled in to be the default; see the
                       X11VNC_LISTEN6 description above under "-6".)

-noipv6                Do not try to use IPv6 for any listening or connecting
                       sockets.  This includes both the listening service
                       port(s) and outgoing connections from -connect,
                       -connect_or_exit, or -proxy.  Use this if you are having
                       problems due to IPv6.

-noipv4                Do not try to use IPv4 for any listening or connecting
                       sockets.  This is mainly for exploring the behavior of
                       x11vnc on an IPv6-only system, but may have other uses.

-reopen                If the X server connection is disconnected, try to
                       reopen the X display (up to one time.)  This is of use
                       for display managers like GDM (KillInitClients option)
                       that kill x11vnc just after the user logs into the
                       X session.  Note: the reopened state may be unstable.
                       Set X11VNC_REOPEN_DISPLAY=n to reopen n times and
                       set X11VNC_REOPEN_SLEEP_MAX to the number of seconds,
                       default 10, to keep trying to reopen the display (once
                       per second.)

                       Update: as of 0.9.9, x11vnc tries to automatically avoid
                       being killed by the display manager by delaying creating
                       windows or using XFIXES.  So you shouldn't need to use
                       KillInitClients=false as long as you log in quickly
                       enough (within 45 seconds of connecting.)  You can
                       disable this by setting X11VNC_AVOID_WINDOWS=never.
                       You can also set it to the number of seconds to delay.

-reflect host:N        Instead of connecting to and polling an X display,
                       connect to the remote VNC server host:N and be a
                       reflector/repeater for it.  This is useful for trying
                       to manage the case of many simultaneous VNC viewers
                       (e.g. classroom broadcasting) where, e.g. you put
                       a repeater on each network switch, etc, to improve
                       performance by distributing the load and network
                       traffic.  Implies -shared (use -noshared as a later
                       option to disable). See the discussion below under
                       -rawfb vnc:host:N for more details.

-id windowid           Show the X window corresponding to "windowid" not
                       the entire display.  New windows like popup menus,
                       transient toplevels, etc, may not be seen or may be
                       clipped.  Disabling SaveUnders or BackingStore in the
                       X server may help show them.  x11vnc may crash if the
                       window is initially partially obscured, changes size,
                       is iconified, etc.  Some steps are taken to avoid this
                       and the -xrandr mechanism is used to track resizes.  Use
                       xwininfo(1) to get the window id, or use "-id pick"
                       to have x11vnc run xwininfo(1) for you and extract
                       the id.  The -id option is useful for exporting very
                       simple applications (e.g. the current view on a webcam).
-sid windowid          As -id, but instead of using the window directly it
                       shifts a root view to it: this shows SaveUnders menus,
                       etc, although they will be clipped if they extend beyond
                       the window.

-appshare              Simple application sharing based on the -id/-sid
                       mechanism.  Every new toplevel window that the
                       application creates induces a new viewer window via
                       a reverse connection.  The -id/-sid and -connect
                       options are required.  Run 'x11vnc -appshare -help'
                       for more info.

-clip WxH+X+Y          Only show the sub-region of the full display that
                       corresponds to the rectangle geometry with size WxH and
                       offset +X+Y.  The VNC display has size WxH (i.e. smaller
                       than the full display).  This also works for -id/-sid
                       mode where the offset is relative to the upper left
                       corner of the selected window.  An example use of this
                       option would be to split a large (e.g. Xinerama) display
                       into two parts to be accessed via separate viewers by
                       running a separate x11vnc on each part.

                       Use '-clip xinerama0' to clip to the first xinerama
                       sub-screen (if xinerama is active).  xinerama1 for the
                       2nd sub-screen, etc.  This way you don't need to figure
                       out the WxH+X+Y of the desired xinerama sub-screen.
                       screens are sorted in increasing distance from the
                       (0,0) origin (I.e. not the Xserver's order).

-flashcmap             In 8bpp indexed color, let the installed colormap flash
                       as the pointer moves from window to window (slow).
                       Also try the -8to24 option to avoid flash altogether.
-shiftcmap n           Rare problem, but some 8bpp displays use less than 256
                       colorcells (e.g. 16-color grayscale, perhaps the other
                       bits are used for double buffering) *and* also need to
                       shift the pixels values away from 0, .., ncells.  "n"
                       indicates the shift to be applied to the pixel values.
                       To see the pixel values set DEBUG_CMAP=1 to print out
                       a colormap histogram.  Example: -shiftcmap 240
-notruecolor           For 8bpp displays, force indexed color (i.e. a colormap)
                       even if it looks like 8bpp TrueColor (rare problem).
-advertise_truecolor   If the X11 display is indexed color, lie to clients
                       when they first connect by telling them it is truecolor.
                       To workaround RealVNC: inPF has colourMap but not 8bpp
                       Use '-advertise_truecolor reset' to reset client fb too.

-visual n              This option probably does not do what you think.
                       It simply *forces* the visual used for the framebuffer;
                       this may be a bad thing... (e.g. messes up colors or
                       cause a crash). It is useful for testing and for some
                       workarounds.  n may be a decimal number, or 0x hex.
                       Run xdpyinfo(1) for the values.  One may also use
                       "TrueColor", etc. see <X11/X.h> for a list.  If the
                       string ends in ":m" then for better or for worse
                       the visual depth is forced to be m.  You may want to
                       use -noshm when using this option (so XGetImage may
                       automatically translate the pixel data).

-overlay               Handle multiple depth visuals on one screen, e.g. 8+24
                       and 24+8 overlay visuals (the 32 bits per pixel are
                       packed with 8 for PseudoColor and 24 for TrueColor).

                       Currently -overlay only works on Solaris via
                       XReadScreen(3X11) and IRIX using XReadDisplay(3).
                       On Solaris there is a problem with image "bleeding"
                       around transient popup menus (but not for the menu
                       itself): a workaround is to disable SaveUnders
                       by passing the "-su" argument to Xsun (in
                       /etc/dt/config/Xservers).

                       Use -overlay as a workaround for situations like these:
                       Some legacy applications require the default visual to
                       be 8bpp (8+24), or they will use 8bpp PseudoColor even
                       when the default visual is depth 24 TrueColor (24+8).
                       In these cases colors in some windows will be incorrect
                       in x11vnc unless -overlay is used.  Another use of
                       -overlay is to enable showing the exact mouse cursor
                       shape (details below).

                       Under -overlay, performance will be somewhat slower
                       due to the extra image transformations required.
                       For optimal performance do not use -overlay, but rather
                       configure the X server so that the default visual is
                       depth 24 TrueColor and try to have all apps use that
                       visual (e.g. some apps have -use24 or -visual options).
-overlay_nocursor      Sets -overlay, but does not try to draw the exact mouse
                       cursor shape using the overlay mechanism.

-8to24 [opts]          Try this option if -overlay is not supported on your
                       OS, and you have a legacy 8bpp app that you want to
                       view on a multi-depth display with default depth 24
                       (and is 32 bpp) OR have a default depth 8 display with
                       depth 24 overlay windows for some apps.  This option
                       may not work on all X servers and hardware (tested
                       on XFree86/Xorg mga driver and Xsun).  The "opts"
                       string is not required and is described below.

                       This mode enables a hack where x11vnc monitors windows
                       within 3 levels from the root window.  If it finds
                       any that are 8bpp it extracts the indexed color
                       pixel values using XGetImage() and then applies a
                       transformation using the colormap(s) to create TrueColor
                       RGB values that it in turn inserts into bits 1-24 of
                       the framebuffer.  This creates a depth 24 "view"
                       of the display that is then exported via VNC.

                       Conversely, for default depth 8 displays, the depth
                       24 regions are read by XGetImage() and everything is
                       transformed and inserted into a depth 24 TrueColor
                       framebuffer.

                       Note that even if there are *no* depth 24 visuals or
                       windows (i.e. pure 8bpp), this mode is potentially
                       an improvement over -flashcmap because it avoids the
                       flashing and shows each window in the correct color.

                       This method works OK, but may still have bugs and it
                       does hog resources.  If there are multiple 8bpp windows
                       using different colormaps, one may have to iconify all
                       but one for the colors to be correct.

                       There may be painting errors for clipping and switching
                       between windows of depths 8 and 24.  Heuristics are
                       applied to try to minimize the painting errors.  One can
                       also press 3 Alt_L's in a row to refresh the screen
                       if the error does not repair itself.  Also the option
                       -fixscreen 8=3.0 or -fixscreen V=3.0 may be used to
                       periodically refresh the screen at the cost of bandwidth
                       (every 3 sec for this example).

                       The [opts] string can contain the following settings.
                       Multiple settings are separated by commas.

                       For for some X servers with default depth 24 a
                       speedup may be achieved via the option "nogetimage".
                       This enables a scheme were XGetImage() is not used
                       to retrieve the 8bpp data.  Instead, it assumes that
                       the 8bpp data is in bits 25-32 of the 32bit X pixels.
                       There is no requirement that the X server should put
                       the data there for our poll requests, but some do and
                       so the extra steps to retrieve it can be skipped.
                       Tested with mga driver with XFree86/Xorg.  For the
                       default depth 8 case this option is ignored.

                       To adjust how often XGetImage() is used to poll the
                       non-default visual regions for changes, use the option
                       "poll=t" where "t" is a floating point time.
                       (default: 0.05)

                       Setting the option "level2" will limit the search
                       for non-default visual windows to two levels from the
                       root window.  Do this on slow machines where you know
                       the window manager only imposes one extra window between
                       the app window and the root window.

                       Also for very slow machines use "cachewin=t"
                       where t is a floating point amount of time to cache
                       XGetWindowAttributes results.  E.g. cachewin=5.0.
                       This may lead to the windows being unnoticed for this
                       amount of time when deiconifying, painting errors, etc.

                       While testing on a very old SS20 these options gave
                       tolerable response: -8to24 poll=0.2,cachewin=5.0. For
                       this machine -overlay is supported and gives better
                       response.

                       Debugging for this mode can be enabled by setting
                       "dbg=1", "dbg=2", or "dbg=3".

-24to32                Very rare problem: if the framebuffer (X display
                       or -rawfb) is 24bpp instead of the usual 32bpp, then
                       dynamically transform the pixels to 32bpp.  This will be
                       slower, but can be used to work around problems where
                       VNC viewers cannot handle 24bpp (e.g. "main: setPF:
                       not 8, 16 or 32 bpp?").  See the FAQ for more info.

                       In the case of -rawfb mode, the pixels are directly
                       modified by inserting a 0 byte to pad them out to 32bpp.
                       For X displays, a kludge is done that is equivalent to
                       "-noshm -visual TrueColor:32".  (If better performance
                       is needed for the latter, feel free to ask).

-scale fraction        Scale the framebuffer by factor "fraction".  Values
                       less than 1 shrink the fb, larger ones expand it. Note:
                       the image may not be sharp and response may be slower.
                       If "fraction" contains a decimal point "." it
                       is taken as a floating point number, alternatively
                       the notation "m/n" may be used to denote fractions
                       exactly, e.g. -scale 2/3

                       To scale asymmetrically in the horizontal and vertical
                       directions, specify a WxH geometry to stretch to:
                       e.g. '-scale 1024x768', or also '-scale 0.9x0.75'

                       Scaling Options: can be added after "fraction" via
                       ":", to supply multiple ":" options use commas.
                       If you just want a quick, rough scaling without
                       blending, append ":nb" to "fraction" (e.g. -scale
                       1/3:nb).  No blending is the default for 8bpp indexed
                       color, to force blending for this case use ":fb".

                       To disable -scrollcopyrect and -wirecopyrect under
                       -scale use ":nocr".  If you need to to enable them use
                       ":cr" or specify them explicitly on the command line.
                       If a slow link is detected, ":nocr" may be applied
                       automatically.  Default: :cr

                       More esoteric options: for compatibility with vncviewers
                       the scaled width is adjusted to be a multiple of 4:
                       to disable this use ":n4".  ":in" use interpolation
                       scheme even when shrinking, ":pad" pad scaled width
                       and height to be multiples of scaling denominator
                       (e.g. 3 for 2/3).

-geometry WxH          Same as -scale WxH

-scale_cursor frac     By default if -scale is supplied the cursor shape is
                       scaled by the same factor.  Depending on your usage,
                       you may want to scale the cursor independently of the
                       screen or not at all.  If you specify -scale_cursor
                       the cursor will be scaled by that factor.  When using
                       -scale mode to keep the cursor at its "natural" size
                       use "-scale_cursor 1".  Most of the ":" scaling
                       options apply here as well.

-viewonly              All VNC clients can only watch (default off).
-shared                VNC display is shared, i.e. more than one viewer can
                       connect at the same time (default off).
-once                  Exit after the first successfully connected viewer
                       disconnects, opposite of -forever. This is the Default.
-forever               Keep listening for more connections rather than exiting
                       as soon as the first client(s) disconnect. Same as -many

                       To get the standard non-shared VNC behavior where when
                       a new VNC client connects the existing VNC client is
                       dropped use:  -nevershared -forever   This method can
                       also be used to guard against hung TCP connections that
                       do not go away.

-loop                  Create an outer loop restarting the x11vnc process
                       whenever it terminates.  -bg and -inetd are ignored
                       in this mode (however see -loopbg below).

                       Useful for continuing even if the X server terminates
                       and restarts (at that moment the process will need
                       permission to reconnect to the new X server of course).

                       Use, e.g., -loop100 to sleep 100 millisecs between
                       restarts, etc.  Default is 2000ms (i.e. 2 secs) Use,
                       e.g. -loop300,5 to sleep 300 ms and only loop 5 times.

                       If -loopbg (plus any numbers) is specified instead,
                       the "-bg" option is implied and the mode approximates
                       inetd(8) usage to some degree.  In this case when
                       it goes into the background any listening sockets
                       (i.e. ports 5900, 5800) are closed, so the next one
                       in the loop can use them.  This mode will only be of
                       use if a VNC client (the only client for that process)
                       is already connected before the process goes into the
                       background, for example, usage of -display WAIT:..,
                       -svc, and -connect can make use of this "poor man's"
                       inetd mode.  The default wait time is 500ms in this
                       mode.  This usage could use useful:  -svc -bg -loopbg

-timeout n             Exit unless a client connects within the first n seconds
                       after startup.

                       If there have been no connection attempts after n
                       seconds x11vnc exits immediately.  If a client is
                       trying to connect but has not progressed to the normal
                       operating state, x11vnc gives it a few more seconds
                       to finish and exits if it does not make it to the
                       normal state.

                       For reverse connections via -connect or -connect_or_exit
                       a timeout of n seconds will be set for all reverse
                       connects.  If the connect timeout alarm goes off,
                       x11vnc will exit immediately.

-sleepin n             At startup sleep n seconds before proceeding (e.g. to
                       allow redirs and listening clients to start up)

                       If a range is given: '-sleepin min-max', a random value
                       between min and max is slept. E.g. '-sleepin 0-20' and
                       '-sleepin 10-30'.  Floats are allowed too.

-inetd                 Launched by inetd(8): stdio instead of listening socket.
                       Note: if you are not redirecting stderr to a log file
                       (via shell 2> or -o option) you MUST also specify the -q
                       option, otherwise the stderr goes to the viewer which
                       will cause it to abort.  Specifying both -inetd and -q
                       and no -o will automatically close the stderr.

-tightfilexfer         Enable the TightVNC file transfer extension. Note that
                       that when the -viewonly option is supplied all file
                       transfers are disabled.  Also clients that log in
                       viewonly cannot transfer files.  However, if the remote
                       control mechanism is used to change the global or
                       per-client viewonly state the filetransfer permissions
                       will NOT change.

                       IMPORTANT: please understand if -tightfilexfer is
                       specified and you run x11vnc as root for, say, inetd
                       or display manager (gdm, kdm, ...) access and you do
                       not have it switch users via the -users option, then
                       VNC Viewers that connect are able to do filetransfer
                       reads and writes as *root*.

                       Also, tightfilexfer is disabled in -unixpw mode.

-ultrafilexfer         Note: to enable UltraVNC filetransfer and to get it to
                       work you probably need to supply these LibVNCServer
                       options: "-rfbversion 3.6 -permitfiletransfer"
                       "-ultrafilexfer" is an alias for this combination.

                       IMPORTANT: please understand if -ultrafilexfer is
                       specified and you run x11vnc as root for, say, inetd
                       or display manager (gdm, kdm, ...) access and you do
                       not have it switch users via the -users option, then
                       VNC Viewers that connect are able to do filetransfer
                       reads and writes as *root*.

                       Note that sadly you cannot do both -tightfilexfer and
                       -ultrafilexfer at the same time because the latter
                       requires setting the version to 3.6 and tightvnc will
                       not do filetransfer when it sees that version number.

-http                  Instead of using -httpdir (see below) to specify
                       where the Java vncviewer applet is, have x11vnc try
                       to *guess* where the directory is by looking relative
                       to the program location and in standard locations
                       (/usr/local/share/x11vnc/classes, etc).  Under -ssl or
                       -stunnel the ssl classes subdirectory is sought.
-http_ssl              As -http, but force lookup for ssl classes subdir.

                       Note that for HTTPS, single-port Java applet delivery
                       you can set X11VNC_HTTPS_DOWNLOAD_WAIT_TIME to the
                       max number of seconds to wait for the applet download
                       to finish.  The default is 15.

-avahi                 Use the Avahi/mDNS ZeroConf protocol to advertise
                       this VNC server to the local network. (Related terms:
                       Rendezvous, Bonjour).  Depending on your setup, you
                       may need to start avahi-daemon and open udp port 5353
                       in your firewall.

                       You can set X11VNC_AVAHI_NAME, X11VNC_AVAHI_HOST,
                       and/or X11VNC_AVAHI_PORT environment variables
                       to override the default values.  For example:
                       -env X11VNC_AVAHI_NAME=wally

                       If the avahi API cannot be found at build time, a helper
                       program like avahi-publish(1) or dns-sd(1) will be tried

-mdns                  Same as -avahi.
-zeroconf              Same as -avahi.

-connect string        For use with "vncviewer -listen" reverse connections.
                       If "string" has the form "host" or "host:port"
                       the connection is made once at startup.

                       Use commas for a list of host's and host:port's.
                       E.g. -connect host1,host2 or host1:0,host2:5678.
                       Note that to reverse connect to multiple hosts at the
                       same time you will likely need to also supply: -shared

                       Note that unlike most vnc servers, x11vnc will require a
                       password for reverse as well as for forward connections.
                       (provided password auth has been enabled, -rfbauth, etc)
                       If you do not want to require a password for reverse
                       connections set X11VNC_REVERSE_CONNECTION_NO_AUTH=1 in
                       your environment before starting x11vnc.

                       If "string" contains "/" it is instead interpreted
                       as a file to periodically check for new hosts.
                       The first line is read and then the file is truncated.
                       Be careful about the location of this file if x11vnc
                       is running as root (e.g. via gdm(1), etc).


                       Repeater mode: Some services provide an intermediate
                       "vnc repeater": http://www.uvnc.com/addons/repeater.html
                       (and also http://koti.mbnet.fi/jtko/ for linux port)
                       that acts as a proxy/gateway.  Modes like these require
                       an initial string to be sent for the reverse connection
                       before the VNC protocol is started.  Here are the ways
                       to do this:

                         -connect pre=some_string+host:port
                         -connect pre128=some_string+host:port
                         -connect repeater=ID:1234+host:port
                         -connect repeater=23.45.67.89::5501+host:port

                       SSVNC notation is also supported:

                         -connect repeater://host:port+ID:1234

                       As with normal -connect usage, if the repeater port is
                       not supplied 5500 is assumed.

                       The basic idea is between the special tag, e.g. "pre="
                       and "+" is the pre-string to be sent.  Note that in
                       this case host:port is the repeater server, NOT the
                       vnc viewer.  Somehow the pre-string tells the repeater
                       server how to find the vnc viewer and connect you to it.

                       In the case pre=some_string+host:port, "some_string"
                       is simply sent. In the case preNNN=some_string+host:port
                       "some_string" is sent in a null padded buffer of
                       length NNN.  repeater= is the same as pre250=, this is
                       the ultravnc repeater buffer size.

                       Strings like "\n" and "\r", etc. are expanded to
                       newline and carriage return.  "\c" is expanded to
                       "," since the connect string is comma separated.

                       See also the -proxy option below for additional ways
                       to plumb reverse connections.

                       Reverse SSL: using -connect in -ssl mode makes x11vnc
                       act as an SSL client (initiates SSL connection) rather
                       than an SSL server.  The idea is x11vnc might be
                       connecting to stunnel on the viewer side with the
                       viewer in listening mode.  If you do not want this
                       behavior, use -env X11VNC_DISABLE_SSL_CLIENT_MODE=1.
                       With this the viewer side can act as the SSL client
                       as it normally does for forward connections.

                       Reverse SSL Repeater mode:  This will work, but note
                       that if the VNC Client does any sort of a 'Fetch Cert'
                       action before connecting, then the Repeater will
                       likely drop the connection and both sides will need
                       to restart.  Consider the use of -connect_or_exit
                       and -loop300,2 to have x11vnc reconnect once to the
                       repeater after the fetch.  You will probably also want
                       to supply -sslonly to avoid x11vnc thinking the delay
                       in response means the connection is VeNCrypt.  The env
                       var X11VNC_DISABLE_SSL_CLIENT_MODE=1 discussed above
                       may also be useful (i.e. the viewer can do a forward
                       connection as it normally does.)

                       IPv6: as of x11vnc 0.9.10 the -connect option should
                       connect to IPv6 hosts properly.  If there are problems
                       you can disable IPv6 by setting -DX11VNC_IPV6=0
                       in CPPFLAGS when configuring.  If there problems
                       connecting to IPv6 hosts consider a relay like the
                       included inet6to4 script or the -proxy option.

-connect_or_exit str   As with -connect, except if none of the reverse
                       connections succeed, then x11vnc shuts down immediately

                       An easier to type alias for this option is '-coe'

                       By the way, if you do not want x11vnc to listen on
                       ANY interface use -rfbport 0  which is handy for the
                       -connect_or_exit mode.

-proxy string          Use proxy in string (e.g. host:port) as a proxy for
                       making reverse connections (-connect or -connect_or_exit
                       options).

                       Web proxies are supported, but note by default most of
                       them only support destination connections to ports 443
                       or 563, so this might not be very useful (the viewer
                       would need to listen on that port or the router would
                       have to do a port redirection).

                       A web proxy may be specified by either "host:port"
                       or "http://host:port" (the port is required even if
                       it is the common choices 80 or 8080)

                       SOCKS4, SOCKS4a, and SOCKS5 are also supported.
                       SOCKS proxies normally do not have restrictions on the
                       destination port number.

                       Use a format like this: socks://host:port or
                       socks5://host:port.  Note that ssh -D does not support
                       SOCKS4a, so use socks5://.  For socks:// SOCKS4 is used
                       on a numerical IP and "localhost", otherwise SOCKS4a
                       is used (and so the proxy tries to do the DNS lookup).

                       An experimental mode is "-proxy http://host:port/..."
                       Note the "/" after the port that distinguishes it from
                       a normal web proxy.  The port must be supplied even if
                       it is the default 80.  For this mode a GET is done to
                       the supplied URL with the string host=H&port=P appended.
                       H and P will be the -connect reverse connect host
                       and port.  Use the string "__END__" to disable the
                       appending.  The basic idea here is that maybe some cgi
                       script provides the actual viewer hookup and tunnelling.
                       How to actually achieve this within cgi, php, etc. is
                       not clear...  A custom web server or apache module
                       would be straight-forward.

                       Another experimental mode is "-proxy ssh://user@host"
                       in which case a SSH tunnel is used for the proxying.
                       "user@" is not needed unless your unix username is
                       different on "host".  For a non-standard SSH port
                       use ssh://user@host:port.  If proxies are chained (see
                       next paragraph) then the ssh one must be the first one.
                       If ssh-agent is not active, then the ssh password needs
                       to be entered in the terminal where x11vnc is running.
                       Examples:

                         -connect localhost:0 -proxy ssh://me@friends-pc:2222

                         -connect snoopy:0 -proxy ssh://ssh.company.com

                       Multiple proxies may be chained together in case one
                       needs to ricochet off of a number of hosts to finally
                       reach the VNC viewer.  Up to 3 may be chained, separate
                       them by commas in the order they are to be connected to.
                       E.g.:  http://host1:port1,socks5://host2:port2 or three
                       like:  first,second,third

                       IPv6: as of x11vnc 0.9.10 the -proxy option should
                       connect to IPv6 hosts properly.  If there are problems
                       you can disable IPv6 by setting -DX11VNC_IPV6=0
                       in CPPFLAGS when configuring.  If there problems
                       connecting to IPv6 hosts consider a relay like the
                       included inet6to4 script.

-vncconnect            Monitor the VNC_CONNECT X property set by the standard
-novncconnect          VNC program vncconnect(1).  When the property is
                       set to "host" or "host:port" establish a reverse
                       connection.  Using xprop(1) instead of vncconnect may
                       work (see the FAQ).  The -remote control mechanism uses
                       X11VNC_REMOTE channel, and this option disables/enables
                       it as well.  Default: -vncconnect

                       To use different names for these X11 properties (e.g. to
                       have separate communication channels for multiple
                       x11vnc's on the same display) set the VNC_CONNECT or
                       X11VNC_REMOTE env. vars. to the string you want, for
                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345
                       Both sides of the channel must use the same unique name.
                       The same can be done for the internal X11VNC_TICKER
                       property (heartbeat and timestamp) if desired.

-allow host1[,host2..] Only allow client connections from hosts matching
                       the comma separated list of hostnames or IP addresses.
                       Can also be a numerical IP prefix, e.g. "192.168.100."
                       to match a simple subnet, for more control build
                       LibVNCServer with libwrap support (See the FAQ).  If the
                       list contains a "/" it instead is a interpreted
                       as a file containing addresses or prefixes that is
                       re-read each time a new client connects.  Lines can be
                       commented out with the "#" character in the usual way.

                       -allow applies in -ssl mode, but not in -stunnel mode.

                       IPv6: as of x11vnc 0.9.10 a host can be specified
                       in IPv6 numerical format, e.g. 2001:4860:b009::93.

-localhost             Basically the same as "-allow 127.0.0.1".

                       Note: if you want to restrict which network interface
                       x11vnc listens on, see the -listen option below.
                       E.g. "-listen localhost" or "-listen 192.168.3.21".
                       As a special case, the option "-localhost" implies
                       "-listen localhost".

                       A rare case, but for non-localhost -listen usage, if
                       you use the remote control mechanism (-R) to change
                       the -listen interface you may need to manually adjust
                       the -allow list (and vice versa) to avoid situations
                       where no connections (or too many) are allowed.

                       If you do not want x11vnc to listen on ANY interface
                       (evidently you are using -connect or -connect_or_exit,
                       or plan to use remote control: -R connect:host), use
                       -rfbport 0

                       IPv6: if IPv6 is supported, this option automatically
                       implies the IPv6 loopback address '::1' as well.

-unixsock str          Listen on the unix socket (AF_UNIX) 'str'
                       for connections.  This mode is for either local
                       connections or a tunnel endpoint where one wants the
                       file permission of the unix socket file to determine
                       what can connect to it.  (This currently requires an
                       edit to libvnserver/rfbserver.c: comment out lines 310
                       and 311, 'close(sock)' and 'return NULL' in rfbserver.c
                       after the setsockopt() call.) Note that to disable all
                       tcp listening ports specify '-rfbport 0' and should be
                       useful with this mode.  Example:
                           mkdir ~/s; chmod 700 ~/s;
                           x11vnc -unixsock ~/s/mysock -rfbport 0 ...
                       The SSVNC unix vncviewer can connect to unix sockets.

-listen6 str           When in IPv6 listen mode "-6", listen only on the
                       network interface with address "str".  It also works
                       for link scope addresses (fe80::219:dbff:fee5:3f92%eth0)
                       and IPv6 hostname strings (e.g. ipv6.google.com.)
                       Use LibVNCServer -listen option for the IPv4 interface.

-nolookup              Do not use gethostbyname() or gethostbyaddr() to look up
                       host names or IP numbers.  Use this if name resolution
                       is incorrectly set up and leads to long pauses as name
                       lookups time out, etc.

-input string          Fine tuning of allowed user input.  If "string" does
                       not contain a comma "," the tuning applies only to
                       normal clients.  Otherwise the part before "," is
                       for normal clients and the part after for view-only
                       clients.  "K" is for Keystroke input, "M" for
                       Mouse-motion input, "B" for Button-click input, "C"
                       is for Clipboard input, and "F" is for File transfer
                       (ultravnc only).  Their presence in the string enables
                       that type of input.  E.g. "-input M" means normal
                       users can only move the mouse and  "-input KMBCF,M"
                       lets normal users do anything and enables view-only
                       users to move the mouse.  This option is ignored when
                       a global -viewonly is in effect (all input is discarded
                       in that case).

-grabkbd               When VNC viewers are connected, attempt to the grab
                       the keyboard so a (non-malicious) user sitting at the
                       physical display is not able to enter keystrokes.
                       This method uses XGrabKeyboard(3X11) and so it is
                       not secure and does not rule out the person at the
                       physical display injecting keystrokes by flooding the
                       server with them, grabbing the keyboard himself, etc.
                       Some degree of cooperation from the person at the
                       display is assumed.  This is intended for remote
                       help-desk or educational usage modes.

                       Note: on some recent (12/2010) X servers and/or
                       desktops, -grabkbd no longer works: it prevents the
                       window manager from resizing windows and similar things.
                       Try -ungrabboth below (might not work.)

-grabptr               As -grabkbd, but for the mouse pointer using
                       XGrabPointer(3X11).  Unfortunately due to the way the X
                       server works, the mouse can still be moved around by the
                       user at the physical display, but he will not be able to
                       change window focus with it.  Also some window managers
                       that call XGrabServer(3X11) for resizes, etc, will
                       act on the local user's input.  Again, some degree of
                       cooperation from the person at the display is assumed.

-ungrabboth            Whenever there is any input (either keyboard or
                       pointer), ungrab *both* the keyboard and the pointer
                       while injecting the synthetic input.  This is to allow
                       window managers, etc. a chance to grab.

-grabalways            Apply both -grabkbd and -grabptr even when no VNC
                       viewers are connected.  If you only want one of them,
                       use the -R remote control to turn the other back on,
                       e.g. -R nograbptr.

-viewpasswd string     Supply a 2nd password for view-only logins.  The -passwd
                       (full-access) password must also be supplied.

-passwdfile filename   Specify the LibVNCServer password via the first line
                       of the file "filename" (instead of via -passwd on
                       the command line where others might see it via ps(1)).

                       See the descriptions below for how to supply multiple
                       passwords, view-only passwords, to specify external
                       programs for the authentication, and other features.

                       If the filename is prefixed with "rm:" it will be
                       removed after being read.  Perhaps this is useful in
                       limiting the readability of the file.  In general, the
                       password file should not be readable by untrusted users
                       (BTW: neither should the VNC -rfbauth file: it is NOT
                       encrypted, only obscured with a fixed key).

                       If the filename is prefixed with "read:" it will
                       periodically be checked for changes and reread.  It is
                       guaranteed to be reread just when a new client connects
                       so that the latest passwords will be used.

                       If "filename" is prefixed with "cmd:" then the
                       string after the ":" is run as an external command:
                       the output of the command will be interpreted as if it
                       were read from a password file (see below).  If the
                       command does not exit with 0, then x11vnc terminates
                       immediately.  To specify more than 1000 passwords this
                       way set X11VNC_MAX_PASSWDS before starting x11vnc.
                       The environment variables are set as in -accept.

                       Note that due to the VNC protocol only the first 8
                       characters of a password are used (DES key).

                       If "filename" is prefixed with "custom:" then a
                       custom password checker is supplied as an external
                       command following the ":". The command will be run
                       when a client authenticates.  If the command exits with
                       0 the client is accepted, otherwise it is rejected.
                       The environment variables are set as in -accept.

                       The standard input to the custom command will be a
                       decimal digit "len" followed by a newline. "len"
                       specifies the challenge size and is usually 16 (the
                       VNC spec).  Then follows len bytes which is the random
                       challenge string that was sent to the client. This is
                       then followed by len more bytes holding the client's
                       response (i.e. the challenge string encrypted via DES
                       with the user password in the standard situation).

                       The "custom:" scheme can be useful to implement
                       dynamic passwords or to implement methods where longer
                       passwords and/or different encryption algorithms
                       are used.  The latter will require customizing the VNC
                       client as well.  One could create an MD5SUM based scheme
                       for example.

                       File format for -passwdfile:

                       If multiple non-blank lines exist in the file they are
                       all taken as valid passwords.  Blank lines are ignored.
                       Password lines may be "commented out" (ignored) if
                       they begin with the character "#" or the line contains
                       the string "__SKIP__".  Lines may be annotated by use
                       of the "__COMM__" string: from it to the end of the
                       line is ignored.  An empty password may be specified
                       via the "__EMPTY__" string on a line by itself (note
                       your viewer might not accept empty passwords).

                       If the string "__BEGIN_VIEWONLY__" appears on a
                       line by itself, the remaining passwords are used for
                       viewonly access.  For compatibility, as a special case
                       if the file contains only two password lines the 2nd
                       one is automatically taken as the viewonly password.
                       Otherwise the "__BEGIN_VIEWONLY__" token must be
                       used to have viewonly passwords.  (tip: make the 3rd
                       and last line be "__BEGIN_VIEWONLY__" to have 2
                       full-access passwords)

-showrfbauth filename  Print to the screen the obscured VNC password kept in
                       the rfbauth file "filename" and then exit.

-unixpw [list]         Use Unix username and password authentication.  x11vnc
                       will use the su(1) program to verify the user's
                       password.  [list] is an optional comma separated list
                       of allowed Unix usernames.  If the [list] string begins
                       with the character "!" then the entire list is taken
                       as an exclude list.  See below for per-user options
                       that can be applied.

                       A familiar "login:" and "Password:" dialog is
                       presented to the user on a black screen inside the
                       vncviewer.  The connection is dropped if the user fails
                       to supply the correct password in 3 tries or does not
                       send one before a 45 second timeout.  Existing clients
                       are view-only during this period.

                       If the first character received is "Escape" then the
                       unix username will not be displayed after "login:"
                       as it is typed.  This could be of use for VNC viewers
                       that automatically type the username and password.

                       Since the detailed behavior of su(1) can vary from
                       OS to OS and for local configurations, test the mode
                       before deployment to make sure it is working properly.
                       x11vnc will attempt to be conservative and reject a
                       login if anything abnormal occurs.

                       One case to note: FreeBSD and the other BSD's by
                       default it is impossible for the user running x11vnc to
                       validate his *own* password via su(1) (commenting out
                       the pam_self.so entry in /etc/pam.d/su eliminates this
                       behavior).  So the x11vnc login will always *FAIL* for
                       this case (even when the correct password is supplied).

                       A possible workaround for this on *BSD would be to
                       start x11vnc as root with the "-users +nobody" option
                       to immediately switch to user nobody where the su'ing
                       will proceed normally.

                       Another source of potential problems are PAM modules
                       that prompt for extra info, e.g. password aging modules.
                       These logins will fail as well even when the correct
                       password is supplied.

                       **IMPORTANT**: to prevent the Unix password being sent
                       in *clear text* over the network, one of two schemes
                       will be enforced: 1) the -ssl builtin SSL mode, or 2)
                       require both -localhost and -stunnel be enabled.

                       Method 1) ensures the traffic is encrypted between
                       viewer and server.  A PEM file will be required, see the
                       discussion under -ssl below (under some circumstances
                       a temporary one can be automatically generated).

                       Method 2) requires the viewer connection to appear
                       to come from the same machine x11vnc is running on
                       (e.g. from a ssh -L port redirection).  And that the
                       -stunnel SSL mode be used for encryption over the
                       network. (see the description of -stunnel below).

                       Note: as a convenience, if you ssh(1) in and start
                       x11vnc it will check if the environment variable
                       SSH_CONNECTION is set and appears reasonable.  If it
                       does, then the -ssl or -stunnel requirement will be
                       dropped since it is assumed you are using ssh for the
                       encrypted tunnelling.  -localhost is still enforced.
                       Use -ssl or -stunnel to force SSL usage even if
                       SSH_CONNECTION is set.

                       To override the above restrictions you can set
                       environment variables before starting x11vnc:

                       Set UNIXPW_DISABLE_SSL=1 to disable requiring either
                       -ssl or -stunnel (as under SSH_CONNECTION.)  Evidently
                       you will be using a different method to encrypt the
                       data between the vncviewer and x11vnc: perhaps ssh(1)
                       or an IPSEC VPN. -localhost is still enforced (however,
                       see the next paragraph.)

                       Set UNIXPW_DISABLE_LOCALHOST=1 to disable the -localhost
                       requirement in -unixpw modes.  One should never do this
                       (i.e. allow the Unix passwords to be sniffed on the
                       network.)  This also disables the localhost requirement
                       for reverse connections (see below.)

                       Note that use of -localhost with ssh(1) (and no -unixpw)
                       is roughly the same as requiring a Unix user login
                       (since a Unix password or the user's public key
                       authentication is used by sshd on the machine where
                       x11vnc runs and only local connections from that machine
                       are accepted).

                       Regarding reverse connections (e.g. -R connect:host
                       and -connect host), when the -localhost constraint is
                       in effect then reverse connections can only be used
                       to connect to the same machine x11vnc is running on
                       (default port 5500).  Please use a ssh or stunnel port
                       redirection to the viewer machine to tunnel the reverse
                       connection over an encrypted channel.

                       In -inetd mode the Method 1) will be enforced (not
                       Method 2).  With -ssl in effect reverse connections
                       are disabled.  If you override this via env. var, be
                       sure to also use encryption from the viewer to inetd.
                       Tip: you can also have your own stunnel spawn x11vnc
                       in -inetd mode (thereby bypassing inetd).  See the FAQ
                       for details.

                       The user names in the comma separated [list] may have
                       per-user options after a ":", e.g. "fred:opts"
                       where "opts" is a "+" separated list of
                       "viewonly", "fullaccess", "input=XXXX", or
                       "deny", e.g. "karl,wally:viewonly,boss:input=M".
                       For "input=" it is the K,M,B,C described under -input.

                       If an item in the list is "*" that means those
                       options apply to all users.  It ALSO implies all users
                       are allowed to log in after supplying a valid password.
                       Use "deny" to explicitly deny some users if you use
                       "*" to set a global option.  If [list] begins with the
                       "!" character then "*" is ignored for checking if
                       the user is allowed, but the option values associated
                       with it do apply as normal.

                       There are also some utilities for checking passwords
                       if [list] starts with the "%" character.  See the
                       quick_pw() function for more details.  Description:
                       "%-" or "%stdin" means read one line from stdin.
                       "%env" means it is in $UNIXPW env var.  A leading
                       "%/" or "%." means read the first line from the
                       filename that follows after the % character. % by
                       itself means prompt for the username and password.
                       Otherwise: %user:pass   E.g. -unixpw %fred:swordfish
                       For the other cases user:pass is read from the indicated
                       source.  If the password is correct 'Y user' is printed
                       and the program exit code is 0.  If the password is
                       incorrect it prints 'N user' and the exit code is 1.
                       If there is some other error the exit code is 2.
                       This feature enables x11vnc to be a general unix user
                       password checking tool; it could be used from scripts
                       or other programs.  These % password checks also apply
                       to the -unixpw_nis and -unixpw_cmd options.

                       For the % password check, if the env. var. UNIXPW_CMD
                       is set to a command then it is run as the user (assuming
                       the password is correct.)  The output of the command is
                       not printed, the program or script must manage that by
                       some other means.  The exit code of x11vnc will depend
                       on the exit code of the command that is run.

                       Use -nounixpw to disable unixpw mode if it was enabled
                       earlier in the cmd line (e.g. -svc mode)

-unixpw_nis [list]     As -unixpw above, however do not use su(1) but rather
                       use the traditional getpwnam(3) + crypt(3) method to
                       verify passwords. All of the above -unixpw options and
                       constraints apply.

                       This mode requires that the encrypted passwords be
                       readable.  Encrypted passwords stored in /etc/shadow
                       will be inaccessible unless x11vnc is run as root.

                       This is called "NIS" mode simply because in most
                       NIS setups user encrypted passwords are accessible
                       (e.g. "ypcat passwd") by an ordinary user and so that
                       user can authenticate ANY user.

                       NIS is not required for this mode to work (only that
                       getpwnam(3) return the encrypted password is required),
                       but it is unlikely it will work (as an ordinary user)
                       for most modern environments unless NIS is available.
                       On the other hand, when x11vnc is run as root it will
                       be able to to access /etc/shadow even if NIS is not
                       available (note running as root is often done when
                       running x11vnc from inetd and xdm/gdm/kdm).

                       Looked at another way, if you do not want to use the
                       su(1) method provided by -unixpw (i.e. su_verify()), you
                       can run x11vnc as root and use -unixpw_nis.  Any users
                       with passwords in /etc/shadow can then be authenticated.

                       In -unixpw_nis mode, under no circumstances is x11vnc's
                       user password verifying function based on su called
                       (i.e. the function su_verify() that runs /bin/su
                       in a pseudoterminal to verify passwords.)  However,
                       if -unixpw_nis is used in conjunction with the -find
                       and -create -display WAIT:... modes then, if x11vnc is
                       running as root, /bin/su may be called externally to
                       run the find or create commands.

-unixpw_cmd cmd        As -unixpw above, however do not use su(1) but rather
                       run the externally supplied command "cmd".  The first
                       line of its stdin will be the username and the second
                       line the received password.  If the command exits
                       with status 0 (success) the VNC user will be accepted.
                       It will be rejected for any other return status.

                       Dynamic passwords and non-unix passwords, e.g. LDAP,
                       can be implemented this way by providing your own custom
                       helper program.  Note that the remote viewer is given 3
                       tries to enter the correct password, and so the program
                       may be called in a row that many (or more) times.

                       If a list of allowed users is needed to limit who can
                       log in, use -unixpw [list] in addition to this option.

                       In FINDDISPLAY and FINDCREATEDISPLAY modes the "cmd"
                       will also be run with the RFB_UNIXPW_CMD_RUN env. var.
                       non-empty and set to the corresponding display
                       find/create command.  The first two lines of input are
                       the username and passwd as in the normal case described
                       above.  To support FINDDISPLAY and FINDCREATEDISPLAY,
                       "cmd" should run the requested command as the user
                       (and most likely refusing to run it if the password is
                       not correct.)  Here is an example script (note it has
                       a hardwired bogus password "abc"!)

                         #!/bin/sh
                         # Example x11vnc -unixpw_cmd script.
                         # Read the first two lines of stdin (user and passwd)
                         read user
                         read pass

                         debug=0
                         if [ $debug = 1 ]; then
                                echo "user: $user" 1>&2
                                echo "pass: $pass" 1>&2
                                env | egrep -i 'rfb|vnc' 1>&2
                         fi

                         # Check if the password is valid.
                         # (A real example would use ldap lookup, etc!)
                         if [ "X$pass" != "Xabc" ]; then
                                exit 1  # incorrect password
                         fi

                         if [ "X$RFB_UNIXPW_CMD_RUN" = "X" ]; then
                                exit 0  # correct password
                         else
                                # Run the requested command (finddisplay)
                                if [ $debug = 1 ]; then
                                        echo "run: $RFB_UNIXPW_CMD_RUN" 1>&2
                                fi
                                exec /bin/su - "$user" -c "$RFB_UNIXPW_CMD_RUN"
                         fi

                       In -unixpw_cmd mode, under no circumstances is x11vnc's
                       user password verifying function based on su called
                       (i.e. the function su_verify() that runs /bin/su in a
                       pseudoterminal to verify passwords.)  It is up to the
                       supplied unixpw_cmd to do user switching if desired
                       and if it has the permissions to do so.

-find                  Find the user's display using FINDDISPLAY. This
                       is an alias for "-display WAIT:cmd=FINDDISPLAY".

                       Note: if a -display occurs later on the command line
                       it will override the -find setting.

                       For this and the next few options see -display WAIT:...
                       below for all of the details.

-finddpy               Run the FINDDISPLAY program, print out the found
                       display (if any) and exit.  Output is like: DISPLAY=:0.0
                       DISPLAY=:0.0,XPID=12345 or DISPLAY=:0.0,VT=7.  XPID is
                       the process ID of the found X server.  VT is the Linux
                       virtual terminal of the X server.
-listdpy               Have the FINDDISPLAY program list all of your displays
                       (i.e. all the X displays on the local machine that you
                       have access rights to).  x11vnc then exits.

-findauth [disp]       Apply the -find/-finddpy heuristics to try to guess
                       the XAUTHORITY file for DISPLAY 'disp'.  If 'disp'
                       is not supplied, then the value in the -display on
                       the cmdline is used; failing that $DISPLAY is used;
                       and failing that ":0" is used.  x11vnc then exits.

                       If nothing is printed out, that means no XAUTHORITY was
                       found for 'disp'; i.e. failure.  If "XAUTHORITY="
                       is printed out, that means use the default (i.e. do
                       not set XAUTHORITY).  If "XAUTHORITY=/path/to/file"
                       is printed out, then use that file.

                       XDM/GDM/KDM: if you are running x11vnc as root and want
                       to find the XAUTHORITY before anyone has logged into an
                       X session yet, use: x11vnc -env FD_XDM=1 -findauth ...
                       (This will also find the XAUTHORITY if a user is already
                       logged into the X session.)  When running as root,
                       FD_XDM=1 will be tried if the initial -findauth fails.

-create                First try to find the user's display using FINDDISPLAY,
                       if that doesn't succeed create an X session via the
                       FINDCREATEDISPLAY method.  This is an alias for
                       "-display WAIT:cmd=FINDCREATEDISPLAY-Xvfb".

                       Note: if a -display occurs later on the command line
                       it will override the -create setting.

                       SSH NOTE: for both -find and -create you can (should!)
                       add the "-localhost" option to force SSH tunnel access.

-xdummy                As in -create, except Xdummy instead of Xvfb.
-xvnc                  As in -create, except Xvnc instead of Xvfb.
-xvnc_redirect         As in -create, except Xvnc.redirect instead of Xvfb.
-xdummy_xvfb           Sets WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb

-create_xsrv str       Sets WAIT:cmd=FINDCREATEDISPLAY-<str>  Can be on cmdline
                       after anything that sets WAIT:.. and other things
                       (e.g. -svc, -xdmsvc) to adjust the X server list.
                       Example: -svc ... -create_xsrv Xdummy,X

-svc                   Terminal services mode based on SSL access.  Alias for
                       -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb -unixpw -users
                       unixpw= -ssl SAVE   Also "-service".

                       Note: if a -display, -unixpw, -users, or -ssl occurs
                       later on the command line it will override the -svc
                       setting.

-svc_xdummy            As -svc except Xdummy instead of Xvfb.
-svc_xvnc              As -svc except Xvnc instead of Xvfb.
-svc_xdummy_xvfb       As -svc with Xdummy,Xvfb.

-xdmsvc                Display manager Terminal services mode based on SSL.
                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp
                       -unixpw -users unixpw= -ssl SAVE  Also "-xdm_service".

                       Note: if a -display, -unixpw, -users, or -ssl occurs
                       later on the command line it will override the -xdmsvc
                       setting.

                       To create a session a user will have to first log in
                       to the -unixpw dialog and then log in again to the
                       XDM/GDM/KDM prompt.  Subsequent re-connections will
                       only require the -unixpw password.  See the discussion
                       under -display WAIT:... for more details about XDM,
                       etc configuration.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-sshxdmsvc             Display manager Terminal services mode based on SSH.
                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp
                       -localhost.

                       The -localhost option constrains connections to come
                       in via a SSH tunnel (which will require a login).
                       To create a session a user will also have to log into
                       the XDM GDM KDM prompt. Subsequent re-connections will
                       only only require the SSH login.  See the discussion
                       under -display WAIT:... for more details about XDM,
                       etc configuration.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-unixpw_system_greeter Present a "Press 'Escape' for System Greeter" option
                       to the connecting VNC client in combined -unixpw
                       and xdmcp FINDCREATEDISPLAY modes (e.g. -xdmsvc).

                       Normally in a -unixpw mode the VNC client must
                       supply a valid username and password to gain access.
                       However, if -unixpw_system_greeter is supplied AND
                       the FINDCREATEDISPLAY command matches 'xdmcp', then
                       the user has the option to press Escape and then get a
                       XDM/GDM/KDM login/greeter panel instead. They will then
                       supply a username and password directly to the greeter.

                       Otherwise, in xdmcp FINDCREATEDISPLAY mode the user
                       must supply his username and password TWICE.  First to
                       the initial unixpw login dialog, and second to the
                       subsequent XDM/GDM/KDM greeter.  Note that if the user
                       re-connects and supplies his username and password in
                       the unixpw dialog the xdmcp greeter is skipped and
                       he is connected directly to his existing X session.
                       So the -unixpw_system_greeter option avoids the extra
                       password at X session creation time.

                       Example:  x11vnc -xdmsvc -unixpw_system_greeter
                       See -unixpw and -display WAIT:... for more info.

                       The special options after a colon at the end of the
                       username (e.g. user:solid) described under -display
                       WAIT: are also applied in this mode if they are typed
                       in before the user hits Escape.  The username is ignored
                       but the colon options are not.

                       The default message is 2 lines in a small font, set
                       the env. var. X11VNC_SYSTEM_GREETER1=true for a 1 line
                       message in a larger font.

                       If the user pressed Escape the FINDCREATEDISPLAY command
                       will be run with the env. var. X11VNC_XDM_ONLY=1.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-redirect port         As in FINDCREATEDISPLAY-Xvnc.redirect mode except
                       redirect immediately (i.e. without X session finding
                       or creation) to a VNC server listening on port. You
                       can also supply host:port to redirect to a different
                       machine.

                       If 0 <= port < 200 it is taken as a VNC display (5900 is
                       added to get the actual port), if port < 0 then -port
                       is used.

                       Probably the only reason to use the -redirect option
                       is in conjunction with SSL support, e.g. -ssl SAVE.
                       This provides an easy way to add SSL encryption to a VNC
                       server that does not support SSL (e.g. Xvnc or vnc.so)
                       In fact, the protocol does not even need to be VNC,
                       and so "-rfbport port1 -ssl SAVE -redirect host:port2"
                       can act as a replacement for stunnel(1).

                       This mode only allows one redirected connection.
                       The -forever option does not apply.  Use -inetd or
                       -loop for persistent service.

-display_WAIT :...      A special usage mode for the normal -display option.
                       Useful with -unixpw, but can be used independently
                       of it.  If the display string begins with WAIT: then
                       x11vnc waits until a VNC client connects before opening
                       the X display (or -rawfb device).

                       This could be useful for delaying opening the display
                       for certain usage modes (say if x11vnc is started at
                       boot time and no X server is running or users logged
                       in yet).

                       If the string is, e.g. WAIT:0.0 or WAIT:1, i.e. "WAIT"
                       in front of a normal X display, then that indicated
                       display is used.

                       One can also insert a geometry between colons, e.g.
                       WAIT:1280x1024:... to set the size of the display the
                       VNC client first attaches to since some VNC viewers
                       will not automatically adjust to a new framebuffer size.

                       A more interesting case is like this:

                            WAIT:cmd=/usr/local/bin/find_display

                       in which case the command after "cmd=" is run to
                       dynamically work out the DISPLAY and optionally the
                       XAUTHORITY data.  The first line of the command output
                       must be of the form DISPLAY=<xdisplay>.  On Linux
                       if the virtual terminal is known append ",VT=n" to
                       this string and the chvt(1) program will also be run.
                       Any remaining output is taken as XAUTHORITY data.
                       It can be either of the form XAUTHORITY=<file> or raw
                       xauthority data for the display. For example;

                            xauth extract - $DISPLAY"

                       NOTE: As specified in the previous paragraph, you can
                       supply your own WAIT:cmd=... program or script, BUT
                       there are two very useful *BUILT-IN* ones: FINDDISPLAY
                       (alias -find above) and FINDCREATEDISPLAY (alias -create
                       above.)  Most people use these instead of creating
                       their own script.  Read the following (especially the
                       BUILT-IN modes sections) to see how to configure these
                       two useful builtin -display WAIT: modes.

                       In the case of -unixpw (and -unixpw_nis only if x11vnc
                       is running as root), then the cmd= command is run
                       as the user who just authenticated via the login and
                       password prompt.

                       In the case of -unixpw_cmd, the commands will also be
                       run as the logged-in user, as long as the user-supplied
                       helper program supports RFB_UNIXPW_CMD_RUN (see the
                       -unixpw_cmd option.)

                       Also in the case of -unixpw, the user logging in can
                       place a colon at the end of her username and supply
                       a few options: scale=, scale_cursor= (or sc=), solid
                       (or so), id=, clear_mods (or cm), clear_keys (or
                       ck), clear_all (or ca), repeat, speeds= (or sp=),
                       readtimeout= (or rd=), viewonly (or vo), nodisplay=
                       (or nd=), rotate= (or ro=), or noncache (or nc),
                       all separated by commas if there is more than one.
                       After the user logs in successfully, these options will
                       be applied to the VNC screen.  For example,

                          login: fred:scale=3/4,sc=1,repeat
                          Password: ...

                          login: runge:sp=modem,rd=120,solid

                       for convenience m/n implies scale= e.g. fred:3/4  If you
                       type and enter your password incorrectly, to retrieve
                       your long "login:" line press the Up arrow once
                       (before typing anything else).

                       Most of these colon options only apply to the builtin
                       FINDDISPLAY and FINDCREATEDISPLAY modes, but note
                       that they are passed to the extrenal command in the
                       environment as well and so could be used.

                       In the login panel, press F1 to get a list of the
                       available options that you can add after the username.

                       Another option is "geom=WxH" or "geom=WxHxD" (or
                       ge=). This only has an effect in FINDCREATEDISPLAY
                       mode when a virtual X server such as Xvfb is going
                       to be created.  It sets the width and height of
                       the new display, and optionally the color depth as
                       well.

                       You can also supply "gnome", "kde", "twm",
                       "fvwm", "mwm", "dtwm", "wmaker", "xfce",
                       "lxde", "enlightenment", "Xsession", or
                       "failsafe" (same as "xterm") to have the created
                       display use that mode for the user session.

                       Specify "tag=..." to set the unique FD_TAG desktop
                       session tag described below.  Note: this option will
                       be ignored if the FD_TAG env. var. is already set or
                       if the viewer-side supplied value is not completely
                       composed of alphanumeric or '_' or '-' characters.

                       User preferences file: Instead of having the user type
                       in geom=WxH,... etc. every time he logs in to find
                       or create his X session, if you set FD_USERPREFS to
                       a string that does not contain the "/" character,
                       then the user's home directory is prepended to that
                       string and if the file exists its first line is read
                       and appended to any options he supplied at the login:
                       prompt.  For example -env FD_USERPREFS=.x11vnc_create
                       and the user put "geom=1600x1200" in his
                       ~/.x11vnc_create file.

                       To disable the option setting set the environment
                       variable X11VNC_NO_UNIXPW_OPTS=1 before starting x11vnc.
                       To set any other options, the user can use the gui
                       (x11vnc -gui connect) or the remote control method
                       (x11vnc -R opt:val) during his VNC session.

                       So we see the combination of -display WAIT:cmd=... and
                       -unixpw allows automatic pairing of an unix
                       authenticated VNC user with his desktop.  This could
                       be very useful on SunRays and also any system where
                       multiple users share a given machine.  The user does
                       not need to remember special ports or passwords set up
                       for his desktop and VNC.

                       A nice way to use WAIT:cmd=... is out of inetd(8)
                       (it automatically forks a new x11vnc for each user).
                       You can have the x11vnc inetd spawned process run as,
                       say, root or nobody.  When run as root (for either inetd
                       or display manager), you can also supply the option
                       "-users unixpw=" to have the x11vnc process switch to
                       the user as well.  Note: there will be a 2nd SSL helper
                       process that will not switch, but it is only encoding
                       and decoding the encrypted stream at that point.

                       BUILT-IN modes:

                       -- Automatic Finding of User X Sessions --

                       As a special case, WAIT:cmd=FINDDISPLAY will run a
                       script that works on most Unixes to determine a user's
                       DISPLAY variable and xauthority data (see who(1)).

                       NOTE: The option "-find" is an alias for this mode.

                       To have this default script printed to stdout (e.g. for
                       customization) run with WAIT:cmd=FINDDISPLAY-print To
                       have the script run to print what display it would find
                       use "-finddpy" or WAIT:cmd=FINDDISPLAY-run

                       The standard script runs xdpyinfo(1) run on potential
                       displays.  If your X server(s) have a login greeter
                       that exclusively grabs the Xserver, then xdpyinfo
                       blocks forever and this mode will not work.  See
                       www.karlrunge.com/x11vnc/faq.html#faq-display-manager
                       for how to disable this for dtgreet on Solaris and
                       possibly for other greeters.

                       In -find/cmd=FINDDISPLAY mode, if you set FD_XDM=1,
                       e.g. 'x11vnc -env FD_XDM=1 -find ...' and x11vnc is
                       running as root (e.g. inetd) then it will try to find
                       the XAUTHORITY file of a running XDM/GDM/KDM login
                       greeter (i.e. no user has logged into an X session yet.)

                       As another special case, WAIT:cmd=HTTPONCE will allow
                       x11vnc to service one http request and then exit.
                       This is usually done in -inetd mode to run on, say,
                       port 5800 and allow the Java vncviewer to be downloaded
                       by client web browsers.  For example:

                        5815 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc
\
                          -inetd -q -http_ssl -prog /.../x11vnc \
                          -display WAIT:cmd=HTTPONCE

                       Where /.../x11vnc is the full path to x11vnc.
                       It is used in the Apache SSL-portal example (see FAQ).

                       In this mode you can set X11VNC_SKIP_DISPLAY to a
                       comma separated list of displays (e.g. ":0,:1") to
                       ignore in the finding process.  The ":" is optional.
                       Ranges n-m e.g. 0-20 can also be supplied. This string
                       can also be set by the connecting user via "nd="
                       using "+" instead of ","  If "nd=all" or you set
                       X11VNC_SKIP_DISPLAY=all then all display finding fails
                       as if you set X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (below.)

                       On some systems lsof(1) can be very slow.  Set the
                       env. var. FIND_DISPLAY_NO_LSOF=1 to skip using lsof to
                       try to find the Linux VT the X server is running on.
                       set FIND_DISPLAY_NO_VT_FIND=1 to avoid looking at all.

                       -- Automatic Creation of User X Sessions --

                       An interesting option is WAIT:cmd=FINDCREATEDISPLAY
                       that is like FINDDISPLAY in that is uses the same method
                       to find an existing display.  However, if it does not
                       find one it will try to *start* up an X server session
                       for the user.  This is the only time x11vnc tries to
                       actually start up an X server.

                       NOTE: The option "-create" is an alias for this mode.

                       It will start looking for an open display number at :20
                       Override via X11VNC_CREATE_STARTING_DISPLAY_NUMBER=n
                       By default 80 X displays are allowed (i.e. going to :99)
                       Override via X11VNC_CREATE_MAX_DISPLAYS=n

                       For its heuristics, the create display script sets
                       LC_ALL=C so that command output is uniform.  By default
                       it will try to restore LC_ALL right before starting the
                       user session.  However, if you don't mind it keeping
                       LC_ALL=C set the env. var.: X11VNC_CREATE_LC_ALL_C_OK=1

                       By default FINDCREATEDISPLAY will try Xvfb and then
                       Xdummy:

                       The Xdummy wrapper is part of the x11vnc source code
                       (x11vnc/misc/Xdummy)  It should be available in PATH
                       and have run "Xdummy -install" once to create the
                       shared library.  Xdummy only works on Linux.  As of
                       12/2009 it no longer needs to be run as root, and the
                       default is to not run as root.  In some circumstances
                       permissions may require running it as root, in these
                       cases specify FD_XDUMMY_RUN_AS_ROOT=1, this is the same
                       as supplying -root to the Xdummy cmdline.

                       Xvfb is available on most platforms and does not
                       require root.

                       An advantage of Xdummy over Xvfb is that Xdummy supports
                       RANDR dynamic screen resizing.

                       When x11vnc exits (i.e. user disconnects) the X
                       server session stays running in the background.
                       The FINDDISPLAY will find it directly next time.
                       The user must exit the X session in the usual way for
                       it to terminate (or kill the X server process if all
                       else fails).

                       To troubleshoot the FINDCREATEDISPLAY mechanism,
                       set the following env. var. to an output log file,
                       e.g -env CREATE_DISPLAY_OUTPUT=/tmp/mydebug.txt

                       So this is a somewhat odd mode for x11vnc in that it
                       will start up and poll virtual X servers!  This can
                       be used from, say, inetd(8) to provide a means of
                       definitely getting a desktop (either real or virtual)
                       on the machine.  E.g. a desktop service:

                         5900 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc
                          -inetd -q -http -ssl SAVE -unixpw -users unixpw=\
                          -passwd secret -prog /.../x11vnc \
                          -display WAIT:cmd=FINDCREATEDISPLAY

                       Where /.../x11vnc is the full path to x11vnc.

                       See the -svc/-service option alias above.

                       If for some reason you do not want x11vnc to ever
                       try to find an existing display set the env. var
                       X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (also -env ...)
                       This is the same as setting X11VNC_SKIP_DISPLAY=all or
                       supplying "nd=all" after "username:"

                       Use WAIT:cmd=FINDCREATEDISPLAY-print to print out the
                       script that is used for this.

                       You can specify the preferred X server order via e.g.,
                       WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb,X  and/or leave
                       out ones you do not want.  The the case "X" means try
                       to start up a real, hardware X server using xinit(1)
                       or startx(1).  If there is already an X server running
                       the X case may only work on Linux (see startx(1)).

                       "Xvnc" will start up a VNC X server (real-
                       or tight-vnc, e.g. use if Xvfb is not available).
                       "Xsrv" will start up the server program in the
                       variable "FD_XSRV" if it is non-empty. You can make
                       this be a wrapper script if you like (it must handle :N,
                       -geometry, and -depth and other X server options).

                       You can set the environment variable FD_GEOM (or
                       X11VNC_CREATE_GEOM) to WxH or WxHxD to set the width
                       and height and optionally the color depth of the
                       created display.  You can also set FD_SESS to be the
                       session (short name of the windowmanager: kde, gnome,
                       twm, failsafe, etc.). FD_OPTS contains extra options
                       to pass to the X server. You can also set FD_PROG to
                       be the full path to the session/windowmanager program.

                       More FD tricks:  FD_CUPS=port or FD_CUPS=host:port
                       will set the cups printing environment.  Similarly for
                       FD_ESD=port or FD_ESD=host:port for esddsp sound
                       redirection.  Set FD_EXTRA to a command to be run a
                       few seconds after the X server starts up.  Set FD_TAG
                       to be a unique name for the session, it is set as an
                       X property, that makes FINDDISPLAY only find sessions
                       with that tag value.

                       Set FD_XDMCP_IF to the network interface that the
                       display manager is running on; default is 'localhost'
                       but you may need to set it to '::1' on some IPv6 only
                       systems or misconfigured display managers.

                       If you want the FINDCREATEDISPLAY session to contact an
                       XDMCP login manager (xdm/gdm/kdm) on the same machine,
                       then use "Xvfb.xdmcp" instead of "Xvfb", etc.
                       The user will have to supply his username and password
                       one more time (but he gets to select his desktop type
                       so that can be useful).  For this to work, you will
                       need to enable localhost XDMCP (udp port 177) for the
                       display manager.  This seems to be:

                        for gdm in gdm.conf:   Enable=true in section [xdmcp]
                        for kdm in kdmrc:      Enable=true in section [Xdmcp]
                        for xdm in xdm-config: DisplayManager.requestPort: 177

                       See the shorthand options above "-svc", "-xdmsvc"
                       and "-sshxdmsvc" that specify the above options for
                       some useful cases.

                       If you set the env. var WAITBG=1 x11vnc will go into
                       the background once listening in wait mode.

                       Another special mode is FINDCREATEDISPLAY-Xvnc.redirect,
                       (or FINDDISPLAY-Xvnc.redirect).  In this case it will
                       start up Xvnc as above if needed, but instead of
                       polling it in its normal way, it simply does a socket
                       redirection of the connected VNC viewer to the Xvnc.

                       So in Xvnc.redirect x11vnc does no VNC but merely
                       transfers the data back and forth.  This should be
                       faster then x11vnc's polling method, but not as fast
                       as connecting directly to the Xvnc with the VNC Viewer.
                       The idea here is to take advantage of x11vnc's display
                       finding/creating scheme, SSL, and perhaps a few others.
                       Most of x11vnc's options do not apply in this mode.

                       Xvnc.redirect should also work for the vnc.so X server
                       module for the h/w display however it will work only
                       for finding the display and the user must already be
                       logged into the X console.

-vencrypt mode         The VeNCrypt extension to the VNC protocol allows
                       encrypted SSL/TLS connections.  If the -ssl mode is
                       enabled, then VeNCrypt is enabled as well BY DEFAULT
                       (they both use a SSL/TLS tunnel, only the protocol
                       handshake is a little different.)

                       To control when and how VeNCrypt is used, specify the
                       mode string.  If mode is "never", then VeNCrypt is
                       not used.  If mode is "support" (the default) then
                       VeNCrypt is supported.  If mode is "only", then the
                       similar and older ANONTLS protocol is not simultaneously
                       supported.  x11vnc's normal SSL mode (vncs://) will be
                       supported under -ssl unless you set mode to "force".

                       If mode is prefixed with "nodh:", then Diffie Hellman
                       anonymous key exchange is disabled.  If mode is prefixed
                       with "nox509:", then X509 key exchange is disabled.

                       To disable all Anonymous Diffie-Hellman access
                       (susceptible to Man-In-The-Middle attack) you will need
                       to supply "-vencrypt nodh:support -anontls never"
                       or "-vencrypt nodh:only"

                       If mode is prefixed with "newdh:", then new Diffie
                       Hellman parameters are generated for each connection
                       (this can be time consuming: 1-60 secs; see -dhparams
                       below for a faster way) rather than using the
                       fixed values in the program.  Using fixed, publicly
                       known values is not known to be a security problem.
                       This setting applies to ANONTLS as well.

                       Long example: -vencrypt newdh:nox509:support

                       Also, if mode is prefixed with "plain:", then
                       if -unixpw mode is active the VeNCrypt "*Plain"
                       username+passwd method is enabled for Unix logins.
                       Otherwise in -unixpw mode the normal login panel is
                       provided.

                       You *MUST* supply the -ssl option for VeNCrypt to
                       be active.  The -vencrypt option only fine-tunes its
                       operation.

-anontls mode          The ANONTLS extension to the VNC protocol allows
                       encrypted SSL/TLS connections.  If the -ssl mode is
                       enabled, then ANONTLS is enabled as well BY DEFAULT
                       (they both use a SSL/TLS tunnel, only the protocol
                       handshake is a little different.)

                       ANONTLS is an older SSL/TLS mode introduced by vino.

                       It is referred to as 'TLS' for its registered VNC
                       security-type name, but we use the more descriptive
                       'ANONTLS' here because it provides only Anonymous
                       Diffie-Hellman encrypted connections, and hence no
                       possibility for certificate authentication.

                       To control when and how ANONTLS is used, specify the
                       mode string.  If mode is "never", then ANONTLS is not
                       used.  If mode is "support" (the default) then ANONTLS
                       is supported.  If mode is "only", then the similar
                       VeNCrypt protocol is not simultaneously supported.
                       x11vnc's normal SSL mode (vncs://) will be supported
                       under -ssl unless you set mode to "force".

                       If mode is prefixed with "newdh:", then new Diffie
                       Hellman parameters are generated for each connection
                       (this can be time consuming: 1-60 secs; see -dhparams
                       below for a faster way) rather than using the
                       fixed values in the program.  Using fixed, publicly
                       known values is not known to be a security problem.
                       This setting applies to VeNCrypt as well.  See the
                       description of "plain:" under -vencrypt.

                       Long example: -anontls newdh:plain:support

                       You *MUST* supply the -ssl option for ANONTLS to
                       be active.  The -anontls option only fine-tunes its
                       operation.

-sslonly               Same as: "-vencrypt never -anontls never"  i.e. it
                       disables the VeNCrypt and ANONTLS encryption methods
                       and only allows standard SSL tunneling.  You must also
                       supply the -ssl ... option (see below.)


-dhparams file         For some operations a set of Diffie Hellman parameters
                       (prime and generator) is needed.  If so, use the
                       parameters in "file". In particular, the VeNCrypt and
                       ANONTLS anonymous DH mode need them.  By default a
                       fixed set is used. If you do not want to do that you
                       can specify "newdh:" to the -vencrypt and -anontls
                       options to generate a new set each session.  If that
                       is too slow for you, use -dhparams file to a set you
                       created manually via "openssl dhparam -out file 1024"

-nossl                 Disable the -ssl option (see below). Since -ssl is off
                       by default -nossl would only be used on the commandline
                       to unset any *earlier* -ssl option (or -svc...)

-ssl [pem]             Use the openssl library (www.openssl.org) to provide a
                       built-in encrypted SSL/TLS tunnel between VNC viewers
                       and x11vnc.  This requires libssl support to be
                       compiled into x11vnc at build time.  If x11vnc is not
                       built with libssl support it will exit immediately when
                       -ssl is prescribed.  See the -stunnel option below for
                       an alternative.

                       The VNC Viewer-side needs to support SSL/TLS as well.
                       See this URL and also the discussion below for
                       ideas on how to enable SSL support for the viewer:
                       http://www.karlrunge.com/x11vnc/faq.html#faq-ssl-tun
                       nel-viewers .  x11vnc provides an SSL enabled Java
                       viewer applet in the classes/ssl directory (-http or
                       -httpdir options.)  The SSVNC viewer package supports
                       SSL tunnels too.

                       If the VNC Viewer supports VeNCrypt or ANONTLS (vino's
                       encryption mode) they are also supported by the -ssl
                       mode (see the -vencrypt and -anontls options for more
                       info; use -sslonly to disable both of them.)

                       Use "-ssl /path/to/mycert.pem" to specify an SSL
                       certificate file in PEM format to use to identify and
                       provide a key for this server.  See openssl(1) for more
                       info about PEMs and the -sslGenCert and "-ssl SAVE"
                       options below for how to create them.

                       The connecting VNC viewer SSL tunnel can (at its option)
                       authenticate this server if it has the public key part
                       of the certificate (or a common certificate authority,
                       CA, is a more sophisticated way to verify this server's
                       cert, see -sslGenCA below).  This authentication is
                       done to prevent Man-In-The-Middle attacks.  Otherwise,
                       if the VNC viewer simply accepts this server's key
                       WITHOUT verification, the traffic is protected from
                       passive sniffing on the network, but *NOT* from
                       Man-In-The-Middle attacks. There are hacker tools
                       like dsniff/webmitm and cain that implement SSL
                       Man-In-The-Middle attacks.

                       If [pem] is empty or the string "SAVE" then the
                       openssl(1) command must be available to generate the
                       certificate the first time.  A self-signed certificate
                       is generated (see -sslGenCA and -sslGenCert for use
                       of a Certificate Authority.)  It will be saved to the
                       file ~/.vnc/certs/server.pem.  On subsequent calls if
                       that file already exists it will be used directly.

                       Use "SAVE_NOPROMPT" to avoid being prompted to
                       protect the generated key with a passphrase.  However in
                       -inetd and -bg modes there will be no prompting for a
                       passphrase in either case.

                       If [pem] is "SAVE_PROMPT" the server.pem certificate
                       will be created based on your answers to its prompts for
                       all info such as OrganizationalName, CommonName, etc.

                       Use "SAVE-<string>" and "SAVE_PROMPT-<string>"
                       to refer to the file ~/.vnc/certs/server-<string>.pem
                       instead (it will be generated if it does not already
                       exist).  E.g. "SAVE-charlie" will store to the file
                       ~/.vnc/certs/server-charlie.pem

                       Examples: x11vnc -ssl SAVE -display :0 ...
                                 x11vnc -ssl SAVE-someother -display :0 ...

                       If [pem] is "TMP" and the openssl(1) utility
                       command exists in PATH, then a temporary, self-signed
                       certificate will be generated for this session.  If
                       openssl(1) cannot be used to generate a temporary
                       certificate x11vnc exits immediately.  The temporary
                       cert will be discarded when x11vnc exits.

                       If successful in using openssl(1) to generate a
                       temporary certificate in "SAVE" or "TMP" creation
                       modes, the public part of it will be displayed to stderr
                       (e.g. one could copy it to the client-side to provide
                       authentication of the server to VNC viewers.)

                       NOTE: In "TMP" mode, unless you safely copy the
                       public part of the temporary Cert to the viewer for
                       authenticate *every time* (unlikely...), then only
                       passive sniffing attacks are prevented and you are
                       still open to Man-In-The-Middle attacks.  This is
                       why the default "SAVE" mode is preferred (and more
                       sophisticated CA mode too).  Only with saved keys AND
                       the VNC viewer authenticating them (via the public
                       certificate), are Man-In-The-Middle attacks prevented.

                       If [pem] is "ANON" then the Diffie-Hellman anonymous
                       key exchange method is used.  In this mode there
                       are *no* SSL certificates and so it is not possible
                       to authenticate either the VNC server or VNC client.
                       Thus only passive network sniffing attacks are avoided:
                       the "ANON" method is susceptible to Man-In-The-Middle
                       attacks.  "ANON" is not recommended; instead use
                       a SSL PEM you created or the default "SAVE" method.

                       See -ssldir below to use a directory besides the
                       default ~/.vnc/certs

                       If your x11vnc binary was not compiled with OpenSSL
                       library support, use of the -ssl option will induce an
                       immediate failure and exit.  For such binaries, consider
                       using the -stunnel option for SSL encrypted connections.

                       Misc Info: In temporary cert creation mode "TMP", set
                       the env. var. X11VNC_SHOW_TMP_PEM=1 to have x11vnc print
                       out the entire certificate, including the PRIVATE KEY
                       part, to stderr.  There are better ways to get/save this
                       info.  See "SAVE" above and "-sslGenCert" below.

-ssltimeout n          Set SSL read timeout to n seconds.  In some situations
                       (i.e. an iconified viewer in Windows) the viewer stops
                       talking and the connection is dropped after the default
                       timeout (25s for about the first minute, 43200s later).
                       Set to zero to poll forever.  Set to a negative value
                       to use the builtin setting.

                       Note that this value does NOT apply to the *initial* ssl
                       init connection.  The default timeout for that is 20sec.
                       Use -env SSL_INIT_TIMEOUT=n to modify it.

-sslnofail             Exit at the first SSL connection failure. Useful when
                       scripting SSL connections (e.g. x11vnc is started via
                       ssh) and you do not want x11vnc waiting around for more
                       connections, tying up ports, etc.

-ssldir dir            Use "dir" as an alternate ssl certificate and key
                       management toplevel directory.  The default is
                       ~/.vnc/certs

                       This directory is used to store server and other
                       certificates and keys and also other materials.  E.g. in
                       the simplest case, "-ssl SAVE" will store the x11vnc
                       server cert in dir/server.pem

                       Use of alternate directories via -ssldir allows you to
                       manage multiple VNC Certificate Authority (CA) keys.
                       Another use is if ~/.vnc/cert is on an NFS share you
                       might want your certificates and keys to be on a local
                       filesystem to prevent network snooping (for example
                       -ssldir /var/lib/x11vnc-certs).

                       -ssldir affects nearly all of the other -ssl* options,
                       e.g. -ssl SAVE, -sslGenCert, etc..

-sslverify path        For either of the -ssl or -stunnel modes, use "path"
                       to provide certificates to authenticate incoming VNC
                       *Client* connections (normally only the server is
                       authenticated in SSL.)  This can be used as a method
                       to replace standard password authentication of clients.

                       If "path" is a directory it contains the client (or CA)
                       certificates in separate files.  If path is a file,
                       it contains one or more certificates. See special tokens
                       below.  These correspond to the "CApath = dir" and
                       "CAfile = file" stunnel options.  See the stunnel(8)
                       manpage for details.

                       Examples:
                              x11vnc -ssl -sslverify ~/my.crt
                              x11vnc -ssl -sslverify ~/my_pem_dir/

                       Note that if path is a directory, it must contain
                       the certs in separate files named like <HASH>.0, where
                       the value of <HASH> is found by running the command
                       "openssl x509 -hash -noout -in file.crt". Evidently
                       one uses <HASH>.1 if there is a collision...

                       The the key-management utility "-sslCertInfo HASHON"
                       and "-sslCertInfo HASHOFF" will create/delete these
                       hashes for you automatically (via symlink) in the HASH
                       subdirs it manages.  Then you can point -sslverify to
                       the HASH subdir.

                       Special tokens: in -ssl mode, if "path" is not a file or
                       a directory, it is taken as a comma separated list of
                       tokens that are interpreted as follows:

                       If a token is "CA" that means load the CA/cacert.pem
                       file from the ssl directory.  If a token is "clients"
                       then all the files clients/*.crt in the ssl directory
                       are loaded.  Otherwise the file clients/token.crt
                       is attempted to be loaded.  As a kludge, use a token
                       like ../server-foo to load a server cert if you find
                       that necessary.

                       Use -ssldir to use a directory different from the
                       ~/.vnc/certs default.

                       Note that if the "CA" cert is loaded you do not need
                       to load any of the certs that have been signed by it.
                       You will need to load any additional self-signed certs
                       however.

                       Examples:
                              x11vnc -ssl -sslverify CA
                              x11vnc -ssl -sslverify self:fred,self:jim
                              x11vnc -ssl -sslverify CA,clients

                       Usually "-sslverify CA" is the most effective.
                       See the -sslGenCA and -sslGenCert options below for
                       how to set up and manage the CA framework.



                       NOTE: the following utilities, -sslGenCA, -sslGenCert,
                       -sslEncKey, -sslCertInfo, and -sslCRL are provided for
                       completeness, but for casual usage they are overkill.

                       They provide VNC Certificate Authority (CA) key creation
                       and server / client key generation and signing.  So they
                       provide a basic Public Key management framework for
                       VNC-ing with x11vnc. (note that they require openssl(1)
                       be installed on the system)

                       However, the simplest usage mode, "-ssl TMP" (where
                       x11vnc automatically generates its own, self-signed,
                       temporary key and the VNC viewers always accept it,
                       e.g. accepting via a dialog box) is probably safe enough
                       for most scenarios.  CA management is not needed.

                       To protect against Man-In-The-Middle attacks the "TMP"
                       mode can be improved by using "-ssl SAVE" (same as
                       "-ssl", i.e. the default) to have x11vnc create a
                       longer term self-signed certificate, and then (safely)
                       copy the corresponding public key cert to the desired
                       client machines (care must be taken the private key part
                       is not stolen; you will be prompted for a passphrase).

                       So keep in mind no CA key creation or management
                       (-sslGenCA and -sslGenCert) is needed for either of
                       the above two common usage modes.

                       One might want to use -sslGenCA and -sslGenCert
                       if you had a large number of VNC client and server
                       workstations.  That way the administrator could generate
                       a single CA key with -sslGenCA and distribute its
                       certificate part to all of the workstations.

                       Next, he could create signed VNC server keys
                       (-sslGenCert server ...) for each workstation or user
                       that then x11vnc would use to authenticate itself to
                       any VNC client that has the CA cert.

                       Optionally, the admin could also make it so the
                       VNC clients themselves are authenticated to x11vnc
                       (-sslGenCert client ...)  For this -sslverify would be
                       pointed to the CA cert (and/or self-signed certs).

                       x11vnc will be able to use all of these cert and
                       key files.  On the VNC client side, they will need to
                       be "imported" somehow.  Web browsers have "Manage
                       Certificates" actions as does the Java applet plugin
                       Control Panel.  stunnel can also use these files (see
                       the ss_vncviewer example script in the FAQ and SSVNC.)

-sslCRL path           Set the Certificate Revocation Lists (CRL) to "path".
                       This setting applies for both -ssl and -stunnel modes.

                       If path is a file, the file contains one or more CRLs
                       in PEM format.  If path is a directory, it contains
                       hash named files of CRLs in the usual OpenSSL manner.
                       See the OpenSSL and stunnel(8) documentation for
                       more info.

                       This option only applies if -sslverify has been
                       supplied: it checks for revocation along the
                       certificate chain used to verify the VNC client.
                       The -sslCRL setting will be ignored when -sslverify is
                       not specified.

                       Note that if a CRL's expiration date has passed, all
                       SSL connections will fail regardless of if they are
                       related to the subject of the CRL or not.

                       Only rarely will one's x11vnc -ssl infrastructure be so
                       large that this option would be useful (since normally
                       maintaining the contents of the -sslverify file or
                       directory should be enough.)  However, when using
                       x11vnc with a Certificate Authority (see -sslGenCA)
                       to authenticate Clients via SSL/TLS, the -sslCRL option
                       can be useful to revoke users' certs whose private SSL
                       keys were lost or stolen (e.g. laptop.)  This way a new
                       CA cert+key does not need to be created and new signed
                       client keys generated and distributed to all users.

                       To create a CRL file with revoked certificates the
                       commands 'openssl ca -revoke ...' and 'openssl ca
                       -gencrl ...' are useful.  (Run them in ~/.vnc/certs)

-sslGenCA [dir]        Generate your own Certificate Authority private key,
                       certificate, and other files in directory [dir].
                       x11vnc then exits.

                       If [dir] is not supplied, a -ssldir setting is used,
                       or otherwise ~/.vnc/certs is used.

                       This command also creates directories where server and
                       client certs and keys will be stored.  The openssl(1)
                       program must be installed on the system and available
                       in PATH.

                       After the CA files and directories are created the
                       x11vnc command exits; the VNC server is not run.

                       You will be prompted for information to put into the CA
                       certificate.  The info does not have to be accurate just
                       as long as clients accept the cert for VNC connections.
                       You will also need to supply a passphrase of at least
                       4 characters for the CA private key.

                       Once you have generated the CA you can distribute
                       its certificate part, [dir]/CA/cacert.pem, to other
                       workstations where VNC viewers will be run.  One will
                       need to "import" this certificate in the applications,
                       e.g. Web browser, Java applet plugin, stunnel, etc.
                       Next, you can create and sign keys using the CA with
                       the -sslGenCert option below.

                       Examples:
                                x11vnc -sslGenCA
                                x11vnc -sslGenCA  ~/myCAdir
                                x11vnc -ssldir ~/myCAdir -sslGenCA

                       (the last two lines are equivalent)

-sslGenCert type name  Generate a VNC server or client certificate and private
                       key pair signed by the CA created previously with
                       -sslGenCA.  The openssl(1) program must be installed
                       on the system and available in PATH.

                       After the Certificate is generated x11vnc exits; the
                       VNC server is not run.

                       The type of key to be generated is the string "type".
                       It is either "server" (i.e. for use by x11vnc) or
                       "client" (for a VNC viewer).  Note that typically
                       only "server" is used: the VNC clients authenticate
                       themselves by a non-public-key method (e.g. VNC or
                       unix password).  "type" is required.

                       An arbitrary default name you want to associate with
                       the key is supplied by the "name" string.  You can
                       change it at the various prompts when creating the key.
                       "name" is optional.

                       If name is left blank for clients keys then "nobody"
                       is used.  If left blank for server keys, then the
                       primary server key: "server.pem" is created (this
                       is the saved one referenced by "-ssl SAVE" when the
                       server is started)

                       If "name" begins with the string "self:" then
                       a self-signed certificate is created instead of one
                       signed by your CA key.

                       If "name" begins with the string "req:" then only a
                       key (.key) and a certificate signing *request* (.req)
                       are generated.  You can then send the .req file to
                       an external CA (even a professional one, e.g. Thawte)
                       and then combine the .key and the received cert into
                       the .pem file with the same basename.

                       The distinction between "server" and "client" is
                       simply the choice of output filenames and sub-directory.
                       This makes it so the -ssl SAVE-name option can easily
                       pick up the x11vnc PEM file this option generates.
                       And similarly makes it easy for the -sslverify option
                       to pick up your client certs.

                       There is nothing special about the filename or directory
                       location of either the "server" and "client" certs.
                       You can rename the files or move them to wherever
                       you like.

                       Precede this option with -ssldir [dir] to use a
                       directory other than the default ~/.vnc/certs You will
                       need to run -sslGenCA on that directory first before
                       doing any -sslGenCert key creation.

                       Note you cannot recreate a cert with exactly the same
                       distiguished name (DN) as an existing one.  To do so,
                       you will need to edit the [dir]/CA/index.txt file to
                       delete the line.

                       Similar to -sslGenCA, you will be prompted to fill
                       in some information that will be recorded in the
                       certificate when it is created.

                       Tip: if you know the fully-qualified hostname other
                       people will be connecting to, you can use that as the
                       CommonName "CN" to avoid some applications (e.g. web
                       browsers and java plugin) complaining that it does not
                       match the hostname.

                       You will also need to supply the CA private key
                       passphrase to unlock the private key created from
                       -sslGenCA.  This private key is used to sign the server
                       or client certificate.

                       The "server" certs can be used by x11vnc directly by
                       pointing to them via the -ssl [pem] option.  The default
                       file will be ~/.vnc/certs/server.pem.  This one would
                       be used by simply typing -ssl SAVE.  The pem file
                       contains both the certificate and the private key.
                       server.crt file contains the cert only.

                       The "client" cert + private key file will need
                       to be copied and imported into the VNC viewer
                       side applications (Web browser, Java plugin,
                       stunnel, etc.)  Once that is done you can delete the
                       "client" private key file on this machine since
                       it is only needed on the VNC viewer side.  The,
                       e.g. ~/.vnc/certs/clients/<name>.pem contains both
                       the cert and private key.  The <name>.crt contains the
                       certificate only.

                       NOTE: It is very important to know one should
                       generate new keys with a passphrase.  Otherwise if an
                       untrusted user steals the key file he could use it to
                       masquerade as the x11vnc server (or VNC viewer client).
                       You will be prompted whether to encrypt the key with
                       a passphrase or not.  It is recommended that you do.
                       One inconvenience to a passphrase is that it must
                       be typed in EVERY time x11vnc or the client app is
                       started up.

                       Examples:

                               x11vnc -sslGenCert server
                               x11vnc -ssl SAVE -display :0 ...

                       and then on viewer using ss_vncviewer stunnel wrapper
                       (see the FAQ):
                               ss_vncviewer -verify ./cacert.crt hostname:0

                       (this assumes the cacert.crt cert from -sslGenCA
                       was safely copied to the VNC viewer machine where
                       ss_vncviewer is run)

                       Example using a name:

                               x11vnc -sslGenCert server charlie
                               x11vnc -ssl SAVE-charlie -display :0 ...

                       Example for a client certificate (rarely used):

                               x11vnc -sslGenCert client roger
                               scp ~/.vnc/certs/clients/roger.pem somehost:.
                               rm  ~/.vnc/certs/clients/roger.pem

                       x11vnc is then started with the option -sslverify
                       ~/.vnc/certs/clients/roger.crt (or simply -sslverify
                       roger), and on the viewer user on somehost could do
                       for example:

                               ss_vncviewer -mycert ./roger.pem hostname:0

                       If you set the env. var REQ_ARGS='...' it will be
                       passed to openssl req(1).  A common use would be
                       REQ_ARGS='-days 1095' to bump up the expiration date
                       (3 years in this case).

-sslEncKey pem         Utility to encrypt an existing PEM file with a
                       passphrase you supply when prompted.  For that key to be
                       used (e.g. by x11vnc) the passphrase must be supplied
                       each time.

                       The "SAVE" notation described under -ssl applies as
                       well. (precede this option with -ssldir [dir] to refer
                       a directory besides the default ~/.vnc/certs)

                       The openssl(1) program must be installed on the system
                       and available in PATH.  After the Key file is encrypted
                       the x11vnc command exits; the VNC server is not run.

                       Examples:
                               x11vnc -sslEncKey /path/to/foo.pem
                               x11vnc -sslEncKey SAVE
                               x11vnc -sslEncKey SAVE-charlie

-sslCertInfo pem       Prints out information about an existing PEM file.
                       In addition the public certificate is also printed.
                       The openssl(1) program must be in PATH. Basically the
                       command "openssl x509 -text" is run on the pem.

                       After the info is printed the x11vnc command exits;
                       the VNC server is not run.

                       The "SAVE" notation described under -ssl applies
                       as well.

                       Using  "LIST" will give a list of all certs being
                       managed (in the ~/.vnc/certs dir, use -ssldir to refer
                       to another dir).  "ALL" will print out the info for
                       every managed key (this can be very long).  Giving a
                       client or server cert shortname will also try a lookup
                       (e.g. -sslCertInfo charlie).  Use "LISTL" or "LL"
                       for a long (ls -l style) listing.

                       Using "HASHON" will create subdirs [dir]/HASH and
                       [dir]/HASH with OpenSSL hash filenames (e.g. 0d5fbbf1.0)
                       symlinks pointing up to the corresponding *.crt file.
                       ([dir] is ~/.vnc/certs or one given by -ssldir.)
                       This is a useful way for other OpenSSL applications
                       (e.g. stunnel) to access all of the certs without
                       having to concatenate them.  x11vnc will not use them
                       unless you specifically reference them.  "HASHOFF"
                       removes these HASH subdirs.

                       The LIST, LISTL, LL, ALL, HASHON, HASHOFF words can
                       also be lowercase, e.g. "list".

-sslDelCert pem        Prompts you to delete all .crt .pem .key .req files
                       associated with [pem].  x11vnc then exits. "SAVE"
                       and lookups as in -sslCertInfo apply as well.

-sslScripts            Prints out both the 'genCA' and 'genCert' x11vnc
                       openssl wrapper scripts for you to examine, modify, etc.
                       The scripts are printed to stdout and then the x11vnc
                       program exits.


-stunnel [pem]         Use the stunnel(8) (stunnel.mirt.net) to provide an
                       encrypted SSL tunnel between viewers and x11vnc.

                       This external tunnel method was implemented prior to the
                       integrated -ssl encryption described above.  It still
                       works well and avoids the requirement of linking with
                       the OpenSSL libraries.  This mode requires stunnel
                       to be installed on the system and available via PATH
                       (n.b. stunnel is often installed in sbin directories).
                       Version 4.x of stunnel is assumed (but see -stunnel3
                       below.)

                       [pem] is optional, use "-stunnel /path/to/stunnel.pem"
                       to specify a PEM certificate file to pass to stunnel.
                       See the -ssl option for more info on certificate files.

                       Whether or not your stunnel has its own certificate
                       depends on your stunnel configuration; stunnel often
                       generates one at install time.  See your stunnel
                       documentation for details.  In any event, if you want to
                       use this certificate you must supply the full path to it
                       as [pem].  Note: the file may only be readable by root.

                       [pem] may also be the special strings "TMP", "SAVE",
                       and "SAVE..." as described in the -ssl option.
                       If [pem] is not supplied, "SAVE" is assumed.

                       Note that the VeNCrypt, ANONTLS, and "ANON" modes
                       are not supported in -stunnel mode.

                       stunnel is started up as a child process of x11vnc and
                       any SSL connections stunnel receives are decrypted and
                       sent to x11vnc over a local socket.  The strings
                       "The SSL VNC desktop is ..." and "SSLPORT=..."
                       are printed out at startup to indicate this.

                       The -localhost option is enforced by default to avoid
                       people routing around the SSL channel.  Use -env
                       STUNNEL_DISABLE_LOCALHOST=1 to disable this security
                       requirement.

                       Set -env STUNNEL_DEBUG=1 for more debugging printout.

                       Set -env STUNNEL_PROG=xxx to the full path of stunnel
                       program you want to be used (e.g. /usr/bin/stunnel4).

                       Set -env STUNNEL_LISTEN=xxx to the address of the
                       network interface to listen on (the default is to listen
                       on all interfaces), e.g. STUNNEL_LISTEN=192.168.1.100.

                       A simple way to add IPv6 support is STUNNEL_LISTEN=::

                       Your VNC viewer will also need to be able to connect
                       via SSL.  Unfortunately not too many do this.  See the
                       information about SSL viewers under the -ssl option.
                       The x11vnc project's SSVNC is an option.

                       Also, in the x11vnc distribution, patched TightVNC
                       and UltraVNC Java applet jar files are provided in
                       the classes/ssl directory that do SSL connections.
                       Enable serving them with the -http, -http_ssl, or
                       -httpdir (see the option descriptions for more info.)

                       Note that for the Java viewer applet usage the
                       "?PORT=xxxx" in the various URLs printed at startup
                       will need to be supplied to the web browser to connect
                       properly.

                       Currently the automatic "single port" HTTPS mode of
                       -ssl is not fully supported in -stunnel mode.  However,
                       it can be emulated via:

                         % x11vnc -stunnel -http_ssl -http_oneport ...

                       In general, it is also not too difficult to set up
                       an stunnel or other SSL tunnel on the viewer side.
                       A simple example on Unix using stunnel 3.x is:

                         % stunnel -c -d localhost:5901 -r remotehost:5900
                         % vncviewer localhost:1

                       For Windows, stunnel has been ported to it and there
                       are probably other such tools available.  See the FAQ
                       and SSVNC for more examples.

-stunnel3  [pem]       Use version 3.x stunnel command line syntax instead of
                       version 4.x.  The -http/-httpdir Java applet serving
                       is currently not available in this mode.

-enc cipher:keyfile    Use symmetric encryption with cipher "cipher"
                       and secret key data in "keyfile".  If keyfile is
                       pw=<string> then "string" is used as the key data.

                       NOTE: It is recommended that you use SSL via the -ssl
                       option instead of this option because SSL is well
                       understood and takes great care to establish unique
                       session keys and is more compatible with other software.
                       Use this option if you do not want to deal with SSL
                       certificates for authentication and do not want to
                       use SSH but want some encryption for your VNC session.
                       Or if you must interface with a symmetric key tunnel
                       that you do not have control over.

                       Note that this mode will NOT work with the UltraVNC DSM
                       plugins because they alter the RFB protocol in addition
                       to tunnelling with the symmetric cipher (an unfortunate
                       choice of implementation...)

                       cipher can be one of:  arc4, aesv2, aes-cfb, blowfish,
                       aes256, or 3des.  See the OpenSSL documentation for
                       more info.  The keysize is 128 bits (except for aes256).
                       Here is one way to make a keyfile with that many bits:

                            dd if=/dev/random of=./my.key bs=16 count=1

                       you will need to securely share this key with the other
                       side of the VNC connection (See SSVNC for examples).

                       Example:  -enc blowfish:./my.key
                       Example:  -enc blowfish:pw=swordfish

                       By default 16 bytes of random salt followed by 16 bytes
                       of random initialization vector are sent at the very
                       beginning of the stream.  The other side must read these
                       and initialize their cipher with them.  These values
                       make the session key unique (without them the security
                       is minimal).  Similarly, the other side must send us
                       its random salt and IV with those same lengths.

                       The salt and key data are combined to create a session
                       key using an md5 hash as described in EVP_BytesToKey(3).

                       The exact call is: EVP_BytesToKey(Cipher, EVP_md5(),
                       salt, keydata, len, 1, keystr, NULL);  where salt is
                       the random data as described above, and keydata is the
                       shared secret key data.  keystr is the resulting session
                       key.  The cipher is then seeded with keystr and uses
                       the random initialization vector as its first block.

                       To modify the amount of random salt and initialization
                       vector use cipher@n,m where n is the salt length and
                       m the initialization vector length.  E.g.

                                 -enc aes-cfb@8,16:./my.key

                       It is not a good idea to set either one to zero,
                       although you may be forced to if the other side of the
                       tunnel is not under your control.

                       To skip the salt and EVP_BytesToKey MD5 entirely (no
                       hashing is done: the keydata is directly inserted into
                       the cipher) specify "-1" for the salt, e.g.

                                 -enc blowfish@-1,16:./my.key

                       The message digest can also be changed to something
                       besides the default MD5.  Use cipher@md+n,m where "md"
                       can be one of sha, sha1, md5, or ripe.  For example:

                                 -enc arc4@sha+8,16:./my.key

                       The SSVNC vnc viewer project supplies a symmetric
                       encryption tool named "ultravnc_dsm_helper" that can
                       be used on the viewer side.  For example:

                       ssvncviewer exec='ultravnc_dsm_helper arc4 my.key 0 h:p'

                       where h:p is the hostname and port of the x11vnc server.
                       ultravnc_dsm_helper may also be used standalone to
                       provide a symmetric encryption tunnel for any viewer
                       or server (VNC or otherwise.) The cipher (1st arg)
                       is basically the same syntax as we use above.

                       Also see the 'Non-Ultra DSM' SSVNC option for the
                       'UltraVNC DSM Encryption Plugin' advanced option.

                       For both ways of using the viewer, you can specify the
                       salt,ivec sizes (in GUI or, e.g. arc4@8,16).

-https [port]          Use a special, separate HTTPS port (-ssl and
                       -stunnel modes only) for HTTPS Java viewer applet
                       downloading. I.e. not 5900 and not 5800 (the defaults.)

                       BACKGROUND: In -ssl mode, it turns out you can use the
                       single VNC port (e.g. 5900) for both VNC and HTTPS
                       connections. (HTTPS is used to retrieve a SSL-aware
                       VncViewer.jar applet that is provided with x11vnc).
                       Since both use SSL the implementation was extended to
                       detect if HTTP traffic (i.e. GET) is taking place and
                       handle it accordingly.  The URL would be, e.g.:

                       https://mymachine.org:5900/

                       This is convenient for firewalls, etc, because only one
                       port needs to be allowed in.  However, this heuristic
                       adds a few seconds delay to each connection and can be
                       unreliable (especially if the user takes much time to
                       ponder the Certificate dialogs in his browser, Java VM,
                       or VNC Viewer applet.  That's right 3 separate "Are
                       you sure you want to connect?" dialogs!)

                       END OF BACKGROUND.

                       USAGE: So use the -https option to provide a separate,
                       more reliable HTTPS port that x11vnc will listen on.  If
                       [port] is not provided (or is 0), one is autoselected.
                       The URL to use is printed out at startup.

                       The SSL Java applet directory is specified via the
                       -httpdir option.  If not supplied, -https will try
                       to guess the directory as though the -http option
                       was supplied.

-httpsredir [port]     In -ssl mode with the Java applet retrieved via HTTPS,
                       when the HTML file containing applet parameters
                       ('index.vnc' or 'proxy.vnc') is sent do NOT set the
                       applet PORT parameter to the actual VNC port but set it
                       to "port" instead.  If "port" is not supplied, then
                       the port number is guessed from the Host: HTTP header.

                       This is useful when an incoming TCP connection
                       redirection is performed by a router/gateway/firewall
                       from one port to an internal machine where x11vnc is
                       listening on a different port. The Java applet needs to
                       connect to the firewall/router port, not the VNC port
                       on the internal workstation. For example, one could
                       redir from mygateway.com:443 to workstation:5900.

                       This spares the user from having to type in
                       https://mygateway.com/?PORT=443 into their web
                       browser. Note that port 443 is the default https port;
                       other ports must be explicitly indicated, for example:
                       https://mygateway.com:8000/?PORT=8000.  To avoid having
                       to include the PORT= in the browser URL, simply supply
                       "-httpsredir" to x11vnc.

                       This option does not work in -stunnel mode.

                       More tricks: set the env var X11VNC_EXTRA_HTTPS_PARAMS
                       to be extra URL parameters to use.  This way you do
                       not need to specify extra PARAMS in the index.vnc file.
                       E.g. x11vnc -env X11VNC_EXTRA_HTTPS_PARAMS='?GET=1' ...

                       If you do not want to expose the non-SSL HTTP port to
                       the network (i.e. you just want the single VNC/HTTPS
                       port, e.g. 5900, open for connections) then specify the
                       option -env X11VNC_HTTP_LISTEN_LOCALHOST=1  This way
                       the connection to the LibVNCServer httpd server will
                       only be available on localhost (note that in -ssl mode,
                       HTTPS requests are redirected from SSL to the non-SSL
                       LibVNCServer HTTP server.)

-http_oneport          For UN-encrypted connections mode (i.e. no -ssl,
                       -stunnel, or -enc options), allow the Java VNC Viewer
                       applet to be downloaded thru the VNC port via HTTP.

                       That is to say, you can use a single port for Java
                       applet viewer connections by using a URL in your web
                       browser like this, for example:

                       http://hostname:5900

                       The regular, two-port mode, URL http://hostname:5800
                       will continue to work as well.

                       As mentioned above, this mode will NOT work with
                       the -ssl, -stunnel, or -enc encryption options.
                       Note that is it equivalent to '-enc none' (i.e. it
                       uses the same detection mechanism as for HTTPS, but
                       with no encryption.)

                       HTTPS single-port is on by default in -ssl encrypted
                       mode (and -enc too), so you only need -http_oneport
                       when doing non-SSL encrypted connections.

                       This mode could also be useful for SSH tunnels since
                       it means only one port needs to be redirected.

                       The -httpsredir option may also be useful for this
                       mode when using an SSH tunnel as well as for router
                       port redirections.

                       Note that the -env X11VNC_HTTP_LISTEN_LOCALHOST=1
                       option described above under -httpsredir applies for
                       the LibVNCServer httpd server in all cases (ssl or not.)

-ssh user@host:disp    Create a remote listening port on machine "host"
                       via a SSH tunnel using the -R rport:localhost:lport
                       method. lport will be the local x11vnc listening port,
                       so a connection to rport (5900+disp) on "host"
                       will reach x11vnc.  E.g. fred@snoopy.com:0

                       This could be useful if a firewall/router prevents
                       incoming connections to the x11vnc machine, but
                       the ssh machine "host" can be reached by the VNC
                       viewer. "user@" is not needed unless the remote unix
                       username differs from the current one.

                       By default the remote sshd is usually configured to
                       listen only on localhost for rport, so the viewer may
                       need to ssh -L redir to "host" as well (See SSVNC to
                       automate this).  The sshd setting GatewayPorts enables
                       listening on all interfaces for rport; viewers can
                       reach it more easily.

                       "disp" is the VNC display for the remote SSH side,
                       e.g. 0 corresponds to port 5900, etc.  If disp is
                       greater than 200 the value is used as the port.  Use a
                       negative value to force a low port, e.g. host:-80 will
                       use port 80.

                       If ssh-agent is not active, then the ssh password needs
                       to be entered in the terminal where x11vnc is running.

                       By default the remote ssh will issue a 'sleep 300' to
                       wait for the incoming connection for 5 mins.  To modify
                       this use user@host:disp+secs.

                       If the remote SSH server is on a non-standard port
                       (i.e. not 22) use user@host:port:disp+secs.

                       Note that the ssh process MAY NOT be killed when
                       x11vnc exits.  It tries by looking at ps(1) output.

-usepw                 If no other password method was supplied on the command
                       line, first look for ~/.vnc/passwd and if found use it
                       with -rfbauth; next, look for ~/.vnc/passwdfile and
                       use it with -passwdfile; otherwise, prompt the user
                       for a password to create ~/.vnc/passwd and use it with
                       the -rfbauth option.  If none of these succeed x11vnc
                       exits immediately.

-storepasswd pass file Store password "pass" as the VNC password in the
                       file "file".  Once the password is stored the
                       program exits.  Use the password via "-rfbauth file"

                       If called with no arguments, "x11vnc -storepasswd",
                       the user is prompted for a password and it is stored
                       in the file ~/.vnc/passwd.  Called with one argument,
                       that will be the file to store the prompted password in.

-nopw                  Disable the big warning message when you use x11vnc
                       without some sort of password.

-accept string         Run a command (possibly to prompt the user at the
                       X11 display) to decide whether an incoming client
                       should be allowed to connect or not.  "string" is
                       an external command run via system(3) or some special
                       cases described below.  Be sure to quote "string"
                       if it contains spaces, shell characters, etc.  If the
                       external command returns 0 the client is accepted,
                       otherwise the client is rejected.  See below for an
                       extension to accept a client view-only.

                       If x11vnc is running as root (say from inetd(8) or from
                       display managers xdm(1), gdm(1), etc), think about the
                       security implications carefully before supplying this
                       option (likewise for the -gone option).

                       Environment: The RFB_CLIENT_IP environment variable will
                       be set to the incoming client IP number and the port
                       in RFB_CLIENT_PORT (or -1 if unavailable).  Similarly,
                       RFB_SERVER_IP and RFB_SERVER_PORT (the x11vnc side
                       of the connection), are set to allow identification
                       of the tcp virtual circuit.  The x11vnc process
                       id will be in RFB_X11VNC_PID, a client id number in
                       RFB_CLIENT_ID, and the number of other connected clients
                       in RFB_CLIENT_COUNT.  RFB_MODE will be "accept".
                       RFB_STATE will be PROTOCOL_VERSION, SECURITY_TYPE,
                       AUTHENTICATION, INITIALISATION, NORMAL, or UNKNOWN
                       indicating up to which state the client has achieved.
                       RFB_LOGIN_VIEWONLY will be 0, 1, or -1 (unknown).
                       RFB_USERNAME, RFB_LOGIN_TIME, and RFB_CURRENT_TIME may
                       also be set.

                       If "string" is "popup" then a builtin popup window
                       is used.  The popup will time out after 120 seconds,
                       use "popup:N" to modify the timeout to N seconds
                       (use 0 for no timeout).

                       In the case of "popup" and when the -unixpw option
                       is specified, then a *second* window will be popped
                       up after the user successfully logs in via his UNIX
                       password.  This time the user will be identified as
                       UNIX:username@hostname, the "UNIX:" prefix indicates
                       which user the viewer logged as via -unixpw.  The first
                       popup is only for whether to allow him to even *try*
                       to login via unix password.

                       If "string" is "xmessage" then an xmessage(1)
                       invocation is used for the command.  xmessage must be
                       installed on the machine for this to work.

                       Both "popup" and "xmessage" will present an option
                       for accepting the client "View-Only" (the client
                       can only watch).  This option will not be presented if
                       -viewonly has been specified, in which case the entire
                       display is view only.

                       If the user supplied command is prefixed with something
                       like "yes:0,no:*,view:3 mycommand ..." then this
                       associates the numerical command return code with
                       the actions: accept, reject, and accept-view-only,
                       respectively.  Use "*" instead of a number to indicate
                       the default action (in case the command returns an
                       unexpected value).  E.g. "no:*" is a good choice.

                       Note that x11vnc blocks while the external command
                       or popup is running (other clients may see no updates
                       during this period).  So a person sitting a the physical
                       display is needed to respond to an popup prompt. (use
                       a 2nd x11vnc if you lock yourself out).

                       More -accept tricks: use "popupmouse" to only allow
                       mouse clicks in the builtin popup to be recognized.
                       Similarly use "popupkey" to only recognize
                       keystroke responses.  These are to help avoid the
                       user accidentally accepting a client by typing or
                       clicking. All 3 of the popup keywords can be followed
                       by +N+M to supply a position for the popup window.
                       The default is to center the popup window.
-afteraccept string    As -accept, except to run a user supplied command after
                       a client has been accepted and authenticated. RFB_MODE
                       will be set to "afteraccept" and the other RFB_*
                       variables are as in -accept.  Unlike -accept, the
                       command return code is not interpreted by x11vnc.
                       Example: -afteraccept 'killall xlock &'
-gone string           As -accept, except to run a user supplied command when
                       a client goes away (disconnects).  RFB_MODE will be
                       set to "gone" and the other RFB_* variables are as
                       in -accept.  The "popup" actions apply as well.
                       Unlike -accept, the command return code is not
                       interpreted by x11vnc.  Example: -gone 'xlock &'

-users list            If x11vnc is started as root (say from inetd(8) or from
                       display managers xdm(1), gdm(1), etc), then as soon
                       as possible after connections to the X display are
                       established try to switch to one of the users in the
                       comma separated "list".  If x11vnc is not running as
                       root this option is ignored.

                       Why use this option?  In general it is not needed since
                       x11vnc is already connected to the X display and can
                       perform its primary functions.  The option was added
                       to make some of the *external* utility commands x11vnc
                       occasionally runs work properly.  In particular under
                       GNOME and KDE to implement the "-solid color" feature
                       external commands (gconftool-2 and dcop) unfortunately
                       must be run as the user owning the desktop session.
                       Since this option switches userid it also affects the
                       userid used to run the processes for the -accept and
                       -gone options.  It also affects the ability to read
                       files for options such as -connect, -allow, and -remap
                       and also the ultra and tight filetransfer feature if
                       enabled.  Note that the -connect file is also sometimes
                       written to.

                       So be careful with this option since in some situations
                       its use can decrease security.

                       In general the switch to a user will only take place
                       if the display can still be successfully opened as that
                       user (this is primarily to try to guess the actual owner
                       of the session). Example: "-users fred,wilma,betty".
                       Note that a malicious local user "barney" by
                       quickly using "xhost +" when logging in may possibly
                       get the x11vnc process to switch to user "fred".
                       What happens next?

                       Under display managers it may be a long time before
                       the switch succeeds (i.e. a user logs in).  To instead
                       make it switch immediately regardless if the display
                       can be reopened prefix the username with the "+"
                       character. E.g. "-users +bob" or "-users +nobody".

                       The latter (i.e. switching immediately to user
                       "nobody") is the only obvious use of the -users option
                       that increases security.

                       Use the following notation to associate a group with
                       a user: user1.group1,user2.group2,...  Note that
                       initgroups(2) will still be called first to try to
                       switch to ALL of a user's groups (primary and additional
                       groups).  Only if that fails or it is not available
                       then the single group specified as above (or the user's
                       primary group if not specified) is switched to with
                       setgid(2).  Use -env X11VNC_SINGLE_GROUP=1 to prevent
                       trying initgroups(2) and only switch to the single
                       group.  This sort of setting is only really needed to
                       make the ultra or tight filetransfer permissions work
                       properly. This format applies to any comma separated lis
t
                       of users, even the special "=" modes described below.

                       In -unixpw mode, if "-users unixpw=" is supplied
                       then after a user authenticates himself via the
                       -unixpw mechanism, x11vnc will try to switch to that
                       user as though "-users +username" had been supplied.
                       If you want to limit which users this will be done for,
                       provide them as a comma separated list after "unixpw="
                       Groups can also be specified as described above.

                       Similarly, in -ssl mode, if "-users sslpeer=" is
                       supplied then after an SSL client authenticates with his
                       cert (the -sslverify option is required for this) x11vnc
                       will extract a UNIX username from the "emailAddress"
                       field (username@hostname.com) of the "Subject" of the
                       x509 SSL cert and then try to switch to that user as
                       though "-users +username" had been supplied.  If you
                       want to limit which users this will be done for, provide
                       them as a comma separated list after "sslpeer=".
                       Set the env. var X11VNC_SSLPEER_CN to use the Common
                       Name (normally a hostname) instead of the Email field.

                       NOTE: for sslpeer= mode the x11vnc administrator must
                       take care that any client certs he adds to -sslverify
                       have the intended UNIX username in the "emailAddress"
                       field of the cert.  Otherwise a user may be able to
                       log in as another.  This command can be of use in
                       checking: "openssl x509 -text -in file.crt", see the
                       "Subject:" line.  Also, along with the normal RFB_*
                       env. vars. (see -accept) passed to external cmd=
                       commands, RFB_SSL_CLIENT_CERT will be set to the
                       client's x509 certificate string.

                       The sslpeer= mode can aid finding X sessions via the
                       FINDDISPLAY and FINDCREATEDISPLAY mechanisms.

                       To immediately switch to a user *before* connections
                       to the X display are made or any files opened use the
                       "=" character: "-users =bob".  That user needs to
                       be able to open the X display and any files of course.

                       The special user "guess=" means to examine the utmpx
                       database (see who(1)) looking for a user attached to
                       the display number (from DISPLAY or -display option)
                       and try him/her.  To limit the list of guesses, use:
                       "-users guess=bob,betty".

                       Even more sinister is the special user "lurk="
                       that means to try to guess the DISPLAY from the utmpx
                       login database as well.  So it "lurks" waiting for
                       anyone to log into an X session and then connects to it.
                       Specify a list of users after the = to limit which users
                       will be tried.  To enable a different searching mode, if
                       the first user in the list is something like ":0" or
                       ":0-2" that indicates a range of DISPLAY numbers that
                       will be tried (regardless of whether they are in the
                       utmpx database) for all users that are logged in.  Also
                       see the "-display WAIT:..." functionality.  Examples:
                       "-users lurk=" and also "-users lurk=:0-1,bob,mary"

                       Be especially careful using the "guess=" and "lurk="
                       modes.  They are not recommended for use on machines
                       with untrustworthy local users.

-noshm                 Do not use the MIT-SHM extension for the polling.
                       Remote displays can be polled this way: be careful this
                       can use large amounts of network bandwidth.  This is
                       also of use if the local machine has a limited number
                       of shm segments and -onetile is not sufficient.
-flipbyteorder         Sometimes needed if remotely polled host has different
                       endianness.  Ignored unless -noshm is set.
-onetile               Do not use the new copy_tiles() framebuffer mechanism,
                       just use 1 shm tile for polling.  Limits shm segments
                       used to 3.

                       To disable any automatic shm reduction set the
                       env. var. X11VNC_NO_LIMIT_SHM.

-solid [color]         To improve performance, when VNC clients are connected
                       try to change the desktop background to a solid color.
                       The [color] is optional: the default color is "cyan4".
                       For a different one specify the X color (rgb.txt name,
                       e.g. "darkblue" or numerical "#RRGGBB").

                       Currently this option only works on GNOME, KDE, CDE,
                       XFCE, and classic X (i.e. with the background image
                       on the root window).  The "gconftool-2", "dcop"
                       and "xfconf-query" external commands are run for
                       GNOME, KDE, and XFCE respectively.  This also works
                       on native MacOSX.  (There is no color selection for
                       MacOSX or XFCE.)  Other desktops won't work, (send
                       us the corresponding commands if you find them).
                       If x11vnc is running as root (inetd(8) or gdm(1)),
                       the -users option may be needed for GNOME, KDE, XFCE.
                       If x11vnc guesses your desktop incorrectly, you can
                       force it by prefixing color with "gnome:", "kde:",
                       "cde:", "xfce:", or "root:".

                       Update: -solid no longer works on KDE4.

                       This mode works in a limited way on the Mac OS X Console
                       with one color ('kelp') using the screensaver writing
                       to the background.  Look in "~/Library/Screen Savers"
                       for VncSolidColor.png to change the color.

-blackout string       Black out rectangles on the screen. "string" is a
                       comma separated list of WxH+X+Y type geometries for
                       each rectangle.  If one of the items on the list is the
                       string "noptr" the mouse pointer will not be allowed
                       to go into a blacked out region.
-xinerama              If your screen is composed of multiple monitors
-noxinerama            glued together via XINERAMA, and that screen is
                       not a rectangle this option will try to guess the
                       areas to black out (if your system has libXinerama).
                       default: -xinerama

                       In general, we have noticed on XINERAMA displays you may
                       need to use the "-xwarppointer" option if the mouse
                       pointer misbehaves and it is enabled by default. Use
                       "-noxwarppointer" if you do not want this.

-xtrap                 Use the DEC-XTRAP extension for keystroke and mouse
                       input insertion.  For use on legacy systems, e.g. X11R5,
                       running an incomplete or missing XTEST extension.
                       By default DEC-XTRAP will be used if XTEST server grab
                       control is missing, use -xtrap to do the keystroke and
                       mouse insertion via DEC-XTRAP as well.

-xrandr [mode]         If the display supports the XRANDR (X Resize, Rotate
                       and Reflection) extension, and you expect XRANDR events
                       to occur to the display while x11vnc is running, this
                       options indicates x11vnc should try to respond to
                       them (as opposed to simply crashing by assuming the
                       old screen size).  See the xrandr(1) manpage and run
                       'xrandr -q' for more info.  [mode] is optional and
                       described below.

                       Since watching for XRANDR events and trapping errors
                       increases polling overhead, only use this option if
                       XRANDR changes are expected.  For example on a rotatable
                       screen PDA or laptop, or using a XRANDR-aware Desktop
                       where you resize often.  It is best to be viewing with a
                       vncviewer that supports the NewFBSize encoding, since it
                       knows how to react to screen size changes.  Otherwise,
                       LibVNCServer tries to do so something reasonable for
                       viewers that cannot do this (portions of the screen
                       may be clipped, unused, etc).

                       Note: the default now is to check for XRANDR events, but
                       do not trap every X call that may fail due to resize.
                       If a resize event is received, the full -xrandr mode
                       is enabled.  To disable even checking for events supply:
                       -noxrandr.

                       "mode" defaults to "resize", which means create a
                       new, resized, framebuffer and hope all viewers can cope
                       with the change.  "newfbsize" means first disconnect
                       all viewers that do not support the NewFBSize VNC
                       encoding, and then resize the framebuffer.  "exit"
                       means disconnect all viewer clients, and then terminate
                       x11vnc.

-rotate string         Rotate and/or flip the framebuffer view exported by VNC.
                       This transformation is independent of XRANDR and is
                       done in software in main memory and so may be slower.
                       This mode could be useful on a handheld with portrait or
                       landscape modes that do not correspond to the scanline
                       order of the actual framebuffer.  "string" can be:

                             x     flip along x-axis
                             y     flip along y-axis
                            xy     flip along x- and y-axes
                           +90     rotate 90 degrees clockwise
                           -90     rotate 90 degrees counter-clockwise
                          +90x     rotate 90 degrees CW, then flip along x
                          +90y     rotate 90 degrees CW, then flip along y

                       these give all possible rotations and reflections.

                       Aliases: same as xy:  yx, +180, -180, 180
                                same as -90: +270, 270
                                same as +90: 90, (ditto for 90x, 90y)

                       Like -scale, this transformation is applied at the very
                       end of any chain of framebuffer transformations and so
                       any options with geometries, e.g. -blackout, -clip, etc.
                       are relative to the original X (or -rawfb) framebuffer,
                       not the final one sent to VNC viewers.

                       If you do not want the cursor shape to be rotated
                       prefix "string" with "nc:", e.g. "nc:+90",
                       "nc:xy", etc.

-padgeom WxH           Whenever a new vncviewer connects, the framebuffer is
                       replaced with a fake, solid black one of geometry WxH.
                       Shortly afterwards the framebuffer is replaced with the
                       real one.  This is intended for use with vncviewers
                       that do not support NewFBSize and one wants to make
                       sure the initial viewer geometry will be big enough
                       to handle all subsequent resizes (e.g. under -xrandr,
                       -remote id:windowid, rescaling, etc.)

                       In -unixpw mode this sets the size of the login screen.
                       Use "once:WxH" it ignore padgeom after the login
                       screen is set up.

-o logfile             Write stderr messages to file "logfile" instead of to
                       the terminal.  Same as "-logfile file".  To append
                       to the file use "-oa file" or "-logappend file".
                       If "logfile" contains the string "%VNCDISPLAY"
                       it is expanded to the vnc display (the name may need
                       to be guessed at.)  "%HOME" works too.

-flag file             Write the "PORT=NNNN" (e.g. PORT=5900) string to
                       "file" in addition to stdout.  This option could be
                       useful by wrapper script to detect when x11vnc is ready.

-rmflag file           Remove "file" at exit to signal when x11vnc is done.
                       The file is created at startup if it does not already
                       exist or if "file" is prefixed with "create:".
                       If the file is created, the x11vnc PID is placed in
                       the file.  Otherwise the files contents is not changed.
                       Use prefix "nocreate:" to prevent creation.

-rc filename           Use "filename" instead of $HOME/.x11vncrc for rc file.
-norc                  Do not process any .x11vncrc file for options.

-env VAR=VALUE         Set the environment variable 'VAR' to value 'VALUE'
                       at x11vnc startup.  This is a convenience utility to
                       avoid shell script wrappers, etc. to set the env. var.
                       You may specify as many of these as needed on the
                       command line.
-prog /path/to/x11vnc  Set the full path to the x11vnc program for cases when
                       it cannot be determined from argv[0] (e.g. tcpd/inetd)

-h, -help              Print this help text.
-?, -opts              Only list the x11vnc options.
-V, -version           Print program version and last modification date.
-license               Print out license information.  Same as -copying and
                       -warranty.

-dbg                   Instead of exiting after cleaning up, run a simple
                       "debug crash shell" when fatal errors are trapped.

-q, -quiet             Be quiet by printing less informational output to
                       stderr. (use -noquiet to undo an earlier -quiet.)

                       The -quiet option does not eliminate all informational
                       output, it only reduces it.  It is ignored in most
                       auxiliary usage modes, e.g. -storepasswd.  To eliminate
                       all output use: 2>/dev/null 1>&2, etc.

-v, -verbose           Print out more information to stderr.

-bg                    Go into the background after screen setup.  Messages to
                       stderr are lost unless -o logfile is used.  Something
                       like this could be useful in a script:
                        port=`ssh -t $host "x11vnc -display :0 -bg" | grep PORT
`
                        port=`echo "$port" | sed -e 's/PORT=//'`
                        port=`expr $port - 5900`
                        vncviewer $host:$port

-modtweak              Option -modtweak automatically tries to adjust the AltGr
-nomodtweak            and Shift modifiers for differing language keyboards
                       between client and host.  Otherwise, only a single key
                       press/release of a Keycode is simulated (i.e. ignoring
                       the state of the modifiers: this usually works for
                       identical keyboards).  Also useful in resolving cases
                       where a Keysym is bound to multiple keys (e.g. "<" + ">"
                       and "," + "<" keys).  Default: -modtweak

                       If you are having trouble with with keys and -xkb or
                       -noxkb, and similar things don't help, try -nomodtweak.

                       On some HP-UX systems it is been noted that they have
                       an odd keymapping where a single keycode will have a
                       keysym, e.g. "#", up to three times.  You can check
                       via "xmodmap -pk" or the -dk option.  The failure
                       is when you try to type "#" it yields "3".  If you
                       see this problem try setting the environment variable
                       MODTWEAK_LOWEST=1 to see if it helps.

-xkb                   When in modtweak mode, use the XKEYBOARD extension (if
-noxkb                 the X display supports it) to do the modifier tweaking.
                       This is powerful and should be tried if there are still
                       keymapping problems when using -modtweak by itself.
                       The default is to check whether some common keysyms,
                       e.g. !, @, [, are only accessible via -xkb mode and if
                       so then automatically enable the mode.  To disable this
                       automatic detection use -noxkb.

                       When -xkb mode is active you can set these env. vars.
                       They apply only when there is ambiguity as to which
                       key to choose (i.e the mapping is not one-to-one).
                       NOKEYHINTS=1: for up ascii keystrokes do not use score
                       hints saved when the key was pressed down. NOANYDOWN=1:
                       for up keystrokes do not resort to searching through
                       keys that are currently pressed down.  KEYSDOWN=N:
                       remember the last N keys press down for tie-breaking
                       when an up keystroke comes in.

-capslock              When in -modtweak (the default) or -xkb mode,
                       if a keysym in the range A-Z comes in check the X
                       server to see if the Caps_Lock is set.  If it is do
                       not artificially press Shift to generate the keysym.
                       This will enable the CapsLock key to behave correctly
                       in some circumstances: namely *both* the VNC viewer
                       machine and the x11vnc X server are in the CapsLock
                       on state.  If one side has CapsLock on and the other
                       off and the keyboard is not behaving as you think it
                       should you should correct the CapsLock states (hint:
                       pressing CapsLock inside and outside of the viewer can
                       help toggle them both to the correct state).  However,
                       for best results do not use this option, but rather
                       *only* enable CapsLock on the VNC viewer side (i.e. by
                       pressing CapsLock outside of the viewer window, also
                       -skip_lockkeys below).  Also try -nomodtweak for a
                       possible workaround.

-skip_lockkeys         Have x11vnc ignore all Caps_Lock, Shift_Lock, Num_Lock,
-noskip_lockkeys       Scroll_Lock keysyms received from viewers.  The idea is
                       you press Caps_Lock on the VNC Viewer side but that does
                       not change the lock state in the x11vnc-side X server.
                       Nevertheless your capitalized letters come in over
                       the wire and are applied correctly to the x11vnc-side
                       X server.  Note this mode probably won't do what you
                       want in -nomodtweak mode.  Also, a kludge for KP_n
                       digits is always done in this mode: they are mapped to
                       regular digit keysyms.  See also -capslock above.
                       The default is -noskip_lockkeys.

-skip_keycodes string  Ignore the comma separated list of decimal keycodes.
                       Perhaps these are keycodes not on your keyboard but
                       your X server thinks exist.  Currently only applies
                       to -xkb mode.  Use this option to help x11vnc in the
                       reverse problem it tries to solve: Keysym -> Keycode(s)
                       when ambiguities exist (more than one Keycode per
                       Keysym).  Run 'xmodmap -pk' to see your keymapping.
                       Example: "-skip_keycodes 94,114"
-sloppy_keys           Experimental option that tries to correct some
                       "sloppy" key behavior.  E.g. if at the viewer you
                       press Shift+Key but then release the Shift before
                       Key that could give rise to extra unwanted characters
                       (usually only between keyboards of different languages).
                       Only use this option if you observe problems with
                       some keystrokes.
-skip_dups             Some VNC viewers send impossible repeated key events,
-noskip_dups           e.g. key-down, key-down, key-up, key-up all for the same
                       key, or 20 downs in a row for the same modifier key!
                       Setting -skip_dups means to skip these duplicates and
                       just process the first event. Note: some VNC viewers
                       assume they can send down's without the corresponding
                       up's and so you should not set this option for
                       these viewers (symptom: some keys do not autorepeat)
                       Default: -noskip_dups
-add_keysyms           If a Keysym is received from a VNC viewer and that
-noadd_keysyms         Keysym does not exist in the X server, then add the
                       Keysym to the X server's keyboard mapping on an unused
                       key.  Added Keysyms will be removed periodically and
                       also when x11vnc exits.  Default: -add_keysyms
-clear_mods            At startup and exit clear the modifier keys by sending
                       KeyRelease for each one. The Lock modifiers are skipped.
                       Used to clear the state if the display was accidentally
                       left with any pressed down.
-clear_keys            As -clear_mods, except try to release ANY pressed key.
                       Note that this option and -clear_mods can interfere
                       with a person typing at the physical keyboard.
-clear_all             As -clear_keys, except try to release any CapsLock,
                       NumLock, etc. locks as well.

-remap string          Read Keysym remappings from file named "string".
                       Format is one pair of Keysyms per line (can be name
                       or hex value) separated by a space.  If no file named
                       "string" exists, it is instead interpreted as this
                       form: key1-key2,key3-key4,...  See <X11/keysymdef.h>
                       header file for a list of Keysym names, or use xev(1).

                       To map a key to a button click, use the fake Keysyms
                       "Button1", ..., etc. E.g: "-remap Super_R-Button2"
                       (useful for pasting on a laptop)

                       I use these if the machine I am viewing from does not
                       have a scrollwheel or I don't like using the one it has:

                              -remap Super_R-Button4,Menu-Button5
                              -remap KP_Add-Button4,KP_Enter-Button5

                       the former would be used on a PC, the latter on a
                       MacBook.  This way those little used keys can be used
                       to generate bigger hops than the Up and Down arrows
                       provide.  One can scroll through text or web pages more
                       quickly this way (especially if x11vnc scroll detection
                       is active.)

                       Use Button44, Button12, etc. for multiple clicks.

                       To disable a keysym (i.e. make it so it will not be
                       injected), remap it to "NoSymbol" or "None".

                       Dead keys: "dead" (or silent, mute) keys are keys that
                       do not produce a character but must be followed by a 2nd
                       keystroke.  This is often used for accenting characters,
                       e.g. to put "`" on top of "a" by pressing the dead
                       key and then "a".  Note that this interpretation
                       is not part of core X11, it is up to the toolkit or
                       application to decide how to react to the sequence.
                       The X11 names for these keysyms are "dead_grave",
                       "dead_acute", etc.  However some VNC viewers send the
                       keysyms "grave", "acute" instead thereby disabling
                       the accenting.  To work around this -remap can be used.
                       For example "-remap grave-dead_grave,acute-dead_acute"
                       As a convenience, "-remap DEAD" applies these remaps:

                               g     grave-dead_grave
                               a     acute-dead_acute
                               c     asciicircum-dead_circumflex
                               t     asciitilde-dead_tilde
                               m     macron-dead_macron
                               b     breve-dead_breve
                               D     abovedot-dead_abovedot
                               d     diaeresis-dead_diaeresis
                               o     degree-dead_abovering
                               A     doubleacute-dead_doubleacute
                               r     caron-dead_caron
                               e     cedilla-dead_cedilla

                       If you just want a subset use the first letter
                       label, e.g. "-remap DEAD=ga" to get the first two.
                       Additional remaps may also be supplied via commas,
                       e.g.  "-remap DEAD=ga,Super_R-Button2".  Finally,
                       "DEAD=missing" means to apply all of the above as
                       long as the left hand member is not already in the
                       X11 keymap.

-norepeat              Option -norepeat disables X server key auto repeat when
-repeat                VNC clients are connected and VNC keyboard input is
                       not idle for more than 5 minutes.  This works around a
                       repeating keystrokes bug (triggered by long processing
                       delays between key down and key up client events:
                       either from large screen changes or high latency).
                       Default: -norepeat

                       You can set the env. var. X11VNC_IDLE_TIMEOUT to the
                       number of idle seconds you want (5min = 300secs).

                       Note: your VNC viewer side will likely do autorepeating,
                       so this is no loss unless someone is simultaneously at
                       the real X display.

                       Use "-norepeat N" to set how many times norepeat will
                       be reset if something else (e.g. X session manager)
                       undoes it.  The default is 2.  Use a negative value
                       for unlimited resets.

-nofb                  Ignore video framebuffer: only process keyboard and
                       pointer.  Intended for use with Win2VNC and x2vnc
                       dual-monitor setups.
-nobell                Do not watch for XBell events. (no beeps will be heard)
                       Note: XBell monitoring requires the XKEYBOARD extension.
-nosel                 Do not manage exchange of X selection/cutbuffer between
                       VNC viewers and the X server at all.
-noprimary             Do not poll the PRIMARY selection for changes to send
                       back to clients.  (PRIMARY is still set on received
                       changes, however).
-nosetprimary          Do not set the PRIMARY selection for changes received
                       from VNC clients.
-noclipboard           Do not poll the CLIPBOARD selection for changes to send
                       back to clients.  (CLIPBOARD is still set on received
                       changes, however).
-nosetclipboard        Do not set the CLIPBOARD selection for changes
                       received from VNC clients.
-seldir string         If direction string is "send", only send the selection
                       to viewers, and if it is "recv" only receive it from
                       viewers.  To work around apps setting the selection
                       too frequently and messing up the other end.  You can
                       actually supply a comma separated list of directions,
                       including "debug" to turn on debugging output.

-cursor [mode]         Sets how the pointer cursor shape (little icon at the
-nocursor              mouse pointer) should be handled.  The "mode" string
                       is optional and is described below.  The default
                       is to show some sort of cursor shape(s).  How this
                       is done depends on the VNC viewer and the X server.
                       Use -nocursor to disable cursor shapes completely.

                       Some VNC viewers support the TightVNC CursorPosUpdates
                       and CursorShapeUpdates extensions (cuts down on
                       network traffic by not having to send the cursor image
                       every time the pointer is moved), in which case these
                       extensions are used (see -nocursorshape and -nocursorpos
                       below to disable).  For other viewers the cursor shape
                       is written directly to the framebuffer every time the
                       pointer is moved or changed and gets sent along with
                       the other framebuffer updates.  In this case, there
                       will be some lag between the vnc viewer pointer and
                       the remote cursor position.

                       If the X display supports retrieving the cursor shape
                       information from the X server, then the default is
                       to use that mode.  On Solaris this can be done with
                       the SUN_OVL extension using -overlay (see also the
                       -overlay_nocursor option).  A similar overlay scheme
                       is used on IRIX.  Xorg (e.g. Linux) and recent Solaris
                       Xsun servers support the XFIXES extension to retrieve
                       the exact cursor shape from the X server.  If XFIXES
                       is present it is preferred over Overlay and is used by
                       default (see -noxfixes below).  This can be disabled
                       with -nocursor, and also some values of the "mode"
                       option below.

                       Note that under XFIXES cursors with transparency (alpha
                       channel) will usually not be exactly represented and one
                       may find Overlay preferable.  See also the -alphacut
                       and -alphafrac options below as fudge factors to try
                       to improve the situation for cursors with transparency
                       for a given theme.

                       The "mode" string can be used to fine-tune the
                       displaying of cursor shapes.  It can be used the
                       following ways:

                       "-cursor arrow" - just show the standard arrow
                       nothing more or nothing less.

                       "-cursor none" - same as "-nocursor"

                       "-cursor X" - when the cursor appears to be on the
                       root window, draw the familiar X shape.  Some desktops
                       such as GNOME cover up the root window completely,
                       and so this will not work, try "X1", etc, to try to
                       shift the tree depth.  On high latency links or slow
                       machines there will be a time lag between expected and
                       the actual cursor shape.

                       "-cursor some" - like "X" but use additional
                       heuristics to try to guess if the window should have
                       a windowmanager-like resizer cursor or a text input
                       I-beam cursor.  This is a complete hack, but may be
                       useful in some situations because it provides a little
                       more feedback about the cursor shape.

                       "-cursor most" - try to show as many cursors as
                       possible.  Often this will only be the same as "some"
                       unless the display has overlay visuals or XFIXES
                       extensions available.  On Solaris and IRIX if XFIXES
                       is not available, -overlay mode will be attempted.

-cursor_drag           Show cursor shape changes even when the mouse is being
                       dragged with a mouse button down.  This is useful if you
                       want to be able to see Drag-and-Drop cursor icons, etc.

-arrow n               Choose an alternate "arrow" cursor from a set of
                       some common ones.  n can be 1 to 6.  Default is: 1
                       Ignored when in XFIXES cursor-grabbing mode.

-noxfixes              Do not use the XFIXES extension to draw the exact cursor
                       shape even if it is available.

                       Note: To work around a crash in Xorg 1.5 and later
                       some people needed to use -noxfixes.  The Xorg crash
                       occurred right after a Display Manager (e.g. GDM) login.
                       Starting with x11vnc 0.9.9 it tries to automatically
                       avoid using XFIXES until it is sure a window manager
                       is running.  See the -reopen option for more info and
                       how to use X11VNC_AVOID_WINDOWS=never to disable it.

-alphacut n            When using the XFIXES extension for the cursor shape,
                       cursors with transparency will not usually be displayed
                       exactly (but opaque ones will).  This option sets n as
                       a cutoff for cursors that have transparency ("alpha
                       channel" with values ranging from 0 to 255) Any cursor
                       pixel with alpha value less than n becomes completely
                       transparent.  Otherwise the pixel is completely opaque.
                       Default 240

-alphafrac fraction    With the threshold in -alphacut some cursors will become
                       almost completely transparent because their alpha values
                       are not high enough.  For those cursors adjust the
                       alpha threshold until fraction of the non-zero alpha
                       channel pixels become opaque.  Default 0.33
-alpharemove           By default, XFIXES cursors pixels with transparency have
                       the alpha factor multiplied into the RGB color values
                       (i.e. that corresponding to blending the cursor with a
                       black background).  Specify this option to remove the
                       alpha factor. (useful for light colored semi-transparent
                       cursors).
-noalphablend          In XFIXES mode do not send cursor alpha channel data
                       to LibVNCServer.  The default is to send it.  The
                       alphablend effect will only be visible in -nocursorshape
                       mode or for clients with cursorshapeupdates turned
                       off. (However there is a hack for 32bpp with depth 24,
                       it uses the extra 8 bits to store cursor transparency
                       for use with a hacked vncviewer that applies the
                       transparency locally.  See the FAQ for more info).

-nocursorshape         Do not use the TightVNC CursorShapeUpdates extension
                       even if clients support it.  See -cursor above.
-cursorpos             Option -cursorpos enables sending the X cursor position
-nocursorpos           back to all vnc clients that support the TightVNC
                       CursorPosUpdates extension.  Other clients will be able
                       to see the pointer motions. Default: -cursorpos
-xwarppointer          Move the pointer with XWarpPointer(3X) instead of
-noxwarppointer        the XTEST extension.  Use this as a workaround
                       if the pointer motion behaves incorrectly, e.g.
                       on touchscreens or other non-standard setups.

                       It is also sometimes needed on XINERAMA displays and is
                       enabled by default if XINERAMA is found to be active.
                       To prevent this, use -noxwarppointer.

-always_inject         Even if there is no displacement (dx = dy = 0) for a
                       VNC mouse event force the pointer to the indicated x,y
                       position anyway.  Recent (2009) gui toolkits (gnome)
                       have problems with x11vnc's original mouse input
                       injection method.  So x11vnc's mouse input injection
                       method has been modified.  To regain the OLD behavior
                       use this option: -always_inject.  Then x11vnc will
                       always force positioning the mouse to the x,y position
                       even if that position has not changed since the previous
                       VNC input event.

                       The first place this problem was noticed was in gnome
                       terminal: if you pressed and released mouse button 3, a
                       menu was posted and then its first element 'New Terminal
                       Window' was activated.  This was because x11vnc injected
                       the mouse position twice: once on ButtonPress and again
                       on ButtonRelease.  The toolkit interpreted the 2nd one
                       as mouse motion even though the mouse hadn't moved.
                       So now by default x11vnc tries to avoid injecting the
                       2nd one.

                       Note that with the new default x11vnc will be oblivious
                       to applications moving the pointer (warping) or the
                       user at the physical display moving it.  So it might,
                       e.g., inject ButtonRelease at the wrong position.
                       If this (or similar scenarios) causes problems in your
                       environment, specify -always_inject for the old method.

-buttonmap string      String to remap mouse buttons.  Format: IJK-LMN, this
                       maps buttons I -> L, etc., e.g.  -buttonmap 13-31

                       Button presses can also be mapped to keystrokes: replace
                       a button digit on the right of the dash with :<sym>:
                       or :<sym1>+<sym2>: etc. for multiple keys. For example,
                       if the viewing machine has a mouse-wheel (buttons 4 5)
                       but the x11vnc side does not, these will do scrolls:
                              -buttonmap 12345-123:Prior::Next:
                              -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:

                       See <X11/keysymdef.h> header file for a list of Keysyms,
                       or use the xev(1) program.  Note: mapping of button
                       clicks to Keysyms may not work if -modtweak or -xkb is
                       needed for the Keysym.

                       If you include a modifier like "Shift_L" the
                       modifier's up/down state is toggled, e.g. to send
                       "The" use :Shift_L+t+Shift_L+h+e: (the 1st one is
                       shift down and the 2nd one is shift up). (note: the
                       initial state of the modifier is ignored and not reset)
                       To include button events use "Button1", ... etc.

                       -buttonmap currently does not work on MacOSX console
                       or in -rawfb mode.

                       Workaround: use -buttonmap IJ...-LM...=n to limit the
                       number of mouse buttons to n, e.g. 123-123=3.  This will
                       prevent x11vnc from crashing if the X server reports
                       there are 5 buttons (4/5 scroll wheel), but there are
                       only really 3.

-nodragging            Do not update the display during mouse dragging events
                       (mouse button held down).  Greatly improves response on
                       slow setups, but you lose all visual feedback for drags,
                       text selection, and some menu traversals.  It overrides
                       any -pointer_mode setting.

-ncache n              Client-side caching scheme.  Framebuffer memory "n"
                       (an integer) times that of the full display is allocated
                       below the actual framebuffer to cache screen contents
                       for rapid retrieval.  So a W x H frambuffer is expanded
                       to a W x (n+1)*H one.  Use 0 to disable.

                       The "n" is actually optional, the default is 10.

                       For this and the other -ncache* options below you can
                       abbreviate "-ncache" with "-nc".  Also, "-nonc"
                       is the same as "-ncache 0"

                       This is an experimental option, currently implemented in
                       an awkward way in that in the VNC Viewer you can see the
                       pixel cache contents if you scroll down, etc.  So you
                       will have to set things up so you can't see that region.
                       If this method is successful, the changes required for
                       clients to do this less awkwardly will be investigated.

                       The SSVNC viewer does a good job at automatically hiding
                       the pixel cache region.  Or use SSVNC's -ycrop option
                       to explicitly hide the region.

                       Note that this mode consumes a huge amount of memory,
                       both on the x11vnc server side and on the VNC Viewer
                       side.  If n=2 then the amount of RAM used is roughly
                       tripled for both x11vnc and the VNC Viewer.  As a rule
                       of thumb, note that 1280x1024 at depth 24 is about 5MB
                       of pixel data.

                       For reasonable response when cycling through 4 to 6
                       large (e.g. web browser) windows a value n of 6 to 12
                       is recommended. (that's right: ~10X more memory...)

                       Because of the way window backingstore and saveunders
                       are implemented, n must be even.  It will be incremented
                       by 1 if it is not.

                       This mode also works for native MacOS X, but may not
                       be as effective as the X version.  This is due to a
                       number of things, one is the drop-shadow compositing
                       that leaves extra areas that need to be repaired (see
                       -ncache_pad).  Another is the window iconification
                       animations need to be avoided (see -macicontime).
                       It appears the that the 'Scale' animation mode gives
                       better results than the 'Genie' one.  Also, window event
                       detection not as accurate as the X version.

-ncache_cr             In -ncache mode, try to do copyrect opaque window
                       moves/drags instead of wireframes (this can induce
                       painting errors).  The wireframe will still be used when
                       moving a window whose save-unders has not yet been set
                       or has been invalidated.

                       Some VNC Viewers provide better response than others
                       with this option.  On Unix, realvnc viewer gives
                       smoother drags than tightvnc viewer.  Response may also
                       be choppy if the server side machine is too slow.

                       Sometimes on very slow modem connections, this actually
                       gives an improvement because no pixel data at all
                       (not even the box animation) is sent during the drag.

-ncache_no_moveraise   In -ncache mode, do not assume that moving a window
                       will cause the window manager to raise it to the top
                       of the stack.  The default is to assume it does, and
                       so at the beginning of any wireframe, etc, window moves
                       the window will be pushed to top in the VNC viewer.

-ncache_no_dtchange    In -ncache mode, do not try to guess when the desktop
                       (viewport) changes to another one (i.e. another
                       workarea).  The default is to try to guess and when
                       detected try to make the transistion more smoothly.

-ncache_no_rootpixmap  In -ncache mode, do not try to snapshot the desktop
                       background to use in guessing or reconstructing window
                       save-unders.

-ncache_keep_anims     In -ncache mode, do not try to disable window
                       manager animations and other effects (that usually
                       degrade ncache performance or cause painting errors).
                       The default is to try to disable them on KDE (but not
                       GNOME) when VNC clients are connected.

                       For other window managers or desktops that provide
                       animations, effects, compositing, translucency,
                       etc. that interfere with the -ncache method you will
                       have to disable them manually.

-ncache_old_wm         In -ncache mode, enable some heuristics for old style
                       window managers such as fvwm and twm.

-ncache_pad n          In -ncache mode, pad each window with n pixels for the
                       caching rectangles.  This can be used to try to improve
                       the situation with dropshadows or other compositing
                       (e.g. MacOS X window manager), although it could make
                       things worse.  The default is 0 on Unix and 24 on
                       MacOS X.
-debug_ncache          Turn on debugging and profiling output under -ncache.

-wireframe [str]       Try to detect window moves or resizes when a mouse
-nowireframe           button is held down and show a wireframe instead of
                       the full opaque window.  This is based completely on
                       heuristics and may not always work: it depends on your
                       window manager and even how you move things around.
                       See -pointer_mode below for discussion of the "bogging
                       down" problem this tries to avoid.
                       Default: -wireframe

                       Shorter aliases:  -wf [str]  and -nowf

                       The value "str" is optional and, of course, is
                       packed with many tunable parameters for this scheme:

                       Format: shade,linewidth,percent,T+B+L+R,mod,t1+t2+t3+t4
                       Default: 0xff,2,0,32+8+8+8,all,0.15+0.30+5.0+0.125

                       If you leave nothing between commas: ",," the default
                       value is used.  If you don't specify enough commas,
                       the trailing parameters are set to their defaults.

                       "shade" indicate the "color" for the wireframe,
                       usually a greyscale: 0-255, however for 16 and 32bpp you
                       can specify an rgb.txt X color (e.g. "dodgerblue") or
                       a value > 255 is treated as RGB (e.g. red is 0xff0000).
                       "linewidth" sets the width of the wireframe in pixels.
                       "percent" indicates to not apply the wireframe scheme
                       to windows with area less than this percent of the
                       full screen.

                       "T+B+L+R" indicates four integers for how close in
                       pixels the pointer has to be from the Top, Bottom, Left,
                       or Right edges of the window to consider wireframing.
                       This is a speedup to quickly exclude a window from being
                       wireframed: set them all to zero to not try the speedup
                       (scrolling and selecting text will likely be slower).

                       "mod" specifies if a button down event in the
                       interior of the window with a modifier key (Alt, Shift,
                       etc.) down should indicate a wireframe opportunity.
                       It can be "0" or "none" to skip it, "1" or "all"
                       to apply it to any modifier, or "Shift", "Alt",
                       "Control", "Meta", "Super", or "Hyper" to only
                       apply for that type of modifier key.

                       "t1+t2+t3+t4" specify four floating point times in
                       seconds: t1 is how long to wait for the pointer to move,
                       t2 is how long to wait for the window to start moving
                       or being resized (for some window managers this can be
                       rather long), t3 is how long to keep a wireframe moving
                       before repainting the window. t4 is the minimum time
                       between sending wireframe "animations".  If a slow
                       link is detected, these values may be automatically
                       changed to something better for a slow link.

-nowireframelocal      By default, mouse motion and button presses of a
                       user sitting at the LOCAL display are monitored for
                       wireframing opportunities (so that the changes will be
                       sent efficiently to the VNC clients).  Use this option
                       to disable this behavior.

-wirecopyrect mode     Since the -wireframe mechanism evidently tracks moving
-nowirecopyrect        windows accurately, a speedup can be obtained by
                       telling the VNC viewers to locally copy the translated
                       window region.  This is the VNC CopyRect encoding:
                       the framebuffer update doesn't need to send the actual
                       new image data.

                       Shorter aliases:  -wcr [mode]  and -nowcr

                       "mode" can be "never" (same as -nowirecopyrect)
                       to never try the copyrect, "top" means only do it if
                       the window was not covered by any other windows, and
                       "always" means to translate the orginally unobscured
                       region (this may look odd as the remaining pieces come
                       in, but helps on a slow link).  Default: "always"

                       Note: there can be painting errors or slow response
                       when using -scale so you may want to disable CopyRect
                       in this case "-wirecopyrect never" on the command
                       line or by remote-control.  Or you can also use the
                       "-scale xxx:nocr" scale option.

-debug_wireframe       Turn on debugging info printout for the wireframe
                       heuristics.  "-dwf" is an alias.  Specify multiple
                       times for more output.

-scrollcopyrect mode   Like -wirecopyrect, but use heuristics to try to guess
-noscrollcopyrect      if a window has scrolled its contents (either vertically
                       or horizontally).  This requires the RECORD X extension
                       to "snoop" on X applications (currently for certain
                       XCopyArea and XConfigureWindow X protocol requests).
                       Examples: Hitting <Return> in a terminal window when the
                       cursor was at the bottom, the text scrolls up one line.
                       Hitting <Down> arrow in a web browser window, the web
                       page scrolls up a small amount.  Or scrolling with a
                       scrollbar or mouse wheel.

                       Shorter aliases:  -scr [mode]  and -noscr

                       This scheme will not always detect scrolls, but when
                       it does there is a nice speedup from using the VNC
                       CopyRect encoding (see -wirecopyrect).  The speedup
                       is both in reduced network traffic and reduced X
                       framebuffer polling/copying.  On the other hand, it may
                       induce undesired transients (e.g. a terminal cursor
                       being scrolled up when it should not be) or other
                       painting errors (window tearing, bunching-up, etc).
                       These are automatically repaired in a short period
                       of time.  If this is unacceptable disable the feature
                       with -noscrollcopyrect.

                       Screen clearing kludges:  for testing at least, there
                       are some "magic key sequences" (must be done in less
                       than 1 second) to aid repairing painting errors that
                       may be seen when using this mode:

                       3 Alt_L's   in a row: resend whole screen,
                       4 Alt_L's   in a row: reread and resend whole screen,
                       3 Super_L's in a row: mark whole screen for polling,
                       4 Super_L's in a row: reset RECORD context,
                       5 Super_L's in a row: try to push a black screen

                       note: Alt_L is the Left "Alt" key (a single key)
                       Super_L is the Left "Super" key (Windows flag).
                       Both of these are modifier keys, and so should not
                       generate characters when pressed by themselves.  Also,
                       your VNC viewer may have its own refresh hot-key
                       or button.

                       "mode" can be "never" (same as -noscrollcopyrect)
                       to never try the copyrect, "keys" means to try it
                       in response to keystrokes only, "mouse" means to
                       try it in response to mouse events only, "always"
                       means to do both. Default: "always"

                       Note: there can be painting errors or slow response
                       when using -scale so you may want to disable CopyRect
                       in this case "-scrollcopyrect never" on the command
                       line or by remote-control.  Or you can also use the
                       "-scale xxx:nocr" scale option.

-scr_area n            Set the minimum area in pixels for a rectangle
                       to be considered for the -scrollcopyrect detection
                       scheme.  This is to avoid wasting the effort on small
                       rectangles that would be quickly updated the normal way.
                       E.g. suppose an app updated the position of its skinny
                       scrollbar first and then shifted the large panel
                       it controlled.  We want to be sure to skip the small
                       scrollbar and get the large panel. Default: 60000

-scr_skip list         Skip scroll detection for applications matching
                       the comma separated list of strings in "list".
                       Some applications implement their scrolling in
                       strange ways where the XCopyArea, etc, also applies
                       to invisible portions of the window: if we CopyRect
                       those areas it looks awful during the scroll and
                       there may be painting errors left after the scroll.
                       Soffice.bin is the worst known offender.

                       Use "##" to denote the start of the application class
                       (e.g. "##XTerm") and "++" to denote the start
                       of the application instance name (e.g. "++xterm").
                       The string your list is matched against is of the form
                       "^^WM_NAME##Class++Instance<same-for-any-subwindows>"
                       The "xlsclients -la" command will provide this info.

                       If a pattern is prefixed with "KEY:" it only applies
                       to Keystroke generated scrolls (e.g. Up arrow).  If it
                       is prefixed with "MOUSE:" it only applies to Mouse
                       induced scrolls (e.g. dragging on a scrollbar).
                       Default: ##Soffice.bin,##StarOffice,##OpenOffice

-scr_inc list          Opposite of -scr_skip: this list is consulted first
                       and if there is a match the window will be monitored
                       via RECORD for scrolls irrespective of -scr_skip.
                       Use -scr_skip '*' to skip anything that does not match
                       your -scr_inc.  Use -scr_inc '*' to include everything.

-scr_keys list         For keystroke scroll detection, only apply the RECORD
                       heuristics to the comma separated list of keysyms in
                       "list".  You may find the RECORD overhead for every
                       one of your keystrokes disrupts typing too much, but you
                       don't want to turn it off completely with "-scr mouse"
                       and -scr_parms does not work or is too confusing.

                       The listed keysyms can be numeric or the keysym
                       names in the <X11/keysymdef.h> header file or from the
                       xev(1) program.  Example: "-scr_keys Up,Down,Return".
                       One probably wants to have application specific lists
                       (e.g. for terminals, etc) but that is too icky to think
                       about for now...

                       If "list" begins with the "-" character the list
                       is taken as an exclude list: all keysyms except those
                       list will be considered.  The special string "builtin"
                       expands to an internal list of keysyms that are likely
                       to cause scrolls.  BTW, by default modifier keys,
                       Shift_L, Control_R, etc, are skipped since they almost
                       never induce scrolling by themselves.

-scr_term list         Yet another cosmetic kludge.  Apply shell/terminal
                       heuristics to applications matching comma separated
                       list (same as for -scr_skip/-scr_inc).  For example an
                       annoying transient under scroll detection is if you
                       hit Enter in a terminal shell with full text window,
                       the solid text cursor block will be scrolled up.
                       So for a short time there are two (or more) block
                       cursors on the screen.  There are similar scenarios,
                       (e.g. an output line is duplicated).

                       These transients are induced by the approximation of
                       scroll detection (e.g. it detects the scroll, but not
                       the fact that the block cursor was cleared just before
                       the scroll).  In nearly all cases these transient errors
                       are repaired when the true X framebuffer is consulted
                       by the normal polling.  But they are distracting, so
                       what this option provides is extra "padding" near the
                       bottom of the terminal window: a few extra lines near
                       the bottom will not be scrolled, but rather updated
                       from the actual X framebuffer.  This usually reduces
                       the annoying artifacts.  Use "none" to disable.
                       Default: "term"

-scr_keyrepeat lo-hi   If a key is held down (or otherwise repeats rapidly) and
                       this induces a rapid sequence of scrolls (e.g. holding
                       down an Arrow key) the "scrollcopyrect" detection
                       and overhead may not be able to keep up.  A time per
                       single scroll estimate is performed and if that estimate
                       predicts a sustainable scrollrate of keys per second
                       between "lo" and "hi" then repeated keys will be
                       DISCARDED to maintain the scrollrate. For example your
                       key autorepeat may be 25 keys/sec, but for a large
                       window or slow link only 8 scrolls per second can be
                       sustained, then roughly 2 out of every 3 repeated keys
                       will be discarded during this period. Default: "4-20"

-scr_parms string      Set various parameters for the scrollcopyrect mode.
                       The format is similar to that for -wireframe and packed
                       with lots of parameters:

                       Format: T+B+L+R,t1+t2+t3,s1+s2+s3+s4+s5
                       Default: 0+64+32+32,0.02+0.10+0.9,0.03+0.06+0.5+0.1+5.0

                       If you leave nothing between commas: ",," the default
                       value is used.  If you don't specify enough commas,
                       the trailing parameters are set to their defaults.

                       "T+B+L+R" indicates four integers for how close in
                       pixels the pointer has to be from the Top, Bottom, Left,
                       or Right edges of the window to consider scrollcopyrect.
                       If -wireframe overlaps it takes precedence.  This is a
                       speedup to quickly exclude a window from being watched
                       for scrollcopyrect: set them all to zero to not try
                       the speedup (things like selecting text will likely
                       be slower).

                       "t1+t2+t3" specify three floating point times in
                       seconds that apply to scrollcopyrect detection with
                       *Keystroke* input: t1 is how long to wait after a key
                       is pressed for the first scroll, t2 is how long to keep
                       looking after a Keystroke scroll for more scrolls.
                       t3 is how frequently to try to update surrounding
                       scrollbars outside of the scrolling area (0.0 to
                       disable)

                       "s1+s2+s3+s4+s5" specify five floating point times
                       in seconds that apply to scrollcopyrect detection with
                       *Mouse* input: s1 is how long to wait after a mouse
                       button is pressed for the first scroll, s2 is how long
                       to keep waiting for additional scrolls after the first
                       Mouse scroll was detected.  s3 is how frequently to
                       try to update surrounding scrollbars outside of the
                       scrolling area (0.0 to disable).  s4 is how long to
                       buffer pointer motion (to try to get fewer, bigger
                       mouse scrolls). s5 is the maximum time to spend just
                       updating the scroll window without updating the rest
                       of the screen.

-fixscreen string      Periodically "repair" the screen based on settings
                       in "string".  Hopefully you won't need this option,
                       it is intended for cases when the -scrollcopyrect or
                       -wirecopyrect features leave too many painting errors,
                       but it can be used for any scenario.  This option
                       periodically performs costly operations and so
                       interactive response may be reduced when it is on.
                       You can use 3 Alt_L's (the Left "Alt" key) taps in
                       a row (as described under -scrollcopyrect) instead to
                       manually request a screen repaint when it is needed.

                       "string" is a comma separated list of one or more of
                       the following: "V=t", "C=t", "X=t", and "8=t".
                       In these "t" stands for a time in seconds (it is
                       a floating point even though one should usually use
                       values > 2 to avoid wasting resources).  V sets how
                       frequently the entire screen should be sent to viewers
                       (it is like the 3 Alt_L's).  C sets how long to wait
                       after a CopyRect to repaint the full screen.  X sets
                       how frequently to reread the full X11 framebuffer from
                       the X server and push it out to connected viewers.
                       Use of X should be rare, please report a bug if you
                       find you need it. 8= applies only for -8to24 mode: it
                       sets how often the non-default visual regions of the
                       screen (e.g. 8bpp windows) are refreshed.  Examples:
                       -fixscreen V=10 -fixscreen C=10

-debug_scroll          Turn on debugging info printout for the scroll
                       heuristics.  "-ds" is an alias.  Specify it multiple
                       times for more output.

-noxrecord             Disable any use of the RECORD extension.  This is
                       currently used by the -scrollcopyrect scheme and to
                       monitor X server grabs.

-grab_buster           Some of the use of the RECORD extension can leave a
-nograb_buster         tiny window for XGrabServer deadlock.  This is only if
                       the whole-server grabbing application expects mouse or
                       keyboard input before releasing the grab.  It is usually
                       a window manager that does this.  x11vnc takes care to
                       avoid the problem, but if caught x11vnc will freeze.
                       Without -grab_buster, the only solution is to go the
                       physical display and give it some input to satisfy the
                       grabbing app.  Or manually kill and restart the window
                       manager if that is feasible.  With -grab_buster, x11vnc
                       will fork a helper thread and if x11vnc appears to be
                       stuck in a grab after a period of time (20-30 sec) then
                       it will inject some user input: button clicks, Escape,
                       mouse motion, etc to try to break the grab.  If you
                       experience a lot of grab deadlock, please report a bug.

-debug_grabs           Turn on debugging info printout with respect to
                       XGrabServer() deadlock for -scrollcopyrect mode.

-debug_sel             Turn on debugging info printout with respect to
                       PRIMARY, CLIPBOARD, and CUTBUFFER0 selections.

-pointer_mode n        Various pointer motion update schemes. "-pm" is
                       an alias.  The problem is pointer motion can cause
                       rapid changes on the screen: consider the rapid
                       changes when you drag a large window around opaquely.
                       Neither x11vnc's screen polling and vnc compression
                       routines nor the bandwidth to the vncviewers can keep
                       up these rapid screen changes: everything will bog down
                       when dragging or scrolling.  So a scheme has to be used
                       to "eat" much of that pointer input before re-polling
                       the screen and sending out framebuffer updates. The
                       mode number "n" can be 0 to 4 and selects one of
                       the schemes desribed below.

                       Note that the -wireframe and -scrollcopyrect modes
                       complement -pointer_mode by detecting (and improving)
                       certain periods of "rapid screen change".

                       n=0: does the same as -nodragging. (all screen polling
                       is suspended if a mouse button is pressed.)

                       n=1: was the original scheme used to about Jan 2004:
                       it basically just skips -input_skip keyboard or pointer
                       events before repolling the screen.

                       n=2 is an improved scheme: by watching the current rate
                       of input events it tries to detect if it should try to
                       "eat" additional pointer events before continuing.

                       n=3 is basically a dynamic -nodragging mode: it detects
                       when the mouse motion has paused and then refreshes
                       the display.

                       n=4 attempts to measures network rates and latency,
                       the video card read rate, and how many tiles have been
                       changed on the screen.  From this, it aggressively tries
                       to push screen "frames" when it decides it has enough
                       resources to do so.  NOT FINISHED.

                       The default n is 2. Note that modes 2, 3, 4 will skip
                       -input_skip keyboard events (but it will not count
                       pointer events).  Also note that these modes are not
                       available in -threads mode which has its own pointer
                       event handling mechanism.

                       To try out the different pointer modes to see which
                       one gives the best response for your usage, it is
                       convenient to use the remote control function, for
                       example "x11vnc -R pm:4" or the tcl/tk gui (Tuning ->
                       pointer_mode -> n).

-input_skip n          For the pointer handling when non-threaded: try to
                       read n user input events before scanning display. n < 0
                       means to act as though there is always user input.
                       Default: 10

-allinput              Have x11vnc read and process all available client input
                       before proceeding.

-input_eagerly         Similar to -allinput but use the handleEventsEagerly
                       mechanism built into LibVNCServer.

-speeds rd,bw,lat      x11vnc tries to estimate some speed parameters that
                       are used to optimize scheduling (e.g. -pointer_mode
                       4, -wireframe, -scrollcopyrect) and other things.
                       Use the -speeds option to set these manually.
                       The triple "rd,bw,lat" corresponds to video h/w
                       read rate in MB/sec, network bandwidth to clients in
                       KB/sec, and network latency to clients in milliseconds,
                       respectively.  If a value is left blank, e.g. "-speeds
                       ,100,15", then the internal scheme is used to estimate
                       the empty value(s).

                       Typical PC video cards have read rates of 5-10 MB/sec.
                       If the framebuffer is in main memory instead of video
                       h/w (e.g. SunRay, shadowfb, dummy driver, Xvfb), the
                       read rate may be much faster.  "x11perf -getimage500"
                       can be used to get a lower bound (remember to factor
                       in the bytes per pixel).  It is up to you to estimate
                       the network bandwith and latency to clients.  For the
                       latency the ping(1) command can be used.

                       For convenience there are some aliases provided,
                       e.g. "-speeds modem".  The aliases are: "modem" for
                       6,4,200; "dsl" for 6,100,50; and "lan" for 6,5000,1

-wmdt string           For some features, e.g. -wireframe and -scrollcopyrect,
                       x11vnc has to work around issues for certain window
                       managers or desktops (currently kde and xfce).
                       By default it tries to guess which one, but it can
                       guess incorrectly.  Use this option to indicate which
                       wm/dt.  "string" can be "gnome", "kde", "cde",
                       "xfce", or "root" (classic X wm).  Anything else
                       is interpreted as "root".

-debug_pointer         Print debugging output for every pointer event.
-debug_keyboard        Print debugging output for every keyboard event.
                       Same as -dp and -dk, respectively.  Use multiple
                       times for more output.

-defer time            Time in ms to delay sending updates to connected clients
                       (deferUpdateTime)  Default: 20

-wait time             Time in ms to pause between screen polls.  Used to cut
                       down on load.  Default: 20

-extra_fbur n          Perform extra FrameBufferUpdateRequests checks to
                       try to be in better sync with the client's requests.
                       What this does is perform extra polls of the client
                       socket at critical times (before '-defer' and '-wait'
                       calls.)  The default is n=1.  Set to a larger number to
                       insert more checks or set to n=0 to disable.  A downside
                       of these extra calls is that more mouse input may be
                       processed than desired.

-wait_ui factor        Factor by which to cut the -wait time if there
                       has been recent user input (pointer or keyboard).
                       Improves response, but increases the load whenever you
                       are moving the mouse or typing.  Default: 2.00
-setdefer n            When the -wait_ui mechanism cuts down the wait time ms,
                       set the defer time to the same ms value. n=1 to enable,
                       0 to disable, and -1 to set defer to 0 (no delay).
                       Similarly, 2 and -2 indicate 'urgent_update' mode should
                       be used to push the updates even sooner.  Default: 1
-nowait_bog            Do not detect if the screen polling is "bogging down"
                       and sleep more.  Some activities with no user input can
                       slow things down a lot: consider a large terminal window
                       with a long build running in it continuously streaming
                       text output.  By default x11vnc will try to detect this
                       (3 screen polls in a row each longer than 0.25 sec with
                       no user input), and sleep up to 1.5 secs to let things
                       "catch up".  Use this option to disable that detection.
-slow_fb time          Floating point time in seconds to delay all screen
                       polling.  For special purpose usage where a low frame
                       rate is acceptable and desirable, but you want the
                       user input processed at the normal rate so you cannot
                       use -wait.
-xrefresh time         Floating point time in seconds to indicate how often to
                       do the equivalent of xrefresh(1) to force all windows
                       (in the viewable area if -id, -sid, or -clip is used)
                       to repaint themselves.  Use this only if applications
                       misbehave by not repainting themselves properly.
                       See also -noxdamage.
-nap                   Monitor activity and if it is low take longer naps
-nonap                 between screen polls to really cut down load when idle.
                       Default: take naps
-sb time               Time in seconds after NO activity (e.g. screen blank)
                       to really throttle down the screen polls (i.e. sleep
                       for about 1.5 secs). Use 0 to disable.  Default: 60
                       Set the env. var. X11VNC_SB_FACTOR to scale it.

-readtimeout n         Set LibVNCServer rfbMaxClientWait to n seconds. On
                       slow links that take a long time to paint the first
                       screen LibVNCServer may hit the timeout and drop the
                       connection.  Default: 20 seconds.
-ping n                Send a 1x1 framebuffer update to all clients every n
                       seconds (e.g. to try to keep a network connection alive)

-nofbpm                If the system supports the FBPM (Frame Buffer Power
-fbpm                  Management) extension (i.e. some Sun systems), then
                       prevent the video h/w from going into a reduced power
                       state when VNC clients are connected.

                       FBPM capable video h/w save energy when the workstation
                       is idle by going into low power states (similar to DPMS
                       for monitors).  This interferes with x11vnc's polling
                       of the framebuffer data.

                       "-nofbpm" means prevent FBPM low power states whenever
                       VNC clients are connected, while "-fbpm" means to not
                       monitor the FBPM state at all.  See the xset(1) manpage
                       for details.  -nofbpm is basically the same as running
                       "xset fbpm force on" periodically.  Default: -fbpm

-nodpms                If the system supports the DPMS (Display Power Managemen
t
-dpms                  Signaling) extension, then prevent the monitor from
                       going into a reduced power state when VNC clients
                       are connected.

                       DPMS reduced power monitor states are a good thing
                       and you normally want the power down to take place
                       (usually x11vnc has no problem exporting the display in
                       this state).  You probably only want to use "-nodpms"
                       to work around problems with Screen Savers kicking
                       on in DPMS low power states.  There is known problem
                       with kdesktop_lock on KDE where the screen saver keeps
                       kicking in every time user input stops for a second
                       or two.  Specifying "-nodpms" works around it.

                       "-nodpms" means prevent DPMS low power states whenever
                       VNC clients are connected, while "-dpms" means to not
                       monitor the DPMS state at all.  See the xset(1) manpage
                       for details.  -nodpms is basically the same as running
                       "xset dpms force on" periodically.  Default: -dpms

-forcedpms             If the system supports the DPMS (Display Power
                       Management Signaling) extension, then try to keep the
                       monitor in a powered off state.  This is to prevent
                       nosey people at the physical display from viewing what
                       is on the screen.  Be sure to lock the screen before
                       disconnecting.

                       This method is far from bullet proof, e.g. suppose
                       someone attaches a non-DPMS monitor, or loads the
                       machine so that there is a gap of time before x11vnc
                       restores the powered off state?  On many machines if
                       he floods it with keyboard and mouse input he can see
                       flashes of what is on the screen before the DPMS off
                       state is reestablished.  For this to work securely
                       there would need to be support in the X server to do
                       this exactly rather than approximately with DPMS.

-clientdpms            As -forcedpms but only when VNC clients are connected.

-noserverdpms          The UltraVNC ServerInput extension is supported.
                       This allows the VNC viewer to click a button that will
                       cause the server (x11vnc) to try to disable keyboard
                       and mouse input at the physical display and put the
                       monitor in dpms powered off state.  Use this option to
                       skip powering off the monitor.

-noultraext            Disable the following UltraVNC extensions: SingleWindow
                       and ServerInput.  The others managed by LibVNCServer
                       (textchat, 1/n scaling, rfbEncodingUltra) are not.

-chatwindow            Place a local UltraVNC chat window on the X11 display
                       that x11vnc is polling.  That way the person on the VNC
                       viewer-side can chat with the person at the physical
                       X11 console. (e.g. helpdesk w/o telephone)

                       For this to work the SSVNC package (version 1.0.21 or
                       later) MUST BE installed on the system where x11vnc runs
                       and the 'ssvnc' command must be available in $PATH.
                       The ssvncviewer is used as a chat window helper.
                       See http://www.karlrunge.com/x11vnc/ssvnc.html

                       This option implies '-rfbversion 3.6' so as to trick
                       UltraVNC viewers, otherwise they assume chat is not
                       available.  To specify a different rfbversion, place
                       it after the -chatwindow option on the cmdline.

                       See also the remote control 'chaton' and 'chatoff'
                       actions.  These can also be set from the tkx11vnc GUI.

-noxdamage             Do not use the X DAMAGE extension to detect framebuffer
                       changes even if it is available.  Use -xdamage if your
                       default is to have it off.

                       x11vnc's use of the DAMAGE extension: 1) significantly
                       reduces the load when the screen is not changing much,
                       and 2) detects changed areas (small ones by default)
                       more quickly.

                       Currently the DAMAGE extension is overly conservative
                       and often reports large areas (e.g. a whole terminal
                       or browser window) as damaged even though the actual
                       changed region is much smaller (sometimes just a few
                       pixels).  So heuristics were introduced to skip large
                       areas and use the damage rectangles only as "hints"
                       for the traditional scanline polling.  The following
                       tuning parameters are introduced to adjust this
                       behavior:

-xd_area A             Set the largest DAMAGE rectangle area "A" (in
                       pixels: width * height) to trust as truly damaged:
                       the rectangle will be copied from the framebuffer
                       (slow) no matter what.  Set to zero to trust *all*
                       rectangles. Default: 20000
-xd_mem f              Set how long DAMAGE rectangles should be "remembered",
                       "f" is a floating point number and is in units of the
                       scanline repeat cycle time (32 iterations).  The default
                       (1.0) should give no painting problems. Increase it if
                       there are problems or decrease it to live on the edge
                       (perhaps useful on a slow machine).

-sigpipe string        Broken pipe (SIGPIPE) handling.  "string" can be
                       "ignore" or "exit".  For "ignore" LibVNCServer
                       will handle the abrupt loss of a client and continue,
                       for "exit" x11vnc will cleanup and exit at the 1st
                       broken connection.

                       This option is not really needed since LibVNCServer
                       is doing the correct thing now for quite some time.
                       However, for convenience you can use it to ignore other
                       signals, e.g. "-sigpipe ignore:HUP,INT,TERM" in case
                       that would be useful for some sort of application.
                       You can also put "exit:.." in the list to have x11vnc
                       cleanup on the listed signals. "-sig" is an alias
                       for this option if you don't like the 'pipe'. Example:
                       -sig ignore:INT,TERM,exit:USR1

-threads               Whether or not to use the threaded LibVNCServer
-nothreads             algorithm [rfbRunEventLoop] if libpthread is available.
                       In this mode new threads (one for input and one
                       for output) are created to handle each new client.
                       Default: -nothreads.

                       Thread stability is much improved in version 0.9.8.

                       Multiple clients in threaded mode should be stable
                       for the ZRLE encoding on all platforms.  The Tight and
                       Zlib encodings are currently only stable on Linux for
                       multiple clients.  Compile with -DTLS=__thread if your
                       OS and compiler and linker support it.

                       For resizes (randr, etc.) set this env. var. to the numb
er
                       of milliseconds to sleep: X11VNC_THREADS_NEW_FB_SLEEP
                       at various places in the do_new_fb() action.  This is to
                       let various activities settle.  Default is about 500ms.

                       Multiple clients in threaded mode could yield better
                       performance for 'class-room' broadcasting usage; also in
                       -appshare broadcast mode.  See also the -reflect option.

-fs f                  If the fraction of changed tiles in a poll is greater
                       than f, the whole screen is updated.  Default: 0.75
-gaps n                Heuristic to fill in gaps in rows or cols of n or
                       less tiles.  Used to improve text paging.  Default: 4
-grow n                Heuristic to grow islands of changed tiles n or wider
                       by checking the tile near the boundary.  Default: 3
-fuzz n                Tolerance in pixels to mark a tiles edges as changed.
                       Default: 2
-debug_tiles           Print debugging output for tiles, fb updates, etc.

-snapfb                Instead of polling the X display framebuffer (fb)
                       for changes, periodically copy all of X display fb
                       into main memory and examine that copy for changes.
                       (This setting also applies for non-X -rawfb modes).
                       Under some circumstances this will improve interactive
                       response, or at least make things look smoother, but in
                       others (most!) it will make the response worse.  If the
                       video h/w fb is such that reading small tiles is very
                       slow this mode could help.  To keep the "framerate"
                       up the screen size x bpp cannot be too large.  Note that
                       this mode is very wasteful of memory I/O resources
                       (it makes full screen copies even if nothing changes).
                       It may be of use in video capture-like applications,
                       webcams, or where window tearing is a problem.

-rawfb string          Instead of polling X, poll the memory object specified
                       in "string".

                       For file polling, to memory map mmap(2) a file use:
                       "map:/path/to/a/file@WxHxB", with framebuffer Width,
                       Height, and Bits per pixel.  "mmap:..." is the
                       same.

                       If there is trouble with mmap, use "file:/..."
                       for slower lseek(2) based reading.

                       Use "snap:..." to imply -snapfb mode and the "file:"
                       access (this is for unseekable devices that only provide
                       the fb all at once, e.g. a video camera provides the
                       whole frame).

                       For shared memory segments string is of the form:
                       "shm:N@WxHxB" which specifies a shmid N and with
                       WxHxB as above.  See shmat(1) and ipcs(1)

                       If you do not supply a type "map" is assumed if
                       the file exists (see the next paragraphs for some
                       exceptions to this.)

                       If string is "setup:cmd", then the command "cmd"
                       is run and the first line from it is read and used
                       as "string".  This allows initializing the device,
                       determining WxHxB, etc. These are often done as root
                       so take care.

                       If the string begins with "video", see the VIDEO4LINUX
                       discussion below where the device may be queried for
                       (and possibly set) the framebuffer parameters.

                       If the string begins with "console", "/dev/fb",
                       "fb", or "vt", see the LINUX CONSOLE discussion
                       below where the framebuffer device is opened and
                       keystrokes (and possibly mouse events) are inserted
                       into the console.

                       If the string begins with "vnc", see the VNC HOST
                       discussion below where the framebuffer is taken as that
                       of another remote VNC server.

                       Optional suffixes are ":R/G/B", "+O", and "#VWxVH" to
                       specify red, green, and blue masks (in hex), offset into
                       the memory object, and virtual width and height.

                       If the masks are not provided x11vnc guesses them based on
                       the bpp (if the colors look wrong, you need to provide the
                       masks.)

                       Another optional suffix is the Bytes Per Line which in
                       some cases is not WxB/8.  Specify it as WxHxB-BPL
                       e.g. 800x600x16-2048.  This could be a normal width
                       1024 at 16bpp fb, but only width 800 shows up.

                       The last optional suffix is virtual dimensions VWxVH. Some
                       devices will double buffer the display in the framebuffer,
                       allowing updating contents of display and then "panning"
                       to the buffer via yoffset. x11vnc will map the virutal
                       size specified by the options stead of just WxH, and track
                       yoffset appropriately so remote clients get all updates to
                       the frame buffer.

                       So the full format is: mode:file@WxHxB:R/G/B+O-BPL#VWxVH

                       Examples:
                           -rawfb shm:210337933@800x600x32:ff/ff00/ff0000
                           -rawfb map:/dev/fb0@1024x768x32
                           -rawfb map:/dev/fb0@800x480x16#800x960
                           -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232
                           -rawfb file:/tmp/my.pnm@250x200x24+37
                           -rawfb file:/dev/urandom@128x128x8
                           -rawfb snap:/dev/video0@320x240x24 -24to32
                           -rawfb video0
                           -rawfb video -pipeinput VID
                           -rawfb console
                           -rawfb vt2
                           -rawfb vnc:somehost:0

                       (see ipcs(1) and fbset(1) for the first two examples)

                       In general all user input is discarded by default (see
                       the -pipeinput option for how to use a helper program
                       to insert).  Most of the X11 (screen, keyboard, mouse)
                       options do not make sense and many will cause this
                       mode to crash, so please think twice before setting or
                       changing them in a running x11vnc.

                       If you DO NOT want x11vnc to close the X DISPLAY in
                       rawfb mode, prepend a "+" e.g. +file:/dev/fb0...
                       Keeping the display open enables the default
                       remote-control channel, which could be useful.
                       Alternatively, if you specify -noviewonly, then the
                       mouse and keyboard input are STILL sent to the X
                       display, this usage should be very rare, i.e. doing
                       something strange with /dev/fb0.

                       If the device is not "seekable" (e.g. webcam) try
                       reading it all at once in full snaps via the "snap:"
                       mode (note: this is a resource hog).  If you are using
                       file: or map: AND the device needs to be reopened for
                       *every* snapfb snapshot, set the environment variable:
                       SNAPFB_RAWFB_RESET=1 as well.

                       If you want x11vnc to dynamically transform a 24bpp
                       rawfb to 32bpp (note that this will be slower) also
                       supply the -24to32 option.  This would be useful for,
                       say, a video camera that delivers the pixel data as
                       24bpp packed RGB.  This is the default under "video"
                       mode if the bpp is 24.

                       Normally the bits per pixel, B, is 8, 16, or 32 (or
                       rarely 24), however there is also some support for
                       B < 8 (e.g. old graphics displays 4 bpp or 1 bpp).
                       In this case you certainly must supply the masks as
                       well: WxHxB:R/G/B.  The pixels will be padded out to
                       8 bpp using depth 8 truecolor.  The scheme currently
                       does not work with snap fb (ask if interested.) B=1
                       monochrome example: file:/dev/urandom@128x128x1:1/1/1
                       Some other like this are 128x128x2:3/3/3 128x128x4:7/7/7

                       For B < 8 framebuffers you can also set the env. var
                       RAWFB_CGA=1 to try a CGA mapping for B=4 (e.g. linux
                       vga16fb driver.)  Note with low bpp and/or resolution
                       VGA and VGA16 modes on the Linux console one's attempt
                       to export them via x11vnc can often be thwarted due to
                       special color palettes, pixel packings, and even video
                       painting buffering.  OTOH, often experimenting with the
                       RGB masks can yield something recognizable.

                       VIDEO4LINUX: on Linux some attempt is made to handle
                       video devices (webcams or TV tuners) automatically.
                       The idea is the WxHxB will be extracted from the
                       device itself.  So if you do not supply "@WxHxB...
                       parameters x11vnc will try to determine them.  It first
                       tries the v4l API if that support has been compiled in.
                       Otherwise it will run the v4l-info(1) external program
                       if it is available.

                       The simplest examples are "-rawfb video" and "-rawfb
                       video1" which imply the device file /dev/video and
                       /dev/video1, respectively.  You can also supply the
                       /dev if you like, e.g. "-rawfb /dev/video0"

                       Since the video capture device framebuffer usually
                       changes continuously (e.g. brightness fluctuations),
                       you may want to use the -wait, -slow_fb, or -defer
                       options to lower the "framerate" to cut down on
                       network VNC traffic.

                       A more sophisticated video device scheme allows
                       initializing the device's settings using:

                           -rawfb video:<settings>

                       The prefix could also be, as above, e.g. "video1:" to
                       specify the device file.  The v4l API must be available
                       for this to work.  Otherwise, you will need to try
                       to initialize the device with an external program,
                       e.g. xawtv, spcaview, and hope they persist when x11vnc
                       re-opens the device.

                       <settings> is a comma separated list of key=value pairs.
                       The device's brightness, color, contrast, and hue can
                       be set to percentages, e.g. br=80,co=50,cn=44,hu=60.

                       The device filename can be set too if needed (if it
                       does not start with "video"), e.g. fn=/dev/qcam.

                       The width, height and bpp of the framebuffer can be
                       set via, e.g., w=160,h=120,bpp=16.

                       Related to the bpp above, the pixel format can be set
                       via the fmt=XXX, where XXX can be one of: GREY, HI240,
                       RGB555, RGB565, RGB24, and RGB32 (with bpp 8, 8, 16, 16,
                       24, and 32 respectively).  See http://www.linuxtv.org
                       for more info (V4L api).

                       For TV/rf tuner cards one can set the tuning mode
                       via tun=XXX where XXX can be one of PAL, NTSC, SECAM,
                       or AUTO.

                       One can switch the input channel by the inp=XXX setting,
                       where XXX is the name of the input channel (Television,
                       Composite1, S-Video, etc).  Use the name that is in the
                       information about the device that is printed at startup.

                       For input channels with tuners (e.g. Television) one
                       can change which station is selected by the sta=XXX
                       setting.  XXX is the station number.  Currently only
                       the ntsc-cable-us (US cable) channels are built into
                       x11vnc.  See the -freqtab option below to supply one
                       from xawtv. If XXX is greater than 500, then it is
                       interpreted as a raw frequency in KHz.

                       Example:

                       -rawfb video:br=80,w=320,h=240,fmt=RGB32,tun=NTSC,sta=47

                       one might need to add inp=Television too for the input
                       channel to be TV if the card doesn't come up by default
                       in that one.

                       Note that not all video capture devices will support
                       all of the above settings.

                       See the -pipeinput VID option below for a way to control
                       the settings through the VNC Viewer via keystrokes.
                       As a shortcut, if the string begins "Video.." instead
                       of "video.." then -pipeinput VID is implied.

                       As above, if you specify a "@WxHxB..." after the
                       <settings> string they are used verbatim: the device
                       is not queried for the current values.  Otherwise the
                       device will be queried.

                       LINUX CONSOLE:  The following describes some ways to
                       view and possibly interact with the Linux text/graphics
                       console (i.e. not X11 XFree86/Xorg)

                       Note: If the LibVNCServer LinuxVNC program is on your
                       system you may want to use that instead of the following
                       method because it will be faster and more accurate
                       for the Linux text console and includes mouse support.
                       There is, however, the basic LinuxVNC functionality in
                       x11vnc if you replace "console" with "vt" in the
                       examples below.

                       If the rawfb string begins with "console" the
                       framebuffer device /dev/fb0 is opened and /dev/tty0 is
                       opened too.  The latter is used to inject keystrokes
                       (not all are supported, but the basic ones are).
                       You will need to be root to inject keystrokes, but
                       not necessarily to open /dev/fb0.  /dev/tty0 refers to
                       the active VT, to indicate one explicitly, use, e.g.,
                       "console2" for /dev/tty2, etc. by indicating the
                       specific VT number.

                       For the Linux framebuffer device, /dev/fb0, (fb1,
                       etc) to be enabled the appropriate kernel drivers must
                       be loaded.  E.g. vesafb or vga16fb and also by setting
                       the boot parameter vga=0x301 (or 0x314, 0x317, etc.)
                       (The vga=... method is the preferred way; set your
                       machines up that way.)  Otherwise there will be a
                       'No such device' error.  You can also load a Linux
                       framebuffer driver specific to your make of video card
                       for more functionality.  Once the machine is booted one
                       can often 'modprobe' the fb driver as root to obtain
                       a framebuffer device.

                       If you cannot get /dev/fb0 working on Linux, try
                       using the LinuxVNC emulation mode by "-rawfb vtN"
                       where N = 1, ... 6 is the Linux Virtual Terminal (aka
                       virtual console) you wish to view, e.g. "-rawfb vt2".
                       Unlike /dev/fb mode, it need not be the active Virtual
                       Terminal.  Note that this mode can only show text and
                       not graphics.  x11vnc polls the text in /dev/vcsaN

                       Set the env. var. RAWFB_VCSA_BW=1 to disable colors in
                       the "vtN" mode (i.e. black and white only.)  If you
                       do not prefer the default 16bpp set RAWFB_VCSA_BPP to
                       8 or 32.  If you need to tweak the rawfb parameters by
                       using the 'console_guess' string printed at startup,
                       be sure to indicate the snap: method.

                       uinput: If the Linux version appears to be 2.6
                       or later and the "uinput" module appears to be
                       present (modprobe uinput), then the uinput method
                       will be used instead of /dev/ttyN.  uinput allows
                       insertion of BOTH keystrokes and mouse input and so it
                       preferred when accessing graphical (e.g. QT-embedded)
                       linux console apps.  It also provides more accurate
                       keystroke insertion.  See -pipeinput UINPUT below for
                       more information on this mode; you will have to use
                       -pipeinput if you want to tweak any UINPUT parameters.
                       You may also want to also use the -nodragging and
                       -cursor none options.  Use "console0", etc  or
                       -pipeinput CONSOLE to force the /dev/ttyN method.

                       Note you can change the Linux VT remotely using the
                       chvt(1) command to make the one you want be the active
                       one (e.g. 'chvt 3').  Sometimes switching out and back
                       corrects the framebuffer's graphics state.  For the
                       "-rawfb vtN" mode there is no need to switch the VT's.

                       To skip input injecting entirely use "consolex"
                       or "vtx".

                       The string "/dev/fb0" (1, etc.) can be used instead
                       of "console".  This can be used to specify a different
                       framebuffer device, e.g. /dev/fb1.  As a shortcut the
                       "/dev/" can be dropped.  If the name is something
                       nonstandard, use "console:/dev/foofb"

                       If you do not want x11vnc to guess the framebuffer's
                       WxHxB and masks automatically (sometimes the kernel
                       gives incorrect information), specify them with a @WxHxB
                       (and optional :R/G/B masks) at the end of the string.

                       Examples:
                           -rawfb console
                           -rawfb /dev/fb0           (same)
                           -rawfb console3           (force /dev/tty3)
                           -rawfb consolex           (no keystrokes or mouse)
                           -rawfb console:/dev/nonstd
                           -rawfb console -pipeinput UINPUT:accel=4.0
                           -rawfb vt3                (/dev/tty3 w/o /dev/fb0)

                       VNC HOST: if the -rawfb string is of the form
                       "vnc:host:N" then the VNC display "N" on the remote
                       VNC server "host" is connected to (i.e. x11vnc acts as
                       a VNC client itself) and that framebuffer is exported.

                       This mode is really only of use if you are trying
                       to improve performance in the case of many (e.g. >
                       10) simultaneous VNC viewers, and you try a divide
                       and conquer scheme to reduce bandwidth and improve
                       responsiveness.  (However, another user found this mode
                       useful to export a demo display through a slow link:
                       then multiple demo viewers connected to the reflecting
                       x11vnc on the fast side of the link, and so avoided
                       all of the demo viewers going through the slow link.)

                       For example, if there will be 64 simultaneous VNC
                       viewers this can lead to a lot of redundant VNC traffic
                       to and from the server host:N, extra CPU usage,
                       and all viewers response can be reduced by having
                       to wait for writes to the slowest client to finish.
                       However, if you set up 8 reflectors/repeaters started
                       with option -rawfb vnc:host:N, then there are only
                       8 connections to host:N.  Each repeater then handles
                       8 vnc viewer connections thereby spreading the load
                       around.  In classroom broadcast usage, try to put the
                       repeaters on different switches.  This mode is the same
                       as -reflect host:N.  Replace "host:N" by "listen"
                       or "listen:port" for a reverse connection.

                       Overall performance will not be as good as a single
                       direct connection because, among other things,
                       there is an additional level of framebuffer polling
                       and pointer motion can still induce many changes per
                       second that must be propagated.  Tip: if the remote VNC
                       is x11vnc doing wireframing, or an X display that does
                       wireframing that gives much better response than opaque
                       window dragging.  Consider the -nodragging option if
                       the problem is severe.

                       The env. var. X11VNC_REFLECT_PASSWORD can be set to
                       the password needed to log into the vnc host server, or
                       to "file:path_to_file" to indicate a file containing
                       the password as its first line.

                       To set the pixel format that x11vnc requests as a VNC
                       CLIENT set the env. vars: X11VNC_REFLECT_bitsPerSample
                       X11VNC_REFLECT_samplesPerPixel, and
                       X11VNC_REFLECT_bytesPerPixel; the defaults are 8, 3, 4.
                       2, 3, 1 would give a low color mode.  See the function
                       rfbGetClient() in libvncclient for more info.

                       The VNC HOST mode implies -shared.  Use -noshared as
                       a subsequent cmdline option to disable sharing.

-freqtab file          For use with "-rawfb video" for TV tuner devices to
                       specify station frequencies.  Instead of using the built
                       in ntsc-cable-us mapping of station number to frequency,
                       use the data in file.  For stations that are not
                       numeric, e.g. SE20, they are placed above the highest
                       numbered station in the order they are found.  Example:
                       "-freqtab /usr/X11R6/share/xawtv/europe-west.list"
                       You can make your own freqtab by copying the xawtv
                       format.

-pipeinput cmd         This option lets you supply an external command in
                       "cmd" that x11vnc will pipe all of the user input
                       events to in a simple format.  In -pipeinput mode by
                       default x11vnc will not process any of the user input
                       events.  If you prefix "cmd" with "tee:" it will
                       both send them to the pipe command and process them.
                       For a description of the format run "-pipeinput
                       tee:/bin/cat".  Another prefix is "reopen" which
                       means to reopen pipe if it exits.  Separate multiple
                       prefixes with commas.

                       In combination with -rawfb one might be able to
                       do amusing things (e.g. control non-X devices).
                       To facilitate this, if -rawfb is in effect then the
                       value is stored in X11VNC_RAWFB_STR for the pipe command
                       to use if it wants. Do 'env | grep X11VNC' for more.

                       Built-in pipeinput modes (no external program required):

                       If cmd is "VID" and you are using the -rawfb for a
                       video capture device, then an internal list of keyboard
                       mappings is used to set parameters of the video.
                       The mappings are:

                         "B" and "b" adjust the brightness up and down.
                         "H" and "h" adjust the hue.
                         "C" and "c" adjust the colour.
                         "N" and "n" adjust the contrast.
                         "S" and "s" adjust the size of the capture screen.
                         "I" and "i" cycle through input channels.
                         Up and Down arrows adjust the station (if a tuner)
                         F1, F2, ..., F6 will switch the video capture pixel
                         format to HI240, RGB565, RGB24, RGB32, RGB555, and
                         GREY respectively.  See -rawfb video for details.

                       If cmd is "CONSOLE" or "CONSOLEn" where n
                       is a Linux console number, then the linux console
                       keystroke insertion to /dev/ttyN (see -rawfb console)
                       is performed.

                       If cmd begins with "UINPUT" then the Linux uinput
                       module is used to insert both keystroke and mouse events
                       to the Linux console (see -rawfb above).  This usually
                       is the /dev/input/uinput device file (you may need to
                       create it with "mknod /dev/input/uinput c 10 223"
                       and insert the module with "modprobe uinput".

                       The UINPUT mode currently only does US keyboards (a
                       scan code option may be added), and not all keysyms
                       are supported.  But it is probably more accurate than
                       the "CONSOLE" method.

                       You may want to use the options -cursor none and
                       -nodragging in this mode.

                       Additional tuning options may be supplied via:
                       UINPUT:opt1,opt2,... (a comma separated list). If an
                       option begins with "/" it is taken as the uinput
                       device file.

                       Which uinput is injected can be controlled by an option
                       string made of the characters "K", "M", and "B"
                       (see the -input option), e.g. "KM" allows keystroke
                       and motion but not button clicks.

                       A UINPUT option of the form: accel=f, or accel=fx+fy
                       sets the mouse motion "acceleration".  This is used
                       to correct raw mouse relative motion into how much the
                       application cursor moves (x11vnc has no control over,
                       or knowledge of how the windowing application interprets
                       the raw mouse motions).  Typically the acceleration
                       for an X display is 2 (see xset "m" option).  "f"
                       is a floating point number, e.g. 3.0.  Use "fx+fy"
                       if you need to supply different corrections for x and y.

                       Note: the default acceleration is 2.0 since it seems
                       both X and qt-embedded often (but not always) use
                       this value.

                       Even with a correct accel setting the mouse position
                       will get out of sync (probably due to a mouse
                       "threshold" setting where the acceleration doe not
                       apply, set xset(1)).  The option reset=N sets the
                       number of ms (default 150) after which the cursor is
                       attempted to be reset (by forcing the mouse to (0,
                       0) via small increments and then back out to (x, y)
                       in 1 jump), This correction seems to be needed but can
                       cause jerkiness or unexpected behavior with menus, etc.
                       Use reset=0 to disable.

                       If you set the env. var X11VNC_UINPUT_THRESHOLDS then
                       the thresh=n mode will be enabled.  It is currently
                       not working well.  If |dx| <= thresh and |dy| < thresh
                       no acceleration is applied.  Use "thresh=+n" |dx| +
                       |dy| < thresh to be used instead (X11?)

                       Example:
                           -pipeinput UINPUT:accel=4.0 -cursor none

                       If the uinput device has an absolute pointer (as opposed
                       to a normal mouse that is a relative pointer) you can
                       specify the option "abs".  Note that a touchpad
                       on a laptop is an absolute device to some degree.
                       This (usually) avoids all the problems with mouse
                       acceleration.  If x11vnc has trouble deducing the
                       size of the device, use "abs=WxH".  Furthermore,
                       if the device is a touchscreen (assumed to have an
                       absolute pointer) use "touch" or "touch=WxH".
                       For touchscreens, when a mouse button is pressed,
                       a pressure increase is injected, and when the button
                       is released a pressure of zero is injected.

                       If touch has been set, use "touch_always=1" to
                       indicate whenever the mouse moves with no button
                       pressed, a touch event of zero pressure should be
                       sent anyway.  Also use "btn_touch=1" to indicate a
                       BTN_TOUCH keystroke press or release should be sent
                       instead of a pressure change.  Set "dragskip=n" to
                       skip n dragged mouse touches (with pressure applied)
                       before injecting one.  To indicate the pressure that
                       should be sent when there is a button click for a
                       touchscreen device, specify pressure=n, e.g. n=5. The
                       default is n=1.

                       If a touch screen is being used ("touch" above)
                       and it is having its input processed by tslib, you can
                       specify the tslib calibration file via tslib_cal=<file>.
                       For example, tslib_cal=/etc/pointercal.  To get accurate
                       or even usable positioning this is required when tslib
                       is in use.

                       The Linux uinput mechanism can be bypassed and one can
                       write input events DIRECTLY to the devices instead.
                       To do this, specify one or more of the following
                       for the input classes: direct_rel=<device>
                       direct_abs=<device> direct_btn=<device> or
                       direct_key=<device>.  The <device> file is usually
                       something like /dev/input/event1 but you can specify
                       any device file or pipe.  You must specify each one
                       of the above classes even if they correspond to the
                       same device file (rel/abs and btn are often the same.)
                       Look at the file /proc/bus/input/devices to get an idea
                       what is available and the device filenames.  Note:
                       The /dev/input/mouse* devices do not seem to work,
                       use the corresponding /dev/input/event* file instead.
                       Any input class not directly specified as above will be
                       handled via the uinput mechanism.  To disable creating a
                       uinput device (and thereby discarding unhandled input),
                       specify "nouinput".

                       Examples:

                         -pipeinput UINPUT:direct_abs=/dev/input/event1

                       this was used on a qtmoko Neo freerunner (armel):

                         -pipeinput UINPUT:touch,tslib_cal=/etc/pointercal,
                          direct_abs=/dev/input/event1,nouinput,dragskip=4

                       (where the long line has been split into two.)

                       You can set the env. var X11VNC_UINPUT_DEBUG=1 or higher
                       to get debugging output for UINPUT mode.

-macnodim              For the native MacOSX server, disable dimming.
-macnosleep            For the native MacOSX server, disable display sleep.
-macnosaver            For the native MacOSX server, disable screensaver.
-macnowait             For the native MacOSX server, do not wait for the
                       user to switch back to his display.
-macwheel n            For the native MacOSX server, set the mouse wheel
                       speed to n (default 5).
-macnoswap             For the native MacOSX server, do not swap mouse
                       buttons 2 and 3.
-macnoresize           For the native MacOSX server, do not resize or reset
                       the framebuffer even if it is detected that the screen
                       resolution or depth has changed.
-maciconanim n         For the native MacOSX server, set n to the number
                       of milliseconds that the window iconify/deiconify
                       animation takes.  In -ncache mode this value will be
                       used to skip the animation if possible. (default 400)
-macmenu               For the native MacOSX server, in -ncache client-side
                       caching mode, try to cache pull down menus (not perfect
                       because they have animated fades, etc.)
-macuskbd              For the native MacOSX server, use the original
                       keystroke insertion code based on a US keyboard.
-macnoopengl           For the native MacOSX server, do not use OpenGL for
                       screen capture, but rather use the original, deprecated
                       raw memory access method: addr = CGDisplayBaseAddress().
-macnorawfb            For the native MacOSX server, disable the raw memory
                       address screen capture method.

                       MACOSX NOTE: There are some deprecated MacOSX interfaces
                       to inject keyboard and mouse events and the raw memory
                       access method is deprecated as well (however, OpenGL
                       will be preferred if available because it is faster.)
                       One can force not using any deprecated interfaces at
                       compile time by setting -DX11VNC_MACOSX_NO_DEPRECATED=1
                       in CPPFLAGS.  Or to turn them off one by one:
                       -DX11VNC_MACOSX_NO_DEPRECATED_LOCALEVENTS=1,
                       -DX11VNC_MACOSX_NO_DEPRECATED_POSTEVENTS=1 or
                       -DX11VNC_MACOSX_NO_DEPRECATED_FRAMEBUFFER=1
                       At run time, for testing and workarounds, one can
                       disable them by using:
                       -env X11VNC_MACOSX_NO_DEPRECATED=1
                       -env X11VNC_MACOSX_NO_DEPRECATED_LOCALEVENTS=1
                       -env X11VNC_MACOSX_NO_DEPRECATED_POSTEVENTS=1 or
                       -env X11VNC_MACOSX_NO_DEPRECATED_FRAMEBUFFER=1
                       Note: When doing either of these for the mouse input
                       not everything works currently, e.g. double clicks and
                       wireframing.  Also, screen resolution and pixel depth
                       changes will not be automatically detected unless the
                       deprecated framebuffer interfaces are allowed.

                       Conversely, if you are compiling on an
                       older machine that does not have some of
                       the newer interfaces, you may need to specify
                       -DX11VNC_MACOSX_NO_CGEVENTCREATESCROLLWHEELEVENT
                       -DX11VNC_MACOSX_NO_CGEVENTCREATEMOUSEEVENT or
                       -DX11VNC_MACOSX_NO_CGEVENTCREATEKEYBOARDEVENT.  Use
                       -DX11VNC_MACOSX_USE_GETMAINDEVICE to regain the very
                       old QuickDraw GetMainDevice() interface (rare...)

-gui [gui-opts]        Start up a simple tcl/tk gui based on the remote
                       control options -remote/-query described below.
                       Requires the "wish" program to be installed on the
                       machine.  "gui-opts" is not required: the default
                       is to start up both the full gui and x11vnc with the
                       gui showing up on the X display in the environment
                       variable DISPLAY.

                       "gui-opts" can be a comma separated list of items.
                       Currently there are these types of items: 1) a gui
                       mode, a 2) gui "simplicity", 3) the X display the
                       gui should display on, 4) a "tray" or "icon" mode,
                       and 5) a gui geometry.

                       1) The gui mode can be "start", "conn", or "wait"
                       "start" is the default mode above and is not required.
                       "conn" means do not automatically start up x11vnc,
                       but instead just try to connect to an existing x11vnc
                       process.  "wait" means just start the gui and nothing
                       else (you will later instruct the gui to start x11vnc
                       or connect to an existing one.)

                       2) The gui simplicity is off by default (a power-user
                       gui with all options is presented) To start with
                       something less daunting supply the string "simple"
                       ("ez" is an alias for this).  Once the gui is
                       started you can toggle between the two with "Misc ->
                       simple_gui".

                       3) Note the possible confusion regarding the potentially
                       two different X displays: x11vnc polls one, but you
                       may want the gui to appear on another.  For example, if
                       you ssh in and x11vnc is not running yet you may want
                       the gui to come back to you via your ssh redirected X
                       display (e.g. localhost:10).

                       If you do not specify a gui X display in "gui-opts"
                       then the DISPLAY environment variable and -display
                       option are tried (in that order).  Regarding the x11vnc
                       X display the gui will try to communication with, it
                       first tries -display and then DISPLAY.  For example,
                       "x11vnc -display :0 -gui otherhost:0", will remote
                       control an x11vnc polling :0 and display the gui on
                       otherhost:0 The "tray/icon" mode below reverses this
                       preference, preferring to display on the x11vnc display.

                       4) When "tray" or "icon" is specified, the gui
                       presents itself as a small icon with behavior typical
                       of a "system tray" or "dock applet".  The color
                       of the icon indicates status (connected clients) and
                       there is also a balloon status.  Clicking on the icon
                       gives a menu from which properties, etc, can be set and
                       the full gui is available under "Advanced".  To be
                       fully functional, the gui mode should be "start"
                       (the default).

                       Note that tray or icon mode will imply the -forever
                       x11vnc option (if the x11vnc server is started along
                       with the gui) unless -connect or -connect_or_exit has
                       been specified.  So x11vnc (and the tray/icon gui)
                       will wait for more connections after the first client
                       disconnects.  If you want only one viewer connection
                       include the -once option.

                       For "icon" the gui just a small standalone window.
                       For "tray" it will attempt to embed itself in the
                       "system tray" if possible. If "=setpass" is appended the
n
                       at startup the X11 user will be prompted to set the
                       VNC session password.  If =<hexnumber> is appended
                       that icon will attempt to embed itself in the window
                       given by hexnumber.  Use =noadvanced to disable the
                       full gui. (To supply more than one, use "+" sign).
                       E.g. -gui tray=setpass and -gui icon=0x3600028

                       Other modes: "full", the default and need not be
                       specified.  "-gui none", do not show a gui, useful
                       to override a ~/.x11vncrc setting, etc.

                       5) When "geom=+X+Y" is specified, that geometry
                       is passed to the gui toplevel.  This is the icon in
                       icon/tray mode, or the full gui otherwise.  You can
                       also specify width and height, i.e. WxH+X+Y, but it
                       is not recommended.  In "tray" mode the geometry is
                       ignored unless the system tray manager does not seem
                       to be running.  One could imagine using something like
                       "-gui tray,geom=+4000+4000" with a display manager
                       to keep the gui invisible until someone logs in...

                       More icon tricks, "icon=minimal" gives an icon just
                       with the VNC display number.  You can also set the font
                       with "iconfont=...".  The following could be useful:
                       "-gui icon=minimal,iconfont=5x8,geom=24x10+0-0"

                       General examples of the -gui option: "x11vnc -gui",
                       "x11vnc -gui ez" "x11vnc -gui localhost:10",
                       "x11vnc -gui conn,host:0", "x11vnc -gui tray,ez"
                       "x11vnc -gui tray=setpass"

                       If you do not intend to start x11vnc from the gui
                       (i.e. just remote control an existing one), then the
                       gui process can run on a different machine from the
                       x11vnc server as long as X permissions, etc. permit
                       communication between the two.

                       FONTS: On some systems the tk fonts can be too small,
                       jagged, or otherwise unreadable.  There are 4 env vars
                       you can set to be the tk font you prefer:

                       X11VNC_FONT_BOLD   main font for menus and buttons.
                       X11VNC_FONT_FIXED  font for fixed width text.

                       X11VNC_FONT_BOLD_SMALL  tray icon font.
                       X11VNC_FONT_REG_SMALL   tray icon menu font.

                       The last two only apply for the tray icon mode.

                       Here are some examples:

                       -env X11VNC_FONT_BOLD='Helvetica -16 bold'
                       -env X11VNC_FONT_FIXED='Courier -14'
                       -env X11VNC_FONT_REG_SMALL='Helvetica -12'

                       You can put the lines like the above (without the
                       quotes) in your ~/.x11vncrc file to avoid having to
                       specify them on the x11vnc command line.

-remote command        Remotely control some aspects of an already running
                       x11vnc server.  "-R" and "-r" are aliases for
                       "-remote".  After the remote control command is
                       sent to the running server the 'x11vnc -remote ...'
                       x11vnc command exits.  You can often use the -query
                       command (see below) to see if the x11vnc server
                       processed your -remote command.

                       The default communication channel is that of X
                       properties (specifically X11VNC_REMOTE), and so this
                       command must be run with correct settings for DISPLAY
                       and possibly XAUTHORITY to connect to the X server
                       and set the property.  Alternatively, use the -display
                       and -auth options to set them to the correct values.
                       The running server cannot use the -novncconnect option
                       because that disables the communication channel.
                       See below for alternate channels.

                       For example: 'x11vnc -remote stop' (which is the same as
                       'x11vnc -R stop') will close down the x11vnc server.
                       'x11vnc -R shared' will enable shared connections, and
                       'x11vnc -R scale:3/4' will rescale the desktop.

                       To use a different name for the X11 property (e.g. to
                       have separate communication channels for multiple
                       x11vnc's on the same display) set the X11VNC_REMOTE
                       environment variable to the string you want, for
                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345
                       Both sides of the channel must use the same unique name.

                       To run a bunch of commands in a sequence use something
                       like: x11vnc -R 'script:firstcmd;secondcmd;...'

                       Use x11vnc -R script:file=/path/to/file to read commands
                       from a file (can be multi-line and use the comment '#'
                       character in the normal way.  The ';' separator must
                       still be used to separate each command.)

                       To not try to contact another x11vnc process and instead
                       just run the command (or query) directly, prefix the
                       command with the string "DIRECT:"

                       The following -remote/-R commands are supported:

                       stop            terminate the server, same as "quit"
                                       "exit" or "shutdown".
                       ping            see if the x11vnc server responds.
                                       return is: ans=ping:<display>
                       ping:mystring   as above, but use your own unique string
.
                                       return is: ans=ping:mystring:<xdisplay>
                       blacken         try to push a black fb update to all
                                       clients (due to timings a client
                                       could miss it). Same as "zero", also
                                       "zero:x1,y1,x2,y2" for a rectangle.
                       refresh         send the entire fb to all clients.
                       reset           recreate the fb, polling memory, etc.
                       id:windowid     set -id window to "windowid". empty
                                       or "root" to go back to root window
                       sid:windowid    set -sid window to "windowid"
                       id_cmd:cmd      cmds: raise, lower, map, unmap, iconify,
                                       move:dXdY, resize:dWdH, geom:WxH+X+Y. dX
                                       dY, dW, and dH must have a leading "+"
                                       or "-" e.g.: move:-30+10 resize:+20+35
                                       also: wm_delete, wm_name:string and
                                       icon_name:string. Also id_cmd:win=N:cmd
                       waitmapped      wait until subwin is mapped.
                       nowaitmapped    do not wait until subwin is mapped.
                       clip:WxH+X+Y    set -clip mode to "WxH+X+Y"
                       flashcmap       enable  -flashcmap mode.
                       noflashcmap     disable -flashcmap mode.
                       shiftcmap:n     set -shiftcmap to n.
                       notruecolor     enable  -notruecolor mode.
                       truecolor       disable -notruecolor mode.
                       overlay         enable  -overlay mode (if applicable).
                       nooverlay       disable -overlay mode.
                       overlay_cursor  in -overlay mode, enable cursor drawing.
                       overlay_nocursor disable cursor drawing. same as
                                        nooverlay_cursor.
                       8to24           enable  -8to24 mode (if applicable).
                       no8to24         disable -8to24 mode.
                       8to24_opts:str  set the -8to24 opts to "str".
                       24to32          enable  -24to32 mode (if applicable).
                       no24to32        disable -24to32 mode.
                       visual:vis      set -visual to "vis"
                       scale:frac      set -scale to "frac"
                       scale_cursor:f  set -scale_cursor to "f"
                       viewonly        enable  -viewonly mode.
                       noviewonly      disable -viewonly mode.
                       shared          enable  -shared mode.
                       noshared        disable -shared mode.
                       forever         enable  -forever mode.
                       noforever       disable -forever mode.
                       timeout:n       reset -timeout to n, if there are
                                       currently no clients, exit unless one
                                       connects in the next n secs.
                       tightfilexfer   enable  filetransfer for NEW clients.
                       notightfilexfer disable filetransfer for NEW clients.
                       ultrafilexfer   enable  filetransfer for clients.
                       noultrafilexfer disable filetransfer for clients.
                       rfbversion:n.m  set -rfbversion for new clients.
                       http            enable  http client connections.
                       nohttp          disable http client connections.
                       deny            deny any new connections, same as "lock"
                       nodeny          allow new connections, same as "unlock"
                       avahi           enable  avahi service advertising.
                       noavahi         disable avahi service advertising.
                       mdns            enable  avahi service advertising.
                       nomdns          disable avahi service advertising.
                       zeroconf        enable  avahi service advertising.
                       nozeroconf      disable avahi service advertising.
                       connect:host    do reverse connection to host, "host"
                                       may be a comma separated list of hosts
                                       or host:ports.  See -connect.  Passwords
                                       required as with fwd connections.
                                       See X11VNC_REVERSE_CONNECTION_NO_AUTH=1
                       disconnect:host disconnect any clients from "host"
                                       same as "close:host".  Use host
                                       "all" to close all current clients.
                                       If you know the client internal hex ID,
                                       e.g. 0x3 (returned by "-query clients"
                                       and RFB_CLIENT_ID) you can use that too.
                       proxy:host:port set reverse connection proxy (empty to
                                       disable).
                       allowonce:host  For the next connection only, allow
                                       connection from "host". In -ssl mode
                                       two connections are allowed (i.e. Fetch
                                       Cert) unless X11VNC_NO_SSL_ALLOW_TWICE=1
                       allow:hostlist  set -allow list to (comma separated)
                                       "hostlist". See -allow and -localhost.
                                       Do not use with -allow /path/to/file
                                       Use "+host" to add a single host, and
                                       use "-host" to delete a single host
                       localhost       enable  -localhost mode
                       nolocalhost     disable -localhost mode
                       listen:str      set -listen to str, empty to disable.
                       noipv6          enable  -noipv6 mode.
                       ipv6            disable -noipv6 mode.
                       noipv4          enable  -noipv4 mode.
                       ipv4            disable -noipv4 mode.
                       6               enable  -6 IPv6 listening mode.
                       no6             disable -6 IPv6 listening mode.
                       lookup          disable -nolookup mode.
                       nolookup        enable  -nolookup mode.
                       lookup          disable -nolookup mode.
                       input:str       set -input to "str", empty to disable.
                       grabkbd         enable  -grabkbd mode.
                       nograbkbd       disable -grabkbd mode.
                       grabptr         enable  -grabptr mode.
                       nograbptr       disable -grabptr mode.
                       grabalways      enable  -grabalways mode.
                       nograbalways    disable -grabalways mode.
                       grablocal:n     set -grablocal to n.
                       client_input:str set the K, M, B -input on a per-client
                                       basis.  select which client as for
                                       disconnect, e.g. client_input:host:MB
                                       or client_input:0x2:K
                       accept:cmd      set -accept "cmd" (empty to disable).
                       afteraccept:cmd set -afteraccept (empty to disable).
                       gone:cmd        set -gone "cmd" (empty to disable).
                       noshm           enable  -noshm mode.
                       shm             disable -noshm mode (i.e. use shm).
                       flipbyteorder   enable -flipbyteorder mode, you may need
                                       to set noshm for this to do something.
                       noflipbyteorder disable -flipbyteorder mode.
                       onetile         enable  -onetile mode. (you may need to
                                       set shm for this to do something)
                       noonetile       disable -onetile mode.
                       solid           enable  -solid mode
                       nosolid         disable -solid mode.
                       solid_color:color set -solid color (and apply it).
                       blackout:str    set -blackout "str" (empty to disable).
                                       See -blackout for the form of "str"
                                       (basically: WxH+X+Y,...)
                                       Use "+WxH+X+Y" to append a single
                                       rectangle use "-WxH+X+Y" to delete one
                       xinerama        enable  -xinerama mode. (if applicable)
                       noxinerama      disable -xinerama mode.
                       xtrap           enable  -xtrap input mode(if applicable)
                       noxtrap         disable -xtrap input mode.
                       xrandr          enable  -xrandr mode. (if applicable)
                       noxrandr        disable -xrandr mode.
                       xrandr_mode:mode set the -xrandr mode to "mode".
                       rotate:mode     set the -rotate mode to "mode".
                       padgeom:WxH     set -padgeom to WxH (empty to disable)
                                       If WxH is "force" or "do" the padded
                                       geometry fb is immediately applied.
                       quiet           enable  -quiet mode.
                       noquiet         disable -quiet mode.
                       modtweak        enable  -modtweak mode.
                       nomodtweak      enable  -nomodtweak mode.
                       xkb             enable  -xkb modtweak mode.
                       noxkb           disable -xkb modtweak mode.
                       capslock        enable  -capslock mode.
                       nocapslock      disable -capslock mode.
                       skip_lockkeys   enable  -skip_lockkeys mode.
                       noskip_lockkeys disable -skip_lockkeys mode.
                       skip_keycodes:str enable -xkb -skip_keycodes "str".
                       sloppy_keys     enable  -sloppy_keys mode.
                       nosloppy_keys   disable -sloppy_keys mode.
                       skip_dups       enable  -skip_dups mode.
                       noskip_dups     disable -skip_dups mode.
                       add_keysyms     enable -add_keysyms mode.
                       noadd_keysyms   stop adding keysyms. those added will
                                       still be removed at exit.
                       clear_mods      enable  -clear_mods mode and clear them.
                       noclear_mods    disable -clear_mods mode.
                       clear_keys      enable  -clear_keys mode and clear them.
                       noclear_keys    disable -clear_keys mode.
                       clear_locks     do the clear_locks action.
                       clear_all       do the clear_all action.
                       keystate        have x11vnc print current keystate.
                       remap:str       set -remap "str" (empty to disable).
                                       See -remap for the form of "str"
                                       (basically: key1-key2,key3-key4,...)
                                       Use "+key1-key2" to append a single
                                       keymapping, use "-key1-key2" to delete.
                       norepeat        enable  -norepeat mode.
                       repeat          disable -norepeat mode.
                       nofb            enable  -nofb mode.
                       fb              disable -nofb mode.
                       bell            enable  bell (if supported).
                       nobell          disable bell.
                       sendbell        ring the bell now.
                       nosel           enable  -nosel mode.
                       sel             disable -nosel mode.
                       noprimary       enable  -noprimary mode.
                       primary         disable -noprimary mode.
                       nosetprimary    enable  -nosetprimary mode.
                       setprimary      disable -nosetprimary mode.
                       noclipboard     enable  -noclipboard mode.
                       clipboard       disable -noclipboard mode.
                       nosetclipboard  enable  -nosetclipboard mode.
                       setclipboard    disable -nosetclipboard mode.
                       seldir:str      set -seldir to "str"
                       resend_cutbuffer resend the most recent CUTBUFFER0 copy
                       resend_clipboard resend the most recent CLIPBOARD copy
                       resend_primary   resend the most recent PRIMARY copy
                       cursor:mode     enable  -cursor "mode".
                       show_cursor     enable  showing a cursor.
                       noshow_cursor   disable showing a cursor. (same as
                                       "nocursor")
                       cursor_drag     enable  cursor changes during drag.
                       nocursor_drag   disable cursor changes during drag.
                       arrow:n         set -arrow to alternate n.
                       xfixes          enable  xfixes cursor shape mode.
                       noxfixes        disable xfixes cursor shape mode.
                       alphacut:n      set -alphacut to n.
                       alphafrac:f     set -alphafrac to f.
                       alpharemove     enable  -alpharemove mode.
                       noalpharemove   disable -alpharemove mode.
                       alphablend      disable -noalphablend mode.
                       noalphablend    enable  -noalphablend mode.
                       cursorshape     disable -nocursorshape mode.
                       nocursorshape   enable  -nocursorshape mode.
                       cursorpos       disable -nocursorpos mode.
                       nocursorpos     enable  -nocursorpos mode.
                       xwarp           enable  -xwarppointer mode.
                       noxwarp         disable -xwarppointer mode.
                       always_inject   enable  -always_inject mode.
                       noalways_inject disable -always_inject mode.
                       buttonmap:str   set -buttonmap "str", empty to disable
                       dragging        disable -nodragging mode.
                       nodragging      enable  -nodragging mode.
                       ncache          reenable -ncache mode.
                       noncache        disable  -ncache mode.
                       ncache_size:n   set -ncache size to n.
                       ncache_cr       enable  -ncache_cr mode.
                       noncache_cr     disable -ncache_cr mode.
                       ncache_no_moveraise     enable  no_moveraise mode.
                       noncache_no_moveraise   disable no_moveraise mode.
                       ncache_no_dtchange      enable  ncache_no_dtchange mode.
                       noncache_no_dtchange    disable ncache_no_dtchange mode.
                       ncache_old_wm           enable  ncache_old_wm mode.
                       noncache_old_wm         disable ncache_old_wm mode.
                       ncache_no_rootpixmap    enable  ncache_no_rootpixmap.
                       noncache_no_rootpixmap  disable ncache_no_rootpixmap.
                       ncache_reset_rootpixmap recheck the root pixmap, ncrp
                       ncache_keep_anims       enable  ncache_keep_anims.
                       noncache_keep_anims     disable ncache_keep_anims.
                       ncache_pad:n    set -ncache_pad to n.
                       wireframe       enable  -wireframe mode. same as "wf"
                       nowireframe     disable -wireframe mode. same as "nowf"
                       wireframe:str   enable  -wireframe mode string.
                       wireframe_mode:str enable  -wireframe mode string.
                       wireframelocal  enable  wireframelocal. same as "wfl"
                       nowireframe     disable wireframelocal. same as "nowfl"
                       wirecopyrect:str set -wirecopyrect string. same as "wcr:
"
                       scrollcopyrect:str set -scrollcopyrect string. same "scr
"
                       noscrollcopyrect disable -scrollcopyrect mode. "noscr"
                       scr_area:n      set -scr_area to n
                       scr_skip:list   set -scr_skip to "list"
                       scr_inc:list    set -scr_inc to "list"
                       scr_keys:list   set -scr_keys to "list"
                       scr_term:list   set -scr_term to "list"
                       scr_keyrepeat:str set -scr_keyrepeat to "str"
                       scr_parms:str   set -scr_parms parameters.
                       fixscreen:str   set -fixscreen to "str".
                       noxrecord       disable all use of RECORD extension.
                       xrecord         enable  use of RECORD extension.
                       reset_record    reset RECORD extension (if avail.)
                       pointer_mode:n  set -pointer_mode to n. same as "pm"
                       input_skip:n    set -input_skip to n.
                       allinput        enable  use of -allinput mode.
                       noallinput      disable use of -allinput mode.
                       input_eagerly   enable  use of -input_eagerly mode.
                       noinput_eagerly disable use of -input_eagerly mode.
                       ssltimeout:n    set -ssltimeout to n.
                       speeds:str      set -speeds to str.
                       wmdt:str        set -wmdt to str.
                       debug_pointer   enable  -debug_pointer, same as "dp"
                       nodebug_pointer disable -debug_pointer, same as "nodp"
                       debug_keyboard   enable  -debug_keyboard, same as "dk"
                       nodebug_keyboard disable -debug_keyboard, same as "nodk"
                       keycode:n       inject keystroke 'keycode' (xmodmap -pk)
                       keycode:n,down  inject 'keycode' (down=0,1)
                       keysym:str      inject keystroke 'keysym' (number/name)
                       keysym:str,down inject 'keysym' (down=0,1)
                       ptr:x,y,mask    inject pointer event x, y, button-mask
                       fakebuttonevent:button,down direct XTestFakeButtonEvent.
                       sleep:t         sleep floating point time t.
                       get_xprop:p     get X property named 'p'.
                       set_xprop:p:val set X property named 'p' to 'val'.
                                       p -> id=NNN:p for hex/dec window id.
                       wininfo:id      get info about X window id.  use 'root'
                                       for root window, use +id for children.
                       grab_state      get state of pointer and keyboard grab.
                       pointer_pos     print XQueryPointer x,y cursor position.
                       pointer_x       print XQueryPointer x cursor position.
                       pointer_y       print XQueryPointer y cursor position.
                       pointer_same    print XQueryPointer ptr on same screen.
                       pointer_root    print XQueryPointer curr ptr rootwin.
                       pointer_mask    print XQueryPointer button and mods mask
                       mouse_x         print x11vnc's idea of cursor position.
                       mouse_y         print x11vnc's idea of cursor position.
                       noop            do nothing.
                       defer:n         set -defer to n ms,same as deferupdate:n
                       wait:n          set -wait to n ms.
                       extra_fbur:n    set -extra_fbur to n.
                       wait_ui:f       set -wait_ui factor to f.
                       setdefer:n      set -setdefer to -2,-1,0,1, or 2.
                       wait_bog        disable -nowait_bog mode.
                       nowait_bog      enable  -nowait_bog mode.
                       slow_fb:f       set -slow_fb to f seconds.
                       xrefresh:f      set -xrefresh to f seconds.
                       readtimeout:n   set read timeout to n seconds.
                       nap             enable  -nap mode.
                       nonap           disable -nap mode.
                       sb:n            set -sb to n s, same as screen_blank:n
                       fbpm            disable -nofbpm mode.
                       nofbpm          enable  -nofbpm mode.
                       dpms            disable -nodpms mode.
                       nodpms          enable  -nodpms mode.
                       forcedpms       enable  -forcedpms mode.
                       noforcedpms     disable -forcedpms mode.
                       clientdpms      enable  -clientdpms mode.
                       noclientdpms    disable -clientdpms mode.
                       noserverdpms    enable  -noserverdpms mode.
                       serverdpms      disable -noserverdpms mode.
                       noultraext      enable  -noultraext mode.
                       ultraext        disable -noultraext mode.
                       chatwindow      enable  local chatwindow mode.
                       nochatwindow    disable local chatwindow mode.
                       chaton          begin chat using local window.
                       chatoff         end   chat using local window.
                       xdamage         enable  xdamage polling hints.
                       noxdamage       disable xdamage polling hints.
                       xd_area:A       set -xd_area max pixel area to "A"
                       xd_mem:f        set -xd_mem remembrance to "f"
                       fs:frac         set -fs fraction to "frac", e.g. 0.5
                       gaps:n          set -gaps to n.
                       grow:n          set -grow to n.
                       fuzz:n          set -fuzz to n.
                       snapfb          enable  -snapfb mode.
                       nosnapfb        disable -snapfb mode.
                       rawfb:str       set -rawfb mode to "str".
                       uinput_accel:f  set uinput_accel to f.
                       uinput_thresh:n set uinput_thresh to n.
                       uinput_reset:n  set uinput_reset to n ms.
                       uinput_always:n set uinput_always to 1/0.
                       progressive:n   set LibVNCServer -progressive slice
                                       height parameter to n.
                       desktop:str     set -desktop name to str for new clients
.
                       rfbport:n       set -rfbport to n.
                       macnosaver      enable  -macnosaver mode.
                       macsaver        disable -macnosaver mode.
                       macnowait       enable  -macnowait  mode.
                       macwait         disable -macnowait  mode.
                       macwheel:n      set -macwheel to n.
                       macnoswap       enable  -macnoswap mouse button mode.
                       macswap         disable -macnoswap mouse button mode.
                       macnoresize     enable  -macnoresize mode.
                       macresize       disable -macnoresize mode.
                       maciconanim:n   set -maciconanim to n.
                       macmenu         enable  -macmenu  mode.
                       macnomenu       disable -macmenu  mode.
                       macuskbd        enable  -macuskbd mode.
                       macnouskbd      disable -macuskbd mode.
                       httpport:n      set -httpport to n.
                       httpdir:dir     set -httpdir to dir (and enable http).
                       enablehttpproxy   enable  -enablehttpproxy mode.
                       noenablehttpproxy disable -enablehttpproxy mode.
                       alwaysshared     enable  -alwaysshared mode.
                       noalwaysshared   disable -alwaysshared mode.
                                        (may interfere with other options)
                       nevershared      enable  -nevershared mode.
                       nonevershared    disable -nevershared mode.
                                        (may interfere with other options)
                       dontdisconnect   enable  -dontdisconnect mode.
                       nodontdisconnect disable -dontdisconnect mode.
                                        (may interfere with other options)
                       debug_xevents   enable  debugging X events.
                       nodebug_xevents disable debugging X events.
                       debug_xdamage   enable  debugging X DAMAGE mechanism.
                       nodebug_xdamage disable debugging X DAMAGE mechanism.
                       debug_wireframe enable   debugging wireframe mechanism.
                       nodebug_wireframe disable debugging wireframe mechanism.
                       debug_scroll    enable  debugging scrollcopy mechanism.
                       nodebug_scroll  disable debugging scrollcopy mechanism.
                       debug_tiles     enable  -debug_tiles
                       nodebug_tiles   disable -debug_tiles
                       debug_grabs     enable  -debug_grabs
                       nodebug_grabs   disable -debug_grabs
                       debug_sel       enable  -debug_sel
                       nodebug_sel     disable -debug_sel
                       debug_ncache    enable  -debug_ncache
                       nodebug_ncache  disable -debug_ncache
                       dbg             enable  -dbg crash shell
                       nodbg           disable -dbg crash shell

                       noremote        disable the -remote command processing,
                                       it cannot be turned back on.

                       bcx_xattach:str  This remote control command is for
                       use with the BARCO xattach program or the x2x program.
                       Both of these programs are for 'pointer and keyboard'
                       sharing between separate X displays.  In general the
                       two displays are usually nearby, e.g. on the same desk,
                       and this allows the user to share a single pointer and
                       keyboard between them.  The user moves the mouse to
                       an edge and then the mouse pointer appears to 'jump'
                       to the other display screen.  Thus it emulates what a
                       single X server would do for two screens (e.g. :0.0 and
                       :0.1) The illusion of a single Xserver with multiple
                       screens is achieved by forwarding events to the 2nd
                       one via the XTEST extension.

                       What the x11vnc bcx_xattach command does is to perform
                       some pointer movements to try to INDUCE xattach/x2x
                       to 'jump' to the other display.  In what follows the
                       'master' display refers to the one that when it has
                       'focus' it is basically doing nothing besides watching
                       for the mouse to go over an edge.  The 'slave'
                       display refers to the one to which the mouse and
                       keyboard is redirected to once an edge in the master
                       has been crossed.  Note that the x11vnc executing the
                       bcx_xattach command MUST be the one connected to the
                       *master* display.

                       Also note that when input is being redirected (via
                       XTEST) from the master display to the slave display,
                       the master display's pointer and keyboard are *grabbed*
                       by xattach/x2x.  x11vnc can use this info to verify that
                       the master/slave mode change has taken place correctly.
                       If you specify the "ifneeded" option (see below)
                       and the initial grab state is that of the desired
                       final state, then no pointer movements are injected
                       and "DONE,GRAB_OK" is returned.

                       "str" must contain one of "up", "down", "left",
                       or "right" to indicate the direction of the 'jump'.
                       "str" must also contain one of "master_to_slave"
                       or "slave_to_master" to indicate the type of mode
                       change induced by the jump.  Use "M2S" and "S2M"
                       as shorter aliases.

                       "str" may be a "+" separated list of additional
                       tuning options.  The "shift=n" option indicates an
                       offset shift position away from (0,0) (default 20).
                       "final=x+y" specifies the final position of the cursor
                       at the end of the normal move sequence; default 30+30.
                       "extra_move=x+y" means to do one more pointer move
                       after "final" to x+y.  "dt=n" sets the sleep time
                       in milliseconds between pointer moves (default: 40ms)
                       "retry=n" specifies the maximum number of retries if
                       the grab state change fails. "ifneeded" means to not
                       apply the pointer movements if the initial grab state is
                       that of the desired final state. "nograbcheck" means
                       to not check if the grab state changed as expected and
                       only apply the pointer movements (default is to check
                       the grab states.)

                       If you do not specify "up", etc., to bcx_xattach
                       nothing will be attempted and the command returns
                       the string FAIL,NO_DIRECTION_SPECIFIED.  If you do
                       not specify "master_to_slave" or "M2S", etc., to
                       bcx_xattach nothing will be attempted and the command
                       returns the string FAIL,NO_MODE_CHANGE_SPECIFIED.

                       Otherwise, the returned string will contain "DONE".
                       It will be "DONE,GRAB_OK" if the grab state changed
                       as expected (or if "ifneeded" was supplied and
                       the initial grab state was already the desired
                       one.)  If the initial grab state was incorrect,
                       but the final grab state was correct then it is
                       "DONE,GRAB_FAIL_INIT".  If the initial grab state
                       was correct, but the final grab state was incorrect
                       then it is "DONE,GRAB_FAIL_FINAL".  If both are
                       incorrect it will be "DONE,GRAB_FAIL".  Under grab
                       failure the string will be followed by ":p1,k1-p2,k2"
                       where  p1,k1 indicates the initial pointer and keyboard
                       grab states and p2,k2 the final ones. If GRAB_FAIL or
                       GRAB_FAIL_FINAL occurs, the action will be retried up
                       to 3 times; trying to reset the state and sleeping a
                       bit between each try.  Set retry=n to adjust the number
                       of retries, zero to disable retries.

                       Examples:
                           -R bcx_xattach:down+M2S
                           -R bcx_xattach:up+S2M
                           -R bcx_xattach:up+S2M+nograbcheck+dt=30
                           -R bcx_xattach:down+M2S+extra_move=100+100

                       or use -Q instead of -R to retrieve the result text.

                       End of the bcx_xattach:str description.

                       The vncconnect(1) command from standard VNC
                       distributions may also be used if string is prefixed
                       with "cmd=" E.g. 'vncconnect cmd=stop'.  Under some
                       circumstances xprop(1) can used if it supports -set
                       (see the FAQ).

                       If "-connect /path/to/file" has been supplied to the
                       running x11vnc server then that file can be used as a
                       communication channel (this is the only way to remote
                       control one of many x11vnc's polling the same X display)
                       Simply run: 'x11vnc -connect /path/to/file -remote ...'
                       or you can directly write to the file via something
                       like: "echo cmd=stop > /path/to/file", etc.

-query variable        Like -remote, except just query the value of
                       "variable".  "-Q" is an alias for "-query".
                       Multiple queries can be done by separating variables
                       by commas, e.g. -query var1,var2. The results come
                       back in the form ans=var1:value1,ans=var2:value2,...
                       to the standard output.  If a variable is read-only,
                       it comes back with prefix "aro=" instead of "ans=".

                       Some -remote commands are pure actions that do not make
                       sense as variables, e.g. "stop" or "disconnect", in
                       these cases the value returned is "N/A".  To direct a
                       query straight to the X11VNC_REMOTE property or connect
                       file use "qry=..." instead of "cmd=..."

                       ans= stop quit exit shutdown ping resend_cutbuffer
                       resend_clipboard resend_primary blacken zero refresh
                       reset close disconnect id_cmd id sid waitmapped
                       nowaitmapped clip flashcmap noflashcmap shiftcmap
                       truecolor notruecolor overlay nooverlay overlay_cursor
                       overlay_yescursor nooverlay_nocursor nooverlay_cursor
                       nooverlay_yescursor overlay_nocursor 8to24 no8to24
                       8to24_opts 24to32 no24to32 visual scale scale_cursor
                       viewonly noviewonly shared noshared forever noforever
                       once timeout tightfilexfer notightfilexfer ultrafilexfer
                       noultrafilexfer rfbversion deny lock nodeny unlock avahi
                       mdns zeroconf noavahi nomdns nozeroconf connect proxy
                       allowonce allow noipv6 ipv6 noipv4 ipv4 no6 6 localhost
                       nolocalhost listen lookup nolookup accept afteraccept
                       gone shm noshm flipbyteorder noflipbyteorder onetile
                       noonetile solid_color solid nosolid blackout xinerama
                       noxinerama xtrap noxtrap xrandr noxrandr xrandr_mode
                       rotate padgeom quiet q noquiet modtweak nomodtweak xkb
                       noxkb capslock nocapslock skip_lockkeys noskip_lockkeys
                       skip_keycodes sloppy_keys nosloppy_keys skip_dups
                       noskip_dups add_keysyms noadd_keysyms clear_mods
                       noclear_mods clear_keys noclear_keys clear_all
                       clear_locks keystate remap repeat norepeat fb nofb bell
                       nobell sendbell sel nosel primary noprimary setprimary
                       nosetprimary clipboard noclipboard setclipboard
                       nosetclipboard seldir cursorshape nocursorshape
                       cursorpos nocursorpos cursor_drag nocursor_drag cursor
                       show_cursor noshow_cursor nocursor arrow xfixes noxfixes
                       xdamage noxdamage xd_area xd_mem alphacut alphafrac
                       alpharemove noalpharemove alphablend noalphablend
                       xwarppointer xwarp noxwarppointer noxwarp always_inject
                       noalways_inject buttonmap dragging nodragging ncache_cr
                       noncache_cr ncache_no_moveraise noncache_no_moveraise
                       ncache_no_dtchange noncache_no_dtchange
                       ncache_no_rootpixmap noncache_no_rootpixmap
                       ncache_reset_rootpixmap ncrp ncache_keep_anims
                       noncache_keep_anims ncache_old_wm noncache_old_wm
                       ncache_pad ncache noncache ncache_size debug_ncache
                       nodebug_ncache wireframe_mode wireframe wf nowireframe
                       nowf wireframelocal wfl nowireframelocal nowfl
                       wirecopyrect wcr nowirecopyrect nowcr scr_area
                       scr_skip scr_inc scr_keys scr_term scr_keyrepeat
                       scr_parms scrollcopyrect scr noscrollcopyrect
                       noscr fixscreen noxrecord xrecord reset_record
                       pointer_mode pm input_skip allinput noallinput
                       input_eagerly noinput_eagerly input grabkbd nograbkbd
                       grabptr nograbptr grabalways nograbalways grablocal
                       client_input ssltimeout speeds wmdt debug_pointer dp
                       nodebug_pointer nodp debug_keyboard dk nodebug_keyboard
                       nodk keycode keysym ptr fakebuttonevent sleep get_xprop
                       set_xprop wininfo bcx_xattach deferupdate defer
                       setdefer extra_fbur wait_ui wait_bog nowait_bog
                       slow_fb xrefresh wait readtimeout nap nonap sb
                       screen_blank fbpm nofbpm dpms nodpms clientdpms
                       noclientdpms forcedpms noforcedpms noserverdpms
                       serverdpms noultraext ultraext chatwindow nochatwindow
                       chaton chatoff fs gaps grow fuzz snapfb nosnapfb
                       rawfb uinput_accel uinput_thresh uinput_reset
                       uinput_always progressive rfbport http nohttp httpport
                       httpdir enablehttpproxy noenablehttpproxy alwaysshared
                       noalwaysshared nevershared noalwaysshared dontdisconnect
                       nodontdisconnect desktop debug_xevents nodebug_xevents
                       debug_xevents debug_xdamage nodebug_xdamage
                       debug_xdamage debug_wireframe nodebug_wireframe
                       debug_wireframe debug_scroll nodebug_scroll debug_scroll
                       debug_tiles dbt nodebug_tiles nodbt debug_tiles
                       debug_grabs nodebug_grabs debug_sel nodebug_sel dbg
                       nodbg macnosaver macsaver nomacnosaver macnowait macwait
                       nomacnowait macwheel macnoswap macswap nomacnoswap
                       macnoresize macresize nomacnoresize maciconanim macmenu
                       macnomenu nomacmenu macuskbd nomacuskbd noremote

                       aro=  noop display vncdisplay icon_mode autoport
                       loop loopbg desktopname guess_desktop guess_dbus
                       http_url auth xauth users rootshift clipshift scale_str
                       scaled_x scaled_y scale_numer scale_denom scale_fac_x
                       scale_fac_y scaling_blend scaling_nomult4 scaling_pad
                       scaling_interpolate inetd privremote unsafe safer nocmds
                       passwdfile unixpw unixpw_nis unixpw_list ssl ssl_pem
                       sslverify stunnel stunnel_pem https httpsredir usepw
                       using_shm logfile o flag rmflag rc norc h help V version
                       lastmod bg sigpipe threads readrate netrate netlatency
                       pipeinput clients client_count pid ext_xtest ext_xtrap
                       ext_xrecord ext_xkb ext_xshm ext_xinerama ext_overlay
                       ext_xfixes ext_xdamage ext_xrandr rootwin num_buttons
                       button_mask mouse_x mouse_y grab_state pointer_pos
                       pointer_x pointer_y pointer_same pointer_root
                       pointer_mask bpp depth indexed_color dpy_x dpy_y wdpy_x
                       wdpy_y off_x off_y cdpy_x cdpy_y coff_x coff_y rfbauth
                       passwd viewpasswd

-QD variable           Just like -query variable, but returns the default
                       value for that parameter (no running x11vnc server
                       is consulted)

-sync                  By default -remote commands are run asynchronously, that
                       is, the request is posted and the program immediately
                       exits.  Use -sync to have the program wait for an
                       acknowledgement from the x11vnc server that command was
                       processed (somehow).  On the other hand -query requests
                       are always processed synchronously because they have
                       to wait for the answer.

                       Also note that if both -remote and -query requests are
                       supplied on the command line, the -remote is processed
                       first (synchronously: no need for -sync), and then
                       the -query request is processed in the normal way.
                       This allows for a reliable way to see if the -remote
                       command was processed by querying for any new settings.
                       Note however that there is timeout of a few seconds
                       (see the next paragraph) so if the x11vnc takes longer
                       than that to process the requests the requester will
                       think that a failure has taken place.

                       The default is to wait 3.5 seconds.  Or if cmd=stop
                       only 1.0 seconds.  If cmd matches 'script:' then it
                       will wait up to 10.0 seconds.  Set X11VNC_SYNC_TIMEOUT
                       to the number of seconds you want it to wait.

-query_retries str     If a query fails to get a response from an x11vnc
                       server, retry up to n times.  "str" is specified as
                       n[:t][/match]  Optionally the delay between tries may
                       be specified by "t" a floating point time (default
                       0.5 seconds.)  Note: the response is not checked for
                       validity or whether it corresponds to the query sent.
                       The query "ping:mystring" may be used to help uniquely
                       identify the query.  Optionally, a matching string after
                       a "/" will be used to check the result text.  Up to
                       n retries will take place until the matching string is
                       found in the output text.  If the match string is never
                       found the program's exit code is 1; if the match is
                       found it exits with 0.  Note that there may be stdout
                       printed for each retry (i.e. multiple lines printed
                       out to stdout.)
                       Example: -query_retries 4:1.5/grab_state

-remote_prefix str     Enable a remote-control communication channel for
                       connected VNC clients.  str is a non-empty string. If a
                       VNC client sends rfbCutText having the prefix "str"
                       then the part after it is processed as though it were
                       sent via 'x11vnc -remote ...'.  If it begins with
                       neither 'cmd=' nor 'qry=' then 'qry=' is assumed.
                       Any corresponding output text for that remote control
                       command is sent back to all client as rfbCutText.
                       The returned output is also prefixed with "str".
                       Example: -remote_prefix DO_THIS:

                       Note that enabling -remote_prefix allows the remote
                       VNC viewers to run x11vnc -remote commands.  Do not
                       use this option if they are not to be trusted.

-noremote              Do not process any remote control commands or queries.
-yesremote             Do process remote control commands or queries.
                       Default: -yesremote

                       A note about security wrt remote control commands.
                       If someone can connect to the X display and change
                       the property X11VNC_REMOTE, then they can remotely
                       control x11vnc.  Normally access to the X display is
                       protected.  Note that if they can modify X11VNC_REMOTE
                       on the X server, they have enough permissions to also
                       run their own x11vnc and thus have complete control
                       of the desktop.  If the  "-connect /path/to/file"
                       channel is being used, obviously anyone who can write
                       to /path/to/file can remotely control x11vnc.  So be
                       sure to protect the X display and that file's write
                       permissions.  See -privremote below.

                       If you are paranoid and do not think -noremote is
                       enough, to disable the X11VNC_REMOTE property channel
                       completely use -novncconnect, or use the -safer option
                       that shuts many things off.

-unsafe                A few remote commands are disabled by default
                       (currently: id:pick, accept:<cmd>, gone:<cmd>, and
                       rawfb:setup:<cmd>) because they are associated with
                       running external programs.  If you specify -unsafe, then
                       these remote-control commands are allowed.  Note that
                       you can still specify these parameters on the command
                       line, they just cannot be invoked via remote-control.
-safer                 Equivalent to: -novncconnect -noremote and prohibiting
                       -gui and the -connect file. Shuts off communcation
                       channels.
-privremote            Perform some sanity checks and disable remote-control
                       commands if it appears that the X DISPLAY and/or
                       connectfile can be accessed by other users.  Once
                       remote-control is disabled it cannot be turned back on.
-nocmds                No external commands (e.g. system(3), popen(3), exec(3))
                       will be run at all.
-allowedcmds list      "list" contains a comma separated list of the only
                       external commands that can be run.  The full list of
                       associated options is:

                        stunnel, ssl, unixpw, WAIT, zeroconf, id, accept,
                        afteraccept, gone, pipeinput, v4l-info, rawfb-setup,
                        dt, gui, ssh, storepasswd, passwdfile, custom_passwd,
                        findauth, crash.

                       See each option's help to learn the associated external
                       command.  Note that the -nocmds option takes precedence
                       and disables all external commands.

-deny_all              For use with -remote nodeny: start out denying all
                       incoming clients until "-remote nodeny" is used to
                       let them in.



These options are passed to LibVNCServer:

-rfbport port          TCP port for RFB protocol
-rfbwait time          max time in ms to wait for RFB client
-rfbauth passwd-file   use authentication on RFB protocol
                       (use 'storepasswd' to create a password file)
-rfbversion 3.x        Set the version of the RFB we choose to advertise
-permitfiletransfer    permit file transfer support
-passwd plain-password use authentication
                       (use plain-password as password, USE AT YOUR RISK)
-deferupdate time      time in ms to defer updates (default 40)
-deferptrupdate time   time in ms to defer pointer updates (default none)
-desktop name          VNC desktop name (default "LibVNCServer")
-alwaysshared          always treat new clients as shared
-nevershared           never treat new clients as shared
-dontdisconnect        don't disconnect existing clients when a new non-shared
                       connection comes in (refuse new connection instead)
-httpdir dir-path      enable http server using dir-path home
-httpport portnum      use portnum for http connection
-enablehttpproxy       enable http proxy support
-progressive height    enable progressive updating for slow links
-listen ipaddr         listen for connections only on network interface with
                       addr ipaddr. '-listen localhost' and hostname work too.

libvncserver-tight-extension options:
-disablefiletransfer   disable file transfer
-ftproot string        set ftp root

   Pretty wild huh? Contact me if you have any questions or problems.

   Personally, I use:
x11vnc -rfbauth $HOME/.vnc/passwd -solid
