/*  $Id$
 *
 *  Copyright (C) 2003 Choe Hwanjin(krisna@kldp.org)
 *  Copyright (c) 2006 Remco den Breeje <remco@sx.mine.nu>
 *  Copyright (c) 2008 Diego Ongaro <ongardie@gmail.com>
 *  Copyright (C) 2020 David Vachulka <arch_dvx@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __DXREMINDERS_H__
#define __DXREMINDERS_H__

G_BEGIN_DECLS

/* enums */
enum {
    DATE = 0,
    TIME
};

/* typedefs */
typedef enum
{
    LAYOUT_DATE_TIME = 0,
    LAYOUT_TIME_DATE,
    LAYOUT_DATE,
    LAYOUT_TIME,
    LAYOUT_COUNT
} dx_layout;

/* plugin structure */
typedef struct
{
    XfcePanelPlugin *plugin;
    /* panel widgets */
    GtkWidget *button;
    GtkWidget *box;
    GtkWidget *date_label;
    GtkWidget *time_label;
    guint timeout_id;
    guint tooltip_timeout_id;
    gulong tooltip_handler_id;
    /* settings */
    gchar *date_font;
    gchar *time_font;
    gchar *date_format;
    gchar *time_format;
    dx_layout layout;
    gboolean calendar;
    gboolean silentmode;
    GtkWidget *silentcheck;
    /* option widgets */
    GtkWidget *date_frame;
    GtkWidget *date_tooltip_label;
    GtkWidget *date_font_hbox;
    GtkWidget *date_font_selector;
    GtkWidget *date_format_combobox;
    GtkWidget *date_format_entry;
    GtkWidget *time_frame;
    GtkWidget *time_tooltip_label;
    GtkWidget *time_font_hbox;
    GtkWidget *time_font_selector;
    GtkWidget *time_format_combobox;
    GtkWidget *time_format_entry;
    /* dxreminders values */
    gchar *tooltip;
    gulong pid;
    int sd;
}
dxremindersPlugin;

gboolean dxreminders_update(dxremindersPlugin *dxreminders);
gchar *dxreminders_do_utf8strftime(const char *format, GDateTime *dt);
void dxreminders_apply_font(dxremindersPlugin *dxreminders, const gchar *date_font_name, const gchar *time_font_name);
void dxreminders_apply_format(dxremindersPlugin *dxreminders, const gchar *date_format, const gchar *time_format);
void dxreminders_apply_layout(dxremindersPlugin *dxreminders, dx_layout layout);
void dxreminders_save(XfcePanelPlugin *plugin, dxremindersPlugin *dxreminders);

G_END_DECLS

#endif /* !__DXREMINDERS_H__ */
