# Submitting Documentation

There are three types of documentation

- **Library programmer's manual**: we [​use doxygen and document the functions](https://grass.osgeo.org/programming8/)
  directly in the source code. See lib/gis/\*.c and lib/gis/gislib.dox for examples

- **User manual**: each command ("module") comes with its own page. We write it
  in simple HTML, storing the manual in a file `'<module>.html'` within the
  subdirectory of the module. See below for details on the structure.

- **Python documentation**: written in Markdown which is compiled with Sphinx
  (see [​PyGRASS documentation](https://grass.osgeo.org/grass-stable/manuals/libpython/pygrass_index.html))

## HTML Pages

The manual pages are not only fundamental for the users but also the
"business card" of the respective module. An ideal page comes with clear
descriptions, hints on the implemented algorithm and example(s).

- Note: Do not upload broken or even empty HTML manual pages. This breaks things
  in various places.
- To avoid the insertion of overly complicated HTML tags (see also below), we
  strongly suggest to use a plain text editor rather than a HTML editor for
  editing.

Important: The HTML file contains **no header nor footer**. The complete HTML
file is autogenerated during the compilation process (indeed, it is generated
in a virtual session directly after compilation of the module). In this virtual
session the module is called internally with --html-description which generates
the parameters/flags list in HTML format, along with `'<module>.html'`, HTML
header and footer the final HTML manual page is created and stored in the target
binaries directory. In a separate process, the MAN format is generated from the
complete HTML files. In order to make sure that manuals build without issues, it
can be useful to validate the HTML before submitting, e.g. here:
[​https://validator.w3.org/](https://validator.w3.org/)

### Module Manual Pages

Place the documentation in HTML format into `'<module>.html'`, where `<module>`
is the name of the module. E.g. if the module is named r.example, the
documentation file should be named r.example.html.

The easiest way to do this is to study an existing HTML page (to get the page
style, e.g. [​vector/v.to.db/v.to.db.html](https://github.com/OSGeo/grass/blob/main/vector/v.to.db/v.to.db.html)
[manual](https://grass.osgeo.org/grass-stable/manuals/v.to.db.html)). With a few
exceptions, header and footer are NOT allowed. You can add figures (PNG format);
the figure name prefix should be the module name. See
[​raster/r.terraflow/r.terraflow.html](https://github.com/OSGeo/grass/blob/main/raster/r.terraflow/r.terraflow.html)
([manual](https://grass.osgeo.org/grass-stable/manuals/r.terraflow.html)) for
an example.

A number of major sections should be present in each help page.

R = Required
S = Suggested
O = Optional

In recommended order (in bold the required entries):

```html
**R: <h2>DESCRIPTION</h2>**
S: <h2>NOTE</H2>, <h2>NOTES</h2>
S: <h2>EXAMPLE</h2>, <h2>EXAMPLES</h2>
O: <h2>TODO</h2>
O: <h2>KNOWN ISSUES</h2>
O: <h2>REFERENCE</h2>, <h2>REFERENCES</h2>
**R: <h2>SEE ALSO</h2>**
**R: <h2>AUTHOR</h2>, <h2>AUTHORS</h2>**
```

Note that the parameter manual section is auto-generated upon compilation. This
is done by running the module in a virtual session after compilation (see the
output of 'make'). To subsequently verify the final HTML page, check the
resulting HTML pages which will be stored with the name of the module.

Examples (please add some more) should be coded like this:

```html
<div class="code"><pre>
v.to.db map=soils type=area option=area column=area_size unit=h
</pre></div>
```

The [​online WWW manual pages](https://grass.osgeo.org/grass-stable/manuals/) are
updated daily (from GitHub repository).

### Supported HTML Tags

Since the MAN conversion of g.html2man is limited, please use no other HTML
tags than:

```html
<a> <b> <body> <br> <code> <dd> <dl> <dt> <em>
<h2> <h3> <h4> <head> <hr> <i> <img> <li> <ol> <p>
<pre> <sup> <table> <td> <th> <title> <tr> <ul>
```

- Note that all tags have a closing tag except for `<hr>`, `<br>` and `<p>`.
- Use lower case forms.
- Do not insert `<p>` after `<h2>...</h2>` or `<h3>...</h3>`

Note that HTML is converted to MAN pages by [tools/g.html2man/](https://trac.osgeo.org/grass/browser/grass/trunk/tools/g.html2man)

### Markup style guide

- Module names (i.e., v.category) should be emphasized with `<em>module</em>`.
- Flags and parameter names written in boldface like `<b>-f</b>` and `<b>input</b>`.
- Shell commands, names, values, etc. should use `<tt>42</tt>`.
- Emphasized phrases `<i>should use italics</i>`.

The `<h2>SEE ALSO</h2>` section of each page should also be alphabetized.

### Footer

No footer to be added, since it will be added automatically during compilation.

### Break long lines

In order to minimize potential git merge conflicts, please break a line
at approximately 70-80 chars.

Hints:

- "geany" editor can format a paragraph with CTRL-j
- "atom" can do that as well
- "kate": activate it in Settings -> Kate -> Editing -> General -> enable static
  word-wrap, set 72

## Images

Naming convention: `module_name.png` or `module_name_keyword.png` (in both
cases, dots in module name are replaced by underscores)

Examples:

- `d_geodesic.png`
- `r_resamp_stats_6m_20m.png`
- `g_gui_rlisetup_8.png`
- `v_clean_rmsa.png`

Image size: ideally **600 pixel width** (height depends on that), use
e.g. ImageMagic:

```bash
mogrify -resize 600x file.png
```

Smaller images are also possible when appropriate, e.g. when a lot of images
are included or they are something special, e.g. equations, icons or simple
diagrams. Larger images are supported, too, see below for an optimal inclusion
into the HTML page.

Please **compress** PNG images with:

```bash
# color quantization
# optional, but usually worth it
# note: may change colors
pngnq -n 128 -s 3 file.png

# shuffle original and quantitized image names
mv file.png file_ORIG.png
mv file-nq8.png file.png

# compress better (lossless)
optipng -o5 file.png
```

See helper script
[source:grass-addons/tools/svn-image.sh](https://trac.osgeo.org/grass/browser/grass-addons/tools/svn-image.sh).

Format: Images should be ideally in PNG (well, JPG and GIF is allowed as well
when appropriate but usually it is not!). Vector graphics should be included in
pages as raster images (i.e. PNGs) for portability but the original format
(preferably SVG) should be committed to the repository as well.

Adding the image to the HTML page (r.viewshed example, the screenshot is shown
with a width of 600 pixel but it is clickable in the manual page). If a larger
image is displayed as shrunk, both **width** and **height** HTML parameters
(values must be calculated according to the picture size!) should be set:

```html
<div align="center" style="margin: 10px">
<a href="r_viewshed.png">
<img src="r_viewshed.png" width="600" height="600" alt="r.viewshed example" border="0">
</a><br>
<i>Figure: Viewshed shown on shaded terrain (observer position in the north-east
quadrant with white dot; 5m above ground)</i>
</div>
```

## Wording

When writing documentation, honor existing terminologies, names, and wording
as they are used in GRASS GIS. Obviously, the current state is not perfect or
completely consistent, so if you identify problems, discuss them with the
community and provide suggestions and reasoning for the new wording. If you
are an experienced GRASS GIS user, keep in mind new users and their first-time
experience with GRASS GIS and their experience with other software. If you are
a new user of GRASS GIS, keep in mind current users and stability of "GRASS GIS
approach." If new terminologies, not used in GRASS GIS before are needed, please
refer first to OGC and OSGeo projects, especially GDAL and PROJ.

For example, use "module" not "function" (means something different in
programming), "tool" (OK, but too general), "program" (does not cover usage
from GUI where it is a dialog), "script" (implementation detail), or "procedure"
(uncommon in this context and similar to workflow) when talking about the
individual executables. The word "command" is applicable when talking about
what is being executed in the command line.

To applicable extent, this applies also to source code comments, user-visible
messages and strings, debug messages, APIs, and naming of concepts in general.
