--TEST--
Hash: FNV1a64 algorithm
--FILE--
<?php

$tests = array(
    array( '9', 'af63b44c8601a894' ),
    array( 'w', 'af63ea4c86020456' ),
    array( 'v', 'af63eb4c86020609' ),
    array( 'Q', 'af640c4c86023e1c' ),
    array( 'd', 'af63d94c8601e773' ),
    array( '"e', '07cc2f07b4942580' ),
    array( 'pl', '08d53c07b5755019' ),
    array( '@L', '090c3c07b5a49289' ),
    array( '"N', '07cc5a07b4946e91' ),
    array( '&O', '07bf3907b489ac22' ),
    array( 'KE:', '50d8ad19d18c8505' ),
    array( '",u', 'd511f317d88f429a' ),
    array( 'RX7', 'a0549119ff001600' ),
    array( '/<i', 'eea15a17e6ea5bbd' ),
    array( 'Otx', '2ffdc919bf72be52' ),
    array( 'w/qn', '9c6e50f771dcafd0' ),
    array( 'aVqG', '4f1788838c1bcf9e' ),
    array( 'G^hs', '33551d7dbbea0209' ),
    array( 'a7z1', '4389ab82f4d6a7d0' ),
    array( 'c@Lf', 'c14b5591800f1338' ),
    array( 'MB:&Y', 'beb09d1ee59646d5' ),
    array( 'ICDy9', '4f05ddd19c2c2285' ),
    array( '>qH0a', '370b9a8e5a2329eb' ),
    array( '*fSR/', 'f78a85007841cb19' ),
    array( '3;$tS', '94b935103cc08938' ),
    array( ' \'7AS}', 'd81e3aef0fde6ad8' ),
    array( 'ou9vPc', '549f05284ed347f7' ),
    array( ':u]S4O', '31b0206c95a52e7d' ),
    array( '{D2\',e', '3a68240ea9539e62' ),
    array( 'Y;yt@n', 'afdae733c98065a2' ),
    array( 'IAu`bI_', 'c311eb3e8f9f51c4' ),
    array( 'R@xIq]d', '3fa1984555c55e46' ),
    array( 'g;8{k5@', '9e9c5e80cdc3d58e' ),
    array( '}<Ldvh^', 'e5be53f31a393f34' ),
    array( 'k*N6KDw', '558fdadc82fbb9d4' ),
    array( '/nWb0Q-"', '84fcc8959c773b75' ),
    array( '/qiK+e7@', 'd177962e1def962a' ),
    array( '\'5]SzT=Z', 'befb197ea3aac960' ),
    array( 'AH)WsNO$', '63dcf1c6c88d5426' ),
    array( '=(fNZsPj', '806bfb067d62da41' ),
    array( 'f:6q!M3(c', '5125f3e296d40b42' ),
    array( 'p\\^Fz:gCC', 'b9ffcd384d90ba98' ),
    array( '@7qp<0x#^', '1da17e378a5f0686' ),
    array( 'Tw/?^JUQL', '85f6d1938d45b818' ),
    array( '#dTfU2F|-', 'b66e4e092e385394' ),
    array( '`dP%&hvv%(', '84523fb38ca2975d' ),
    array( 'p)fE!vd`B;', '9c94c2a34d9f95c3' ),
    array( '2n>vD&MVMJ', '1f4fd77c72b6004b' ),
    array( 'd//546~,-$', '159ef268adc718d9' ),
    array( '4~.{E/s*p6', '31a60e2db942bc67' ),
    array( 'F#&dyJkG!:q', '33b8c68aed55c285' ),
    array( 'eI"{^9zjG  ', 'b42c013a2028584a' ),
    array( 'F/|k>pv/(=3', '671c9537b41d76fe' ),
    array( '.#-XoUZ*HAT', '84e0630a952577f4' ),
    array( 'K>4d:~-: SI', '57deb72cc24c6bad' ),
    array( '|@hn8xvV,%Y:', '157fda2502fe1297' ),
    array( '^Jp:T9\\*ez>K', 'f784c17d1a2d1bd2' ),
    array( '5>XP>-z<Mc,f', '6084bce050682a8b' ),
    array( ']#=j)w&hBv#w', '7a2da4d0b1c01e1e' ),
    array( '1_"vZ@Bp_{A}', 'e1e8fb095e4709fd' ),
    array( ')<;W!G>^K\\JTT', 'dd737d6771e9cd69' ),
    array( 'P>vGAoX"qP]3s', '0375e65060074988' ),
    array( 'Nrooqy-.Q.Upm', '135d77993c647f43' ),
    array( '"M8W"huy18ij:', 'aedeb2565e1c29f7' ),
    array( '\\;wo0Gb!8UzEc', '59ae633a0b17a945' ),
    array( 'LS:=B<kZtmDjhU', '2b2e674d9a46a36c' ),
    array( '$S@>0\\7 l^cmw:', 'f21c8cb206540a2e' ),
    array( 'h=}6q8T4U@nJ/3', 'b258eae8a4671c77' ),
    array( '6wi:L*Y\\gp]UPB', 'bff5f2c9ed84bce5' ),
    array( 'CH\\-fZDXsxlJ9\\', '298d4e05d5a47c45' ),
    array( 'uIp,BZFne!KMr*#', '8641dfc04c9fb552' ),
    array( 'CLGl)USdy-Yry$-', '3ab1497c481f22ab' ),
    array( 'WyVH\'y#NhhO57B?', '8dea1d032c597f60' ),
    array( ';fkbSt8(Z264&09', '4b875649e7cfa1a9' ),
    array( '4g3k1:e4iN}9c6[', 'd33acc8fe01b77fd' ),
    array( '$QBo4veM @`6UgGn', 'c4b17749dca1aa6a' ),
    array( '{0#gA>MV(|TAaj}e', '067ae9cfff2cd6ea' ),
    array( '=AVR8< 9]aO3Iw#E', '02bad50d48a8e564' ),
    array( '(&-JD[!LYVm<Bl#_', 'ec868a84ae92c032' ),
    array( '.Y2Gv3`Tt1h>)kd2', '9f7776edcdaf2937' ),
    array( 'qq]6N_c)7REY?H:M"', '1899eee357e747b4' ),
    array( 'Mtx`VNVg7uq#Z%uMc', '8eb7e5a4bb9fb739' ),
    array( '-{Cp%ZCK5ctO2v}\'p', '58ebf399369565ce' ),
    array( '^^@6GW,9[f?Q4#^1G', '76ab1ea61d68a738' ),
    array( 'P7#tb9XWhjOgrAGQa', '29294a2d4b758119' ),
    array( ']x9i3uPSGeW\'v~W.#L', '508d3356f8ec886b' ),
    array( 'p<&I&pxmd:57{r06\\D', '4660b5543de2afdc' ),
    array( ',.wTsO[jO4xSajog4u', '6d85fca5fba07683' ),
    array( 'Y.c?HyVElg\\J,hY%>N', '01e82905c1f66c8f' ),
    array( 'Uy:&/4Yq~IZ4@5B%Tk', 'a05cc808b297050e' ),
    array( '~+1lrm8 Wr&uA[p[a!o', '22783c7a8fbe4826' ),
    array( '<roeM$\'bG,73+CDx731', 'e00ac9dc3812b301' ),
    array( '7j$>aFyS#\\TsxGc_uhf', 'a8cfc6804bc24e1d' ),
    array( 'X0rpD~5iwL|*dh/#KU|', '17b538fc3a531c98' ),
    array( '~YZSMS{14qzzK,n=PmR', '47a7dd2be021ae55' ),
    array( ':f 8pd!!hMWeL1A!^u|p', '4c9d34c81b647804' ),
    array( '*ol&<xtZIb-dJ.|<r~=[', '7d8483384e8a46c8' ),
    array( 'LuBx\'dzfZwXehEk%>`_h', '25484f299d38dc95' ),
    array( 'DmMn{K+oKILw?oqGTl/0', '8ecc9d0f58ead225' ),
    array( 'eguN-bTLC55h$cX!0cq[', 'b3e4439d186da97b' ),
    array( '.?TN/Fvd4&uznlJ{O~Is5', '983efebee9945885' ),
    array( '_\\9C5;Sy-0)LdW[,NAAU7', 'c01a00203768a32c' ),
    array( '<D%fATfjH{K&6n;QC6^T?', 'ef488311549372ed' ),
    array( '+9wgEG*g}B$BGjd{QPEN{', '2c57de61c289de00' ),
    array( 'Kdkg6/~uc>"}7jD^t,\\80', 'f83a6970b348b383' ),
    array( ' _{e\\N6#|2Nb~7y/6orUrq', '26006911a7c5d137' ),
    array( 'l]6LRC)jS*KPo)~&,{9Z^9', 'd848d0547a41bac1' ),
    array( 'rXH)I;^<.KyExMh"9=-em|', 'ad7ca21d760bab1f' ),
    array( 'nl$zh>UHWH" RL<1hJ]coV', '87be1c6aab3568a9' ),
    array( '2XYKuf1cd Qhz;\'Qc^zf^M', 'fcb5e375b267b232' ),
    array( '3z_|F>`6usoP?e8QJ|R{fM7', 'd6cd721ef468a686' ),
    array( 'm {Mzc-Iv(*tOIVe@JVpj=*', '5ea4e77a701e1fd9' ),
    array( '<g\'ndm=|\\=y*9]7cU@nJp9"', '256fbcae5dc6e749' ),
    array( 'VYL.K7KUT4]DyLav*~p49OL', '55e66fa9c0b7f691' ),
    array( '}%mlP^&R6` D,8pbl%A1~ms', '1d260b7fec06fa81' ),
    array( 'vwsg--8Z,=Ixn) A?`BdlZVP', '1ac9ffbeaf2ceff1' ),
    array( 'H[qZ[_NRXC;fQSA]qjV`sW#4', 'fcd1a44f1f9644d7' ),
    array( '8Ey&!PVJ-H%i)T=bwXII-j( ', '20541ecba873cbbb' ),
    array( 'V^`K6d`O+ZU,,,W:U\\$_2BB+', '817f942d64cdf041' ),
    array( 'zlU)W])/=j[SP<$[wYh%f@@=', '8a852332f2c99373' ),
    array( '}E|0g@<b-qleOuumaQA2nFnf ', 'f817c2a8dc3cac28' ),
    array( 'Wlgw-%uR#\':DC}R5j8ea/SDau', 'be35effdcebfb5bc' ),
    array( 'VP<E8=}%%u2+le/s S8}&Ni?4', '31a4b812c4ec4d45' ),
    array( 'LOhp1_Ga|my;k~Ab2LOw\\Cx1[', '21bc5ceca29e51b8' ),
    array( 'w7*aW?/() 9hHzf6u"#uCe(p5', 'de09593ecddfbfad' ),
    array( '!MYz^5rv@UO`dWidpS-l:Db=GY', 'ba497ffae361581a' ),
    array( 'a-bRCc!|_`3RWS)(5n`~TRSa?n', '7d6da8683f44e043' ),
    array( '\'#,O]m\\@A!%B}d$18\\eAdz0Ezd', '964a554b2ea62312' ),
    array( 'xOG9>O<K~y:\\;\\]@ [%$l=`S_E', 'a6d30ae05805da81' ),
    array( 'OokJUez}~9M;eL6!)Q]fq]Bwa0', '52a0a33924a1e495' ),
    array( '5Bdth4eU_;;Z9:tgVZ4m[=@:%3w', '4e3d8a502aad23d1' ),
    array( 'H+YYA|>7fR|<39XmSsb;K>P9ymY', 'a30084c8ebfe7959' ),
    array( '5sl-<xgv:d5RLhOh{iBi=6MYak*', 'e4a386d2c4782f99' ),
    array( '{fxU{lC**=q!XW7+$ Zm|E0gcG5', '19e6ce2e2493a78b' ),
    array( '=*"H&iA\\f/!p:>b<v;S"?T].Q#?', '226c52cdff2324cb' ),
    array( ':ffP%pSMw=oT$ Uu:sYVkt+m5_KC', '08df2d276c9a057a' ),
    array( '2OcL7J}<<Qj4nZisZ?iu4DL 9WmO', 'f02866cab6af3d35' ),
    array( '8:sJjWw"#u>@H)T7d>,@^v6r;crU', 'ef8377919e2a1bad' ),
    array( '<a&T|y gRxiUo)v83LPwk\\9JTO>o', '99a9a1a21c2ee2ec' ),
    array( '31FOsL%pG%Yz}CQnMH\'`tWY`5r+i', '887cd200603d7a11' ),
    array( 'BJZV["&PN+Bv1{q0@C~mk\'Oa_*Bt|', 'faad097477f65bd7' ),
    array( 'N_@x:wU=}&l*Ic<EVLfyLUfS&H30k', '26a5acae427f26a8' ),
    array( '(.:hN4$FiAEp.P:ql`I:GCf|+:$TM', 'bfe197dd01c4279a' ),
    array( '4@VB[@qoD8Ze^Ks/ff|G07oT}m`9q', '60dffddf1fd785eb' ),
    array( '5g&V>I2_;#$T]j3*^CqF@:WX*-Vxm', '05994a3217bb26d8' ),
    array( 'oj#WqZv;lWVp[,OF?Y&cLM%f%]q24j', '151f45373d53bd27' ),
    array( '!%U$]H_UcL-;>iGm0gH7KtdP\\i.N|C', '0b91af28a642cac4' ),
    array( '9}Io#(8b]|0k8NU`=fIe}t[bF8MUfJ', 'fd58c24dc342b56c' ),
    array( 'y ICoML(0+%Av>pM .4Is2?OufhC<O', '199280a86e05b101' ),
    array( 'n6O8Z?f\'Hw2N9*m*Wn9k9.~Y^t@G9]', '732c4bf03e824fe5' ),
    array( 'v(tFAPf(W0 j^:uMDM<^:Vl90K/PrH/', 'ad49c5c4b29581d8' ),
    array( 'jQ$1rTx{-*{xi7n7\\=T;X+(r;T"lHK{', '74f8023eb53a4c87' ),
    array( '3|!EpV?lcIi]3!LK]j xC,"6HW85 d2', '45f93db9ecbd61e2' ),
    array( '4a4YSjy@NC+,V,Y#jE#dh/f~W?8m?}!', '628239fa1e9fbf4c' ),
    array( 'T_5/3 )TOL_\\$l7\'W\\+<E;$ErC^ac\\b', 'c4d6aab371c199b4' ),
    array( '8=xGQyP&I}f&"S>*+z6GAQLfDoF\'S#jk', '97ef2b6a27cfe08b' ),
    array( '@c3q]dx(b_/e3Mp?H\'gjX4Q}$w%X{pE<', '8a65a0d9c497dca7' ),
    array( 'TY/3>(;"hJg{wY<A`$,:8^8=W>vS/<pd', '7d99f135b9dd392a' ),
    array( 'u w4)46r^~nWX,x:0%TIdmg<,^o<z`"p', 'a3296f83b9d4178e' ),
    array( 'az%k/<^m<NEtZ?0kDd5*R|F_[6|Ww~HZ', '6971ed23982e966c' ),
    array( 'yNG)j&w\'U>|1]-|#r3-E0S&lj$Db#m>}<', 'b3fb4982abc0e4c0' ),
    array( 'e(\'l!/C?-T|:Q -d.SuaZcM^)1bvOa36i', '031098cfb4e50d1f' ),
    array( ';$jKG+X{(sN)"48U+z1oHoxYSo*5$@ ?D', 'd2ee11dc187ad41e' ),
    array( 'kjlvDi 89*:MBpY="IfrB@G3J\\7k\\W1HB', 'fee80db84822febc' ),
    array( '}@gh@ "K:Pm,*,.Tr"w4I+_\'CKcz]->\\N', '849ddd5ac8830991' ),
    array( '&En&G;Aw*M#6\\W*_O?)[~0~Kty)#9eQ?+A', '58f765bdd716e1c2' ),
    array( 'FS\\hLf6O}s\')SWH]3Hn3sc.|gGc:go[/C9', '1ef7be10e1e94525' ),
    array( 'wo!/@ #H)W R54z$GnhVlP}QkfAGueamVc', 'fb192bd95f5f88b2' ),
    array( '|vc!?mX?@mT<r|+\\Sx.RJy9lB/R$})h{ L', '3f2604691e2ced49' ),
    array( '|?;U_[D4x81%te}#8I}Q6@ahE_q.[r[Y3v', 'cb8807aabe087372' ),
    array( '/rST(Ll:Qb Pf8yej0&LyL-lZi_6Cs.Sga(', '4c6bc9be092660cd' ),
    array( 'o/u+aY,2@D-&0>-\\8Yj&5TeLxZZLB=T3MK>', '9207d0b883378aaa' ),
    array( '/%JBFoOM n[]\'5H-K}swvORCqpx%>EDNKnp', '34c18ad3e2030b27' ),
    array( 'q_A@_0{>82gF]e:V]j*!\\zza:@&hkuZ^U{ ', 'ff47e63839babc22' ),
    array( '6,|UD/=jm$&DapOcNJ^0e 7Nl.*Ld&Lz3IP', '8fc04f6e48534104' ),
    array( 'WYnCGrJlT<<8jgw{Mx4|eB\'2\'._#A)SybC>+', '444cf38629f9f5e6' ),
    array( '6hxk&5$p}|lKu!I\\DQoK_ON!X#{<G:H]#AI*', '93be8d30fbf2a711' ),
    array( 'WNzUKh"BjL~/}o[]?+_x.[6Vu^4y ^$X- .Y', '0457576f79c1af9f' ),
    array( 'h1{T]{c[k?:+Ky%ZV;1MzEHz$MT1Mbk7sgkR', '60d5a7492fab7ad1' ),
    array( 'dP.PpH\\<Cbvz}(HxNqtS?Iem-Q%":qT~CcP4', '0005d93c99685bc1' ),
    array( '-.QPpIKoRth!f^U\');t7ly9\'ln\'0RWE_ew1VA', 'e13bf2cdf312dd7b' ),
    array( ']FsR0u:oKAxg61U1J\\~9d0l<UL#N]Zo;"dn3[', '53d2c531034cdde3' ),
    array( '*#\'K|ob.EsY#rsg$`%Y.((lcx(e]wx9"|ANy1', 'e16aa67d2eb4115b' ),
    array( '1)V%bYxVB}8GWFP`34Z<z95tS7qtek\'wt^}X9', '5511e58643ea102a' ),
    array( 'w/[uH$NnU0#jj?e$TZWlLMS9UK/4IgNAw+7@0', 'c03ee6776b09be84' ),
    array( 'e0eu3PaS7f)r?v?lJYCvhXAP\'bI3ziCaz)X.Z:', '6e63e154ba982b2f' ),
    array( 'bq!kd@c%.._R&H+Gy3+CG&.jh)tA8P[zC]g)~K', 'd191830ad78ef4b4' ),
    array( '..Zn``7l(2 3VG:e3#o)D(Y!$|_k&^85lr$MT<', '7aa3d56eb663566f' ),
    array( ':]O;p&c,lv0\\ UdZVhW6U^umtbax066KsefelK', 'ea574dd4514d7c68' ),
    array( 'qYB#6CX{~0dVF;6=)+ j%1"<\\u"D[ooNI3Q`W+', '58f171ded41e0193' ),
    array( '\\V;B.b^D gP SV1VrnLu4)f$W18*qo5OGPrU3Qz', '11baf93d39928abd' ),
    array( '4:L4n#FEv5rmJ{TOTeg^XXt( EzVYLRmg #V$I{', '0ac0c936f7521a28' ),
    array( 'z_nh*k>Y@$B~\\zte{:`St.\'cu\'fL+1I\'q9p{%/V', '1a0c38f41c1826e8' ),
    array( 'E4yEpu:WqU8FJGM/=Uvja(4hyMYvSiNx}H>o?YH', '75024234e0476c05' ),
    array( '2/`XZ(\'jF\\a1?iF(dtb\\HM+BLTa<t;d\'KF_\'Ogq', 'bdcaffa418ba3eda' ),
    array( 'vES(d>Om#EP`n}l1JBsg70M>[t~bDfU;-)DqGt_K', 'bda836f33c0092dc' ),
    array( ':1-)0y;Z</CS?pq{eq^+Y4Gf>lYfa:2|K?&\\:B7V', '16e6a228513a03c4' ),
    array( 'QZ+qL}m3oM?Ibf1!Tjh6&z4R;;/V]F-0"8#O6pc\'', 'd272ca04df7d0554' ),
    array( '?#P"jb$?MlVThj\'%&6[d]it`#w19itA)wr,bU1##', 'c1b2b80d012bdf50' ),
    array( '}ZXgE_lLvI1T3\'67 GQi<rs5e!x;2|?1Wwx}WfJN', 'bdd12a4f05766cfe' ),
    array( '1\\$Ed;\\dc.O !D6fE/#X,Bic:carJ-B\\jG"Ob^4Fl', '9667031dfb5a16c7' ),
    array( 'dGm)^UOmX(zzq_6VB)"PK^;s`jV? },dFzn%Q>s*G', '166ff835024396df' ),
    array( 'n&:O=pqGrBsQ^g2J>RJ=_0c[ i->]8eL?!|\\qo$e3', 'bd73d9e41ae5c6d8' ),
    array( 'w7q_J<~|g=]w!9wjF7I^}v}~s[pc_VvXnh9:&87mV', '81bed0679537a583' ),
    array( 'ueW/^CUul5tc4sXoe<P=4*,}CF$\\^q3TXjd8/;.|P', '823ceb765e67c7a8' ),
    array( '#aew:U]W\'{k1(iTOm1/`Dd:0JR@ea>6e {]:R<qZ8^', '3d7194b6e03cc23b' ),
    array( 'kAHAq7S"wxf3*1eJvGh.-h+j$^(v9@U&b~GT7zV0s>', '01e47424ff38f337' ),
    array( 'C}P)IHP3V]|bI!BQx[rOaUO*+f&bvz!:yQDCzuVRTT', '55e116dfbdeaffb3' ),
    array( '5}VWPO4D vzO!&7(h.#jI|=nA8dxj9M 8$XhTm.Td)', '5ccd76496410ea5e' ),
    array( '%f0<nxKrcup!d2:J,%cZ&{^^e4Lsi2}nx.,h\'X[kOM', '99b5ca1d7ad80276' ),
    array( 'm5`(_l.DG4@\'s\';A{%SytM("60[r|+@jA!s"n"F77g>', '42c09c31678d6f41' ),
    array( '+nZLj`!dUNmXe}4Yz@zfb|[dk^+#urB!a|NM^P25 !m', '7c2bc1c66d9f0223' ),
    array( 'e~#?zD:a\'8=l${w(qkKsNIC{(s/=t0,Z0/z+T6l\\N+I', '8b024f00082671f5' ),
    array( 'S\'B\\y/(n]Q3ZY(jv|{$W,3S8hi&E91ol92I3BR# $6[', 'f90f149aea3b4fff' ),
    array( ']?FU<BZtOmHgW3m}M m:9!dMC7QD<h y(GPDj+:;yc#', '216ea9a72de9aadc' ),
    array( 'RwqPEr>`,@EZc],)yt*t|QFB<R\\WMA[ 9NQ^Ao?N1e)u', '9a53a5fdb4a3fea9' ),
    array( 'C5~>*)4([ZJw-(P[I-[b\\-A}}aM/GV&kl%+w/? jyJc(', '7a9e26e4aeb98fc9' ),
    array( 'R5c|B@_~N"}McK\\,#cxpi%hxDhd?3HHf^,c!MD!{F I+', '4f0136432df156d5' ),
    array( 'L\'8Oj1@U6)N[r4z\'\\Cm;PR=}v?z>?EIkLa;8s\\m+f=fZ', 'c2587023e1d5b660' ),
    array( 'Qaa/&PKV#iTz)P9Huc4CFP\\:-KEth,O;n1JtavKe`!ai', '50683e95eabc367d' ),
    array( 'R{2H_Fl\'vIA%tgy^tJyd\\EY><&%}(fgZby#CApJ8:l>0U', 'f16422882c0082cc' ),
    array( '9nJci0@/i_LoeJxL2S0-WTNH gbl&rC?bn$L~E[h%)YkS', 'b8c4873ffdaf0fac' ),
    array( 'R8f\'Is^}C\'}+jk2^/QA}Vm|{If"SAm\'t\'m{PbZO&bN2M:', '948738b38e532172' ),
    array( 'D,JvNIM<GJf.L:P:AEB0Ars|Cy_q-.-Q;XHi"v&IAmXn(', 'afd0b1e73ddced08' ),
    array( ')*JNL[p@OmcJNVW]d*y=Sc?JjhlYB\\aKf-z4hkT9Z9d*p', '1dfd3ac789532668' ),
    array( '=gUGarzF3F2|4k?qNjX[fmERC_.\\D8Nb!$*cw&*+M=(b*G', 'c7ce7d6de622765c' ),
    array( 'TX3.5y{[M?<[|`sKDtPNXHUcT#"\\e,%;e9I{4FWaes>cU2', 'f0fa521206e1c67b' ),
    array( '0y(aIa*~F_#H<iUB%;\\N7punS[cq@:%Q4-3]o=]7|`_:J5', 'a38fb64baf6368b4' ),
    array( ']PQ: h,uX_R=QrWWDkdWJUu(lsiM/5cme5)e~5\\Wu/uH#M', '885465855ee39187' ),
    array( ' G:e d;vm)kWWzm;hSPr:P)v)~\'~G*LHQf.RLJI:S5r,1`', 'de1bd4eebc876571' ),
    array( 'Gz5xmPIvGRvNQ>Y~f+fu^4@)Ot>B!P$HK:B:jk13?(bqG<p', '5fce9e2beab28428' ),
    array( '/HX%\'lF0<;O_< ceL~(fitx}4"`&I|wYFP_M=&^YA.:^/}E', 'babb5873a7b954a2' ),
    array( '[}MCgC<eW>G^hEVCk\'#:E)y K):+89Pt7~8 BTfzs.Y\\T0 ', 'a4dcad2a3d27a8c5' ),
    array( '@8#[^-U_Y^ydw45lL5%LXZ3SNB.,v?,8X0t7>Jvw*q\\"\'rn', '5fce337a1b15535d' ),
    array( 'S)t aO46}VD*Nd7g=H\\Uf\'M^2?;4F/$y8xzzH/1GfVR5;j}', 'd650a004f4a4a934' ),
    array( 'X3Z.yb[Xt{t*C$.>=\'98PHJx0!KF<6DuI~%Dba|X^rb"wp@5', '26f61f52e18a413f' ),
    array( 'xYNI#xB4ynZ7& .P 3tbtr;Te}V^nwshRC2V<Uj7DFOKF]{F', '955141b7150fa2c1' ),
    array( 'pp)fcE;JCr)3j}{=A/s^d^v*%FUL$QrtC|\\(BwRfk\\yVZvs|', '26761cf7ed795ba8' ),
    array( '\'h\\kGSvMzLy~~ltBiQJ-J}s6Znl6ea4lJqYrFPAA};@})5@s', '7e915de5eb615078' ),
    array( 'fk"2juHFd6\\Jxq8Ddr7+CYLBul@ #atjMv|8lF^Q]<|V/6zs', '7313e5cd61f71972' ),
    array( ')3~MmKoc91c<rX\'AO%Z<K9n)Vl`f#\\Z,oZY^\'JB@[&]O_ep/j', 'b8b744c7e5836f88' ),
    array( 'KL7e;A=)"$,^^9O9s.A>QazW@J7&<Gqgs*N0Kk:NoF.O_^iSl', '71567bade5dcc22e' ),
    array( '+r?lnv.:/4VW\'?L1m]]Yw,I>;x~ycSgnG\'\\6~jP/ \'f\'G395q', 'b52ab992b89a25eb' ),
    array( 'wni%9(@3(:v["e#*B:)-j8-r 5:4OO&G?oLXxll!(c]*Ja4l{', '05178f3f6d1bd723' ),
    array( '>zgV)ZW?tknEq6dbb>[P+]Xo<c:}x(z7$bn-=FL33;Y&R>h6]', '2d02887219c5f7ba' ),
    array( 'Efi$@Y@$s?||:4!}$/<J[O]w)cKHMa&rIpwiJ8n?Xk<s!>q%M.', '7402cada54c164fc' ),
    array( 'P*^."grN1A085Z)-DSF3s~ 0r!Nd\'{sW&Rf);ZWL{hd2Cn?hBf', '7d506df1306b7bd3' ),
    array( '|6e|GY~v?\'s3^zeE%"!\\N|F40j#OSE7Q\\|N%VN{vUo*5jpZor\\', '2f6a27e5596405bc' ),
    array( 'MBYtVj_Y:4 Qe]O5b\'d_};O)P;y,,mhZ0COf.0AIEB{, KBcS\'', '584088c026129ecb' ),
    array( 'CRCr[s/V ;EivU-F=;W_e|"a*".LeaT*5w|pk-HlImW@Ddga!?', '52d26109c3976242' ),
    array( 'Bf=DIGGWt.:I8OA6@.ChzmWR.{8v^:7!!TEJ|m#q{=;5l]K.kow', '0664b26c38a5d953' ),
    array( 'g]O;lKSc*mz+oPQ;N@>A<[]RI;}W\'mOnL *9K^}VLxb=J4XyTw;', '614bf3c3f15ec6d4' ),
    array( 'qTxD}4CV;2\'+^\'5xStv*Apl_<"96W1QIeKnd`3;|EC(%J>~~3u)', '75c7984cbfee5c09' ),
    array( 'Ugv5$xN;P`mzF9j,y}HvDk I7>H6Q??((6=-0lH`M7\\tPG!KFIC', '08249b54b4e80e4a' ),
    array( 'j6C5Mb^d5~%=\'<[5LH].vtkkF3mrZ86FNZ[|=;bR:gpB$LWQu6`', 'd86b2b1dc38a51fe' ),
    array( 'l,LYR_GF;_\\a/8=-VYo*sXz7\\Hn/>%o+1<ed|-+8mhy}!8+Wq{ae', 'de82683d6c863f8e' ),
    array( 'T]}2&lADr2P$N6iKDud3^^1`w=9i:{PoYN"`;D%/VV4&m}R3s7FS', '1585883d76b8ad21' ),
    array( 'vX4nvNX1J)"%X$etIk$!C8\'27YE+pl_hFtW=C0On:QtrV[g Hk!k', '0fcab3a55bc257eb' ),
    array( '%)}<bDHT1(=W|uuA&F1@x&4Oa{P*hRvm[u*?;RtM[3&Y){z0C-Q<', 'f8b622573f260ed6' ),
    array( '3ekub=!Kox9LnDl+waXSu^.~[*/~7`<JG(A*EBU6;ob+4O6-2oa(', '9cfe1752ba2120c5' ),
    array( 'Oo(+y8+1yG\\AP}KvA"-\\qph\'A 5Tov]@geKa}Wsw Q:PPfHqhVO[H', 'bbfbf47f5e41f626' ),
    array( '9ci9x?*o|JXbv:aN/ZO`u!2\\I$E T"Hme3(^R2OO\\(3TCu$SQS4GT', '0fd77de0e48a299e' ),
    array( 'G$}LJ~!LHo2[wq/*A^gJr<niAB;tWbJ~fIK1HL]p<pM5b\\?%<(P0E', 'ff59a87c858ded0c' ),
    array( '?yfa5[9w&8_Pdqx2OjOA8d$u%*2-ZBSy<:[RvuK}/+Ns|G&M3VnL;', 'c15664e583440709' ),
    array( 'sB@}TNXw"R5=/g4%424?`)=)/j<fZh"N,CLar&YtXo3gXGmlY#,:,', 'ed2cece5fae7e40a' ),
    array( 'JD;6`"pJ%@VIm9<sr2McE6<l$)G\'6b3`\'OvgRh3X)j"v$>kwP9[vOw', 'af6317fd2ec74937' ),
    array( 'cS!+[7nnxu?o^qXqJb\\LZakFY=_54/.xc/%?Gs/@iN1H@j;kNw9)Z%', '176ecfc36ff0fb5e' ),
    array( 'O4B0JW@XP$hUC1IRR4"d\\BOw/~pH(KMX`ph,H)ex-OOQ`x%4.\'xkJI', '2e7bda1a61ef9b56' ),
    array( 'cYHU#Q"P*bBroj|Uc+%4]f-c{<jt(6?lphBs:DEE(g9wR6N7ASK ;Y', '3d2b93b2479f85fc' ),
    array( 'c7vO-~eMkW7.LRSqw\\Z1U.H$EjXqjtLN,C}:Bcg/<~>hQq[JO6[%D$', '62a5e1665612c6c0' ),
    array( '*jnc]YX*)eN\' qjh!(g?p:2LdacAf)Fqt6URp.]yt-!t~l] tF@faR4', '547b12c39bb0fdf3' ),
    array( 'G4wh{"0mvFCI7R(1G53=4 {5tBV\\%)pL>h6:jF)blM,% 57HJJe_Jau', 'c22639e2811d6816' ),
    array( '@%L|*VnWtWm0C49\'"f4\'fI>0tiuU4XKU]xShOB@Ez.U?CnFFUZM=%lM', '37b9a926337766d3' ),
    array( 'yVDOk|{BZtuDE9dj4s@S80z^fV-%[zRUQw&>t"`PwWt=pZ)%NJYgZUF', 'cc6ba46fb041513c' ),
    array( 'B,TGgOz>"rD@gG"9?Y/]JigP92+!m`H0m|XUMStOF9o/`qH!KX^vBFG', 'a4c997dd620f2ff9' ),
    array( '\\YS^H4(Y"&2XSeM#,gs<HeeJ2>**aQR>+&|S;%-=,?v_&Db2-VNV=4!P', 'a07bd8ec425f5a4f' ),
    array( 'S+[5\\.Sh4Q=PWKnckeCq+\'%8^Tn|hpM={)RY8\'CMX`}1,luxR:j^Aov!', '84b7e4acb0c0a79a' ),
    array( 'Df}.WLKTV~/o&R=^3;p@)f9[!%;Cu2E:yCIRpu\'Ht68ziVZ|qL>z3WW5', 'e0f646c8b28fd049' ),
    array( ']rYS&~n!C8S5/[]%rv!\\M[Z@)x<<QtR/h,bo+QpNjEcz!B s:!Qg],)f', '05032e744464292c' ),
    array( '&E$W:Vf$cJsn{d>g+#b,Fb!`dSIB_R*ex/=4e%8JO,9LqX4|\\v*#Z+d?', 'd416e24b2f0208f8' ),
    array( '^.b?`m&Z|DncI(.y4HG\'"[%^S/b/;GOzU3:7!Ar~eac0iq*~;Q\'=.,|b;', '3927892869e71809' ),
    array( '_qW(AR^UmvV/iVtL:&7-06Hb>fqJdTfEG>Miq,?_#vomMe:hkQu|h?_\'\'', '6642fa162be3f787' ),
    array( 'RQk\'91OW^9IkX*oOz]}`xfLJ]I3}*;%]mpd\'"5^aN)M(4>X/{Vpu>=@|g', 'bc2d4f3aa4d38015' ),
    array( 'Tzro P]q6esKDVzN%#cC[r@3c6R"WOj,K]|K/[=EA2qfil5npy3LlT_Qj', 'f8e6d9128469532b' ),
    array( '2SCb?P.|MZ-*xSK,E3u3He$BxQ0N1b9D6]\'U.6S[p`fi52uZElnnRs2LE', '7277ce5e05c03037' ),
    array( 'CzW&5{=r$s!;H],*Dv?Wmz}Zim-] Z$DU[KjXh]\\\\_w&>%0b{O;iJ9E5\'S', 'f52c0085314b0fd8' ),
    array( 'r(.wMcSxN,a-i?maF,gVnd&+NQDtfLHZUVR#:&|i3_v| e_FqG|`,$k[U1', '69e03fdc5e6ef8b3' ),
    array( 'P=^xx4PK8jR6TeuLcu2C<%j9ew>RStd%2D}+YNWr:+)oq~=UtPx1UdK<\\i', 'ad82f3fd37f369cc' ),
    array( 'o0^U5qy4|ScUF~`OnRN-)D]"V3g"PDl@ULuk>o <DdrjcS;S\'j`1/>3eR{', 'a0a8ea76841101cb' ),
    array( 'h#@VDv#;bB,c_PHR<-\'W`/BA@R`T83P"7pX\\h\\wK~$/_TX2qe:IGIlhi?I', 'cc3c875a245445bb' ),
    array( '>X]n[t`4QIqJuqN%Q$^cuD}@kH.U2M Q\']@bS"w&KiPA[~G.$&rzKq<8:Jn', '36b37774404085a2' ),
    array( 'Mxn~ M?c!B[\'mFX0#XX1\\_%W,vtD2?4_8#^9P}|RAYZ0!3@$ky6HY<!f3u,', '6953f8802999c26d' ),
    array( 'E6@%NDdhtceH%@#5A6VF"P]K+yMq.D}TZ?Z*c?rX#Y"(z%==;sc>EBjP=9C', 'a93c088a44fbfc35' ),
    array( 'L]B!9a\\DE{8~ r!)m\'G+C;oaa3M3QfV}Ex _[\\%"Y>!Z1#c *+,MG|0)0^<', '4c23bc673f998d50' ),
    array( 'bEs`kmaLI?RKxpMT"P8#[D/)k,:u=x2!?&a,tDX>c+j]|82~iK"Eo2O\\?iR', '68fc83d0d7fbfe26' ),
    array( '\\ce]$k@0aei Iuk\'r$:qnet4V(d3GOf%3Lb79$Gzi2{4(g<zkWm[>cotkU)3', '1154a4047a591047' ),
    array( '%o88={PV!xQk+M 35=/"t}]3aN(M$2a)"zB?vrvxkHdwvd,-#<0w:n+{=4JB', '4241c775b22008a8' ),
    array( 'F-LI(oi b`xO*]H"CT0Fp@>,/J)M^Sp&a>Oi.:iq{bB\'@j)d@9+2ZJ>itG8T', 'd8a203d84a6e0ad0' ),
    array( '{)[]G+GVF2HBtjI6USzvm\')HRG2HnK|kTXI|dqS,${Nygx0>M,5;4>cffv/V', '71228d8490cbb004' ),
    array( 'B-BwfkuK]IXbF\'\\/!mMNybi/"NuhE&@g3b`yOVF.! pH(MW);&X6iCEkq<U7', 'f772a9177eddfcf8' ),
);

$i = 0;
$pass = true;
foreach($tests as $test) {
    $result = hash('fnv1a64', $test[0]);
    if ($result != $test[1]) {
        echo "Iteration " . $i . " failed - expected '" . $test[1] . "', got '" . $result . "' for '" . $test[1] . "'\n";
    $pass = false;
    }
    $i++;
}

if($pass) {
    echo "PASS";
}
?>
--EXPECT--
PASS
