package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// SubscriptionClient is the client for the Subscription methods of the Batch
// service.
type SubscriptionClient struct {
	ManagementClient
}

// NewSubscriptionClient creates an instance of the SubscriptionClient client.
func NewSubscriptionClient(subscriptionID string) SubscriptionClient {
	return NewSubscriptionClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSubscriptionClientWithBaseURI creates an instance of the
// SubscriptionClient client.
func NewSubscriptionClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionClient {
	return SubscriptionClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetSubscriptionQuotas gets the Batch service quotas for the specified
// suscription.
//
// locationName is the desired region for the quotas.
func (client SubscriptionClient) GetSubscriptionQuotas(locationName string) (result SubscriptionQuotasGetResult, err error) {
	req, err := client.GetSubscriptionQuotasPreparer(locationName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batch.SubscriptionClient", "GetSubscriptionQuotas", nil, "Failure preparing request")
	}

	resp, err := client.GetSubscriptionQuotasSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batch.SubscriptionClient", "GetSubscriptionQuotas", resp, "Failure sending request")
	}

	result, err = client.GetSubscriptionQuotasResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.SubscriptionClient", "GetSubscriptionQuotas", resp, "Failure responding to request")
	}

	return
}

// GetSubscriptionQuotasPreparer prepares the GetSubscriptionQuotas request.
func (client SubscriptionClient) GetSubscriptionQuotasPreparer(locationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSubscriptionQuotasSender sends the GetSubscriptionQuotas request. The method will close the
// http.Response Body if it receives an error.
func (client SubscriptionClient) GetSubscriptionQuotasSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSubscriptionQuotasResponder handles the response to the GetSubscriptionQuotas request. The method always
// closes the http.Response Body.
func (client SubscriptionClient) GetSubscriptionQuotasResponder(resp *http.Response) (result SubscriptionQuotasGetResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
